/* $Id: TransformSigAssign.cpp 4676 2009-09-17 16:21:07Z potyra $
 *
 * Transform concurrent signal assignment statements into equivalent
 * processes.
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <cassert>
#include "frontend/visitor/TransformSigAssign.hpp"
#include "frontend/ast/Architecture.hpp"
#include "frontend/ast/CondalSigAssign.hpp"
#include "frontend/ast/SigAssignStat.hpp"
#include "frontend/ast/Process.hpp"
#include "frontend/ast/WaitStat.hpp"
#include "frontend/ast/Process.hpp"
#include "frontend/ast/NodeFactory.hpp"

namespace ast {

void
TransformSigAssign::visit(Architecture &node)
{
	if (node.concurrentStats == NULL) {
		return;
	}

	this->workList = node.concurrentStats;
	this->listTraverse(*node.concurrentStats, this->deleteFlag);
	this->workList = NULL;
}

void
TransformSigAssign::visit(CondalSigAssign &node)
{
	assert(this->workList != NULL);
	assert(node.assignStat != NULL);

	this->pickupSignals = true;
	node.assignStat->accept(*this);

	// generate proces...
	std::list<Name *> *sl = new std::list<Name *>();
	sl->insert(sl->end(), this->sensitivities.begin(), 
		this->sensitivities.end());
	WaitStat *ws = new WaitStat(
				sl,
				NULL,
				NULL,
				node.location);

	std::list<SeqStat*> *transformed = new std::list<SeqStat*>();
	transformed->push_back(node.assignStat);
	transformed->push_back(ws);

	Process *p = new Process(NULL, 
				new std::list<SymbolDeclaration*>(), 
				transformed, 
				node.location);
	// FIXME name!


	this->workList->push_front(p);
	this->sensitivities.clear();

	this->pickupSignals = false;
	this->deleteFlag = true;
}


void
TransformSigAssign::visit(SigAssignStat &node)
{
	// don't traverse to target, that's already set.
	if (node.waveForm == NULL) {
		return;
	}

	// pick up any signal in the waveForm so that it can be 
	// added to the sensitivity set. (anything apart from a time
	// expression)
	this->listTraverse(*node.waveForm);
}

void
TransformSigAssign::visit(WaveFormElem &node)
{
	if (node.value != NULL) {
		node.value->accept(*this);
	}
}

void
TransformSigAssign::visit(SimpleName &node)
{
	if (! this->pickupSignals) {
		return;
	}

	if (! node.isSignal()) {
		return;
	}


	if (! util::MiscUtil::listContainsObj(this->sensitivities, &node)) {
		this->sensitivities.push_back(&node);
	}
}

}; /* namespace ast */
