/* $Id: Operand.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/operands/Operand.hpp"

namespace intermediate {

std::ostream&
operator <<(std::ostream& stream, const enum OpType t)
{
	switch(t) {
	case OP_TYPE_INTEGER:
		stream << 'i';
		break;
	case OP_TYPE_REAL:
		stream << 'r';
		break;
	case OP_TYPE_POINTER:
		stream << 'p';
		break;
	}

	return stream;
}

}; /* namespace intermediate */
