/*
 * rtpstream.h - Headers for RTP plugin stream implementation
 *
 * Farsight Voice+Video library
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>.
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_STREAM_H__
#define __FARSIGHT_RTP_STREAM_H__

#include "farsight-stream.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_RTP_STREAM \
  (farsight_rtp_stream_get_type())
#define FARSIGHT_RTP_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStream))
#define FARSIGHT_RTP_STREAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStreamClass))
#define FARSIGHT_IS_RTP_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_RTP_STREAM))
#define FARSIGHT_IS_RTP_STREAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_RTP_STREAM))
#define FARSIGHT_RTP_STREAM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_RTP_STREAM, FarsightRTPStreamClass))

typedef struct _FarsightRTPStreamClass FarsightRTPStreamClass;
typedef struct _FarsightRTPStreamPrivate FarsightRTPStreamPrivate;

struct _FarsightRTPStreamClass
{
  FarsightStreamClass parent_class;
};

struct _FarsightRTPStream
{
  FarsightStream parent;

  FarsightRTPStreamPrivate *priv;
};

void farsight_rtp_stream_register_type(GTypeModule *module);

GType farsight_rtp_stream_get_type (void);

G_END_DECLS

#endif
