{
  Gestion LinEx FacturLinEx 2.0

  Copyright (C) 2000-2011

  Nicolas Lopez de Lerma Aymerich <nicolas@esdebian.org>

  Collaborators:
                 Antonio Domínguez Santos (adslinex)
                 Xaime Alvarez Ares
                 Elmo Calatayud Chumbes
                 Fco. Javier Perez Vidal
                 José Belenguer
                 Eduardo Maldonado
                 David Gámiz Jiménez
                 Juan Manuel Martínez Gámiz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

Unit Menu;

{$mode Objfpc}{$H+}

Interface

Uses
  Classes, Sysutils, Lresources, Forms, Controls, Graphics, Dialogs, ComCtrls,
  Buttons, Inifiles, ZConnection, ZDataset, StdCtrls, ExtCtrls, Process, db,
  LCLType, DBGrids, Menus, LR_Class;
Type
   RServidorBD = record
      nombre: string[15];       // Lo que muestra el ComboBox
      soportado: boolean;       // En la actualidad ¿Esta soportado por facturlinex2?
      // Aquí podíamos añadir algún campo si fuera necesario, protocolos, parametros
   end;

  { TFMenu }

  TFMenu = Class(Tform)
    BitBtn10: TBitBtn;
    BitBtn11: TBitBtn;
    BitBtn12: TBitBtn;
    BitBtn13: TBitBtn;
    BitBtn14: TBitBtn;
    BitBtn15: TBitBtn;
    BitBtn16: TBitBtn;
    BitBtn17: TBitBtn;
    BitBtn18: TBitBtn;
    BitBtn19: TBitBtn;
    BitBtn20: TBitBtn;
    BitBtn21: TBitBtn;
    BitBtn22: TBitBtn;
    BitBtn23: TBitBtn;
    BitBtn24: TBitBtn;
    BitBtn25: TBitBtn;
    BitBtn26: TBitBtn;
    BitBtn27: TBitBtn;
    BitBtn28: TBitBtn;
    BitBtn29: TBitBtn;
    BitBtn30: TBitBtn;
    BitBtn31: TBitBtn;
    BitBtn32: TBitBtn;
    BitBtn33: TBitBtn;
    BitBtn34: TBitBtn;
    BitBtn35: TBitBtn;
    BitBtn36: TBitBtn;
    BitBtn37: TBitBtn;
    BitBtn40: TBitBtn;
    BitBtn44: TBitBtn;
    BitBtn45: TBitBtn;
    BitBtn46: TBitBtn;
    BitBtn47: TBitBtn;
    BitBtn48: TBitBtn;
    BitBtn49: TBitBtn;
    BitBtn50: TBitBtn;
    BitBtn51: TBitBtn;
    BitBtn52: TBitBtn;
    BitBtn53: TBitBtn;
    BitBtn54: TBitBtn;
    BitBtn55: TBitBtn;
    BitBtn56: TBitBtn;
    BitBtn57: TBitBtn;
    BitBtn58: TBitBtn;
    BitBtn59: TBitBtn;
    BitBtnAbout: TBitBtn;
    BitBtnActuArti: TBitBtn;
    BitBtnActuEans: TBitBtn;
    BitBtnActuPedi: TBitBtn;
    BitBtnComun: TBitBtn;
    BitBtn38: TBitBtn;
    BitBtn39: TBitBtn;
    BitBtn41: TBitBtn;
    BitBtn42: TBitBtn;
    BitBtn43: TBitBtn;
    BitBtnEnviArti: TBitBtn;
    BitBtnEnviCli: TBitBtn;
    ComboServidoresBD: TComboBox;
    Datasource1: TDatasource;
    Datasource2: TDatasource;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    dbPedidos: TZQuery;
    dbLlamadas: TZQuery;
    dbUsuarios: TZQuery;
    dbRoles: TZQuery;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit21: TEdit;
    Edit22: TEdit;
    Edit23: TEdit;
    Edit24: TEdit;
    Edit25: TEdit;
    Edit26: TEdit;
    Edit27: TEdit;
    Edit3: TEdit;
    frReport1: TfrReport;
    Image1: TImage;
    ImagenLogo: TImage;
    ImageList1: TImageList;
    Label1: TLabel;
    Label2: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label3: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label4: TLabel;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    Pagecontrol1: Tpagecontrol;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    PopupMenu1: TPopupMenu;
    Shape1: TShape;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    LabelLlamada: TStaticText;
    Tabsheet1: Ttabsheet;
    Tabsheet2: Ttabsheet;
    Bitbtn1: Tbitbtn;
    Bitbtn2: Tbitbtn;
    Bitbtn3: Tbitbtn;
    Bitbtn4: Tbitbtn;
    Bitbtn5: Tbitbtn;
    Bitbtn6: Tbitbtn;
    Tabsheet3: Ttabsheet;
    Tabsheet4: Ttabsheet;
    Tabsheet5: Ttabsheet;
    Tabsheet6: Ttabsheet;
    Tabsheet7: Ttabsheet;
    Tabsheet8: Ttabsheet;
    Tabsheet9: Ttabsheet;
    Tabsheet10: Ttabsheet;
    Bitbtn7: Tbitbtn;
    Bitbtn8: Tbitbtn;
    dbConect: TZConnection;
    dbQuery: TZQuery;
    Bitbtn9: Tbitbtn;
    Timer1: TTimer;


    procedure ActualizaBBDD(Sender: TObject);
    procedure BitBtn10Click(Sender: TObject);
    procedure BitBtn11Click(Sender: TObject);
    procedure BitBtn12Click(Sender: TObject);
    procedure BitBtn13Click(Sender: TObject);
    procedure BitBtn14Click(Sender: TObject);
    procedure BitBtn15Click(Sender: TObject);
    procedure BitBtn16Click(Sender: TObject);
    procedure BitBtn17Click(Sender: TObject);
    procedure BitBtn18Click(Sender: TObject);
    procedure BitBtn19Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn20Click(Sender: TObject);
    procedure BitBtn21Click(Sender: TObject);
    procedure BitBtn22Click(Sender: TObject);
    procedure BitBtn23Click(Sender: TObject);
    procedure BitBtn24Click(Sender: TObject);
    procedure BitBtn25Click(Sender: TObject);
    procedure BitBtn26Click(Sender: TObject);
    procedure BitBtn27Click(Sender: TObject);
    procedure BitBtn28Click(Sender: TObject);
    procedure BitBtn29Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn30Click(Sender: TObject);
    procedure BitBtn31Click(Sender: TObject);
    procedure BitBtn32Click(Sender: TObject);
    procedure BitBtn33Click(Sender: TObject);
    procedure BitBtn34Click(Sender: TObject);
    procedure BitBtn35Click(Sender: TObject);
    procedure BitBtn36Click(Sender: TObject);
    procedure BitBtn37Click(Sender: TObject);
    procedure BitBtn44Click(Sender: TObject);
    procedure BitBtn45Click(Sender: TObject);
    procedure BitBtn46Click(Sender: TObject);
    procedure BitBtn47Click(Sender: TObject);
    procedure BitBtn48Click(Sender: TObject);
    procedure BitBtn49Click(Sender: TObject);
    procedure BitBtn52Click(Sender: TObject);
    procedure BitBtn53Click(Sender: TObject);
    procedure BitBtn54Click(Sender: TObject);
    procedure BitBtn55Click(Sender: TObject);
    procedure BitBtn56Click(Sender: TObject);
    procedure BitBtn57Click(Sender: TObject);
    procedure BitBtn58Click(Sender: TObject);
    procedure BitBtn59Click(Sender: TObject);
    procedure BitBtnActuArtiClick(Sender: TObject);
    procedure BitBtnActuPediClick(Sender: TObject);
    procedure BitBtnEnviArtiClick(Sender: TObject);
    procedure BitBtnEnviCliClick(Sender: TObject);
    procedure BitBtn38Click(Sender: TObject);
    procedure BitBtn39Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn40Click(Sender: TObject);
    procedure BitBtn41Click(Sender: TObject);
    procedure BitBtn42Click(Sender: TObject);
    procedure BitBtn43Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    Procedure Bitbtn8click(Sender: Tobject);
    Procedure Bitbtn5click(Sender: Tobject);
    procedure BitBtn9Click(Sender: TObject);
    procedure BitBtn50Click(Sender: TObject);
    procedure BitBtnActuEansClick(Sender: TObject);
    procedure BitBtnComunClick(Sender: TObject);
    procedure BitBtnAboutClick(Sender: TObject);
    procedure Edit26Enter(Sender: TObject);
    procedure Edit26Exit(Sender: TObject);
    procedure Edit26KeyPress(Sender: TObject; var Key: char);
    procedure Edit27KeyPress(Sender: TObject; var Key: char);
    Procedure Formclose(Sender: Tobject; Var Closeaction: Tcloseaction);
    Procedure Formcreate(Sender: Tobject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure frReport1GetValue(const ParName: String; var ParValue: Variant);
    Procedure Iniciar();
    Procedure Bitbtn7click(Sender: Tobject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure CargaIconos();
    procedure ActualizamosPromociones();
    procedure Timer1Timer(Sender: TObject);

  Private
    { Private Declarations }
  Public
    { Public Declarations }
    IniReader : TIniFile;
    Sections : TStringList;
//    Contents : TStringList;//quitado por javi no se usa
  End;

Var
  FMenu: TFMenu;
  Lee, Empresa, Direccion, Localidad, Nif, Tienda, Puesto: String;
  NTienda: Integer;
  ServidoresBD: array [0..26] of RServidorBD;
  IconoLlamadas, IconoPedidos: String;
  FechaEntrada: String;
  
Implementation

uses
   Global, Tiendas, Clientes, Articulos, listatiendas, Factura, config, Ventas,
   Proveedores, Familias, Usuarios, Departamentos, FormaPago, Rutas, Fabricantes,
   Envases, listausuarios, Albaran, historicoop, gestionar, listaarticulos,
   listaclientes, listafamilias, ivaEmi, ivaReci, listaproveedores, acaja,
   listadepartamentos, actualizaarti, Creditos, entrada, Puestos, listapuestos,
   facturar, lineales, histopedi, Presupuestos, Funciones, actualizaeans,
   enviopedidos, Produccion, about, HistoAlba, FAStock, EtiEans, EtiLineales,
   CopiaSeg, ActAutArt, unirpedido, generarped, actualizapedi, envioclientes,
   envioarti, roles, promociones, facturaped, histofaprov, copiasegauto;
   
{ TFMenu }

//===================== CREAR APLICACION ==============
Procedure Tfmenu.Formcreate(Sender: Tobject);
var
  cont: integer;
Begin
   // Cargando valores en el ComboBox
   ServidoresBD[0].nombre:='ASA7';ServidoresBD[0].soportado:=FALSE;
   ServidoresBD[1].nombre:='ASA8';ServidoresBD[1].soportado:=FALSE;
   ServidoresBD[2].nombre:='ASA9';ServidoresBD[2].soportado:=FALSE;
   ServidoresBD[3].nombre:='firebird-1.0';ServidoresBD[3].soportado:=FALSE;
   ServidoresBD[4].nombre:='firebird-1.5';ServidoresBD[4].soportado:=FALSE;
   ServidoresBD[5].nombre:='firebird-2.0';ServidoresBD[5].soportado:=FALSE;
   ServidoresBD[6].nombre:='firebirdd-1.5';ServidoresBD[6].soportado:=FALSE;
   ServidoresBD[7].nombre:='firebirdd-2.0';ServidoresBD[7].soportado:=FALSE;
   ServidoresBD[8].nombre:='interbase-5';ServidoresBD[8].soportado:=FALSE;
   ServidoresBD[9].nombre:='interbase-6';ServidoresBD[9].soportado:=FALSE;
   ServidoresBD[10].nombre:='mssql';ServidoresBD[10].soportado:=FALSE;
   ServidoresBD[11].nombre:='mysql';ServidoresBD[11].soportado:=TRUE;
   ServidoresBD[12].nombre:='mysql-4.1';ServidoresBD[12].soportado:=TRUE;
   ServidoresBD[13].nombre:='mysql-5';ServidoresBD[13].soportado:=TRUE; // Si hay más ¿?
   ServidoresBD[14].nombre:='mysqld-4.1';ServidoresBD[14].soportado:=TRUE;
   ServidoresBD[15].nombre:='mysqld-5';ServidoresBD[15].soportado:=TRUE;
   ServidoresBD[16].nombre:='oracle';ServidoresBD[16].soportado:=FALSE;
   ServidoresBD[17].nombre:='oracle-9i';ServidoresBD[17].soportado:=FALSE;
   ServidoresBD[18].nombre:='postgresql';ServidoresBD[18].soportado:=FALSE;
   ServidoresBD[19].nombre:='postgresql-7';ServidoresBD[19].soportado:=FALSE;
   ServidoresBD[20].nombre:='postgresql-8';ServidoresBD[20].soportado:=FALSE;
   ServidoresBD[21].nombre:='sqlite';ServidoresBD[21].soportado:=FALSE;
   ServidoresBD[22].nombre:='sqlite-2.8';ServidoresBD[22].soportado:=FALSE;
   ServidoresBD[23].nombre:='sqlite-3';ServidoresBD[23].soportado:=FALSE;
   ServidoresBD[24].nombre:='sybase';ServidoresBD[24].soportado:=FALSE;
   //ServidoresBD[25].nombre:='';ServidoresBD[25].soportado:=FALSE;

  ComboServidoresBD.Clear;ComboServidoresBD.Text:='';
  cont:=0;
  While ServidoresBD[cont].nombre <> '' do
  begin
    ComboServidoresBD.Items.Add(ServidoresBD[cont].nombre);
    cont:=cont+1;
  end;

   ShortDateFormat:='DD/MM/YYYY';
  {$IFDEF LINUX}
     DecimalSeparator:='.';

     Lee:=GetEnvironmentVariable('HOME')+'/.facturlinex2/';

{     // Comprobamos si la aplicación es para desarrollo o en producción.
     if ExtractFilePath(ParamStr(0))='/usr/bin/' then
                Lee:=GetEnvironmentVariable('HOME')+'/.facturlinex2/' else
                Lee:=ExtractFilePath(ParamStr(0));
}
    // Showmessage(lee);
    //----------------- Carga de la variable AbrirAchivo
    //Descubrir que escritorio está utilizando el usuario
    if AbrirAchivo = '' then AbrirAchivo:=GetEnvironmentVariable('DESKTOP_SESSION')+'-open';

  {$ELSE}
     Lee:=ExtractFilePath(ParamStr(0));
     DecimalSeparator:='.';
     if AbrirAchivo= '' then AbrirAchivo:= 'explorer.exe';
  {$ENDIF}
  if not FileExists(Lee+'FacturConf.ini') then
    begin
     //------------- Linex / Debian / Ubuntu -------------
     if (FileExists('/etc/debian_version')) or (FileExists('/etc/ubuntu_version')) then
       begin
         if FileExists('/usr/lib/libmysqlclient.so.10.0.0') then ComboServidoresBD.Text:='mysql';
         if FileExists('/usr/lib/libmysqlclient.so.12.0.0') then ComboServidoresBD.Text:='mysql';
         if FileExists('/usr/lib/libmysqlclient.so.14.0.0') then ComboServidoresBD.Text:='mysql-4.1';
         if FileExists('/usr/lib/libmysqlclient.so.15.0.0') then ComboServidoresBD.Text:='mysql-5';
         if FileExists('/usr/lib/libmysqlclient.so.16.0.0') then ComboServidoresBD.Text:='mysql-5';
       end;
     //------------- Red-Hat / Fedora -----------
     if FileExists('/etc/redhat-release') then
       begin
         if FileExists('/usr/lib/mysql/libmysqlclient.so.10.0.0') then ComboServidoresBD.Text:='mysql';
         if FileExists('/usr/lib/mysql/libmysqlclient.so.12.0.0') then ComboServidoresBD.Text:='mysql';
         if FileExists('/usr/lib/mysql/libmysqlclient.so.14.0.0') then ComboServidoresBD.Text:='mysql-4.1';
         if FileExists('/usr/lib/mysql/libmysqlclient.so.15.0.0') then ComboServidoresBD.Text:='mysql-5';
         if FileExists('/usr/lib/mysql/libmysqlclient.so.16.0.0') then ComboServidoresBD.Text:='mysql-5';
       end;
     Pagecontrol1.Enabled:=False;
     Panel1.Visible:=True; Panel1.Enabled:=True;
     //Edit21.SetFocus;
     Exit;
    end;



  Iniciar();
End;

//===================== INICIAR APLICACION ====================
Procedure Tfmenu.Iniciar();
var
  cont: Integer;
begin

  FechaEntrada:= FormatDateTime('DD/MM/YYYY',Date);  // guardamos fecha de entrada a la aplicación.

//  OpenDialog1.FileName:=Lee+'FacturConf.ini';     // cambiado por javi para quitar el opendialog1
//  IniReader := TIniFile.Create(OpenDialog1.FileName); // cambiado por javi para quitar el opendialog1
  IniReader := TIniFile.Create(Lee+'FacturConf.ini'); //añadido por javi para quitaron opendialog
  Sections := TStringList.Create;
//  Contents := TStringList.Create; //quitado por javi no se usa
  IniReader.ReadSections( Sections );
  Empresa:=IniReader.ReadString('datos','nombre','');
  Direccion:=IniReader.ReadString('datos','direccion','');
  Localidad:=IniReader.ReadString('datos','cp','')+' - '+IniReader.ReadString('datos','poblacion','');
  Nif:=IniReader.ReadString('datos','CIF','');
  Tienda:=IniReader.ReadString('tienda','codigo','');
  if Tienda<>'' then NTienda:=StrToInt(Tienda) else NTienda:=0;
  Puesto:=IniReader.ReadString('tienda','puesto','');
  ColorFondo:=IniReader.ReadString('datos','ColorFondo','');
  ColorBotones:=IniReader.ReadString('datos','ColorBotones','');
  //----------------- Conexion -----------------
  if IniReader.ReadString('BBDD','host','')<>'' then
   begin
    dbConect.HostName:=IniReader.ReadString('BBDD','host','');
    dbConect.Database:=IniReader.ReadString('BBDD','database','');
    dbConect.User:=IniReader.ReadString('BBDD','usuario','');
    dbConect.Password:=IniReader.ReadString('BBDD','passwd','');
    dbConect.Port:=StrToInt(IniReader.ReadString('BBDD','puerto',''));
    dbConect.Protocol:=IniReader.ReadString('BBDD','protocolo','');
    dbConect.Connected:=True;

   end;
  //----------------- Pedidos pendientes ----------
  dbPedidos.Active:=False;
  dbPedidos.SQL.Text:='SELECT * FROM pedicc'+Tienda+' ORDER BY PC1 ASC';
  dbPedidos.Active:=True;

  //----------------- Llamadas pendientes ----------
  dbLlamadas.Active:=False;
  dbLlamadas.SQL.Text:='SELECT * FROM llamadas'+Tienda+' ORDER BY Fechallama ASC';
  dbLlamadas.Active:=True;
  //----------------- Botones de aviso de llamadas/pedidos pendientes ---------
  IconoLlamadas:='LlamadaNo.png';
  IconoPedidos:='PedidoNo.png';

  //timer1.Enabled:=True;
  CargaIconos();
  //----------------- Colores del formulario y botones ------------------------
  if ColorFondo<>'' then Color:=StringToColor(ColorFondo);
    cont:=0;
  if ColorBotones<>'' then
    begin
     for cont:=0 to ComponentCount-1 do
       begin
        if (Components[cont] is TBitBtn) then
          TBitBtn(FindComponent(Components[cont].Name)).color:=StringToColor(ColorBotones);
       end;
    end;
  Timer1.Enabled:=True;
  //-------------------------- Controlar claves de acceso y Usuario activo ---------------------
   if CgClaves='S' then
      begin
        SpeedButton1.Enabled:=False; SpeedButton2.Enabled:=False;
        PageControl1.Enabled:=False;
        Panel6.Visible:=True;
        Exit;
      end else
      begin
         dbUsuarios.SQL.Text:='SELECT * FROM usuarios'+Tienda;
         dbUsuarios.Active:=True;
         if dbUsuarios.RecordCount<> 0 then UsuarioActivo:= dbUsuarios.FieldByName('USU9').AsString
                                       else UsuarioActivo:='';
      end;
end;

procedure TFMenu.ActualizamosPromociones();
begin
  //---------------------- Revisamos las promociones -------------------
   fPromociones:=TfPromociones.Create(Application);    // Creamos el formulario para acceder a su contenido
   fPromociones.WindowState:=wsMinimized;
   fPromociones.Show;
   fPromociones.ActualizarPromociones();
   fPromociones.Free;
end;

//===========================================================
//========================= VENTAS ==========================
//===========================================================
//--------------------------- VENTAS ----------------------
procedure TFMenu.BitBtn1Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormVentas();
  Timer1Timer(nil);
end;
//-------------------------- CREDITOS ----------------------
procedure TFMenu.BitBtn38Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormCreditos('');
  Timer1Timer(nil);
end;

//--------------------------- CAJAS ----------------------
procedure TFMenu.BitBtn2Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormCaja();
  Timer1Timer(nil);
end;
//--------------------------- ALBARANES ---------------------
procedure TFMenu.BitBtn3Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormAlbaranes();
  Timer1Timer(nil);
end;

//--------------------------- FACTURAS ----------------------
procedure Tfmenu.Bitbtn5click(Sender: Tobject);
begin
  timer1.enabled:=false;
  ShowFormFacturas();
  Timer1Timer(nil);
end;

//--------------------------- FACTURAR ----------------------
procedure TFMenu.BitBtn6Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormFacturar();
  Timer1Timer(nil);
end;

//-------------------------- PRESUPUESTOS ----------------------
procedure TFMenu.BitBtn4Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormPresupuestos('PRESUPUESTO');
  Timer1Timer(nil);
end;

//--------------------------- PROFORMAS ----------------------
procedure TFMenu.BitBtn43Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormPresupuestos('PROFORMA');
  Timer1Timer(nil);
end;


//===========================================================
//======================= ARCHIVOS ==========================
//===========================================================
//--------------------------- TIENDAS -----------------------
Procedure Tfmenu.Bitbtn7click(Sender: Tobject);
Begin
  timer1.enabled:=false;
  ShowFormTiendas();
  Timer1Timer(nil);
end;
//--------------------------- USUARIOS -----------------------
procedure TFMenu.BitBtn12Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormUsuarios();
  Timer1Timer(nil);
end;
//---------------------- DEPARTAMENTOS -----------------------
procedure TFMenu.BitBtn16Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormDepartamentos();
  Timer1Timer(nil);
end;

//-------------------------- FAMILIAS -----------------------
procedure TFMenu.BitBtn15Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormFamilias();
  Timer1Timer(nil);
end;
//------------------------- ARTICULOS -----------------------
procedure TFMenu.BitBtn11Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormArticulos();
  Timer1Timer(nil);
end;
//-------------------------- CLIENTES -----------------------
procedure TFMenu.BitBtn10Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormClientes();
  Timer1Timer(nil);
end;

//----------------------- PROVEEDORES -----------------------
procedure TFMenu.BitBtn14Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormProveedores();
  Timer1Timer(nil);
end;

//------------------------ VARIOS -------------------------
procedure TFMenu.BitBtn17Click(Sender: TObject);
begin
  Panel2.Visible:=True; Pagecontrol1.Enabled:=False;
end;

//-------------------- CERRAR VARIOS ----------------------
procedure TFMenu.BitBtn20Click(Sender: TObject);
begin
  Panel2.Visible:=False; PageControl1.Enabled:=True;
end;
//------------------ FORMAS DE PAGO / COBRO ---------------
procedure TFMenu.BitBtn21Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormFormaPago();
  Timer1Timer(nil);
end;
//------------------ RUTAS DISTINTIVOS ---------------
procedure TFMenu.BitBtn22Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormRutas();
  Timer1Timer(nil);
end;
//------------------- FABRICANTES --------------------
procedure TFMenu.BitBtn23Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormFabricantes();
  Timer1Timer(nil);
end;
//------------------- ENVASES --------------------
procedure TFMenu.BitBtn24Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormEnvases();
  Timer1Timer(nil);
end;
//------------------- PUESTOS DE VENTAS --------------------
procedure TFMenu.BitBtn42Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormPuestos();
  Timer1Timer(nil);
end;
//-------------------- PRODUCCION ----------------------
procedure TFMenu.BitBtn35Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormProduccion();
  Timer1Timer(nil);
end;


//===========================================================
//========================= LISTADOS ========================
//===========================================================
//-------------------  Listado de tiendas ------------------
procedure TFMenu.BitBtn25Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistatiendas();
  Timer1Timer(nil);
end;
//-------------------  Listado de usuarios ------------------
procedure TFMenu.BitBtn9Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistausuarios();
  Timer1Timer(nil);
end;
//----------------- Listado de articulos -------------
procedure TFMenu.BitBtn28Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistaarticulos();
  Timer1Timer(nil);
end;
//----------------- Listado de clientes -------------
procedure TFMenu.BitBtn29Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistaclientes();
  Timer1Timer(nil);
end;
//----------------- Listado de departamentos -------------
procedure TFMenu.BitBtn34Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistadepartamentos();
  Timer1Timer(nil);
end;
//----------------- Listado de familias -------------
procedure TFMenu.BitBtn30Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistafamilias();
  Timer1Timer(nil);
end;
//----------------- Listado de proveedores -------------
procedure TFMenu.BitBtn31Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistaproveedores();
  Timer1Timer(nil);
end;
//----------------- IVA Emitido -------------
procedure TFMenu.BitBtn32Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistaivaEmi();
  Timer1Timer(nil);
end;
//----------------- IVA Recibido -------------
procedure TFMenu.BitBtn33Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormlistaivaReci();
  Timer1Timer(nil);
end;


//===========================================================
//======================== PEDIDOS ==========================
//===========================================================
//----------------- Gestion de pedidos ----------------------
procedure TFMenu.BitBtn27Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormPedido();
  Timer1Timer(nil);
end;
//----------------- Entrada de pedidos ----------------------
procedure TFMenu.BitBtn39Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormEntradaPedido('','','','','');
  Timer1Timer(nil);
end;
//----------------- Generar pedidos ----------------------
procedure TFMenu.BitBtn53Click(Sender: TObject);
begin
 timer1.enabled:=false;
 ShowFormGeneraPed();
 Timer1Timer(nil);
end;

//----------------- Unir pedidos ----------------------
procedure TFMenu.BitBtn52Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormUniPedi();
  Timer1Timer(nil);
end;


//===========================================================
//======================= HISTORICOS ========================
//===========================================================

//----------------- Historico de operaciones ----------------
procedure TFMenu.BitBtn26Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormHistoop();
  Timer1Timer(nil);
end;
//----------------- Historico de pedidos ----------------
procedure TFMenu.BitBtn41Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormHistoPedido();
  Timer1Timer(nil);
end;

//----------------- Historico de albaranes ----------------
procedure TFMenu.BitBtn36Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormHistoAlbaranes();
  Timer1Timer(nil);
end;

//----------------- Facturar albaranes de pedidos ----------------------
procedure TFMenu.BitBtn57Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormFacturaPedi();
  Timer1Timer(nil);
end;

//----------------- Facturas de proveedor ----------------------
procedure TFMenu.BitBtn59Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormHistoFaProv();
  Timer1Timer(nil);
end;


//===========================================================
//======================== ETIQUETAS ========================
//===========================================================
//----------------- Etiquetas Lineales --------------------
procedure TFMenu.BitBtn40Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormEtilineales();
  Timer1Timer(nil);
end;

//===========================================================
//===================== COMUNICACIONES ======================
//===========================================================
//----------------- Actualizar Articulos --------------------
procedure TFMenu.BitBtnActuArtiClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormactualizaArti();
  Timer1Timer(nil);
end;
procedure TFMenu.BitBtnActuEansClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormactualizaEans();
  Timer1Timer(nil);
end;
procedure TFMenu.BitBtnComunClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormenviopedidos();
  Timer1Timer(nil);
end;
procedure TFMenu.BitBtnActuPediClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormactualizaPedi();
  Timer1Timer(nil);
end;
procedure TFMenu.BitBtnEnviArtiClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormenvioArti();
  Timer1Timer(nil);
end;
procedure TFMenu.BitBtnEnviCliClick(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormenvioClientes();
  Timer1Timer(nil);
end;
//===========================================================
//======================= UTILIDADES ========================
//===========================================================
//---------------------- Configuracion ----------------------
procedure TFMenu.BitBtn13Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormConfig();
  Timer1Timer(nil);
end;
//---------------------- Copias de seguridad ----------------
procedure TFMenu.BitBtn37Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormCopiaSeg();
  Timer1Timer(nil);
end;
//-------------------- Actualizaciones BBDD -----------------
procedure TFMenu.ActualizaBBDD(Sender: TObject);
begin
  AProcess := TProcess.Create(nil);
  {$IFDEF LINUX}
     AProcess.CommandLine := 'gksu /usr/bin/FacturActBBDD';
  {$ELSE}
     AProcess.CommandLine := Lee+'FacturActBBDD';
  {$ENDIF}
  AProcess.Execute;
  AProcess.Free;
end;

//---------------------- ACTUALIZAR TARIFAS ----------------
procedure TFMenu.BitBtn50Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormActAutArt();
  Timer1Timer(nil);
end;

//--------------------------- ACTUALIZACION DE STOCKS ----------------------
procedure TFMenu.BitBtn44Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormStock();
  Timer1Timer(nil);
end;
//--------------------- ETIQUETAS DE BARRAS -------------------
procedure TFMenu.BitBtn45Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormEtiEans();
  Timer1Timer(nil);
end;
//--------------------- ETIQUETAS LINEALES -------------------
procedure TFMenu.BitBtn46Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormEtiLineal();
  Timer1Timer(nil);
end;

//--------------------------- LLAMADA AL DISEÑADOR DE REPORTS ----------------------
procedure TFMenu.frReport1GetValue(const ParName: String; var ParValue: Variant
  );
begin
   if ParName='EMPRESA' then ParValue := Empresa;
   if ParName='DIRECCION' then ParValue := Direccion;
   if ParName='LOCALIDAD' then ParValue := Localidad;
   if ParName='PROVINCIA' then ParValue := Provincia;
   if ParName='NIF' then ParValue := Nif;
   if ParName='TELEFONO' then ParValue := Telefono;
   if ParName='FAX' then ParValue := Fax;
   if ParName='EMAIL' then ParValue := EMail;
   if ParName='CP' then ParValue := CP;
   if ParName='TITULO' then ParValue := TituloGrid;
end;


procedure TFMenu.BitBtn47Click(Sender: TObject);
begin
  timer1.enabled:=false;
  showmessage('No se recomienda la edición de reports si no está seguro de lo que va ha hacer');
  showmessage('Aseguresé de tener una copia de seguridad de sus reports');
  frReport1.DesignReport;
  Timer1Timer(nil);
end;

//-------------------- Promociones en artículos ------------
procedure TFMenu.BitBtn58Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormPromociones();
  Timer1Timer(nil);
end;


//--------------------- Roles de usuarios -------------------
procedure TFMenu.BitBtn54Click(Sender: TObject);
begin
  timer1.enabled:=false;
  ShowFormRoles();
  Timer1Timer(nil);
end;


//===========================================================
//========================= AYUDA ===========================
//===========================================================
//---------------------- A cerca de ... ---------------------
procedure TFMenu.BitBtnAboutClick(Sender: TObject);
begin
  timer1.enabled:=false; //añadido por javi para que no refresque sino esta en el menu principal
  AboutShow();
  Timer1Timer(nil); //añadido por javi para que refresque al volver
end;

//=================== CERRAR APLICACION ==================
Procedure Tfmenu.Bitbtn8click(Sender: Tobject);
Begin
  Close();
End;
Procedure Tfmenu.Formclose(Sender: Tobject; Var Closeaction: Tcloseaction);
Begin
 CloseAction:= CaFree;
End;

//===============================================================
//===================== LLAMADAS PENDIENTES =====================
//===============================================================
//----------------- Mostrar / Ocultar Panel -----------------
procedure TFMenu.SpeedButton1Click(Sender: TObject);
begin
   if Panel3.Visible=False then
    Panel3.Visible:=true
  else
    Panel3.Visible:=False;
end;

//----------------- Nueva Llamada ----------------
procedure TFMenu.MenuItem1Click(Sender: TObject);
begin
  LabelLlamada.Caption:='NUEVA LLAMADA / CORREO';
  Panel5.Visible:=True;
  Edit1.Text:=FormatDateTime('DD/MM/YYYY',Date);
  Edit2.Text:=FormatDateTime('HH:MM:SS',Time);
  Edit3.Text:='';
  Edit3.SetFocus;
end;
//----------------- Borrar llamada ---------------
procedure TFMenu.MenuItem2Click(Sender: TObject);
begin
   boxstyle :=  MB_ICONQUESTION + MB_YESNO;
   if Application.MessageBox('CONFIRME EL BORRADO DEL REGISTRO','FacturLinEx', boxstyle) = IDNO Then
      Exit;
  if dbLlamadas.RecordCount=0 then exit;
  dbLlamadas.Delete;
end;
//----------------- Editar llamada ---------------
procedure TFMenu.MenuItem3Click(Sender: TObject);
begin
  if dbLlamadas.RecordCount=0 then exit;
  LabelLlamada.Caption:='EDITAR LLAMADA / CORREO';
  Edit1.Text:=dbLlamadas.FieldByName('Fechallama').AsString;
  Edit2.Text:=dbLlamadas.FieldByName('Horallama').AsString;
  //dbLlamadas.FieldByName('Usuariollama').Value:=1;
  Edit3.Text:=dbLlamadas.FieldByName('Textollama').AsString;
  Panel5.Visible:=True; Edit3.SetFocus;
end;

//----------------- Editar / Nueva llamada --------
procedure TFMenu.BitBtn48Click(Sender: TObject);
begin
  if Edit1.Text='' then begin showmessage('DEBE RELLENAR LA FECHA'); exit; end;
  if Edit2.Text='' then begin showmessage('DEBE RELLENAR LA HORA'); exit; end;
  if Edit3.Text='' then begin showmessage('DEBE RELLENAR EL TEXTO'); exit; end;
  if LabelLlamada.Caption='NUEVA LLAMADA / CORREO' then
    dbLlamadas.Append else dbLlamadas.Edit;
  dbLlamadas.FieldByName('Fechallama').Value:=StrToDate(Edit1.Text);
  dbLlamadas.FieldByName('Horallama').Value:=StrToTime(Edit2.Text);
  dbLlamadas.FieldByName('Usuariollama').Value:=1;
  dbLlamadas.FieldByName('Textollama').Value:=Edit3.Text;
  dbLlamadas.Post;

  BitBtn49Click(self);

end;

//---------------- Cerrar panel llamadas pendientes
procedure TFMenu.BitBtn49Click(Sender: TObject);
begin
  Panel5.Visible:=False;
end;

//===============================================================
//====================== PEDIDOS PENDIENTES =====================
//===============================================================
//----------------- Mostrar / Ocultar Panel -----------------
procedure TFMenu.SpeedButton2Click(Sender: TObject);
begin
    if Panel4.Visible=False then
    Panel4.Visible:=true
  else
    Panel4.Visible:=False;
end;

//=================== CAMBIAR ICONOS DE AVISO LLAMADAS/PEDIDOS =================
procedure TFMenu.CargaIconos();
var
  Png: TPortableNetworkGraphic;
  Imagen: string;
begin
  Png := TPortableNetworkGraphic.Create;

  try
   Imagen:='LlamadaNo.png';
   if dbConect.Connected then
     if (dbllamadas.RecordCount<>0) then Imagen:='LlamadaSi.png';

     if (IconoLlamadas <> Imagen) then
       begin
       {$IFDEF LINUX}
         if FileExists('/usr/share/facturlinex2/Icons/'+Imagen) then begin
           Png.LoadFromFile('/usr/share/facturlinex2/Icons/'+Imagen);
           Speedbutton1.Glyph.Assign(Png);
           IconoLlamadas:= Imagen;
         end;
       {$ELSE}
         if FileExists(ExtractFilePath(ParamStr(0))+Imagen) then begin
           Png.LoadFromFile(ExtractFilePath(ParamStr(0))+Imagen);
           Speedbutton1.Glyph.Assign(Png);
           IconoLlamadas:= Imagen;
         end;
       {$ENDIF}
       end;
     Imagen:='PedidosNo.png';
     if dbConect.Connected then
       if (dbpedidos.RecordCount<>0) then Imagen:='PedidosSi.png';
     if (IconoPedidos <> Imagen) then
       begin
       {$IFDEF LINUX}
         if FileExists('/usr/share/facturlinex2/Icons/'+Imagen) then begin
           Png.LoadFromFile('/usr/share/facturlinex2/Icons/'+Imagen);
           Speedbutton2.Glyph.Assign(Png);
           IconoPedidos:= Imagen;
         end;
       {$ELSE}
        if FileExists(ExtractFilePath(ParamStr(0))+Imagen) then begin
           Png.LoadFromFile(ExtractFilePath(ParamStr(0))+Imagen);
           Speedbutton2.Glyph.Assign(Png);
           IconoPedidos:= Imagen;
        end;
       {$ENDIF}
       end;
  finally
    Png.Free;
  end;
end;
//=================== CHEQUEAR SI HAY AVISO DE LLAMADAS/PEDIDOS =================
procedure TFMenu.Timer1Timer(Sender: TObject);
var
  HoraInicioCopia, HoraFinCopia, HoraActual: TDateTime;
  FicheroCopia: String;
begin
 Timer1.enabled:=False;
 if dbConect.Connected then begin      //modificado por javi para arreglar problema sino existe el fichero ini
    dbllamadas.Refresh; dbpedidos.Refresh;
 end;
  CargaIconos();

  // Comprobamos si cambió el día.
  if FechaEntrada <> FormatDateTime('DD/MM/YYYY',Date) then
   begin
      ActualizamosPromociones;
      FechaEntrada:=FormatDateTime('DD/MM/YYYY',Date);
   end;

  // Proceso de Copia de Seguridad Automatica
  if global.Copia1Activada='SI' then begin

     HoraInicioCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia1InicioHora),StrToInt(global.Copia1InicioMinutos),0,0));
     HoraFinCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia1FinHora),StrToInt(global.Copia1FinMinutos),0,0));
     HoraActual:=now();

     if ((HoraInicioCopia<=HoraActual) and (HoraActual<=HoraFinCopia)) then begin
        // La Copia 1 está activada y la hora de ejecución es correcta
        FicheroCopia:=global.Copia1Destino+'/'+global.DBDataBase+'_'+FormatDateTime('yyyymmdd',now)+'_A.sql';
        if FileExists(FicheroCopia) then abort;  // La Copia 1 de hoy ya está hecha
        if not DirectoryExists(global.Copia1Destino) then begin showmessage('No existe el destino para la copia de seguridad 1'+ #13 +
                                                                            'Se cancela el proceso de generación'); abort; end;

        PageControl1.Enabled:=False;  // Deshabilitamos el sistema mientras hacermos la copia de seguridad

        fCopiaSegAuto:=TFCopiaSegAuto.Create(Application);
        fCopiaSegAuto.GenerarSQL(FicheroCopia);  // Se genera el fichero sql de copia de seguridad

        PageControl1.Enabled:=True;  // habilitamos el sistema.

     end;
  end;

  if global.Copia2Activada='SI' then begin

     HoraInicioCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia2InicioHora),StrToInt(global.Copia2InicioMinutos),0,0));
     HoraFinCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia2FinHora),StrToInt(global.Copia2FinMinutos),0,0));
     HoraActual:=now();

     if ((HoraInicioCopia<=HoraActual) and (HoraActual<=HoraFinCopia)) then begin
        // La Copia 2 está activada y la hora de ejecución es correcta
        FicheroCopia:=global.Copia1Destino+'/'+global.DBDataBase+'_'+FormatDateTime('yyyymmdd',now)+'_B.sql';
        if FileExists(FicheroCopia) then abort;  // La Copia 2 de hoy ya está hecha
        if not DirectoryExists(global.Copia2Destino) then begin showmessage('No existe el destino para la copia de seguridad 2'+ #13 +
                                                                            'Se cancela la generación del proceso'); abort; end;

        PageControl1.Enabled:=False;  // Deshabilitamos el sistema mientras hacermos la copia de seguridad

        fCopiaSegAuto:=TFCopiaSegAuto.Create(Application);
        fCopiaSegAuto.GenerarSQL(FicheroCopia);  // Se genera el fichero sql de copia de seguridad

        PageControl1.Enabled:=True;  // habilitamos el sistema

     end;
  end;

  if global.Copia3Activada='SI' then begin

     HoraInicioCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia3InicioHora),StrToInt(global.Copia3InicioMinutos),0,0));
     HoraFinCopia:=ComposeDateTime(now(),EncodeTime(StrToInt(global.Copia3FinHora),StrToInt(global.Copia3FinMinutos),0,0));
     HoraActual:=now();

     if ((HoraInicioCopia<=HoraActual) and (HoraActual<=HoraFinCopia)) then begin
        // La Copia 3 está activada y la hora de ejecución es correcta
        FicheroCopia:=global.Copia1Destino+'/'+global.DBDataBase+'_'+FormatDateTime('yyyymmdd',now)+'_C.sql';
        if FileExists(FicheroCopia) then abort;  // La Copia 3 de hoy ya está hecha
        if not DirectoryExists(global.Copia3Destino) then begin showmessage('No existe el destino para la copia de seguridad 3'+ #13 +
                                                                        'Se cancela la generación del proceso'); abort; end;

        PageControl1.Enabled:=False;  // Deshabilitamos el sistema mientras hacermos la copia de seguridad

        fCopiaSegAuto:=TFCopiaSegAuto.Create(Application);
        fCopiaSegAuto.GenerarSQL(FicheroCopia);  // Se genera el fichero sql de copia de seguridad

        PageControl1.Enabled:=True;  // habilitamos el sistema

     end;
  end;

  Timer1.Enabled:=True;

end;

//===============================================================
//=================== INICIAR POR PRIMERA VEZ ===================
//===============================================================
//------------ Aceptar panel de configuracion y guardar ------------
procedure TFMenu.BitBtn19Click(Sender: TObject);
var
  Txt: String;
  F: TextFile;
  FicheroSql: String;
begin
  //Comprueba que el protocolo escogido en el Combo esté soportado
  if not ServidoresBD[ComboServidoresBD.ItemIndex].soportado then
  begin
    ShowMessage('Actualmente este protocolo no está soportado. Solicite más información en la página del proyecto. Gracias');
    exit;
  end;

  //----------------- Crear BBDD -------
  //------- Este es el código propuesto por Fco. Javier Perez Vidal
  //------- con esto evitamos saber donde esta mysql instalado
  dbConect.HostName:=Edit21.Text;
  dbConect.User:=Edit22.Text;
  dbConect.Password:=Edit23.Text;
  dbConect.Port:=StrToInt(Edit25.Text);
  dbConect.Protocol:=ComboServidoresBD.Text;
  try
    dbConect.Connect;
  except
    begin ShowMessage('NO HE PODIDO CONECTAR CON EL SERVIDOR DE BBDD, REVISE LOS DATOS DE CONEXION!'); exit; end;
  end;        // A partir de aquí tiene conexión con el servidor, si no la hubiera, vuelve a la pantalla de inicio
  if ExisteDB(dbConect, Edit24.Text) then  //Si existe la BD
    begin     // Pregunta si la quiere usar . Si SI pasa a guardar los datos de config (linea 568)
      If Application.MessageBox('¿DESEA UTILIZAR LA BASE DE DATOS EXISTENTE?','FacturLinEx', boxstyle) = IDNO Then
      Exit;  // Si no, vuelve a la pantalla de inicio
    end
  else       // Si no existe la BD, la intenta crear. Si todo es correcto,
    begin    //acude al script factirlinex2.sql para crear las tablas
      dbQuery.SQL.Text:='CREATE DATABASE '+Edit24.Text;
      try
        dbQuery.ExecSQL;
      except
        begin ShowMessage('ERROR AL CREAR LA BASE DE DATOS'); exit; end;
    end;
    //----------------- Crear Tablas -------
    dbConect.Disconnect;
    dbConect.Database:=Edit24.Text;
    dbConect.Connected:=True;
    {$IFDEF LINUX}
//      Opendialog1.FileName:='/usr/share/facturlinex2/facturlinex2.sql';  //Cambiado por javi para quitar el opendialog
      FicheroSql:= '/usr/share/facturlinex2/facturlinex2.sql';  //añadido por javi para quitar opendialog
    {$ELSE}
//      Opendialog1.FileName:='tablas/facturlinex2.sql'; //Cambiado por javi para quitar el opendialog
      FicheroSql:= 'tablas/facturlinex2.sql';  //añadido por javi para quitar opendialog
    {$ENDIF}
//    AssignFile(F,Opendialog1.FileName);  //Cambiado por javi para quitar el opendialog
    AssignFile(F,FicheroSql); //añadido por javi para quitar opendialog
    Reset(F);
    while not EOF(F) do
      begin
       Readln(F,Txt);
       if (Txt<>'') and (copy(Txt,1,1)<>'#') then
         begin
           //No hay duda de que es la primera vez que se ejecuta, por lo que no
           // hay miedo de cambiar directamente las XXXX por 0000, así que ...
           Txt:=StringReplace(Txt,'XXXX','0000',[rfReplaceAll]);
           dbQuery.SQL.Text:=Txt;
           dbQuery.ExecSQL; end;
      end;
  end;
  dbConect.Disconnect;
  //--------------- Guardar datos en el config ---------------
  if not directoryExists(Lee) then mkdir(Lee);
//  OpenDialog1.FileName:=Lee+'FacturConf.ini';  // cambiado por javi para quitar el opendialog1
//  IniReader := TIniFile.Create(OpenDialog1.FileName); // cambiado por javi para quitar el opendialog1
  IniReader := TIniFile.Create(Lee+'FacturConf.ini'); //añadido por javi para quitar opendialog
  Sections := TStringList.Create;
//  Contents := TStringList.Create;//quitado por javi no se usa
  //---------- Sección Empresa ---------
  IniReader.WriteString('datos','nombre','PUNTODEV GNU S.L.');
  IniReader.WriteString('datos','direccion','ARTURO BAREA, 4 - 1 B');
  IniReader.WriteString('datos','poblacion','BADAJOZ');
  IniReader.WriteString('datos','cp','06011');
  IniReader.WriteString('datos','provincia','BADAJOZ');
  IniReader.WriteString('datos','CIF','B06XXXXXX');
  IniReader.WriteString('datos','telefono','924-224066');
  IniReader.WriteString('datos','fax','924-263006');
  IniReader.WriteString('datos','mail','info@puntodev.com');
  //----------- Seccion BBDD -----------
  IniReader.WriteString('BBDD','host',Edit21.Text);
  IniReader.WriteString('BBDD','usuario',Edit22.Text);
  IniReader.WriteString('BBDD','passwd',Edit23.Text);
  IniReader.WriteString('BBDD','database',Edit24.Text);
  IniReader.WriteString('BBDD','puerto',Edit25.Text);
  IniReader.WriteString('BBDD','protocolo',ComboServidoresBD.Text);
  //----------- Seccion Tienda Activa
  IniReader.WriteString('tienda','codigo','0000');
  IniReader.WriteString('tienda','puesto','A');
  //----------- Seccion SicLinEx -----------
  IniReader.WriteString('BBDD','ActivarSIC','N');
  IniReader.WriteString('BBDD','SIChost','localhost');
  IniReader.WriteString('BBDD','SICusuario','root');
  IniReader.WriteString('BBDD','SICpasswd','');
  IniReader.WriteString('BBDD','SICdatabase','sicLinex');
  IniReader.WriteString('BBDD','SICpuerto','3306');
  IniReader.WriteString('BBDD','SICprotocolo','mysql-5');
  //----------- IVAS
  IniReader.WriteString('Programa','IVA1','18');
  IniReader.WriteString('Programa','IVA2','7');
  IniReader.WriteString('Programa','IVA3','4');
  IniReader.WriteString('Programa','RIVA1','4');
  IniReader.WriteString('Programa','RIVA2','1');
  IniReader.WriteString('Programa','RIVA3','0.5');

  //---------- Sección Tickets ---------
  IniReader.WriteString('tickets','HoraEnTicket','S');
  IniReader.WriteString('tickets','SacaVende','S');
  IniReader.WriteString('tickets','DesgloIva','N');
  IniReader.WriteString('tickets','SacaIva','S');

  //---------- Sección Puntos ---------
  IniReader.WriteString('Puntos','Activar_Puntos','N');
  IniReader.WriteString('Puntos','Activar_Productos','N');
  IniReader.WriteString('Puntos','Porcentaje','0');
  IniReader.WriteString('Puntos','Extra','0');
  IniReader.WriteString('Puntos','Especial','0');

  //---------- Sección de Configuración General ----------
  IniReader.WriteString('CGeneral','Idioma','ESP');
  IniReader.WriteString('CGeneral','Cod_apertura_cajon','000');
  IniReader.WriteString('CGeneral','Cod_balanza','0000000000000');
  IniReader.WriteString('CGeneral','Tarjetas_Varios','N');
  IniReader.WriteString('CGeneral','Precio_IVA_Inc','N');
  IniReader.WriteString('CGeneral','Benficio_Caja','N');
  IniReader.WriteString('CGeneral','Forzar_Albaranes','N');
  IniReader.WriteString('CGeneral','Permitir_Fras_Credito','N');
  IniReader.WriteString('CGeneral','Borra_Albaran_Facturado','N');
  IniReader.WriteString('CGeneral','Mostrar_Oferta','N');
  IniReader.WriteString('CGeneral','Controlar_Horas','N');
  IniReader.WriteString('CGeneral','Activar_Lotes','N');
  IniReader.WriteString('CGeneral','Activar_Envases','N');
  IniReader.WriteString('CGeneral','Agrupar_Envases','N');
  IniReader.WriteString('CGeneral','Avisar_Stock_0','N');
  IniReader.WriteString('CGeneral','Imprimir_Dto','N');
  IniReader.WriteString('CGeneral','Visualiar_antes_imprimir','N');
  IniReader.WriteString('CGeneral','Imprimir_Ticket','Ticketera');
  IniReader.WriteString('CGeneral','Imprimir_Ticket_Regalo','N');
  IniReader.WriteString('CGeneral','Previsualizar_Albaran_Ventas','N');
  IniReader.WriteString('CGeneral','Imprimir_Albaranes','Impresora');
  IniReader.WriteString('CGeneral','Previsualizar_Facturas_Ventas','N');
  IniReader.WriteString('CGeneral','Imprimir_Facturas','Impresora');
  IniReader.WriteString('CGeneral','Importe_Letras_Facturas','N');
  IniReader.WriteString('CGeneral','Tiempo_Visualizar_Aviso','SIEMPRE');
  IniReader.WriteString('CGeneral','PedirUsuario','N');


  //---- Escribir IniFile
  IniReader.UpdateFile;
  Panel1.Visible:=False; Pagecontrol1.Enabled:=True;

  //----------------- Refrescar datos del datamodule
  Global.Tienda:='0000';
  Global.VeTienda:='0000';
  Global.NTienda:='0';
  Global.Puesto:='A';
  Global.Empresa:='PUNTODEV GNU S.L.';
  Global.Direccion:='ARTURO BAREA, 4 - 3.B';
  Global.Localidad:='BADAJOZ';
  Global.Nif:='B06XXXXXX';
  Global.CP:='06011';
  Global.DBHost:=Edit21.Text;
  Global.DBUsuario:=Edit22.Text;
  Global.DBPasswd:=Edit23.Text;
  Global.DBDataBase:=Edit24.Text;
  Global.DBPuerto:=Edit25.Text;
  Global.DBProtocolo:=ComboServidoresBD.Text;
  Global.ActivarSIC:='N';
  Global.SICHost:='localhost';
  Global.SICDataBase:='sicLinex';
  Global.SICUsuario:='root';
  Global.SICPasswd:='';
  Global.SICPuerto:='3306';
  Global.SICProtocolo:='mysql-5';
  Global.IVA1:=18;Global.IVA2:=7;Global.IVA3:=4;
  Global.RIVA1:=4;Global.RIVA2:=1;Global.RIVA3:=0.5;
  Global.APuntos:='N';
  Global.AProductos:='N';
  Global.Porcentaje:='0';
  Global.Extra:='0';
  Global.Especial:='0';

  //------------- Iniciar normalmente --------
  Iniciar();

end;

//------------ Cerrar panel de configuracion y salir ------------
procedure TFMenu.BitBtn18Click(Sender: TObject);
begin
  Close();
end;

procedure TFMenu.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
  );
begin
// cambiado por javi para quitar if entrelazados por un case más optimizado
// if (key=VK_1) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet1; Exit; End;
// if (key=VK_2) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet2; Exit; End;
// if (key=VK_3) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet3; Exit; End;
// if (key=VK_4) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet4; Exit; End;
// if (key=VK_5) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet5; Exit; End;
// if (key=VK_6) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet6; Exit; End;
// if (key=VK_7) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet7; Exit; End;
// if (key=VK_8) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet9; Exit; End;
// if (key=VK_9) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet8; Exit; End;
// if (key=VK_0) and (ssAlt in Shift) then begin key:=0; PageControl1.ActivePage:= TabSheet10; Exit; End;

  if (ssAlt in Shift) = False then exit;
  case key of
    VK_1:  PageControl1.ActivePage:= TabSheet1;
    VK_2:  PageControl1.ActivePage:= TabSheet2;
    VK_3:  PageControl1.ActivePage:= TabSheet3;
    VK_4:  PageControl1.ActivePage:= TabSheet4;
    VK_5:  PageControl1.ActivePage:= TabSheet5;
    VK_6:  PageControl1.ActivePage:= TabSheet6;
    VK_7:  PageControl1.ActivePage:= TabSheet7;
    VK_8:  PageControl1.ActivePage:= TabSheet9;
    VK_9:  PageControl1.ActivePage:= TabSheet8;
    VK_0:  PageControl1.ActivePage:= TabSheet10;
  end;
end;

procedure TFMenu.FormPaint(Sender: TObject);
begin
    //----------------- Pedidos pendientes ----------
// if dbConect.Connected then begin      //modificado por javi para arreglar problema sino existe el fichero ini
//desactivado ya que esta puesto el timer y que al volver de algun menu se refresque el sql
//    dbPedidos.Active:=False;
//    dbPedidos.SQL.Text:='SELECT * FROM pedicc'+Tienda+' ORDER BY PC1 ASC';
//    dbPedidos.Active:=True;
// end;
end;

procedure TFMenu.FormShow(Sender: TObject);
begin

 if (LogoEmpresa = '') then exit;
 ImagenLogo.Picture.Clear;
 if FileExists(LogoEmpresa) then ImagenLogo.Picture.LoadFromFile(LogoEmpresa);
 ActualizamosPromociones();
end;

//============================================================================
//============================ USUARIO Y CLAVE DE ACCESO =====================
//============================================================================
//------------------- Aceptar usuario y clave
procedure TFMenu.BitBtn55Click(Sender: TObject);
begin
  if Edit27.Text='' then exit;
  if dbUsuarios.Active=False then exit;
  if dbUsuarios.RecordCount=0 then exit;
  if (Copy(Edit27.Text, 1, 8) <>dbUsuarios.FieldByName('USU10').AsString) then
    begin
       showmessage('ERROR EN EL ACCESO A LA APLICACION.');
       Edit26.SetFocus;
       exit;
    end;
  UsuarioActivo:=Edit26.Text;    // Guardamos el usuario por defecto.
  Panel6.Visible:=False;
  Pagecontrol1.Enabled:=True;
  SpeedButton1.Enabled:=True; SpeedButton2.Enabled:=True;
  CgRol:=dbUsuarios.FieldByName('USU11').AsString;//--------- Rol del usuario

  BitBtn7.Enabled:=CheckRoles(dbRoles, CgRol, 'Tiendas', 1);//------ Rol Ficha Tiendas
  BitBtn12.Enabled:=CheckRoles(dbRoles, CgRol, 'Usuarios', 1);//---- Rol Ficha Usuarios
  BitBtn16.Enabled:=CheckRoles(dbRoles, CgRol, 'Departa', 1);//----- Rol Ficha Departamentos
  BitBtn15.Enabled:=CheckRoles(dbRoles, CgRol, 'Familias', 1);//---- Rol Ficha Familias
  BitBtn11.Enabled:=CheckRoles(dbRoles, CgRol, 'Articulos', 1);//--- Rol Ficha Articulos
  BitBtn10.Enabled:=CheckRoles(dbRoles, CgRol, 'Clientes', 1);//---- Rol Ficha Clientes
  BitBtn14.Enabled:=CheckRoles(dbRoles, CgRol, 'Proveed', 1);//----- Rol Ficha Proveedores
  BitBtn21.Enabled:=CheckRoles(dbRoles, CgRol, 'Formapag', 1);//---- Rol Ficha F. Pagos / Cobros
  BitBtn22.Enabled:=CheckRoles(dbRoles, CgRol, 'Rutas', 1);//------- Rol Ficha Rutas
  BitBtn23.Enabled:=CheckRoles(dbRoles, CgRol, 'Fabrica', 1);//----- Rol Ficha Fabricantes
  BitBtn24.Enabled:=CheckRoles(dbRoles, CgRol, 'Envases', 1);//----- Rol Ficha Envases
  BitBtn42.Enabled:=CheckRoles(dbRoles, CgRol, 'Puestos', 1);//----- Rol Ficha Puestos
  BitBtn35.Enabled:=CheckRoles(dbRoles, CgRol, 'Produccion', 1);//-- Rol Ficha Produccion
end;

//------------------- Cerrar panel usuario y clave
procedure TFMenu.BitBtn56Click(Sender: TObject);
begin
  Close();
end;

//========================= USUARIO ==========================
procedure TFMenu.Edit26Enter(Sender: TObject);
begin
   Edit26.Text:=''; Edit27.Text:='';
end;
procedure TFMenu.Edit26Exit(Sender: TObject);
begin
   if Edit26.Text='' then exit;
   dbUsuarios.SQL.Text:='SELECT * FROM usuarios'+Tienda+' WHERE USU9="'+Edit26.Text+'"';
   dbUsuarios.Active:=True;
   if dbUsuarios.RecordCount=0 then exit;
end;
procedure TFMenu.Edit26KeyPress(Sender: TObject; var Key: char);
begin
  if Key=#13 then Edit27.SetFocus;
end;

procedure TFMenu.Edit27KeyPress(Sender: TObject; var Key: char);
begin
  if Key=#13 then BitBtn55Click(BitBtn55);
end;


Initialization
  {$I menu.lrs}

End.

