/***************************************************************************
                          main.cpp  -  Principal
                             -------------------
    begin                : lun mar 19 13:44:14 CET 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfont.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <qsqldriver.h>
#include <qplatinumstyle.h>
#include <qsettings.h>
#include <qwidgetfactory.h>

#include "flbase/FLApplication.h"
#include "flbase/FLSessionDB.h"
#include "ftsw/firsttimesetupwizardimp.h"

int
main (int argc, char *argv[])
{
  FLApplication FacturaLUX (argc, argv);
  QSettings settings;
  QFont appFont;
  QString keybase("/facturalux/" VERSION "/");

  QApplication::setOverrideCursor( Qt::WaitCursor );

  appFont.setFamily (settings.readEntry ( keybase + "fuente/familia", "helvetica"));
  appFont.setPointSize (settings.readNumEntry ( keybase + "fuente/puntos", 12));
  appFont.setBold (settings.readBoolEntry ( keybase + "fuente/negrita", false));
  appFont.setItalic (settings.readBoolEntry ( keybase + "fuente/cursiva", false));
  appFont.setUnderline (settings.readBoolEntry ( keybase + "fuente/subrayado", false));
  appFont.setStrikeOut (settings.readBoolEntry ( keybase + "fuente/tachado", false));

  FacturaLUX.setFont (appFont);
  FacturaLUX.setStyle (settings.readEntry ( keybase + "estilo", "Platinum"));

  QString Language (QTextCodec::locale ());

  QTranslator qt (0);
  if (!qt.load (QString (FLDATA "/facturalux/translations/qt_") + Language.left (2), "."))
    qWarning (FacturaLUX.tr ("main.cpp : No se ha podido cargar el fichero de traducciones qt_"
			 + Language.left (2) + ".qm . Ejecute 'make install' despues de compilar la aplicacin."));
  else
    FacturaLUX.installTranslator (&qt);
  
  QTranslator  tor (0);
  if (!tor.load (QString (FLDATA "/facturalux/translations/facturalux.") + Language.left (2), "."))
    qWarning (FacturaLUX.tr ("main.cpp : No se ha podido cargar el fichero de traducciones facturalux."
			  + Language.left (2) + ".qm . Ejecute 'make install' despues de compilar la aplicacin."));
  else
    FacturaLUX.installTranslator (&tor);

  QTranslator perso (0);
  if (!perso.load (QString (FLDATA "/facturalux/translations/perso.") + Language.left (2), "."))
    qWarning (FacturaLUX.tr ("main.cpp : No se ha podido cargar el fichero de traducciones perso."
			 + Language.left (2) + ".qm . Necesita instalar una personalizacin."));
  else
    FacturaLUX.installTranslator (&perso);

  FacturaLUX.addLibraryPath (FLLIB);
  FacturaLUX.addLibraryPath(QTDIR "/plugins");
  FacturaLUX.addLibraryPath(QTDIR "/plugins-mt");

  FLSessionDB *s = 0;
  QSqlDatabase *db;
  db=NULL;
  bool FirstTime;
  int ret;

  FirstTime = settings.readBoolEntry( keybase + "First Time Setup", false);

  QApplication::restoreOverrideCursor();

  if(!FirstTime)
    {
       FirstTimeSetupWizardImp *ftsw=NULL;
	ftsw = new FirstTimeSetupWizardImp();
	ret = ftsw->exec ();
	if (ret != QDialog::Accepted)
	    {
	  	FacturaLUX.quit ();
	  	return 0;
	    }
    }

  do
	{
	  db = QSqlDatabase::addDatabase ("QPSQL7");
	  if (!db)
		{
		  qWarning (FacturaLUX.tr ("main : Fallo al conectar con el driver. Esta aplicacin utiliza PostgreSQL."));
		  return 0;
		}

	  if (!db->driver ()->hasFeature (QSqlDriver::Transactions))
		{
		  qWarning (FacturaLUX.tr ("Esta base de datos no soporta transacciones. Imposible continuar."));
		  return 0;
		}

	  if (s)
		delete s;

	  s = new FLSessionDB (0, 0, Qt::WDestructiveClose);
	  ret = s->exec ();
	}
  while (s->error ());

  if (ret != QDialog::Accepted)
        {
	    FacturaLUX.quit ();
           return 0;
        }

  if (s)
	delete s;

  FLApplication::setOverrideCursor( Qt::WaitCursor );
  QLabel *splash = FacturaLUX.showSplash();

  FacturaLUX.set_splash_status(FacturaLUX.tr("Conectando a la base de datos..."));  
  FacturaLUX.setGeneralDB (db);

  QString form = FLDATA "/facturalux/forms/FLWidgetApplication.ui";
  QWidget *w = QWidgetFactory::create (form, &FacturaLUX);

  if (!w)
	{
	  qWarning (FacturaLUX.tr ("main : No se ha podido cargar '") + form +
				FacturaLUX.tr ("'. Ejecute 'make install' despues de compilar la aplicacin."));
	  FacturaLUX.quit ();
	}

  FacturaLUX.setMainWidget (w);
  w->show ();
  delete splash;
  QApplication::restoreOverrideCursor();
  return FacturaLUX.exec ();
}
