/***************************************************************************
                          FLReportViewer.h  -  description
                             -------------------
    begin                : vie jun 28 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLREPORTVIEWER_H
#define FLREPORTVIEWER_H

#include "FLWidgetReportViewer.h"

class MReportViewer;
class FLSqlQuery;
class FLSqlCursor;
class FLReportEngine;

/** Visor para previsualizar informes de Kugar

    @author Federico Albujer Zornoza
    @version 0.4 */
class FLReportViewer : public FLWidgetReportViewer
{
    public:

    /** constructor */	
    FLReportViewer( QWidget *parent=0, const char *name=0 );
	
    /** destructor */
    ~FLReportViewer();

    /** Carga el informe en el visor.

        @return    TRUE si todo ha ido bien*/
    bool renderReport();

    /** Establece los datos del informe a partir de una consulta

        @param q   Objeto FLSqlQuery con la consulta de la que se toman los datos
        @return    TRUE si todo ha ido bien*/
    bool setReportData( FLSqlQuery * q );

    /** Establece los datos del informe a partir de una tabla

         @param t   Objeto FLSqlCursor con  la tabla de la que se toman los datos
         @return    TRUE si todo ha ido bien*/
    bool setReportData( FLSqlCursor * t );

     /** Establece la plantilla para el informe.

        El nombre de la plantilla corresponde con el nombre del fichero con extesin ".kut".

        @param  t   Nombre dela plantilla
        @return    TRUE si todo ha ido bien*/
    bool setReportTemplate( const QString & t);

    /** Reimplementacin de QWidget::sizeHint() */
    QSize sizeHint() const;

    private slots:

    /** Muestra la primera pgina del informe */
    void slotFirstPage();

    /** Muestra la tlima pgina del informe */
    void slotLastPage();

    /** Muestra la siguiente pgina del informe */
    void slotNextPage();

    /** Muestra la anterior pgina del informe */
    void slotPrevPage();

    /** Cierra el visor */
    void slotExit();

    /** Imprime el informe */
    void slotPrintReport();

    private:

    /** Visor bsico de Kugar */
    MReportViewer * rptViewer;

    /** Motor de informes de FacturaLUX */
    FLReportEngine * rptEngine;
};

#endif
