/* ethos-error.c
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#include <glib-object.h>
#include "ethos-error.h"

/**
 * SECTION:ethos-error
 * @title: EthosError
 * @short_description: ethos error types
 */

/**
 * ethos_error_quark:
 *
 * Retrieves the error domain for ethos.
 *
 * Return value: the #GQuark for ethos
 */
GQuark
ethos_error_quark (void)
{
	return g_quark_from_static_string ("ethos-error-quark");
}

/**
 * ethos_error_get_type:
 *
 * Retreives the GType for the ethos error domain.
 *
 * Return value: the #GType for #EthosError
 */
GType
ethos_error_get_type (void)
{
	static GType g_type = 0;
	static GEnumValue values[] = {
		{ ETHOS_ERROR_FILE_NOT_FOUND,   "ETHOS_ERROR_FILE_NOT_FOUND",   "FILE_NOT_FOUND" },
		{ ETHOS_ERROR_INVALID_KEY_FILE, "ETHOS_ERROR_INVALID_KEY_FILE", "INVALID_KEY_FILE" },
		{ ETHOS_ERROR_PLUGIN,           "ETHOS_ERROR_PLUGIN",            "PLUGIN" },
		{ ETHOS_ERROR_PLUGIN_LOADER,    "ETHOS_ERROR_PLUGIN_LOADER",     "PLUGIN_LOADER" },
		{ 0, NULL, NULL }
	};

	if (G_UNLIKELY (!g_type))
		g_type = g_enum_register_static ("EthosError", values);

	return g_type;
}
