#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Greg Rogers
#
#-----------------------------------------------------------------------------

from enthought.traits.ui.api import View, Item

from my_model_handler import MyModelHandler

class MyModelView( View ):
    """ Custom, default, view for MyModel objects.
    """
    def __init__(self):
        """ Creates a new MyModelView instance. """
        
        super(MyModelView, self).__init__(
            Item( name='name'),
            
            # Note: can't use '_' in object names.
            Item( object='handlermodel', name='allow_empty_string', 
                  label='Allow Empty'),
            
            handler=MyModelHandler()
            )

### EOF
