C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C


      SUBROUTINE MODVAL   (LENIN,LENOUT,MULT)
C
C---->
C*                                                                    *
C*    NAME      : MODVAL                                              *
C*                                                                    *
C*    FUNCTION  : MAKES ONE VALUE A MULTIPLE OF ANOTHER.              *
C*                                                                    *
C*    INPUT     : LENIN = INPUT  VALUE                                *
C*                MULT  = MODULO VALUE                                *
C*                                                                    *
C*    OUTPUT    : LENOUT= OUTPUT VALUE                                *
C*                                                                    *
C*    GENERAL   : MODVAL CALLS  MOD                                   *
C*                              ABS                                   *
C*                                                                    *
C*    AUTHOR    : B.V. GURETZKY    V.E. DAY                           *
C*                                                                    *
C*    MODIFIED  : J. HENNESSY      25.11.85                           *
C*                                                                    *
C*                                                                    *
C     ---------------------------------------------------------------
C----<
C
      LENG  = ABS (MULT)
      INTER = MOD (ABS(LENIN),LENG)
C
      IF (INTER.NE.0)
     C   THEN
             LENG = LENG - INTER
             IF (LENIN.LT.0)
     C           THEN
                     LENOUT = LENIN - LENG
                 ELSE
                     LENOUT = LENIN + LENG
                 ENDIF
         ELSE
             LENOUT = LENIN
         ENDIF
C
C
      RETURN
      END
