/*
 *
 * (c) 2005 Laurent Vivier <Laurent@lvivier.info>
 *
 */


typedef enum modifiers_mask {
	modifier_shift		= 0x01,
	modifier_capslock	= 0x02,
	modifier_command	= 0x04,
	modifier_option		= 0x08,
	modifier_control	= 0x10,
} modifiers_mask;

typedef enum scancodes {
	scancode_A		= 0x00,
	scancode_S		= 0x01,
	scancode_D		= 0x02,
	scancode_F		= 0x03,
	scancode_H		= 0x04,
	scancode_G		= 0x05,
	scancode_Z		= 0x06,
	scancode_X		= 0x07,
	scancode_C		= 0x08,
	scancode_V		= 0x09,
	scancode_B		= 0x0b,
	scancode_Q		= 0x0c,
	scancode_W		= 0x0d,
	scancode_E		= 0x0e,
	scancode_R		= 0x0f,
	scancode_Y		= 0x10,
	scancode_T		= 0x11,
	scancode_1		= 0x12,
	scancode_2		= 0x13,
	scancode_3		= 0x14,
	scancode_4		= 0x15,
	scancode_6		= 0x16,
	scancode_5		= 0x17,
	scancode_Equals          = 0x18,
	scancode_9		= 0x19,
	scancode_7		= 0x1a,
	scancode_Minus           = 0x1b,
	scancode_8		= 0x1c,
	scancode_0		= 0x1d,
	scancode_CloseBrace      = 0x1e,
	scancode_O		= 0x1F,
	scancode_U		= 0x20,
	scancode_OpenBrace       = 0x21,
	scancode_I		= 0x22,
	scancode_P		= 0x23,
	scancode_Return		= 0x24,
	scancode_L		= 0x25,
	scancode_J		= 0x26,
	scancode_Quote           = 0x27,
	scancode_K		= 0x28,
	scancode_Colon           = 0x29,
	scancode_Backslash       = 0x2a,
	scancode_Comma           = 0x2b,
	scancode_Slash           = 0x2c,
	scancode_N		= 0x2d,
	scancode_M		= 0x2e,
	scancode_Stop		= 0x2f,
	scancode_Tab		= 0x30,
	scancode_Space		= 0x31,
	scancode_Tilde		= 0x32,
	scancode_Backspace	= 0x33,
	scancode_Escape		= 0x35,
	scancode_Command		= 0x37,
	scancode_LeftShift	= 0x38,
	scancode_CapsLock	= 0x39,
	scancode_LeftOption	= 0x3a,
	scancode_LeftControl	= 0x3b,
	scancode_RightShift	= 0x3c,
	scancode_RightOption	= 0x3d,
	scancode_RightControl	= 0x3e,
	scancode_KeypadStop	= 0x41,
	scancode_KeypadAsterisk  = 0x43,
	scancode_KeypadPlus      = 0x45,
	scancode_NumLock		= 0x47,
	scancode_KeypadSlash     = 0x4B,
	scancode_KeypadEnter	= 0x4C,
	scancode_KeypadMinus     = 0x4E,
	scancode_KeypadEquals	= 0x51,
	scancode_Keypad0		= 0x52,
	scancode_Keypad1		= 0x53,
	scancode_Keypad2		= 0x54,
	scancode_Keypad3		= 0x55,
	scancode_Keypad4		= 0x56,
	scancode_Keypad5		= 0x57,
	scancode_Keypad6		= 0x58,
	scancode_Keypad7		= 0x59,
	scancode_Keypad8		= 0x5b,
	scancode_Keypad9		= 0x5c,
	scancode_F5		= 0x60,
	scancode_F6		= 0x61,
	scancode_F7		= 0x62,
	scancode_F3		= 0x63,
	scancode_F8		= 0x64,
	scancode_F9		= 0x65,
	scancode_F11		= 0x67,
	scancode_PrintScreen	= 0x69,
	scancode_ScreenLock	= 0x6b,
	scancode_F10		= 0x6d,
	scancode_F12		= 0x6f,
	scancode_Pause		= 0x71,
	scancode_Insert		= 0x72,
	scancode_Home		= 0x73,
	scancode_PageUp		= 0x74,
	scancode_Del		= 0x75,
	scancode_F4		= 0x76,
	scancode_End		= 0x77,
	scancode_F2		= 0x78,
	scancode_PageDown	= 0x79,
	scancode_F1		= 0x7a,
	scancode_Left		= 0x7b,
	scancode_Right		= 0x7c,
	scancode_Down		= 0x7d,
	scancode_Up		= 0x7e,


	scancode_Last		= 0x80,
} scancodes_t;

extern void keyboard_get_scancode(int *modifiers, int *code);
extern int keyboard_convert_scancode(int modifiers, int scancode);
extern int keyboard_keypressed(void);
extern int keyboard_getchar();
