# -*- coding: utf-8 -*-
'''a module to define abstract stock elements'''

#   This file is part of emesene.
#
#    Emesene is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    emesene is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with emesene; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
ACCEPT = 1
ADD = 2
APPLY = 3
BACK = 4
BOLD = 5
CANCEL = 6
CLEAR = 7
CLOSE = 8
CONNECT = 9
DELETE = 10
DISCONNECT = 11
DOWN = 12
EDIT = 13
ERROR = 14
FORWARD = 15
INFORMATION = 16
ITALIC = 17
NEW = 18
NO = 19
OK = 20
OPEN = 21
PREFERENCES = 22
PROPERTIES = 23
QUESTION = 24
QUIT = 25
REFRESH = 26
REMOVE = 27
SAVE = 28
SELECT_COLOR = 29
SELECT_FONT = 30
STOP = 31
STRIKE = 32
UNDERLINE = 33
UP = 34
WARNING = 35
YES = 36
ABOUT = 37
COPY = 38

def map_stock(stock_id):
    '''map the abstract stock to a stock object of the toolkit, it doesn't 
    need to be implemented if the toolkit doesnt't use stock identifiers'''
    raise NotImplementedError

