/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.GroutAlignJFrameEvent;
import org.emboss.jemboss.editor.GroutAlignJFrameListener;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollection;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionEvent;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionListener;
import org.emboss.jemboss.editor.GroutSequenceJPanel;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceProperties;

public class GroutAlignJFrame
extends AlignJFrame
implements GroutGraphicSequenceCollectionListener {
    private Vector targets = new Vector();
    private int position = 0;

    public GroutAlignJFrame(Vector vseqs, Vector indents) {
        if (vseqs != null && vseqs.size() > 0) {
            this.openMethod(vseqs, indents);
        }
        this.addMenuItems();
    }

    public GroutAlignJFrame(Vector vseqs) {
        super(vseqs);
        this.addMenuItems();
    }

    public GroutAlignJFrame(File seqFile) {
        super(seqFile);
        this.addMenuItems();
    }

    public GroutAlignJFrame(String seqString, String name) {
        super(seqString, name);
        this.addMenuItems();
    }

    public GroutAlignJFrame() {
        super(false);
        this.addMenuItems();
    }

    public GroutAlignJFrame(boolean useExitMenu) {
        super(useExitMenu);
    }

    protected void openMethod(Vector seqVector) {
        gsc = new GroutGraphicSequenceCollection(seqVector, this.jspSequence, true, false, true, true, statusField);
        ((GroutGraphicSequenceCollection)gsc).addGroutGraphicSequenceCollectionListener(this);
        gsc.setColorScheme(SequenceProperties.residueColor);
        this.currentColour = (Hashtable)SequenceProperties.residueColor.clone();
        this.residueColor.setSelected(true);
        this.jspSequence.setViewportView(gsc);
        this.colourScheme("Residue colour");
    }

    protected void openMethod(Vector seqVector, Vector indents) {
        gsc = new GroutGraphicSequenceCollection(seqVector, indents, this.jspSequence, true, false, true, true, statusField);
        if (seqVector.size() > 1) {
            gsc.drawNumber();
        }
        ((GroutGraphicSequenceCollection)gsc).addGroutGraphicSequenceCollectionListener(this);
        gsc.setColorScheme(SequenceProperties.residueColor);
        this.currentColour = (Hashtable)SequenceProperties.residueColor.clone();
        this.residueColor.setSelected(true);
        this.jspSequence.setViewportView(gsc);
        this.colourScheme("Residue colour");
    }

    public synchronized void addGroutAlignJFrameListener(GroutAlignJFrameListener listener) {
        this.targets.addElement(listener);
    }

    public synchronized void removeGroutAlignJFrameListener(GroutAlignJFrameListener listener) {
        this.targets.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTargets(String propertyName, Object oldValue, Object newValue) {
        Vector l;
        GroutAlignJFrameEvent s = new GroutAlignJFrameEvent(this, propertyName, oldValue, newValue);
        GroutAlignJFrame groutAlignJFrame = this;
        synchronized (groutAlignJFrame) {
            l = (Vector)this.targets.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            GroutAlignJFrameListener sl = (GroutAlignJFrameListener)l.elementAt(i);
            sl.groutAlignJFrameChanged(s);
        }
    }

    public void setPosition(int position) {
        ((GroutGraphicSequenceCollection)gsc).setPosition(position);
        this.position = position;
    }

    public void setIndents(Vector indents) {
        ((GroutGraphicSequenceCollection)gsc).doIndent(indents);
    }

    protected void addWindowCloser() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GroutAlignJFrame.this.notifyTargets("windowClosed", new Boolean(false), new Boolean(true));
                GroutAlignJFrame.this.dispose();
            }

            public void windowOpened(WindowEvent evt) {
                GroutAlignJFrame.this.setPosition(GroutAlignJFrame.this.position);
                GroutSequenceJPanel sequenceJPanel = (GroutSequenceJPanel)AlignJFrame.gsc.getGraphicSequence().elementAt(0);
                if (sequenceJPanel != null) {
                    sequenceJPanel.drawCentreMarker(sequenceJPanel.getGraphics());
                }
                int height = ((GroutGraphicSequenceCollection)AlignJFrame.gsc).setSize();
                Dimension size = GroutAlignJFrame.this.jspSequence.getPreferredSize();
                Dimension size2 = GroutAlignJFrame.this.jspSequence.getHorizontalScrollBar().getPreferredSize();
                size.height = height + size2.height + 4;
                GroutAlignJFrame.this.jspSequence.setPreferredSize(size);
                GroutAlignJFrame.this.pack();
            }
        });
    }

    private void addMenuItems() {
        JMenu groutMenu = new JMenu("Grout Menu");
        JMenuItem newAlignFrame = new JMenuItem("new Align Frame");
        newAlignFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroutAlignJFrame.this.notifyTargets("newAlignJFrame", new Boolean(false), new Boolean(true));
            }
        });
        groutMenu.add(newAlignFrame);
        final JCheckBoxMenuItem jumpTo = new JCheckBoxMenuItem("Jump to nearest alignment");
        jumpTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroutAlignJFrame.this.notifyTargets("JumpToNearestAlignment", new Boolean(!jumpTo.getState()), new Boolean(jumpTo.getState()));
            }
        });
        groutMenu.add(jumpTo);
        this.menuBar.add(groutMenu);
    }

    public void groutGraphicSequenceCollectionChanged(GroutGraphicSequenceCollectionEvent e) {
        this.notifyTargets(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public static void main(String[] args) {
        Vector<Integer> indents = new Vector<Integer>();
        Vector<Sequence> seqs = new Vector<Sequence>();
        Sequence s = new Sequence("Seq2", "ggcagcttaagccaaacattcccaaatctatgaagcagggcccattgttggtcagttgttatttgcaatgaagcacagttctgatcatgtttaaagtggaggcacgcagggcaggagtgcttgagcccaagcaaaggatggaaaaaaataagcctttgttgggtaaaaaaggactgtctgagactttcatttgttctgtgcaacatataagtcaatacagataagtcttcctctgcaaacttcactaaaaagcctgggggttctggcagtctagattaaaatgcttgcacatgcagaaacctctggggacaaagacacacttccactgaattatactctgctttaaaaaaatccccaaaagcaaatgatcagaaatgtagaaattaatggaaggatttaaacatgaccttctcgttcaatatctactgttttttagttaaggaattacttgtgaacagataattgagattcattgctccggcatgaaatatactaataattttattccaccagagttgctgcacatttggagacaccttcctaagttgcagtttttgtatgtgtgcatgtagttttgttcagtgtcagcctgcactgcacagcagcacatttctgcaggggagtgagcacacatacgcactgttggtacaattgccggtgcagacatttctacctcctgacattttgcagcctacattccctgagggctgtgtgctgagggaactgtcagagaagggctatgtgggagtgcatgccacagctgctggctggcttacttcttccttctcgctggctgtaatttccaccacggtcaggcagccagttccggcccacggttctgttgtgtagacagcagagactttggagacccggatgtcgcacgccaggtgcaagaggtgggaatgggagaaaaggagtgacgtgggagcggagggtctgtatgtgtgcacttgggcacgtatatgtgtgctctgaaggtcaggattgccagggcaaagtagcacagtctggtatagtctgaagaagcggctgctcagctgcagaagccctctggtccggcaggatgggaacggctgccttgccttctgcccacaccctagggacatgagctgtccttccaaacagagctccaggcactctcttggggacagcatggcaggctctgtgtggtagcagtgcctgggagttggccttttactcattgttgaaataatttttgtttattatttatttaacgatacatatatttatatatttatcaatggggtatctgcagggatgttttgacaccatcttccaggatggagattatttgtgaagacttcagtagaatcccaggactaaacgtctaaattttttctccaaacttgactgacttgggaaaaccaggtgaatagaataagagctgaatgttttaagtaataaacgttcaaactgctctaagtaaaaaaatgcattttactgcaatgaatttctagaatatttttcccccaaagctatgcctcctaacccttaaatggtgaacaactggtttcttgctacagctcactgccatttcttcttactatcatcactaggtttcctaagattcactcatacagtattatttgaagattcagctttgttctgtgaatgtcatcttaggattgtgtctatattcttttgcttatttctttttactctgggcctctcatactagtaagattttaaaaagccttttcttctctgtatgtttggctcaccaaggcgaaatatatattcttctctttttcatttctcaagaataaacctcatctgcttttttgtttttctgtgttttggcttggtactgaatgactcaactgctcggttttaaagttcaaagtgtaagtacttagggttagtactgcttatttcaataatgttgacggtgactatctttggaaagcagtaacatgctgtcttagaaatgacattaataatgggcttaaacaaatgaataggggggtccccccactctccttttgtatgcctatgtgtgtctgatttgttaaaagatggacagggaattgattgcagagtgtcgcttccttctaaagtagttttattttgtctactgttagtatttaaagatcctggaggtggacataaggaataaatggaagagaaaagtagatattgtatggtggctactaaaaggaaattcaaaaagtcttagaacccgagcacctgagcaaactgcagtagtcaaaatatttatctcatgttaaagaaaggcaaatctagtgtaagaaatgagtaccatatagggttttgaagttcatatactagaaacacttaaaagatatcatttcagatattacgtttggcattgttcttaagtatttatatctttgagtcaagctgataattaaaaaaaatctgttaatggagtgtatatttcataatgtatcaaaatggtgtctatacctaaggtagcattattgaagagagatatgtttatgtagtaagttattaacataatgagtaacaaataatgtttccagaagaaaggaaaacacattttcagagtgcgtttttatcagaggaagacaaaaatacacacccctctccagtagcttatttttacaaagccggcccagtgaattagaaaaacaaagcacttggatatgatttttggaaagcccaggtacacttattattcaaaatgcacttttactg");
        Sequence s1 = new Sequence("Seq1a", "ACTATACAGAGTAGACTgTATAGAtTATAAGCGACATACGAGAGACGAC");
        s1.reverseSequence();
        seqs.add(s1);
        seqs.add(s);
        indents.add(new Integer(10));
        indents.add(new Integer(0));
        new GroutAlignJFrame(seqs, indents);
    }

    class winExit
    extends WindowAdapter {
        winExit() {
        }

        public void windowClosing(WindowEvent we) {
            GroutAlignJFrame.this.dispose();
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

