/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.FileProperties;
import jalview.MSFfile;
import jalview.MailProperties;
import jalview.NJTree;
import jalview.OutputGenerator;
import jalview.PostscriptPopup;
import jalview.PostscriptProperties;
import jalview.Sequence;
import jalview.TreeThreadCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;

public class TreePanel
extends Panel {
    NJTree njt;
    Object parent;
    Panel p;
    Button close;
    Button output;
    Checkbox cb;
    TreeThreadCanvas mc;
    Choice f;
    MailProperties mp;
    FileProperties fp;
    PostscriptProperties pp;
    Vector selected;

    public TreePanel(Object object, NJTree nJTree) {
        this.njt = nJTree;
        this.parent = object;
        this.treeInit();
    }

    public TreePanel(Object object, Sequence[] sequenceArray, String string, String string2) {
        this.njt = new NJTree(sequenceArray, string, string2);
        if (object instanceof AlignFrame) {
            ((AlignFrame)object).status.setText("Finished calculating tree");
            ((AlignFrame)object).status.validate();
        }
        this.parent = object;
        this.treeInit();
    }

    public TreePanel(Object object, Sequence[] sequenceArray) {
        this(object, sequenceArray, "AV", "PID");
    }

    public void treeInit() {
        this.setLayout(new BorderLayout());
        this.p = new Panel();
        Panel panel = new Panel();
        this.p.setLayout(new BorderLayout());
        panel.setLayout(new FlowLayout());
        this.close = new Button("Close");
        this.output = new Button("Output");
        this.cb = new Checkbox("Show distances");
        this.cb.setState(false);
        Label label = new Label("Font size");
        this.f = new Choice();
        this.f.addItem("6");
        this.f.addItem("8");
        this.f.addItem("10");
        this.f.addItem("12");
        this.f.addItem("14");
        this.f.select("8");
        this.njt.tf.setFontSize(8);
        this.njt.tf.showDistances = false;
        this.njt.tf.reCount(this.njt.tf.top);
        this.njt.tf.findHeight(this.njt.tf.top);
        this.mc = new TreeThreadCanvas(this.njt.tf);
        this.mc.setBackground(Color.white);
        if (this.parent instanceof OutputGenerator) {
            this.njt.tf.mp.server = ((OutputGenerator)this.parent).getMailProperties().server;
        }
        this.p.add("Center", this.mc);
        panel.add(label);
        panel.add(this.f);
        panel.add(this.cb);
        panel.add(this.close);
        panel.add(this.output);
        this.add("Center", this.p);
        this.add("South", panel);
        if (this.parent instanceof AlignFrame) {
            this.selected = ((AlignFrame)this.parent).ap.sel;
            this.njt.tf.selected = ((AlignFrame)this.parent).ap.sel;
            return;
        }
        this.selected = new Vector();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.target == this.mc) {
            Object object = this.njt.tf.findElement(this.mc, n, n2);
            if (object instanceof Sequence) {
                Sequence sequence = (Sequence)object;
                System.out.println(sequence.name);
                if (this.selected.contains(sequence)) {
                    this.selected.removeElement(sequence);
                } else {
                    this.selected.addElement(sequence);
                }
                if (this.parent instanceof AlignFrame) {
                    AlignFrame alignFrame = (AlignFrame)this.parent;
                    alignFrame.ap.idPanel.idCanvas.paintFlag = true;
                    alignFrame.ap.idPanel.idCanvas.repaint();
                    if (alignFrame.pca != null) {
                        alignFrame.pca.p.rc.redrawneeded = true;
                        alignFrame.pca.p.rc.repaint();
                    }
                }
                this.mc.repaint();
            } else if (this.njt.tf.maxheight != 0.0f) {
                float f = (float)(n - this.njt.tf.offx) / (float)((double)this.size().width * 0.8 - (double)(2 * this.njt.tf.offx));
                System.out.println("New threshold = " + f);
                this.mc.threshold = n;
                this.mc.paint(this.mc.getGraphics());
                if (this.parent instanceof AlignFrame) {
                    AlignFrame alignFrame = (AlignFrame)this.parent;
                    alignFrame.regroup(f);
                }
            }
        }
        return true;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.f) {
            int n = Integer.parseInt(this.f.getSelectedItem());
            this.njt.tf.setFontSize(n);
            this.mc.repaint();
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.close && event.id == 1001) {
            this.hide();
            if (this.getParent() instanceof Frame) {
                ((Frame)this.getParent()).dispose();
            }
            return true;
        }
        if (event.target == this.output && event.id == 1001) {
            if (this.parent instanceof Frame) {
                new PostscriptPopup((Frame)this.parent, "Mail postscript", this.njt.tf);
            }
            return true;
        }
        if (event.target == this.cb) {
            this.njt.tf.showDistances = this.cb.getState();
            this.mc.repaint();
            if (this.parent instanceof Frame) {
                ((Frame)this.parent).validate();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public void show() {
        super.show();
        this.njt.tf.draw(this.p.getGraphics(), 500, 500);
    }

    public static void main(String[] stringArray) {
        try {
            MSFfile mSFfile = new MSFfile(stringArray[0], "File");
            Sequence[] sequenceArray = new Sequence[mSFfile.seqs.size()];
            int n = 0;
            while (n < mSFfile.seqs.size()) {
                sequenceArray[n] = (Sequence)mSFfile.seqs.elementAt(n);
                ++n;
            }
            Frame frame = new Frame("Average distance tree");
            TreePanel treePanel = new TreePanel((Object)frame, sequenceArray);
            frame.setLayout(new BorderLayout());
            frame.add("Center", treePanel);
            frame.resize(500, 500);
            frame.show();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception : " + iOException);
            return;
        }
    }
}

