#ifndef __RMIME_H__
#define __RMIME_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdlib.h>

#include "mime.h"
#include "memchunk.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/

extern rmime_t *rmime_create_size (size_t size);
extern rmime_t *rmime_create (void);
extern void     rmime_destroy (rmime_t *ptr);
extern void     rmime_add (rmime_t *ptr, mime_t *x);
extern void     rmime_remove (rmime_t *ptr, unsigned index);
extern void     rmime_shrink (rmime_t *ptr);
extern rmime_t *rmime_join (rmime_t *x, rmime_t *y);
extern void     rmime_dump (memchunk_t *memchunk, rmime_t *ptr);
extern rmime_t *rmime_read (memchunk_t *memchunk);

/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER rmime.h
 *
 ****************************************************************************/
#endif
