package de.lmu.ifi.dbs.elki.data.synthetic.bymodel.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2011
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Interface for a simple distribution generator
 * with a PDF, i.e. it can also compute a density
 * 
 * @author Erich Schubert
 */
public interface Distribution {
  /**
   * Generate a new random value
   * @return new generated value
   */
  public double generate();
  /**
   * Return the density of an existing value
   * @param val existing value
   * @return distribution density
   */
  public double explain(double val);
  
  /**
   * Describe the generator
   * @return description
   */
  @Override
  public String toString();
}
