#-*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import os
import platform

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import plugin, component
from elisa.extern.translation import gettexter, Translator

tests_dir = os.path.dirname(__file__)

class TestAPlugin(plugin.Plugin):
    name = "test"
    config_file = os.path.join(tests_dir, "data","test_plugin.conf")

TestAPlugin.directory = os.path.join(tests_dir, "data")


class TestPlugin(ElisaTestCase):

    def test_instanciation(self):
        """
        """
        TestAPlugin.load_config()
        TestAPlugin.initialize()
        t = TestAPlugin()
        self.failUnless(t)

    def test_platform(self):
        
        platfrm = platform.system().lower()
        if platfrm == 'linux':
            other_platform = 'windows'
        elif platfrm == 'windows':
            other_platform = 'linux'
        else:
            other_platform = 'linux'
        
        components = {'foo_component': {'path': 'elisa.tests.test_component:FooComponent',
                                        'description': 'To access file:// media',
                                        'name': 'foo_component',
                                        'platforms': [other_platform,]}}

        TestAPlugin.load_config()
        # override components
        TestAPlugin.components = components

        self.assertRaises(component.UnSupportedPlatform,
                          TestAPlugin.check_component_dependencies,
                          'foo_component')

    def test_deps(self):
        components = {'foo_component': {'path': 'elisa.tests.test_component:FooComponent',
                                        'description': 'To access file:// media',
                                        'name': 'foo_component',
                                        'external_dependencies': ['elisarock',]
                                        }
                      }

        TestAPlugin.load_config()
        # override components
        TestAPlugin.components = components

        self.assertRaises(component.UnMetDependency,
                          TestAPlugin.check_component_dependencies,
                          'foo_component')

    def test_i18n_loading(self):
        translator = Translator()
        TestAPlugin.load_config()
        TestAPlugin.load_translations(translator)

        T_ = gettexter('elisa-test')

        artist = T_('By Artist') #deu3
        album = T_('By Album') #deu
        dvd = T_('DVD') # deu2

        artist_t = translator.translateTranslatable(artist, ['deu3'])
        album_t = translator.translateTranslatable(album, ['deu'])
        dvd_t = translator.translateTranslatable(dvd, ['deu2'])

        self.assertEquals(artist_t, u'Nach Künstler2')
        self.assertEquals(album_t, u'Nach Album')
        self.assertEquals(dvd_t, u'Video DVD')

    def test_invalid_component_name(self):
        components = {'test': {'path': 'elisa.tests.test_component:FooComponent',
                               'description': 'To access file:// media',
                               'name': 'test',
                               }
                      }

        TestAPlugin.load_config()
        # override components
        TestAPlugin.components = components
        self.assertRaises(component.InitializeFailure, TestAPlugin.initialize)
        
