# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
This module provides access to the singleton application and a L{boot}
function which initializes the global application execution
environment.

@var  application: the Elisa application
@type application: L{elisa.core.application.Application}
@var booted:       has execution environment been initialized by calling L{boot}?
@type booted:      bool
"""

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

import sys

application = None

def set_application(app):
    """
    Set the L{application} singleton's value. Overrides previous value.

    @param app: the new singleton's value
    @type app:  L{Application}
    """
    global application
    application = app

booted = False
from_test = False

def boot():
    """
    Initializes the global application execution. Can't be called more
    than once.

    - install Twisted's glib2reactor
    - initialize the logging framework
    - clean namespace regarding pygst import

    """
    global booted
    global from_test
    log_to_file = False

    if not booted:
        #FIXME : BAD HACK to disable the reactor installation in test mode 
        if not from_test:
            try:
                #FIXME glib2reactor does not works with unittest
                from twisted.internet import glib2reactor
                glib2reactor.install()
            except AssertionError:
                pass
        
        from elisa.core import log

        if 'gst' in sys.modules:
            del sys.modules['gst']

        import pygst
        pygst.require('0.10')
        
        if '-l' in sys.argv:
            log_to_file = True

        log.init(log_to_file)
        log.logTwisted()

        booted = True
