#*******************************************************************************
# Copyright (c) 2009 Tasktop Technologies and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
#      Tasktop Technologies - initial API and implementation
#*******************************************************************************
#!/bin/bash -e

help() {
  echo "usage: sign-update-site.sh major build"
  echo "                           local"
  exit 1
}

if [ $# -eq 0 ]
then
 help
fi

if [ "$1" == "local" ]
then
 BUILD_ROOT=$(cd $(dirname $0); pwd)
 source $BUILD_ROOT/local.sh
else
 if [ $# -lt 2 ]
 then
  help
 fi

 MAJOR_VERSION=$1
 QUALIFIER=$2
fi

SRC=/home/data/httpd/download.eclipse.org/tools/mylyn/update-archive/$MAJOR_VERSION/$QUALIFIER
DST=/opt/public/download-staging.priv/tools/mylyn
OUT=$DST/output
TMP=$DST/tmp/$MAJOR_VERSION.$QUALIFIER
JAVA_HOME=/shared/tools/mylyn/tools/jdk
ECLIPSE_HOME=/shared/tools/mylyn/eclipse

unzip() {
 /bin/rm -R $TMP/$1 || true
 /bin/mkdir -p $TMP/$1
 if [ "$1" == "standard" ]
 then
  /usr/bin/unzip -d $TMP/$1 $SRC/mylyn-$MAJOR_VERSION.$QUALIFIER.zip
 else
  /usr/bin/unzip -d $TMP/$1 $SRC/mylyn-$MAJOR_VERSION.$QUALIFIER-$1.zip
 fi
}

rezip() {
 cd $TMP/$1
 echo Rezipping archive for $1, output is logged to $DST/sign.log
 if [ "$1" == "standard" ]
 then
  /usr/bin/zip $TMP/mylyn-$MAJOR_VERSION.$QUALIFIER.zip -r . >> $DST/sign.log
 else
  /usr/bin/zip $TMP/mylyn-$MAJOR_VERSION.$QUALIFIER-$1.zip -r . >> $DST/sign.log
 fi 
}

pack() {
DIR=$TMP/$1
$JAVA_HOME/bin/java \
 -Xmx512m \
 -jar $ECLIPSE_HOME/plugins/org.eclipse.equinox.launcher_*.jar \
 -application org.eclipse.update.core.siteOptimizer \
 -jarProcessor -verbose -processAll -repack -pack \
 -digestBuilder -digestOutputDir=$DIR -siteXML=$DIR/site.xml \
 -outputDir $DIR $DIR

echo Processing $DIR
rm -f $DIR/artifacts.jar $DIR/content.jar
$JAVA_HOME/bin/java \
 -Xmx512m \
 -jar $ECLIPSE_HOME/plugins/org.eclipse.equinox.launcher_*.jar \
 -application org.eclipse.equinox.p2.metadata.generator.EclipseGenerator \
 -updateSite $DIR \
 -site file:$DIR/site.xml \
 -metadataRepository file:$DIR \
 -metadataRepositoryName "$2 "\
 -artifactRepository file:$DIR \
 -artifactRepositoryName "$2" \
 -compress \
 -reusePack200Files \
 -noDefaultIUs
}

fixpermissions() {
DIR=$1
/bin/chgrp -R mylynadmin $DIR
/bin/chmod g+w -R $DIR
/bin/chmod o+r -R $DIR
/usr/bin/find $DIR -type d | xargs chmod +x
}

if [ ! -e $TMP ]
then

 # extract site

 /bin/rm $TMP || true
 unzip standard
 #unzip extras
 unzip incubator

 echo Creating archive for signing, output is logged to $DST/sign.log
 /bin/rm $DST/mylyn.zip || true
 cd $TMP
 /usr/bin/find -name "org.eclipse*mylyn*.jar" | zip $DST/mylyn.zip -@ > $DST/sign.log

 # sign

 mkdir -p $OUT
 /bin/rm $OUT/mylyn.zip || true
 /usr/bin/sign $DST/mylyn.zip nomail $OUT
fi

I=0
while [ $I -lt 30 ] && [ ! -e $OUT/mylyn.zip ]; do
  echo Waiting for $OUT/mylyn.zip
  sleep 45
  let I=I+1
done

if [ ! -e $OUT/mylyn.zip ]
then
  echo
  echo Signing Failed: Timeout waiting for $OUT/mylyn.zip
  exit 1
fi

# repack site

echo Unzipping signed files, output is logged to $DST/sign.log
/usr/bin/unzip -o -d $TMP $OUT/mylyn.zip >> $DST/sign.log

pack standard "Mylyn for Eclipse 3.5, 3.6 and 3.7"
#pack extras "Mylyn Extras"
pack incubator "Mylyn Incubator"

fixpermissions $TMP

rezip standard
#rezip extras
rezip incubator

# republish

/bin/mv $SRC $SRC-DELETE
# other zip files are overridden here with signed versions
mv $TMP/standard $TMP/e3.4
/bin/cp -av $TMP $SRC
# recover wikitext-standalone zip and other archives
/bin/cp -v $SRC-DELETE/mylyn-wikitext-standalone-*.zip $SRC
fixpermissions $SRC
rm -R $SRC-DELETE

# clean up
/bin/rm -R $TMP || true
