#include <iostream>

#include "parameter_list.h"

ParameterList::~ParameterList() {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		delete *it;
	}
}

void ParameterList::addParameter(const string &param_name, int param_type, void *bind_variable) {
	parameter_list.push_back(new ParameterDefinition(param_name, param_type, bind_variable));
}

void ParameterList::setParameter(const string &param_name, const string &param_value) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			switch(pd->param_type) {
			case PARAM_TYPE_INT:	*(int*)(pd->bind_variable)=atoi(param_value.c_str()); break;
			case PARAM_TYPE_DOUBLE: *(double*)(pd->bind_variable)=atof(param_value.c_str()); break;
			case PARAM_TYPE_STRING: *(string*)(pd->bind_variable)=param_value; break;
			}
			return;
		}
	}
	cerr<<"unknown parameter '"<<param_name<<"'"<<endl;
}

void ParameterList::setParameter(const string &param_name, int param_value) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			*(int*)(pd->bind_variable)=param_value;
			return;
		}
	}
	cerr<<"unknown parameter '"<<param_name<<"'"<<endl;
}

void ParameterList::setParameter(const string &param_name, double param_value) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			*(double*)(pd->bind_variable)=param_value;
			return;
		}
	}
	cerr<<"unknown parameter '"<<param_name<<"'"<<endl;
}

string ParameterList::parameterAsString(const string &param_name) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			return *(string*)(pd->bind_variable);
		}
	}
	return "";
}

int ParameterList::parameterAsInt(const string &param_name) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			return *(int*)(pd->bind_variable);
		}
	}
	return 0;
}

double ParameterList::parameterAsDouble(const string &param_name) {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		if(pd->param_name==param_name) {
			return *(double*)(pd->bind_variable);
		}
	}
	return 0.0;
}

void ParameterList::listParameters() {
	list<ParameterDefinition*>::iterator it;
	for(it=parameter_list.begin(); it!=parameter_list.end(); it++) {
		ParameterDefinition *pd=*it;
		cerr<<pd->param_name<<"\t\t\t";
		switch(pd->param_type) {
		case PARAM_TYPE_INT:	cerr<<": integer value"; break;
		case PARAM_TYPE_DOUBLE: cerr<<": floating point value"; break;
		case PARAM_TYPE_STRING: cerr<<": string value"; break;
		}
		cerr<<endl;
	}
}
