// Standard Unix includes
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

// The libs I use
#include <mysql/mysql.h>
#include <dotconf.h>
#include <auth-client.h>
#include <libesmtp.h>

// My includes
#include "message.h"	// Read stdin and message analysis
#include "log.h"
#include "global.h"	// loaded config file structure and extern stdin/out
#include "config_file.h"	// Lib-dot-conf loading and parsing functions
#include "my_strings.h"	// string manipulation (addSlashes() and so on)
#include "smtp.h"	// Lib esmtp send mail function
#include "sql_query.h"	// MySQL implementation

void reject(char* message){
	mysql_cleanUp();

	LOG("Denying message.............done!\n\n");
	fprintf(stderr,"iGlobalWall spam checker rejected message %s",message);
	exit(31);
}

void deferal(char* message){
	mysql_cleanUp();

	LOG("Deffering message...........done!\n\n");
	fprintf(stderr,"iGlobalWall spam checker defered message %s\n",message);
	exit(2);
}

void autorize(){
	mysql_cleanUp();

	LOG("Autorising message..........done!\n\n");
	fprintf(stderr,"iGlobalWall spam checker autorised message\n");
	exit(0);
}

// Error codes:
// 11 : address too long
// 31 : Permanentely refuse to send the message
// All other: temporary errors
// 51 : out of memeory
// 52 : timeout
// 53 : write error
// 55 : enable to read a configuration file
// 56 : problem to make a network connection from this host
// 61 : problem with the qmail home directory
// 62 : problem with the queue directory
// 63 : problem with the queue/pid directory
// 64 : problem with the queue/mess
// 65 : problem with the queue/intd
// 66 : problem with the queue/todo
// 71 : Mail  server  temporarily refuses to send the message to any recipients.
// 72 : Connection to mail server timed out.   (Not  used  by qmail-queue.)
// 73 : Connection  to  mail  server  rejected.  (Not used by qmail-queue.)
// 74 : Connection to mail server succeeded,  but  communication failed.  (Not used by qmail-queue.)
// 81 : Internal bug; e.g., segmentation fault.
// 91 : Envelope format error.

int main(int argc,char* argv[]){
	tErr err;
	tMsg msg;	// The incoming message object (parsed from stdin)
	LOG("Reading conf file...........");
	read_config_file();
	LOG("done!\n");

	LOG("Connecting to mysql.........");
	do_ze_mysql_connect();
	LOG("done!\n");


 	LOG("Parsing message header......");
	err = initMessage(&msg);
	if(err != noErr){
		LOG("Error while parsing header.");
		exit(1);
	}else{
		LOG("done!\n");
	}

	LOG("Checking from field.........");
	if(strstr(msg.m_head->m_From_feild,"iglobalwalldaemon@iglobalwall.com") != 0){
		LOG("[igw]Accepting message: from spam daemon.");
		exit(0);
		return(0);
	}else{
		LOG("not from igwdaemon\n");
	}

//	fprintf(stderr,"[igw]login:%s/srv:%s/",
//msg->m_head->m_fetchmail_username,msg->m_head->m_fetchmail_server_addr);
	if(isInWhitelist(msg.m_head->m_iWall_user,msg.m_head->m_fetchmail_username,msg.m_head->m_fetchmail_server_addr,msg.m_head->m_From_feild)!=NULL){
		LOG("[igw]Accepting message: from address recognised in whitelist.");
		exit(0);
	}
	exit(1);
	return(1);
}
