#ifndef __HEADER_H__
#define __HEADER_H__

#ifndef __GLOBAL_H__
#include "global.h"
#endif

#define MAX_HEADER_LINE 1024

typedef struct{
// Some global infos for our object
	unsigned long m_headerSize;
	unsigned int m_headerNumLines;

// Vars founded out of header data (duplicates to be freed at object destroy)
	char* m_fetchmail_server_addr;
	char* m_fetchmail_username;
	char* m_iWall_user;
	char* m_fetchmail_email_addr;	// This one is guessed by the 3 first in DB (table mailbox)

// raw header buffer pointer, terminated by \r\n\r\n\0
// later on execution all \r\n at end of line are replaced by \0\n
	char* m_buffer;
// Direct pointers to fields inside m_buffer (no malloc)
	char* m_From_feild;
	char* m_To_feild;
	char* m_Cc_feild;
	char* m_Bcc_feild;
	char* m_ReturnPath_feild;
	char* m_DeliveredTo_feild;
	char* m_Subject_feild;

	char** m_msgbuf;	// pointer to pointer to row message buffer (in fact pointer to message object pointer to allow call to realloc())
	long unsigned* m_msgsize;	// Same, but size

// 2 usefull table to allow fast access to the header field
	unsigned int m_headerLines[MAX_HEADER_LINE];
	unsigned int m_headerLinesSize[MAX_HEADER_LINE];
}header;
tErr initHeader(header* head,char** message,long unsigned* curSize);
void destroyHeader(header* head);
tErr countLines(header* head,char* message,long unsigned size);
tErr getHeaderFields(header* head);


#endif // __HEADER_H__
