
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         DRIZZLEparse
#define yylex           DRIZZLElex
#define yyerror         DRIZZLEerror
#define yylval          DRIZZLElval
#define yychar          DRIZZLEchar
#define yydebug         DRIZZLEdebug
#define yynerrs         DRIZZLEnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 23 "sql_yacc.yy"

/* session is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (Session*) when used.
** Use the YYSession macro for this.
*/
#define YYPARSE_PARAM yysession
#define YYLEX_PARAM yysession
#define YYSession (static_cast<Session *>(yysession))

#define YYENABLE_NLS 0
#define YYLTYPE_IS_TRIVIAL 0

#define DRIZZLE_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYSession->lex)

#include "config.h"
#include <cstdio>
#include "drizzled/parser.h"

int yylex(void *yylval, void *yysession);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (drizzled::my_yyoverflow((B), (D), &val)) \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define DRIZZLE_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYSession);\
    YYABORT;                                  \
  } while (0)

#define DRIZZLE_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };\
    my_parse_error(&pass);\
    DRIZZLE_YYABORT;                      \
  }


#define YYDEBUG 0

namespace drizzled
{

class Table_ident;
class Item;
class Item_num;


static bool check_reserved_words(LEX_STRING *name)
{
  if (!my_strcasecmp(system_charset_info, name->str, "GLOBAL") ||
      !my_strcasecmp(system_charset_info, name->str, "LOCAL") ||
      !my_strcasecmp(system_charset_info, name->str, "SESSION"))
    return true;
  return false;
}

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

struct my_parse_error_st {
  const char *s;
  Session *session;
};

static void my_parse_error(void *arg)
{
 struct my_parse_error_st *ptr= (struct my_parse_error_st *)arg;

  const char *s= ptr->s;
  Session *session= ptr->session;

  Lex_input_stream *lip= session->m_lip;

  const char *yytext= lip->get_tok_start();
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use DRIZZLE_YYABORT/DRIZZLE_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup.
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and DRIZZLE_YYABORT
  to abort from the parser.
*/

static void DRIZZLEerror(const char *s)
{
  Session *session= current_session;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the Session.
  */
  LEX::cleanup_lex_after_parse_error(session);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);

  struct my_parse_error_st pass= { s, session };
  my_parse_error(&pass);
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param session the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
static Item* handle_sql2003_note184_exception(Session *session,
                                              Item* left, bool equal,
                                              Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      Select_Lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (session->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(session, result);

      return(result);
    }
  }

  if (equal)
    result= new (session->mem_root) Item_func_eq(left, expr);
  else
    result= new (session->mem_root) Item_func_ne(left, expr);

  return(result);
}

/**
   @brief Creates a new Select_Lex for a UNION branch.

   Sets up and initializes a Select_Lex structure for a query once the parser
   discovers a UNION token. The current Select_Lex is pushed on the stack and
   the new Select_Lex becomes the current one..=

   @lex The parser state.

   @is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
static bool add_select_to_union_list(Session *session, LEX *lex, bool is_union_distinct)
{
  if (lex->result)
  {
    /* Only the last SELECT can have  INTO...... */
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return true;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), session };
    my_parse_error(&pass);
    return true;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return true;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return false;
}

/**
   @brief Initializes a Select_Lex for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
static bool setup_select_in_parentheses(Session *session, LEX *lex)
{
  Select_Lex * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), session };
    my_parse_error(&pass);
    return true;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), session };
    my_parse_error(&pass);
    return true;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return true;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return false;
}

static Item* reserved_keyword_function(Session *session, const std::string &name, List<Item> *item_list)
{
  const plugin::Function *udf= plugin::Function::get(name.c_str(), name.length());
  Item *item= NULL;

  if (udf)
  {
    item= Create_udf_func::s_singleton.create(session, udf, item_list);
  } else {
    my_error(ER_SP_DOES_NOT_EXIST, MYF(0), "FUNCTION", name.c_str());
  }

  return item;
}

} /* namespace drizzled; */

using namespace drizzled;


/* Line 189 of yacc.c  */
#line 399 "drizzled/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACTION = 259,
     ADD = 260,
     ADDDATE_SYM = 261,
     AFTER_SYM = 262,
     AGGREGATE_SYM = 263,
     ALL = 264,
     ALTER = 265,
     ANALYZE_SYM = 266,
     AND_SYM = 267,
     ANY_SYM = 268,
     AS = 269,
     ASC = 270,
     ASENSITIVE_SYM = 271,
     AT_SYM = 272,
     AUTO_INC = 273,
     AVG_ROW_LENGTH = 274,
     AVG_SYM = 275,
     BEFORE_SYM = 276,
     BEGIN_SYM = 277,
     BETWEEN_SYM = 278,
     BIGINT_SYM = 279,
     BINARY = 280,
     BIN_NUM = 281,
     BIT_SYM = 282,
     BLOB_SYM = 283,
     BOOLEAN_SYM = 284,
     BOOL_SYM = 285,
     BOTH = 286,
     BTREE_SYM = 287,
     BY = 288,
     BYTE_SYM = 289,
     CALL_SYM = 290,
     CASCADE = 291,
     CASCADED = 292,
     CASE_SYM = 293,
     CAST_SYM = 294,
     CHAIN_SYM = 295,
     CHANGE = 296,
     CHAR_SYM = 297,
     CHECKSUM_SYM = 298,
     CHECK_SYM = 299,
     CLOSE_SYM = 300,
     COALESCE = 301,
     COLLATE_SYM = 302,
     COLLATION_SYM = 303,
     COLUMNS = 304,
     COLUMN_SYM = 305,
     COMMENT_SYM = 306,
     COMMITTED_SYM = 307,
     COMMIT_SYM = 308,
     COMPACT_SYM = 309,
     COMPRESSED_SYM = 310,
     CONCURRENT = 311,
     CONDITION_SYM = 312,
     CONNECTION_SYM = 313,
     CONSISTENT_SYM = 314,
     CONSTRAINT = 315,
     CONTAINS_SYM = 316,
     CONTINUE_SYM = 317,
     CONVERT_SYM = 318,
     COUNT_SYM = 319,
     CREATE = 320,
     CROSS = 321,
     CUBE_SYM = 322,
     CURDATE = 323,
     CURRENT_USER = 324,
     CURSOR_SYM = 325,
     DATABASE = 326,
     DATABASES = 327,
     DATAFILE_SYM = 328,
     DATA_SYM = 329,
     DATETIME_SYM = 330,
     DATE_ADD_INTERVAL = 331,
     DATE_SUB_INTERVAL = 332,
     DATE_SYM = 333,
     DAY_HOUR_SYM = 334,
     DAY_MICROSECOND_SYM = 335,
     DAY_MINUTE_SYM = 336,
     DAY_SECOND_SYM = 337,
     DAY_SYM = 338,
     DEALLOCATE_SYM = 339,
     DECIMAL_NUM = 340,
     DECIMAL_SYM = 341,
     DECLARE_SYM = 342,
     DEFAULT = 343,
     DELETE_SYM = 344,
     DESC = 345,
     DESCRIBE = 346,
     DETERMINISTIC_SYM = 347,
     DISABLE_SYM = 348,
     DISCARD = 349,
     DISTINCT = 350,
     DIV_SYM = 351,
     DOUBLE_SYM = 352,
     DROP = 353,
     DUMPFILE = 354,
     DUPLICATE_SYM = 355,
     DYNAMIC_SYM = 356,
     EACH_SYM = 357,
     ELSE = 358,
     ELSEIF_SYM = 359,
     ENABLE_SYM = 360,
     ENCLOSED = 361,
     END = 362,
     ENDS_SYM = 363,
     END_OF_INPUT = 364,
     ENGINE_SYM = 365,
     ENUM_SYM = 366,
     EQ = 367,
     EQUAL_SYM = 368,
     ERRORS = 369,
     ESCAPED = 370,
     ESCAPE_SYM = 371,
     EXCLUSIVE_SYM = 372,
     EXISTS = 373,
     EXTENDED_SYM = 374,
     EXTRACT_SYM = 375,
     FALSE_SYM = 376,
     FETCH_SYM = 377,
     COLUMN_FORMAT_SYM = 378,
     FILE_SYM = 379,
     FIRST_SYM = 380,
     FIXED_SYM = 381,
     FLOAT_NUM = 382,
     FLUSH_SYM = 383,
     FORCE_SYM = 384,
     FOREIGN = 385,
     FOR_SYM = 386,
     FOUND_SYM = 387,
     FRAC_SECOND_SYM = 388,
     FROM = 389,
     FULL = 390,
     GE = 391,
     GLOBAL_SYM = 392,
     GROUP_SYM = 393,
     GROUP_CONCAT_SYM = 394,
     GT_SYM = 395,
     HASH_SYM = 396,
     HAVING = 397,
     HEX_NUM = 398,
     HOUR_MICROSECOND_SYM = 399,
     HOUR_MINUTE_SYM = 400,
     HOUR_SECOND_SYM = 401,
     HOUR_SYM = 402,
     IDENT = 403,
     IDENTIFIED_SYM = 404,
     IDENT_QUOTED = 405,
     IF = 406,
     IGNORE_SYM = 407,
     IMPORT = 408,
     INDEXES = 409,
     INDEX_SYM = 410,
     INFILE = 411,
     INNER_SYM = 412,
     INOUT_SYM = 413,
     INSENSITIVE_SYM = 414,
     INSERT = 415,
     INTERVAL_SYM = 416,
     INTO = 417,
     INT_SYM = 418,
     IN_SYM = 419,
     IS = 420,
     ISOLATION = 421,
     ITERATE_SYM = 422,
     JOIN_SYM = 423,
     KEYS = 424,
     KEY_BLOCK_SIZE = 425,
     KEY_SYM = 426,
     KILL_SYM = 427,
     LAST_SYM = 428,
     LE = 429,
     LEADING = 430,
     LEFT = 431,
     LEVEL_SYM = 432,
     LEX_HOSTNAME = 433,
     LIKE = 434,
     LIMIT = 435,
     LINES = 436,
     LIST_SYM = 437,
     LOAD = 438,
     LOCAL_SYM = 439,
     LOCATOR_SYM = 440,
     LOCKS_SYM = 441,
     LOCK_SYM = 442,
     LOGS_SYM = 443,
     LONG_NUM = 444,
     LONG_SYM = 445,
     LOOP_SYM = 446,
     LT = 447,
     MATCH = 448,
     MAX_ROWS = 449,
     MAX_SIZE_SYM = 450,
     MAX_SYM = 451,
     MAX_VALUE_SYM = 452,
     MEDIUM_SYM = 453,
     MERGE_SYM = 454,
     MICROSECOND_SYM = 455,
     MINUTE_MICROSECOND_SYM = 456,
     MINUTE_SECOND_SYM = 457,
     MINUTE_SYM = 458,
     MIN_ROWS = 459,
     MIN_SYM = 460,
     MODE_SYM = 461,
     MODIFIES_SYM = 462,
     MODIFY_SYM = 463,
     MOD_SYM = 464,
     MONTH_SYM = 465,
     NAMES_SYM = 466,
     NAME_SYM = 467,
     NATIONAL_SYM = 468,
     NATURAL = 469,
     NE = 470,
     NEG = 471,
     NEW_SYM = 472,
     NEXT_SYM = 473,
     NONE_SYM = 474,
     NOT_SYM = 475,
     NOW_SYM = 476,
     NO_SYM = 477,
     NULL_SYM = 478,
     NUM = 479,
     NUMERIC_SYM = 480,
     OFFLINE_SYM = 481,
     OFFSET_SYM = 482,
     ON = 483,
     ONE_SHOT_SYM = 484,
     ONE_SYM = 485,
     ONLINE_SYM = 486,
     OPEN_SYM = 487,
     OPTIMIZE = 488,
     OPTION = 489,
     OPTIONALLY = 490,
     ORDER_SYM = 491,
     OR_SYM = 492,
     OUTER = 493,
     OUTFILE = 494,
     OUT_SYM = 495,
     PAGE_SYM = 496,
     PARTIAL = 497,
     PHASE_SYM = 498,
     POSITION_SYM = 499,
     PRECISION = 500,
     PREV_SYM = 501,
     PRIMARY_SYM = 502,
     PROCESS = 503,
     PROCESSLIST_SYM = 504,
     QUARTER_SYM = 505,
     QUERY_SYM = 506,
     RANGE_SYM = 507,
     READS_SYM = 508,
     READ_ONLY_SYM = 509,
     READ_SYM = 510,
     READ_WRITE_SYM = 511,
     REAL = 512,
     REDUNDANT_SYM = 513,
     REFERENCES = 514,
     RELEASE_SYM = 515,
     RENAME = 516,
     REPEATABLE_SYM = 517,
     REPEAT_SYM = 518,
     REPLACE = 519,
     RESTRICT = 520,
     RETURNS_SYM = 521,
     RETURN_SYM = 522,
     REVERSE_SYM = 523,
     REVOKE = 524,
     RIGHT = 525,
     ROLLBACK_SYM = 526,
     ROLLUP_SYM = 527,
     ROUTINE_SYM = 528,
     ROWS_SYM = 529,
     ROW_FORMAT_SYM = 530,
     ROW_SYM = 531,
     SAVEPOINT_SYM = 532,
     SECOND_MICROSECOND_SYM = 533,
     SECOND_SYM = 534,
     SECURITY_SYM = 535,
     SELECT_SYM = 536,
     SENSITIVE_SYM = 537,
     SEPARATOR_SYM = 538,
     SERIALIZABLE_SYM = 539,
     SERIAL_SYM = 540,
     SESSION_SYM = 541,
     SERVER_SYM = 542,
     SERVER_OPTIONS = 543,
     SET = 544,
     SET_VAR = 545,
     SHARE_SYM = 546,
     SHOW = 547,
     SIMPLE_SYM = 548,
     SNAPSHOT_SYM = 549,
     SPECIFIC_SYM = 550,
     SQLEXCEPTION_SYM = 551,
     SQLSTATE_SYM = 552,
     SQLWARNING_SYM = 553,
     SQL_BIG_RESULT = 554,
     SQL_BUFFER_RESULT = 555,
     SQL_CALC_FOUND_ROWS = 556,
     SQL_SMALL_RESULT = 557,
     SQL_SYM = 558,
     STARTING = 559,
     START_SYM = 560,
     STATUS_SYM = 561,
     STDDEV_SAMP_SYM = 562,
     STD_SYM = 563,
     STOP_SYM = 564,
     STORAGE_SYM = 565,
     STORED_SYM = 566,
     STRAIGHT_JOIN = 567,
     STRING_SYM = 568,
     SUBDATE_SYM = 569,
     SUBJECT_SYM = 570,
     SUBSTRING = 571,
     SUM_SYM = 572,
     SUSPEND_SYM = 573,
     SWAPS_SYM = 574,
     SWITCHES_SYM = 575,
     SYSDATE = 576,
     TABLES = 577,
     TABLESPACE = 578,
     TABLE_REF_PRIORITY = 579,
     TABLE_SYM = 580,
     TEMPORARY_SYM = 581,
     TERMINATED = 582,
     TEXT_STRING = 583,
     TEXT_SYM = 584,
     THEN_SYM = 585,
     TIMESTAMP_SYM = 586,
     TIMESTAMP_ADD = 587,
     TIMESTAMP_DIFF = 588,
     TO_SYM = 589,
     TRAILING = 590,
     TRANSACTION_SYM = 591,
     TRIM = 592,
     TRUE_SYM = 593,
     TRUNCATE_SYM = 594,
     TYPES_SYM = 595,
     TYPE_SYM = 596,
     ULONGLONG_NUM = 597,
     UNCOMMITTED_SYM = 598,
     UNDOFILE_SYM = 599,
     UNDO_SYM = 600,
     UNION_SYM = 601,
     UNIQUE_SYM = 602,
     UNKNOWN_SYM = 603,
     UNLOCK_SYM = 604,
     UPDATE_SYM = 605,
     USAGE = 606,
     USER = 607,
     USE_SYM = 608,
     USING = 609,
     UTC_DATE_SYM = 610,
     UTC_TIMESTAMP_SYM = 611,
     VALUES = 612,
     VALUE_SYM = 613,
     VARBINARY = 614,
     VARCHAR_SYM = 615,
     VARIABLES = 616,
     VARIANCE_SYM = 617,
     VARYING = 618,
     VAR_SAMP_SYM = 619,
     WARNINGS = 620,
     WEEK_SYM = 621,
     WHEN_SYM = 622,
     WHERE = 623,
     WITH = 624,
     WITH_ROLLUP_SYM = 625,
     WORK_SYM = 626,
     WRITE_SYM = 627,
     XOR = 628,
     YEAR_MONTH_SYM = 629,
     YEAR_SYM = 630
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACTION 259
#define ADD 260
#define ADDDATE_SYM 261
#define AFTER_SYM 262
#define AGGREGATE_SYM 263
#define ALL 264
#define ALTER 265
#define ANALYZE_SYM 266
#define AND_SYM 267
#define ANY_SYM 268
#define AS 269
#define ASC 270
#define ASENSITIVE_SYM 271
#define AT_SYM 272
#define AUTO_INC 273
#define AVG_ROW_LENGTH 274
#define AVG_SYM 275
#define BEFORE_SYM 276
#define BEGIN_SYM 277
#define BETWEEN_SYM 278
#define BIGINT_SYM 279
#define BINARY 280
#define BIN_NUM 281
#define BIT_SYM 282
#define BLOB_SYM 283
#define BOOLEAN_SYM 284
#define BOOL_SYM 285
#define BOTH 286
#define BTREE_SYM 287
#define BY 288
#define BYTE_SYM 289
#define CALL_SYM 290
#define CASCADE 291
#define CASCADED 292
#define CASE_SYM 293
#define CAST_SYM 294
#define CHAIN_SYM 295
#define CHANGE 296
#define CHAR_SYM 297
#define CHECKSUM_SYM 298
#define CHECK_SYM 299
#define CLOSE_SYM 300
#define COALESCE 301
#define COLLATE_SYM 302
#define COLLATION_SYM 303
#define COLUMNS 304
#define COLUMN_SYM 305
#define COMMENT_SYM 306
#define COMMITTED_SYM 307
#define COMMIT_SYM 308
#define COMPACT_SYM 309
#define COMPRESSED_SYM 310
#define CONCURRENT 311
#define CONDITION_SYM 312
#define CONNECTION_SYM 313
#define CONSISTENT_SYM 314
#define CONSTRAINT 315
#define CONTAINS_SYM 316
#define CONTINUE_SYM 317
#define CONVERT_SYM 318
#define COUNT_SYM 319
#define CREATE 320
#define CROSS 321
#define CUBE_SYM 322
#define CURDATE 323
#define CURRENT_USER 324
#define CURSOR_SYM 325
#define DATABASE 326
#define DATABASES 327
#define DATAFILE_SYM 328
#define DATA_SYM 329
#define DATETIME_SYM 330
#define DATE_ADD_INTERVAL 331
#define DATE_SUB_INTERVAL 332
#define DATE_SYM 333
#define DAY_HOUR_SYM 334
#define DAY_MICROSECOND_SYM 335
#define DAY_MINUTE_SYM 336
#define DAY_SECOND_SYM 337
#define DAY_SYM 338
#define DEALLOCATE_SYM 339
#define DECIMAL_NUM 340
#define DECIMAL_SYM 341
#define DECLARE_SYM 342
#define DEFAULT 343
#define DELETE_SYM 344
#define DESC 345
#define DESCRIBE 346
#define DETERMINISTIC_SYM 347
#define DISABLE_SYM 348
#define DISCARD 349
#define DISTINCT 350
#define DIV_SYM 351
#define DOUBLE_SYM 352
#define DROP 353
#define DUMPFILE 354
#define DUPLICATE_SYM 355
#define DYNAMIC_SYM 356
#define EACH_SYM 357
#define ELSE 358
#define ELSEIF_SYM 359
#define ENABLE_SYM 360
#define ENCLOSED 361
#define END 362
#define ENDS_SYM 363
#define END_OF_INPUT 364
#define ENGINE_SYM 365
#define ENUM_SYM 366
#define EQ 367
#define EQUAL_SYM 368
#define ERRORS 369
#define ESCAPED 370
#define ESCAPE_SYM 371
#define EXCLUSIVE_SYM 372
#define EXISTS 373
#define EXTENDED_SYM 374
#define EXTRACT_SYM 375
#define FALSE_SYM 376
#define FETCH_SYM 377
#define COLUMN_FORMAT_SYM 378
#define FILE_SYM 379
#define FIRST_SYM 380
#define FIXED_SYM 381
#define FLOAT_NUM 382
#define FLUSH_SYM 383
#define FORCE_SYM 384
#define FOREIGN 385
#define FOR_SYM 386
#define FOUND_SYM 387
#define FRAC_SECOND_SYM 388
#define FROM 389
#define FULL 390
#define GE 391
#define GLOBAL_SYM 392
#define GROUP_SYM 393
#define GROUP_CONCAT_SYM 394
#define GT_SYM 395
#define HASH_SYM 396
#define HAVING 397
#define HEX_NUM 398
#define HOUR_MICROSECOND_SYM 399
#define HOUR_MINUTE_SYM 400
#define HOUR_SECOND_SYM 401
#define HOUR_SYM 402
#define IDENT 403
#define IDENTIFIED_SYM 404
#define IDENT_QUOTED 405
#define IF 406
#define IGNORE_SYM 407
#define IMPORT 408
#define INDEXES 409
#define INDEX_SYM 410
#define INFILE 411
#define INNER_SYM 412
#define INOUT_SYM 413
#define INSENSITIVE_SYM 414
#define INSERT 415
#define INTERVAL_SYM 416
#define INTO 417
#define INT_SYM 418
#define IN_SYM 419
#define IS 420
#define ISOLATION 421
#define ITERATE_SYM 422
#define JOIN_SYM 423
#define KEYS 424
#define KEY_BLOCK_SIZE 425
#define KEY_SYM 426
#define KILL_SYM 427
#define LAST_SYM 428
#define LE 429
#define LEADING 430
#define LEFT 431
#define LEVEL_SYM 432
#define LEX_HOSTNAME 433
#define LIKE 434
#define LIMIT 435
#define LINES 436
#define LIST_SYM 437
#define LOAD 438
#define LOCAL_SYM 439
#define LOCATOR_SYM 440
#define LOCKS_SYM 441
#define LOCK_SYM 442
#define LOGS_SYM 443
#define LONG_NUM 444
#define LONG_SYM 445
#define LOOP_SYM 446
#define LT 447
#define MATCH 448
#define MAX_ROWS 449
#define MAX_SIZE_SYM 450
#define MAX_SYM 451
#define MAX_VALUE_SYM 452
#define MEDIUM_SYM 453
#define MERGE_SYM 454
#define MICROSECOND_SYM 455
#define MINUTE_MICROSECOND_SYM 456
#define MINUTE_SECOND_SYM 457
#define MINUTE_SYM 458
#define MIN_ROWS 459
#define MIN_SYM 460
#define MODE_SYM 461
#define MODIFIES_SYM 462
#define MODIFY_SYM 463
#define MOD_SYM 464
#define MONTH_SYM 465
#define NAMES_SYM 466
#define NAME_SYM 467
#define NATIONAL_SYM 468
#define NATURAL 469
#define NE 470
#define NEG 471
#define NEW_SYM 472
#define NEXT_SYM 473
#define NONE_SYM 474
#define NOT_SYM 475
#define NOW_SYM 476
#define NO_SYM 477
#define NULL_SYM 478
#define NUM 479
#define NUMERIC_SYM 480
#define OFFLINE_SYM 481
#define OFFSET_SYM 482
#define ON 483
#define ONE_SHOT_SYM 484
#define ONE_SYM 485
#define ONLINE_SYM 486
#define OPEN_SYM 487
#define OPTIMIZE 488
#define OPTION 489
#define OPTIONALLY 490
#define ORDER_SYM 491
#define OR_SYM 492
#define OUTER 493
#define OUTFILE 494
#define OUT_SYM 495
#define PAGE_SYM 496
#define PARTIAL 497
#define PHASE_SYM 498
#define POSITION_SYM 499
#define PRECISION 500
#define PREV_SYM 501
#define PRIMARY_SYM 502
#define PROCESS 503
#define PROCESSLIST_SYM 504
#define QUARTER_SYM 505
#define QUERY_SYM 506
#define RANGE_SYM 507
#define READS_SYM 508
#define READ_ONLY_SYM 509
#define READ_SYM 510
#define READ_WRITE_SYM 511
#define REAL 512
#define REDUNDANT_SYM 513
#define REFERENCES 514
#define RELEASE_SYM 515
#define RENAME 516
#define REPEATABLE_SYM 517
#define REPEAT_SYM 518
#define REPLACE 519
#define RESTRICT 520
#define RETURNS_SYM 521
#define RETURN_SYM 522
#define REVERSE_SYM 523
#define REVOKE 524
#define RIGHT 525
#define ROLLBACK_SYM 526
#define ROLLUP_SYM 527
#define ROUTINE_SYM 528
#define ROWS_SYM 529
#define ROW_FORMAT_SYM 530
#define ROW_SYM 531
#define SAVEPOINT_SYM 532
#define SECOND_MICROSECOND_SYM 533
#define SECOND_SYM 534
#define SECURITY_SYM 535
#define SELECT_SYM 536
#define SENSITIVE_SYM 537
#define SEPARATOR_SYM 538
#define SERIALIZABLE_SYM 539
#define SERIAL_SYM 540
#define SESSION_SYM 541
#define SERVER_SYM 542
#define SERVER_OPTIONS 543
#define SET 544
#define SET_VAR 545
#define SHARE_SYM 546
#define SHOW 547
#define SIMPLE_SYM 548
#define SNAPSHOT_SYM 549
#define SPECIFIC_SYM 550
#define SQLEXCEPTION_SYM 551
#define SQLSTATE_SYM 552
#define SQLWARNING_SYM 553
#define SQL_BIG_RESULT 554
#define SQL_BUFFER_RESULT 555
#define SQL_CALC_FOUND_ROWS 556
#define SQL_SMALL_RESULT 557
#define SQL_SYM 558
#define STARTING 559
#define START_SYM 560
#define STATUS_SYM 561
#define STDDEV_SAMP_SYM 562
#define STD_SYM 563
#define STOP_SYM 564
#define STORAGE_SYM 565
#define STORED_SYM 566
#define STRAIGHT_JOIN 567
#define STRING_SYM 568
#define SUBDATE_SYM 569
#define SUBJECT_SYM 570
#define SUBSTRING 571
#define SUM_SYM 572
#define SUSPEND_SYM 573
#define SWAPS_SYM 574
#define SWITCHES_SYM 575
#define SYSDATE 576
#define TABLES 577
#define TABLESPACE 578
#define TABLE_REF_PRIORITY 579
#define TABLE_SYM 580
#define TEMPORARY_SYM 581
#define TERMINATED 582
#define TEXT_STRING 583
#define TEXT_SYM 584
#define THEN_SYM 585
#define TIMESTAMP_SYM 586
#define TIMESTAMP_ADD 587
#define TIMESTAMP_DIFF 588
#define TO_SYM 589
#define TRAILING 590
#define TRANSACTION_SYM 591
#define TRIM 592
#define TRUE_SYM 593
#define TRUNCATE_SYM 594
#define TYPES_SYM 595
#define TYPE_SYM 596
#define ULONGLONG_NUM 597
#define UNCOMMITTED_SYM 598
#define UNDOFILE_SYM 599
#define UNDO_SYM 600
#define UNION_SYM 601
#define UNIQUE_SYM 602
#define UNKNOWN_SYM 603
#define UNLOCK_SYM 604
#define UPDATE_SYM 605
#define USAGE 606
#define USER 607
#define USE_SYM 608
#define USING 609
#define UTC_DATE_SYM 610
#define UTC_TIMESTAMP_SYM 611
#define VALUES 612
#define VALUE_SYM 613
#define VARBINARY 614
#define VARCHAR_SYM 615
#define VARIABLES 616
#define VARIANCE_SYM 617
#define VARYING 618
#define VAR_SAMP_SYM 619
#define WARNINGS 620
#define WEEK_SYM 621
#define WHEN_SYM 622
#define WHERE 623
#define WITH 624
#define WITH_ROLLUP_SYM 625
#define WORK_SYM 626
#define WRITE_SYM 627
#define XOR 628
#define YEAR_MONTH_SYM 629
#define YEAR_SYM 630




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 339 "sql_yacc.yy"

  int  num;
  ulong ulong_num;
  uint64_t ulonglong_number;
  int64_t longlong_number;
  drizzled::LEX_STRING lex_str;
  drizzled::LEX_STRING *lex_str_ptr;
  drizzled::LEX_SYMBOL symbol;
  drizzled::Table_ident *table;
  char *simple_string;
  drizzled::Item *item;
  drizzled::Item_num *item_num;
  drizzled::List<drizzled::Item> *item_list;
  drizzled::List<drizzled::String> *string_list;
  drizzled::String *string;
  drizzled::Key_part_spec *key_part;
  const drizzled::plugin::Function *udf;
  drizzled::TableList *table_list;
  struct drizzled::sys_var_with_base variable;
  enum drizzled::sql_var_t var_type;
  drizzled::Key::Keytype key_type;
  enum drizzled::ha_key_alg key_alg;
  enum drizzled::column_format_type column_format_type;
  enum drizzled::ha_rkey_function ha_rkey_mode;
  enum drizzled::enum_tx_isolation tx_isolation;
  enum drizzled::Cast_target cast_type;
  const drizzled::CHARSET_INFO *charset;
  drizzled::thr_lock_type lock_type;
  drizzled::interval_type interval, interval_time_st;
  enum drizzled::enum_drizzle_timestamp_type date_time_type;
  drizzled::Select_Lex *select_lex;
  drizzled::chooser_compare_func_creator boolfunc2creator;
  struct drizzled::st_lex *lex;
  enum drizzled::index_hint_type index_hint;
  enum drizzled::enum_filetype filetype;
  enum drizzled::ha_build_method build_method;
  drizzled::message::Table::ForeignKeyConstraint::ForeignKeyOption m_fk_option;



/* Line 214 of yacc.c  */
#line 1226 "drizzled/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 378 "sql_yacc.yy"

namespace drizzled
{
bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);
}


/* Line 264 of yacc.c  */
#line 1246 "drizzled/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  274
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   20447

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  389
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  401
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1127
/* YYNRULES -- Number of states.  */
#define YYNSTATES  1943

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   630

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   384,     2,     2,     2,   380,     2,     2,
     381,   382,   378,   377,   383,   376,   387,   379,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   388,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   385,     2,   386,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    63,    71,    72,    86,    87,    94,    97,   100,
     104,   109,   114,   115,   120,   121,   122,   128,   129,   137,
     138,   139,   146,   147,   149,   150,   152,   154,   156,   160,
     162,   166,   170,   171,   173,   174,   178,   179,   181,   183,
     186,   188,   191,   195,   197,   201,   205,   209,   213,   217,
     219,   224,   229,   231,   233,   235,   237,   240,   242,   246,
     248,   250,   253,   256,   264,   273,   282,   285,   288,   289,
     291,   294,   295,   297,   300,   301,   305,   308,   310,   313,
     318,   320,   325,   330,   332,   334,   336,   338,   340,   343,
     346,   349,   350,   356,   358,   360,   363,   365,   367,   369,
     371,   373,   376,   377,   381,   383,   389,   390,   394,   395,
     397,   398,   400,   403,   405,   407,   410,   413,   416,   421,
     423,   427,   430,   432,   435,   438,   441,   444,   446,   448,
     450,   452,   453,   455,   456,   458,   464,   465,   469,   473,
     475,   476,   479,   482,   485,   486,   490,   494,   501,   508,
     510,   512,   515,   518,   521,   523,   526,   529,   531,   533,
     534,   536,   538,   540,   542,   543,   545,   546,   548,   551,
     552,   554,   556,   559,   562,   565,   567,   571,   574,   576,
     578,   583,   586,   588,   593,   594,   596,   597,   600,   602,
     606,   607,   615,   616,   622,   623,   625,   626,   629,   632,
     634,   635,   637,   639,   641,   645,   648,   652,   655,   660,
     661,   668,   669,   670,   678,   682,   687,   691,   695,   698,
     701,   708,   714,   718,   722,   724,   726,   728,   729,   731,
     732,   734,   735,   738,   740,   741,   743,   745,   747,   751,
     752,   756,   757,   762,   763,   768,   769,   774,   776,   780,
     784,   786,   789,   794,   797,   801,   804,   808,   809,   813,
     814,   815,   822,   825,   827,   829,   832,   835,   843,   844,
     846,   849,   851,   853,   855,   857,   859,   861,   863,   865,
     866,   869,   874,   878,   880,   882,   886,   891,   892,   893,
     894,   897,   900,   902,   904,   905,   908,   912,   916,   920,
     923,   927,   932,   936,   941,   945,   950,   952,   956,   961,
     965,   969,   976,   978,   984,   991,   997,  1005,  1012,  1021,
    1027,  1034,  1039,  1045,  1047,  1051,  1055,  1061,  1067,  1071,
    1075,  1079,  1083,  1087,  1089,  1091,  1093,  1095,  1097,  1099,
    1101,  1103,  1105,  1107,  1109,  1111,  1113,  1115,  1117,  1119,
    1121,  1125,  1127,  1129,  1131,  1134,  1137,  1141,  1145,  1151,
    1158,  1163,  1168,  1171,  1178,  1184,  1191,  1196,  1201,  1207,
    1212,  1215,  1220,  1225,  1230,  1241,  1248,  1257,  1264,  1269,
    1274,  1281,  1286,  1291,  1296,  1304,  1312,  1320,  1327,  1334,
    1341,  1348,  1352,  1357,  1364,  1373,  1376,  1385,  1394,  1401,
    1404,  1409,  1416,  1423,  1432,  1441,  1448,  1457,  1464,  1467,
    1472,  1481,  1490,  1493,  1496,  1501,  1506,  1510,  1519,  1524,
    1531,  1536,  1543,  1552,  1557,  1564,  1565,  1571,  1572,  1574,
    1576,  1580,  1585,  1590,  1596,  1602,  1607,  1608,  1609,  1617,
    1622,  1628,  1633,  1639,  1644,  1649,  1654,  1659,  1664,  1670,
    1671,  1680,  1681,  1685,  1689,  1691,  1696,  1697,  1699,  1700,
    1703,  1704,  1706,  1707,  1711,  1714,  1717,  1719,  1721,  1724,
    1726,  1730,  1731,  1733,  1734,  1737,  1742,  1748,  1750,  1752,
    1754,  1756,  1761,  1763,  1767,  1771,  1775,  1776,  1783,  1784,
    1791,  1792,  1801,  1806,  1807,  1816,  1817,  1828,  1835,  1836,
    1845,  1846,  1857,  1864,  1866,  1869,  1872,  1873,  1878,  1882,
    1888,  1892,  1893,  1894,  1903,  1905,  1906,  1907,  1914,  1915,
    1919,  1920,  1921,  1927,  1928,  1930,  1931,  1933,  1934,  1937,
    1941,  1945,  1947,  1949,  1950,  1958,  1959,  1967,  1969,  1972,
    1973,  1974,  1977,  1978,  1981,  1982,  1984,  1986,  1988,  1990,
    1994,  1996,  2000,  2002,  2004,  2006,  2008,  2010,  2012,  2014,
    2016,  2018,  2020,  2022,  2024,  2026,  2028,  2030,  2032,  2034,
    2036,  2038,  2040,  2042,  2044,  2046,  2047,  2049,  2051,  2052,
    2055,  2056,  2058,  2059,  2060,  2064,  2065,  2066,  2070,  2073,
    2074,  2075,  2080,  2085,  2088,  2089,  2091,  2095,  2099,  2101,
    2104,  2105,  2107,  2108,  2113,  2118,  2121,  2122,  2124,  2126,
    2127,  2129,  2130,  2132,  2135,  2137,  2141,  2145,  2147,  2149,
    2151,  2152,  2155,  2157,  2159,  2161,  2163,  2165,  2167,  2169,
    2171,  2173,  2175,  2177,  2178,  2181,  2185,  2187,  2190,  2191,
    2195,  2196,  2202,  2205,  2207,  2213,  2214,  2222,  2227,  2229,
    2233,  2235,  2236,  2239,  2240,  2242,  2243,  2244,  2252,  2253,
    2254,  2260,  2263,  2265,  2267,  2269,  2273,  2278,  2279,  2283,
    2287,  2289,  2292,  2295,  2296,  2300,  2301,  2307,  2311,  2313,
    2317,  2319,  2323,  2325,  2327,  2328,  2330,  2331,  2336,  2337,
    2339,  2343,  2345,  2347,  2349,  2350,  2351,  2358,  2359,  2360,
    2371,  2375,  2377,  2381,  2385,  2387,  2391,  2392,  2397,  2398,
    2405,  2406,  2409,  2411,  2415,  2416,  2418,  2419,  2423,  2426,
    2430,  2434,  2439,  2445,  2451,  2457,  2463,  2466,  2469,  2473,
    2475,  2479,  2484,  2488,  2489,  2492,  2494,  2496,  2497,  2500,
    2503,  2504,  2509,  2510,  2515,  2517,  2519,  2520,  2522,  2523,
    2525,  2527,  2528,  2532,  2536,  2538,  2539,  2543,  2548,  2550,
    2552,  2553,  2555,  2559,  2560,  2562,  2564,  2567,  2568,  2569,
    2570,  2571,  2590,  2592,  2593,  2595,  2596,  2598,  2600,  2601,
    2604,  2607,  2609,  2613,  2618,  2622,  2626,  2627,  2630,  2633,
    2635,  2639,  2643,  2644,  2648,  2650,  2652,  2653,  2657,  2660,
    2664,  2666,  2668,  2671,  2672,  2675,  2677,  2680,  2682,  2684,
    2686,  2688,  2691,  2694,  2696,  2698,  2700,  2702,  2704,  2706,
    2708,  2711,  2714,  2716,  2718,  2720,  2722,  2724,  2726,  2728,
    2732,  2738,  2740,  2742,  2744,  2746,  2748,  2752,  2757,  2763,
    2765,  2771,  2775,  2778,  2780,  2784,  2787,  2789,  2791,  2793,
    2795,  2797,  2799,  2801,  2803,  2805,  2807,  2809,  2811,  2813,
    2815,  2817,  2819,  2821,  2823,  2825,  2827,  2829,  2831,  2833,
    2835,  2837,  2839,  2841,  2843,  2845,  2847,  2849,  2851,  2853,
    2855,  2857,  2859,  2861,  2863,  2865,  2867,  2869,  2871,  2873,
    2875,  2877,  2879,  2881,  2883,  2885,  2887,  2889,  2891,  2893,
    2895,  2897,  2899,  2901,  2903,  2905,  2907,  2909,  2911,  2913,
    2915,  2917,  2919,  2921,  2923,  2925,  2927,  2929,  2931,  2933,
    2935,  2937,  2939,  2941,  2943,  2945,  2947,  2949,  2951,  2953,
    2955,  2957,  2959,  2961,  2963,  2965,  2967,  2969,  2971,  2973,
    2975,  2977,  2979,  2981,  2983,  2985,  2987,  2989,  2991,  2993,
    2995,  2997,  2999,  3001,  3003,  3005,  3007,  3009,  3011,  3013,
    3015,  3017,  3019,  3021,  3023,  3025,  3027,  3029,  3031,  3033,
    3035,  3037,  3039,  3041,  3043,  3045,  3047,  3049,  3051,  3053,
    3055,  3057,  3059,  3061,  3063,  3065,  3067,  3069,  3071,  3073,
    3075,  3077,  3079,  3081,  3083,  3085,  3087,  3089,  3091,  3093,
    3095,  3097,  3099,  3101,  3103,  3105,  3107,  3109,  3111,  3113,
    3115,  3117,  3119,  3121,  3123,  3125,  3127,  3129,  3130,  3135,
    3136,  3138,  3140,  3144,  3145,  3148,  3150,  3152,  3154,  3156,
    3157,  3159,  3160,  3162,  3164,  3166,  3167,  3170,  3173,  3176,
    3178,  3181,  3186,  3192,  3197,  3204,  3206,  3209,  3212,  3215,
    3217,  3219,  3221,  3223,  3225,  3227,  3229,  3231,  3232,  3236,
    3237,  3241,  3242,  3244,  3245,  3249,  3252,  3253,  3255,  3258,
    3259,  3261,  3266,  3271,  3277,  3280,  3284,  3285,  3287,  3288,
    3293,  3294,  3296,  3298,  3299,  3302,  3305,  3307,  3308,  3310,
    3312,  3315,  3319,  3321,  3322,  3328,  3332,  3333
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     390,     0,    -1,   109,    -1,   391,   109,    -1,   392,    -1,
     766,    -1,   474,    -1,   492,    -1,   494,    -1,   772,    -1,
     393,    -1,   677,    -1,   691,    -1,   638,    -1,   697,    -1,
     644,    -1,   703,    -1,   706,    -1,   775,    -1,   496,    -1,
     647,    -1,   773,    -1,   774,    -1,   500,    -1,   747,    -1,
     685,    -1,   490,    -1,   683,    -1,   764,    -1,   670,    -1,
     705,    -1,    -1,    65,   410,   325,   411,   738,   394,   397,
      -1,    -1,    65,   479,   395,   461,   155,   743,   463,   228,
     738,   381,   469,   382,   464,    -1,    -1,    65,    71,   411,
     743,   396,   407,    -1,   381,   398,    -1,   412,   400,    -1,
     179,   738,   412,    -1,   381,   179,   738,   382,    -1,   421,
     382,   412,   400,    -1,    -1,   403,   382,   399,   779,    -1,
      -1,    -1,   713,   406,   403,   401,   776,    -1,    -1,   713,
     406,   381,   403,   382,   402,   779,    -1,    -1,    -1,   281,
     404,   511,   515,   405,   420,    -1,    -1,    14,    -1,    -1,
     418,    -1,   408,    -1,   409,    -1,   409,   383,   408,    -1,
     744,    -1,   744,   661,   744,    -1,   744,   661,   629,    -1,
      -1,   326,    -1,    -1,   151,   527,   118,    -1,    -1,   414,
      -1,   415,    -1,   415,   413,    -1,   415,    -1,   415,   414,
      -1,   415,   383,   414,    -1,   416,    -1,   110,   661,   744,
      -1,    51,   662,   740,    -1,    18,   662,   629,    -1,   744,
     661,   744,    -1,   744,   661,   629,    -1,   417,    -1,   448,
      47,   662,   447,    -1,   448,    47,   662,   447,    -1,    88,
      -1,   126,    -1,   101,    -1,   623,    -1,   510,   514,    -1,
     422,    -1,   421,   383,   422,    -1,   423,    -1,   424,    -1,
     429,   425,    -1,   429,   450,    -1,   456,   471,   463,   381,
     469,   382,   464,    -1,   427,   457,   471,   463,   381,   469,
     382,   464,    -1,   427,   130,   171,   471,   381,   469,   382,
     450,    -1,   428,   425,    -1,   427,   426,    -1,    -1,   426,
      -1,    44,   521,    -1,    -1,   428,    -1,    60,   471,    -1,
      -1,   737,   430,   431,    -1,   432,   442,    -1,   436,    -1,
     437,   441,    -1,   434,   381,   224,   382,    -1,   434,    -1,
     435,   381,   224,   382,    -1,   359,   381,   224,   382,    -1,
      78,    -1,   331,    -1,    75,    -1,    28,    -1,   329,    -1,
      86,   438,    -1,   225,   438,    -1,   126,   438,    -1,    -1,
     111,   433,   381,   473,   382,    -1,   285,    -1,    42,    -1,
     434,   363,    -1,   360,    -1,   163,    -1,    24,    -1,   257,
      -1,    97,    -1,    97,   245,    -1,    -1,   381,   224,   382,
      -1,   439,    -1,   381,   224,   383,   224,   382,    -1,    -1,
     381,   224,   382,    -1,    -1,   439,    -1,    -1,   443,    -1,
     443,   444,    -1,   444,    -1,   223,    -1,   123,   419,    -1,
     527,   223,    -1,    88,   445,    -1,   228,   350,   221,   520,
      -1,    18,    -1,   285,    88,   358,    -1,   449,   171,    -1,
     347,    -1,   347,   171,    -1,    51,   740,    -1,    47,   446,
      -1,   221,   520,    -1,   728,    -1,   744,    -1,   446,    -1,
      88,    -1,    -1,    88,    -1,    -1,   247,    -1,   259,   738,
     451,   453,   454,    -1,    -1,   381,   452,   382,    -1,   452,
     383,   743,    -1,   743,    -1,    -1,   193,   135,    -1,   193,
     242,    -1,   193,   293,    -1,    -1,   228,   350,   455,    -1,
     228,    89,   455,    -1,   228,   350,   455,   228,    89,   455,
      -1,   228,    89,   455,   228,   350,   455,    -1,   265,    -1,
      36,    -1,   289,   223,    -1,   222,     4,    -1,   289,    88,
      -1,   458,    -1,   247,   171,    -1,   347,   459,    -1,   171,
      -1,   155,    -1,    -1,   458,    -1,   169,    -1,   155,    -1,
     154,    -1,    -1,   347,    -1,    -1,   462,    -1,   462,   466,
      -1,    -1,   465,    -1,   467,    -1,   465,   467,    -1,   354,
     468,    -1,   341,   468,    -1,   466,    -1,   170,   662,   628,
      -1,    51,   740,    -1,    32,    -1,   141,    -1,   469,   383,
     470,   621,    -1,   470,   621,    -1,   743,    -1,   743,   381,
     224,   382,    -1,    -1,   737,    -1,    -1,   387,   743,    -1,
     727,    -1,   473,   383,   727,    -1,    -1,    10,   479,   487,
     325,   738,   475,   478,    -1,    -1,    10,    71,   477,   476,
     418,    -1,    -1,   743,    -1,    -1,    94,   323,    -1,   153,
     323,    -1,   480,    -1,    -1,   231,    -1,   226,    -1,   482,
      -1,   480,   383,   482,    -1,     5,   486,    -1,   481,   423,
     488,    -1,     5,   424,    -1,   481,   381,   421,   382,    -1,
      -1,    41,   486,   737,   483,   429,   488,    -1,    -1,    -1,
     208,   486,   737,   484,   431,   485,   488,    -1,    98,   486,
     737,    -1,    98,   130,   171,   471,    -1,    98,   247,   171,
      -1,    98,   458,   737,    -1,    93,   169,    -1,   105,   169,
      -1,    10,   486,   737,   289,    88,   728,    -1,    10,   486,
     737,    98,    88,    -1,   261,   489,   738,    -1,    63,   334,
     447,    -1,   413,    -1,   129,    -1,   614,    -1,    -1,    50,
      -1,    -1,   152,    -1,    -1,     7,   743,    -1,   125,    -1,
      -1,   334,    -1,   112,    -1,    14,    -1,   305,   336,   491,
      -1,    -1,   369,    59,   294,    -1,    -1,    11,   763,   493,
     640,    -1,    -1,    44,   763,   495,   640,    -1,    -1,   261,
     763,   497,   498,    -1,   499,    -1,   498,   383,   499,    -1,
     738,   334,   738,    -1,   501,    -1,   281,   504,    -1,   381,
     502,   382,   779,    -1,   281,   506,    -1,   381,   502,   382,
      -1,   281,   575,    -1,   381,   503,   382,    -1,    -1,   506,
     505,   776,    -1,    -1,    -1,   507,   511,   515,   508,   509,
     514,    -1,   617,   623,    -1,   634,    -1,   510,    -1,   634,
     510,    -1,   510,   634,    -1,   134,   557,   606,   611,   608,
     617,   623,    -1,    -1,   512,    -1,   512,   513,    -1,   513,
      -1,   312,    -1,    95,    -1,   302,    -1,   299,    -1,   300,
      -1,   301,    -1,     9,    -1,    -1,   131,   350,    -1,   187,
     164,   291,   206,    -1,   515,   383,   516,    -1,   516,    -1,
     378,    -1,   517,   732,   518,    -1,   517,   521,   518,   519,
      -1,    -1,    -1,    -1,    14,   743,    -1,    14,   740,    -1,
     743,    -1,   740,    -1,    -1,   381,   382,    -1,   521,   525,
     521,    -1,   521,   373,   521,    -1,   521,   526,   521,    -1,
     220,   521,    -1,   522,   165,   338,    -1,   522,   165,   527,
     338,    -1,   522,   165,   121,    -1,   522,   165,   527,   121,
      -1,   522,   165,   348,    -1,   522,   165,   527,   348,    -1,
     522,    -1,   522,   165,   223,    -1,   522,   165,   527,   223,
      -1,   522,   113,   523,    -1,   522,   528,   523,    -1,   522,
     528,   529,   381,   787,   382,    -1,   523,    -1,   524,   164,
     381,   787,   382,    -1,   524,   527,   164,   381,   787,   382,
      -1,   524,   164,   381,   521,   382,    -1,   524,   164,   381,
     521,   383,   552,   382,    -1,   524,   527,   164,   381,   521,
     382,    -1,   524,   527,   164,   381,   521,   383,   552,   382,
      -1,   524,    23,   524,    12,   523,    -1,   524,   527,    23,
     524,    12,   523,    -1,   524,   179,   530,   610,    -1,   524,
     527,   179,   530,   610,    -1,   524,    -1,   524,   377,   524,
      -1,   524,   376,   524,    -1,   524,   377,   161,   521,   600,
      -1,   524,   376,   161,   521,   600,    -1,   524,   378,   524,
      -1,   524,   379,   524,    -1,   524,   380,   524,    -1,   524,
      96,   524,    -1,   524,   209,   524,    -1,   530,    -1,   237,
      -1,    12,    -1,   220,    -1,   112,    -1,   136,    -1,   140,
      -1,   174,    -1,   192,    -1,   215,    -1,     9,    -1,    13,
      -1,   734,    -1,   531,    -1,   532,    -1,   534,    -1,   533,
      -1,   530,    47,   744,    -1,   729,    -1,   543,    -1,   539,
      -1,   377,   530,    -1,   376,   530,    -1,   381,   787,   382,
      -1,   381,   521,   382,    -1,   381,   521,   383,   552,   382,
      -1,   276,   381,   521,   383,   552,   382,    -1,   118,   381,
     787,   382,    -1,   385,   743,   521,   386,    -1,    25,   530,
      -1,    39,   381,   521,    14,   551,   382,    -1,    38,   553,
     555,   554,   107,    -1,    63,   381,   521,   383,   551,   382,
      -1,    88,   381,   734,   382,    -1,   357,   381,   735,   382,
      -1,   161,   521,   600,   377,   521,    -1,    42,   381,   552,
     382,    -1,    69,   520,    -1,    78,   381,   521,   382,    -1,
      83,   381,   521,   382,    -1,   147,   381,   521,   382,    -1,
     160,   381,   521,   383,   521,   383,   521,   383,   521,   382,
      -1,   161,   381,   521,   383,   521,   382,    -1,   161,   381,
     521,   383,   521,   383,   552,   382,    -1,   176,   381,   521,
     383,   521,   382,    -1,   203,   381,   521,   382,    -1,   210,
     381,   521,   382,    -1,   270,   381,   521,   383,   521,   382,
      -1,   279,   381,   521,   382,    -1,   331,   381,   521,   382,
      -1,   337,   381,   521,   382,    -1,   337,   381,   175,   521,
     134,   521,   382,    -1,   337,   381,   335,   521,   134,   521,
     382,    -1,   337,   381,    31,   521,   134,   521,   382,    -1,
     337,   381,   175,   134,   521,   382,    -1,   337,   381,   335,
     134,   521,   382,    -1,   337,   381,    31,   134,   521,   382,
      -1,   337,   381,   521,   134,   521,   382,    -1,   352,   381,
     382,    -1,   375,   381,   521,   382,    -1,     6,   381,   521,
     383,   521,   382,    -1,     6,   381,   521,   383,   161,   521,
     600,   382,    -1,    68,   520,    -1,    76,   381,   521,   383,
     161,   521,   600,   382,    -1,    77,   381,   521,   383,   161,
     521,   600,   382,    -1,   120,   381,   600,   134,   521,   382,
      -1,   221,   520,    -1,   221,   381,   521,   382,    -1,   244,
     381,   524,   164,   521,   382,    -1,   314,   381,   521,   383,
     521,   382,    -1,   314,   381,   521,   383,   161,   521,   600,
     382,    -1,   316,   381,   521,   383,   521,   383,   521,   382,
      -1,   316,   381,   521,   383,   521,   382,    -1,   316,   381,
     521,   134,   521,   131,   521,   382,    -1,   316,   381,   521,
     134,   521,   382,    -1,   321,   520,    -1,   321,   381,   521,
     382,    -1,   332,   381,   601,   383,   521,   383,   521,   382,
      -1,   333,   381,   601,   383,   521,   383,   521,   382,    -1,
     355,   520,    -1,   356,   520,    -1,    46,   381,   552,   382,
      -1,    48,   381,   521,   382,    -1,    71,   381,   382,    -1,
     151,   381,   521,   383,   521,   383,   521,   382,    -1,   200,
     381,   521,   382,    -1,   209,   381,   521,   383,   521,   382,
      -1,   250,   381,   521,   382,    -1,   263,   381,   521,   383,
     521,   382,    -1,   264,   381,   521,   383,   521,   383,   521,
     382,    -1,   268,   381,   521,   382,    -1,   339,   381,   521,
     383,   521,   382,    -1,    -1,   739,   381,   535,   536,   382,
      -1,    -1,   537,    -1,   538,    -1,   537,   383,   538,    -1,
     517,   521,   518,   519,    -1,    20,   381,   549,   382,    -1,
      20,   381,    95,   549,   382,    -1,    64,   381,   605,   378,
     382,    -1,    64,   381,   549,   382,    -1,    -1,    -1,    64,
     381,    95,   540,   552,   541,   382,    -1,   205,   381,   549,
     382,    -1,   205,   381,    95,   549,   382,    -1,   196,   381,
     549,   382,    -1,   196,   381,    95,   549,   382,    -1,   308,
     381,   549,   382,    -1,   362,   381,   549,   382,    -1,   307,
     381,   549,   382,    -1,   364,   381,   549,   382,    -1,   317,
     381,   549,   382,    -1,   317,   381,    95,   549,   382,    -1,
      -1,   139,   381,   546,   542,   552,   548,   547,   382,    -1,
      -1,   388,   544,   545,    -1,   744,   290,   521,    -1,   744,
      -1,   388,   756,   744,   472,    -1,    -1,    95,    -1,    -1,
     283,   727,    -1,    -1,   618,    -1,    -1,   605,   550,   521,
      -1,    25,   440,    -1,    42,   440,    -1,    78,    -1,    75,
      -1,    86,   438,    -1,   521,    -1,   552,   383,   521,    -1,
      -1,   521,    -1,    -1,   103,   521,    -1,   367,   521,   330,
     521,    -1,   555,   367,   521,   330,   521,    -1,   569,    -1,
     560,    -1,   559,    -1,   556,    -1,   385,   743,   556,   386,
      -1,   558,    -1,   559,   383,   558,    -1,   556,   568,   556,
      -1,   556,   312,   569,    -1,    -1,   556,   568,   556,   228,
     561,   521,    -1,    -1,   556,   312,   569,   228,   562,   521,
      -1,    -1,   556,   568,   556,   354,   563,   381,   599,   382,
      -1,   556,   214,   168,   569,    -1,    -1,   556,   176,   585,
     168,   556,   228,   564,   521,    -1,    -1,   556,   176,   585,
     168,   569,   565,   354,   381,   599,   382,    -1,   556,   214,
     176,   585,   168,   569,    -1,    -1,   556,   270,   585,   168,
     556,   228,   566,   521,    -1,    -1,   556,   270,   585,   168,
     569,   567,   354,   381,   599,   382,    -1,   556,   214,   270,
     585,   168,   569,    -1,   168,    -1,   157,   168,    -1,    66,
     168,    -1,    -1,   570,   738,   604,   594,    -1,   584,   583,
     580,    -1,   381,   583,   571,   382,   604,    -1,   578,   617,
     623,    -1,    -1,    -1,   571,   346,   783,   572,   784,   573,
     617,   623,    -1,   575,    -1,    -1,    -1,   576,   511,   515,
     577,   420,   514,    -1,    -1,   583,   579,   559,    -1,    -1,
      -1,   581,   511,   515,   582,   420,    -1,    -1,   281,    -1,
      -1,   238,    -1,    -1,   131,   168,    -1,   131,   236,    33,
      -1,   131,   138,    33,    -1,   129,    -1,   152,    -1,    -1,
     587,   458,   586,   589,   381,   598,   382,    -1,    -1,   353,
     458,   586,   590,   381,   596,   382,    -1,   588,    -1,   591,
     588,    -1,    -1,    -1,   593,   591,    -1,    -1,   595,   592,
      -1,    -1,   598,    -1,   743,    -1,   247,    -1,   597,    -1,
     598,   383,   597,    -1,   743,    -1,   599,   383,   743,    -1,
     602,    -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,
     144,    -1,   145,    -1,   146,    -1,   201,    -1,   202,    -1,
     278,    -1,   374,    -1,   602,    -1,   133,    -1,    83,    -1,
     366,    -1,   147,    -1,   203,    -1,   210,    -1,   250,    -1,
     279,    -1,   200,    -1,   375,    -1,    -1,    14,    -1,   112,
      -1,    -1,   603,   743,    -1,    -1,     9,    -1,    -1,    -1,
     368,   607,   521,    -1,    -1,    -1,   142,   609,   521,    -1,
     116,   530,    -1,    -1,    -1,   138,    33,   612,   613,    -1,
     612,   383,   733,   621,    -1,   733,   621,    -1,    -1,   370,
      -1,   236,    33,   615,    -1,   615,   383,   616,    -1,   616,
      -1,   735,   621,    -1,    -1,   618,    -1,    -1,   236,    33,
     619,   620,    -1,   620,   383,   733,   621,    -1,   733,   621,
      -1,    -1,    15,    -1,    90,    -1,    -1,   624,    -1,    -1,
     624,    -1,   180,   625,    -1,   626,    -1,   626,   383,   626,
      -1,   626,   227,   626,    -1,   342,    -1,   189,    -1,   224,
      -1,    -1,   180,   626,    -1,   224,    -1,   143,    -1,   189,
      -1,   342,    -1,    85,    -1,   127,    -1,   224,    -1,   342,
      -1,   189,    -1,    85,    -1,   127,    -1,    -1,   631,   632,
      -1,   632,   383,   633,    -1,   633,    -1,   388,   744,    -1,
      -1,   162,   635,   636,    -1,    -1,   239,   742,   637,   714,
     717,    -1,    99,   742,    -1,   630,    -1,    98,   643,   763,
     642,   640,    -1,    -1,    98,   479,   155,   743,   228,   738,
     639,    -1,    98,    71,   642,   743,    -1,   641,    -1,   640,
     383,   641,    -1,   738,    -1,    -1,   151,   118,    -1,    -1,
     326,    -1,    -1,    -1,   160,   645,   487,   650,   646,   652,
     668,    -1,    -1,    -1,   264,   648,   650,   649,   652,    -1,
     162,   651,    -1,   651,    -1,   641,    -1,   655,    -1,   381,
     382,   655,    -1,   381,   654,   382,   655,    -1,    -1,   289,
     653,   659,    -1,   654,   383,   731,    -1,   731,    -1,   357,
     658,    -1,   358,   658,    -1,    -1,   403,   656,   776,    -1,
      -1,   381,   403,   382,   657,   779,    -1,   658,   383,   663,
      -1,   663,    -1,   659,   383,   660,    -1,   660,    -1,   735,
     661,   667,    -1,   112,    -1,   290,    -1,    -1,   661,    -1,
      -1,   381,   664,   665,   382,    -1,    -1,   666,    -1,   666,
     383,   667,    -1,   667,    -1,   521,    -1,    88,    -1,    -1,
      -1,   228,   100,   669,   171,   350,   675,    -1,    -1,    -1,
     350,   487,   738,   671,   289,   673,   672,   606,   617,   627,
      -1,   673,   383,   674,    -1,   674,    -1,   735,   661,   667,
      -1,   675,   383,   676,    -1,   676,    -1,   735,   661,   667,
      -1,    -1,    89,   678,   681,   679,    -1,    -1,   134,   738,
     680,   606,   617,   627,    -1,    -1,   682,   681,    -1,   152,
      -1,   339,   684,   641,    -1,    -1,   325,    -1,    -1,   292,
     686,   687,    -1,    72,   690,    -1,   322,   688,   690,    -1,
     326,   322,   690,    -1,   325,   306,   688,   690,    -1,    49,
     689,   738,   688,   690,    -1,   460,   689,   738,   688,   606,
      -1,    64,   381,   378,   382,   365,    -1,    64,   381,   378,
     382,   114,    -1,   365,   622,    -1,   114,   622,    -1,   755,
     306,   690,    -1,   249,    -1,   755,   361,   690,    -1,    65,
      71,   411,   743,    -1,    65,   325,   738,    -1,    -1,   689,
     743,    -1,   134,    -1,   164,    -1,    -1,   179,   740,    -1,
     368,   521,    -1,    -1,   694,   738,   692,   696,    -1,    -1,
     694,   695,   693,   500,    -1,    90,    -1,    91,    -1,    -1,
     119,    -1,    -1,   727,    -1,   743,    -1,    -1,   128,   698,
     699,    -1,   699,   383,   700,    -1,   700,    -1,    -1,   763,
     701,   702,    -1,   322,   369,   255,   187,    -1,   188,    -1,
     306,    -1,    -1,   640,    -1,   172,   704,   521,    -1,    -1,
      58,    -1,   251,    -1,   353,   743,    -1,    -1,    -1,    -1,
      -1,   183,   711,   707,   712,   156,   742,   708,   713,   162,
     709,   325,   738,   710,   714,   717,   720,   722,   725,    -1,
      74,    -1,    -1,    56,    -1,    -1,   264,    -1,   152,    -1,
      -1,    49,   715,    -1,   715,   716,    -1,   716,    -1,   327,
      33,   727,    -1,   235,   106,    33,   727,    -1,   106,    33,
     727,    -1,   115,    33,   727,    -1,    -1,   181,   718,    -1,
     718,   719,    -1,   719,    -1,   327,    33,   727,    -1,   304,
      33,   727,    -1,    -1,   152,   224,   721,    -1,   181,    -1,
     274,    -1,    -1,   381,   723,   382,    -1,   381,   382,    -1,
     723,   383,   724,    -1,   724,    -1,   735,    -1,   388,   744,
      -1,    -1,   289,   675,    -1,   741,    -1,   726,   741,    -1,
     741,    -1,   143,    -1,    26,    -1,   729,    -1,   377,   730,
      -1,   376,   730,    -1,   726,    -1,   730,    -1,   223,    -1,
     121,    -1,   338,    -1,   143,    -1,    26,    -1,    78,   726,
      -1,   331,   726,    -1,   224,    -1,   189,    -1,   342,    -1,
      85,    -1,   127,    -1,   735,    -1,   732,    -1,   743,   387,
     378,    -1,   743,   387,   743,   387,   378,    -1,   521,    -1,
     743,    -1,   736,    -1,   743,    -1,   736,    -1,   743,   387,
     743,    -1,   387,   743,   387,   743,    -1,   743,   387,   743,
     387,   743,    -1,   743,    -1,   743,   387,   743,   387,   743,
      -1,   743,   387,   743,    -1,   387,   743,    -1,   743,    -1,
     743,   387,   743,    -1,   387,   743,    -1,   148,    -1,   150,
      -1,   328,    -1,   328,    -1,   328,    -1,   739,    -1,   745,
      -1,   743,    -1,   740,    -1,   178,    -1,   746,    -1,    22,
      -1,    34,    -1,    43,    -1,    45,    -1,    51,    -1,    53,
      -1,    61,    -1,    84,    -1,   107,    -1,   128,    -1,   222,
      -1,   232,    -1,   271,    -1,   277,    -1,   280,    -1,   287,
      -1,   305,    -1,   309,    -1,   339,    -1,     4,    -1,     6,
      -1,     7,    -1,     8,    -1,    13,    -1,    17,    -1,    18,
      -1,    19,    -1,    20,    -1,    27,    -1,    30,    -1,    29,
      -1,    32,    -1,    37,    -1,    40,    -1,    46,    -1,    48,
      -1,   123,    -1,    49,    -1,    52,    -1,    54,    -1,    55,
      -1,    56,    -1,    58,    -1,    59,    -1,    67,    -1,    74,
      -1,    72,    -1,    73,    -1,    75,    -1,    78,    -1,    83,
      -1,    93,    -1,    94,    -1,    99,    -1,   100,    -1,   101,
      -1,   108,    -1,   111,    -1,   110,    -1,   114,    -1,   116,
      -1,   117,    -1,   119,    -1,   132,    -1,   105,    -1,   135,
      -1,   124,    -1,   125,    -1,   126,    -1,   133,    -1,   137,
      -1,   141,    -1,   147,    -1,   149,    -1,   153,    -1,   154,
      -1,   166,    -1,   170,    -1,   173,    -1,   177,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,   194,    -1,   195,
      -1,   197,    -1,   198,    -1,   199,    -1,   200,    -1,   203,
      -1,   204,    -1,   208,    -1,   206,    -1,   210,    -1,   212,
      -1,   211,    -1,   213,    -1,   218,    -1,   217,    -1,   219,
      -1,   226,    -1,   227,    -1,   229,    -1,   230,    -1,   231,
      -1,   241,    -1,   242,    -1,   243,    -1,   246,    -1,   248,
      -1,   249,    -1,   250,    -1,   251,    -1,   254,    -1,   258,
      -1,   262,    -1,   266,    -1,   268,    -1,   272,    -1,   273,
      -1,   274,    -1,   275,    -1,   276,    -1,   279,    -1,   285,
      -1,   284,    -1,   286,    -1,   293,    -1,   291,    -1,   294,
      -1,   300,    -1,   306,    -1,   310,    -1,   313,    -1,   314,
      -1,   315,    -1,   318,    -1,   319,    -1,   320,    -1,   322,
      -1,   323,    -1,   326,    -1,   329,    -1,   336,    -1,   331,
      -1,   332,    -1,   333,    -1,   340,    -1,   341,    -1,   343,
      -1,   344,    -1,   348,    -1,   352,    -1,   361,    -1,   358,
      -1,   365,    -1,   366,    -1,   371,    -1,   375,    -1,    -1,
     289,   749,   748,   750,    -1,    -1,   234,    -1,   751,    -1,
     750,   383,   751,    -1,    -1,   752,   757,    -1,   754,    -1,
     137,    -1,   184,    -1,   286,    -1,    -1,   229,    -1,    -1,
     137,    -1,   184,    -1,   286,    -1,    -1,   137,   387,    -1,
     184,   387,    -1,   286,   387,    -1,   758,    -1,   754,   759,
      -1,   753,   760,   661,   762,    -1,   753,   336,   166,   177,
     761,    -1,   388,   744,   661,   521,    -1,   388,   388,   756,
     760,   661,   762,    -1,   743,    -1,   255,   343,    -1,   255,
      52,    -1,   262,   255,    -1,   284,    -1,   521,    -1,    88,
      -1,   228,    -1,     9,    -1,    25,    -1,   325,    -1,   322,
      -1,    -1,   349,   765,   763,    -1,    -1,    22,   767,   768,
      -1,    -1,   371,    -1,    -1,    12,   222,    40,    -1,    12,
      40,    -1,    -1,   260,    -1,   222,   260,    -1,    -1,   277,
      -1,    53,   768,   769,   770,    -1,   271,   768,   769,   770,
      -1,   271,   768,   334,   771,   743,    -1,   277,   743,    -1,
     260,   277,   743,    -1,    -1,   777,    -1,    -1,   346,   783,
     778,   501,    -1,    -1,   777,    -1,   780,    -1,    -1,   781,
     782,    -1,   618,   622,    -1,   624,    -1,    -1,    95,    -1,
       9,    -1,   281,   574,    -1,   381,   503,   382,    -1,   784,
      -1,    -1,   785,   346,   783,   786,   784,    -1,   788,   785,
     789,    -1,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   972,   972,   989,   993,   994,   999,  1000,  1001,  1002,
    1003,  1004,  1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,
    1013,  1014,  1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,
    1023,  1030,  1029,  1063,  1062,  1090,  1089,  1107,  1108,  1110,
    1120,  1133,  1136,  1135,  1141,  1143,  1142,  1146,  1145,  1152,
    1182,  1151,  1196,  1197,  1201,  1202,  1203,  1207,  1208,  1212,
    1219,  1227,  1242,  1243,  1247,  1248,  1251,  1253,  1257,  1258,
    1262,  1263,  1264,  1267,  1270,  1278,  1285,  1296,  1303,  1312,
    1316,  1335,  1345,  1346,  1347,  1351,  1352,  1356,  1357,  1361,
    1362,  1366,  1367,  1374,  1383,  1393,  1413,  1417,  1423,  1425,
    1429,  1433,  1434,  1438,  1443,  1442,  1477,  1481,  1498,  1511,
    1529,  1540,  1559,  1580,  1590,  1600,  1610,  1629,  1640,  1650,
    1660,  1671,  1670,  1682,  1700,  1704,  1705,  1709,  1710,  1714,
    1718,  1720,  1726,  1727,  1729,  1734,  1743,  1744,  1748,  1749,
    1753,  1754,  1758,  1759,  1763,  1775,  1782,  1794,  1801,  1803,
    1816,  1831,  1846,  1854,  1862,  1870,  1886,  1888,  1893,  1904,
    1905,  1909,  1910,  1913,  1915,  1919,  1931,  1932,  1936,  1938,
    1948,  1949,  1951,  1953,  1959,  1963,  1968,  1973,  1979,  1988,
    1989,  1990,  1991,  1992,  1996,  2000,  2001,  2005,  2006,  2010,
    2011,  2015,  2016,  2017,  2021,  2022,  2026,  2038,  2039,  2043,
    2044,  2048,  2049,  2053,  2054,  2058,  2059,  2061,  2066,  2067,
    2071,  2072,  2076,  2077,  2089,  2090,  2094,  2095,  2099,  2100,
    2108,  2107,  2131,  2130,  2149,  2150,  2153,  2155,  2160,  2165,
    2170,  2173,  2177,  2184,  2185,  2189,  2199,  2200,  2206,  2214,
    2213,  2221,  2234,  2220,  2249,  2256,  2264,  2272,  2280,  2287,
    2294,  2301,  2308,  2330,  2340,  2346,  2352,  2361,  2362,  2366,
    2367,  2371,  2372,  2379,  2389,  2390,  2391,  2392,  2396,  2407,
    2408,  2416,  2415,  2429,  2428,  2443,  2442,  2454,  2455,  2459,
    2477,  2489,  2490,  2494,  2499,  2504,  2509,  2514,  2513,  2535,
    2543,  2535,  2550,  2551,  2552,  2553,  2554,  2558,  2567,  2569,
    2581,  2582,  2586,  2587,  2588,  2589,  2590,  2596,  2602,  2605,
    2607,  2612,  2621,  2622,  2623,  2635,  2642,  2662,  2670,  2678,
    2679,  2680,  2681,  2682,  2686,  2687,  2692,  2741,  2746,  2787,
    2789,  2791,  2793,  2795,  2797,  2799,  2801,  2805,  2807,  2809,
    2811,  2813,  2815,  2819,  2823,  2829,  2833,  2839,  2843,  2851,
    2853,  2859,  2861,  2863,  2867,  2869,  2871,  2873,  2875,  2877,
    2879,  2881,  2883,  2885,  2889,  2893,  2897,  2901,  2902,  2903,
    2904,  2905,  2906,  2910,  2911,  2915,  2916,  2917,  2918,  2919,
    2920,  2928,  2929,  2930,  2934,  2935,  2937,  2941,  2942,  2947,
    2952,  2956,  2957,  2962,  2970,  2972,  2979,  2984,  2989,  3001,
    3003,  3012,  3014,  3016,  3018,  3020,  3029,  3037,  3039,  3041,
    3043,  3045,  3047,  3049,  3051,  3053,  3055,  3057,  3059,  3061,
    3063,  3065,  3074,  3090,  3095,  3097,  3102,  3104,  3106,  3108,
    3113,  3118,  3120,  3125,  3127,  3139,  3150,  3162,  3173,  3178,
    3183,  3185,  3187,  3192,  3205,  3207,  3209,  3218,  3220,  3222,
    3224,  3226,  3228,  3230,  3240,  3254,  3253,  3302,  3303,  3307,
    3312,  3320,  3340,  3342,  3344,  3346,  3349,  3351,  3348,  3354,
    3361,  3363,  3365,  3367,  3369,  3371,  3373,  3375,  3377,  3380,
    3379,  3395,  3394,  3403,  3408,  3413,  3428,  3429,  3434,  3437,
    3442,  3445,  3457,  3456,  3474,  3476,  3478,  3480,  3482,  3487,
    3492,  3500,  3501,  3505,  3506,  3510,  3516,  3527,  3528,  3537,
    3548,  3549,  3555,  3556,  3576,  3581,  3587,  3585,  3603,  3601,
    3619,  3617,  3624,  3633,  3631,  3649,  3648,  3658,  3669,  3667,
    3686,  3685,  3696,  3707,  3708,  3709,  3721,  3721,  3734,  3775,
    3818,  3822,  3827,  3819,  3839,  3861,  3869,  3861,  3878,  3877,
    3901,  3918,  3901,  3925,  3929,  3950,  3951,  3956,  3959,  3960,
    3961,  3965,  3966,  3971,  3970,  3976,  3975,  3983,  3984,  3987,
    3989,  3989,  3993,  3993,  3998,  3999,  4003,  4005,  4010,  4011,
    4015,  4023,  4033,  4034,  4035,  4036,  4037,  4038,  4039,  4040,
    4041,  4042,  4043,  4044,  4048,  4049,  4067,  4068,  4069,  4070,
    4071,  4072,  4073,  4074,  4075,  4078,  4080,  4081,  4085,  4086,
    4090,  4092,  4096,  4098,  4097,  4111,  4114,  4113,  4128,  4134,
    4144,  4146,  4150,  4152,  4157,  4158,  4183,  4187,  4188,  4192,
    4205,  4207,  4212,  4211,  4246,  4248,  4253,  4254,  4255,  4260,
    4266,  4270,  4271,  4275,  4279,  4286,  4293,  4303,  4304,  4305,
    4310,  4314,  4323,  4324,  4325,  4326,  4327,  4328,  4332,  4333,
    4334,  4335,  4336,  4340,  4340,  4350,  4351,  4355,  4371,  4370,
    4377,  4376,  4385,  4397,  4406,  4417,  4417,  4432,  4444,  4445,
    4449,  4457,  4458,  4462,  4463,  4471,  4483,  4470,  4493,  4503,
    4492,  4512,  4513,  4517,  4526,  4527,  4528,  4530,  4529,  4540,
    4541,  4545,  4546,  4548,  4547,  4551,  4550,  4556,  4557,  4561,
    4562,  4566,  4576,  4577,  4581,  4582,  4587,  4586,  4600,  4601,
    4605,  4610,  4618,  4619,  4622,  4624,  4624,  4632,  4645,  4631,
    4665,  4666,  4670,  4678,  4679,  4683,  4696,  4695,  4712,  4711,
    4722,  4723,  4727,  4731,  4743,  4745,  4752,  4751,  4764,  4804,
    4864,  4890,  4932,  4974,  5015,  5023,  5031,  5038,  5045,  5084,
    5106,  5145,  5155,  5167,  5168,  5172,  5173,  5176,  5178,  5185,
    5196,  5195,  5237,  5236,  5246,  5247,  5251,  5252,  5256,  5257,
    5258,  5271,  5270,  5284,  5285,  5290,  5289,  5295,  5300,  5305,
    5313,  5314,  5320,  5333,  5334,  5335,  5341,  5356,  5370,  5379,
    5385,  5355,  5401,  5404,  5405,  5412,  5413,  5414,  5417,  5419,
    5423,  5424,  5428,  5433,  5440,  5445,  5452,  5454,  5458,  5459,
    5463,  5468,  5475,  5477,  5485,  5486,  5490,  5491,  5492,  5496,
    5498,  5503,  5504,  5509,  5510,  5516,  5521,  5528,  5534,  5545,
    5558,  5559,  5560,  5568,  5569,  5570,  5575,  5576,  5577,  5578,
    5579,  5580,  5584,  5589,  5594,  5596,  5604,  5619,  5620,  5624,
    5630,  5639,  5643,  5655,  5659,  5669,  5673,  5693,  5709,  5729,
    5730,  5747,  5758,  5762,  5763,  5764,  5768,  5769,  5787,  5794,
    5801,  5808,  5809,  5818,  5819,  5820,  5825,  5826,  5827,  5828,
    5829,  5830,  5831,  5832,  5833,  5834,  5835,  5836,  5837,  5838,
    5839,  5840,  5841,  5842,  5843,  5844,  5854,  5855,  5856,  5857,
    5858,  5859,  5860,  5861,  5862,  5863,  5864,  5865,  5866,  5867,
    5868,  5869,  5870,  5871,  5872,  5873,  5874,  5875,  5876,  5877,
    5878,  5879,  5880,  5881,  5882,  5883,  5884,  5885,  5886,  5887,
    5888,  5889,  5890,  5891,  5892,  5893,  5894,  5895,  5896,  5897,
    5898,  5899,  5900,  5901,  5902,  5903,  5904,  5905,  5906,  5907,
    5908,  5909,  5910,  5911,  5912,  5913,  5914,  5915,  5916,  5917,
    5918,  5919,  5920,  5921,  5922,  5923,  5924,  5925,  5926,  5927,
    5928,  5929,  5930,  5931,  5932,  5933,  5934,  5935,  5936,  5937,
    5938,  5939,  5940,  5941,  5942,  5943,  5944,  5945,  5946,  5947,
    5948,  5949,  5950,  5951,  5952,  5953,  5954,  5955,  5956,  5957,
    5958,  5959,  5960,  5961,  5962,  5963,  5964,  5965,  5966,  5967,
    5968,  5969,  5970,  5971,  5972,  5973,  5974,  5975,  5976,  5977,
    5978,  5979,  5980,  5981,  5982,  5983,  5984,  5985,  5986,  5987,
    5988,  5989,  5990,  5991,  5992,  5993,  5994,  6001,  6000,  6017,
    6018,  6022,  6023,  6027,  6027,  6035,  6036,  6037,  6038,  6042,
    6043,  6047,  6048,  6049,  6050,  6054,  6055,  6056,  6057,  6061,
    6062,  6066,  6078,  6090,  6094,  6102,  6119,  6120,  6121,  6122,
    6126,  6127,  6128,  6129,  6130,  6134,  6135,  6140,  6139,  6153,
    6152,  6164,  6165,  6170,  6171,  6172,  6177,  6178,  6179,  6183,
    6184,  6188,  6202,  6213,  6226,  6238,  6255,  6256,  6261,  6260,
    6276,  6277,  6278,  6282,  6282,  6306,  6307,  6311,  6312,  6313,
    6317,  6321,  6328,  6331,  6329,  6344,  6351,  6372
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACTION", "ADD",
  "ADDDATE_SYM", "AFTER_SYM", "AGGREGATE_SYM", "ALL", "ALTER",
  "ANALYZE_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASENSITIVE_SYM",
  "AT_SYM", "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BETWEEN_SYM", "BIGINT_SYM", "BINARY", "BIN_NUM", "BIT_SYM",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM",
  "CLOSE_SYM", "COALESCE", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "COUNT_SYM", "CREATE", "CROSS",
  "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "DATABASE",
  "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME_SYM",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DELETE_SYM", "DESC", "DESCRIBE", "DETERMINISTIC_SYM", "DISABLE_SYM",
  "DISCARD", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DROP", "DUMPFILE",
  "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE", "ELSEIF_SYM",
  "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM", "END_OF_INPUT",
  "ENGINE_SYM", "ENUM_SYM", "EQ", "EQUAL_SYM", "ERRORS", "ESCAPED",
  "ESCAPE_SYM", "EXCLUSIVE_SYM", "EXISTS", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FETCH_SYM", "COLUMN_FORMAT_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FULL", "GE", "GLOBAL_SYM",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HASH_SYM", "HAVING",
  "HEX_NUM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM",
  "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF",
  "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INTERVAL_SYM", "INTO",
  "INT_SYM", "IN_SYM", "IS", "ISOLATION", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LAST_SYM", "LE",
  "LEADING", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINES",
  "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LT", "MATCH",
  "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM", "MAX_VALUE_SYM", "MEDIUM_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM", "MODE_SYM",
  "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM", "MONTH_SYM", "NAMES_SYM",
  "NAME_SYM", "NATIONAL_SYM", "NATURAL", "NE", "NEG", "NEW_SYM",
  "NEXT_SYM", "NONE_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NULL_SYM",
  "NUM", "NUMERIC_SYM", "OFFLINE_SYM", "OFFSET_SYM", "ON", "ONE_SHOT_SYM",
  "ONE_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION", "OPTIONALLY",
  "ORDER_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "PAGE_SYM",
  "PARTIAL", "PHASE_SYM", "POSITION_SYM", "PRECISION", "PREV_SYM",
  "PRIMARY_SYM", "PROCESS", "PROCESSLIST_SYM", "QUARTER_SYM", "QUERY_SYM",
  "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM",
  "REAL", "REDUNDANT_SYM", "REFERENCES", "RELEASE_SYM", "RENAME",
  "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "RESTRICT", "RETURNS_SYM",
  "RETURN_SYM", "REVERSE_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET",
  "SET_VAR", "SHARE_SYM", "SHOW", "SIMPLE_SYM", "SNAPSHOT_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CALC_FOUND_ROWS",
  "SQL_SMALL_RESULT", "SQL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STORED_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUM_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TEMPORARY_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THEN_SYM",
  "TIMESTAMP_SYM", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM",
  "TYPE_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDOFILE_SYM",
  "UNDO_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM",
  "UPDATE_SYM", "USAGE", "USER", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR_SYM",
  "VARIABLES", "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "WARNINGS",
  "WEEK_SYM", "WHEN_SYM", "WHERE", "WITH", "WITH_ROLLUP_SYM", "WORK_SYM",
  "WRITE_SYM", "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "'-'", "'+'", "'*'",
  "'/'", "'%'", "'('", "')'", "','", "'!'", "'{'", "'}'", "'.'", "'@'",
  "$accept", "query", "verb_clause", "statement", "create", "$@1", "$@2",
  "$@3", "create2", "create2a", "$@4", "create3", "$@5", "$@6",
  "create_select", "$@7", "$@8", "opt_as", "opt_create_database_options",
  "opt_database_custom_options", "custom_database_option",
  "opt_table_options", "opt_if_not_exists", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "custom_engine_option", "default_collation",
  "default_collation_schema", "column_format_types", "opt_select_from",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@9", "field_def", "type", "$@10", "char",
  "varchar", "int_type", "real_type", "float_options", "precision",
  "opt_len", "opt_precision", "opt_attribute", "opt_attribute_list",
  "attribute", "now_or_signed_literal", "collation_name",
  "collation_name_or_default", "opt_default", "opt_primary", "references",
  "opt_ref_list", "ref_list", "opt_match_clause", "opt_on_update_delete",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "init_key_options",
  "key_alg", "key_options", "key_opts", "key_using_alg", "key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@11", "$@12", "ident_or_empty",
  "alter_commands", "build_method", "alter_list", "add_column",
  "alter_list_item", "$@13", "$@14", "$@15", "opt_column", "opt_ignore",
  "opt_place", "opt_to", "start", "start_transaction_opts", "analyze",
  "$@16", "check", "$@17", "rename", "$@18", "table_to_table_list",
  "table_to_table", "select", "select_init", "select_paren",
  "select_paren_derived", "select_init2", "$@19", "select_part2", "$@20",
  "$@21", "select_into", "select_from", "select_options",
  "select_option_list", "select_option", "select_lock_type",
  "select_item_list", "select_item", "remember_name", "remember_end",
  "select_alias", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "comp_op", "all_or_any", "simple_expr",
  "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "function_call_generic", "@22",
  "opt_udf_expr_list", "udf_expr_list", "udf_expr", "sum_expr", "$@23",
  "$@24", "$@25", "variable", "$@26", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "$@27",
  "cast_type", "expr_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "$@28", "$@29", "$@30", "$@31", "$@32", "$@33", "$@34",
  "normal_join", "table_factor", "$@35", "select_derived_union", "$@36",
  "$@37", "select_init2_derived", "select_part2_derived", "$@38", "$@39",
  "select_derived", "$@40", "select_derived2", "$@41", "$@42",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@43",
  "$@44", "index_hints_list", "opt_index_hints_list", "$@45",
  "opt_key_definition", "$@46", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@47", "having_clause", "$@48", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@49", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "select_var_list_init", "$@50", "select_var_list",
  "select_var_ident", "into", "$@51", "into_destination", "$@52", "drop",
  "$@53", "table_list", "table_name", "if_exists", "opt_temporary",
  "insert", "$@54", "$@55", "replace", "$@56", "$@57", "insert2",
  "insert_table", "insert_field_spec", "$@58", "fields", "insert_values",
  "$@59", "$@60", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "$@61", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "$@62", "update", "$@63", "$@64",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "delete", "$@65", "single_multi", "$@66", "opt_delete_options",
  "opt_delete_option", "truncate", "opt_table_sym", "show", "$@67",
  "show_param", "opt_db", "from_or_in", "show_wild", "describe", "$@68",
  "$@69", "describe_command", "opt_extended_describe",
  "opt_describe_column", "flush", "$@70", "flush_options", "flush_option",
  "$@71", "opt_table_list", "kill", "kill_option", "use", "load", "$@72",
  "$@73", "$@74", "$@75", "data_file", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident",
  "ident_or_text", "keyword", "keyword_sp", "set", "$@76", "opt_option",
  "option_value_list", "option_type_value", "$@77", "option_type",
  "option_type2", "opt_var_type", "opt_var_ident_type", "ext_option_value",
  "sys_option_value", "option_value", "internal_variable_name",
  "isolation_types", "set_expr_or_default", "table_or_tables", "unlock",
  "$@78", "begin", "$@79", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@80", "union_opt",
  "union_order_or_limit", "$@81", "order_or_limit", "union_option",
  "query_specification", "query_expression_body", "$@82", "subselect",
  "subselect_start", "subselect_end", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,    45,    43,    42,    47,
      37,    40,    41,    44,    33,   123,   125,    46,    64
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   389,   390,   390,   391,   391,   392,   392,   392,   392,
     392,   392,   392,   392,   392,   392,   392,   392,   392,   392,
     392,   392,   392,   392,   392,   392,   392,   392,   392,   392,
     392,   394,   393,   395,   393,   396,   393,   397,   397,   397,
     397,   398,   399,   398,   400,   401,   400,   402,   400,   404,
     405,   403,   406,   406,   407,   407,   407,   408,   408,   409,
     409,   409,   410,   410,   411,   411,   412,   412,   413,   413,
     414,   414,   414,   415,   416,   416,   416,   416,   416,   416,
     417,   418,   419,   419,   419,   420,   420,   421,   421,   422,
     422,   423,   423,   424,   424,   424,   424,   424,   425,   425,
     426,   427,   427,   428,   430,   429,   431,   432,   432,   432,
     432,   432,   432,   432,   432,   432,   432,   432,   432,   432,
     432,   433,   432,   432,   434,   435,   435,   436,   436,   437,
     437,   437,   438,   438,   438,   439,   440,   440,   441,   441,
     442,   442,   443,   443,   444,   444,   444,   444,   444,   444,
     444,   444,   444,   444,   444,   444,   445,   445,   446,   447,
     447,   448,   448,   449,   449,   450,   451,   451,   452,   452,
     453,   453,   453,   453,   454,   454,   454,   454,   454,   455,
     455,   455,   455,   455,   456,   457,   457,   458,   458,   459,
     459,   460,   460,   460,   461,   461,   462,   463,   463,   464,
     464,   465,   465,   466,   466,   467,   467,   467,   468,   468,
     469,   469,   470,   470,   471,   471,   472,   472,   473,   473,
     475,   474,   476,   474,   477,   477,   478,   478,   478,   478,
     479,   479,   479,   480,   480,   481,   482,   482,   482,   483,
     482,   484,   485,   482,   482,   482,   482,   482,   482,   482,
     482,   482,   482,   482,   482,   482,   482,   486,   486,   487,
     487,   488,   488,   488,   489,   489,   489,   489,   490,   491,
     491,   493,   492,   495,   494,   497,   496,   498,   498,   499,
     500,   501,   501,   502,   502,   503,   503,   505,   504,   507,
     508,   506,   509,   509,   509,   509,   509,   510,   511,   511,
     512,   512,   513,   513,   513,   513,   513,   513,   513,   514,
     514,   514,   515,   515,   515,   516,   516,   517,   518,   519,
     519,   519,   519,   519,   520,   520,   521,   521,   521,   521,
     521,   521,   521,   521,   521,   521,   521,   522,   522,   522,
     522,   522,   522,   523,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   523,   524,   524,   524,   524,   524,   524,
     524,   524,   524,   524,   525,   526,   527,   528,   528,   528,
     528,   528,   528,   529,   529,   530,   530,   530,   530,   530,
     530,   530,   530,   530,   530,   530,   530,   530,   530,   530,
     530,   530,   530,   530,   530,   530,   530,   530,   530,   531,
     531,   531,   531,   531,   531,   531,   531,   531,   531,   531,
     531,   531,   531,   531,   531,   531,   531,   531,   531,   531,
     531,   531,   531,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   533,   533,   533,   533,   533,   533,
     533,   533,   533,   533,   533,   535,   534,   536,   536,   537,
     537,   538,   539,   539,   539,   539,   540,   541,   539,   539,
     539,   539,   539,   539,   539,   539,   539,   539,   539,   542,
     539,   544,   543,   545,   545,   545,   546,   546,   547,   547,
     548,   548,   550,   549,   551,   551,   551,   551,   551,   552,
     552,   553,   553,   554,   554,   555,   555,   556,   556,   557,
     558,   558,   559,   559,   560,   560,   561,   560,   562,   560,
     563,   560,   560,   564,   560,   565,   560,   560,   566,   560,
     567,   560,   560,   568,   568,   568,   570,   569,   569,   569,
     571,   572,   573,   571,   574,   576,   577,   575,   579,   578,
     581,   582,   580,   583,   584,   585,   585,   586,   586,   586,
     586,   587,   587,   589,   588,   590,   588,   591,   591,   592,
     593,   592,   595,   594,   596,   596,   597,   597,   598,   598,
     599,   599,   600,   600,   600,   600,   600,   600,   600,   600,
     600,   600,   600,   600,   601,   601,   602,   602,   602,   602,
     602,   602,   602,   602,   602,   603,   603,   603,   604,   604,
     605,   605,   606,   607,   606,   608,   609,   608,   610,   610,
     611,   611,   612,   612,   613,   613,   614,   615,   615,   616,
     617,   617,   619,   618,   620,   620,   621,   621,   621,   622,
     622,   623,   623,   624,   625,   625,   625,   626,   626,   626,
     627,   627,   628,   628,   628,   628,   628,   628,   629,   629,
     629,   629,   629,   631,   630,   632,   632,   633,   635,   634,
     637,   636,   636,   636,   638,   639,   638,   638,   640,   640,
     641,   642,   642,   643,   643,   645,   646,   644,   648,   649,
     647,   650,   650,   651,   652,   652,   652,   653,   652,   654,
     654,   655,   655,   656,   655,   657,   655,   658,   658,   659,
     659,   660,   661,   661,   662,   662,   664,   663,   665,   665,
     666,   666,   667,   667,   668,   669,   668,   671,   672,   670,
     673,   673,   674,   675,   675,   676,   678,   677,   680,   679,
     681,   681,   682,   683,   684,   684,   686,   685,   687,   687,
     687,   687,   687,   687,   687,   687,   687,   687,   687,   687,
     687,   687,   687,   688,   688,   689,   689,   690,   690,   690,
     692,   691,   693,   691,   694,   694,   695,   695,   696,   696,
     696,   698,   697,   699,   699,   701,   700,   700,   700,   700,
     702,   702,   703,   704,   704,   704,   705,   707,   708,   709,
     710,   706,   711,   712,   712,   713,   713,   713,   714,   714,
     715,   715,   716,   716,   716,   716,   717,   717,   718,   718,
     719,   719,   720,   720,   721,   721,   722,   722,   722,   723,
     723,   724,   724,   725,   725,   726,   726,   727,   727,   727,
     728,   728,   728,   729,   729,   729,   729,   729,   729,   729,
     729,   729,   730,   730,   730,   730,   730,   731,   731,   732,
     732,   733,   734,   734,   735,   735,   736,   736,   736,   737,
     737,   737,   737,   738,   738,   738,   739,   739,   740,   741,
     742,   743,   743,   744,   744,   744,   745,   745,   745,   745,
     745,   745,   745,   745,   745,   745,   745,   745,   745,   745,
     745,   745,   745,   745,   745,   745,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   748,   747,   749,
     749,   750,   750,   752,   751,   753,   753,   753,   753,   754,
     754,   755,   755,   755,   755,   756,   756,   756,   756,   757,
     757,   758,   758,   759,   759,   760,   761,   761,   761,   761,
     762,   762,   762,   762,   762,   763,   763,   765,   764,   767,
     766,   768,   768,   769,   769,   769,   770,   770,   770,   771,
     771,   772,   773,   773,   774,   775,   776,   776,   778,   777,
     779,   779,   779,   781,   780,   782,   782,   783,   783,   783,
     784,   784,   785,   786,   785,   787,   788,   789
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     7,     0,    13,     0,     6,     2,     2,     3,
       4,     4,     0,     4,     0,     0,     5,     0,     7,     0,
       0,     6,     0,     1,     0,     1,     1,     1,     3,     1,
       3,     3,     0,     1,     0,     3,     0,     1,     1,     2,
       1,     2,     3,     1,     3,     3,     3,     3,     3,     1,
       4,     4,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     2,     2,     7,     8,     8,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     3,     2,     1,     2,     4,
       1,     4,     4,     1,     1,     1,     1,     1,     2,     2,
       2,     0,     5,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     0,     3,     1,     5,     0,     3,     0,     1,
       0,     1,     2,     1,     1,     2,     2,     2,     4,     1,
       3,     2,     1,     2,     2,     2,     2,     1,     1,     1,
       1,     0,     1,     0,     1,     5,     0,     3,     3,     1,
       0,     2,     2,     2,     0,     3,     3,     6,     6,     1,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     0,     1,     2,     0,
       1,     1,     2,     2,     2,     1,     3,     2,     1,     1,
       4,     2,     1,     4,     0,     1,     0,     2,     1,     3,
       0,     7,     0,     5,     0,     1,     0,     2,     2,     1,
       0,     1,     1,     1,     3,     2,     3,     2,     4,     0,
       6,     0,     0,     7,     3,     4,     3,     3,     2,     2,
       6,     5,     3,     3,     1,     1,     1,     0,     1,     0,
       1,     0,     2,     1,     0,     1,     1,     1,     3,     0,
       3,     0,     4,     0,     4,     0,     4,     1,     3,     3,
       1,     2,     4,     2,     3,     2,     3,     0,     3,     0,
       0,     6,     2,     1,     1,     2,     2,     7,     0,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     3,     4,     0,     0,     0,
       2,     2,     1,     1,     0,     2,     3,     3,     3,     2,
       3,     4,     3,     4,     3,     4,     1,     3,     4,     3,
       3,     6,     1,     5,     6,     5,     7,     6,     8,     5,
       6,     4,     5,     1,     3,     3,     5,     5,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     2,     2,     3,     3,     5,     6,
       4,     4,     2,     6,     5,     6,     4,     4,     5,     4,
       2,     4,     4,     4,    10,     6,     8,     6,     4,     4,
       6,     4,     4,     4,     7,     7,     7,     6,     6,     6,
       6,     3,     4,     6,     8,     2,     8,     8,     6,     2,
       4,     6,     6,     8,     8,     6,     8,     6,     2,     4,
       8,     8,     2,     2,     4,     4,     3,     8,     4,     6,
       4,     6,     8,     4,     6,     0,     5,     0,     1,     1,
       3,     4,     4,     5,     5,     4,     0,     0,     7,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     1,     0,     3,     2,     2,     1,     1,     2,     1,
       3,     0,     1,     0,     2,     4,     5,     1,     1,     1,
       1,     4,     1,     3,     3,     3,     0,     6,     0,     6,
       0,     8,     4,     0,     8,     0,    10,     6,     0,     8,
       0,    10,     6,     1,     2,     2,     0,     4,     3,     5,
       3,     0,     0,     8,     1,     0,     0,     6,     0,     3,
       0,     0,     5,     0,     1,     0,     1,     0,     2,     3,
       3,     1,     1,     0,     7,     0,     7,     1,     2,     0,
       0,     2,     0,     2,     0,     1,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     0,     2,
       0,     1,     0,     0,     3,     0,     0,     3,     2,     0,
       0,     4,     4,     2,     0,     1,     3,     3,     1,     2,
       0,     1,     0,     4,     4,     2,     0,     1,     1,     0,
       1,     0,     1,     2,     1,     3,     3,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     3,     1,     2,     0,     3,
       0,     5,     2,     1,     5,     0,     7,     4,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     7,     0,     0,
       5,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    10,
       3,     1,     3,     3,     1,     3,     0,     4,     0,     6,
       0,     2,     1,     3,     0,     1,     0,     3,     2,     3,
       3,     4,     5,     5,     5,     5,     2,     2,     3,     1,
       3,     4,     3,     0,     2,     1,     1,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     0,     1,     0,     1,
       1,     0,     3,     3,     1,     0,     3,     4,     1,     1,
       0,     1,     3,     0,     1,     1,     2,     0,     0,     0,
       0,    18,     1,     0,     1,     0,     1,     1,     0,     2,
       2,     1,     3,     4,     3,     3,     0,     2,     2,     1,
       3,     3,     0,     3,     1,     1,     0,     3,     2,     3,
       1,     1,     2,     0,     2,     1,     2,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     0,
       1,     1,     3,     0,     2,     1,     1,     1,     1,     0,
       1,     0,     1,     1,     1,     0,     2,     2,     2,     1,
       2,     4,     5,     4,     6,     1,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     0,
       3,     0,     1,     0,     3,     2,     0,     1,     2,     0,
       1,     4,     4,     5,     2,     3,     0,     1,     0,     4,
       0,     1,     1,     0,     2,     2,     1,     0,     1,     1,
       2,     3,     1,     0,     5,     3,     0,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   230,     0,  1089,     0,  1091,   230,   736,   774,   775,
     683,     2,   781,   685,   793,     0,     0,     0,   688,  1091,
       0,   289,  1049,   746,     0,   744,  1087,   259,     0,     0,
       0,     0,     4,    10,     6,    26,     7,     8,    19,    23,
     280,    13,    15,    20,    29,    11,    27,    25,    12,   776,
      14,    16,    30,    17,    24,    28,     5,     9,    21,    22,
      18,   224,   232,   231,   259,  1086,  1085,   271,  1091,   273,
    1092,  1093,    64,    63,     0,    33,   740,   681,   684,     0,
       0,     0,   259,   794,   795,     0,   802,   797,     0,   275,
       0,  1093,   906,   907,   908,   909,   910,   911,   912,   913,
     914,   887,   915,   917,   916,   918,   888,   919,   920,   889,
     890,   921,   922,   924,   891,   925,   892,   926,   927,   928,
     929,   930,   893,   931,   933,   934,   932,   935,   936,   937,
     894,   938,   939,   940,   941,   942,   951,   895,   943,   945,
     944,   946,   947,   948,   949,   923,   953,   954,   955,   896,
     950,   956,   952,   957,   958,   959,   876,   960,   877,   961,
     962,   963,   964,   965,   966,   967,   968,   969,   970,   971,
     972,   973,   974,   975,   976,   977,   978,   980,   979,   981,
     983,   982,   984,   986,   985,   987,   897,   988,   989,   990,
     991,   992,   898,   993,   994,   995,   996,   997,   998,   999,
    1000,  1001,  1002,  1003,  1004,  1005,   899,  1006,  1007,  1008,
    1009,  1010,   900,  1011,   901,  1013,  1012,  1014,   902,  1016,
    1015,  1017,  1018,   903,  1019,   904,  1020,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,  1029,  1030,  1032,  1033,  1034,
    1031,   905,  1035,  1036,  1037,  1038,  1039,  1040,  1042,  1041,
    1043,  1044,  1045,  1046,   881,  1104,   882,   886,   281,   287,
     298,  1050,  1047,  1061,   269,   745,     0,     0,   260,     0,
     796,   289,     0,     0,     1,     3,   949,     0,   772,   770,
     873,   222,   225,     0,     0,  1090,     0,     0,  1096,     0,
       0,    64,   194,   742,     0,   740,     0,     0,     0,   681,
     788,   789,  1086,   782,   784,   785,     0,   907,   914,     0,
     849,   501,     0,     0,   921,   922,     0,     0,   324,   324,
       0,     0,     0,   936,   937,   855,     0,     0,     0,   846,
     856,     0,   848,   959,     0,     0,     0,     0,   853,     0,
     976,   977,     0,     0,   981,     0,   324,   845,   852,     0,
     999,     0,     0,  1005,     0,  1010,  1011,     0,     0,  1022,
       0,     0,   324,   879,  1032,  1033,  1034,     0,   847,   905,
     854,  1040,   324,   324,     0,     0,     0,  1046,     0,     0,
    1126,     0,     0,   481,   792,   336,   342,   353,   363,   376,
     377,   379,   378,   383,   382,   843,   381,   844,   375,   863,
     881,   835,   862,   803,  1105,     0,     0,   693,   689,   692,
     680,  1099,  1096,  1106,   308,   303,   305,   306,   307,   304,
     302,   317,   299,   301,  1053,     0,     0,     0,   767,   639,
    1062,   193,   192,   191,  1063,   759,  1064,   763,     0,     0,
     639,     0,   747,     0,     0,   268,   743,  1088,   727,   283,
       0,  1110,   875,     0,   778,     0,   161,     0,   272,   678,
     274,  1095,     0,     0,  1097,  1101,   366,     0,    35,     0,
     195,     0,     0,   737,   741,   682,   677,     0,     0,     0,
       0,   790,   686,     0,   610,   392,   502,     0,     0,     0,
       0,     0,     0,   610,     0,   425,   400,     0,     0,     0,
       0,   850,     0,     0,  1126,     0,   486,     0,     0,     0,
    1126,     0,     0,   610,     0,     0,   610,     0,     0,   329,
       0,   429,     0,     0,     0,     0,     0,     0,     0,     0,
     610,   610,     0,     0,   610,     0,   438,     0,   851,     0,
       0,     0,     0,     0,   442,   443,     0,   610,   610,     0,
     385,   384,     0,     0,     0,     0,     0,     0,   365,   364,
       0,     0,     0,   367,     0,   368,   369,     0,   370,   371,
     372,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   836,   455,     0,   804,     0,   276,
     277,     0,   691,     0,  1100,     0,  1102,  1117,   288,  1107,
     314,   290,   313,     0,   300,  1048,  1051,  1059,   765,   766,
       0,     0,    64,     0,     0,     0,   748,     0,   757,   640,
     767,     0,   763,   767,   756,     0,   767,   767,     0,     0,
     284,  1111,   282,  1112,     0,   773,   839,   838,   771,   779,
     837,   780,   874,   162,   223,     0,   220,     0,  1094,  1098,
      65,    54,    31,     0,   738,     0,   674,     0,   783,   791,
     786,     0,     0,   611,   610,     0,   492,     0,   503,     0,
     499,     0,     0,     0,     0,   466,     0,   492,   325,   446,
       0,     0,     0,     0,     0,     0,   583,   584,   585,   586,
     596,   587,   588,   589,   598,   603,   590,   591,   599,   600,
     601,   592,   602,   597,   593,   604,     0,   582,   487,   479,
       0,     0,     0,     0,     0,     0,   610,     0,     0,     0,
     610,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   610,     0,     0,
       0,   595,     0,   594,     0,     0,     0,     0,     0,     0,
     421,     0,   865,   864,     0,     0,     0,   387,     0,   386,
     545,     0,  1122,  1127,     0,     0,   885,   878,  1065,   482,
     884,   883,   484,   327,   326,   328,   339,   332,   337,   330,
     334,     0,   373,   910,   340,     0,     0,   361,  1126,   619,
     362,     0,   355,     0,   354,   358,   359,   360,     0,     0,
       0,   380,   317,   866,     0,     0,     0,    49,   697,     0,
       0,     0,   703,   690,   694,  1103,  1119,  1118,  1108,   317,
     630,   318,   318,   862,  1053,  1056,  1057,  1060,  1058,     0,
    1055,  1054,  1069,   763,     0,     0,   762,   768,   769,   648,
     649,   647,   643,   644,   749,   764,   767,   750,   763,   758,
     760,   270,     0,     0,   639,  1116,  1114,   714,   161,   679,
      36,    56,    57,    55,    59,    66,   196,   612,   675,   787,
     724,     0,     0,   462,     0,     0,     0,     0,     0,     0,
     399,     0,   444,   445,     0,     0,   465,     0,     0,     0,
     401,   402,   396,   390,     0,     0,   403,     0,     0,     0,
       0,     0,     0,   471,   448,   408,     0,   469,     0,   409,
     430,     0,   450,     0,     0,   453,     0,     0,   411,   475,
     473,     0,     0,     0,     0,   477,   439,   412,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,     0,   397,
     474,   476,   422,     0,  1120,   544,   298,   545,     0,     0,
    1117,  1125,   391,   867,     0,     0,     0,     0,     0,   333,
     338,   331,   335,  1126,     0,     0,     0,     0,   351,     0,
       0,     0,  1126,   619,     0,     0,   458,   459,     0,   880,
     798,   278,   279,   298,     0,   716,   701,   708,   702,     0,
       0,     0,   700,   858,   857,   864,  1106,     0,   312,   536,
     668,   309,   294,   641,   631,   293,   319,   315,     0,  1052,
    1031,  1075,     0,     0,  1070,   767,     0,   761,     0,     0,
     751,   612,   728,   731,     0,   632,  1115,   712,   713,   715,
       0,   257,   257,   714,   257,   714,     0,   938,   939,   257,
     951,     0,   255,   961,   257,     0,   264,   254,    68,    73,
      79,     0,   221,   229,     0,   233,   256,     0,     0,     0,
       0,   101,    32,   805,    67,    70,   197,     0,   613,   630,
     676,     0,   687,     0,     0,   463,   493,     0,   504,     0,
     394,   136,   136,   497,   496,   132,     0,   500,     0,   467,
     464,     0,     0,     0,   490,     0,     0,     0,   398,     0,
     472,   470,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   478,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   388,   317,   285,     0,  1121,  1123,  1066,
    1067,  1068,   216,   483,     0,   349,   345,     0,   343,   618,
     357,   356,     0,     0,     0,   352,   318,   456,   317,   868,
     805,   317,   698,   710,     0,   718,     0,     0,   695,   705,
       0,     0,   704,  1109,   554,   553,     0,   510,   612,   512,
     509,   508,   507,     0,   553,   663,     0,     0,   291,   296,
     292,   642,   295,     0,   316,   323,   322,   859,   866,     0,
       0,  1065,     0,   752,   755,   754,   646,   645,   753,     0,
     612,     0,     0,   160,   159,    81,   158,   258,   214,   188,
     187,   237,     0,    98,   214,   184,   235,     0,     0,     0,
       0,     0,   248,   227,     0,     0,     0,     0,   249,     0,
     228,     0,     0,   267,   266,   265,     0,    69,   714,   161,
     101,     0,   261,    98,   104,   869,     0,    58,   661,   662,
     660,   658,   659,    61,    60,    66,     0,    37,     0,     0,
      87,    89,    90,   807,   806,    38,    52,   161,    71,     0,
       0,   198,     0,     0,   650,   725,     0,   423,   505,     0,
       0,   494,   495,     0,   498,   134,   393,   395,     0,     0,
       0,   428,   488,   491,     0,     0,   405,     0,   407,   449,
     431,   451,     0,   410,   389,     0,   432,     0,   437,   435,
       0,     0,     0,   419,     0,   417,     0,   418,     0,   420,
     454,   546,   286,     0,     0,   485,   341,     0,   350,   347,
       0,   344,   319,   460,     0,    50,     0,     0,   723,   722,
       0,   719,   721,   707,  1110,   696,   699,   553,   536,     0,
       0,   533,   555,     0,   555,   536,   536,   620,   536,   605,
     550,     0,     0,   673,     0,   669,   310,     0,   321,   320,
       0,     0,  1083,  1084,  1081,  1082,  1080,  1071,     0,     0,
     730,   630,   732,   861,   633,   636,   103,   215,     0,     0,
       0,   189,    97,   214,    96,    99,   196,     0,    76,   239,
      75,   253,   214,   246,   247,   244,    74,   241,   626,   628,
     636,   252,     0,   234,     0,   872,     0,   263,   236,     0,
      91,    92,     0,     0,    78,    77,    39,     0,    42,    66,
     101,    53,     0,    72,   208,   209,   204,   203,     0,   614,
       0,   739,     0,     0,   506,     0,     0,   468,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   416,   414,   415,   641,  1124,   217,   346,     0,   461,
     799,   641,   709,   711,   717,     0,   706,     0,   630,   548,
       0,   535,   534,   556,     0,   536,   555,   555,     0,   515,
     514,     0,   615,   513,   606,   607,     0,   572,   538,   298,
     672,   670,     0,   664,   666,     0,   860,     0,     0,  1079,
    1072,     0,  1073,   650,     0,   637,   638,   635,   100,   214,
     185,   190,   186,   196,     0,     0,     0,     0,   245,     0,
       0,   629,    80,   238,   262,   166,   128,   116,   124,   115,
     113,   132,   130,   121,   132,   127,   132,   129,   123,   117,
     114,     0,   126,   105,   140,   110,     0,   107,   138,   871,
      40,  1113,   805,    88,     0,    45,     0,   651,     0,   424,
     137,   133,     0,   426,   427,   489,   480,   447,     0,   406,
     452,   433,   436,   434,   440,   441,   309,   309,    85,   348,
       0,    51,   720,  1117,   605,   641,   536,   511,   536,   522,
       0,     0,   536,   518,   516,   520,     0,   616,   630,   609,
     537,   569,   317,   808,   667,     0,   311,  1077,  1076,  1078,
       0,   729,   636,     0,     0,     0,   251,     0,   261,   242,
     627,     0,   170,   118,   131,     0,   120,   119,     0,   149,
       0,     0,     0,     0,   144,     0,   164,     0,   152,   106,
     141,   143,     0,     0,   125,     0,     0,     0,   139,   108,
       0,    43,    41,     0,  1106,     0,   636,   212,     0,     0,
       0,   547,    86,     0,   541,   539,   540,   549,     0,   507,
     536,   536,     0,   507,     0,     0,     0,   624,   636,     0,
     641,   573,     0,   551,     0,   816,   665,  1074,   634,     0,
       0,     0,     0,     0,     0,     0,   250,   840,   240,   261,
       0,   169,     0,   174,     0,     0,   155,   154,   324,   147,
     157,    82,    84,    83,   145,     0,     0,   153,   142,   151,
     146,     0,     0,     0,   870,    47,    46,   199,     0,   211,
       0,   726,   734,     0,   135,   404,   800,     0,   523,     0,
     527,   532,   528,     0,   519,   517,     0,   625,     0,   621,
     623,   617,   297,   561,   562,     0,     0,   567,   571,   641,
       0,     0,     0,     0,   809,   811,     0,   671,     0,     0,
     199,   842,   841,   243,   167,     0,   171,   172,   173,     0,
     165,     0,   218,   112,   156,   324,   150,   109,   111,  1113,
       0,   714,    34,   200,   205,   201,   636,     0,     0,     0,
     808,   542,     0,     0,     0,     0,     0,   580,   636,   557,
     557,   568,   552,     0,     0,     0,     0,   810,     0,     0,
     817,   819,     0,   199,    93,   168,     0,     0,   122,     0,
     148,    48,   207,     0,   202,   210,   213,   733,   735,   816,
     630,   524,     0,   529,     0,   521,     0,   622,     0,   565,
     563,   814,   815,     0,   812,     0,     0,   818,    95,    94,
     180,     0,   179,     0,   176,   175,   219,   656,   657,   653,
     654,   652,   655,   206,   822,   641,     0,     0,   581,     0,
     558,     0,     0,     0,   813,   821,   820,   182,   183,   181,
       0,     0,     0,   826,   543,   526,   531,   560,   559,   574,
       0,     0,     0,     0,     0,   833,   577,     0,   578,   575,
     576,     0,   178,   177,   824,   825,   823,   828,     0,     0,
     830,   831,     0,   801,   566,     0,   564,   832,   827,     0,
     834,   579,   829
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    30,    31,    32,    33,   865,   292,   651,  1062,  1257,
    1561,  1265,  1664,  1799,   812,   983,  1471,  1432,   860,   861,
     862,    74,   290,  1063,  1047,  1064,  1065,  1049,  1050,   644,
    1724,  1586,  1259,  1260,  1261,  1262,  1394,  1395,  1212,  1213,
    1243,  1422,  1553,  1554,  1635,  1555,  1556,  1557,  1558,  1284,
    1285,  1281,  1659,  1649,  1650,  1651,  1719,  1204,  1205,  1051,
    1652,  1421,  1632,  1710,  1713,  1790,  1874,  1214,  1393,  1215,
    1522,   441,   471,  1066,  1067,  1802,  1803,  1804,  1805,  1436,
    1665,  1666,  1386,  1325,  1791,    34,   858,   456,   281,  1052,
      64,  1053,  1054,  1055,  1527,  1529,  1709,  1216,   269,  1418,
    1236,    35,   445,    36,   284,    37,   286,    38,   405,   589,
     590,    39,    40,   273,   949,   258,   413,   259,   260,   820,
    1001,  1587,   421,   422,   423,  1178,   601,   602,   603,  1006,
    1184,   495,   670,   385,   386,   387,   561,   562,  1653,   571,
     785,   388,   389,   390,   391,   392,   802,   975,   976,   977,
     393,   885,  1288,   895,   394,   557,   769,   709,  1451,  1292,
     665,   874,  1086,   943,   487,   878,   668,  1167,  1168,  1169,
    1170,  1171,  1685,  1684,  1686,  1812,  1749,  1814,  1753,  1356,
    1172,  1173,  1477,  1747,  1850,   944,   945,   946,  1464,  1478,
    1596,  1498,  1499,  1769,  1347,  1174,  1484,  1859,  1766,  1767,
    1893,  1892,  1768,  1691,  1692,  1610,  1611,  1917,  1918,  1919,
    1816,   706,   742,   707,  1496,  1497,   666,  1069,  1273,  1608,
    1689,   968,  1492,  1687,  1759,  1056,  1408,  1409,  1003,  1004,
    1202,  1384,  1517,   618,  1588,  1181,   842,   843,  1441,  1883,
    1253,  1363,  1364,  1503,  1504,  1005,  1175,  1365,  1613,    41,
    1070,   458,   459,   297,    80,    42,    82,   661,    43,    90,
     593,   408,   409,   813,   984,   991,   814,   996,  1344,   986,
    1152,  1153,  1029,  1030,   987,  1155,  1340,  1341,  1342,  1072,
    1442,    44,   629,  1200,  1022,  1023,  1741,  1742,    45,    76,
     473,   867,   294,   295,    46,   266,    47,   263,   442,   620,
     621,   616,    48,   454,   453,    49,   278,   638,    50,    81,
     303,   304,   481,   660,    51,    85,    52,    53,   403,  1150,
    1590,  1810,    87,   588,  1266,  1695,  1774,  1775,  1777,  1830,
    1831,  1903,  1926,  1915,  1929,  1930,  1933,   395,   639,  1706,
     396,   397,   992,   993,  1385,   398,  1743,   399,  1244,   410,
     400,   770,   401,   980,   402,  1057,   256,   257,    54,   424,
     262,   605,   606,   607,   829,   830,   443,   957,   831,   832,
    1014,  1012,  1510,  1377,   305,    55,   267,    56,    68,    71,
     288,   465,   595,    57,    58,    59,    60,   598,   631,   997,
     632,   633,   634,   856,   818,   762,   763,  1323,   553,   554,
     951
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -1698
static const yytype_int16 yypact[] =
{
    1404,   506,   511, -1698,   511,  -181,     2, -1698, -1698, -1698,
     456, -1698, -1698, -1698,    49,   126,   -60,   511, -1698,  -181,
   19706, -1698,   172, -1698,   -88,   -53, -1698,   262, 19706,  -146,
     466,   434, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, 12365,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, 19706, -1698, -1698,   262, -1698, -1698, -1698,  -181, -1698,
   -1698,   559,   483, -1698,   260, -1698,   522,   507, -1698,   534,
     511,   471,   262, -1698, -1698,  5654, -1698, -1698, 19706, -1698,
   11633,    36, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
     765, -1698, -1698,  1612,   384, -1698, 12731,   511, -1698, 12731,
   -1698, -1698,  -146,   415, -1698, -1698,   307, 19706, -1698, -1698,
     421, -1698, -1698,   509, 12731, -1698, 12731,    81,   388,   622,
   19706,   483,   503, -1698,   736,   522,   743, 19706, 19706,   507,
   -1698, -1698,   515,   530, -1698, -1698, 11633,   537,   540,  7919,
   -1698,  5654,   542,   544,   560,   562,   576,   580,   582,   582,
     585,   593,   598,  -187,   611, -1698,   656,   687,   703, -1698,
   -1698,   740, -1698,   747,   755,   756,  6030,   757, -1698,   761,
     764,   768,   773,   776,   778,  5654,   779, -1698, -1698,   781,
     783,   784,   785,   786,   789,   791,   799,   800,   801,   803,
     806,   810,   817, -1698,  -177,   819,   821,   823, -1698,   829,
   -1698,   833,   582,   582,   834,   841,   842,   844,  7919,  7919,
    5654, 19706, 19706, -1698,    53,  1137, -1698,   702,   887, -1698,
   -1698, -1698, -1698, -1698, -1698,   627, -1698, -1698, -1698, -1698,
     847, -1698,   583,   941, -1698, 12731, 12731, -1698, -1698, -1698,
   -1698,   744,   388,   752, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698,   731,   765, -1698, -1698,   491,   848,   -12,   -84,   944,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698,   491,   838,   851,
     944,   491, -1698,  -153,  1171, -1698, -1698, -1698, -1698, -1698,
     849,     1, -1698,   376, 17144, 19706,  1145, 12731,   854, -1698,
     854, -1698,  1194,   980, -1698, -1698, -1698,  1123, -1698, 12731,
   -1698,  1089, 12731, -1698, -1698, -1698, -1698,  1017, 12731,   991,
     471, 12731, -1698,  5654,   129,   887,    53,   884,  5654,  5654,
    5654,  5654,  5654,   251,   874, -1698, -1698,   875,  5654,  5654,
    5654,   627,  5654, 13097, -1698,  2149,  1167,  5654,  5654,  5654,
    5654,  1359,  5654,   589,  5654,  5654,   770,  5654,  5654, -1698,
    4141, -1698,  7919,  5654,  5654,  5654,  5654,  5654,  5654,  5654,
    1254,  1254,  5654,  5654,   792,  4141, -1698,  5654,   627,   993,
     993,  3380,  5654,   883, -1698, -1698, 13097,  1254,  1254,  5654,
     887,   887,    60,   885,   499,  5654,   879,  9047, -1698, -1698,
    5654,  5654,  5654, -1698,  7919, -1698, -1698,   910, -1698, -1698,
   -1698,  6415,  7919,  7919,   888,  7919,  7919,  8295,  8671,  7919,
    7919,  7919,   104, 18242, -1698, -1698, 19706, -1698,  1112,   891,
   -1698,   945, -1698,   518, -1698, 19706, -1698,   808, -1698, -1698,
   -1698,   892, -1698,  5654, -1698,   895, -1698,    -7, -1698, -1698,
   12731,   902,   483, 12731,   953,  5654, -1698,   429, -1698, -1698,
     -84, 19706,   491,   -84, -1698, 12731,   -84,   -84,   988,   995,
   -1698, -1698, -1698, -1698,    29, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698,  1238, -1698, 12731, -1698, -1698,
   -1698, 16412, -1698, 19706, -1698, 12731,   854,  1099, -1698,   854,
   -1698,   518,    55, -1698,  1254,   905, -1698,  5654,   -34,    77,
      53,   490,   513,   179,    82, -1698,   906,   911, -1698, -1698,
     117,   120,   180,   187,   908,   912, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698,  1159, -1698, -1698, -1698,
     209,   131,   132,    74,   918,   134,  1254,   914,   244,   247,
    1254,   921,   137,   269,   293,   798,   294,   138,   140,   296,
     146,   151,   318,   923,   924,   152,    38,  1254,   925,   320,
     331, -1698,   931, -1698,   932,  4526,  4902,  5278,    97,   155,
   -1698,   926, -1698,   583,   936,   938,   333, -1698,  5654, -1698,
   -1698,   538, -1698,   976,    37, 19706, -1698, -1698,    79, -1698,
   -1698, -1698,  1033,  1314,    40, -1698, -1698, -1698, -1698, -1698,
   -1698,   590, -1698,   949, -1698,   950,   673, -1698,  5654,   561,
   -1698,  6030,   727,  6030,   727, -1698, -1698, -1698,  7919,   952,
    7919, -1698,   946,   951,  1008, 12731, 12731, -1698, -1698,   956,
     956, 11267, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
      14,    53, -1698,   955, -1698, -1698, -1698, -1698, -1698, 20072,
     957, -1698, -1698,   491,   961, 19706, -1698, -1698,    53, -1698,
   -1698, -1698, -1698,   -48, -1698, -1698,   -84, -1698,   491, -1698,
   -1698, -1698, 13097,  1311,   944, -1698, -1698,    22, 15308, -1698,
   -1698, -1698,   963, -1698,    22, 14201, -1698,   979, -1698, -1698,
    1120,  6791,   967, -1698,  5654,    54,  5654,  5654,  1244,  1072,
   -1698,  5654, -1698, -1698,  1072,  5654, -1698,   971,  1193,  1196,
   -1698, -1698, -1698, -1698,  5654,  5654, -1698,  5654,  5654,  5654,
    5654,  5654,   978, -1698, -1698, -1698,   981, -1698,  5654, -1698,
   -1698,  5654, -1698,  5654,  5654, -1698,  5654,  5654, -1698, -1698,
   -1698,  7167,  5654,  5654,   982, -1698, -1698, -1698,  5654,  5654,
    5654,   113,  5654,   281,  5654,   510,  5654, -1698,  5654, -1698,
   -1698, -1698, -1698,   533, -1698, -1698,   765, -1698,   538,   984,
     808, -1698, -1698, -1698,   975,   983,   987, 18242,  5654, -1698,
   -1698, -1698, -1698, -1698,  7919,    94,   990,  7919, -1698,  1359,
    1359,   682,  5654,   561,  5654,   994,   992, -1698, 19706, -1698,
   -1698, -1698, -1698,   765, 13097, -1698,   996, -1698,   996,   283,
     998,   567, -1698, -1698, -1698,   955,   752,   376, -1698,  -127,
   -1698,   505,  1215,   944, -1698,  1247, 18608, -1698, 14567, -1698,
    1218, -1698,    22,  9419, -1698,   -84,   -26, -1698,   429,   429,
   -1698,   979,  1005, -1698,    22, -1698, -1698, -1698, -1698, -1698,
   17510,   686,  1339,    22,  1339,    22,  1056,  1222,  1070,   775,
    1225,    22, -1698,  1081,    61,  1362,    48, -1698, 16778, -1698,
   -1698,  1358, -1698,  1023, 11999, -1698, -1698,    22, 18242, 16046,
   12731, 10535, -1698,   480, -1698, 13829,   319,  1179, -1698,  1175,
   -1698,  1313, -1698,  6030,   336, -1698,    53,  5654,    53,   360,
   -1698,  1036,  1036, -1698, -1698,  1037,  1038,    53,  1042,  1045,
   -1698,  5654,  5654,   337,  -122,   159,   163,   105, -1698,   347,
   -1698, -1698,   367,   378,   379,   166,   382,   577,  6030,   385,
     194,   116, -1698,   168,   171,   386,  5654,   470,  5654,   485,
    5654,   504,   528, -1698,   731, -1698,  1043, -1698, -1698, -1698,
   -1698, -1698,  1047,    53,  1061, -1698, -1698,  5654, -1698,   887,
   -1698, -1698,  7919,   119,  1062, -1698,    53, -1698, -1698, -1698,
     -28,   731,  1064, -1698,    22,  7543,   956,  1148, -1698, -1698,
     283, 13097, -1698, -1698, -1698, -1698, 19706,   947,   979, -1698,
    1068, -1698, -1698, 12731, -1698,    16,  1095,  1288, -1698, -1698,
   -1698, -1698, -1698, 18974, -1698, -1698, -1698, -1698,  1067,  1278,
    3765,    79,    22, -1698, -1698, -1698, -1698, -1698, -1698, 13097,
     979,  7543,  5654, -1698, -1698, -1698, -1698, -1698, 13463, -1698,
   -1698, -1698,    75,    93, 13463, -1698, -1698, 13463,   623, 13463,
     953, 17510, -1698, -1698,  1285,  1287, 13463, 13463, -1698, 18242,
   -1698, 13463, 13097, -1698, -1698, -1698, 12731, -1698,    22, 15680,
   10901, 19706,   115,    58, -1698,  1073, 16046, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1698, 16778, 12731, -1698,  1077,   595,
   -1698, -1698, -1698, -1698, -1698, -1698,  1447, 17876, -1698,   101,
     101, -1698, 12731,  5654,  1282, -1698,  1359, -1698,    53,  5654,
    1239, -1698, -1698,  1240, -1698, -1698, -1698, -1698,  1083,  1359,
    1359, -1698,  1185, -1698,  5654,  5654, -1698,  5654, -1698, -1698,
   -1698, -1698,  5654, -1698, -1698,  1359, -1698,  5654, -1698, -1698,
    5654,  5654,  5654, -1698,   535, -1698,   547, -1698,   553, -1698,
   -1698,   892, -1698,   499, 19706, -1698, -1698,   607, -1698, -1698,
    5654, -1698, 18608, -1698,  1309,   892, 13097,  7543,   656,    53,
    1092,  1097, -1698, -1698,     1, -1698, -1698, -1698,   543,  1307,
    1310, -1698,  1243,   -29,  1243,   543,   543,  1345,  -127,   717,
   -1698,  1008,  1008, -1698,  1096, -1698, -1698,  1195, -1698, -1698,
   14933,   616, -1698,  7919,   656, -1698,    53, -1698, 19706,  5654,
   -1698,  1175, -1698,    53,  1102,   144, -1698, -1698,  5654,  1316,
    1317,    30, -1698, 13463, -1698, -1698, -1698,     0, -1698, -1698,
   -1698, -1698, 13463, -1698, -1698, -1698, -1698, -1698,  1106, -1698,
     144, -1698, 17510, -1698,   613, -1698, 19706, -1698, -1698, 12731,
   -1698, -1698,  1506, 19706, -1698, -1698, -1698,  1108, -1698, 16778,
   10901, -1698,   546, -1698, -1698, -1698, -1698, -1698,  1110,    53,
     429, -1698,  1321,   486,    53,  1114,   619, -1698,  1115,  1116,
      45,  1118,   566,   175,   626,   569,   525,   574,   594,   600,
     602, -1698, -1698, -1698,   710, -1698, -1698, -1698,   633, -1698,
   -1698,   710, -1698, -1698, -1698,  7543, -1698,  -164,  1175, -1698,
     878, -1698, -1698, -1698,  1333,   543,  1243,  1243,  1340,  1281,
     -25,  1478,  1370, -1698, -1698, -1698, 19706, -1698, -1698,   765,
   -1698, -1698, 18242,  1131, -1698,  1312, -1698,    35,  1260, -1698,
   -1698,    22,    53,  1282,  5654, -1698, -1698, -1698,    53, 13463,
   -1698, -1698, -1698, -1698,  1135,  1429,  1433, 13463, -1698,  1506,
   13097, -1698, -1698, -1698, -1698,  1141, -1698, -1698, -1698, -1698,
   -1698,  1037,  1279, -1698,  1037, -1698,  1037, -1698, -1698, -1698,
   -1698,  1142, -1698, -1698,   985,   258,  1146, -1698,  1147,  1144,
   -1698,   -30,   480, -1698,  1148, -1698, 19706, -1698,  1183, -1698,
   -1698, -1698,  1315, -1698, -1698, -1698, -1698, -1698,  5654, -1698,
   -1698, -1698, -1698, -1698, -1698, -1698,   505,   505, -1698, -1698,
    1210, -1698, -1698,   808,   586,   944,  -127, -1698,   543, -1698,
    1369,  1374,   543, -1698, -1698, -1698,  5654, -1698,  1175, -1698,
   -1698,    13,   731,  1489, -1698,  1096, -1698, -1698, -1698, -1698,
    3765, -1698,   144,  1164,  1166, 19706, -1698,  1213,   115, -1698,
   -1698, 19706,  1357, -1698, -1698,  1172, -1698, -1698,  1328, -1698,
   18242,   953,  1198,   763, -1698,  1204, -1698,  1468,  1386, -1698,
     985, -1698,  1387,  1342, -1698,  1343,  1346,  1347, -1698, -1698,
   19706, -1698, -1698,  1181,   752,   635,   144,  1192, 13097,  1200,
     612, -1698, -1698, 12731, -1698, -1698, -1698,  1068,   915,  1223,
     543,   543,  1085,  1224,  5654,  5654,  1199,   329,   144,  5654,
     944, -1698,    91,   892,    -3,  1405, -1698, -1698, -1698, 19706,
   19706,   642,   627,   627,   629,   629, -1698, -1698, -1698,   115,
     644, -1698,   -31,  1360,    45,  1203, -1698, -1698,   582, -1698,
   -1698, -1698, -1698, -1698, -1698,  1372,  1233, -1698, -1698, -1698,
   -1698,  1212,  1216,  1214, -1698, -1698, -1698,    26, 19706, -1698,
    1371,  1217, -1698,    22, -1698, -1698, -1698,   499, -1698,  1245,
   -1698, -1698, -1698,  1248,    53,    53, 19706, -1698,  5654, -1698,
   -1698,    53, -1698, -1698, -1698,    30,    30, -1698,    91,   710,
    1568,  1571,  1500,  1574,    -3, -1698,  -134, -1698,   661,   665,
      26, -1698, -1698, -1698, -1698, 19706, -1698, -1698, -1698,    -6,
   -1698,   692, -1698, -1698, -1698,   582, -1698, -1698, -1698,   -30,
     953,    22, -1698,    26, -1698, -1698,   144,  1226, 13097,  7543,
    1489, -1698,  5654,  1229,  5654,  1231,   704, -1698,   144,  1482,
    1482, -1698, -1698,    45,    45,  1581,    45, -1698,  1582,  1583,
    -134, -1698,  1375,    26, -1698, -1698,    87,    87, -1698,    45,
   -1698, -1698, -1698,   -27, -1698, -1698, -1698, -1698, -1698,  1405,
    1175,    53, 19706,    53, 19706, -1698, 19706, -1698,   445, -1698,
   -1698, -1698, -1698,    45, -1698,    45,    45, -1698, -1698, -1698,
   -1698,  1617, -1698,   457,  1400,  1401, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698,  1479,   944,   706,   711, -1698,  1597,
   -1698,  1600,  1255,  1261, -1698, -1698, -1698, -1698, -1698, -1698,
    1291,  1554,  1420,  1264, -1698, -1698, -1698, -1698, -1698, 19340,
   19340,    87,    87,   -61,  9791,  1361, -1698,  1265, -1698,  1263,
   -1698,   728, -1698, -1698, -1698, -1698, -1698, -1698, 18242,   730,
   -1698, -1698, 13097, -1698, -1698, 19340, -1698, -1698, -1698, 10163,
    1217, -1698, -1698
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698,    89, -1698, -1698,  -794, -1698, -1698, -1698, -1698,   591,
   -1698, -1698,  -252, -1156,   604,  -985,  -821, -1698, -1698,  1003,
   -1698, -1411,   417,   228,   605,   631,   420,   448, -1698, -1698,
     139, -1698,   141, -1698, -1698, -1698, -1698, -1698, -1698,  -632,
     109,   592, -1698, -1698, -1698,    23, -1698,    32, -1111,  -363,
   -1698,  -154, -1698, -1698, -1698, -1698, -1697, -1698, -1698, -1027,
   -1698, -1698, -1698, -1698, -1278, -1614, -1698,   617,  -121,   416,
   -1470,   -51, -1117, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
     640, -1698, -1698,   449, -1698, -1698, -1698,  -204,   641, -1502,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
     886,  1236,   693,  1422,   749, -1698, -1698,  1424, -1698, -1698,
   -1698,  -707,  -919, -1698,  1277,  -581, -1100,   881,  -749,  -765,
     369,  -318,  1663, -1698,  -539,  1046, -1698, -1698,  -226, -1698,
   -1698,  -304, -1698, -1698, -1698, -1698, -1698, -1698, -1698,   554,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
     919, -1698,   820,  -476, -1698, -1698, -1698,  -955, -1698,   345,
     110, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
    -579, -1698, -1698, -1698, -1698, -1698,   758, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698, -1078, -1698,  -760,  -113, -1698,   -58,
   -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,  -227,  -199,
   -1182,  -495,  1173,   516, -1698,   121,  1219,  -465, -1698, -1698,
   -1698,   741, -1698, -1698, -1698, -1698, -1698,   186, -1058,  -599,
   -1698, -1698, -1370,  -394,  -993,  -395, -1698,  -976,   204, -1698,
   -1034, -1698, -1698, -1698,   106,   721, -1698, -1698, -1698, -1698,
   -1698,   118,   -68,  1425, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698,  1413,  1322,  1069, -1698, -1698,  -853, -1698, -1698,   927,
   -1698,   393,  -855, -1012,   579, -1698, -1698, -1698, -1181, -1698,
   -1698, -1698, -1698, -1698, -1698,   539,  -193,   -67, -1698, -1698,
   -1698, -1698,  1445, -1698, -1698, -1698, -1698, -1698, -1698,  -546,
     224,  -542, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698,  1262, -1698, -1698, -1698, -1698, -1698, -1698, -1698, -1698,
   -1698, -1698, -1698, -1698,   596,   -65, -1698,   -24,  -102, -1698,
     -79, -1698, -1698, -1698, -1698,  -184, -1698,  -317, -1394,   114,
   -1417,  -587,   597,  1149, -1432,  1256,  -531,  -516,   -92,   -18,
     -20,  -611,  -393,  -230,   714,  -550, -1698, -1698, -1698, -1698,
   -1698, -1698,   937, -1698, -1698, -1698, -1698,   573, -1698, -1698,
   -1698,   391, -1698,   150,    88, -1698, -1698, -1698, -1698,   176,
    1669,  1364, -1698, -1698, -1698, -1698, -1698,  -978,  -409, -1698,
   -1308, -1698, -1698, -1698,  -931, -1285, -1698, -1698,  -478, -1698,
   -1698
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1114
static const yytype_int16 yytable[] =
{
     254,   496,   584,   837,   599,   485,   501,   772,   254,  1059,
    1180,  1274,  1226,   671,   672,   751,   714,   990,  1162,  1128,
    1382,  1218,   407,  1220,  1321,   776,   685,  1124,   521,   254,
     752,   279,   784,   801,   619,   854,  1476,  1048,  1465,   469,
    1531,   254,  1196,  1197,   536,   619,   624,   538,   287,   558,
     558,  1335,   558,   974,   544,   545,  1575,  1007,  1877,   612,
    1591,   640,  1233,   467,  1151,   558,   558,   558,   254,   876,
     254,   636,   558,    72,   550,   551,   846,  1800,   844, -1110,
    1268,   847,  1622,  1836,   849,   850,   558,  1617,  1194,   558,
      67,   879,    69,   645,   558,   614,  1360,  1396,  1525,  1426,
    1878,   864,  1388,  1770,  1786,    89,   558,    83,   584,   558,
    1401,  1207,  1771,  1002,   853,  1361,  1879,   558,  1524,  1388,
    1924,   461,  1416,  1870,  1263,   558,  1708,   798,   558,   558,
     825,   558,   558,  1434,  1027,   271,  1158,  1388,   663,  1485,
    1875,   363,  -570,   558,   558,   584,   558,  1486,   999,   558,
     558,   363,   558,   626,  1164,  1701,  1473,  1190,   558,  1515,
    1234,   582,  1880,   558,   558,  -570,  1834,   558,   299,  1201,
    1828,   558,   922,  -979,  1688,   558,  1000,   826,   558,  1018,
     558, -1113,  1593,   558,  1398,  1209,  1229,   558,   637,  1353,
      70,   558,   558,  1829,   500,    91,  1801,  1881,   446,   558,
      86,  1210,  1246,  1604,   537,  1389,   558,  1783,   627,   617,
    1707,  1787,  1424,  1925,  1922,  1923,   954,    88,  1594,  1869,
    1763,   558,   827,  -102,   664,  1707,  1412,  1048,    62,  1778,
    1779,   936,  1772,    63,  1516,   272,  1264, -1113,   407,   855,
    1417,  1487,  1435,  1764,   285,  1624,   254,  1116,   264,   254,
     853,   448,  1698,  1661,  1165,  1362,   558,   254,  1166,   558,
     663,   881,  1788,   955,   254,   853,   254,  1258,   799,  1479,
     254,   789,   265,  1562,   559,   559,  1523,   254,   254,   828,
     994,   558,  1433,   800,   615,  1528,   254,  1015,   645,  1526,
     559,   559,   559,   558,  1592,   752,  1739,   559,  1182,  1337,
      84,  1532,  1021,   462,  1020,   558,   558,  1345,   558,  1871,
     966,   559,  1028,   613,   559,  1882,   597,  1419,  1760,   559,
    1792,  1024,  1390,  1513,  1773,  1307,  1818,   -62,    73,  1605,
     558,   559,   558,   877,   559,  1019,   752,  1379,   407,  1195,
    -102,   781,   559,   558,  1837,   558,   675,   597,   558,   558,
     559,  -979,  1872,   559,   559,   447,   559,   559,  1822,   558,
     835,   254,   254,   990,  1521,   956,  -570,  1269,   559,   559,
     411,   559,   558,   363,   559,   559,  1873,   559,  1618,   558,
    1270,  1332,  1235,   559,  1077,   254,   254,   591,   559,   559,
     558,   558,   559,  1480,   558,  1185,   559,   558,   558,   974,
     559,  1490,  1623,   559,   460,   559,   261,  1132,   559,  1089,
     560,   560,   559,   560,   268,  1118,   559,   559,  1048,  1094,
    1595,   923,  1391,   952,   559,  1135,   560,   560,   560,  1861,
    1862,   559,  1864,   560,   254,   254,  1845,   254,   871,   646,
    -102,  1107,   757,   758,  1765,  1876,   559,   560,  1857,   254,
     560,   652,   254,  1154,   654,   560,   757,   899,   254,   619,
    1026,   254,  1811,  1192,  1567,   884,   274,   560,   752,  1894,
     560,  1895,  1896,  1193,  1140,  1141,  1136,  1137,   560,   937,
    1206,   559,   558,   254,   559,  1134,   560,  1296,  1297,   560,
     560,  1841,   560,   560,  1144,  1293,   973,   558,  1309,  1310,
     888,  1329,  1330,   889,   560,   560,   559,   560,   864,  1254,
     560,   560,  1693,   560,   897,   898,   558,   901,   559,   560,
     908,   913,   558,   914,   560,   560,   254,    77,   560,   916,
     559,   559,   560,   559,   917,   921,   560,   254,   938,   560,
     558,   560,  1294,   275,   560,  1898,  1295,   558,   560,  1302,
    1690,  1311,   560,   560,  1312,   559,  1198,   559,  1578,   558,
     560,   883,   890,   254,   807,   558,   254,   560,   559,   891,
     559,   287,  1368,   559,   559,   254,  1308,    61,   558,   859,
    1612,   558,   560,  1889,   559,   291,   558,   599,  -777,   -44,
     254,   896,   833,   254,  1488,   836,   656,   559,   663,   659,
    1494,   254,  1676,  1328,   559,   254,   558,   848,   583,  1400,
     463,  -230,   558,  1890,   558,   559,   559,   560,   839,   559,
     560,  1654,   559,   559,   558,   608,   904,   254,  1848,   905,
     994,   254,  1263,   254,   289,   254,  1176,   868,  1565,  1655,
     809,   810,   560,  1678,  1120,   752,    75,  1682,   464,   610,
      79,   909,  -608,   840,   560,   609,  1620,    21,   296,   300,
    1269,  1327,  1674,  1139,  1157,   625,   560,   560,  1024,   560,
    1886,  1206,  1887,  1270,   293,   910,   912,   967,   915,  1406,
    1899,  1891,    62,   752,   716,   964,  1736,    63,  -777,   298,
    1279,   560,  1177,   560,  1142,  -608,  1425,  1762,  1495,  1757,
     918,  1410,   926,  1357,   560,   283,   560,   559,  1248,   560,
     560,   959,  1758,   927,   325,   942,   752,  -608,  1277,  1291,
     560,  1185,   559,   306,  -608,   572,  1600,  1601,  -608,  1298,
    -101,  1494,    62,   560,   255,  1381,  1207,    63,  1819,  1820,
     560,   559,   270,  -608,  1264,   254,  1208,   559,  -608,  1299,
    1249,   560,   560,   444,  -608,   560,   330,    29,   560,   560,
    1300,  1301,  -608,   280,  1303,   559,  -608,  1306,  1313,   573,
    1663,   841,   559,  -608,   414,   282,  1489,   301,   573,   663,
     760,  1443,    78,  -608,   559,   254,   254,   591,   982,  1843,
     559,   254,  1885,   302,  1448,  1449,    66,   451,   573,   807,
    -608,   663,   404,   559,   280,  1154,   559,   808,   455,   254,
    1456,   559,  1250,   960,  -608,   254,  -101,   816,   338,   947,
     752,  1454,  -608,   573,  1164,  1207,  -608,   807,  1217,  1495,
    1219,   559,   254,    65,   457,  1227,    66,   559,   254,   559,
    1231,  1209,   466,   560,   999,   254,  -608,  1251,  -608,   559,
     470,  1721,  1315,   348,  1468,  -608,  -608,  1210,   560,  -608,
     415,   475,  1206,   900,  1722,   720,   574,  1317,  1569,  -608,
     472,  1507,   880,   881,  -608,   809,   810,   560,  1508,  -608,
     761,   575,   576,   560,   479,  -608,  1319,   737,  1809,  1723,
     617,   576,  1904,  -608,   573,   882,   881,  -608,  -608,   811,
    1509,   560,   900,   817,  -608,  1224,  1599,  1581,   560,  1633,
    1320,   576,  1636,   480,  1637,  1123,   881,  1461,   483,   948,
     560,   484,   466,   488,  1165,   489,   560,  1564,   961,  1462,
    1209,  -608,  -608,  -101,   583,  1463,   576,   254,   962,   560,
    -608,   490,   560,   491,  1349,  -608,  1210,   560,  1577,  1160,
    1161,  1580,  1614,  -608,  -608,   363,  1582,   492,   254,  1304,
     881,   493,   911,   494,   254,  1252,   497,   560,  -608,  -608,
     586,   370,  -608,   560,   498,   560,  1583,  1429,  1430,   499,
     280,  1349,  1584,   280,  1585,   560,   254,  -608,   254,  1467,
     881,   452,   502,   254,  1745,  1533,  1430,   587,   280,  1410,
     280,  1571,  1572,  1639,   468,  1671,  1672,   576,  1579,   881,
     254,   476,   477,  1349,   752,  1589,   881,  1737,  1738,  1679,
     280,   594,  1225,  1683,  1780,  1738,  1784,  1785,   254,  -608,
    1717,   777,  1640,  -101,   254,  1350,  1641,   503,   254,   254,
     254,   254,  1255,  1832,  1738,   254,  1351,  1833,  1738,   577,
     578,   579,   580,   581,  1352,   743,   743,   640,   577,   578,
     579,   580,   581,  -608,   416,   417,   418,   419,   504,   485,
    -608,  -608,  1350,  1642,  1838,  1839,   690,   420,   577,   578,
     579,   580,   581,  1351,   505,  -608,  1855,  1856,  1905,  1856,
    1206,  1352,  1353,  1906,  1856,   555,   556,  1081,   597,  -608,
    -608,  1750,  1751,  -608,  1350,   579,   580,   581,  1643,   600,
    1936,  1935,  1938,  1939,  1082,  1351,  1387,  1781,  1782,   280,
     280,   506,  1387,  1352,   617,  1397,   741,  1399,   507,  1353,
     466,  1500,  1501,   778,  1404,  1405,   508,   509,   512,  1407,
     694,   254,   513,  1748,   622,   514,   254,  1083,  1354,   515,
    1084,  1349,   752,   254,   516,  1359,  -163,   517,  1085,   518,
     520,  1353,   522,   254,   523,   524,   525,   526,   641,   642,
     527,   280,   528,   623,   577,   578,   579,   580,   581,   254,
     529,   530,   531,   280,   532,  1354,   280,   533,   254,  1842,
    1355,   534,   280,   695,   254,   280,   698,   254,   535,   254,
     539,   254,   540,   699,   541,   466,   254,   254,  1644,   254,
     542,   254,   254,  1645,   543,   546,   254,  1354,  1411,   254,
     254,   254,   547,   548,   310,   549,   254,  1355,   585,   611,
     628,   630,  1646,   643,   648,   254,   254,   647,  1427,   310,
     649,   650,  1350,   700,   653,   655,   657,   254,   779,   563,
     564,   667,   254,  1351,  1438,   599,   678,   679,   780,  1355,
     753,  1352,   708,   663,  1597,   750,   765,   759,   804,   788,
    1647,   771,   702,   565,   805,   819,  1702,   566,   824,   806,
     834,   767,   851,   325,   852,   857,   869,   873,   886,   887,
     892,  1702,   752,   894,   893,   900,   903,   771,   325,  1353,
     803,  1387,   567,   907,   254,   919,   920,   925,   939,   815,
    1387,   568,   254,  1752,   928,   929,   254,   823,   940,   329,
     941,   640,   950,   958,   280,   330,   558,   280,  -457,   569,
    -374,   963,  1648,   972,   329,   845,   979,   985,   978,   280,
     330,   332,  1008,  1016,  1025,  1013,  1058,  1068,  1071,  1075,
     254,  1080,   570,  1090,  1091,  1354,   332,  1092,   254,   703,
    1100,   280,  1129,  1101,  1112,   771,  1127,   866,   705,   280,
    1130,   558,  1138,   254,  1131,  1148,  1147,  1000,  1937,  1156,
    1159,   999,   254,  1931,  1189,   501,   538,   338,  1199,  1207,
    1221,  1222,   254,  1223,  1228,  1232,   254,  1355,   752,   254,
    1794,  1535,   338,   254,  1230,  1238,  1239,  1272,  1931,   254,
     254,   853,   676,  1275,     1,     2,   752,  1280,  1283,  1718,
    1286,   347,   348,   752,  1287,  1322,     3,  1387,   881,   807,
     640,   640,   717,   640,  1324,   721,   347,   348,   686,   687,
     688,   689,   690,  1326,  1331,  1366,   640,  1336,     4,   733,
     734,  1358,  1367,   738,  1370,  1371,  1402,     5,  1403,  1428,
    1423,  1431,  1440,  1445,  1446,  1447,   754,   755,  1450,     6,
     640,  1470,   640,   640,  1474,  1481,   254,  1840,  1482,   953,
    1475,  1483,   254,  1491,  1502,  1514,  1505,  1519,  1520,  1530,
    1560,  1566,  1568,     7,     8,     9,  1570,  1573,  1574,   254,
    1576,  1598,    10,   691,   692,   693,   694,   254,  1602,  1603,
     254,  1606,  1607,    11,  1615,  1619,  1625,  1626,  1616,   280,
     280,  1627,  1631,  1638,  1634,   995,   363,  1656,  1657,  1703,
    1536,  1660,    12,  1668,  1537,  1673,   368,  1680,  1694,  1669,
     370,   363,  1681,  1011,  1703,  1699,   254,  1700,  1538,  1017,
    1712,   368,  1715,  1714,  1725,   370,  1726,  1727,  1729,   695,
     696,   697,   698,  1735,    13,  1730,   753,  1731,   725,   699,
    1732,  1733,   771,  1740,  1704,  1705,    14,  -525,  -530,   771,
    1756,  1539,  1744,   872,  1540,  1793,  1776,    15,  1789,  1704,
    1705,  1796,  1541,  1795,  1797,  1807,   559,  1572,  1798,  1813,
    1808,  1823,  1815,  1542,  1824,   254,  1825,  1826,  1846,   700,
    1852,   254,  1854,  1858,  1863,  1865,  1866,  1543,   786,   787,
     254,  1897,   790,   792,   794,   795,   796,   797,  1900,  1901,
    1907,  1902,  1544,  1908,  1419,   902,  1909,   701,   702,   906,
     254,  1911,  1910,  1912,  1913,  1914,  1935,  1934,   254,  1247,
    1932,  1662,  1237,   254,   863,  1746,   924,  1414,  1563,  1242,
    1392,   425,  1211,  1420,    16,    17,  1628,  1658,    18,  1545,
    1629,   771,  1716,  1728,  1282,    19,   426,   427,  1868,   254,
     254,    20,  1844,  1271,   428,    21,  1437,  1806,  1413,   635,
    1163,   981,  1149,    22,   450,   449,    23,  1126,   753,   604,
     998,  1469,  1333,  1493,  1088,  1125,  1677,  1860,  1941,    24,
    1821,  1921,   677,   744,  1145,  1675,  1630,  1621,   254,   482,
    1186,  1696,  1188,  1179,   478,   703,   429,   771,   592,  1472,
     870,  1546,   560,   704,   705,  1343,   254,   988,  1380,  1940,
     474,  1847,   658,    25,   771,  1849,  1334,  1884,   384,   430,
    1827,  1867,   822,    26,    27,  1942,  1720,    28,  1346,   684,
     412,  1009,   771,  1547,  1378,   254,   431,   432,  1245,  1511,
    1697,     0,   771,   771,   280,  1245,   596,     0,     0,   771,
       0,   433,     0,     0,     0,    29,     0,     0,   254,     0,
       0,  1548,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   254,     0,   254,  1549,   254,  1550,     0,     0,
       0,     0,     0,     0,   971,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   435,     0,     0,     0,  1551,  1552,     0,     0,     0,
       0,     0,     0,     0,     0,   995,     0,     0,     0,     0,
    1348,     0,     0,     0,     0,     0,     0,   280,     0,   254,
     254,     0,     0,     0,   254,     0,     0,  1369,   436,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   254,     0,
       0,     0,   254,   753,     0,   254,     0,     0,     0,   254,
       0,     0,  1245,     0,     0,     0,     0,     0,  1245,     0,
       0,  1245,     0,  1245,   437,   771,     0,   438,   439,     0,
    1245,  1245,     0,   771,     0,  1245,   753,     0,     0,     0,
     280,     0,     0,   771,  1245,  1415,     0,     0,     0,     0,
     771,     0,     0,     0,     0,     0,     0,     0,     0,   771,
     280,     0,     0,     0,   486,     0,     0,   440,     0,     0,
       0,   771,     0,     0,     0,     0,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   511,
       0,     0,     0,     0,     0,     0,     0,     0,   519,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1466,     0,
       0,     0,     0,   552,     0,     0,  1186,     0,     0,     0,
     753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1149,     0,     0,     0,     0,     0,
       0,     0,  1011,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1245,     0,     0,
       0,     0,     0,     0,     0,     0,  1245,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   771,     0,     0,     0,
    1534,     0,     0,   280,     0,     0,     0,  1559,     0,     0,
       0,     0,     0,   771,  1245,     0,   662,     0,     0,     0,
       0,   669,     0,     0,   673,   674,     0,     0,     0,     0,
       0,   680,   681,   682,     0,   683,     0,     0,     0,     0,
     710,   711,   712,   713,     0,   715,     0,   718,   719,     0,
     722,   723,     0,   724,     0,     0,   726,   727,   728,   729,
     730,   731,   732,     0,     0,   735,   736,     0,   739,     0,
     740,     0,     0,     0,   748,   749,     0,     0,     0,     0,
    1609,     0,   756,     0,     0,     0,   771,     0,   764,     0,
       0,     0,     0,   773,   774,   775,     0,     0,   686,   687,
     688,   689,   690,  1245,     0,     0,     0,     0,     0,     0,
       0,  1245,     0,     0,   753,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   838,     0,
    1667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   691,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     875,     0,     0,     0,     0,     0,     0,     0,     0,  1667,
       0,     0,     0,     0,     0,  1711,     0,     0,     0,   695,
     696,   697,   698,     0,   771,     0,     0,     0,     0,   699,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1734,     0,     0,     0,     0,     0,
       0,     0,   753,     0,     0,     0,     0,   280,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   700,
       0,     0,     0,     0,     0,     0,     0,     0,   931,   933,
     935,     0,     0,  1667,  1667,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   701,   702,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   965,  1667,     0,   969,     0,   970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1817,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1835,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   703,     0,     0,     0,     0,
       0,     0,   753,   704,   705,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1074,     0,     0,  1076,     0,  1078,
    1079,     0,     0,     0,  1087,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1093,     0,     0,
    1095,  1096,  1097,  1098,  1099,     0,  1817,     0,  1817,     0,
    1888,  1102,     0,     0,  1103,     0,  1104,  1105,     0,  1106,
       0,     0,     0,     0,  1109,  1110,  1111,     0,     0,     0,
       0,  1113,  1114,  1115,     0,  1117,     0,  1119,     0,  1121,
       0,  1122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1133,     0,  1920,  1920,     0,     0,     0,   753,     0,
       0,     0,     0,     0,     0,  1143,     0,  1146,     0,     0,
       0,     0,   771,     0,     0,     0,   753,     0,     0,  1920,
       0,     0,     0,   753,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1276,     0,     0,     0,
    1278,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1289,  1290,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1305,     0,     0,     0,     0,     0,     0,     0,  1314,
       0,  1316,     0,  1318,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1339,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1376,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1339,  1383,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1439,     0,     0,     0,
       0,     0,  1444,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1452,  1453,     0,
       0,     0,     0,     0,     0,  1455,     0,     0,     0,     0,
    1457,     0,     0,  1458,  1459,  1460,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1339,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1512,     0,     0,     0,     0,     0,     0,     0,
       0,  1518,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1339,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1383,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1670,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1383,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1376,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1754,  1755,     0,
       0,     0,  1761,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    92,     0,   307,    94,    95,     0,
       0,     0,     0,    96,     0,     0,     0,    97,    98,    99,
     308,     0,   101,     0,     0,   309,   310,   102,     0,   103,
     104,   745,   105,     0,   106,     0,     0,   107,   311,   312,
     108,  1383,   313,   109,     0,   110,   314,     0,   315,   113,
       0,   114,   115,   116,   117,   118,   119,     0,   120,   121,
       0,   122,     0,   316,   317,     0,     0,   123,   318,   319,
       0,   320,   124,   125,   126,   127,   321,   322,   323,     0,
       0,     0,     0,   324,   130,   325,     0,     0,   326,     0,
       0,     0,  1339,   131,   132,  1851,     0,  1853,     0,   133,
     134,   135,     0,     0,     0,   136,     0,   137,   138,     0,
     139,   140,     0,     0,   141,     0,   142,   143,   327,   144,
     328,   329,     0,   145,   146,   147,   148,   330,   149,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,   331,
       0,   154,     0,   332,     0,     0,     0,   333,   156,   157,
     158,   334,     0,   159,   160,     0,     0,     0,     0,     0,
     335,   336,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,     0,   746,   337,   164,     0,     0,
       0,     0,   165,     0,   166,     0,   167,     0,   168,   338,
       0,     0,     0,     0,   169,   170,   339,   171,   172,   173,
     340,     0,     0,   341,   176,   342,   177,     0,   178,   343,
     344,   180,   181,   182,     0,     0,     0,   183,   184,   185,
     345,   346,   186,   347,   348,     0,   187,   188,     0,   189,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
       0,   193,   194,   195,   349,     0,   196,     0,   197,   198,
     350,   200,     0,     0,   201,     0,     0,     0,   202,     0,
       0,     0,   203,   351,   352,     0,   204,     0,   353,     0,
     354,   206,   207,   208,   209,   210,   355,   212,     0,   356,
     214,     0,     0,     0,   215,   216,   217,   218,     0,     0,
       0,   219,     0,   220,   221,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,   223,   224,   357,   358,   225,
     226,     0,     0,   227,   359,   229,   360,   361,   230,   231,
     232,   362,   233,   234,     0,     0,   235,     0,   363,   236,
       0,   364,   365,   366,     0,   747,   240,   367,   368,   369,
     242,   243,   370,   244,   245,     0,     0,     0,   246,     0,
       0,     0,   371,     0,     0,   372,   373,   374,   248,     0,
       0,   249,   375,     0,   376,   250,   251,     0,     0,     0,
       0,   252,     0,     0,     0,   377,   378,   379,     0,     0,
       0,   380,     0,     0,     0,   381,     0,   382,   383,    92,
       0,   307,    94,    95,  1372,     0,     0,     0,    96,     0,
       0,     0,    97,    98,    99,   308,     0,   101,     0,     0,
    1373,   310,   102,     0,   103,   104,     0,   105,     0,   106,
       0,     0,   107,   311,   312,   108,     0,   313,   109,     0,
     110,   314,     0,   315,   113,     0,   114,   115,   116,   117,
     118,   119,     0,   120,   121,     0,   122,     0,   316,   317,
       0,     0,   123,   318,   319,     0,   320,   124,   125,   126,
     127,   321,   322,   323,     0,     0,     0,     0,   324,   130,
     325,     0,     0,  1374,     0,     0,     0,     0,   131,   132,
       0,     0,     0,     0,   133,   134,   135,     0,     0,     0,
     136,     0,   137,   138,     0,   139,   140,     0,     0,   141,
       0,   142,   143,   327,   144,   328,   329,     0,   145,   146,
     147,   148,   330,   149,     0,     0,     0,   150,   151,     0,
     152,     0,   153,     0,   331,     0,   154,     0,   332,     0,
       0,     0,   333,   156,   157,   158,   334,     0,   159,   160,
       0,     0,     0,     0,     0,   335,   336,     0,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,     0,
       0,   337,   164,     0,     0,     0,     0,   165,     0,   166,
       0,   167,     0,   168,   338,     0,     0,     0,     0,   169,
     170,   339,   171,   172,   173,   340,     0,     0,   341,   176,
     342,   177,     0,   178,   343,   344,   180,   181,   182,     0,
       0,     0,   183,   184,   185,   345,   346,   186,   347,   348,
       0,   187,   188,  1375,   189,   190,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,   193,   194,   195,   349,
       0,   196,     0,   197,   198,   350,   200,     0,     0,   201,
       0,     0,     0,   202,     0,     0,     0,   203,   351,   352,
       0,   204,     0,   353,     0,   354,   206,   207,   208,   209,
     210,   355,   212,     0,   356,   214,     0,     0,     0,   215,
     216,   217,   218,     0,     0,     0,   219,     0,   220,   221,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     223,   224,   357,   358,   225,   226,     0,     0,   227,   359,
     229,   360,   361,   230,   231,   232,   362,   233,   234,     0,
       0,   235,     0,   363,   236,     0,   364,   365,   366,     0,
       0,   240,   367,   368,   369,   242,   243,   370,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   371,     0,     0,
     372,   373,   374,   248,     0,     0,   249,   375,     0,   376,
     250,   251,     0,     0,     0,     0,   252,     0,     0,     0,
     377,   378,   379,     0,     0,    92,   380,   307,    94,    95,
     381,     0,   382,   383,    96,     0,     0,     0,    97,    98,
      99,   308,     0,   101,     0,     0,   309,   310,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,   311,
     312,   108,     0,   313,   109,     0,   110,   314,     0,   315,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,   316,   317,     0,     0,   123,   318,
     319,     0,   320,   124,   125,   126,   127,   321,   322,   323,
       0,     0,     0,     0,   324,   130,   325,     0,     0,   326,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,   327,
     144,   328,   329,     0,   145,   146,   147,   148,   330,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
     331,     0,   154,     0,   332,     0,     0,     0,   333,   156,
     157,   158,   334,     0,   159,   160,     0,     0,     0,     0,
       0,   335,   336,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   337,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
     338,     0,     0,     0,     0,   169,   170,   339,   171,   172,
     173,   340,     0,     0,   341,   176,   342,   177,     0,   178,
     343,   344,   180,   181,   182,     0,     0,     0,   183,   184,
     185,   345,   346,   186,   347,   348,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,   349,     0,   196,     0,   197,
     198,   350,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,   351,   352,     0,   204,     0,   353,
       0,   354,   206,   207,   208,   209,   210,   355,   212,     0,
     356,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,   357,   358,
     225,   226,     0,     0,   227,   359,   229,   360,   361,   230,
     231,   232,   362,   233,   234,     0,     0,   235,     0,   363,
     236,     0,   364,   365,   366,     0,     0,   240,   367,   368,
     369,   242,   243,   370,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   371,     0,     0,   372,   373,   374,   248,
       0,     0,   249,   375,     0,   376,   250,   251,     0,     0,
       0,     0,   252,     0,     0,     0,   377,   378,   379,     0,
       0,     0,   380,   678,     0,     0,   381,     0,   382,   383,
      92,     0,   307,    94,    95,     0,     0,     0,     0,    96,
       0,     0,     0,    97,    98,    99,   308,     0,   101,     0,
       0,   309,   310,   102,     0,   103,   104,     0,   105,     0,
     106,     0,     0,   107,   311,   312,   108,     0,   313,   109,
       0,   110,   314,     0,   315,   113,     0,   114,   115,   116,
     117,   118,   119,     0,   120,   121,     0,   122,     0,   316,
     317,     0,     0,   123,   318,   319,     0,   320,   124,   125,
     126,   127,   321,   322,   323,     0,     0,     0,     0,   324,
     130,   325,     0,     0,   326,     0,     0,     0,     0,   131,
     132,     0,     0,     0,     0,   133,   134,   135,     0,     0,
       0,   136,     0,   137,   138,     0,   139,   140,     0,     0,
     141,     0,   142,   143,   327,   144,   328,   329,     0,   145,
     146,   147,   148,   330,   149,     0,     0,     0,   150,   151,
     930,   152,     0,   153,     0,   331,     0,   154,     0,   332,
       0,     0,     0,   333,   156,   157,   158,   334,     0,   159,
     160,     0,     0,     0,     0,     0,   335,   336,     0,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
       0,     0,   337,   164,     0,     0,     0,     0,   165,     0,
     166,     0,   167,     0,   168,   338,     0,     0,     0,     0,
     169,   170,   339,   171,   172,   173,   340,     0,     0,   341,
     176,   342,   177,     0,   178,   343,   344,   180,   181,   182,
       0,     0,     0,   183,   184,   185,   345,   346,   186,   347,
     348,     0,   187,   188,     0,   189,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,   193,   194,   195,
     349,     0,   196,     0,   197,   198,   350,   200,     0,     0,
     201,     0,     0,     0,   202,     0,     0,     0,   203,   351,
     352,     0,   204,     0,   353,     0,   354,   206,   207,   208,
     209,   210,   355,   212,     0,   356,   214,     0,     0,     0,
     215,   216,   217,   218,     0,     0,     0,   219,     0,   220,
     221,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,   223,   224,   357,   358,   225,   226,     0,     0,   227,
     359,   229,   360,   361,   230,   231,   232,   362,   233,   234,
       0,     0,   235,     0,   363,   236,     0,   364,   365,   366,
       0,     0,   240,   367,   368,   369,   242,   243,   370,   244,
     245,     0,     0,     0,   246,     0,     0,     0,   371,     0,
       0,   372,   373,   374,   248,     0,     0,   249,   375,     0,
     376,   250,   251,     0,     0,     0,     0,   252,     0,     0,
       0,   377,   378,   379,     0,     0,    92,   380,   307,    94,
      95,   381,     0,   382,   383,    96,     0,     0,     0,    97,
      98,    99,   308,     0,   101,     0,     0,   309,   310,   102,
       0,   103,   104,     0,   105,     0,   106,     0,     0,   107,
     311,   312,   108,     0,   313,   109,     0,   110,   314,     0,
     315,   113,     0,   114,   115,   116,   117,   118,   119,     0,
     120,   121,     0,   122,     0,   316,   317,     0,     0,   123,
     318,   319,     0,   320,   124,   125,   126,   127,   321,   322,
     323,     0,     0,     0,     0,   324,   130,   325,     0,     0,
     326,     0,     0,     0,     0,   131,   132,     0,     0,     0,
       0,   133,   134,   135,     0,     0,     0,   136,     0,   137,
     138,     0,   139,   140,     0,     0,   141,     0,   142,   143,
     327,   144,   328,   329,     0,   145,   146,   147,   148,   330,
     149,     0,     0,     0,   150,   151,   932,   152,     0,   153,
       0,   331,     0,   154,     0,   332,     0,     0,     0,   333,
     156,   157,   158,   334,     0,   159,   160,     0,     0,     0,
       0,     0,   335,   336,     0,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,     0,     0,   337,   164,
       0,     0,     0,     0,   165,     0,   166,     0,   167,     0,
     168,   338,     0,     0,     0,     0,   169,   170,   339,   171,
     172,   173,   340,     0,     0,   341,   176,   342,   177,     0,
     178,   343,   344,   180,   181,   182,     0,     0,     0,   183,
     184,   185,   345,   346,   186,   347,   348,     0,   187,   188,
       0,   189,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,   193,   194,   195,   349,     0,   196,     0,
     197,   198,   350,   200,     0,     0,   201,     0,     0,     0,
     202,     0,     0,     0,   203,   351,   352,     0,   204,     0,
     353,     0,   354,   206,   207,   208,   209,   210,   355,   212,
       0,   356,   214,     0,     0,     0,   215,   216,   217,   218,
       0,     0,     0,   219,     0,   220,   221,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,   223,   224,   357,
     358,   225,   226,     0,     0,   227,   359,   229,   360,   361,
     230,   231,   232,   362,   233,   234,     0,     0,   235,     0,
     363,   236,     0,   364,   365,   366,     0,     0,   240,   367,
     368,   369,   242,   243,   370,   244,   245,     0,     0,     0,
     246,     0,     0,     0,   371,     0,     0,   372,   373,   374,
     248,     0,     0,   249,   375,     0,   376,   250,   251,     0,
       0,     0,     0,   252,     0,     0,     0,   377,   378,   379,
       0,     0,    92,   380,   307,    94,    95,   381,     0,   382,
     383,    96,     0,     0,     0,    97,    98,    99,   308,     0,
     101,     0,     0,   309,   310,   102,     0,   103,   104,     0,
     105,     0,   106,     0,     0,   107,   311,   312,   108,     0,
     313,   109,     0,   110,   314,     0,   315,   113,     0,   114,
     115,   116,   117,   118,   119,     0,   120,   121,     0,   122,
       0,   316,   317,     0,     0,   123,   318,   319,     0,   320,
     124,   125,   126,   127,   321,   322,   323,     0,     0,     0,
       0,   324,   130,   325,     0,     0,   326,     0,     0,     0,
       0,   131,   132,     0,     0,     0,     0,   133,   134,   135,
       0,     0,     0,   136,     0,   137,   138,     0,   139,   140,
       0,     0,   141,     0,   142,   143,   327,   144,   328,   329,
       0,   145,   146,   147,   148,   330,   149,     0,     0,     0,
     150,   151,   934,   152,     0,   153,     0,   331,     0,   154,
       0,   332,     0,     0,     0,   333,   156,   157,   158,   334,
       0,   159,   160,     0,     0,     0,     0,     0,   335,   336,
       0,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,     0,     0,   337,   164,     0,     0,     0,     0,
     165,     0,   166,     0,   167,     0,   168,   338,     0,     0,
       0,     0,   169,   170,   339,   171,   172,   173,   340,     0,
       0,   341,   176,   342,   177,     0,   178,   343,   344,   180,
     181,   182,     0,     0,     0,   183,   184,   185,   345,   346,
     186,   347,   348,     0,   187,   188,     0,   189,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,     0,   193,
     194,   195,   349,     0,   196,     0,   197,   198,   350,   200,
       0,     0,   201,     0,     0,     0,   202,     0,     0,     0,
     203,   351,   352,     0,   204,     0,   353,     0,   354,   206,
     207,   208,   209,   210,   355,   212,     0,   356,   214,     0,
       0,     0,   215,   216,   217,   218,     0,     0,     0,   219,
       0,   220,   221,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,   223,   224,   357,   358,   225,   226,     0,
       0,   227,   359,   229,   360,   361,   230,   231,   232,   362,
     233,   234,     0,     0,   235,     0,   363,   236,     0,   364,
     365,   366,     0,     0,   240,   367,   368,   369,   242,   243,
     370,   244,   245,     0,     0,     0,   246,     0,     0,     0,
     371,     0,     0,   372,   373,   374,   248,     0,     0,   249,
     375,     0,   376,   250,   251,     0,     0,     0,     0,   252,
       0,     0,     0,   377,   378,   379,     0,     0,    92,   380,
     307,    94,    95,   381,     0,   382,   383,    96,     0,     0,
       0,    97,    98,    99,   308,     0,   101,     0,     0,   309,
     310,   102,     0,   103,   104,     0,   105,     0,   106,     0,
       0,   107,   311,   312,   108,     0,   313,   109,     0,   110,
     314,     0,   315,   113,     0,   114,   115,   116,   117,   118,
     119,     0,   120,   121,     0,   122,     0,   316,   317,     0,
       0,   123,   318,   319,     0,   320,   124,   125,   126,   127,
     321,   322,   323,     0,     0,     0,     0,   324,   130,   325,
       0,     0,   326,     0,     0,     0,     0,   131,   132,     0,
       0,     0,     0,   133,   134,   135,     0,     0,     0,   136,
       0,   137,   138,     0,   139,   140,     0,     0,   141,     0,
     142,   143,   327,   144,   328,   329,     0,   145,   146,   147,
     148,   330,   149,     0,     0,     0,   150,   151,     0,   152,
       0,   153,     0,   331,     0,   154,     0,   332,     0,     0,
       0,   333,   156,   157,   158,   334,     0,   159,   160,     0,
       0,     0,     0,     0,   335,   336,     0,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,     0,     0,
     337,   164,     0,     0,     0,     0,   165,     0,   166,     0,
     167,     0,   168,   338,     0,     0,     0,     0,   169,   170,
     339,   171,   172,   173,   340,     0,     0,   341,   176,   342,
     177,     0,   178,   343,   344,   180,   181,   182,     0,     0,
       0,   183,   184,   185,   345,   346,   186,   347,   348,     0,
     187,   188,     0,   189,   190,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,   193,   194,   195,   349,     0,
     196,     0,   197,   198,   350,   200,     0,     0,   201,     0,
       0,     0,   202,     0,     0,     0,   203,   351,   352,     0,
     204,     0,   353,     0,   354,   206,   207,   208,   209,   210,
     355,   212,     0,   356,   214,     0,     0,     0,   215,   216,
     217,   218,     0,     0,     0,   219,     0,   220,   221,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,   223,
     224,   357,   358,   225,   226,     0,     0,   227,   359,   229,
     360,   361,   230,   231,   232,   362,   233,   234,     0,     0,
     235,     0,   363,   236,     0,   364,   365,   366,     0,     0,
     240,   367,   368,   369,   242,   243,   370,   244,   245,     0,
       0,     0,   246,     0,     0,     0,   371,     0,     0,   372,
     373,   374,   248,     0,     0,   249,   375,     0,   376,   250,
     251,     0,     0,     0,     0,   252,     0,     0,     0,   377,
     378,   379,     0,     0,    92,   380,   307,    94,    95,   381,
       0,   382,   383,    96,     0,     0,     0,    97,    98,    99,
     308,     0,   101,     0,     0,   309,   310,   102,     0,   103,
     104,     0,   105,     0,   106,     0,     0,   107,   311,   312,
     108,     0,   313,   109,     0,   110,   314,     0,   315,   113,
       0,   114,   115,   116,   117,   118,   119,     0,   120,   121,
       0,   122,     0,   316,   317,     0,     0,   123,   318,   319,
       0,   320,   124,   125,   126,   127,   321,   322,   323,     0,
       0,     0,     0,   324,   130,   325,     0,     0,   326,     0,
       0,     0,     0,   131,   132,     0,     0,     0,     0,   133,
     134,   135,     0,     0,     0,   136,     0,   137,   138,     0,
     139,   140,     0,     0,   141,     0,   142,   143,   327,   144,
     328,   329,     0,   145,   146,   147,   148,   330,   149,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,   331,
       0,   154,     0,   332,     0,     0,     0,   333,   156,   157,
     158,   334,     0,   159,   160,     0,     0,     0,     0,     0,
     335,   336,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,     0,     0,   337,   164,     0,     0,
       0,     0,   165,     0,   166,     0,   167,     0,   168,   338,
       0,     0,     0,     0,   169,   170,   339,   171,   172,   173,
     340,     0,     0,   341,   176,   342,   177,     0,   178,   343,
     344,   180,   181,   182,     0,     0,     0,   183,   184,   185,
     345,   346,   186,   347,   348,     0,   187,   188,     0,   189,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
       0,   193,   194,   195,   349,     0,   196,     0,   197,   198,
     350,   200,     0,     0,   201,     0,     0,     0,   202,     0,
       0,     0,   203,   351,   352,     0,   204,     0,   353,     0,
     354,   206,   207,   208,   209,   210,   355,   212,     0,   356,
     214,     0,     0,     0,   215,   216,   217,   218,     0,     0,
       0,   219,     0,   220,   221,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,   223,   224,   357,   358,   225,
     226,     0,     0,   227,   359,   229,   360,   361,   230,   231,
     232,   362,   233,   234,     0,     0,   235,     0,   363,   236,
       0,   364,   365,   366,     0,     0,   240,   367,   368,   369,
     242,   243,   370,   244,   245,     0,     0,     0,   246,     0,
       0,     0,   371,     0,     0,   372,   373,   374,   248,     0,
       0,   249,   375,     0,   376,   250,   251,     0,     0,     0,
       0,   252,     0,     0,     0,   377,   378,   379,     0,     0,
       0,   510,     0,     0,     0,   381,     0,   382,   383,    92,
       0,   307,    94,    95,   782,     0,     0,     0,   783,     0,
       0,     0,    97,    98,    99,   308,     0,   101,     0,     0,
     309,   310,   102,     0,   103,   104,     0,   105,     0,   106,
       0,     0,   107,   311,   312,   108,     0,   313,   109,     0,
     110,   314,     0,   315,   113,     0,   114,   115,   116,   117,
     118,   119,     0,   120,   121,     0,   122,     0,   316,   317,
       0,     0,   123,   318,   319,     0,   320,   124,   125,   126,
     127,   321,   322,   323,     0,     0,     0,     0,   324,   130,
     325,     0,     0,   326,     0,     0,     0,     0,   131,   132,
       0,     0,     0,     0,   133,   134,   135,     0,     0,     0,
     136,     0,   137,   138,     0,   139,   140,     0,     0,   141,
       0,   142,   143,   327,   144,   328,   329,     0,   145,   146,
     147,   148,   330,   149,     0,     0,     0,   150,   151,     0,
     152,     0,   153,     0,   331,     0,   154,     0,   332,     0,
       0,     0,   333,   156,   157,   158,   334,     0,   159,   160,
       0,     0,     0,     0,     0,   335,   336,     0,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,     0,
       0,   337,   164,     0,     0,     0,     0,   165,     0,   166,
       0,   167,     0,   168,   338,     0,     0,     0,     0,   169,
     170,   339,   171,   172,   173,   340,     0,     0,   341,   176,
     342,   177,     0,   178,   343,   344,   180,   181,   182,     0,
       0,     0,   183,   184,   185,     0,   346,   186,   347,   348,
       0,   187,   188,     0,   189,   190,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,   193,   194,   195,   349,
       0,   196,     0,   197,   198,   350,   200,     0,     0,   201,
       0,     0,     0,   202,     0,     0,     0,   203,   351,   352,
       0,   204,     0,   353,     0,   354,   206,   207,   208,   209,
     210,   355,   212,     0,   356,   214,     0,     0,     0,   215,
     216,   217,   218,     0,     0,     0,   219,     0,   220,   221,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     223,   224,   357,   358,   225,   226,     0,     0,   227,   359,
     229,   360,   361,   230,   231,   232,   362,   233,   234,     0,
       0,   235,     0,   363,   236,     0,   364,   365,   366,     0,
       0,   240,   367,   368,   369,   242,   243,   370,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   371,     0,     0,
     372,   373,   374,   248,     0,     0,   249,   375,     0,   376,
     250,   251,     0,     0,     0,     0,   252,     0,     0,     0,
     377,   378,   379,     0,     0,    92,   380,   307,    94,    95,
     381,     0,   382,   383,    96,     0,     0,     0,    97,    98,
      99,   308,     0,   101,     0,     0,   309,   310,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,   311,
     312,   108,     0,   313,   109,     0,   110,   314,     0,   315,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,   316,   317,     0,     0,   123,   318,
     319,     0,   320,   124,   125,   126,   127,   321,   322,   323,
       0,     0,     0,     0,   324,   130,   325,     0,     0,   326,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,   327,
     144,   328,   329,     0,   145,   146,   147,   148,   330,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
     331,     0,   154,     0,   332,     0,     0,     0,   333,   156,
     157,   158,   334,     0,   159,   160,     0,     0,     0,     0,
       0,   335,  1073,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   337,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
     338,     0,     0,     0,     0,   169,   170,   339,   171,   172,
     173,   340,     0,     0,   341,   176,   342,   177,     0,   178,
     343,   344,   180,   181,   182,     0,     0,     0,   183,   184,
     185,   345,   346,   186,   347,   348,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,   349,     0,   196,     0,   197,
     198,   350,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,   351,   352,     0,   204,     0,   353,
       0,   354,   206,   207,   208,   209,   210,   355,   212,     0,
     356,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,   357,   358,
     225,   226,     0,     0,   227,   359,   229,   360,   361,   230,
     231,   232,   362,   233,   234,     0,     0,   235,     0,   363,
     236,     0,   364,   365,   366,     0,     0,   240,   367,   368,
     369,   242,   243,   370,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   371,     0,     0,   372,   373,   374,   248,
       0,     0,   249,   375,     0,   376,   250,   251,     0,     0,
       0,     0,   252,     0,     0,     0,   377,   378,   379,     0,
       0,    92,   380,   307,    94,    95,   381,     0,   382,   383,
      96,     0,     0,     0,    97,    98,    99,   308,     0,   101,
       0,     0,   309,   310,   102,     0,   103,   104,     0,   105,
       0,   106,     0,     0,   107,   311,   312,   108,     0,   313,
     109,     0,   110,   314,     0,   315,   113,     0,   114,   115,
     116,   117,   118,   119,     0,   120,   121,     0,   122,     0,
     316,   317,     0,     0,   123,   318,   319,     0,   320,   124,
     125,   126,   127,   321,   322,   323,     0,     0,     0,     0,
     324,   130,   325,     0,     0,   326,     0,     0,     0,     0,
     131,   132,     0,     0,     0,     0,   133,   134,   135,     0,
       0,     0,   136,     0,   137,   138,     0,   139,   140,     0,
       0,   141,     0,   142,   143,   327,   144,   328,   329,     0,
     145,   146,   147,   148,   330,   149,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,   331,     0,   154,     0,
     332,     0,     0,     0,   333,   156,   157,   158,   334,     0,
     159,   160,     0,     0,     0,     0,     0,   335,  1108,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,     0,     0,   337,   164,     0,     0,     0,     0,   165,
       0,   166,     0,   167,     0,   168,   338,     0,     0,     0,
       0,   169,   170,   339,   171,   172,   173,   340,     0,     0,
     341,   176,   342,   177,     0,   178,   343,   344,   180,   181,
     182,     0,     0,     0,   183,   184,   185,   345,   346,   186,
     347,   348,     0,   187,   188,     0,   189,   190,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,   193,   194,
     195,   349,     0,   196,     0,   197,   198,   350,   200,     0,
       0,   201,     0,     0,     0,   202,     0,     0,     0,   203,
     351,   352,     0,   204,     0,   353,     0,   354,   206,   207,
     208,   209,   210,   355,   212,     0,   356,   214,     0,     0,
       0,   215,   216,   217,   218,     0,     0,     0,   219,     0,
     220,   221,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,   224,   357,   358,   225,   226,     0,     0,
     227,   359,   229,   360,   361,   230,   231,   232,   362,   233,
     234,     0,     0,   235,     0,   363,   236,     0,   364,   365,
     366,     0,     0,   240,   367,   368,   369,   242,   243,   370,
     244,   245,     0,     0,     0,   246,     0,     0,     0,   371,
       0,     0,   372,   373,   374,   248,     0,     0,   249,   375,
       0,   376,   250,   251,     0,     0,     0,     0,   252,     0,
       0,     0,   377,   378,   379,     0,     0,    92,   380,   307,
      94,    95,   381,     0,   382,   383,    96,     0,     0,     0,
      97,    98,    99,   308,     0,   101,     0,     0,   309,   310,
     102,     0,   103,   104,     0,   105,     0,   106,     0,     0,
     107,   311,   312,   108,     0,   313,   109,     0,   110,   314,
       0,   315,   113,     0,   114,   115,   116,   117,   118,   119,
       0,   120,   121,     0,   122,     0,   316,   317,     0,     0,
     123,   318,   319,     0,   320,   124,   125,   126,   127,   321,
     322,   323,     0,     0,     0,     0,   324,   130,   325,     0,
       0,  1338,     0,     0,     0,     0,   131,   132,     0,     0,
       0,     0,   133,   134,   135,     0,     0,     0,   136,     0,
     137,   138,     0,   139,   140,     0,     0,   141,     0,   142,
     143,   327,   144,   328,   329,     0,   145,   146,   147,   148,
     330,   149,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,   331,     0,   154,     0,   332,     0,     0,     0,
     333,   156,   157,   158,   334,     0,   159,   160,     0,     0,
       0,     0,     0,   335,   336,     0,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,     0,     0,   337,
     164,     0,     0,     0,     0,   165,     0,   166,     0,   167,
       0,   168,   338,     0,     0,     0,     0,   169,   170,   339,
     171,   172,   173,   340,     0,     0,   341,   176,   342,   177,
       0,   178,   343,   344,   180,   181,   182,     0,     0,     0,
     183,   184,   185,   345,   346,   186,   347,   348,     0,   187,
     188,     0,   189,   190,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   193,   194,   195,   349,     0,   196,
       0,   197,   198,   350,   200,     0,     0,   201,     0,     0,
       0,   202,     0,     0,     0,   203,   351,   352,     0,   204,
       0,   353,     0,   354,   206,   207,   208,   209,   210,   355,
     212,     0,   356,   214,     0,     0,     0,   215,   216,   217,
     218,     0,     0,     0,   219,     0,   220,   221,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,   224,
     357,   358,   225,   226,     0,     0,   227,   359,   229,   360,
     361,   230,   231,   232,   362,   233,   234,     0,     0,   235,
       0,   363,   236,     0,   364,   365,   366,     0,     0,   240,
     367,   368,   369,   242,   243,   370,   244,   245,     0,     0,
       0,   246,     0,     0,     0,   371,     0,     0,   372,   373,
     374,   248,     0,     0,   249,   375,     0,   376,   250,   251,
       0,     0,     0,     0,   252,     0,     0,     0,   377,   378,
     379,     0,     0,    92,   380,   307,    94,    95,   381,     0,
     382,   383,    96,     0,     0,     0,    97,    98,    99,   308,
       0,   101,     0,     0,   309,   310,   102,     0,   103,   104,
       0,   105,     0,   106,     0,     0,   107,   311,   312,   108,
       0,   313,   109,     0,   110,   314,     0,   315,   113,     0,
     114,   115,   116,   117,   118,   119,     0,   120,   121,     0,
     122,     0,   316,   317,     0,     0,   123,   318,   319,     0,
     320,   124,   125,   126,   127,   321,   322,   323,     0,     0,
       0,     0,   324,   130,   325,     0,     0,   326,     0,     0,
       0,     0,   131,   132,     0,     0,     0,     0,   133,   134,
     135,     0,     0,     0,   136,     0,   137,   138,     0,   139,
     140,     0,     0,   141,     0,   142,   143,   327,   144,   328,
     329,     0,   145,   146,   147,   148,   330,   149,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,   331,     0,
     154,     0,   332,     0,     0,     0,   333,   156,   157,   158,
     334,     0,   159,   160,     0,     0,     0,     0,     0,   335,
     336,     0,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,     0,     0,   337,   164,     0,     0,     0,
       0,   165,     0,   166,     0,   167,     0,   168,   338,     0,
       0,     0,     0,   169,   170,   339,   171,   172,   173,   340,
       0,     0,   341,   176,   342,   177,     0,   178,   343,   344,
     180,   181,   182,     0,     0,     0,   183,   184,   185,     0,
     346,   186,   347,   348,     0,   187,   188,     0,   189,   190,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
     193,   194,   195,   349,     0,   196,     0,   197,   198,   350,
     200,     0,     0,   201,     0,     0,     0,   202,     0,     0,
       0,   203,   351,   352,     0,   204,     0,   353,     0,   354,
     206,   207,   208,   209,   210,   355,   212,     0,   356,   214,
       0,     0,     0,   215,   216,   217,   218,     0,     0,     0,
     219,     0,   220,   221,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,   223,   224,   357,   358,   225,   226,
       0,     0,   227,   359,   229,   360,   361,   230,   231,   232,
     362,   233,   234,     0,     0,   235,     0,   363,   236,     0,
     364,   365,   366,     0,     0,   240,   367,   368,   369,   242,
     243,   370,   244,   245,     0,     0,     0,   246,     0,     0,
       0,   371,     0,     0,   372,   373,   374,   248,     0,     0,
     249,   375,     0,   376,   250,   251,     0,     0,     0,     0,
     252,     0,     0,     0,   377,   378,   379,     0,     0,    92,
     380,   307,    94,    95,   381,     0,   382,   383,    96,     0,
       0,     0,    97,    98,    99,   308,     0,   101,     0,     0,
     309,   310,   102,     0,   103,   104,     0,   105,     0,   106,
       0,     0,   107,   311,   312,   108,     0,   313,   109,     0,
     110,   314,     0,   315,   113,     0,   114,   115,   116,   117,
     118,   119,     0,   120,   121,     0,   122,     0,   316,   317,
       0,     0,   123,   318,   319,     0,   320,   124,   125,   126,
     127,   321,   322,   323,     0,     0,     0,     0,   324,   130,
     325,     0,     0,   326,     0,     0,     0,     0,   131,   132,
       0,     0,     0,     0,   133,   134,   135,     0,     0,     0,
     136,     0,   137,   138,     0,   139,   140,     0,     0,   141,
       0,   142,   143,   327,   144,   328,   329,     0,   145,   146,
     147,   148,   330,   149,     0,     0,     0,   150,   151,     0,
     152,     0,   153,     0,   331,     0,   154,     0,   332,     0,
       0,     0,   333,   156,   157,   158,   334,     0,   159,   160,
       0,     0,     0,     0,     0,   335,   791,     0,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,     0,
       0,   337,   164,     0,     0,     0,     0,   165,     0,   166,
       0,   167,     0,   168,   338,     0,     0,     0,     0,   169,
     170,   339,   171,   172,   173,   340,     0,     0,   341,   176,
     342,   177,     0,   178,   343,   344,   180,   181,   182,     0,
       0,     0,   183,   184,   185,     0,   346,   186,   347,   348,
       0,   187,   188,     0,   189,   190,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,   193,   194,   195,   349,
       0,   196,     0,   197,   198,   350,   200,     0,     0,   201,
       0,     0,     0,   202,     0,     0,     0,   203,   351,   352,
       0,   204,     0,   353,     0,   354,   206,   207,   208,   209,
     210,   355,   212,     0,   356,   214,     0,     0,     0,   215,
     216,   217,   218,     0,     0,     0,   219,     0,   220,   221,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     223,   224,   357,   358,   225,   226,     0,     0,   227,   359,
     229,   360,   361,   230,   231,   232,   362,   233,   234,     0,
       0,   235,     0,   363,   236,     0,   364,   365,   366,     0,
       0,   240,   367,   368,   369,   242,   243,   370,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   371,     0,     0,
     372,   373,   374,   248,     0,     0,   249,   375,     0,   376,
     250,   251,     0,     0,     0,     0,   252,     0,     0,     0,
     377,   378,   379,     0,     0,    92,   380,   307,    94,    95,
     381,     0,   382,   383,    96,     0,     0,     0,    97,    98,
      99,   308,     0,   101,     0,     0,   309,   310,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,   311,
     312,   108,     0,   313,   109,     0,   110,   314,     0,   315,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,   316,   317,     0,     0,   123,   318,
     319,     0,   320,   124,   125,   126,   127,   321,   322,   323,
       0,     0,     0,     0,   324,   130,   325,     0,     0,   326,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,   327,
     144,   328,   329,     0,   145,   146,   147,   148,   330,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
     331,     0,   154,     0,   332,     0,     0,     0,   333,   156,
     157,   158,   334,     0,   159,   160,     0,     0,     0,     0,
       0,   335,   793,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,   337,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
     338,     0,     0,     0,     0,   169,   170,   339,   171,   172,
     173,   340,     0,     0,   341,   176,   342,   177,     0,   178,
     343,   344,   180,   181,   182,     0,     0,     0,   183,   184,
     185,     0,   346,   186,   347,   348,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,   349,     0,   196,     0,   197,
     198,   350,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,   351,   352,     0,   204,     0,   353,
       0,   354,   206,   207,   208,   209,   210,   355,   212,     0,
     356,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,   357,   358,
     225,   226,     0,     0,   227,   359,   229,   360,   361,   230,
     231,   232,   362,   233,   234,     0,     0,   235,     0,   363,
     236,     0,   364,   365,   366,     0,     0,   240,   367,   368,
     369,   242,   243,   370,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   371,     0,     0,   372,   373,   374,   248,
       0,     0,   249,   375,     0,   376,   250,   251,     0,     0,
       0,     0,   252,     0,     0,     0,   377,   378,   379,     0,
       0,    92,   380,    93,    94,    95,   381,     0,   382,   383,
      96,     0,     0,     0,    97,    98,    99,   100,     0,   101,
       0,     0,     0,     0,   102,     0,   103,   104,     0,   105,
       0,   106,     0,     0,   107,     0,     0,   108,     0,     0,
     109,     0,   110,   111,     0,   112,   113,     0,   114,   115,
     116,   117,   118,   119,     0,   120,   121,     0,   122,     0,
       0,     0,     0,     0,   123,     0,     0,     0,     0,   124,
     125,   126,   127,     0,     0,   128,     0,     0,     0,     0,
     129,   130,     0,     0,     0,     0,     0,     0,     0,     0,
     131,   132,     0,     0,     0,     0,   133,   134,   135,     0,
       0,     0,   136,     0,   137,   138,     0,   139,   140,     0,
       0,   141,     0,   142,   143,     0,   144,     0,     0,     0,
     145,   146,   147,   148,     0,   149,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,     0,     0,   155,   156,   157,   158,     0,     0,
     159,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,     0,     0,     0,   164,   766,     0,     0,     0,   165,
       0,   166,     0,   167,     0,   168,     0,     0,     0,     0,
       0,   169,   170,     0,   171,   172,   173,   174,     0,     0,
     175,   176,     0,   177,     0,   178,     0,   179,   180,   181,
     182,     0,     0,     0,   183,   184,   185,     0,     0,   186,
       0,     0,     0,   187,   188,     0,   189,   190,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,   193,   194,
     195,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,   201,     0,     0,     0,   202,     0,     0,     0,   203,
       0,     0,     0,   204,     0,   205,     0,     0,   206,   207,
     208,   209,   210,   211,   212,     0,   213,   214,     0,     0,
       0,   215,   216,   217,   218,     0,     0,     0,   219,     0,
     220,   221,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,   224,     0,     0,   225,   226,     0,     0,
     227,   228,   229,     0,     0,   230,   231,   232,     0,   233,
     234,     0,     0,   235,     0,   767,   236,     0,   237,   238,
     239,     0,     0,   240,     0,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,     0,     0,     0,   247,
       0,     0,     0,     0,     0,   248,     0,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,     0,   252,     0,
       0,     0,   253,    92,     0,    93,    94,    95,     0,     0,
       0,     0,    96,     0,     0,   768,    97,    98,    99,   100,
       0,   101,     0,     0,     0,     0,   102,     0,   103,   104,
       0,   105,     0,   106,     0,     0,   107,     0,     0,   108,
       0,     0,   109,     0,   110,   111,     0,   112,   113,     0,
     114,   115,   116,   117,   118,   119,     0,   120,   121,     0,
     122,     0,     0,     0,     0,     0,   123,     0,     0,     0,
       0,   124,   125,   126,   127,     0,     0,   128,     0,     0,
       0,     0,   129,   130,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   132,     0,     0,     0,     0,   133,   134,
     135,     0,     0,     0,   136,     0,   137,   138,     0,   139,
     140,     0,     0,   141,     0,   142,   143,     0,   144,     0,
       0,     0,   145,   146,   147,   148,     0,   149,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,     0,     0,   155,   156,   157,   158,
       0,     0,   159,   160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,     0,     0,     0,   164,   766,     0,     0,
       0,   165,     0,   166,     0,   167,     0,   168,     0,     0,
       0,     0,     0,   169,   170,     0,   171,   172,   173,   174,
       0,     0,   175,   176,     0,   177,     0,   178,     0,   179,
     180,   181,   182,     0,     0,     0,   183,   184,   185,     0,
       0,   186,     0,     0,     0,   187,   188,     0,   189,   190,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
     193,   194,   195,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,   201,     0,     0,     0,   202,     0,     0,
       0,   203,     0,     0,     0,   204,     0,   205,     0,     0,
     206,   207,   208,   209,   210,   211,   212,     0,   213,   214,
       0,     0,     0,   215,   216,   217,   218,     0,     0,     0,
     219,     0,   220,   221,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,   223,   224,     0,     0,   225,   226,
       0,     0,   227,   228,   229,     0,     0,   230,   231,   232,
       0,   233,   234,     0,     0,   235,     0,   767,   236,     0,
     237,   238,   239,     0,     0,   240,     0,     0,   241,   242,
     243,     0,   244,   245,     0,     0,     0,   246,     0,     0,
       0,   247,     0,     0,     0,     0,     0,   248,     0,     0,
     249,     0,     0,     0,   250,   251,     0,     0,     0,     0,
     252,     0,     0,     0,   253,    92,     0,    93,    94,    95,
       0,     0,     0,     0,    96,     0,     0,  1191,    97,    98,
      99,   100,     0,   101,     0,     0,     0,     0,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,     0,
       0,   108,     0,     0,   109,     0,   110,   111,     0,   112,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,     0,     0,     0,     0,   123,     0,
       0,     0,     0,   124,   125,   126,   127,     0,     0,   128,
       0,     0,     0,     0,   129,   130,     0,     0,     0,     0,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,     0,
     144,     0,     0,     0,   145,   146,   147,   148,     0,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,     0,     0,   155,   156,
     157,   158,     0,     0,   159,   160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,     0,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,   170,     0,   171,   172,
     173,   174,     0,     0,   175,   176,     0,   177,     0,   178,
       0,   179,   180,   181,   182,     0,     0,     0,   183,   184,
     185,     0,     0,   186,     0,     0,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,     0,     0,     0,   204,     0,   205,
       0,     0,   206,   207,   208,   209,   210,   211,   212,     0,
     213,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,     0,     0,
     225,   226,     0,     0,   227,   228,   229,     0,     0,   230,
     231,   232,     0,   233,   234,     0,     0,   235,     0,     0,
     236,     0,   237,   238,   239,     0,     0,   240,     0,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   247,     0,     0,     0,     0,     0,   248,
       0,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,     0,   252,     0,     0,     0,   253,    92,     0,    93,
      94,    95,     0,  1927,     0,     0,    96,     0,   382,  1928,
      97,    98,    99,   100,     0,   101,     0,     0,     0,     0,
     102,     0,   103,   104,     0,   105,     0,   106,     0,     0,
     107,     0,     0,   108,     0,     0,   109,     0,   110,   111,
       0,   112,   113,     0,   114,   115,   116,   117,   118,   119,
       0,   120,   121,     0,   122,     0,     0,     0,     0,     0,
     123,     0,     0,     0,     0,   124,   125,   126,   127,     0,
       0,   128,     0,     0,     0,     0,   129,   130,     0,     0,
       0,     0,     0,     0,     0,     0,   131,   132,     0,     0,
       0,     0,   133,   134,   135,     0,     0,     0,   136,     0,
     137,   138,     0,   139,   140,     0,     0,   141,     0,   142,
     143,     0,   144,     0,     0,     0,   145,   146,   147,   148,
       0,   149,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,   157,   158,     0,     0,   159,   160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,     0,     0,     0,
     164,     0,     0,     0,     0,   165,     0,   166,     0,   167,
       0,   168,     0,     0,     0,     0,     0,   169,   170,     0,
     171,   172,   173,   174,     0,     0,   175,   176,     0,   177,
       0,   178,     0,   179,   180,   181,   182,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,     0,     0,   187,
     188,     0,   189,   190,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   193,   194,   195,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,   201,     0,     0,
       0,   202,     0,     0,     0,   203,     0,     0,     0,   204,
       0,   205,     0,     0,   206,   207,   208,   209,   210,   211,
     212,     0,   213,   214,     0,     0,     0,   215,   216,   217,
     218,     0,     0,     0,   219,     0,   220,   221,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,   224,
       0,     0,   225,   226,     0,     0,   227,   228,   229,     0,
       0,   230,   231,   232,     0,   233,   234,     0,     0,   235,
       0,     0,   236,     0,   237,   238,   239,     0,     0,   240,
       0,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,     0,     0,     0,   247,     0,     0,     0,     0,
       0,   248,     0,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,     0,   252,     0,     0,     0,   253,    92,
       0,    93,    94,    95,     0,     0,     0,     0,    96,     0,
     382,  1928,    97,    98,    99,   100,     0,   101,     0,     0,
       0,     0,   102,     0,   103,   104,     0,   105,     0,   106,
       0,     0,   107,     0,     0,   108,     0,     0,   109,     0,
     110,   111,     0,   112,   113,     0,   114,   115,   116,   117,
     118,   119,     0,   120,   121,  1208,   122,     0,     0,     0,
       0,     0,   123,     0,     0,     0,     0,   124,   125,   126,
     127,     0,     0,   128,     0,     0,     0,     0,   129,   130,
       0,     0,     0,     0,     0,     0,     0,     0,   131,   132,
       0,     0,     0,     0,   133,   134,   135,     0,     0,     0,
     136,     0,   137,   138,     0,   139,   140,     0,     0,   141,
       0,   142,   143,     0,   144,     0,     0,     0,   145,   146,
     147,   148,     0,   149,     0,     0,     0,   150,   151,     0,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
       0,     0,   155,   156,   157,   158,     0,     0,   159,   160,
    1209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   161,     0,     0,     0,   162,  1210,     0,   163,     0,
       0,     0,   164,     0,  1256,     0,     0,   165,     0,   166,
       0,   167,     0,   168,     0,     0,     0,     0,     0,   169,
     170,     0,   171,   172,   173,   174,     0,     0,   175,   176,
       0,   177,     0,   178,     0,   179,   180,   181,   182,     0,
       0,     0,   183,   184,   185,     0,     0,   186,     0,     0,
       0,   187,   188,     0,   189,   190,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,   193,   194,   195,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,   201,
       0,     0,     0,   202,     0,     0,     0,   203,     0,     0,
       0,   204,     0,   205,     0,     0,   206,   207,   208,   209,
     210,   211,   212,     0,   213,   214,   807,     0,     0,   215,
     216,   217,   218,     0,     0,     0,   219,     0,   220,   221,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     223,   224,     0,     0,   225,   226,     0,     0,   227,   228,
     229,     0,     0,   230,   231,   232,     0,   233,   234,     0,
       0,   235,     0,     0,   236,     0,   237,   238,   239,     0,
       0,   240,     0,     0,   241,   242,   243,     0,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   247,     0,     0,
       0,     0,     0,   248,     0,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,    92,   252,    93,    94,    95,
     253,     0,     0,     0,    96,     0,     0,     0,    97,    98,
      99,   100,  1241,   101,     0,     0,     0,     0,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,     0,
       0,   108,     0,     0,   109,     0,   110,   111,     0,   112,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,  1208,   122,     0,     0,     0,     0,     0,   123,     0,
       0,     0,     0,   124,   125,   126,   127,     0,     0,   128,
       0,     0,     0,     0,   129,   130,     0,     0,     0,     0,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,     0,
     144,     0,     0,     0,   145,   146,   147,   148,     0,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,     0,     0,   155,   156,
     157,   158,     0,     0,   159,   160,  1209,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   161,     0,     0,
       0,   162,  1210,     0,   163,     0,     0,     0,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,   170,     0,   171,   172,
     173,   174,     0,     0,   175,   176,     0,   177,     0,   178,
       0,   179,   180,   181,   182,     0,     0,     0,   183,   184,
     185,     0,     0,   186,     0,     0,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,     0,     0,     0,   204,     0,   205,
       0,     0,   206,   207,   208,   209,   210,   211,   212,     0,
     213,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,     0,     0,
     225,   226,     0,     0,   227,   228,   229,     0,     0,   230,
     231,   232,     0,   233,   234,     0,     0,   235,     0,     0,
     236,     0,   237,   238,   239,     0,     0,   240,     0,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   247,     0,     0,     0,     0,     0,   248,
       0,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,    92,   252,    93,    94,    95,   253,     0,     0,     0,
      96,     0,     0,     0,    97,    98,    99,   100,  1241,   101,
       0,     0,     0,     0,   102,     0,   103,   104,     0,   105,
       0,   106,     0,     0,   107,     0,     0,   108,     0,     0,
     109,     0,   110,   111,     0,   112,   113,     0,   114,   115,
     116,   117,   118,   119,     0,   120,   121,     0,   122,     0,
       0,     0,     0,     0,   123,     0,     0,     0,     0,   124,
     125,   126,   127,     0,     0,   128,     0,     0,     0,     0,
     129,   130,     0,     0,     0,     0,     0,     0,     0,     0,
     131,   132,     0,     0,     0,     0,   133,   134,   135,     0,
       0,     0,   136,     0,   137,   138,     0,   139,   140,     0,
       0,   141,     0,   142,   143,     0,   144,     0,     0,     0,
     145,   146,   147,   148,     0,   149,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,     0,     0,   155,   156,   157,   158,     0,     0,
     159,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,     0,     0,     0,   164,     0,     0,     0,     0,   165,
       0,   166,     0,   167,     0,   168,     0,     0,     0,     0,
       0,   169,   170,     0,   171,   172,   173,   174,     0,     0,
     175,   176,     0,   177,     0,   178,     0,   179,   180,   181,
     182,     0,     0,     0,   183,   184,   185,     0,     0,   186,
       0,     0,     0,   187,   188,     0,   189,   190,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,   193,   194,
     195,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,   201,     0,     0,     0,   202,     0,     0,     0,   203,
       0,     0,     0,   204,     0,   205,     0,     0,   206,   207,
     208,   209,   210,   211,   212,     0,   213,   214,   807,     0,
       0,   215,   216,   217,   218,     0,     0,     0,   219,     0,
     220,   221,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,   224,     0,     0,   225,   226,     0,     0,
     227,   228,   229,     0,     0,   230,   231,   232,     0,   233,
     234,     0,     0,   235,     0,     0,   236,     0,   237,   238,
     239,     0,     0,   240,     0,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,     0,     0,     0,   247,
       0,     0,     0,     0,     0,   248,     0,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,    92,   252,    93,
      94,    95,   253,     0,     0,     0,    96,     0,     0,   989,
      97,    98,    99,   100,   382,   101,     0,     0,     0,     0,
     102,     0,   103,   104,     0,   105,     0,   106,     0,     0,
     107,     0,     0,   108,     0,     0,   109,     0,   110,   111,
       0,   112,   113,     0,   114,   115,   116,   117,   118,   119,
       0,   120,   121,     0,   122,     0,     0,     0,     0,     0,
     123,     0,     0,     0,     0,   124,   125,   126,   127,     0,
       0,   128,     0,     0,     0,     0,   129,   130,     0,     0,
       0,     0,     0,     0,     0,     0,   131,   132,     0,     0,
       0,     0,   133,   134,   135,     0,     0,     0,   136,     0,
     137,   138,     0,   139,   140,     0,     0,   141,     0,   142,
     143,     0,   144,     0,     0,     0,   145,   146,   147,   148,
       0,   149,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,   157,   158,     0,     0,   159,   160,     0,     0,
       0,     0,     0,     0,     0,   406,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,     0,     0,     0,
     164,     0,     0,     0,     0,   165,     0,   166,     0,   167,
       0,   168,     0,     0,     0,     0,     0,   169,   170,     0,
     171,   172,   173,   174,     0,     0,   175,   176,     0,   177,
       0,   178,     0,   179,   180,   181,   182,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,     0,     0,   187,
     188,     0,   189,   190,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   193,   194,   195,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,   201,     0,     0,
       0,   202,     0,     0,     0,   203,     0,     0,     0,   204,
       0,   205,     0,     0,   206,   207,   208,   209,   210,   211,
     212,     0,   213,   214,     0,     0,     0,   215,   216,   217,
     218,     0,     0,     0,   219,     0,   220,   221,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,   224,
       0,     0,   225,   226,     0,     0,   227,   228,   229,     0,
       0,   230,   231,   232,     0,   233,   234,     0,     0,   235,
       0,     0,   236,     0,   237,   238,   239,     0,     0,   240,
       0,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,     0,     0,     0,   247,     0,     0,     0,     0,
       0,   248,     0,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,    92,   252,    93,    94,    95,   253,     0,
       0,     0,    96,     0,     0,     0,    97,    98,    99,   100,
     277,   101,     0,     0,     0,     0,   102,     0,   103,   104,
       0,   105,     0,   106,     0,     0,   107,     0,     0,   108,
       0,     0,   109,     0,   110,   111,     0,   112,   113,     0,
     114,   115,   116,   117,   118,   119,     0,   120,   121,     0,
     122,     0,     0,     0,     0,     0,   123,     0,     0,     0,
       0,   124,   125,   126,   127,     0,     0,   128,     0,     0,
       0,     0,   129,   130,     0,     0,     0,     0,     0,     0,
       0,     0,   131,   132,     0,     0,     0,     0,   133,   134,
     135,     0,     0,     0,   136,     0,   137,   138,     0,   139,
     140,     0,     0,   141,     0,   142,   143,     0,   144,     0,
       0,     0,   145,   146,   147,   148,     0,   149,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,     0,     0,   155,   156,   157,   158,
       0,     0,   159,   160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,     0,     0,     0,   164,     0,     0,     0,
       0,   165,     0,   166,     0,   167,     0,   168,     0,     0,
       0,     0,     0,   169,   170,     0,   171,   172,   173,   174,
       0,     0,   175,   176,     0,   177,     0,   178,     0,   179,
     180,   181,   182,     0,     0,     0,   183,   184,   185,     0,
       0,   186,     0,     0,     0,   187,   188,     0,   189,   190,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
     193,   194,   195,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,   201,     0,     0,     0,   202,     0,     0,
       0,   203,     0,     0,     0,   204,     0,   205,     0,     0,
     206,   207,   208,   209,   210,   211,   212,     0,   213,   214,
       0,     0,     0,   215,   216,   217,   218,     0,     0,     0,
     219,     0,   220,   221,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,   223,   224,     0,     0,   225,   226,
       0,     0,   227,   228,   229,     0,     0,   230,   231,   232,
       0,   233,   234,     0,     0,   235,     0,     0,   236,     0,
     237,   238,   239,     0,     0,   240,     0,     0,   241,   242,
     243,     0,   244,   245,     0,     0,     0,   246,     0,     0,
       0,   247,     0,     0,     0,     0,     0,   248,     0,     0,
     249,     0,     0,     0,   250,   251,     0,     0,     0,    92,
     252,    93,    94,    95,   253,     0,     0,     0,    96,     0,
    1240,     0,    97,    98,    99,   100,  1241,   101,     0,     0,
       0,     0,   102,     0,   103,   104,     0,   105,     0,   106,
       0,     0,   107,     0,     0,   108,     0,     0,   109,     0,
     110,   111,     0,   112,   113,     0,   114,   115,   116,   117,
     118,   119,     0,   120,   121,     0,   122,     0,     0,     0,
       0,     0,   123,     0,     0,     0,     0,   124,   125,   126,
     127,     0,     0,   128,     0,     0,     0,     0,   129,   130,
       0,     0,     0,     0,     0,     0,     0,     0,   131,   132,
       0,     0,     0,     0,   133,   134,   135,     0,     0,     0,
     136,     0,   137,   138,     0,   139,   140,     0,     0,   141,
       0,   142,   143,     0,   276,     0,     0,     0,   145,   146,
     147,   148,     0,   149,     0,     0,     0,   150,   151,     0,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
       0,     0,   155,   156,   157,   158,     0,     0,   159,   160,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,     0,
       0,     0,   164,     0,     0,     0,     0,   165,     0,   166,
       0,   167,     0,   168,     0,     0,     0,     0,     0,   169,
     170,     0,   171,   172,   173,   174,     0,     0,   175,   176,
       0,   177,     0,   178,     0,   179,   180,   181,   182,     0,
       0,     0,   183,   184,   185,     0,     0,   186,     0,     0,
       0,   187,   188,     0,   189,   190,   191,   192,     0,     0,
       0,     0,     0,     0,     0,     0,   193,   194,   195,     0,
       0,   196,     0,   197,   198,   199,   200,     0,     0,   201,
       0,     0,     0,   202,     0,     0,     0,   203,     0,     0,
       0,   204,     0,   205,     0,     0,   206,   207,   208,   209,
     210,   211,   212,     0,   213,   214,     0,     0,     0,   215,
     216,   217,   218,     0,     0,     0,   219,     0,   220,   221,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     223,   224,     0,     0,   225,   226,     0,     0,   227,   228,
     229,     0,     0,   230,   231,   232,     0,   233,   234,     0,
       0,   235,     0,     0,   236,     0,   237,   238,   239,     0,
       0,   240,     0,     0,   241,   242,   243,     0,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   247,     0,     0,
       0,     0,     0,   248,     0,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,    92,   252,    93,    94,    95,
     253,     0,     0,     0,    96,     0,     0,     0,    97,    98,
      99,   100,   277,   101,     0,     0,     0,     0,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,     0,
       0,   108,     0,     0,   109,     0,   110,   111,     0,   112,
     113,     0,   114,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,     0,     0,     0,     0,   123,     0,
       0,     0,     0,   124,   125,   126,   127,     0,     0,   128,
       0,     0,     0,     0,   129,   130,     0,     0,     0,     0,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,   139,   140,     0,     0,   141,     0,   142,   143,     0,
     144,     0,     0,     0,   145,   146,   147,   148,     0,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,     0,     0,   155,   156,
     157,   158,     0,     0,   159,   160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,     0,   164,     0,
       0,     0,     0,   165,     0,   166,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,   170,     0,   171,   172,
     173,   174,     0,     0,   175,   176,     0,   177,     0,   178,
       0,   179,   180,   181,   182,     0,     0,     0,   183,   184,
     185,     0,     0,   186,     0,     0,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,     0,     0,     0,   204,     0,   205,
       0,     0,   206,   207,   208,   209,   210,   211,   212,     0,
     213,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,     0,     0,
     225,   226,     0,     0,   227,   228,   229,     0,     0,   230,
     231,   232,     0,   233,   234,     0,     0,   235,     0,     0,
     236,     0,   237,   238,   239,     0,     0,   240,     0,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   247,     0,     0,     0,     0,     0,   248,
       0,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,    92,   252,    93,    94,    95,   253,     0,     0,     0,
      96,     0,     0,     0,    97,    98,    99,   100,   277,   101,
       0,     0,     0,     0,   102,     0,   103,   104,     0,   105,
       0,   106,     0,     0,   107,     0,     0,   108,     0,     0,
     109,     0,   110,   111,     0,   112,   113,     0,   114,   115,
     116,   117,   118,   119,     0,   120,   121,     0,   122,     0,
       0,     0,     0,     0,   123,     0,     0,     0,     0,   124,
     125,   126,   127,     0,     0,   128,     0,     0,     0,     0,
     129,   130,     0,     0,     0,     0,     0,     0,     0,     0,
     131,   132,     0,     0,     0,     0,   133,   134,   135,     0,
       0,     0,   136,     0,   137,   138,     0,   139,   140,     0,
       0,   141,     0,   142,   143,     0,   144,     0,     0,     0,
     145,   146,   147,   148,     0,   149,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,     0,     0,   155,   156,   157,   158,     0,     0,
     159,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,     0,     0,     0,   164,     0,     0,     0,     0,   165,
       0,   166,     0,   167,     0,   168,     0,     0,     0,     0,
       0,   169,   170,     0,   171,   172,   173,   174,     0,     0,
     175,   176,     0,   177,     0,   178,     0,   179,   180,   181,
     182,     0,     0,     0,   183,   184,   185,     0,     0,   186,
       0,     0,     0,   187,   188,     0,   189,   190,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,   193,   194,
     195,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,   201,     0,     0,     0,   202,     0,     0,     0,   203,
       0,     0,     0,   204,     0,   205,     0,     0,   206,   207,
     208,   209,   210,   211,   212,     0,   213,   214,     0,     0,
       0,   215,   216,   217,   218,     0,     0,     0,   219,     0,
     220,   221,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,   224,     0,     0,   225,   226,     0,     0,
     227,   228,   229,     0,     0,   230,   231,   232,     0,   233,
     234,     0,     0,   235,     0,     0,   236,     0,   237,   238,
     239,     0,     0,   240,     0,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,     0,     0,     0,   247,
       0,     0,     0,     0,     0,   248,     0,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,    92,   252,    93,
      94,    95,   253,     0,     0,     0,    96,     0,     0,     0,
      97,    98,    99,   100,   382,   101,     0,     0,     0,     0,
     102,     0,   103,   104,     0,   105,     0,   106,     0,     0,
     107,     0,     0,   108,     0,     0,   109,     0,   110,   111,
       0,   112,   113,     0,   114,   115,   116,   117,   118,   119,
       0,   120,   121,     0,   122,     0,     0,     0,     0,     0,
     123,     0,     0,     0,     0,   124,   125,   126,   127,     0,
       0,   128,     0,     0,     0,     0,   129,   130,     0,     0,
       0,     0,     0,     0,     0,     0,   131,   132,     0,     0,
       0,     0,   133,   134,   135,     0,     0,     0,   136,     0,
     137,   138,     0,   139,   140,     0,     0,   141,     0,   142,
     143,     0,   144,     0,     0,     0,   145,   146,   147,   148,
       0,   149,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,   157,   158,     0,     0,   159,   160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,     0,     0,     0,
     164,     0,     0,     0,     0,   165,     0,   166,     0,   167,
       0,   168,     0,     0,     0,     0,     0,   169,   170,     0,
     171,   172,   173,   174,     0,     0,   175,   176,     0,   177,
       0,   178,     0,   179,   180,   181,   182,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,     0,     0,   187,
     188,     0,   189,   190,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   193,   194,   195,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,   201,     0,     0,
       0,   202,     0,     0,     0,   203,     0,     0,     0,   204,
       0,   205,     0,     0,   206,   207,   208,   209,   210,   211,
     212,     0,   213,   214,     0,     0,     0,   215,   216,   217,
     218,     0,     0,     0,   219,     0,   220,   221,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,   224,
       0,     0,   225,   226,     0,     0,   227,   228,   229,     0,
       0,   230,   231,   232,     0,   233,   234,     0,     0,   235,
       0,     0,   236,     0,   237,   238,   239,     0,     0,   240,
       0,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,     0,     0,     0,   247,     0,     0,     0,     0,
       0,   248,     0,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,    92,   252,    93,    94,    95,   253,     0,
       0,     0,    96,     0,     0,     0,    97,  1033,    99,   100,
    1241,   101,     0,     0,     0,     0,   102,     0,   103,   104,
       0,   105,     0,   106,     0,     0,   107,     0,     0,   108,
       0,     0,   109,     0,   110,   111,  -161,   112,   113,     0,
    1035,   115,   116,   117,   118,   119,     0,   120,   121,     0,
     122,     0,     0,     0,     0,     0,   123,     0,     0,     0,
       0,   124,   125,   126,   127,     0,     0,   128,     0,     0,
       0,     0,   129,   130,     0,     0,     0,   643,     0,     0,
       0,     0,   131,   132,     0,     0,     0,     0,   133,   134,
     135,     0,     0,     0,   136,     0,   137,   138,     0,  1041,
     140,     0,     0,   141,     0,   142,   143,     0,   144,     0,
       0,     0,   145,   146,   147,   148,     0,   149,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,     0,     0,   155,   156,   157,   158,
       0,     0,   159,   160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,     0,     0,     0,   164,   766,     0,     0,
       0,   165,     0,   166,     0,   167,     0,   168,     0,     0,
       0,     0,     0,   169,   170,     0,   171,   172,   173,   174,
       0,     0,   175,   176,     0,   177,     0,   178,     0,   179,
     180,   181,   182,     0,     0,     0,   183,   184,   185,     0,
       0,   186,     0,     0,     0,   187,   188,     0,   189,   190,
     191,   192,     0,     0,     0,     0,     0,     0,     0,     0,
     193,   194,   195,     0,     0,   196,     0,   197,   198,   199,
     200,     0,     0,   201,     0,     0,     0,   202,     0,     0,
       0,   203,     0,     0,     0,   204,     0,   205,     0,     0,
     206,   207,   208,   209,   210,   211,   212,     0,   213,   214,
       0,     0,     0,   215,   216,   217,   218,     0,     0,     0,
     219,     0,   220,   221,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,   223,   224,     0,     0,   225,   226,
       0,     0,   227,   228,   229,     0,     0,   230,   231,   232,
       0,   233,   234,     0,     0,   235,     0,   767,   236,     0,
     237,   238,   239,     0,     0,   240,     0,     0,   241,   242,
     243,     0,   244,   245,     0,     0,     0,   246,     0,     0,
       0,   247,     0,     0,     0,     0,     0,   248,     0,     0,
     249,     0,     0,     0,   250,   251,     0,     0,     0,     0,
     252,     0,     0,     0,   253,    92,     0,    93,    94,    95,
       0,     0,  1267,     0,    96,     0,     0,     0,    97,  1033,
      99,   100,     0,   101,     0,     0,     0,     0,   102,     0,
     103,   104,     0,   105,     0,   106,     0,     0,   107,     0,
       0,   108,     0,     0,   109,     0,   110,   111,  -161,   112,
     113,     0,  1035,   115,   116,   117,   118,   119,     0,   120,
     121,     0,   122,     0,     0,     0,     0,     0,   123,     0,
       0,     0,     0,   124,   125,   126,   127,     0,     0,   128,
       0,     0,     0,     0,   129,   130,     0,     0,     0,   643,
       0,     0,     0,     0,   131,   132,     0,     0,     0,     0,
     133,   134,   135,     0,     0,     0,   136,     0,   137,   138,
       0,  1041,   140,     0,     0,   141,     0,   142,   143,     0,
     144,     0,     0,     0,   145,   146,   147,   148,     0,   149,
       0,     0,     0,   150,   151,     0,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,     0,     0,   155,   156,
     157,   158,     0,     0,   159,   160,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,     0,     0,     0,   164,   766,
    1060,     0,     0,   165,     0,   166,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,   170,     0,   171,   172,
     173,   174,     0,     0,   175,   176,     0,   177,     0,   178,
       0,   179,   180,   181,   182,     0,     0,     0,   183,   184,
     185,     0,     0,   186,     0,     0,     0,   187,   188,     0,
     189,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,     0,   193,   194,   195,     0,     0,   196,     0,   197,
     198,   199,   200,     0,     0,   201,     0,     0,     0,   202,
       0,     0,     0,   203,     0,     0,     0,   204,     0,   205,
       0,     0,   206,   207,   208,   209,   210,   211,   212,     0,
     213,   214,     0,     0,     0,   215,   216,   217,   218,     0,
       0,     0,   219,     0,   220,   221,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,   224,     0,     0,
     225,   226,     0,     0,   227,   228,   229,     0,     0,   230,
     231,   232,     0,   233,   234,     0,     0,   235,     0,   767,
     236,     0,   237,   238,   239,     0,     0,   240,     0,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
       0,     0,     0,   247,     0,     0,     0,     0,     0,   248,
       0,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,    92,   252,    93,    94,    95,   253,     0,     0,     0,
      96,     0,  1061,     0,    97,    98,    99,   100,     0,   101,
       0,     0,     0,     0,   102,     0,   103,   104,     0,   105,
       0,   106,     0,     0,   107,     0,     0,   108,     0,     0,
     109,     0,   110,   111,     0,   112,   113,     0,   114,   115,
     116,   117,   118,   119,     0,   120,   121,     0,   122,     0,
       0,     0,     0,     0,   123,     0,     0,     0,     0,   124,
     125,   126,   127,     0,     0,   128,     0,     0,     0,     0,
     129,   130,     0,     0,     0,     0,     0,     0,     0,     0,
     131,   132,     0,     0,     0,     0,   133,   134,   135,     0,
       0,     0,   136,     0,   137,   138,     0,   139,   140,     0,
       0,   141,     0,   142,   143,     0,   144,     0,     0,     0,
     145,   146,   147,   148,     0,   149,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,     0,     0,   155,   156,   157,   158,     0,     0,
     159,   160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,     0,     0,     0,   164,     0,     0,     0,     0,   165,
       0,   166,     0,   167,     0,   168,     0,     0,     0,     0,
       0,   169,   170,     0,   171,   172,   173,   174,     0,     0,
     175,   176,     0,   177,     0,   178,     0,   179,   180,   181,
     182,     0,     0,     0,   183,   184,   185,     0,     0,   186,
       0,     0,     0,   187,   188,     0,   189,   190,   191,   192,
       0,     0,     0,     0,     0,     0,     0,     0,   193,   194,
     195,     0,     0,   196,     0,   197,   198,   199,   200,     0,
       0,   201,     0,     0,     0,   202,     0,     0,     0,   203,
       0,     0,     0,   204,     0,   205,     0,     0,   206,   207,
     208,   209,   210,   211,   212,     0,   213,   214,     0,     0,
       0,   215,   216,   217,   218,     0,     0,     0,   219,     0,
     220,   221,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,   223,   224,     0,     0,   225,   226,     0,     0,
     227,   228,   229,     0,     0,   230,   231,   232,     0,   233,
     234,     0,     0,   235,     0,     0,   236,     0,   237,   238,
     239,     0,     0,   240,     0,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,     0,     0,     0,   247,
       0,     0,     0,     0,     0,   248,     0,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,    92,   252,    93,
      94,    95,   253,     0,     0,  1187,    96,     0,     0,     0,
      97,    98,    99,   100,     0,   101,     0,     0,     0,     0,
     102,     0,   103,   104,     0,   105,     0,   106,     0,     0,
     107,     0,     0,   108,     0,     0,   109,     0,   110,   111,
       0,   112,   113,     0,   114,   115,   116,   117,   118,   119,
       0,   120,   121,     0,   122,     0,     0,     0,     0,     0,
     123,     0,     0,     0,     0,   124,   125,   126,   127,     0,
       0,   128,     0,     0,     0,     0,   129,   130,     0,     0,
       0,     0,     0,     0,     0,     0,   131,   132,     0,     0,
       0,     0,   133,   134,   135,     0,     0,     0,   136,     0,
     137,   138,     0,   139,   140,     0,     0,   141,     0,   142,
     143,     0,   144,     0,     0,     0,   145,   146,   147,   148,
       0,   149,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,   157,   158,     0,     0,   159,   160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,     0,     0,     0,
     164,     0,     0,     0,     0,   165,     0,   166,     0,   167,
       0,   168,     0,     0,     0,     0,     0,   169,   170,     0,
     171,   172,   173,   174,     0,     0,   175,   176,     0,   177,
       0,   178,     0,   179,   180,   181,   182,     0,     0,     0,
     183,   184,   185,     0,     0,   186,     0,     0,     0,   187,
     188,     0,   189,   190,   191,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   193,   194,   195,     0,     0,   196,
       0,   197,   198,   199,   200,     0,     0,   201,     0,     0,
       0,   202,     0,     0,     0,   203,     0,     0,     0,   204,
       0,   205,     0,     0,   206,   207,   208,   209,   210,   211,
     212,     0,   213,   214,     0,     0,     0,   215,   216,   217,
     218,     0,     0,     0,   219,     0,   220,   221,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,   224,
       0,     0,   225,   226,     0,     0,   227,   228,   229,     0,
       0,   230,   231,   232,     0,   233,   234,     0,     0,   235,
       0,     0,   236,     0,   237,   238,   239,     0,     0,   240,
       0,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,     0,     0,     0,   247,     0,     0,     0,     0,
       0,   248,     0,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,     0,   252,     0,     0,     0,   253,     0,
       0,  1506,    92,  1031,    93,    94,    95,     0,  1032,     0,
       0,    96,     0,     0,     0,    97,  1033,    99,   100,     0,
     101,     0,     0,     0,     0,   102,     0,   103,   104,     0,
     105,     0,   106,     0,     0,   107,     0,     0,   108,  1034,
       0,   109,     0,   110,   111,     0,   112,   113,     0,  1035,
     115,   116,   117,   118,   119,     0,   120,   121,     0,   122,
       0,  1036,     0,     0,     0,   123,     0,     0,     0,     0,
     124,   125,   126,   127,     0,     0,   128,     0,     0,     0,
       0,   129,   130,     0,     0,     0,   643,     0,     0,     0,
       0,  1037,  1038,     0,     0,     0,  1039,   133,   134,   135,
       0,     0,     0,  1040,     0,   137,   138,  -226,  1041,   140,
       0,     0,   141,     0,   142,   143,     0,   144,     0,     0,
       0,   145,   146,   147,   148,     0,   149,  1042,     0,     0,
     150,   151,     0,   152,     0,   153,     0,     0,     0,   154,
       0,     0,     0,     0,     0,   155,   156,   157,   158,     0,
       0,  1043,   160,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,     0,     0,     0,   164,   766,     0,     0,     0,
     165,     0,   166,     0,   167,     0,   168,     0,     0,     0,
       0,     0,   169,   170,     0,   171,   172,   173,   174,     0,
       0,   175,   176,     0,   177,     0,  1044,     0,   179,   180,
     181,   182,     0,     0,     0,   183,   184,   185,     0,     0,
     186,     0,     0,     0,   187,   188,     0,   189,   190,   191,
     192,     0,     0,     0,  1045,     0,     0,     0,     0,   193,
     194,   195,     0,     0,   196,     0,   197,   198,   199,   200,
       0,     0,   201,     0,     0,     0,   202,     0,     0,  1046,
     203,     0,     0,     0,   204,     0,   205,     0,     0,   206,
     207,   208,   209,   210,   211,   212,     0,   213,   214,     0,
       0,     0,   215,   216,   217,   218,     0,     0,     0,   219,
       0,   220,   221,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,   223,   224,     0,     0,   225,   226,     0,
       0,   227,   228,   229,     0,     0,   230,   231,   232,     0,
     233,   234,     0,     0,   235,     0,   767,   236,     0,   237,
     238,   239,     0,     0,   240,     0,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,     0,     0,     0,
     247,     0,     0,     0,     0,     0,   248,     0,     0,   249,
       0,     0,     0,   250,   251,     0,     0,     0,     0,   252,
       0,     0,     0,   253,    92,  1031,    93,    94,    95,     0,
    1032,     0,     0,    96,     0,     0,     0,    97,  1033,    99,
     100,     0,   101,     0,     0,     0,     0,   102,     0,   103,
     104,     0,   105,     0,   106,     0,     0,   107,     0,     0,
     108,  1034,     0,   109,     0,   110,   111,     0,   112,   113,
       0,  1035,   115,   116,   117,   118,   119,     0,   120,   121,
       0,   122,     0,  1036,     0,     0,     0,   123,     0,     0,
       0,     0,   124,   125,   126,   127,     0,     0,   128,     0,
       0,     0,     0,   129,   130,     0,     0,     0,   643,     0,
       0,     0,     0,  1037,   132,     0,     0,     0,  1039,   133,
     134,   135,     0,     0,     0,  1040,     0,   137,   138,     0,
    1041,   140,     0,     0,   141,     0,   142,   143,     0,   144,
       0,     0,     0,   145,   146,   147,   148,     0,   149,  1042,
       0,     0,   150,   151,     0,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,     0,     0,   155,   156,   157,
     158,     0,     0,   159,   160,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,     0,     0,     0,   164,   766,     0,
       0,     0,   165,     0,   166,     0,   167,     0,   168,     0,
       0,     0,     0,     0,   169,   170,     0,   171,   172,   173,
     174,     0,     0,   175,   176,     0,   177,     0,  1044,     0,
     179,   180,   181,   182,     0,     0,     0,   183,   184,   185,
       0,     0,   186,     0,     0,     0,   187,   188,     0,   189,
     190,   191,   192,     0,     0,     0,  1045,     0,     0,     0,
       0,   193,   194,   195,     0,     0,   196,     0,   197,   198,
     199,   200,     0,     0,   201,     0,     0,     0,   202,     0,
       0,  1046,   203,     0,     0,     0,   204,     0,   205,     0,
       0,   206,   207,   208,   209,   210,   211,   212,     0,   213,
     214,     0,     0,     0,   215,   216,   217,   218,     0,     0,
       0,   219,     0,   220,   221,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,   223,   224,     0,     0,   225,
     226,     0,     0,   227,   228,   229,     0,     0,   230,   231,
     232,     0,   233,   234,     0,     0,   235,     0,   767,   236,
       0,   237,   238,   239,     0,     0,   240,     0,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,     0,
       0,     0,   247,     0,     0,     0,     0,     0,   248,     0,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
      92,   252,    93,    94,    95,   253,     0,     0,     0,    96,
       0,     0,     0,    97,    98,    99,   100,     0,   101,     0,
       0,     0,     0,   102,     0,   103,   104,     0,   105,     0,
     106,     0,     0,   107,     0,     0,   108,     0,     0,   109,
       0,   110,   111,     0,   112,   113,     0,   114,   115,   116,
     117,   118,   119,     0,   120,   121,     0,   122,     0,     0,
       0,     0,     0,   123,     0,     0,     0,     0,   124,   125,
     126,   127,     0,     0,   128,     0,     0,     0,     0,   129,
     130,  1248,     0,     0,     0,     0,     0,     0,     0,   131,
     132,     0,     0,     0,     0,   133,   134,   135,     0,     0,
       0,   136,     0,   137,   138,     0,   139,   140,     0,     0,
     141,     0,   142,   143,     0,   144,     0,     0,     0,   145,
     146,   147,   148,  1249,   149,     0,     0,     0,   150,   151,
       0,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,     0,     0,   155,   156,   157,   158,     0,     0,   159,
     160,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
       0,     0,     0,   164,   766,     0,     0,     0,   165,     0,
     166,     0,   167,     0,   168,  1250,     0,     0,     0,     0,
     169,   170,     0,   171,   172,   173,   174,     0,     0,   175,
     176,     0,   177,     0,   178,     0,   179,   180,   181,   182,
       0,     0,     0,   183,   184,   185,     0,     0,   186,     0,
    1251,     0,   187,   188,     0,   189,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,   193,   194,   195,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
     201,     0,     0,     0,   202,     0,     0,     0,   203,     0,
       0,     0,   204,     0,   205,     0,     0,   206,   207,   208,
     209,   210,   211,   212,     0,   213,   214,     0,     0,     0,
     215,   216,   217,   218,     0,     0,     0,   219,     0,   220,
     221,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,   223,   224,     0,     0,   225,   226,     0,     0,   227,
     228,   229,     0,     0,   230,   231,   232,     0,   233,   234,
       0,     0,   235,     0,   767,   236,     0,   237,   238,   239,
       0,     0,   240,     0,     0,   241,   242,   243,  1252,   244,
     245,     0,     0,     0,   246,     0,     0,     0,   247,     0,
       0,     0,     0,     0,   248,     0,     0,   249,     0,     0,
       0,   250,   251,     0,     0,     0,    92,   252,    93,    94,
      95,   253,     0,     0,     0,    96,     0,     0,     0,    97,
      98,    99,   100,     0,   101,     0,     0,     0,     0,   102,
       0,   103,   104,     0,   105,     0,   106,     0,     0,   107,
       0,     0,   108,     0,     0,   109,     0,   110,   111,  -161,
     112,   113,     0,   114,   115,   116,   117,   118,   119,     0,
     120,   121,     0,   122,     0,     0,     0,     0,     0,   123,
       0,     0,     0,     0,   124,   125,   126,   127,     0,     0,
     128,     0,     0,     0,     0,   129,   130,     0,     0,     0,
     643,     0,     0,     0,     0,   131,   132,     0,     0,     0,
       0,   133,   134,   135,     0,     0,     0,   136,     0,   137,
     138,     0,   139,   140,     0,     0,   141,     0,   142,   143,
       0,   144,     0,     0,     0,   145,   146,   147,   148,     0,
     149,     0,     0,     0,   150,   151,     0,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,     0,     0,   155,
     156,   157,   158,     0,     0,   159,   160,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,     0,     0,     0,   164,
     766,     0,     0,     0,   165,     0,   166,     0,   167,     0,
     168,     0,     0,     0,     0,     0,   169,   170,     0,   171,
     172,   173,   174,     0,     0,   175,   176,     0,   177,     0,
     178,     0,   179,   180,   181,   182,     0,     0,     0,   183,
     184,   185,     0,     0,   186,     0,     0,     0,   187,   188,
       0,   189,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,   193,   194,   195,     0,     0,   196,     0,
     197,   198,   199,   200,     0,     0,   201,     0,     0,     0,
     202,     0,     0,     0,   203,     0,     0,     0,   204,     0,
     205,     0,     0,   206,   207,   208,   209,   210,   211,   212,
       0,   213,   214,     0,     0,     0,   215,   216,   217,   218,
       0,     0,     0,   219,     0,   220,   221,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,   223,   224,     0,
       0,   225,   226,     0,     0,   227,   228,   229,     0,     0,
     230,   231,   232,     0,   233,   234,     0,     0,   235,     0,
     767,   236,     0,   237,   238,   239,     0,     0,   240,     0,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,     0,     0,     0,   247,     0,     0,     0,     0,     0,
     248,     0,     0,   249,     0,     0,     0,   250,   251,     0,
       0,     0,    92,   252,    93,    94,    95,   253,     0,     0,
       0,    96,     0,     0,     0,    97,  1033,    99,   100,     0,
     101,     0,     0,     0,     0,   102,     0,   103,   104,     0,
     105,     0,   106,     0,     0,   107,     0,     0,   108,     0,
       0,   109,     0,   110,   111,  -161,   112,   113,     0,  1035,
     115,   116,   117,   118,   119,     0,   120,   121,     0,   122,
       0,     0,     0,     0,     0,   123,     0,     0,     0,     0,
     124,   125,   126,   127,     0,     0,   128,     0,     0,     0,
       0,   129,   130,     0,     0,     0,   643,     0,     0,     0,
       0,   131,   132,     0,     0,     0,     0,   133,   134,   135,
       0,     0,     0,   136,     0,   137,   138,     0,  1041,   140,
       0,     0,   141,     0,   142,   143,     0,   144,     0,     0,
       0,   145,   146,   147,   148,     0,   149,     0,     0,     0,
     150,   151,     0,   152,     0,   153,     0,     0,     0,   154,
       0,     0,     0,     0,     0,   155,   156,   157,   158,     0,
       0,   159,   160,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,     0,     0,     0,   164,   766,     0,     0,     0,
     165,     0,   166,     0,   167,     0,   168,     0,     0,     0,
       0,     0,   169,   170,     0,   171,   172,   173,   174,     0,
       0,   175,   176,     0,   177,     0,   178,     0,   179,   180,
     181,   182,     0,     0,     0,   183,   184,   185,     0,     0,
     186,     0,     0,     0,   187,   188,     0,   189,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,     0,   193,
     194,   195,     0,     0,   196,     0,   197,   198,   199,   200,
       0,     0,   201,     0,     0,     0,   202,     0,     0,     0,
     203,     0,     0,     0,   204,     0,   205,     0,     0,   206,
     207,   208,   209,   210,   211,   212,     0,   213,   214,     0,
       0,     0,   215,   216,   217,   218,     0,     0,     0,   219,
       0,   220,   221,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,   223,   224,     0,     0,   225,   226,     0,
       0,   227,   228,   229,     0,     0,   230,   231,   232,     0,
     233,   234,     0,     0,   235,     0,   767,   236,     0,   237,
     238,   239,     0,     0,   240,     0,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,     0,     0,     0,
     247,     0,     0,     0,     0,     0,   248,     0,     0,   249,
       0,     0,     0,   250,   251,     0,     0,     0,    92,   252,
      93,    94,    95,   253,     0,     0,     0,    96,     0,     0,
       0,    97,    98,    99,   100,     0,   101,     0,     0,     0,
     636,   102,     0,   103,   104,     0,   105,     0,   106,     0,
       0,   107,     0,     0,   108,     0,     0,   109,     0,   110,
     111,     0,   112,   113,     0,   114,   115,   116,   117,   118,
     119,     0,   120,   121,     0,   122,     0,     0,     0,     0,
       0,   123,     0,     0,     0,     0,   124,   125,   126,   127,
       0,     0,   128,     0,     0,     0,     0,   129,   130,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   132,     0,
       0,     0,     0,   133,   134,   135,     0,     0,     0,   136,
       0,   137,   138,     0,   139,   140,     0,     0,   141,     0,
     142,   143,     0,   144,     0,     0,     0,   145,   146,   147,
     148,     0,   149,     0,     0,     0,   150,   151,     0,   152,
       0,   153,     0,     0,     0,   154,     0,   637,     0,     0,
       0,   155,   156,   157,   158,     0,     0,   159,   160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,     0,     0,
       0,   164,     0,     0,     0,     0,   165,     0,   166,     0,
     167,     0,   168,     0,     0,     0,     0,     0,   169,   170,
       0,   171,   172,   173,   174,     0,     0,   175,   176,     0,
     177,     0,   178,     0,   179,   180,   181,   182,     0,     0,
       0,   183,   184,   185,     0,     0,   186,     0,     0,     0,
     187,   188,     0,   189,   190,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,   193,   194,   195,     0,     0,
     196,     0,   197,   198,   199,   200,     0,     0,   201,     0,
       0,     0,   202,     0,     0,     0,   203,     0,     0,     0,
     204,     0,   205,     0,     0,   206,   207,   208,   209,   210,
     211,   212,     0,   213,   214,     0,     0,     0,   215,   216,
     217,   218,     0,     0,     0,   219,     0,   220,   221,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,   223,
     224,     0,     0,   225,   226,     0,     0,   227,   228,   229,
       0,     0,   230,   231,   232,     0,   233,   234,     0,     0,
     235,     0,   363,   236,     0,   237,   238,   239,     0,     0,
     240,     0,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,     0,     0,     0,   247,     0,     0,     0,
       0,     0,   248,     0,     0,   249,     0,     0,     0,   250,
     251,     0,     0,     0,    92,   252,    93,    94,    95,   253,
       0,     0,     0,    96,     0,     0,     0,    97,    98,    99,
     100,     0,   101,     0,     0,     0,     0,   102,     0,   103,
     104,     0,   105,     0,   106,     0,     0,   107,     0,     0,
     108,     0,     0,   109,     0,   110,   111,     0,   112,   113,
       0,   114,   115,   116,   117,   118,   119,     0,   120,   121,
       0,   122,     0,     0,     0,     0,     0,   123,     0,     0,
       0,     0,   124,   125,   126,   127,     0,     0,   128,     0,
       0,     0,     0,   129,   130,     0,     0,     0,  1203,     0,
       0,     0,     0,   131,   132,     0,     0,     0,     0,   133,
     134,   135,     0,     0,     0,   136,     0,   137,   138,     0,
     139,   140,     0,     0,   141,     0,   142,   143,     0,   144,
       0,     0,     0,   145,   146,   147,   148,     0,   149,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,     0,     0,   155,   156,   157,
     158,     0,     0,   159,   160,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,     0,     0,     0,   164,   766,     0,
       0,     0,   165,     0,   166,     0,   167,     0,   168,     0,
       0,     0,     0,     0,   169,   170,     0,   171,   172,   173,
     174,     0,     0,   175,   176,     0,   177,     0,   178,     0,
     179,   180,   181,   182,     0,     0,     0,   183,   184,   185,
       0,     0,   186,     0,     0,     0,   187,   188,     0,   189,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
       0,   193,   194,   195,     0,     0,   196,     0,   197,   198,
     199,   200,     0,     0,   201,     0,     0,     0,   202,     0,
       0,     0,   203,     0,     0,     0,   204,     0,   205,     0,
       0,   206,   207,   208,   209,   210,   211,   212,     0,   213,
     214,     0,     0,     0,   215,   216,   217,   218,     0,     0,
       0,   219,     0,   220,   221,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,   223,   224,     0,     0,   225,
     226,     0,     0,   227,   228,   229,     0,     0,   230,   231,
     232,     0,   233,   234,     0,     0,   235,     0,   767,   236,
       0,   237,   238,   239,     0,     0,   240,     0,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,     0,
       0,     0,   247,     0,     0,     0,     0,     0,   248,     0,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
      92,   252,    93,    94,    95,   253,     0,     0,     0,    96,
       0,     0,     0,    97,  1033,    99,   100,     0,   101,     0,
       0,     0,     0,   102,     0,   103,   104,     0,   105,     0,
     106,     0,     0,   107,     0,     0,   108,     0,     0,   109,
       0,   110,   111,     0,   112,   113,     0,  1035,   115,   116,
     117,   118,   119,     0,   120,   121,     0,   122,     0,     0,
       0,     0,     0,   123,     0,     0,     0,     0,   124,   125,
     126,   127,     0,     0,   128,     0,     0,     0,     0,   129,
     130,     0,     0,     0,   643,     0,     0,     0,     0,   131,
     132,     0,     0,     0,     0,   133,   134,   135,     0,     0,
       0,   136,     0,   137,   138,     0,  1041,   140,     0,     0,
     141,     0,   142,   143,     0,   144,     0,     0,     0,   145,
     146,   147,   148,     0,   149,     0,     0,     0,   150,   151,
       0,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,     0,     0,   155,   156,   157,   158,     0,     0,   159,
     160,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
       0,     0,     0,   164,   766,     0,     0,     0,   165,     0,
     166,     0,   167,     0,   168,     0,     0,     0,     0,     0,
     169,   170,     0,   171,   172,   173,   174,     0,     0,   175,
     176,     0,   177,     0,   178,     0,   179,   180,   181,   182,
       0,     0,     0,   183,   184,   185,     0,     0,   186,     0,
       0,     0,   187,   188,     0,   189,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,   193,   194,   195,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
     201,     0,     0,     0,   202,     0,     0,     0,   203,     0,
       0,     0,   204,     0,   205,     0,     0,   206,   207,   208,
     209,   210,   211,   212,     0,   213,   214,     0,     0,     0,
     215,   216,   217,   218,     0,     0,     0,   219,     0,   220,
     221,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,   223,   224,     0,     0,   225,   226,     0,     0,   227,
     228,   229,     0,     0,   230,   231,   232,     0,   233,   234,
       0,     0,   235,     0,   767,   236,     0,   237,   238,   239,
       0,     0,   240,     0,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,     0,     0,     0,   247,     0,
       0,     0,     0,     0,   248,     0,     0,   249,     0,     0,
       0,   250,   251,     0,     0,     0,    92,   252,    93,    94,
      95,   253,     0,     0,     0,    96,     0,     0,     0,    97,
      98,    99,   100,     0,   101,     0,     0,     0,     0,   102,
       0,   103,   104,     0,   105,     0,   106,     0,     0,   107,
       0,     0,   108,     0,     0,   109,     0,   110,   111,     0,
     112,   113,     0,   114,   115,   116,   117,   118,   119,     0,
     120,   121,     0,   122,     0,     0,     0,     0,     0,   123,
       0,     0,     0,     0,   124,   125,   126,   127,     0,     0,
     128,     0,     0,     0,     0,   129,   130,     0,     0,     0,
       0,     0,     0,     0,     0,   131,   132,     0,     0,     0,
       0,   133,   134,   135,     0,     0,     0,   136,     0,   137,
     138,     0,   139,   140,     0,     0,   141,     0,   142,   143,
       0,   144,     0,     0,     0,   145,   146,   147,   148,     0,
     149,     0,     0,     0,   150,   151,     0,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,     0,     0,   155,
     156,   157,   158,     0,     0,   159,   160,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,     0,     0,     0,   164,
     766,     0,     0,     0,   165,     0,   166,     0,   167,     0,
     168,     0,     0,     0,     0,     0,   169,   170,     0,   171,
     172,   173,   174,     0,     0,   175,   176,     0,   177,     0,
     178,     0,   179,   180,   181,   182,     0,     0,     0,   183,
     184,   185,     0,     0,   186,     0,     0,     0,   187,   188,
       0,   189,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,   193,   194,   195,     0,     0,   196,     0,
     197,   198,   199,   200,     0,     0,   201,     0,     0,     0,
     202,     0,     0,     0,   203,     0,     0,     0,   204,     0,
     205,     0,     0,   206,   207,   208,   209,   210,   211,   212,
       0,   213,   214,     0,     0,     0,   215,   216,   217,   218,
       0,     0,     0,   219,     0,   220,   221,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,   223,   224,     0,
       0,   225,   226,     0,     0,   227,   228,   229,     0,     0,
     230,   231,   232,     0,   233,   234,     0,     0,   235,     0,
     767,   236,     0,   237,   238,   239,     0,     0,   240,     0,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,     0,     0,     0,   247,     0,     0,     0,     0,     0,
     248,     0,     0,   249,     0,     0,     0,   250,   251,     0,
       0,     0,    92,   252,    93,    94,    95,   253,     0,     0,
       0,    96,  1183,     0,     0,    97,    98,    99,   100,     0,
     101,     0,     0,     0,     0,   102,     0,   103,   104,     0,
     105,     0,   106,     0,     0,   107,     0,     0,   108,     0,
       0,   109,     0,   110,   111,     0,   112,   113,     0,   114,
     115,   116,   117,   118,   119,     0,   120,   121,     0,   122,
       0,     0,     0,     0,     0,   123,     0,     0,     0,     0,
     124,   125,   126,   127,     0,     0,   128,     0,     0,     0,
       0,   129,   130,     0,     0,     0,     0,     0,     0,     0,
       0,   131,   132,     0,     0,     0,     0,   133,   134,   135,
       0,     0,     0,   136,     0,   137,   138,     0,   139,   140,
       0,     0,   141,     0,   142,   143,     0,   144,     0,     0,
       0,   145,   146,   147,   148,     0,   149,     0,     0,     0,
     150,   151,     0,   152,     0,   153,     0,     0,     0,   154,
       0,     0,     0,     0,     0,   155,   156,   157,   158,     0,
       0,   159,   160,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,     0,     0,     0,   164,     0,     0,     0,     0,
     165,     0,   166,     0,   167,     0,   168,     0,     0,     0,
       0,     0,   169,   170,     0,   171,   172,   173,   174,     0,
       0,   175,   176,     0,   177,     0,   178,     0,   179,   180,
     181,   182,     0,     0,     0,   183,   184,   185,     0,     0,
     186,     0,     0,     0,   187,   188,     0,   189,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,     0,   193,
     194,   195,     0,     0,   196,     0,   197,   198,   199,   200,
       0,     0,   201,     0,     0,     0,   202,     0,     0,     0,
     203,     0,     0,     0,   204,     0,   205,     0,     0,   206,
     207,   208,   209,   210,   211,   212,     0,   213,   214,     0,
       0,     0,   215,   216,   217,   218,     0,     0,     0,   219,
       0,   220,   221,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,   223,   224,     0,     0,   225,   226,     0,
       0,   227,   228,   229,     0,     0,   230,   231,   232,     0,
     233,   234,     0,     0,   235,     0,   767,   236,     0,   237,
     238,   239,     0,     0,   240,     0,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,     0,     0,     0,
     247,     0,     0,     0,     0,     0,   248,     0,     0,   249,
       0,     0,     0,   250,   251,     0,     0,     0,    92,   252,
      93,    94,    95,   253,     0,     0,     0,    96,     0,     0,
       0,    97,    98,    99,   100,     0,   101,     0,     0,     0,
       0,   102,     0,   103,   104,     0,   105,     0,   106,     0,
       0,   107,     0,     0,   108,     0,     0,   109,     0,   110,
     111,     0,   112,   113,     0,   114,   115,   116,   117,   118,
     119,     0,   120,   121,     0,   122,     0,     0,     0,     0,
       0,   123,     0,     0,     0,     0,   124,   125,   126,   127,
       0,     0,   128,     0,     0,     0,     0,   129,   130,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   132,     0,
       0,     0,     0,   133,   134,   135,     0,     0,     0,   136,
       0,   137,   138,     0,   139,   140,     0,     0,   141,     0,
     142,   143,     0,   144,     0,     0,     0,   145,   146,   147,
     148,     0,   149,     0,     0,     0,   150,   151,     0,   152,
       0,   153,     0,     0,     0,   154,     0,     0,     0,     0,
       0,   155,   156,   157,   158,     0,     0,   159,   160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,     0,     0,
       0,   164,     0,     0,     0,     0,   165,     0,   166,     0,
     167,     0,   168,     0,     0,     0,     0,     0,   169,   170,
       0,   171,   172,   173,   174,     0,     0,   175,   176,     0,
     177,     0,   178,     0,   179,   180,   181,   182,     0,     0,
       0,   183,   184,   185,     0,     0,   186,     0,     0,     0,
     187,   188,     0,   189,   190,   191,   192,     0,     0,     0,
       0,     0,     0,     0,     0,   193,   194,   195,     0,     0,
     196,     0,   197,   198,   199,   200,     0,     0,   201,     0,
       0,     0,   202,     0,     0,     0,   203,     0,     0,     0,
     204,     0,   205,     0,     0,   206,   207,   208,   209,   210,
     211,   212,     0,   213,   214,     0,     0,     0,   215,   216,
     217,   218,     0,     0,     0,   219,     0,   220,   221,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,   223,
     224,     0,     0,   225,   226,     0,     0,   227,   228,   229,
       0,     0,   230,   231,   232,     0,   233,   234,     0,     0,
     235,     0,   767,   236,     0,   237,   238,   239,     0,     0,
     240,     0,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,     0,     0,     0,   247,     0,     0,     0,
       0,     0,   248,     0,     0,   249,     0,     0,     0,   250,
     251,     0,     0,     0,    92,   252,    93,    94,    95,   253,
       0,     0,     0,    96,     0,     0,     0,    97,    98,    99,
     100,     0,   101,     0,     0,     0,     0,   102,     0,   103,
     104,     0,   105,     0,   106,     0,     0,   107,     0,     0,
     108,     0,     0,   109,     0,   110,   111,     0,   112,   113,
       0,   114,   115,   116,   117,   118,   119,     0,   120,   121,
       0,   122,     0,     0,     0,     0,     0,   123,     0,     0,
       0,     0,   124,   125,   126,   127,     0,     0,   128,     0,
       0,     0,     0,   129,   130,     0,     0,     0,     0,     0,
       0,     0,     0,   131,   132,     0,     0,     0,     0,   133,
     134,   135,     0,     0,     0,   136,     0,   137,   138,     0,
     139,   140,     0,     0,   141,     0,   142,   143,     0,   144,
       0,     0,     0,   145,   146,   147,   148,     0,   149,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,     0,     0,   155,   156,   157,
     158,     0,     0,   159,   160,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,     0,     0,     0,   164,     0,     0,
       0,     0,   165,     0,   166,     0,   167,     0,   168,     0,
       0,     0,     0,     0,   169,   170,     0,   171,   172,   173,
     174,     0,     0,   175,   176,     0,   177,     0,   178,     0,
     179,   180,   181,   182,     0,     0,     0,   183,   184,   185,
       0,     0,   186,     0,     0,     0,   187,   188,     0,   189,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
       0,   193,   194,   195,     0,     0,   196,  1916,   197,   198,
     199,   200,     0,     0,   201,     0,     0,     0,   202,     0,
       0,     0,   203,     0,     0,     0,   204,     0,   205,     0,
       0,   206,   207,   208,   209,   210,   211,   212,     0,   213,
     214,     0,     0,     0,   215,   216,   217,   218,     0,     0,
       0,   219,     0,   220,   221,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,   223,   224,     0,     0,   225,
     226,     0,     0,   227,   228,   229,     0,     0,   230,   231,
     232,     0,   233,   234,     0,     0,   235,     0,     0,   236,
       0,   237,   238,   239,     0,     0,   240,     0,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,     0,
       0,     0,   247,     0,     0,     0,     0,     0,   248,     0,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
      92,   252,    93,    94,    95,   253,     0,     0,     0,    96,
       0,     0,     0,    97,    98,    99,   100,     0,   101,     0,
       0,     0,     0,   102,     0,   103,   104,     0,   105,     0,
     106,     0,     0,   107,     0,     0,   108,     0,     0,   109,
       0,   110,   111,     0,   112,   113,     0,   114,   115,   116,
     117,   118,   119,     0,   120,   121,     0,   122,     0,     0,
       0,     0,     0,   123,     0,     0,     0,     0,   124,   125,
     126,   127,     0,     0,   128,     0,     0,     0,     0,   129,
     130,     0,     0,     0,     0,     0,     0,     0,     0,   131,
     132,     0,     0,     0,     0,   133,   134,   135,     0,     0,
       0,   136,     0,   137,   138,     0,   139,   140,     0,     0,
     141,     0,   142,   143,     0,   144,     0,     0,     0,   145,
     146,   147,   148,     0,   149,     0,     0,     0,   150,   151,
       0,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,     0,     0,   155,   156,   157,   158,     0,     0,   159,
     160,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
       0,     0,     0,   164,     0,     0,     0,     0,   165,     0,
     166,     0,   167,     0,   168,     0,     0,     0,     0,     0,
     169,   170,     0,   171,   172,   173,   174,     0,     0,   175,
     176,     0,   177,     0,   178,     0,   179,   180,   181,   182,
       0,     0,     0,   183,   184,   185,     0,     0,   186,     0,
       0,     0,   187,   188,     0,   189,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,     0,   193,   194,   195,
       0,     0,   196,     0,   197,   198,   199,   200,     0,     0,
     201,     0,     0,     0,   202,     0,     0,     0,   203,     0,
       0,     0,   204,     0,   205,     0,     0,   206,   207,   208,
     209,   210,   211,   212,     0,   213,   214,     0,     0,     0,
     215,   216,   217,   218,     0,     0,     0,   219,     0,   220,
     221,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,   223,   224,     0,     0,   225,   226,     0,     0,   227,
     228,   229,     0,     0,   230,   231,   232,     0,   233,   234,
       0,     0,   235,     0,     0,   236,     0,   237,   238,   239,
       0,     0,   240,     0,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,     0,     0,     0,   247,     0,
       0,     0,     0,     0,   248,     0,     0,   249,     0,     0,
       0,   250,   251,     0,     0,     0,    92,   252,    93,    94,
      95,   253,     0,     0,     0,    96,     0,     0,     0,    97,
      98,    99,   100,     0,   101,     0,     0,     0,     0,   102,
       0,   103,   104,     0,   105,     0,   106,     0,     0,   107,
       0,     0,   108,     0,     0,   109,     0,   110,   111,     0,
     112,   113,     0,   114,   115,   116,   117,   118,   119,     0,
     120,   121,     0,   122,     0,     0,     0,     0,     0,   123,
       0,     0,     0,     0,   124,   125,   126,   127,     0,     0,
     128,     0,     0,     0,     0,   129,   130,     0,     0,     0,
       0,     0,     0,     0,     0,   131,   132,     0,     0,     0,
       0,   133,   134,   135,     0,     0,     0,   136,     0,   137,
     138,     0,   139,   140,     0,     0,   141,     0,   142,   143,
       0,   144,     0,     0,     0,   145,   146,   147,   148,     0,
     149,     0,     0,     0,   150,   151,     0,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,     0,     0,   155,
     156,   157,   158,     0,     0,   159,   160,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,     0,     0,     0,   164,
       0,     0,     0,     0,   165,     0,   166,     0,   167,     0,
     168,     0,     0,     0,     0,     0,   169,   170,     0,   171,
     172,   173,   174,     0,     0,   175,   176,     0,   177,     0,
     178,     0,   179,   180,   181,   182,     0,     0,     0,   183,
     184,   185,     0,     0,   186,     0,     0,     0,   187,   188,
       0,   189,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,     0,   193,   194,   195,     0,     0,   196,     0,
     197,   198,   199,   200,     0,     0,   201,     0,     0,     0,
     202,     0,     0,     0,   203,     0,     0,     0,   204,     0,
     205,     0,     0,   206,   207,   208,   209,   210,   211,   212,
       0,   213,   214,     0,     0,     0,   215,   216,   217,   218,
       0,     0,     0,   219,     0,   220,   221,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,   223,   224,     0,
       0,   225,   226,     0,     0,   227,   228,   229,     0,     0,
     230,   231,   232,     0,   233,   234,     0,     0,   235,     0,
       0,   236,     0,   237,   238,   239,     0,     0,  1010,     0,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,     0,     0,     0,   247,     0,     0,     0,     0,     0,
     248,     0,     0,   249,     0,     0,     0,   250,   251,     0,
       0,     0,     0,   252,     0,     0,     0,   253
};

static const yytype_int16 yycheck[] =
{
      20,   319,   395,   614,   413,   309,   323,   557,    28,   864,
    1003,  1069,  1039,   489,   490,   546,   511,   811,   996,   950,
    1201,  1033,    90,  1035,  1124,   564,   504,   946,   346,    49,
     546,    49,   571,   583,   429,   634,  1344,   858,  1323,   291,
    1410,    61,  1018,  1019,   362,   440,   440,   364,    12,    12,
      12,  1151,    12,   802,   372,   373,  1450,   822,    85,    71,
    1471,   454,    14,   289,   983,    12,    12,    12,    88,   103,
      90,    26,    12,    71,   378,   379,   622,    51,   620,   109,
    1065,   623,  1514,    89,   626,   627,    12,    52,   114,    12,
       2,    14,     4,   456,    12,   179,  1174,  1214,    98,  1255,
     127,   651,    44,   106,   135,    17,    12,    58,   501,    12,
    1221,    50,   115,   820,   236,    99,   143,    12,  1396,    44,
     181,    40,     7,    36,   152,    12,  1628,    23,    12,    12,
     137,    12,    12,    32,   112,   281,   989,    44,     9,   168,
    1837,   328,   129,    12,    12,   538,    12,   176,   134,    12,
      12,   328,    12,   306,   281,  1625,  1337,  1012,    12,    15,
     112,   387,   189,    12,    12,   152,  1780,    12,    80,  1024,
     304,    12,   134,   112,  1606,    12,   162,   184,    12,   227,
      12,   180,   346,    12,  1218,   155,  1041,    12,   143,   214,
     371,    12,    12,   327,   381,    19,   170,   224,   266,    12,
      74,   171,  1057,   228,   381,   130,    12,  1709,   361,   180,
    1627,   242,  1246,   274,  1911,  1912,   137,   277,   382,  1833,
     129,    12,   229,   130,    95,  1642,  1238,  1048,   226,  1699,
    1700,   134,   235,   231,    90,   381,   264,   236,   306,   634,
     125,   270,   141,   152,    68,  1523,   266,   134,   336,   269,
     236,   269,  1622,  1561,   381,   239,    12,   277,   385,    12,
       9,   383,   293,   184,   284,   236,   286,  1061,   164,  1347,
     290,   575,   325,  1429,   237,   237,  1393,   297,   298,   286,
     811,    12,  1267,   179,   368,  1402,   306,   833,   651,   289,
     237,   237,   237,    12,  1475,   811,  1666,   237,  1005,  1154,
     251,  1412,   848,   222,   846,    12,    12,  1160,    12,   222,
     788,   237,   290,   325,   237,   342,   346,   259,  1688,   237,
    1714,   852,   247,  1381,   327,   131,  1758,   325,   326,   354,
      12,   237,    12,   367,   237,   383,   852,  1192,   406,   365,
     247,   567,   237,    12,   350,    12,    95,   346,    12,    12,
     237,   290,   265,   237,   237,   267,   237,   237,  1769,    12,
     612,   381,   382,  1157,  1391,   286,   353,   341,   237,   237,
     334,   237,    12,   328,   237,   237,   289,   237,   343,    12,
     354,  1146,   334,   237,   330,   405,   406,   405,   237,   237,
      12,    12,   237,  1348,    12,  1006,   237,    12,    12,  1148,
     237,  1356,  1519,   237,   286,   237,   234,   957,   237,   885,
     373,   373,   237,   373,   152,   134,   237,   237,  1239,   895,
    1478,   383,   347,   386,   237,   964,   373,   373,   373,  1823,
    1824,   237,  1826,   373,   454,   455,  1806,   457,   383,   457,
     347,   917,   382,   383,   353,  1839,   237,   373,  1818,   469,
     373,   469,   472,   984,   472,   373,   382,   383,   478,   854,
     854,   481,  1747,  1013,  1440,   383,     0,   373,   984,  1863,
     373,  1865,  1866,  1015,   969,   970,   382,   383,   373,   382,
    1030,   237,    12,   503,   237,   963,   373,   382,   383,   373,
     373,  1799,   373,   373,   972,  1094,   800,    12,   382,   383,
     383,   382,   383,   383,   373,   373,   237,   373,  1058,  1059,
     373,   373,  1612,   373,   383,   383,    12,   383,   237,   373,
     383,   383,    12,   383,   373,   373,   546,    71,   373,   383,
     237,   237,   373,   237,   383,   383,   373,   557,   383,   373,
      12,   373,   383,   109,   373,    88,   383,    12,   373,   383,
    1608,   383,   373,   373,   383,   237,  1021,   237,   383,    12,
     373,   382,   382,   583,   281,    12,   586,   373,   237,   382,
     237,    12,  1183,   237,   237,   595,   382,    71,    12,   647,
    1499,    12,   373,   138,   237,   325,    12,   996,   281,   109,
     610,   382,   610,   613,  1354,   613,   478,   237,     9,   481,
      14,   621,  1595,  1142,   237,   625,    12,   625,    47,  1220,
     222,   155,    12,   168,    12,   237,   237,   373,   189,   237,
     373,   363,   237,   237,    12,   134,   382,   647,  1809,   382,
    1161,   651,   152,   653,   151,   655,   131,   655,  1432,   381,
     357,   358,   373,  1598,   134,  1161,     6,  1602,   260,   425,
      10,   382,    66,   224,   373,   164,  1511,   281,   151,   188,
     341,  1137,  1593,   967,   381,   441,   373,   373,  1199,   373,
    1852,  1221,  1854,   354,   152,   382,   382,   116,   382,  1229,
     223,   236,   226,  1199,    95,    12,  1664,   231,   381,   155,
     330,   373,   187,   373,    12,   109,  1246,  1690,   112,   370,
     382,  1232,   382,  1168,   373,    64,   373,   237,    85,   373,
     373,   121,   383,   382,    85,   382,  1232,   131,   382,   382,
     373,  1332,   237,    82,   138,    23,  1486,  1487,   142,   382,
      44,    14,   226,   373,    20,  1200,    50,   231,  1765,  1766,
     373,   237,    28,   157,   264,   765,    60,   237,   162,   382,
     127,   373,   373,   369,   168,   373,   127,   381,   373,   373,
     382,   382,   176,    49,   382,   237,   180,   382,   382,    96,
    1564,   342,   237,   187,     9,    61,  1355,   306,    96,     9,
     281,  1276,   326,    66,   237,   805,   806,   805,   806,  1801,
     237,   811,  1850,   322,  1289,  1290,   325,   382,    96,   281,
     214,     9,    88,   237,    90,  1336,   237,   289,   387,   829,
    1305,   237,   189,   223,   228,   835,   130,     9,   189,   281,
    1336,  1297,   236,    96,   281,    50,   109,   281,  1032,   112,
    1034,   237,   852,   322,   325,  1039,   325,   237,   858,   237,
    1044,   155,   220,   373,   134,   865,   129,   224,   131,   237,
     347,    88,   382,   224,  1330,   138,   270,   171,   373,   142,
      95,   118,  1412,   377,   101,    95,   164,   382,   382,   152,
     134,   255,   382,   383,   157,   357,   358,   373,   262,   162,
     381,   179,   209,   373,   369,   168,   382,    95,  1743,   126,
     180,   209,  1885,   176,    96,   382,   383,   180,   312,   381,
     284,   373,   377,    95,   187,   130,  1485,   382,   373,  1541,
     382,   209,  1544,   383,  1546,   382,   383,   382,   381,   381,
     373,   381,   220,   381,   381,   381,   373,   381,   338,   382,
     155,   214,   346,   247,    47,   382,   209,   957,   348,   373,
     354,   381,   373,   381,    66,   228,   171,   373,   382,   382,
     383,   382,  1502,   236,   368,   328,   382,   381,   978,   382,
     383,   381,   164,   381,   984,   342,   381,   373,   382,   383,
     387,   342,   386,   373,   381,   373,   382,   382,   383,   381,
     266,    66,   382,   269,   382,   373,  1006,   270,  1008,   382,
     383,   277,   381,  1013,   382,   382,   383,    56,   284,  1530,
     286,   382,   383,    18,   290,  1586,  1587,   209,   382,   383,
    1030,   297,   298,    66,  1530,   382,   383,   382,   383,  1598,
     306,   277,   247,  1602,   382,   383,   382,   383,  1048,   312,
    1641,   121,    47,   347,  1054,   157,    51,   381,  1058,  1059,
    1060,  1061,  1060,   382,   383,  1065,   168,   382,   383,   376,
     377,   378,   379,   380,   176,   539,   540,  1450,   376,   377,
     378,   379,   380,   346,   299,   300,   301,   302,   381,  1373,
     353,   354,   157,    88,   382,   383,    83,   312,   376,   377,
     378,   379,   380,   168,   381,   368,   382,   383,   382,   383,
    1640,   176,   214,   382,   383,   381,   382,    25,   346,   382,
     383,  1680,  1681,   386,   157,   378,   379,   380,   123,   378,
     382,   383,   382,   383,    42,   168,  1208,  1704,  1705,   405,
     406,   381,  1214,   176,   180,  1217,   133,  1219,   381,   214,
     220,  1361,  1362,   223,  1226,  1227,   381,   381,   381,  1231,
     147,  1161,   381,   228,   306,   381,  1166,    75,   270,   381,
      78,    66,  1668,  1173,   381,  1173,   171,   381,    86,   381,
     381,   214,   381,  1183,   381,   381,   381,   381,   454,   455,
     381,   457,   381,   322,   376,   377,   378,   379,   380,  1199,
     381,   381,   381,   469,   381,   270,   472,   381,  1208,  1800,
     312,   381,   478,   200,  1214,   481,   203,  1217,   381,  1219,
     381,  1221,   381,   210,   381,   220,  1226,  1227,   223,  1229,
     381,  1231,  1232,   228,   381,   381,  1236,   270,  1236,  1239,
    1240,  1241,   381,   381,    26,   381,  1246,   312,   381,   381,
      59,   382,   247,    88,    40,  1255,  1256,   383,  1256,    26,
     260,   118,   157,   250,   155,   228,   255,  1267,   338,   112,
     113,   367,  1272,   168,  1272,  1664,   382,   382,   348,   312,
     546,   176,    95,     9,   386,   382,   387,   382,   156,   381,
     285,   557,   279,   136,   383,   383,    78,   140,   383,   334,
     378,   328,   294,    85,   289,    47,   187,   382,   382,   378,
     382,    78,  1808,   134,   382,   377,   382,   583,    85,   214,
     586,  1393,   165,   382,  1324,   382,   382,   382,   382,   595,
    1402,   174,  1332,   228,   383,   383,  1336,   603,   382,   121,
     382,  1714,   346,   290,   610,   127,    12,   613,   382,   192,
     381,   381,   347,   381,   121,   621,   328,   381,   387,   625,
     127,   143,   387,   382,    33,   388,   383,   368,   228,   382,
    1370,   107,   215,   382,   161,   270,   143,   161,  1378,   366,
     382,   647,   387,   382,   382,   651,   382,   653,   375,   655,
     387,    12,   382,  1393,   387,   383,   382,   162,  1928,   383,
     382,   134,  1402,  1914,   166,  1702,  1703,   189,   383,    50,
     334,   169,  1412,   323,   169,    33,  1416,   312,  1914,  1419,
    1718,  1419,   189,  1423,   323,    47,   383,   228,  1939,  1429,
    1430,   236,   493,   100,    10,    11,  1932,   381,   381,   221,
     382,   223,   224,  1939,   382,   382,    22,  1519,   383,   281,
    1823,  1824,   513,  1826,   387,   516,   223,   224,    79,    80,
      81,    82,    83,   382,   382,   350,  1839,   383,    44,   530,
     531,   383,   164,   534,   387,   177,   171,    53,   171,   382,
     387,    14,   180,   224,   224,   382,   547,   548,   283,    65,
    1863,   162,  1865,  1866,   382,   168,  1496,  1795,   168,   765,
     383,   238,  1502,   138,   388,   383,   291,   171,   171,   383,
     382,   381,   171,    89,    90,    91,   382,   382,   382,  1519,
     382,   168,    98,   144,   145,   146,   147,  1527,   168,   228,
    1530,    33,   142,   109,   383,   255,   381,    88,   206,   805,
     806,    88,   381,   381,   245,   811,   328,   381,   381,   331,
      24,   387,   128,   350,    28,   325,   338,   168,    49,   224,
     342,   328,   168,   829,   331,   381,  1566,   381,    42,   835,
     193,   338,   224,   381,   350,   342,    88,   171,   171,   200,
     201,   202,   203,   382,   160,   223,   852,   224,   522,   210,
     224,   224,   858,   381,   376,   377,   172,   354,   354,   865,
     381,    75,   382,   664,    78,   382,   181,   183,   228,   376,
     377,   358,    86,   221,   382,   224,   237,   383,   382,   354,
     383,    33,   354,    97,    33,  1625,   106,    33,   382,   250,
     381,  1631,   381,   131,    33,    33,    33,   111,   572,   573,
    1640,     4,   576,   577,   578,   579,   580,   581,   228,   228,
      33,   152,   126,    33,   259,   716,   381,   278,   279,   720,
    1660,   350,   381,    89,   224,   381,   383,   382,  1668,  1058,
     289,  1562,  1048,  1673,   651,  1673,   737,  1240,  1430,  1054,
    1212,    49,  1031,  1243,   260,   261,  1527,  1558,   264,   163,
    1529,   957,  1640,  1650,  1082,   271,    64,    65,  1832,  1699,
    1700,   277,  1803,  1066,    72,   281,  1270,  1738,  1239,   453,
     997,   805,   978,   289,   272,   271,   292,   948,   984,   422,
     819,  1332,  1148,  1358,   884,   947,  1596,  1820,  1935,   305,
    1768,  1910,   493,   540,   973,  1594,  1530,  1513,  1738,   306,
    1006,  1615,  1008,  1002,   299,   366,   114,  1013,   406,  1336,
     661,   225,   373,   374,   375,  1156,  1756,   810,  1199,  1932,
     295,  1808,   480,   339,  1030,  1810,  1150,  1849,    85,   137,
    1774,  1830,   603,   349,   350,  1939,  1642,   353,  1161,   503,
      91,   824,  1048,   257,  1191,  1785,   154,   155,  1054,  1378,
    1620,    -1,  1058,  1059,  1060,  1061,   412,    -1,    -1,  1065,
      -1,   169,    -1,    -1,    -1,   381,    -1,    -1,  1808,    -1,
      -1,   285,    -1,    -1,    -1,    -1,   184,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1852,    -1,  1854,   329,  1856,   331,    -1,    -1,
      -1,    -1,    -1,    -1,   798,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   249,    -1,    -1,    -1,   359,   360,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1161,    -1,    -1,    -1,    -1,
    1166,    -1,    -1,    -1,    -1,    -1,    -1,  1173,    -1,  1909,
    1910,    -1,    -1,    -1,  1914,    -1,    -1,  1183,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1928,    -1,
      -1,    -1,  1932,  1199,    -1,  1935,    -1,    -1,    -1,  1939,
      -1,    -1,  1208,    -1,    -1,    -1,    -1,    -1,  1214,    -1,
      -1,  1217,    -1,  1219,   322,  1221,    -1,   325,   326,    -1,
    1226,  1227,    -1,  1229,    -1,  1231,  1232,    -1,    -1,    -1,
    1236,    -1,    -1,  1239,  1240,  1241,    -1,    -1,    -1,    -1,
    1246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1255,
    1256,    -1,    -1,    -1,   311,    -1,    -1,   365,    -1,    -1,
      -1,  1267,    -1,    -1,    -1,    -1,  1272,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1324,    -1,
      -1,    -1,    -1,   380,    -1,    -1,  1332,    -1,    -1,    -1,
    1336,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1402,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1412,    -1,    -1,    -1,
    1416,    -1,    -1,  1419,    -1,    -1,    -1,  1423,    -1,    -1,
      -1,    -1,    -1,  1429,  1430,    -1,   483,    -1,    -1,    -1,
      -1,   488,    -1,    -1,   491,   492,    -1,    -1,    -1,    -1,
      -1,   498,   499,   500,    -1,   502,    -1,    -1,    -1,    -1,
     507,   508,   509,   510,    -1,   512,    -1,   514,   515,    -1,
     517,   518,    -1,   520,    -1,    -1,   523,   524,   525,   526,
     527,   528,   529,    -1,    -1,   532,   533,    -1,   535,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
    1496,    -1,   549,    -1,    -1,    -1,  1502,    -1,   555,    -1,
      -1,    -1,    -1,   560,   561,   562,    -1,    -1,    79,    80,
      81,    82,    83,  1519,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1527,    -1,    -1,  1530,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   603,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   615,    -1,
    1566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     667,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1625,
      -1,    -1,    -1,    -1,    -1,  1631,    -1,    -1,    -1,   200,
     201,   202,   203,    -1,  1640,    -1,    -1,    -1,    -1,   210,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1660,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1668,    -1,    -1,    -1,    -1,  1673,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   745,   746,
     747,    -1,    -1,  1699,  1700,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,   279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   788,  1738,    -1,   791,    -1,   793,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1756,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1785,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,
      -1,    -1,  1808,   374,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   871,    -1,    -1,   874,    -1,   876,
     877,    -1,    -1,    -1,   881,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   894,    -1,    -1,
     897,   898,   899,   900,   901,    -1,  1852,    -1,  1854,    -1,
    1856,   908,    -1,    -1,   911,    -1,   913,   914,    -1,   916,
      -1,    -1,    -1,    -1,   921,   922,   923,    -1,    -1,    -1,
      -1,   928,   929,   930,    -1,   932,    -1,   934,    -1,   936,
      -1,   938,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   958,    -1,  1909,  1910,    -1,    -1,    -1,  1914,    -1,
      -1,    -1,    -1,    -1,    -1,   972,    -1,   974,    -1,    -1,
      -1,    -1,  1928,    -1,    -1,    -1,  1932,    -1,    -1,  1935,
      -1,    -1,    -1,  1939,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1073,    -1,    -1,    -1,
    1077,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1091,  1092,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1116,
      -1,  1118,    -1,  1120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1190,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1201,  1202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1273,    -1,    -1,    -1,
      -1,    -1,  1279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1294,  1295,    -1,
      -1,    -1,    -1,    -1,    -1,  1302,    -1,    -1,    -1,    -1,
    1307,    -1,    -1,  1310,  1311,  1312,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1475,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1606,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1620,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1684,  1685,    -1,
      -1,    -1,  1689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     4,    -1,     6,     7,     8,    -1,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    34,    -1,    -1,    37,    38,    39,
      40,  1758,    42,    43,    -1,    45,    46,    -1,    48,    49,
      -1,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,    69,
      -1,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    -1,    -1,    83,    84,    85,    -1,    -1,    88,    -1,
      -1,    -1,  1809,    93,    94,  1812,    -1,  1814,    -1,    99,
     100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,    -1,   114,    -1,   116,   117,   118,   119,
     120,   121,    -1,   123,   124,   125,   126,   127,   128,    -1,
      -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,   139,
      -1,   141,    -1,   143,    -1,    -1,    -1,   147,   148,   149,
     150,   151,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     170,    -1,    -1,   173,    -1,   175,   176,   177,    -1,    -1,
      -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,   189,
      -1,    -1,    -1,    -1,   194,   195,   196,   197,   198,   199,
     200,    -1,    -1,   203,   204,   205,   206,    -1,   208,   209,
     210,   211,   212,   213,    -1,    -1,    -1,   217,   218,   219,
     220,   221,   222,   223,   224,    -1,   226,   227,    -1,   229,
     230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,   244,    -1,   246,    -1,   248,   249,
     250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
      -1,    -1,   262,   263,   264,    -1,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,
      -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
     300,    -1,    -1,    -1,    -1,   305,   306,   307,   308,   309,
     310,    -1,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,    -1,   328,   329,
      -1,   331,   332,   333,    -1,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,    -1,   355,   356,   357,   358,    -1,
      -1,   361,   362,    -1,   364,   365,   366,    -1,    -1,    -1,
      -1,   371,    -1,    -1,    -1,   375,   376,   377,    -1,    -1,
      -1,   381,    -1,    -1,    -1,   385,    -1,   387,   388,     4,
      -1,     6,     7,     8,     9,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    -1,    29,    30,    -1,    32,    -1,    34,
      -1,    -1,    37,    38,    39,    40,    -1,    42,    43,    -1,
      45,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    -1,    61,    -1,    63,    64,
      -1,    -1,    67,    68,    69,    -1,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    83,    84,
      85,    -1,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,
      -1,   116,   117,   118,   119,   120,   121,    -1,   123,   124,
     125,   126,   127,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,
      -1,    -1,   147,   148,   149,   150,   151,    -1,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,
      -1,   176,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,
      -1,   186,    -1,   188,   189,    -1,    -1,    -1,    -1,   194,
     195,   196,   197,   198,   199,   200,    -1,    -1,   203,   204,
     205,   206,    -1,   208,   209,   210,   211,   212,   213,    -1,
      -1,    -1,   217,   218,   219,   220,   221,   222,   223,   224,
      -1,   226,   227,   228,   229,   230,   231,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,   244,
      -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,    -1,    -1,   262,   263,   264,
      -1,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,
     285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,
     305,   306,   307,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,    -1,   328,   329,    -1,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,   340,   341,   342,   343,   344,
      -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,
     355,   356,   357,   358,    -1,    -1,   361,   362,    -1,   364,
     365,   366,    -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,
     375,   376,   377,    -1,    -1,     4,   381,     6,     7,     8,
     385,    -1,   387,   388,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    38,
      39,    40,    -1,    42,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,
      69,    -1,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,    -1,    -1,    -1,    83,    84,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,   118,
     119,   120,   121,    -1,   123,   124,   125,   126,   127,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
     139,    -1,   141,    -1,   143,    -1,    -1,    -1,   147,   148,
     149,   150,   151,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,   176,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
     189,    -1,    -1,    -1,    -1,   194,   195,   196,   197,   198,
     199,   200,    -1,    -1,   203,   204,   205,   206,    -1,   208,
     209,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,   220,   221,   222,   223,   224,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,   244,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,   263,   264,    -1,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,   307,   308,
     309,   310,    -1,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,    -1,   328,
     329,    -1,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,   340,   341,   342,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,   355,   356,   357,   358,
      -1,    -1,   361,   362,    -1,   364,   365,   366,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,   375,   376,   377,    -1,
      -1,    -1,   381,   382,    -1,    -1,   385,    -1,   387,   388,
       4,    -1,     6,     7,     8,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    25,    26,    27,    -1,    29,    30,    -1,    32,    -1,
      34,    -1,    -1,    37,    38,    39,    40,    -1,    42,    43,
      -1,    45,    46,    -1,    48,    49,    -1,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    -1,    61,    -1,    63,
      64,    -1,    -1,    67,    68,    69,    -1,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,    83,
      84,    85,    -1,    -1,    88,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,
      -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,
     114,    -1,   116,   117,   118,   119,   120,   121,    -1,   123,
     124,   125,   126,   127,   128,    -1,    -1,    -1,   132,   133,
     134,   135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,
      -1,    -1,    -1,   147,   148,   149,   150,   151,    -1,   153,
     154,    -1,    -1,    -1,    -1,    -1,   160,   161,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,
      -1,    -1,   176,   177,    -1,    -1,    -1,    -1,   182,    -1,
     184,    -1,   186,    -1,   188,   189,    -1,    -1,    -1,    -1,
     194,   195,   196,   197,   198,   199,   200,    -1,    -1,   203,
     204,   205,   206,    -1,   208,   209,   210,   211,   212,   213,
      -1,    -1,    -1,   217,   218,   219,   220,   221,   222,   223,
     224,    -1,   226,   227,    -1,   229,   230,   231,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
     244,    -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,
     254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,   263,
     264,    -1,   266,    -1,   268,    -1,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,
     284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,
     294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,
      -1,   305,   306,   307,   308,   309,   310,    -1,    -1,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,    -1,   328,   329,    -1,   331,   332,   333,
      -1,    -1,   336,   337,   338,   339,   340,   341,   342,   343,
     344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,
      -1,   355,   356,   357,   358,    -1,    -1,   361,   362,    -1,
     364,   365,   366,    -1,    -1,    -1,    -1,   371,    -1,    -1,
      -1,   375,   376,   377,    -1,    -1,     4,   381,     6,     7,
       8,   385,    -1,   387,   388,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    25,    26,    27,
      -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,
      38,    39,    40,    -1,    42,    43,    -1,    45,    46,    -1,
      48,    49,    -1,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,    67,
      68,    69,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    -1,    -1,    -1,    -1,    83,    84,    85,    -1,    -1,
      88,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,
      -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,
     108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,
     118,   119,   120,   121,    -1,   123,   124,   125,   126,   127,
     128,    -1,    -1,    -1,   132,   133,   134,   135,    -1,   137,
      -1,   139,    -1,   141,    -1,   143,    -1,    -1,    -1,   147,
     148,   149,   150,   151,    -1,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,   161,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,   170,    -1,    -1,   173,    -1,    -1,   176,   177,
      -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,
     188,   189,    -1,    -1,    -1,    -1,   194,   195,   196,   197,
     198,   199,   200,    -1,    -1,   203,   204,   205,   206,    -1,
     208,   209,   210,   211,   212,   213,    -1,    -1,    -1,   217,
     218,   219,   220,   221,   222,   223,   224,    -1,   226,   227,
      -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,   244,    -1,   246,    -1,
     248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,
     258,    -1,    -1,    -1,   262,   263,   264,    -1,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,   287,
      -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,   307,
     308,   309,   310,    -1,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,    -1,
     328,   329,    -1,   331,   332,   333,    -1,    -1,   336,   337,
     338,   339,   340,   341,   342,   343,   344,    -1,    -1,    -1,
     348,    -1,    -1,    -1,   352,    -1,    -1,   355,   356,   357,
     358,    -1,    -1,   361,   362,    -1,   364,   365,   366,    -1,
      -1,    -1,    -1,   371,    -1,    -1,    -1,   375,   376,   377,
      -1,    -1,     4,   381,     6,     7,     8,   385,    -1,   387,
     388,    13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    25,    26,    27,    -1,    29,    30,    -1,
      32,    -1,    34,    -1,    -1,    37,    38,    39,    40,    -1,
      42,    43,    -1,    45,    46,    -1,    48,    49,    -1,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    -1,    61,
      -1,    63,    64,    -1,    -1,    67,    68,    69,    -1,    71,
      72,    73,    74,    75,    76,    77,    78,    -1,    -1,    -1,
      -1,    83,    84,    85,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,
      -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,
      -1,    -1,   114,    -1,   116,   117,   118,   119,   120,   121,
      -1,   123,   124,   125,   126,   127,   128,    -1,    -1,    -1,
     132,   133,   134,   135,    -1,   137,    -1,   139,    -1,   141,
      -1,   143,    -1,    -1,    -1,   147,   148,   149,   150,   151,
      -1,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,
      -1,   173,    -1,    -1,   176,   177,    -1,    -1,    -1,    -1,
     182,    -1,   184,    -1,   186,    -1,   188,   189,    -1,    -1,
      -1,    -1,   194,   195,   196,   197,   198,   199,   200,    -1,
      -1,   203,   204,   205,   206,    -1,   208,   209,   210,   211,
     212,   213,    -1,    -1,    -1,   217,   218,   219,   220,   221,
     222,   223,   224,    -1,   226,   227,    -1,   229,   230,   231,
     232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,   244,    -1,   246,    -1,   248,   249,   250,   251,
      -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,
     262,   263,   264,    -1,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
      -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,
      -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,    -1,   305,   306,   307,   308,   309,   310,    -1,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,
     332,   333,    -1,    -1,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,
     352,    -1,    -1,   355,   356,   357,   358,    -1,    -1,   361,
     362,    -1,   364,   365,   366,    -1,    -1,    -1,    -1,   371,
      -1,    -1,    -1,   375,   376,   377,    -1,    -1,     4,   381,
       6,     7,     8,   385,    -1,   387,   388,    13,    -1,    -1,
      -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,    25,
      26,    27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,
      -1,    37,    38,    39,    40,    -1,    42,    43,    -1,    45,
      46,    -1,    48,    49,    -1,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    67,    68,    69,    -1,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    -1,    -1,    -1,    83,    84,    85,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,
      -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,
     116,   117,   118,   119,   120,   121,    -1,   123,   124,   125,
     126,   127,   128,    -1,    -1,    -1,   132,   133,    -1,   135,
      -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,    -1,
      -1,   147,   148,   149,   150,   151,    -1,   153,   154,    -1,
      -1,    -1,    -1,    -1,   160,   161,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,
     176,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,
     186,    -1,   188,   189,    -1,    -1,    -1,    -1,   194,   195,
     196,   197,   198,   199,   200,    -1,    -1,   203,   204,   205,
     206,    -1,   208,   209,   210,   211,   212,   213,    -1,    -1,
      -1,   217,   218,   219,   220,   221,   222,   223,   224,    -1,
     226,   227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,   244,    -1,
     246,    -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,
      -1,    -1,   258,    -1,    -1,    -1,   262,   263,   264,    -1,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,
     286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,
      -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,
     306,   307,   308,   309,   310,    -1,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,    -1,   328,   329,    -1,   331,   332,   333,    -1,    -1,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
      -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,   355,
     356,   357,   358,    -1,    -1,   361,   362,    -1,   364,   365,
     366,    -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,   375,
     376,   377,    -1,    -1,     4,   381,     6,     7,     8,   385,
      -1,   387,   388,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,
      30,    -1,    32,    -1,    34,    -1,    -1,    37,    38,    39,
      40,    -1,    42,    43,    -1,    45,    46,    -1,    48,    49,
      -1,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,    69,
      -1,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      -1,    -1,    -1,    83,    84,    85,    -1,    -1,    88,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,
     100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,    -1,   114,    -1,   116,   117,   118,   119,
     120,   121,    -1,   123,   124,   125,   126,   127,   128,    -1,
      -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,   139,
      -1,   141,    -1,   143,    -1,    -1,    -1,   147,   148,   149,
     150,   151,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,   161,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     170,    -1,    -1,   173,    -1,    -1,   176,   177,    -1,    -1,
      -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,   189,
      -1,    -1,    -1,    -1,   194,   195,   196,   197,   198,   199,
     200,    -1,    -1,   203,   204,   205,   206,    -1,   208,   209,
     210,   211,   212,   213,    -1,    -1,    -1,   217,   218,   219,
     220,   221,   222,   223,   224,    -1,   226,   227,    -1,   229,
     230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,   244,    -1,   246,    -1,   248,   249,
     250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
      -1,    -1,   262,   263,   264,    -1,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,
      -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
     300,    -1,    -1,    -1,    -1,   305,   306,   307,   308,   309,
     310,    -1,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,    -1,   328,   329,
      -1,   331,   332,   333,    -1,    -1,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,    -1,   355,   356,   357,   358,    -1,
      -1,   361,   362,    -1,   364,   365,   366,    -1,    -1,    -1,
      -1,   371,    -1,    -1,    -1,   375,   376,   377,    -1,    -1,
      -1,   381,    -1,    -1,    -1,   385,    -1,   387,   388,     4,
      -1,     6,     7,     8,     9,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    -1,    29,    30,    -1,    32,    -1,    34,
      -1,    -1,    37,    38,    39,    40,    -1,    42,    43,    -1,
      45,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    -1,    61,    -1,    63,    64,
      -1,    -1,    67,    68,    69,    -1,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    83,    84,
      85,    -1,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,
      -1,   116,   117,   118,   119,   120,   121,    -1,   123,   124,
     125,   126,   127,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,
      -1,    -1,   147,   148,   149,   150,   151,    -1,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,
      -1,   176,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,
      -1,   186,    -1,   188,   189,    -1,    -1,    -1,    -1,   194,
     195,   196,   197,   198,   199,   200,    -1,    -1,   203,   204,
     205,   206,    -1,   208,   209,   210,   211,   212,   213,    -1,
      -1,    -1,   217,   218,   219,    -1,   221,   222,   223,   224,
      -1,   226,   227,    -1,   229,   230,   231,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,   244,
      -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,    -1,    -1,   262,   263,   264,
      -1,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,
     285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,
     305,   306,   307,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,    -1,   328,   329,    -1,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,   340,   341,   342,   343,   344,
      -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,
     355,   356,   357,   358,    -1,    -1,   361,   362,    -1,   364,
     365,   366,    -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,
     375,   376,   377,    -1,    -1,     4,   381,     6,     7,     8,
     385,    -1,   387,   388,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    38,
      39,    40,    -1,    42,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,
      69,    -1,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,    -1,    -1,    -1,    83,    84,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,   118,
     119,   120,   121,    -1,   123,   124,   125,   126,   127,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
     139,    -1,   141,    -1,   143,    -1,    -1,    -1,   147,   148,
     149,   150,   151,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,   176,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
     189,    -1,    -1,    -1,    -1,   194,   195,   196,   197,   198,
     199,   200,    -1,    -1,   203,   204,   205,   206,    -1,   208,
     209,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,   220,   221,   222,   223,   224,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,   244,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,   263,   264,    -1,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,   307,   308,
     309,   310,    -1,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,    -1,   328,
     329,    -1,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,   340,   341,   342,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,   355,   356,   357,   358,
      -1,    -1,   361,   362,    -1,   364,   365,   366,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,   375,   376,   377,    -1,
      -1,     4,   381,     6,     7,     8,   385,    -1,   387,   388,
      13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    25,    26,    27,    -1,    29,    30,    -1,    32,
      -1,    34,    -1,    -1,    37,    38,    39,    40,    -1,    42,
      43,    -1,    45,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    -1,    61,    -1,
      63,    64,    -1,    -1,    67,    68,    69,    -1,    71,    72,
      73,    74,    75,    76,    77,    78,    -1,    -1,    -1,    -1,
      83,    84,    85,    -1,    -1,    88,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,
      -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,
      -1,   114,    -1,   116,   117,   118,   119,   120,   121,    -1,
     123,   124,   125,   126,   127,   128,    -1,    -1,    -1,   132,
     133,    -1,   135,    -1,   137,    -1,   139,    -1,   141,    -1,
     143,    -1,    -1,    -1,   147,   148,   149,   150,   151,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,   160,   161,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,
     173,    -1,    -1,   176,   177,    -1,    -1,    -1,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,   189,    -1,    -1,    -1,
      -1,   194,   195,   196,   197,   198,   199,   200,    -1,    -1,
     203,   204,   205,   206,    -1,   208,   209,   210,   211,   212,
     213,    -1,    -1,    -1,   217,   218,   219,   220,   221,   222,
     223,   224,    -1,   226,   227,    -1,   229,   230,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,   244,    -1,   246,    -1,   248,   249,   250,   251,    -1,
      -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
     263,   264,    -1,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,    -1,    -1,
      -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,
     293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,
      -1,    -1,   305,   306,   307,   308,   309,   310,    -1,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,   332,
     333,    -1,    -1,   336,   337,   338,   339,   340,   341,   342,
     343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,
      -1,    -1,   355,   356,   357,   358,    -1,    -1,   361,   362,
      -1,   364,   365,   366,    -1,    -1,    -1,    -1,   371,    -1,
      -1,    -1,   375,   376,   377,    -1,    -1,     4,   381,     6,
       7,     8,   385,    -1,   387,   388,    13,    -1,    -1,    -1,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    25,    26,
      27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,
      37,    38,    39,    40,    -1,    42,    43,    -1,    45,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,
      67,    68,    69,    -1,    71,    72,    73,    74,    75,    76,
      77,    78,    -1,    -1,    -1,    -1,    83,    84,    85,    -1,
      -1,    88,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,
     117,   118,   119,   120,   121,    -1,   123,   124,   125,   126,
     127,   128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,
     137,    -1,   139,    -1,   141,    -1,   143,    -1,    -1,    -1,
     147,   148,   149,   150,   151,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,   160,   161,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,   176,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,
      -1,   188,   189,    -1,    -1,    -1,    -1,   194,   195,   196,
     197,   198,   199,   200,    -1,    -1,   203,   204,   205,   206,
      -1,   208,   209,   210,   211,   212,   213,    -1,    -1,    -1,
     217,   218,   219,   220,   221,   222,   223,   224,    -1,   226,
     227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,   244,    -1,   246,
      -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,   263,   264,    -1,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,
     287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,
     307,   308,   309,   310,    -1,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
      -1,   328,   329,    -1,   331,   332,   333,    -1,    -1,   336,
     337,   338,   339,   340,   341,   342,   343,   344,    -1,    -1,
      -1,   348,    -1,    -1,    -1,   352,    -1,    -1,   355,   356,
     357,   358,    -1,    -1,   361,   362,    -1,   364,   365,   366,
      -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,   375,   376,
     377,    -1,    -1,     4,   381,     6,     7,     8,   385,    -1,
     387,   388,    13,    -1,    -1,    -1,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    25,    26,    27,    -1,    29,    30,
      -1,    32,    -1,    34,    -1,    -1,    37,    38,    39,    40,
      -1,    42,    43,    -1,    45,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    -1,
      61,    -1,    63,    64,    -1,    -1,    67,    68,    69,    -1,
      71,    72,    73,    74,    75,    76,    77,    78,    -1,    -1,
      -1,    -1,    83,    84,    85,    -1,    -1,    88,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,
     101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,
     111,    -1,    -1,   114,    -1,   116,   117,   118,   119,   120,
     121,    -1,   123,   124,   125,   126,   127,   128,    -1,    -1,
      -1,   132,   133,    -1,   135,    -1,   137,    -1,   139,    -1,
     141,    -1,   143,    -1,    -1,    -1,   147,   148,   149,   150,
     151,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,   160,
     161,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,
      -1,    -1,   173,    -1,    -1,   176,   177,    -1,    -1,    -1,
      -1,   182,    -1,   184,    -1,   186,    -1,   188,   189,    -1,
      -1,    -1,    -1,   194,   195,   196,   197,   198,   199,   200,
      -1,    -1,   203,   204,   205,   206,    -1,   208,   209,   210,
     211,   212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,
     221,   222,   223,   224,    -1,   226,   227,    -1,   229,   230,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,   244,    -1,   246,    -1,   248,   249,   250,
     251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,
      -1,   262,   263,   264,    -1,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,
     291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,
      -1,    -1,    -1,    -1,   305,   306,   307,   308,   309,   310,
      -1,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,
     331,   332,   333,    -1,    -1,   336,   337,   338,   339,   340,
     341,   342,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,    -1,   355,   356,   357,   358,    -1,    -1,
     361,   362,    -1,   364,   365,   366,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,   375,   376,   377,    -1,    -1,     4,
     381,     6,     7,     8,   385,    -1,   387,   388,    13,    -1,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      25,    26,    27,    -1,    29,    30,    -1,    32,    -1,    34,
      -1,    -1,    37,    38,    39,    40,    -1,    42,    43,    -1,
      45,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    -1,    61,    -1,    63,    64,
      -1,    -1,    67,    68,    69,    -1,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    83,    84,
      85,    -1,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,
      -1,   116,   117,   118,   119,   120,   121,    -1,   123,   124,
     125,   126,   127,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,   137,    -1,   139,    -1,   141,    -1,   143,    -1,
      -1,    -1,   147,   148,   149,   150,   151,    -1,   153,   154,
      -1,    -1,    -1,    -1,    -1,   160,   161,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,
      -1,   176,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,
      -1,   186,    -1,   188,   189,    -1,    -1,    -1,    -1,   194,
     195,   196,   197,   198,   199,   200,    -1,    -1,   203,   204,
     205,   206,    -1,   208,   209,   210,   211,   212,   213,    -1,
      -1,    -1,   217,   218,   219,    -1,   221,   222,   223,   224,
      -1,   226,   227,    -1,   229,   230,   231,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,   244,
      -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,    -1,    -1,   262,   263,   264,
      -1,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,
     285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,
     305,   306,   307,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,    -1,   328,   329,    -1,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,   340,   341,   342,   343,   344,
      -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,
     355,   356,   357,   358,    -1,    -1,   361,   362,    -1,   364,
     365,   366,    -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,
     375,   376,   377,    -1,    -1,     4,   381,     6,     7,     8,
     385,    -1,   387,   388,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    25,    26,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    38,
      39,    40,    -1,    42,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,
      69,    -1,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,    -1,    -1,    -1,    83,    84,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,   118,
     119,   120,   121,    -1,   123,   124,   125,   126,   127,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
     139,    -1,   141,    -1,   143,    -1,    -1,    -1,   147,   148,
     149,   150,   151,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,   160,   161,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,   176,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
     189,    -1,    -1,    -1,    -1,   194,   195,   196,   197,   198,
     199,   200,    -1,    -1,   203,   204,   205,   206,    -1,   208,
     209,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,    -1,   221,   222,   223,   224,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,   244,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,   263,   264,    -1,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,   307,   308,
     309,   310,    -1,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,    -1,   328,
     329,    -1,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,   340,   341,   342,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,   355,   356,   357,   358,
      -1,    -1,   361,   362,    -1,   364,   365,   366,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,   375,   376,   377,    -1,
      -1,     4,   381,     6,     7,     8,   385,    -1,   387,   388,
      13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,
      -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,
      43,    -1,    45,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,
      -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,
      -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,
     123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,
     133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,
     173,    -1,    -1,    -1,   177,   178,    -1,    -1,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,
      -1,   194,   195,    -1,   197,   198,   199,   200,    -1,    -1,
     203,   204,    -1,   206,    -1,   208,    -1,   210,   211,   212,
     213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,
      -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,
      -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,    -1,    -1,
      -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,
     293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,
      -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,    -1,    -1,   318,   319,   320,    -1,   322,
     323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,   332,
     333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,
     343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,
      -1,    -1,   365,   366,    -1,    -1,    -1,    -1,   371,    -1,
      -1,    -1,   375,     4,    -1,     6,     7,     8,    -1,    -1,
      -1,    -1,    13,    -1,    -1,   388,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,
      -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,
      -1,    -1,    43,    -1,    45,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,
     101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,
     111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,
      -1,    -1,   123,   124,   125,   126,    -1,   128,    -1,    -1,
      -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
      -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,
      -1,    -1,   173,    -1,    -1,    -1,   177,   178,    -1,    -1,
      -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,
      -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,   200,
      -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,
     211,   212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,
      -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,    -1,   248,   249,   250,
     251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,
      -1,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,
     291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,
      -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,
      -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,   320,
      -1,   322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,
     331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,
     341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,
     361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,   375,     4,    -1,     6,     7,     8,
      -1,    -1,    -1,    -1,    13,    -1,    -1,   388,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,
      -1,    40,    -1,    -1,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,
     119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
      -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,
     199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,
      -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,
      -1,    -1,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,
     309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,
     319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,
     339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,   375,     4,    -1,     6,
       7,     8,    -1,   382,    -1,    -1,    13,    -1,   387,   388,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,
      37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,
     117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,
      -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,
      -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,
     197,   198,   199,   200,    -1,    -1,   203,   204,    -1,   206,
      -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,
     217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,
     227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
      -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,
      -1,   268,    -1,    -1,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,
     287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,
      -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,   332,   333,    -1,    -1,   336,
      -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,
      -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,   375,     4,
      -1,     6,     7,     8,    -1,    -1,    -1,    -1,    13,    -1,
     387,   388,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      -1,    -1,    27,    -1,    29,    30,    -1,    32,    -1,    34,
      -1,    -1,    37,    -1,    -1,    40,    -1,    -1,    43,    -1,
      45,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,
      -1,   116,   117,    -1,   119,    -1,    -1,    -1,   123,   124,
     125,   126,    -1,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,    -1,    -1,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   170,   171,    -1,   173,    -1,
      -1,    -1,   177,    -1,   179,    -1,    -1,   182,    -1,   184,
      -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,   194,
     195,    -1,   197,   198,   199,   200,    -1,    -1,   203,   204,
      -1,   206,    -1,   208,    -1,   210,   211,   212,   213,    -1,
      -1,    -1,   217,   218,   219,    -1,    -1,   222,    -1,    -1,
      -1,   226,   227,    -1,   229,   230,   231,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,    -1,
      -1,   266,    -1,   268,    -1,    -1,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,   281,    -1,    -1,   284,
     285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,
     305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,
     315,    -1,    -1,   318,   319,   320,    -1,   322,   323,    -1,
      -1,   326,    -1,    -1,   329,    -1,   331,   332,   333,    -1,
      -1,   336,    -1,    -1,   339,   340,   341,    -1,   343,   344,
      -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,
      -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,
     365,   366,    -1,    -1,    -1,     4,   371,     6,     7,     8,
     375,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,
      19,    20,   387,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,
      -1,    40,    -1,    -1,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,
     119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
      -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,   171,    -1,   173,    -1,    -1,    -1,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,
     199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,
      -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,
      -1,    -1,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,
     309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,
     319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,
     339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,     4,   371,     6,     7,     8,   375,    -1,    -1,    -1,
      13,    -1,    -1,    -1,    17,    18,    19,    20,   387,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,
      -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,
      43,    -1,    45,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,
      -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,
      -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,
     123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,
     133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,
     173,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,
      -1,   194,   195,    -1,   197,   198,   199,   200,    -1,    -1,
     203,   204,    -1,   206,    -1,   208,    -1,   210,   211,   212,
     213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,
      -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,
      -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,   281,    -1,
      -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,
     293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,
      -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,    -1,    -1,   318,   319,   320,    -1,   322,
     323,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,   332,
     333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,
     343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,
      -1,    -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,
       7,     8,   375,    -1,    -1,    -1,    13,    -1,    -1,   382,
      17,    18,    19,    20,   387,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,
      37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,
     117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,
      -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,
      -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,
     197,   198,   199,   200,    -1,    -1,   203,   204,    -1,   206,
      -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,
     217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,
     227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
      -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,
      -1,   268,    -1,    -1,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,
     287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,
      -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,   332,   333,    -1,    -1,   336,
      -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,
      -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,     4,   371,     6,     7,     8,   375,    -1,
      -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,
     387,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,
      -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,
      -1,    -1,    43,    -1,    45,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,
     101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,
     111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,
      -1,    -1,   123,   124,   125,   126,    -1,   128,    -1,    -1,
      -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
      -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,
      -1,    -1,   173,    -1,    -1,    -1,   177,    -1,    -1,    -1,
      -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,
      -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,   200,
      -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,
     211,   212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,
      -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,    -1,   248,   249,   250,
     251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,
      -1,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,
     291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,
      -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,
      -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,   320,
      -1,   322,   323,    -1,    -1,   326,    -1,    -1,   329,    -1,
     331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,
     341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,
     361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,     4,
     371,     6,     7,     8,   375,    -1,    -1,    -1,    13,    -1,
     381,    -1,    17,    18,    19,    20,   387,    22,    -1,    -1,
      -1,    -1,    27,    -1,    29,    30,    -1,    32,    -1,    34,
      -1,    -1,    37,    -1,    -1,    40,    -1,    -1,    43,    -1,
      45,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      55,    56,    -1,    58,    59,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,
     105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,
      -1,   116,   117,    -1,   119,    -1,    -1,    -1,   123,   124,
     125,   126,    -1,   128,    -1,    -1,    -1,   132,   133,    -1,
     135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,    -1,    -1,   153,   154,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,
      -1,    -1,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,
      -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,   194,
     195,    -1,   197,   198,   199,   200,    -1,    -1,   203,   204,
      -1,   206,    -1,   208,    -1,   210,   211,   212,   213,    -1,
      -1,    -1,   217,   218,   219,    -1,    -1,   222,    -1,    -1,
      -1,   226,   227,    -1,   229,   230,   231,   232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,    -1,
      -1,   266,    -1,   268,    -1,    -1,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,
     285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,
     305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,
     315,    -1,    -1,   318,   319,   320,    -1,   322,   323,    -1,
      -1,   326,    -1,    -1,   329,    -1,   331,   332,   333,    -1,
      -1,   336,    -1,    -1,   339,   340,   341,    -1,   343,   344,
      -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,
      -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,
     365,   366,    -1,    -1,    -1,     4,   371,     6,     7,     8,
     375,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,
      19,    20,   387,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,
      -1,    40,    -1,    -1,    43,    -1,    45,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,
     119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
      -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,
     199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,
      -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,
      -1,    -1,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,
     309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,
     319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,    -1,
     329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,
     339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,     4,   371,     6,     7,     8,   375,    -1,    -1,    -1,
      13,    -1,    -1,    -1,    17,    18,    19,    20,   387,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,
      -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,
      43,    -1,    45,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,
      -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,
      -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,
     123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,
     133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,
     173,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,
      -1,   194,   195,    -1,   197,   198,   199,   200,    -1,    -1,
     203,   204,    -1,   206,    -1,   208,    -1,   210,   211,   212,
     213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,
      -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,
      -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,    -1,    -1,
      -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,
     293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,
      -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,    -1,    -1,   318,   319,   320,    -1,   322,
     323,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,   332,
     333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,
     343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,
      -1,    -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,
       7,     8,   375,    -1,    -1,    -1,    13,    -1,    -1,    -1,
      17,    18,    19,    20,   387,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,
      37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,
     117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,
      -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,
      -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,
     197,   198,   199,   200,    -1,    -1,   203,   204,    -1,   206,
      -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,
     217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,
     227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
      -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,
      -1,   268,    -1,    -1,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,
     287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,
      -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,   332,   333,    -1,    -1,   336,
      -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,
      -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,     4,   371,     6,     7,     8,   375,    -1,
      -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,
     387,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,
      -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,
      -1,    -1,    43,    -1,    45,    46,    47,    48,    49,    -1,
      51,    52,    53,    54,    55,    56,    -1,    58,    59,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    83,    84,    -1,    -1,    -1,    88,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,
     101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,
     111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,
      -1,    -1,   123,   124,   125,   126,    -1,   128,    -1,    -1,
      -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
      -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,
      -1,    -1,   173,    -1,    -1,    -1,   177,   178,    -1,    -1,
      -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,
      -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,   200,
      -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,
     211,   212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,
      -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,    -1,   248,   249,   250,
     251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,
      -1,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,
     291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,
      -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,
      -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,   320,
      -1,   322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,
     331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,
     341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,
      -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,
     361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,   375,     4,    -1,     6,     7,     8,
      -1,    -1,   383,    -1,    13,    -1,    -1,    -1,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,
      29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,
      -1,    40,    -1,    -1,    43,    -1,    45,    46,    47,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    -1,    58,
      59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,
      99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,
      -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,
     119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,
      -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,
      -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,   178,
     179,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,
     199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,
      -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,   218,
     219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,
     229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,
     249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,
      -1,    -1,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,
      -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,
     309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,
     319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,   328,
     329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,
     339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,
      -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,     4,   371,     6,     7,     8,   375,    -1,    -1,    -1,
      13,    -1,   381,    -1,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,
      -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,
      43,    -1,    45,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    55,    56,    -1,    58,    59,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,
      -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,
      -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,
     123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,
     133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,
     153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,
     173,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,   182,
      -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,
      -1,   194,   195,    -1,   197,   198,   199,   200,    -1,    -1,
     203,   204,    -1,   206,    -1,   208,    -1,   210,   211,   212,
     213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,
      -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,
      -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,    -1,    -1,
      -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,
     293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,
      -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,    -1,    -1,   318,   319,   320,    -1,   322,
     323,    -1,    -1,   326,    -1,    -1,   329,    -1,   331,   332,
     333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,
     343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,
      -1,    -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,
       7,     8,   375,    -1,    -1,   378,    13,    -1,    -1,    -1,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,
      37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,
     107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,
     117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,
      -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,
     137,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,
      -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,
     197,   198,   199,   200,    -1,    -1,   203,   204,    -1,   206,
      -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,
     217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,
     227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
      -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,
      -1,   268,    -1,    -1,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,
     287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,
      -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,
      -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,   326,
      -1,    -1,   329,    -1,   331,   332,   333,    -1,    -1,   336,
      -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,
      -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,
      -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,    -1,   371,    -1,    -1,    -1,   375,    -1,
      -1,   378,     4,     5,     6,     7,     8,    -1,    10,    -1,
      -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,
      32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    48,    49,    -1,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    -1,    61,
      -1,    63,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      -1,    83,    84,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    -1,    98,    99,   100,   101,
      -1,    -1,    -1,   105,    -1,   107,   108,   109,   110,   111,
      -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,
      -1,   123,   124,   125,   126,    -1,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,
      -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,
      -1,   173,    -1,    -1,    -1,   177,   178,    -1,    -1,    -1,
     182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,
      -1,    -1,   194,   195,    -1,   197,   198,   199,   200,    -1,
      -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,   211,
     212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,
     222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,
     232,    -1,    -1,    -1,   236,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,   251,
      -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,   261,
     262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
      -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,
      -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,    -1,    -1,   318,   319,   320,    -1,
     322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,
     332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,
      -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,   365,   366,    -1,    -1,    -1,    -1,   371,
      -1,    -1,    -1,   375,     4,     5,     6,     7,     8,    -1,
      10,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,
      30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    48,    49,
      -1,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      -1,    61,    -1,    63,    -1,    -1,    -1,    67,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    98,    99,
     100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,
      -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     170,    -1,    -1,   173,    -1,    -1,    -1,   177,   178,    -1,
      -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,
     200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,
     210,   211,   212,   213,    -1,    -1,    -1,   217,   218,   219,
      -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,
     230,   231,   232,    -1,    -1,    -1,   236,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
      -1,   261,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,
      -1,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,
      -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
     300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,
     320,    -1,   322,   323,    -1,    -1,   326,    -1,   328,   329,
      -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,
     340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,
       4,   371,     6,     7,     8,   375,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,    -1,
      34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,    43,
      -1,    45,    46,    -1,    48,    49,    -1,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      84,    85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,
      -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,
     114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,   123,
     124,   125,   126,   127,   128,    -1,    -1,    -1,   132,   133,
      -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,   153,
     154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,
      -1,    -1,    -1,   177,   178,    -1,    -1,    -1,   182,    -1,
     184,    -1,   186,    -1,   188,   189,    -1,    -1,    -1,    -1,
     194,   195,    -1,   197,   198,   199,   200,    -1,    -1,   203,
     204,    -1,   206,    -1,   208,    -1,   210,   211,   212,   213,
      -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,    -1,
     224,    -1,   226,   227,    -1,   229,   230,   231,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,
     254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,
      -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,
     284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,
     294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,
      -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,    -1,    -1,   318,   319,   320,    -1,   322,   323,
      -1,    -1,   326,    -1,   328,   329,    -1,   331,   332,   333,
      -1,    -1,   336,    -1,    -1,   339,   340,   341,   342,   343,
     344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,     7,
       8,   375,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,
      -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,    47,
      48,    49,    -1,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,
      88,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,
      -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,
     108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,
      -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,
     128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,
     178,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,
     188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,
     198,   199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,
     208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,
     218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,
      -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,
     258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,
     268,    -1,    -1,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,   287,
      -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,
     318,   319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,
     328,   329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,
      -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,
     348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,
     358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,
      -1,    -1,     4,   371,     6,     7,     8,   375,    -1,    -1,
      -1,    13,    -1,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,
      32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,
      -1,    43,    -1,    45,    46,    47,    48,    49,    -1,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      -1,    83,    84,    -1,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,
      -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,
      -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,
      -1,   123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,
     132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,
      -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,
      -1,   173,    -1,    -1,    -1,   177,   178,    -1,    -1,    -1,
     182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,
      -1,    -1,   194,   195,    -1,   197,   198,   199,   200,    -1,
      -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,   211,
     212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,
     222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,
     232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,   251,
      -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,
     262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
      -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,
      -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,    -1,    -1,   318,   319,   320,    -1,
     322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,
     332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,
      -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,   365,   366,    -1,    -1,    -1,     4,   371,
       6,     7,     8,   375,    -1,    -1,    -1,    13,    -1,    -1,
      -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,
      26,    27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,
      -1,    37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,
      46,    -1,    48,    49,    -1,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,
      -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,
     116,   117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,
     126,    -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,
      -1,   137,    -1,    -1,    -1,   141,    -1,   143,    -1,    -1,
      -1,   147,   148,   149,   150,    -1,    -1,   153,   154,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,
      -1,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,
     186,    -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,
      -1,   197,   198,   199,   200,    -1,    -1,   203,   204,    -1,
     206,    -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,
      -1,   217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,
     226,   227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,
      -1,    -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,
     266,    -1,   268,    -1,    -1,   271,   272,   273,   274,   275,
     276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,
     286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,
      -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
      -1,    -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,
     326,    -1,   328,   329,    -1,   331,   332,   333,    -1,    -1,
     336,    -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,
      -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,
      -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,     4,   371,     6,     7,     8,   375,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,
      30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,
      40,    -1,    -1,    43,    -1,    45,    46,    -1,    48,    49,
      -1,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    88,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,
     100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,
      -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,    -1,
      -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     170,    -1,    -1,   173,    -1,    -1,    -1,   177,   178,    -1,
      -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,
     200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,
     210,   211,   212,   213,    -1,    -1,    -1,   217,   218,   219,
      -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,
     230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
      -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,
      -1,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,
      -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
     300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,
     320,    -1,   322,   323,    -1,    -1,   326,    -1,   328,   329,
      -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,
     340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,
       4,   371,     6,     7,     8,   375,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,    -1,
      34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,    43,
      -1,    45,    46,    -1,    48,    49,    -1,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      84,    -1,    -1,    -1,    88,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,
      -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,
     114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,   123,
     124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,   133,
      -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,   153,
     154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,
      -1,    -1,    -1,   177,   178,    -1,    -1,    -1,   182,    -1,
     184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,
     194,   195,    -1,   197,   198,   199,   200,    -1,    -1,   203,
     204,    -1,   206,    -1,   208,    -1,   210,   211,   212,   213,
      -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,    -1,
      -1,    -1,   226,   227,    -1,   229,   230,   231,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,
     254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,
      -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,
     284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,
     294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,
      -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,    -1,    -1,   318,   319,   320,    -1,   322,   323,
      -1,    -1,   326,    -1,   328,   329,    -1,   331,   332,   333,
      -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,   343,
     344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,     7,
       8,   375,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,
      -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,    -1,
      48,    49,    -1,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,
      -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,
     108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,
      -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,
     128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,
     178,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,
     188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,
     198,   199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,
     208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,
     218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,
      -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,
     258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,
     268,    -1,    -1,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,   287,
      -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,
     318,   319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,
     328,   329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,
      -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,
     348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,
     358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,
      -1,    -1,     4,   371,     6,     7,     8,   375,    -1,    -1,
      -1,    13,    14,    -1,    -1,    17,    18,    19,    20,    -1,
      22,    -1,    -1,    -1,    -1,    27,    -1,    29,    30,    -1,
      32,    -1,    34,    -1,    -1,    37,    -1,    -1,    40,    -1,
      -1,    43,    -1,    45,    46,    -1,    48,    49,    -1,    51,
      52,    53,    54,    55,    56,    -1,    58,    59,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      -1,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    -1,    -1,    99,   100,   101,
      -1,    -1,    -1,   105,    -1,   107,   108,    -1,   110,   111,
      -1,    -1,   114,    -1,   116,   117,    -1,   119,    -1,    -1,
      -1,   123,   124,   125,   126,    -1,   128,    -1,    -1,    -1,
     132,   133,    -1,   135,    -1,   137,    -1,    -1,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,    -1,
      -1,   153,   154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,   170,    -1,
      -1,   173,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,
     182,    -1,   184,    -1,   186,    -1,   188,    -1,    -1,    -1,
      -1,    -1,   194,   195,    -1,   197,   198,   199,   200,    -1,
      -1,   203,   204,    -1,   206,    -1,   208,    -1,   210,   211,
     212,   213,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,
     222,    -1,    -1,    -1,   226,   227,    -1,   229,   230,   231,
     232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,   251,
      -1,    -1,   254,    -1,    -1,    -1,   258,    -1,    -1,    -1,
     262,    -1,    -1,    -1,   266,    -1,   268,    -1,    -1,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
      -1,    -1,   284,   285,   286,   287,    -1,    -1,    -1,   291,
      -1,   293,   294,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,    -1,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,    -1,    -1,   318,   319,   320,    -1,
     322,   323,    -1,    -1,   326,    -1,   328,   329,    -1,   331,
     332,   333,    -1,    -1,   336,    -1,    -1,   339,   340,   341,
      -1,   343,   344,    -1,    -1,    -1,   348,    -1,    -1,    -1,
     352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,   365,   366,    -1,    -1,    -1,     4,   371,
       6,     7,     8,   375,    -1,    -1,    -1,    13,    -1,    -1,
      -1,    17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,
      -1,    27,    -1,    29,    30,    -1,    32,    -1,    34,    -1,
      -1,    37,    -1,    -1,    40,    -1,    -1,    43,    -1,    45,
      46,    -1,    48,    49,    -1,    51,    52,    53,    54,    55,
      56,    -1,    58,    59,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    -1,    -1,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    -1,    -1,    -1,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    -1,    -1,    99,   100,   101,    -1,    -1,    -1,   105,
      -1,   107,   108,    -1,   110,   111,    -1,    -1,   114,    -1,
     116,   117,    -1,   119,    -1,    -1,    -1,   123,   124,   125,
     126,    -1,   128,    -1,    -1,    -1,   132,   133,    -1,   135,
      -1,   137,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,    -1,    -1,   153,   154,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,   170,    -1,    -1,   173,    -1,    -1,
      -1,   177,    -1,    -1,    -1,    -1,   182,    -1,   184,    -1,
     186,    -1,   188,    -1,    -1,    -1,    -1,    -1,   194,   195,
      -1,   197,   198,   199,   200,    -1,    -1,   203,   204,    -1,
     206,    -1,   208,    -1,   210,   211,   212,   213,    -1,    -1,
      -1,   217,   218,   219,    -1,    -1,   222,    -1,    -1,    -1,
     226,   227,    -1,   229,   230,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,   251,    -1,    -1,   254,    -1,
      -1,    -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,
     266,    -1,   268,    -1,    -1,   271,   272,   273,   274,   275,
     276,   277,    -1,   279,   280,    -1,    -1,    -1,   284,   285,
     286,   287,    -1,    -1,    -1,   291,    -1,   293,   294,    -1,
      -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
      -1,    -1,   318,   319,   320,    -1,   322,   323,    -1,    -1,
     326,    -1,   328,   329,    -1,   331,   332,   333,    -1,    -1,
     336,    -1,    -1,   339,   340,   341,    -1,   343,   344,    -1,
      -1,    -1,   348,    -1,    -1,    -1,   352,    -1,    -1,    -1,
      -1,    -1,   358,    -1,    -1,   361,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,     4,   371,     6,     7,     8,   375,
      -1,    -1,    -1,    13,    -1,    -1,    -1,    17,    18,    19,
      20,    -1,    22,    -1,    -1,    -1,    -1,    27,    -1,    29,
      30,    -1,    32,    -1,    34,    -1,    -1,    37,    -1,    -1,
      40,    -1,    -1,    43,    -1,    45,    46,    -1,    48,    49,
      -1,    51,    52,    53,    54,    55,    56,    -1,    58,    59,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    -1,    -1,    99,
     100,   101,    -1,    -1,    -1,   105,    -1,   107,   108,    -1,
     110,   111,    -1,    -1,   114,    -1,   116,   117,    -1,   119,
      -1,    -1,    -1,   123,   124,   125,   126,    -1,   128,    -1,
      -1,    -1,   132,   133,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,    -1,    -1,   153,   154,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,
     170,    -1,    -1,   173,    -1,    -1,    -1,   177,    -1,    -1,
      -1,    -1,   182,    -1,   184,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,    -1,   194,   195,    -1,   197,   198,   199,
     200,    -1,    -1,   203,   204,    -1,   206,    -1,   208,    -1,
     210,   211,   212,   213,    -1,    -1,    -1,   217,   218,   219,
      -1,    -1,   222,    -1,    -1,    -1,   226,   227,    -1,   229,
     230,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,   248,   249,
     250,   251,    -1,    -1,   254,    -1,    -1,    -1,   258,    -1,
      -1,    -1,   262,    -1,    -1,    -1,   266,    -1,   268,    -1,
      -1,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,    -1,    -1,   284,   285,   286,   287,    -1,    -1,
      -1,   291,    -1,   293,   294,    -1,    -1,    -1,    -1,    -1,
     300,    -1,    -1,    -1,    -1,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,    -1,    -1,   318,   319,
     320,    -1,   322,   323,    -1,    -1,   326,    -1,    -1,   329,
      -1,   331,   332,   333,    -1,    -1,   336,    -1,    -1,   339,
     340,   341,    -1,   343,   344,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,
       4,   371,     6,     7,     8,   375,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    -1,    27,    -1,    29,    30,    -1,    32,    -1,
      34,    -1,    -1,    37,    -1,    -1,    40,    -1,    -1,    43,
      -1,    45,    46,    -1,    48,    49,    -1,    51,    52,    53,
      54,    55,    56,    -1,    58,    59,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    83,
      84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    -1,    -1,    99,   100,   101,    -1,    -1,
      -1,   105,    -1,   107,   108,    -1,   110,   111,    -1,    -1,
     114,    -1,   116,   117,    -1,   119,    -1,    -1,    -1,   123,
     124,   125,   126,    -1,   128,    -1,    -1,    -1,   132,   133,
      -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,    -1,    -1,   153,
     154,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,   170,    -1,    -1,   173,
      -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,   182,    -1,
     184,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,
     194,   195,    -1,   197,   198,   199,   200,    -1,    -1,   203,
     204,    -1,   206,    -1,   208,    -1,   210,   211,   212,   213,
      -1,    -1,    -1,   217,   218,   219,    -1,    -1,   222,    -1,
      -1,    -1,   226,   227,    -1,   229,   230,   231,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,   251,    -1,    -1,
     254,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,    -1,
      -1,    -1,   266,    -1,   268,    -1,    -1,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,    -1,    -1,
     284,   285,   286,   287,    -1,    -1,    -1,   291,    -1,   293,
     294,    -1,    -1,    -1,    -1,    -1,   300,    -1,    -1,    -1,
      -1,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,    -1,    -1,   318,   319,   320,    -1,   322,   323,
      -1,    -1,   326,    -1,    -1,   329,    -1,   331,   332,   333,
      -1,    -1,   336,    -1,    -1,   339,   340,   341,    -1,   343,
     344,    -1,    -1,    -1,   348,    -1,    -1,    -1,   352,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,   361,    -1,    -1,
      -1,   365,   366,    -1,    -1,    -1,     4,   371,     6,     7,
       8,   375,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      -1,    29,    30,    -1,    32,    -1,    34,    -1,    -1,    37,
      -1,    -1,    40,    -1,    -1,    43,    -1,    45,    46,    -1,
      48,    49,    -1,    51,    52,    53,    54,    55,    56,    -1,
      58,    59,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    -1,    -1,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    -1,
      -1,    99,   100,   101,    -1,    -1,    -1,   105,    -1,   107,
     108,    -1,   110,   111,    -1,    -1,   114,    -1,   116,   117,
      -1,   119,    -1,    -1,    -1,   123,   124,   125,   126,    -1,
     128,    -1,    -1,    -1,   132,   133,    -1,   135,    -1,   137,
      -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,    -1,    -1,   153,   154,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,   170,    -1,    -1,   173,    -1,    -1,    -1,   177,
      -1,    -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,
     188,    -1,    -1,    -1,    -1,    -1,   194,   195,    -1,   197,
     198,   199,   200,    -1,    -1,   203,   204,    -1,   206,    -1,
     208,    -1,   210,   211,   212,   213,    -1,    -1,    -1,   217,
     218,   219,    -1,    -1,   222,    -1,    -1,    -1,   226,   227,
      -1,   229,   230,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,   251,    -1,    -1,   254,    -1,    -1,    -1,
     258,    -1,    -1,    -1,   262,    -1,    -1,    -1,   266,    -1,
     268,    -1,    -1,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,    -1,    -1,   284,   285,   286,   287,
      -1,    -1,    -1,   291,    -1,   293,   294,    -1,    -1,    -1,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,    -1,    -1,
     318,   319,   320,    -1,   322,   323,    -1,    -1,   326,    -1,
      -1,   329,    -1,   331,   332,   333,    -1,    -1,   336,    -1,
      -1,   339,   340,   341,    -1,   343,   344,    -1,    -1,    -1,
     348,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,
     358,    -1,    -1,   361,    -1,    -1,    -1,   365,   366,    -1,
      -1,    -1,    -1,   371,    -1,    -1,    -1,   375
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,    10,    11,    22,    44,    53,    65,    89,    90,    91,
      98,   109,   128,   160,   172,   183,   260,   261,   264,   271,
     277,   281,   289,   292,   305,   339,   349,   350,   353,   381,
     390,   391,   392,   393,   474,   490,   492,   494,   496,   500,
     501,   638,   644,   647,   670,   677,   683,   685,   691,   694,
     697,   703,   705,   706,   747,   764,   766,   772,   773,   774,
     775,    71,   226,   231,   479,   322,   325,   763,   767,   763,
     371,   768,    71,   326,   410,   479,   678,    71,   326,   479,
     643,   698,   645,    58,   251,   704,    74,   711,   277,   763,
     648,   768,     4,     6,     7,     8,    13,    17,    18,    19,
      20,    22,    27,    29,    30,    32,    34,    37,    40,    43,
      45,    46,    48,    49,    51,    52,    53,    54,    55,    56,
      58,    59,    61,    67,    72,    73,    74,    75,    78,    83,
      84,    93,    94,    99,   100,   101,   105,   107,   108,   110,
     111,   114,   116,   117,   119,   123,   124,   125,   126,   128,
     132,   133,   135,   137,   141,   147,   148,   149,   150,   153,
     154,   166,   170,   173,   177,   182,   184,   186,   188,   194,
     195,   197,   198,   199,   200,   203,   204,   206,   208,   210,
     211,   212,   213,   217,   218,   219,   222,   226,   227,   229,
     230,   231,   232,   241,   242,   243,   246,   248,   249,   250,
     251,   254,   258,   262,   266,   268,   271,   272,   273,   274,
     275,   276,   277,   279,   280,   284,   285,   286,   287,   291,
     293,   294,   300,   305,   306,   309,   310,   313,   314,   315,
     318,   319,   320,   322,   323,   326,   329,   331,   332,   333,
     336,   339,   340,   341,   343,   344,   348,   352,   358,   361,
     365,   366,   371,   375,   739,   743,   745,   746,   504,   506,
     507,   234,   749,   686,   336,   325,   684,   765,   152,   487,
     743,   281,   381,   502,     0,   109,   119,   387,   695,   738,
     743,   477,   743,   487,   493,   768,   495,    12,   769,   151,
     411,   325,   395,   152,   681,   682,   151,   642,   155,   763,
     188,   306,   322,   699,   700,   763,   487,     6,    20,    25,
      26,    38,    39,    42,    46,    48,    63,    64,    68,    69,
      71,    76,    77,    78,    83,    85,    88,   118,   120,   121,
     127,   139,   143,   147,   151,   160,   161,   176,   189,   196,
     200,   203,   205,   209,   210,   220,   221,   223,   224,   244,
     250,   263,   264,   268,   270,   276,   279,   307,   308,   314,
     316,   317,   321,   328,   331,   332,   333,   337,   338,   339,
     342,   352,   355,   356,   357,   362,   364,   375,   376,   377,
     381,   385,   387,   388,   521,   522,   523,   524,   530,   531,
     532,   533,   534,   539,   543,   726,   729,   730,   734,   736,
     739,   741,   743,   707,   743,   497,   162,   641,   650,   651,
     738,   334,   769,   505,     9,    95,   299,   300,   301,   302,
     312,   511,   512,   513,   748,    49,    64,    65,    72,   114,
     137,   154,   155,   169,   184,   249,   286,   322,   325,   326,
     365,   460,   687,   755,   369,   491,   641,   763,   738,   506,
     502,   382,   743,   693,   692,   387,   476,   325,   640,   641,
     640,    40,   222,   222,   260,   770,   220,   527,   743,   411,
     347,   461,   134,   679,   681,   118,   743,   743,   642,   369,
     383,   701,   650,   381,   381,   530,   521,   553,   381,   381,
     381,   381,   381,   381,   381,   520,   520,   381,   381,   381,
     381,   726,   381,   381,   381,   381,   381,   381,   381,   381,
     381,   521,   381,   381,   381,   381,   381,   381,   381,   521,
     381,   520,   381,   381,   381,   381,   381,   381,   381,   381,
     381,   381,   381,   381,   381,   381,   520,   381,   726,   381,
     381,   381,   381,   381,   520,   520,   381,   381,   381,   381,
     530,   530,   521,   787,   788,   743,   743,   544,    12,   237,
     373,   525,   526,   112,   113,   136,   140,   165,   174,   192,
     215,   528,    23,    96,   164,   179,   209,   376,   377,   378,
     379,   380,   527,    47,   741,   381,   387,    56,   712,   498,
     499,   738,   651,   649,   277,   771,   770,   346,   776,   777,
     378,   515,   516,   517,   513,   750,   751,   752,   134,   164,
     689,   381,    71,   325,   179,   368,   690,   180,   622,   624,
     688,   689,   306,   322,   622,   689,   306,   361,    59,   671,
     382,   777,   779,   780,   781,   500,    26,   143,   696,   727,
     741,   743,   743,    88,   418,   448,   738,   383,    40,   260,
     118,   396,   738,   155,   738,   228,   640,   255,   700,   640,
     702,   646,   521,     9,    95,   549,   605,   367,   555,   521,
     521,   552,   552,   521,   521,    95,   549,   605,   382,   382,
     521,   521,   521,   521,   734,   787,    79,    80,    81,    82,
      83,   144,   145,   146,   147,   200,   201,   202,   203,   210,
     250,   278,   279,   366,   374,   375,   600,   602,    95,   546,
     521,   521,   521,   521,   600,   521,    95,   549,   521,   521,
      95,   549,   521,   521,   521,   524,   521,   521,   521,   521,
     521,   521,   521,   549,   549,   521,   521,    95,   549,   521,
     521,   133,   601,   602,   601,    31,   175,   335,   521,   521,
     382,   735,   736,   743,   549,   549,   521,   382,   383,   382,
     281,   381,   784,   785,   521,   387,   178,   328,   388,   545,
     740,   743,   744,   521,   521,   521,   523,   121,   223,   338,
     348,   527,     9,    13,   523,   529,   524,   524,   381,   530,
     524,   161,   524,   161,   524,   524,   524,   524,    23,   164,
     179,   744,   535,   743,   156,   383,   334,   281,   289,   357,
     358,   381,   403,   652,   655,   743,     9,    95,   783,   383,
     508,   521,   732,   743,   383,   137,   184,   229,   286,   753,
     754,   757,   758,   738,   378,   411,   738,   740,   521,   189,
     224,   342,   625,   626,   690,   743,   688,   690,   738,   690,
     690,   294,   289,   236,   618,   624,   782,    47,   475,   641,
     407,   408,   409,   418,   744,   394,   743,   680,   738,   187,
     652,   383,   549,   382,   550,   521,   103,   367,   554,    14,
     382,   383,   382,   382,   383,   540,   382,   378,   383,   383,
     382,   382,   382,   382,   134,   542,   382,   383,   383,   383,
     377,   383,   549,   382,   382,   382,   549,   382,   383,   382,
     382,   164,   382,   383,   383,   382,   383,   383,   382,   382,
     382,   383,   134,   383,   549,   382,   382,   382,   383,   383,
     134,   521,   134,   521,   134,   521,   134,   382,   383,   382,
     382,   382,   382,   552,   574,   575,   576,   281,   381,   503,
     346,   789,   386,   743,   137,   184,   286,   756,   290,   121,
     223,   338,   348,   381,    12,   521,   787,   116,   610,   521,
     521,   524,   381,   530,   517,   536,   537,   538,   387,   328,
     742,   499,   738,   404,   653,   381,   658,   663,   658,   382,
     403,   654,   731,   732,   735,   743,   656,   778,   516,   134,
     162,   509,   510,   617,   618,   634,   518,   518,   387,   751,
     336,   743,   760,   388,   759,   688,   382,   743,   227,   383,
     690,   688,   673,   674,   735,    33,   622,   112,   290,   661,
     662,     5,    10,    18,    41,    51,    63,    93,    94,    98,
     105,   110,   129,   153,   208,   236,   261,   413,   415,   416,
     417,   448,   478,   480,   481,   482,   614,   744,   383,   661,
     179,   381,   397,   412,   414,   415,   462,   463,   368,   606,
     639,   228,   668,   161,   521,   382,   521,   330,   521,   521,
     107,    25,    42,    75,    78,    86,   551,   521,   551,   552,
     382,   161,   161,   521,   552,   521,   521,   521,   521,   521,
     382,   382,   521,   521,   521,   521,   521,   552,   161,   521,
     521,   521,   382,   521,   521,   521,   134,   521,   134,   521,
     134,   521,   521,   382,   511,   575,   503,   382,   783,   387,
     387,   387,   744,   521,   787,   523,   382,   383,   382,   530,
     600,   600,    12,   521,   787,   610,   521,   382,   383,   743,
     708,   511,   659,   660,   735,   664,   383,   381,   655,   382,
     382,   383,   776,   501,   281,   381,   385,   556,   557,   558,
     559,   560,   569,   570,   584,   635,   131,   187,   514,   634,
     623,   624,   510,    14,   519,   740,   743,   378,   743,   166,
     661,   388,   744,   690,   114,   365,   626,   626,   606,   383,
     672,   661,   619,    88,   446,   447,   744,    50,    60,   155,
     171,   424,   427,   428,   456,   458,   486,   486,   662,   486,
     662,   334,   169,   323,   130,   247,   458,   486,   169,   661,
     323,   486,    33,    14,   112,   334,   489,   413,    47,   383,
     381,   387,   423,   429,   737,   743,   661,   408,    85,   127,
     189,   224,   342,   629,   744,   738,   179,   398,   403,   421,
     422,   423,   424,   152,   264,   400,   713,   383,   414,   341,
     354,   466,   228,   607,   617,   100,   521,   382,   521,   330,
     381,   440,   440,   381,   438,   439,   382,   382,   541,   521,
     521,   382,   548,   618,   383,   383,   382,   383,   382,   382,
     382,   382,   383,   382,   382,   521,   382,   131,   382,   382,
     383,   383,   383,   382,   521,   382,   521,   382,   521,   382,
     382,   515,   382,   786,   387,   472,   382,   552,   523,   382,
     383,   382,   518,   538,   713,   515,   383,   661,    88,   521,
     665,   666,   667,   663,   657,   655,   731,   583,   743,    66,
     157,   168,   176,   214,   270,   312,   568,   606,   383,   738,
     583,    99,   239,   630,   631,   636,   350,   164,   740,   743,
     387,   177,     9,    25,    88,   228,   521,   762,   756,   661,
     674,   606,   667,   521,   620,   733,   471,   737,    44,   130,
     247,   347,   426,   457,   425,   426,   471,   737,   629,   737,
     740,   447,   171,   171,   737,   737,   744,   737,   615,   616,
     735,   738,   662,   482,   421,   743,     7,   125,   488,   259,
     425,   450,   430,   387,   629,   744,   412,   738,   382,   382,
     383,    14,   406,   414,    32,   141,   468,   468,   738,   521,
     180,   627,   669,   600,   521,   224,   224,   382,   600,   600,
     283,   547,   521,   521,   552,   521,   600,   521,   521,   521,
     521,   382,   382,   382,   577,   784,   743,   382,   552,   519,
     162,   405,   660,   667,   382,   383,   779,   571,   578,   583,
     556,   168,   168,   238,   585,   168,   176,   270,   585,   569,
     556,   138,   611,   558,    14,   112,   603,   604,   580,   581,
     742,   742,   388,   632,   633,   291,   378,   255,   262,   284,
     761,   760,   521,   617,   383,    15,    90,   621,   521,   171,
     171,   458,   459,   471,   463,    98,   289,   483,   471,   484,
     383,   621,   447,   382,   743,   738,    24,    28,    42,    75,
      78,    86,    97,   111,   126,   163,   225,   257,   285,   329,
     331,   359,   360,   431,   432,   434,   435,   436,   437,   743,
     382,   399,   412,   422,   381,   403,   381,   626,   171,   382,
     382,   382,   383,   382,   382,   727,   382,   382,   383,   382,
     382,   382,   382,   382,   382,   382,   420,   510,   623,   382,
     709,   420,   667,   346,   382,   617,   579,   386,   168,   569,
     585,   585,   168,   228,   228,   354,    33,   142,   608,   743,
     594,   595,   511,   637,   744,   383,   206,    52,   343,   255,
     661,   627,   733,   471,   463,   381,    88,    88,   429,   431,
     616,   381,   451,   438,   245,   433,   438,   438,   381,    18,
      47,    51,    88,   123,   223,   228,   247,   285,   347,   442,
     443,   444,   449,   527,   363,   381,   381,   381,   439,   441,
     387,   779,   400,   403,   401,   469,   470,   743,   350,   224,
     521,   514,   514,   325,   783,   604,   623,   559,   556,   569,
     168,   168,   556,   569,   562,   561,   563,   612,   733,   609,
     617,   592,   593,   515,    49,   714,   633,   762,   621,   381,
     381,   469,    78,   331,   376,   377,   728,   729,   488,   485,
     452,   743,   193,   453,   381,   224,   446,   740,   221,   445,
     728,    88,   101,   126,   419,   350,    88,   171,   444,   171,
     223,   224,   224,   224,   743,   382,   776,   382,   383,   621,
     381,   675,   676,   735,   382,   382,   738,   572,   228,   565,
     569,   569,   228,   567,   521,   521,   381,   370,   383,   613,
     621,   521,   623,   129,   152,   353,   587,   588,   591,   582,
     106,   115,   235,   327,   715,   716,   181,   717,   469,   469,
     382,   730,   730,   488,   382,   383,   135,   242,   293,   228,
     454,   473,   727,   382,   520,   221,   358,   382,   382,   402,
      51,   170,   464,   465,   466,   467,   470,   224,   383,   661,
     710,   784,   564,   354,   566,   354,   599,   743,   733,   458,
     458,   588,   420,    33,    33,   106,    33,   716,   304,   327,
     718,   719,   382,   382,   464,   743,    89,   350,   382,   383,
     520,   779,   740,   662,   467,   621,   382,   676,   667,   714,
     573,   521,   381,   521,   381,   382,   383,   621,   131,   586,
     586,   727,   727,    33,   727,    33,    33,   719,   450,   464,
      36,   222,   265,   289,   455,   455,   727,    85,   127,   143,
     189,   224,   342,   628,   717,   617,   599,   599,   743,   138,
     168,   236,   590,   589,   727,   727,   727,     4,    88,   223,
     228,   228,   152,   720,   623,   382,   382,    33,    33,   381,
     381,   350,    89,   224,   381,   722,   247,   596,   597,   598,
     743,   598,   455,   455,   181,   274,   721,   382,   388,   723,
     724,   735,   289,   725,   382,   383,   382,   744,   382,   383,
     675,   597,   724
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */





/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 973 "sql_yacc.yy"
    {
            Session *session= YYSession;
            if (!(session->lex->select_lex.options & OPTION_FOUND_COMMENT))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              DRIZZLE_YYABORT;
            }
            else
            {
              session->lex->sql_command= SQLCOM_EMPTY_QUERY;
              session->lex->statement=
                new(std::nothrow) statement::EmptyQuery(YYSession);
              if (session->lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 989 "sql_yacc.yy"
    {}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 1030 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            lex->sql_command= SQLCOM_CREATE_TABLE;
            statement::CreateTable *statement= new(std::nothrow) statement::CreateTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(5) - (5)].table), NULL,
                                                   TL_OPTION_UPDATING,
                                                   TL_WRITE))
              DRIZZLE_YYABORT;
            lex->col_list.empty();
            statement->change=NULL;
            statement->is_if_not_exists= (yyvsp[(4) - (5)].num);
            statement->create_info.db_type= NULL;
            statement->create_info.default_table_charset= NULL;
            lex->name.str= 0;

	    message::Table &proto= statement->create_table_message;
	   
	    proto.set_name((yyvsp[(5) - (5)].table)->table.str);
	    if ((yyvsp[(2) - (5)].num))
	      proto.set_type(message::Table::TEMPORARY);
	    else
	      proto.set_type(message::Table::STANDARD);
          }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 1058 "sql_yacc.yy"
    {
            LEX *lex= YYSession->lex;
            lex->current_select= &lex->select_lex;
          }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 1063 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_CREATE_INDEX;
            statement::CreateIndex *statement= new(std::nothrow) statement::CreateIndex(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
            statement->alter_info.build_method= (yyvsp[(2) - (2)].build_method);
            lex->col_list.empty();
            statement->change=NULL;
          }
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 1076 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateIndex *statement= (statement::CreateIndex *)Lex->statement;

            if (!lex->current_select->add_table_to_list(lex->session, (yyvsp[(9) - (13)].table),
                                                        NULL,
                                                        TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
            Key *key;
            key= new Key((yyvsp[(4) - (13)].key_type), (yyvsp[(6) - (13)].lex_str), &statement->key_create_info, 0, lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty();
          }
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 1090 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            lex->sql_command=SQLCOM_CREATE_DB;
            statement::CreateSchema *statement= new(std::nothrow) statement::CreateSchema(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->is_if_not_exists= (yyvsp[(3) - (4)].num);
          }
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 1101 "sql_yacc.yy"
    {
            Lex->name= (yyvsp[(4) - (6)].lex_str);
          }
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 1107 "sql_yacc.yy"
    {}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 1109 "sql_yacc.yy"
    {}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 1111 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->is_create_table_like= true;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(2) - (3)].table), NULL, 0, TL_READ))
              DRIZZLE_YYABORT;
          }
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 1121 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->is_create_table_like= true;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              DRIZZLE_YYABORT;
          }
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 1134 "sql_yacc.yy"
    {}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 1136 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 1137 "sql_yacc.yy"
    {}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 1141 "sql_yacc.yy"
    {}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 1143 "sql_yacc.yy"
    { Lex->current_select->set_braces(0);}
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 1144 "sql_yacc.yy"
    {}
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 1146 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 1147 "sql_yacc.yy"
    {}
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 1152 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->lock_option= TL_READ;
            if (lex->sql_command == SQLCOM_INSERT)
            {
              lex->sql_command= SQLCOM_INSERT_SELECT;
              delete lex->statement;
              lex->statement=
                new(std::nothrow) statement::InsertSelect(YYSession);
              if (lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
            else if (lex->sql_command == SQLCOM_REPLACE)
            {
              lex->sql_command= SQLCOM_REPLACE_SELECT;
              delete lex->statement;
              lex->statement=
                new(std::nothrow) statement::ReplaceSelect(YYSession);
              if (lex->statement == NULL)
                DRIZZLE_YYABORT;
            }
            /*
              The following work only with the local list, the global list
              is created correctly in this case
            */
            lex->current_select->table_list.save_and_clear(&lex->save_list);
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 1182 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 1186 "sql_yacc.yy"
    {
            /*
              The following work only with the local list, the global list
              is created correctly in this case
            */
            Lex->current_select->table_list.push_front(&Lex->save_list);
          }
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 1196 "sql_yacc.yy"
    {}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 1197 "sql_yacc.yy"
    {}
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 1201 "sql_yacc.yy"
    {}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 1202 "sql_yacc.yy"
    {}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 1203 "sql_yacc.yy"
    {}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 1213 "sql_yacc.yy"
    {
          statement::CreateSchema *statement= (statement::CreateSchema *)Lex->statement;
          drizzled::message::Engine::Option *opt= statement->schema_message.mutable_engine()->add_options();

          opt->set_name((yyvsp[(1) - (1)].lex_str).str);
        }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 1220 "sql_yacc.yy"
    {
          statement::CreateSchema *statement= (statement::CreateSchema *)Lex->statement;
          drizzled::message::Engine::Option *opt= statement->schema_message.mutable_engine()->add_options();

          opt->set_name((yyvsp[(1) - (3)].lex_str).str);
          opt->set_state((yyvsp[(3) - (3)].lex_str).str);
        }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 1228 "sql_yacc.yy"
    {
          statement::CreateSchema *statement= (statement::CreateSchema *)Lex->statement;
          char number_as_string[22];

          snprintf(number_as_string, sizeof(number_as_string), "%"PRIu64, (yyvsp[(3) - (3)].ulonglong_number));

          drizzled::message::Engine::Option *opt= statement->schema_message.mutable_engine()->add_options();

          opt->set_name((yyvsp[(1) - (3)].lex_str).str);
          opt->set_state(number_as_string);
        }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 1242 "sql_yacc.yy"
    { (yyval.num)= false; }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 1243 "sql_yacc.yy"
    { (yyval.num)= true; }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 1247 "sql_yacc.yy"
    { (yyval.num)= false; }
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 1248 "sql_yacc.yy"
    { (yyval.num)= true; }
    break;

  case 74:

/* Line 1455 of yacc.c  */
#line 1271 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            statement->is_engine_set= true;

            ((statement::CreateTable *)Lex->statement)->create_table_message.mutable_engine()->set_name((yyvsp[(3) - (3)].lex_str).str);
          }
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 1279 "sql_yacc.yy"
    {
	    message::Table::TableOptions *tableopts;
	    tableopts= ((statement::CreateTable *)Lex->statement)->create_table_message.mutable_options();

	    tableopts->set_comment((yyvsp[(3) - (3)].lex_str).str);
          }
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 1286 "sql_yacc.yy"
    {
	    message::Table::TableOptions *tableopts;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

	    tableopts= ((statement::CreateTable *)Lex->statement)->create_table_message.mutable_options();

            statement->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number);
            statement->create_info.used_fields|= HA_CREATE_USED_AUTO;
	    tableopts->set_auto_increment_value((yyvsp[(3) - (3)].ulonglong_number));
          }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 1297 "sql_yacc.yy"
    {
	    drizzled::message::Engine::Option *opt= ((statement::CreateTable *)Lex->statement)->create_table_message.mutable_engine()->add_options();

            opt->set_name((yyvsp[(1) - (3)].lex_str).str);
            opt->set_state((yyvsp[(3) - (3)].lex_str).str);
          }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 1304 "sql_yacc.yy"
    {
            char number_as_string[22];
            snprintf(number_as_string, sizeof(number_as_string), "%"PRIu64, (yyvsp[(3) - (3)].ulonglong_number));

	    drizzled::message::Engine::Option *opt= ((statement::CreateTable *)Lex->statement)->create_table_message.mutable_engine()->add_options();
            opt->set_name((yyvsp[(1) - (3)].lex_str).str);
            opt->set_state(number_as_string);
          }
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 1317 "sql_yacc.yy"
    {
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            HA_CREATE_INFO *cinfo= &statement->create_info;
            if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
                 cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
                 !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
              {
                my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                         (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
                DRIZZLE_YYABORT;
              }
              statement->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
              statement->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
          }
    break;

  case 81:

/* Line 1455 of yacc.c  */
#line 1336 "sql_yacc.yy"
    {
            statement::CreateSchema *statement= (statement::CreateSchema *)Lex->statement;

            message::Schema &schema_message= statement->schema_message;
            schema_message.set_collation((yyvsp[(4) - (4)].charset)->name);
          }
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 1345 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_DEFAULT; }
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 1346 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_FIXED; }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 1347 "sql_yacc.yy"
    { (yyval.column_format_type)= COLUMN_FORMAT_TYPE_DYNAMIC; }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 1351 "sql_yacc.yy"
    {}
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 1368 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 1375 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Key((yyvsp[(1) - (7)].key_type), (yyvsp[(2) - (7)].lex_str), &statement->key_create_info, 0,
                              lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 1385 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Key((yyvsp[(2) - (8)].key_type), (yyvsp[(3) - (8)].lex_str).str ? (yyvsp[(3) - (8)].lex_str) : (yyvsp[(1) - (8)].lex_str), &statement->key_create_info, 0,
                              lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 1394 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Key *key= new Foreign_key((yyvsp[(1) - (8)].lex_str).str ? (yyvsp[(1) - (8)].lex_str) : (yyvsp[(4) - (8)].lex_str), lex->col_list,
                                      (yyvsp[(8) - (8)].table),
                                      lex->ref_list,
                                      statement->fk_delete_opt,
                                      statement->fk_update_opt,
                                      statement->fk_match_option);

            statement->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, (yyvsp[(1) - (8)].lex_str).str ? (yyvsp[(1) - (8)].lex_str) : (yyvsp[(4) - (8)].lex_str),
                         &default_key_create_info, 1,
                         lex->col_list);
            statement->alter_info.key_list.push_back(key);
            lex->col_list.empty(); /* Alloced by memory::sql_alloc */
            /* Only used for ALTER TABLE. Ignored otherwise. */
            statement->alter_info.flags.set(ALTER_FOREIGN_KEY);
          }
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 1414 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 1418 "sql_yacc.yy"
    {
            Lex->col_list.empty(); /* Alloced by memory::sql_alloc */
          }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 1433 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 1434 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 1438 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 1443 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
            lex->length=lex->dec=0;
            lex->type=0;
            statement->default_value= statement->on_update_value= 0;
            statement->comment= null_lex_str;
            lex->charset=NULL;
            statement->column_format= COLUMN_FORMAT_TYPE_DEFAULT;

            message::AlterTable &alter_proto=
              ((statement::CreateTable *)Lex->statement)->alter_info.alter_proto;
            statement->current_proto_field= alter_proto.add_added_field();
          }
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 1458 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_name((yyvsp[(1) - (3)].lex_str).str);

            if (add_field_to_list(lex->session, &(yyvsp[(1) - (3)].lex_str), (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                  lex->length,lex->dec,lex->type,
                                  statement->column_format,
                                  statement->default_value, statement->on_update_value,
                                  &statement->comment,
                                  statement->change, &lex->interval_list, lex->charset))
              DRIZZLE_YYABORT;

            statement->current_proto_field= NULL;
          }
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 1477 "sql_yacc.yy"
    {}
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 1482 "sql_yacc.yy"
    {
          (yyval.num)=(yyvsp[(1) - (1)].num);
          Lex->length=(char*) 0; /* use default length */
          statement::CreateTable *statement=
            (statement::CreateTable *)Lex->statement;

          if (statement->current_proto_field)
          {
            if ((yyvsp[(1) - (1)].num) == DRIZZLE_TYPE_LONG)
              statement->current_proto_field->set_type(message::Table::Field::INTEGER);
            else if ((yyvsp[(1) - (1)].num) == DRIZZLE_TYPE_LONGLONG)
              statement->current_proto_field->set_type(message::Table::Field::BIGINT);
            else
              abort();
          }
          }
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 1499 "sql_yacc.yy"
    {
            (yyval.num)=(yyvsp[(1) - (2)].num);

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
            {
              assert ((yyvsp[(1) - (2)].num) == DRIZZLE_TYPE_DOUBLE);
              statement->current_proto_field->set_type(message::Table::Field::DOUBLE);
            }
          }
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 1512 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              (yyval.num)=DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
            {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
            }
            }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 1530 "sql_yacc.yy"
    {
              Lex->length=(char*) "1";
              (yyval.num)=DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
            }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 1541 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              (yyval.num)= DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
	    {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);

              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
            }
            }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 1560 "sql_yacc.yy"
    {
              Lex->length=(yyvsp[(3) - (4)].lex_str).str;
              Lex->charset=&my_charset_bin;
              (yyval.num)= DRIZZLE_TYPE_VARCHAR;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
	    {
              statement->current_proto_field->set_type(message::Table::Field::VARCHAR);
              message::Table::Field::StringFieldOptions *string_field_options;

              string_field_options= statement->current_proto_field->mutable_string_options();

              string_field_options->set_length(atoi((yyvsp[(3) - (4)].lex_str).str));
              string_field_options->set_collation_id(my_charset_bin.number);
              string_field_options->set_collation(my_charset_bin.name);
            }
            }
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 1581 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DATE;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DATE);
          }
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 1591 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_TIMESTAMP;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::TIMESTAMP);
          }
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 1601 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DATETIME;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DATETIME);
          }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 1611 "sql_yacc.yy"
    {
              Lex->charset=&my_charset_bin;
              (yyval.num)=DRIZZLE_TYPE_BLOB;
              Lex->length=(char*) 0; /* use default length */

              statement::CreateTable *statement=
                (statement::CreateTable *)Lex->statement;

              if (statement->current_proto_field)
              {
                statement->current_proto_field->set_type(message::Table::Field::BLOB);
                message::Table::Field::StringFieldOptions *string_field_options;

                string_field_options= statement->current_proto_field->mutable_string_options();
                string_field_options->set_collation_id(my_charset_bin.number);
                string_field_options->set_collation(my_charset_bin.name);
              }
            }
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 1630 "sql_yacc.yy"
    {
              (yyval.num)=DRIZZLE_TYPE_BLOB;
              Lex->length=(char*) 0; /* use default length */

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::BLOB);
            }
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 1641 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 1651 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 1661 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_DECIMAL;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::DECIMAL);
          }
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 1671 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 1673 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_ENUM;

            statement::CreateTable *statement=
              (statement::CreateTable *)Lex->statement;

            if (statement->current_proto_field)
              statement->current_proto_field->set_type(message::Table::Field::ENUM);
          }
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 1683 "sql_yacc.yy"
    {
            (yyval.num)=DRIZZLE_TYPE_LONGLONG;
            Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG);

            statement::CreateTable *statement= (statement::CreateTable *)Lex->statement;
            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);

              statement->current_proto_field->set_type(message::Table::Field::BIGINT);
            }
          }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 1700 "sql_yacc.yy"
    {}
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 1704 "sql_yacc.yy"
    {}
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 1705 "sql_yacc.yy"
    {}
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 1709 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_LONG; }
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 1710 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_LONGLONG; }
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 1715 "sql_yacc.yy"
    {
            (yyval.num)= DRIZZLE_TYPE_DOUBLE;
          }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 1719 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_DOUBLE; }
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 1721 "sql_yacc.yy"
    { (yyval.num)=DRIZZLE_TYPE_DOUBLE; }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 1726 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 1728 "sql_yacc.yy"
    { Lex->length=(yyvsp[(2) - (3)].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 1730 "sql_yacc.yy"
    {}
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 1735 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->length=(yyvsp[(2) - (5)].lex_str).str;
            lex->dec=(yyvsp[(4) - (5)].lex_str).str;
          }
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 1743 "sql_yacc.yy"
    { Lex->length=(char*) 0; /* use default length */ }
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 1744 "sql_yacc.yy"
    { Lex->length= (yyvsp[(2) - (3)].lex_str).str; }
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 1748 "sql_yacc.yy"
    {}
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 1749 "sql_yacc.yy"
    {}
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 1753 "sql_yacc.yy"
    {}
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 1754 "sql_yacc.yy"
    {}
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 1758 "sql_yacc.yy"
    {}
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 1764 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Lex->type&= ~ NOT_NULL_FLAG;

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(true);
            }
          }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 1776 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->column_format= (yyvsp[(2) - (2)].column_format_type);
            statement->alter_info.flags.set(ALTER_COLUMN_FORMAT);
          }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 1783 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            Lex->type|= NOT_NULL_FLAG;

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 1795 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->default_value=(yyvsp[(2) - (2)].item);
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 1802 "sql_yacc.yy"
    { ((statement::AlterTable *)Lex->statement)->on_update_value= new Item_func_now_local(); }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 1804 "sql_yacc.yy"
    {
            Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG;

            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;

              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 1817 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 1832 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);

            if (statement->current_proto_field)
            {
              message::Table::Field::FieldConstraints *constraints;
              constraints= statement->current_proto_field->mutable_constraints();
              constraints->set_is_nullable(false);
            }
          }
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 1847 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= UNIQUE_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 1855 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            lex->type|= UNIQUE_KEY_FLAG;
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 1863 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->comment= (yyvsp[(2) - (2)].lex_str);

            if (statement->current_proto_field)
              statement->current_proto_field->set_comment((yyvsp[(2) - (2)].lex_str).str);
          }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 1871 "sql_yacc.yy"
    {
            if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[(2) - (2)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(2) - (2)].charset)->name,Lex->charset->csname);
              DRIZZLE_YYABORT;
            }
            else
            {
              Lex->charset=(yyvsp[(2) - (2)].charset);
            }
          }
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 1887 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 1889 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 1894 "sql_yacc.yy"
    {
            if (!((yyval.charset)=get_charset_by_name((yyvsp[(1) - (1)].lex_str).str)))
            {
              my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 1904 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[(1) - (1)].charset); }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 1905 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 1909 "sql_yacc.yy"
    {}
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 1910 "sql_yacc.yy"
    {}
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 1924 "sql_yacc.yy"
    {
            (yyval.table)=(yyvsp[(2) - (5)].table);
          }
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 1931 "sql_yacc.yy"
    { Lex->ref_list.empty(); }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 1937 "sql_yacc.yy"
    { Lex->ref_list.push_back(new Key_part_spec((yyvsp[(3) - (3)].lex_str), 0)); }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 1939 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->ref_list.empty();
            lex->ref_list.push_back(new Key_part_spec((yyvsp[(1) - (1)].lex_str), 0));
          }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 1948 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= drizzled::message::Table::ForeignKeyConstraint::MATCH_UNDEFINED; }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 1950 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= drizzled::message::Table::ForeignKeyConstraint::MATCH_FULL; }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 1952 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= drizzled::message::Table::ForeignKeyConstraint::MATCH_PARTIAL; }
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 1954 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->fk_match_option= drizzled::message::Table::ForeignKeyConstraint::MATCH_SIMPLE; }
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 1959 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= drizzled::message::Table::ForeignKeyConstraint::OPTION_UNDEF;
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= drizzled::message::Table::ForeignKeyConstraint::OPTION_UNDEF;
          }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 1964 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(3) - (3)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= drizzled::message::Table::ForeignKeyConstraint::OPTION_UNDEF;
          }
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 1969 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= drizzled::message::Table::ForeignKeyConstraint::OPTION_UNDEF;
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(3) - (3)].m_fk_option);
          }
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 1975 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(3) - (6)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(6) - (6)].m_fk_option);
          }
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 1981 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->fk_update_opt= (yyvsp[(6) - (6)].m_fk_option);
            ((statement::CreateTable *)Lex->statement)->fk_delete_opt= (yyvsp[(3) - (6)].m_fk_option);
          }
    break;

  case 179:

/* Line 1455 of yacc.c  */
#line 1988 "sql_yacc.yy"
    { (yyval.m_fk_option)= drizzled::message::Table::ForeignKeyConstraint::OPTION_RESTRICT; }
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 1989 "sql_yacc.yy"
    { (yyval.m_fk_option)= drizzled::message::Table::ForeignKeyConstraint::OPTION_CASCADE; }
    break;

  case 181:

/* Line 1455 of yacc.c  */
#line 1990 "sql_yacc.yy"
    { (yyval.m_fk_option)= drizzled::message::Table::ForeignKeyConstraint::OPTION_SET_NULL; }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 1991 "sql_yacc.yy"
    { (yyval.m_fk_option)= drizzled::message::Table::ForeignKeyConstraint::OPTION_NO_ACTION; }
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 1992 "sql_yacc.yy"
    { (yyval.m_fk_option)= drizzled::message::Table::ForeignKeyConstraint::OPTION_DEFAULT;  }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 1996 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 2000 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 2001 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 2005 "sql_yacc.yy"
    {}
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 2006 "sql_yacc.yy"
    {}
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 2010 "sql_yacc.yy"
    {}
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 2015 "sql_yacc.yy"
    {}
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 2016 "sql_yacc.yy"
    {}
    break;

  case 193:

/* Line 1455 of yacc.c  */
#line 2017 "sql_yacc.yy"
    {}
    break;

  case 194:

/* Line 1455 of yacc.c  */
#line 2021 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 195:

/* Line 1455 of yacc.c  */
#line 2022 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 196:

/* Line 1455 of yacc.c  */
#line 2026 "sql_yacc.yy"
    {
            ((statement::CreateTable *)Lex->statement)->key_create_info= default_key_create_info;
          }
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 2043 "sql_yacc.yy"
    {}
    break;

  case 203:

/* Line 1455 of yacc.c  */
#line 2053 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.algorithm= (yyvsp[(2) - (2)].key_alg); }
    break;

  case 204:

/* Line 1455 of yacc.c  */
#line 2054 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.algorithm= (yyvsp[(2) - (2)].key_alg); }
    break;

  case 206:

/* Line 1455 of yacc.c  */
#line 2060 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.block_size= (yyvsp[(3) - (3)].ulong_num); }
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 2062 "sql_yacc.yy"
    { ((statement::CreateTable *)Lex->statement)->key_create_info.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 2066 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 209:

/* Line 1455 of yacc.c  */
#line 2067 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 2071 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[(3) - (4)].key_part)); }
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 2072 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[(1) - (2)].key_part)); }
    break;

  case 212:

/* Line 1455 of yacc.c  */
#line 2076 "sql_yacc.yy"
    { (yyval.key_part)=new Key_part_spec((yyvsp[(1) - (1)].lex_str), 0); }
    break;

  case 213:

/* Line 1455 of yacc.c  */
#line 2078 "sql_yacc.yy"
    {
            int key_part_len= atoi((yyvsp[(3) - (4)].lex_str).str);
            if (!key_part_len)
            {
              my_error(ER_KEY_PART_0, MYF(0), (yyvsp[(1) - (4)].lex_str).str);
            }
            (yyval.key_part)=new Key_part_spec((yyvsp[(1) - (4)].lex_str), (uint) key_part_len);
          }
    break;

  case 214:

/* Line 1455 of yacc.c  */
#line 2089 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 215:

/* Line 1455 of yacc.c  */
#line 2090 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 216:

/* Line 1455 of yacc.c  */
#line 2094 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 217:

/* Line 1455 of yacc.c  */
#line 2095 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 218:

/* Line 1455 of yacc.c  */
#line 2099 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[(1) - (1)].string)); }
    break;

  case 219:

/* Line 1455 of yacc.c  */
#line 2100 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[(3) - (3)].string)); }
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 2108 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            lex->name.str= 0;
            lex->name.length= 0;
            lex->sql_command= SQLCOM_ALTER_TABLE;
            statement::AlterTable *statement= new(std::nothrow) statement::AlterTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_ERROR;
            if (!lex->select_lex.add_table_to_list(session, (yyvsp[(5) - (5)].table), NULL,
                                                   TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
            lex->col_list.empty();
            lex->select_lex.init_order();
            lex->select_lex.db=
              ((TableList*) lex->select_lex.table_list.first)->db;
            statement->alter_info.build_method= (yyvsp[(2) - (5)].build_method);
          }
    break;

  case 221:

/* Line 1455 of yacc.c  */
#line 2129 "sql_yacc.yy"
    {}
    break;

  case 222:

/* Line 1455 of yacc.c  */
#line 2131 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command=SQLCOM_ALTER_DB;
            lex->statement= new(std::nothrow) statement::AlterSchema(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 223:

/* Line 1455 of yacc.c  */
#line 2139 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->name= (yyvsp[(3) - (5)].lex_str);
            if (lex->name.str == NULL &&
                lex->copy_db_to(&lex->name.str, &lex->name.length))
              DRIZZLE_YYABORT;
          }
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 2149 "sql_yacc.yy"
    { (yyval.lex_str).str= 0; (yyval.lex_str).length= 0; }
    break;

  case 225:

/* Line 1455 of yacc.c  */
#line 2150 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 227:

/* Line 1455 of yacc.c  */
#line 2156 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->alter_info.tablespace_op= DISCARD_TABLESPACE;
          }
    break;

  case 228:

/* Line 1455 of yacc.c  */
#line 2161 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->alter_info.tablespace_op= IMPORT_TABLESPACE;
          }
    break;

  case 230:

/* Line 1455 of yacc.c  */
#line 2170 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_DEFAULT;
          }
    break;

  case 231:

/* Line 1455 of yacc.c  */
#line 2174 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_ONLINE;
          }
    break;

  case 232:

/* Line 1455 of yacc.c  */
#line 2178 "sql_yacc.yy"
    {
            (yyval.build_method)= HA_BUILD_OFFLINE;
          }
    break;

  case 235:

/* Line 1455 of yacc.c  */
#line 2190 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->change=0;
            statement->alter_info.flags.set(ALTER_ADD_COLUMN);
          }
    break;

  case 236:

/* Line 1455 of yacc.c  */
#line 2199 "sql_yacc.yy"
    { }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 2201 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 238:

/* Line 1455 of yacc.c  */
#line 2207 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ADD_COLUMN);
            statement->alter_info.flags.set(ALTER_ADD_INDEX);
          }
    break;

  case 239:

/* Line 1455 of yacc.c  */
#line 2214 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->change= (yyvsp[(3) - (3)].lex_str).str;
            statement->alter_info.flags.set(ALTER_CHANGE_COLUMN);
          }
    break;

  case 241:

/* Line 1455 of yacc.c  */
#line 2221 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            lex->length=lex->dec=0; lex->type=0;
            statement->default_value= statement->on_update_value= 0;
            statement->comment= null_lex_str;
            lex->charset= NULL;
            statement->alter_info.flags.set(ALTER_CHANGE_COLUMN);
            statement->column_format= COLUMN_FORMAT_TYPE_DEFAULT;

            statement->current_proto_field= NULL;
          }
    break;

  case 242:

/* Line 1455 of yacc.c  */
#line 2234 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            if (add_field_to_list(lex->session,&(yyvsp[(3) - (5)].lex_str),
                                  (enum enum_field_types) (yyvsp[(5) - (5)].num),
                                  lex->length, lex->dec, lex->type,
                                  statement->column_format,
                                  statement->default_value,
                                  statement->on_update_value,
                                  &statement->comment,
                                  (yyvsp[(3) - (5)].lex_str).str, &lex->interval_list, lex->charset))
              DRIZZLE_YYABORT;
          }
    break;

  case 244:

/* Line 1455 of yacc.c  */
#line 2250 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::COLUMN, (yyvsp[(3) - (3)].lex_str).str));
            statement->alter_info.flags.set(ALTER_DROP_COLUMN);
          }
    break;

  case 245:

/* Line 1455 of yacc.c  */
#line 2257 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::FOREIGN_KEY,
                                                                    (yyvsp[(4) - (4)].lex_str).str));
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
            statement->alter_info.flags.set(ALTER_FOREIGN_KEY);
          }
    break;

  case 246:

/* Line 1455 of yacc.c  */
#line 2265 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY,
                                                               "PRIMARY"));
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
          }
    break;

  case 247:

/* Line 1455 of yacc.c  */
#line 2273 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY,
                                                                    (yyvsp[(3) - (3)].lex_str).str));
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
          }
    break;

  case 248:

/* Line 1455 of yacc.c  */
#line 2281 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.keys_onoff= DISABLE;
            statement->alter_info.flags.set(ALTER_KEYS_ONOFF);
          }
    break;

  case 249:

/* Line 1455 of yacc.c  */
#line 2288 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.keys_onoff= ENABLE;
            statement->alter_info.flags.set(ALTER_KEYS_ONOFF);
          }
    break;

  case 250:

/* Line 1455 of yacc.c  */
#line 2295 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.alter_list.push_back(new AlterColumn((yyvsp[(3) - (6)].lex_str).str,(yyvsp[(6) - (6)].item)));
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 251:

/* Line 1455 of yacc.c  */
#line 2302 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.alter_list.push_back(new AlterColumn((yyvsp[(3) - (5)].lex_str).str, (Item*) 0));
            statement->alter_info.flags.set(ALTER_COLUMN_DEFAULT);
          }
    break;

  case 252:

/* Line 1455 of yacc.c  */
#line 2309 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;
            size_t dummy;

            lex->select_lex.db=(yyvsp[(3) - (3)].table)->db.str;
            if (lex->select_lex.db == NULL &&
                lex->copy_db_to(&lex->select_lex.db, &dummy))
            {
              DRIZZLE_YYABORT;
            }

            if (check_table_name((yyvsp[(3) - (3)].table)->table.str,(yyvsp[(3) - (3)].table)->table.length))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(3) - (3)].table)->table.str);
              DRIZZLE_YYABORT;
            }

            lex->name= (yyvsp[(3) - (3)].table)->table;
            statement->alter_info.flags.set(ALTER_RENAME);
          }
    break;

  case 253:

/* Line 1455 of yacc.c  */
#line 2331 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->create_info.table_charset=
            statement->create_info.default_table_charset= (yyvsp[(3) - (3)].charset);
            statement->create_info.used_fields|= (HA_CREATE_USED_CHARSET |
              HA_CREATE_USED_DEFAULT_CHARSET);
            statement->alter_info.flags.set(ALTER_CONVERT);
          }
    break;

  case 254:

/* Line 1455 of yacc.c  */
#line 2341 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_OPTIONS);
          }
    break;

  case 255:

/* Line 1455 of yacc.c  */
#line 2347 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_FORCE);
          }
    break;

  case 256:

/* Line 1455 of yacc.c  */
#line 2353 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            statement->alter_info.flags.set(ALTER_ORDER);
          }
    break;

  case 257:

/* Line 1455 of yacc.c  */
#line 2361 "sql_yacc.yy"
    {}
    break;

  case 258:

/* Line 1455 of yacc.c  */
#line 2362 "sql_yacc.yy"
    {}
    break;

  case 259:

/* Line 1455 of yacc.c  */
#line 2366 "sql_yacc.yy"
    { Lex->ignore= 0;}
    break;

  case 260:

/* Line 1455 of yacc.c  */
#line 2367 "sql_yacc.yy"
    { Lex->ignore= 1;}
    break;

  case 261:

/* Line 1455 of yacc.c  */
#line 2371 "sql_yacc.yy"
    {}
    break;

  case 262:

/* Line 1455 of yacc.c  */
#line 2373 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            store_position_for_column((yyvsp[(2) - (2)].lex_str).str);
            statement->alter_info.flags.set(ALTER_COLUMN_ORDER);
          }
    break;

  case 263:

/* Line 1455 of yacc.c  */
#line 2380 "sql_yacc.yy"
    {
            statement::AlterTable *statement= (statement::AlterTable *)Lex->statement;

            store_position_for_column(first_keyword);
            statement->alter_info.flags.set(ALTER_COLUMN_ORDER);
          }
    break;

  case 264:

/* Line 1455 of yacc.c  */
#line 2389 "sql_yacc.yy"
    {}
    break;

  case 265:

/* Line 1455 of yacc.c  */
#line 2390 "sql_yacc.yy"
    {}
    break;

  case 266:

/* Line 1455 of yacc.c  */
#line 2391 "sql_yacc.yy"
    {}
    break;

  case 267:

/* Line 1455 of yacc.c  */
#line 2392 "sql_yacc.yy"
    {}
    break;

  case 268:

/* Line 1455 of yacc.c  */
#line 2397 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_BEGIN;
            lex->statement= new(std::nothrow) statement::StartTransaction(YYSession, (start_transaction_option_t)(yyvsp[(3) - (3)].num));
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 269:

/* Line 1455 of yacc.c  */
#line 2407 "sql_yacc.yy"
    { (yyval.num) = START_TRANS_NO_OPTIONS; }
    break;

  case 270:

/* Line 1455 of yacc.c  */
#line 2409 "sql_yacc.yy"
    {
            (yyval.num)= START_TRANS_OPT_WITH_CONS_SNAPSHOT;
          }
    break;

  case 271:

/* Line 1455 of yacc.c  */
#line 2416 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_ANALYZE;
            lex->statement= new(std::nothrow) statement::Analyze(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 272:

/* Line 1455 of yacc.c  */
#line 2424 "sql_yacc.yy"
    {}
    break;

  case 273:

/* Line 1455 of yacc.c  */
#line 2429 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            lex->sql_command = SQLCOM_CHECK;
            lex->statement= new(std::nothrow) statement::Check(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 274:

/* Line 1455 of yacc.c  */
#line 2438 "sql_yacc.yy"
    {}
    break;

  case 275:

/* Line 1455 of yacc.c  */
#line 2443 "sql_yacc.yy"
    {
            Lex->sql_command= SQLCOM_RENAME_TABLE;
            Lex->statement= new(std::nothrow) statement::RenameTable(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 276:

/* Line 1455 of yacc.c  */
#line 2450 "sql_yacc.yy"
    {}
    break;

  case 279:

/* Line 1455 of yacc.c  */
#line 2460 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            Select_Lex *sl= lex->current_select;
            if (!sl->add_table_to_list(lex->session, (yyvsp[(1) - (3)].table),NULL,TL_OPTION_UPDATING,
                                       TL_IGNORE) ||
                !sl->add_table_to_list(lex->session, (yyvsp[(3) - (3)].table),NULL,TL_OPTION_UPDATING,
                                       TL_IGNORE))
              DRIZZLE_YYABORT;
          }
    break;

  case 280:

/* Line 1455 of yacc.c  */
#line 2478 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_SELECT;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 283:

/* Line 1455 of yacc.c  */
#line 2495 "sql_yacc.yy"
    {
            if (setup_select_in_parentheses(YYSession, Lex))
              DRIZZLE_YYABORT;
          }
    break;

  case 285:

/* Line 1455 of yacc.c  */
#line 2505 "sql_yacc.yy"
    {
            if (setup_select_in_parentheses(YYSession, Lex))
              DRIZZLE_YYABORT;
          }
    break;

  case 287:

/* Line 1455 of yacc.c  */
#line 2514 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex * sel= lex->current_select;
            if (lex->current_select->set_braces(0))
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            if (sel->linkage == UNION_TYPE &&
                sel->master_unit()->first_select()->braces)
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 289:

/* Line 1455 of yacc.c  */
#line 2535 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if (sel->linkage != UNION_TYPE)
              mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 290:

/* Line 1455 of yacc.c  */
#line 2543 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 292:

/* Line 1455 of yacc.c  */
#line 2550 "sql_yacc.yy"
    {}
    break;

  case 297:

/* Line 1455 of yacc.c  */
#line 2560 "sql_yacc.yy"
    {
            Lex->current_select->context.table_list=
              Lex->current_select->context.first_name_resolution_table=
                reinterpret_cast<TableList *>(Lex->current_select->table_list.first);
          }
    break;

  case 299:

/* Line 1455 of yacc.c  */
#line 2570 "sql_yacc.yy"
    {
            if (Lex->current_select->options & SELECT_DISTINCT &&
                Lex->current_select->options & SELECT_ALL)
            {
              my_error(ER_WRONG_USAGE, MYF(0), "ALL", "DISTINCT");
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 302:

/* Line 1455 of yacc.c  */
#line 2586 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_STRAIGHT_JOIN; }
    break;

  case 303:

/* Line 1455 of yacc.c  */
#line 2587 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_DISTINCT; }
    break;

  case 304:

/* Line 1455 of yacc.c  */
#line 2588 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_SMALL_RESULT; }
    break;

  case 305:

/* Line 1455 of yacc.c  */
#line 2589 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_BIG_RESULT; }
    break;

  case 306:

/* Line 1455 of yacc.c  */
#line 2591 "sql_yacc.yy"
    {
            if (check_simple_select())
              DRIZZLE_YYABORT;
            Lex->current_select->options|= OPTION_BUFFER_RESULT;
          }
    break;

  case 307:

/* Line 1455 of yacc.c  */
#line 2597 "sql_yacc.yy"
    {
            if (check_simple_select())
              DRIZZLE_YYABORT;
            Lex->current_select->options|= OPTION_FOUND_ROWS;
          }
    break;

  case 308:

/* Line 1455 of yacc.c  */
#line 2602 "sql_yacc.yy"
    { Lex->current_select->options|= SELECT_ALL; }
    break;

  case 310:

/* Line 1455 of yacc.c  */
#line 2608 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->set_lock_for_tables(TL_WRITE);
          }
    break;

  case 311:

/* Line 1455 of yacc.c  */
#line 2613 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->
              set_lock_for_tables(TL_READ_WITH_SHARED_LOCKS);
          }
    break;

  case 314:

/* Line 1455 of yacc.c  */
#line 2624 "sql_yacc.yy"
    {
            Session *session= YYSession;
            if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                          context,
                                                          NULL, NULL, "*")))
              DRIZZLE_YYABORT;
            (session->lex->current_select->with_wild)++;
          }
    break;

  case 315:

/* Line 1455 of yacc.c  */
#line 2636 "sql_yacc.yy"
    {
            Session *session= YYSession;

            if (session->add_item_to_list((yyvsp[(2) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 316:

/* Line 1455 of yacc.c  */
#line 2643 "sql_yacc.yy"
    {
            Session *session= YYSession;
            assert((yyvsp[(1) - (4)].simple_string) < (yyvsp[(3) - (4)].simple_string));

            if (session->add_item_to_list((yyvsp[(2) - (4)].item)))
              DRIZZLE_YYABORT;
            if ((yyvsp[(4) - (4)].lex_str).str)
            {
              (yyvsp[(2) - (4)].item)->is_autogenerated_name= false;
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(4) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).length, system_charset_info);
            }
            else if (!(yyvsp[(2) - (4)].item)->name)
            {
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(1) - (4)].simple_string), (uint) ((yyvsp[(3) - (4)].simple_string) - (yyvsp[(1) - (4)].simple_string)), session->charset());
            }
          }
    break;

  case 317:

/* Line 1455 of yacc.c  */
#line 2662 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            (yyval.simple_string)= (char*) lip->get_cpp_tok_start();
          }
    break;

  case 318:

/* Line 1455 of yacc.c  */
#line 2670 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            (yyval.simple_string)= (char*) lip->get_cpp_tok_end();
          }
    break;

  case 319:

/* Line 1455 of yacc.c  */
#line 2678 "sql_yacc.yy"
    { (yyval.lex_str)=null_lex_str;}
    break;

  case 320:

/* Line 1455 of yacc.c  */
#line 2679 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 321:

/* Line 1455 of yacc.c  */
#line 2680 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str); }
    break;

  case 322:

/* Line 1455 of yacc.c  */
#line 2681 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 323:

/* Line 1455 of yacc.c  */
#line 2682 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 324:

/* Line 1455 of yacc.c  */
#line 2686 "sql_yacc.yy"
    {}
    break;

  case 325:

/* Line 1455 of yacc.c  */
#line 2687 "sql_yacc.yy"
    {}
    break;

  case 326:

/* Line 1455 of yacc.c  */
#line 2693 "sql_yacc.yy"
    {
            /*
              Design notes:
              Do not use a manually maintained stack like session->lex->xxx_list,
              but use the internal bison stack ($$, $1 and $3) instead.
              Using the bison stack is:
              - more robust to changes in the grammar,
              - guaranteed to be in sync with the parser state,
              - better for performances (no memory allocation).
            */
            Item_cond_or *item1;
            Item_cond_or *item3;
            if (is_cond_or((yyvsp[(1) - (3)].item)))
            {
              item1= (Item_cond_or*) (yyvsp[(1) - (3)].item);
              if (is_cond_or((yyvsp[(3) - (3)].item)))
              {
                item3= (Item_cond_or*) (yyvsp[(3) - (3)].item);
                /*
                  (X1 OR X2) OR (Y1 OR Y2) ==> OR (X1, X2, Y1, Y2)
                */
                item3->add_at_head(item1->argument_list());
                (yyval.item) = (yyvsp[(3) - (3)].item);
              }
              else
              {
                /*
                  (X1 OR X2) OR Y ==> OR (X1, X2, Y)
                */
                item1->add((yyvsp[(3) - (3)].item));
                (yyval.item) = (yyvsp[(1) - (3)].item);
              }
            }
            else if (is_cond_or((yyvsp[(3) - (3)].item)))
            {
              item3= (Item_cond_or*) (yyvsp[(3) - (3)].item);
              /*
                X OR (Y1 OR Y2) ==> OR (X, Y1, Y2)
              */
              item3->add_at_head((yyvsp[(1) - (3)].item));
              (yyval.item) = (yyvsp[(3) - (3)].item);
            }
            else
            {
              /* X OR Y */
              (yyval.item) = new (YYSession->mem_root) Item_cond_or((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
            }
          }
    break;

  case 327:

/* Line 1455 of yacc.c  */
#line 2742 "sql_yacc.yy"
    {
            /* XOR is a proprietary extension */
            (yyval.item) = new (YYSession->mem_root) Item_cond_xor((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
          }
    break;

  case 328:

/* Line 1455 of yacc.c  */
#line 2747 "sql_yacc.yy"
    {
            /* See comments in rule expr: expr or expr */
            Item_cond_and *item1;
            Item_cond_and *item3;
            if (is_cond_and((yyvsp[(1) - (3)].item)))
            {
              item1= (Item_cond_and*) (yyvsp[(1) - (3)].item);
              if (is_cond_and((yyvsp[(3) - (3)].item)))
              {
                item3= (Item_cond_and*) (yyvsp[(3) - (3)].item);
                /*
                  (X1 AND X2) AND (Y1 AND Y2) ==> AND (X1, X2, Y1, Y2)
                */
                item3->add_at_head(item1->argument_list());
                (yyval.item) = (yyvsp[(3) - (3)].item);
              }
              else
              {
                /*
                  (X1 AND X2) AND Y ==> AND (X1, X2, Y)
                */
                item1->add((yyvsp[(3) - (3)].item));
                (yyval.item) = (yyvsp[(1) - (3)].item);
              }
            }
            else if (is_cond_and((yyvsp[(3) - (3)].item)))
            {
              item3= (Item_cond_and*) (yyvsp[(3) - (3)].item);
              /*
                X AND (Y1 AND Y2) ==> AND (X, Y1, Y2)
              */
              item3->add_at_head((yyvsp[(1) - (3)].item));
              (yyval.item) = (yyvsp[(3) - (3)].item);
            }
            else
            {
              /* X AND Y */
              (yyval.item) = new (YYSession->mem_root) Item_cond_and((yyvsp[(1) - (3)].item), (yyvsp[(3) - (3)].item));
            }
          }
    break;

  case 329:

/* Line 1455 of yacc.c  */
#line 2788 "sql_yacc.yy"
    { (yyval.item)= negate_expression(YYSession, (yyvsp[(2) - (2)].item)); }
    break;

  case 330:

/* Line 1455 of yacc.c  */
#line 2790 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_istrue((yyvsp[(1) - (3)].item)); }
    break;

  case 331:

/* Line 1455 of yacc.c  */
#line 2792 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isnottrue((yyvsp[(1) - (4)].item)); }
    break;

  case 332:

/* Line 1455 of yacc.c  */
#line 2794 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isfalse((yyvsp[(1) - (3)].item)); }
    break;

  case 333:

/* Line 1455 of yacc.c  */
#line 2796 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_isnotfalse((yyvsp[(1) - (4)].item)); }
    break;

  case 334:

/* Line 1455 of yacc.c  */
#line 2798 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnull((yyvsp[(1) - (3)].item)); }
    break;

  case 335:

/* Line 1455 of yacc.c  */
#line 2800 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnotnull((yyvsp[(1) - (4)].item)); }
    break;

  case 337:

/* Line 1455 of yacc.c  */
#line 2806 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnull((yyvsp[(1) - (3)].item)); }
    break;

  case 338:

/* Line 1455 of yacc.c  */
#line 2808 "sql_yacc.yy"
    { (yyval.item)= new Item_func_isnotnull((yyvsp[(1) - (4)].item)); }
    break;

  case 339:

/* Line 1455 of yacc.c  */
#line 2810 "sql_yacc.yy"
    { (yyval.item)= new Item_func_equal((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 340:

/* Line 1455 of yacc.c  */
#line 2812 "sql_yacc.yy"
    { (yyval.item)= (*(yyvsp[(2) - (3)].boolfunc2creator))(0)->create((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 341:

/* Line 1455 of yacc.c  */
#line 2814 "sql_yacc.yy"
    { (yyval.item)= all_any_subquery_creator((yyvsp[(1) - (6)].item), (yyvsp[(2) - (6)].boolfunc2creator), (yyvsp[(3) - (6)].num), (yyvsp[(5) - (6)].select_lex)); }
    break;

  case 343:

/* Line 1455 of yacc.c  */
#line 2820 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_in_subselect((yyvsp[(1) - (5)].item), (yyvsp[(4) - (5)].select_lex));
          }
    break;

  case 344:

/* Line 1455 of yacc.c  */
#line 2824 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Item *item= new (session->mem_root) Item_in_subselect((yyvsp[(1) - (6)].item), (yyvsp[(5) - (6)].select_lex));
            (yyval.item)= negate_expression(session, item);
          }
    break;

  case 345:

/* Line 1455 of yacc.c  */
#line 2830 "sql_yacc.yy"
    {
            (yyval.item)= handle_sql2003_note184_exception(YYSession, (yyvsp[(1) - (5)].item), true, (yyvsp[(4) - (5)].item));
          }
    break;

  case 346:

/* Line 1455 of yacc.c  */
#line 2834 "sql_yacc.yy"
    {
            (yyvsp[(6) - (7)].item_list)->push_front((yyvsp[(4) - (7)].item));
            (yyvsp[(6) - (7)].item_list)->push_front((yyvsp[(1) - (7)].item));
            (yyval.item)= new (YYSession->mem_root) Item_func_in(*(yyvsp[(6) - (7)].item_list));
          }
    break;

  case 347:

/* Line 1455 of yacc.c  */
#line 2840 "sql_yacc.yy"
    {
            (yyval.item)= handle_sql2003_note184_exception(YYSession, (yyvsp[(1) - (6)].item), false, (yyvsp[(5) - (6)].item));
          }
    break;

  case 348:

/* Line 1455 of yacc.c  */
#line 2844 "sql_yacc.yy"
    {
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(5) - (8)].item));
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(1) - (8)].item));
            Item_func_in *item = new (YYSession->mem_root) Item_func_in(*(yyvsp[(7) - (8)].item_list));
            item->negate();
            (yyval.item)= item;
          }
    break;

  case 349:

/* Line 1455 of yacc.c  */
#line 2852 "sql_yacc.yy"
    { (yyval.item)= new Item_func_between((yyvsp[(1) - (5)].item),(yyvsp[(3) - (5)].item),(yyvsp[(5) - (5)].item)); }
    break;

  case 350:

/* Line 1455 of yacc.c  */
#line 2854 "sql_yacc.yy"
    {
            Item_func_between *item= new Item_func_between((yyvsp[(1) - (6)].item),(yyvsp[(4) - (6)].item),(yyvsp[(6) - (6)].item));
            item->negate();
            (yyval.item)= item;
          }
    break;

  case 351:

/* Line 1455 of yacc.c  */
#line 2860 "sql_yacc.yy"
    { (yyval.item)= new Item_func_like((yyvsp[(1) - (4)].item),(yyvsp[(3) - (4)].item),(yyvsp[(4) - (4)].item),Lex->escape_used); }
    break;

  case 352:

/* Line 1455 of yacc.c  */
#line 2862 "sql_yacc.yy"
    { (yyval.item)= new Item_func_not(new Item_func_like((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].item), Lex->escape_used)); }
    break;

  case 354:

/* Line 1455 of yacc.c  */
#line 2868 "sql_yacc.yy"
    { (yyval.item)= new Item_func_plus((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 355:

/* Line 1455 of yacc.c  */
#line 2870 "sql_yacc.yy"
    { (yyval.item)= new Item_func_minus((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 356:

/* Line 1455 of yacc.c  */
#line 2872 "sql_yacc.yy"
    { (yyval.item)= new Item_date_add_interval((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].interval),0); }
    break;

  case 357:

/* Line 1455 of yacc.c  */
#line 2874 "sql_yacc.yy"
    { (yyval.item)= new Item_date_add_interval((yyvsp[(1) - (5)].item),(yyvsp[(4) - (5)].item),(yyvsp[(5) - (5)].interval),1); }
    break;

  case 358:

/* Line 1455 of yacc.c  */
#line 2876 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mul((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 359:

/* Line 1455 of yacc.c  */
#line 2878 "sql_yacc.yy"
    { (yyval.item)= new Item_func_div(YYSession,(yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 360:

/* Line 1455 of yacc.c  */
#line 2880 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mod((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 361:

/* Line 1455 of yacc.c  */
#line 2882 "sql_yacc.yy"
    { (yyval.item)= new Item_func_int_div((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 362:

/* Line 1455 of yacc.c  */
#line 2884 "sql_yacc.yy"
    { (yyval.item)= new Item_func_mod((yyvsp[(1) - (3)].item),(yyvsp[(3) - (3)].item)); }
    break;

  case 367:

/* Line 1455 of yacc.c  */
#line 2901 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_eq_creator; }
    break;

  case 368:

/* Line 1455 of yacc.c  */
#line 2902 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_ge_creator; }
    break;

  case 369:

/* Line 1455 of yacc.c  */
#line 2903 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_gt_creator; }
    break;

  case 370:

/* Line 1455 of yacc.c  */
#line 2904 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_le_creator; }
    break;

  case 371:

/* Line 1455 of yacc.c  */
#line 2905 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_lt_creator; }
    break;

  case 372:

/* Line 1455 of yacc.c  */
#line 2906 "sql_yacc.yy"
    { (yyval.boolfunc2creator) = &comp_ne_creator; }
    break;

  case 373:

/* Line 1455 of yacc.c  */
#line 2910 "sql_yacc.yy"
    { (yyval.num) = 1; }
    break;

  case 374:

/* Line 1455 of yacc.c  */
#line 2911 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 380:

/* Line 1455 of yacc.c  */
#line 2921 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Item *i1= new (session->mem_root) Item_string((yyvsp[(3) - (3)].lex_str).str,
                                                      (yyvsp[(3) - (3)].lex_str).length,
                                                      session->charset());
            (yyval.item)= new (session->mem_root) Item_func_set_collation((yyvsp[(1) - (3)].item), i1);
          }
    break;

  case 383:

/* Line 1455 of yacc.c  */
#line 2931 "sql_yacc.yy"
    {
            Lex->setSumExprUsed();
          }
    break;

  case 384:

/* Line 1455 of yacc.c  */
#line 2934 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (2)].item); }
    break;

  case 385:

/* Line 1455 of yacc.c  */
#line 2936 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_neg((yyvsp[(2) - (2)].item)); }
    break;

  case 386:

/* Line 1455 of yacc.c  */
#line 2938 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_singlerow_subselect((yyvsp[(2) - (3)].select_lex));
          }
    break;

  case 387:

/* Line 1455 of yacc.c  */
#line 2941 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (3)].item); }
    break;

  case 388:

/* Line 1455 of yacc.c  */
#line 2943 "sql_yacc.yy"
    {
            (yyvsp[(4) - (5)].item_list)->push_front((yyvsp[(2) - (5)].item));
            (yyval.item)= new (YYSession->mem_root) Item_row(*(yyvsp[(4) - (5)].item_list));
          }
    break;

  case 389:

/* Line 1455 of yacc.c  */
#line 2948 "sql_yacc.yy"
    {
            (yyvsp[(5) - (6)].item_list)->push_front((yyvsp[(3) - (6)].item));
            (yyval.item)= new (YYSession->mem_root) Item_row(*(yyvsp[(5) - (6)].item_list));
          }
    break;

  case 390:

/* Line 1455 of yacc.c  */
#line 2953 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_exists_subselect((yyvsp[(3) - (4)].select_lex));
          }
    break;

  case 391:

/* Line 1455 of yacc.c  */
#line 2956 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(3) - (4)].item); }
    break;

  case 392:

/* Line 1455 of yacc.c  */
#line 2958 "sql_yacc.yy"
    {
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(2) - (2)].item), ITEM_CAST_CHAR, NULL, NULL,
                                 &my_charset_bin);
          }
    break;

  case 393:

/* Line 1455 of yacc.c  */
#line 2963 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].cast_type), lex->length, lex->dec,
                                 lex->charset);
            if (!(yyval.item))
              DRIZZLE_YYABORT;
          }
    break;

  case 394:

/* Line 1455 of yacc.c  */
#line 2971 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_case(* (yyvsp[(3) - (5)].item_list), (yyvsp[(2) - (5)].item), (yyvsp[(4) - (5)].item) ); }
    break;

  case 395:

/* Line 1455 of yacc.c  */
#line 2973 "sql_yacc.yy"
    {
            (yyval.item)= create_func_cast(YYSession, (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].cast_type), Lex->length, Lex->dec,
                                 Lex->charset);
            if (!(yyval.item))
              DRIZZLE_YYABORT;
          }
    break;

  case 396:

/* Line 1455 of yacc.c  */
#line 2980 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_default_value(Lex->current_context(),
                                                         (yyvsp[(3) - (4)].item));
          }
    break;

  case 397:

/* Line 1455 of yacc.c  */
#line 2985 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_insert_value(Lex->current_context(),
                                                        (yyvsp[(3) - (4)].item));
          }
    break;

  case 398:

/* Line 1455 of yacc.c  */
#line 2991 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(5) - (5)].item),(yyvsp[(2) - (5)].item),(yyvsp[(3) - (5)].interval),0); }
    break;

  case 399:

/* Line 1455 of yacc.c  */
#line 3002 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_char(*(yyvsp[(3) - (4)].item_list)); }
    break;

  case 400:

/* Line 1455 of yacc.c  */
#line 3004 "sql_yacc.yy"
    {
            std::string user_str("user");
            if (! ((yyval.item)= reserved_keyword_function(YYSession, user_str, NULL)))
            {
              DRIZZLE_YYABORT;
            }
            Lex->setCacheable(false);
          }
    break;

  case 401:

/* Line 1455 of yacc.c  */
#line 3013 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_typecast((yyvsp[(3) - (4)].item)); }
    break;

  case 402:

/* Line 1455 of yacc.c  */
#line 3015 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_dayofmonth((yyvsp[(3) - (4)].item)); }
    break;

  case 403:

/* Line 1455 of yacc.c  */
#line 3017 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_hour((yyvsp[(3) - (4)].item)); }
    break;

  case 404:

/* Line 1455 of yacc.c  */
#line 3019 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_insert(*YYSession, (yyvsp[(3) - (10)].item), (yyvsp[(5) - (10)].item), (yyvsp[(7) - (10)].item), (yyvsp[(9) - (10)].item)); }
    break;

  case 405:

/* Line 1455 of yacc.c  */
#line 3021 "sql_yacc.yy"
    {
            Session *session= YYSession;
            List<Item> *list= new (session->mem_root) List<Item>;
            list->push_front((yyvsp[(5) - (6)].item));
            list->push_front((yyvsp[(3) - (6)].item));
            Item_row *item= new (session->mem_root) Item_row(*list);
            (yyval.item)= new (session->mem_root) Item_func_interval(item);
          }
    break;

  case 406:

/* Line 1455 of yacc.c  */
#line 3030 "sql_yacc.yy"
    {
            Session *session= YYSession;
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(5) - (8)].item));
            (yyvsp[(7) - (8)].item_list)->push_front((yyvsp[(3) - (8)].item));
            Item_row *item= new (session->mem_root) Item_row(*(yyvsp[(7) - (8)].item_list));
            (yyval.item)= new (session->mem_root) Item_func_interval(item);
          }
    break;

  case 407:

/* Line 1455 of yacc.c  */
#line 3038 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_left((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item)); }
    break;

  case 408:

/* Line 1455 of yacc.c  */
#line 3040 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_minute((yyvsp[(3) - (4)].item)); }
    break;

  case 409:

/* Line 1455 of yacc.c  */
#line 3042 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_month((yyvsp[(3) - (4)].item)); }
    break;

  case 410:

/* Line 1455 of yacc.c  */
#line 3044 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_right((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item)); }
    break;

  case 411:

/* Line 1455 of yacc.c  */
#line 3046 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_second((yyvsp[(3) - (4)].item)); }
    break;

  case 412:

/* Line 1455 of yacc.c  */
#line 3048 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_datetime_typecast((yyvsp[(3) - (4)].item)); }
    break;

  case 413:

/* Line 1455 of yacc.c  */
#line 3050 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(3) - (4)].item)); }
    break;

  case 414:

/* Line 1455 of yacc.c  */
#line 3052 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_ltrim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 415:

/* Line 1455 of yacc.c  */
#line 3054 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_rtrim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 416:

/* Line 1455 of yacc.c  */
#line 3056 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(6) - (7)].item),(yyvsp[(4) - (7)].item)); }
    break;

  case 417:

/* Line 1455 of yacc.c  */
#line 3058 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_ltrim((yyvsp[(5) - (6)].item)); }
    break;

  case 418:

/* Line 1455 of yacc.c  */
#line 3060 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_rtrim((yyvsp[(5) - (6)].item)); }
    break;

  case 419:

/* Line 1455 of yacc.c  */
#line 3062 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(5) - (6)].item)); }
    break;

  case 420:

/* Line 1455 of yacc.c  */
#line 3064 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_trim((yyvsp[(5) - (6)].item),(yyvsp[(3) - (6)].item)); }
    break;

  case 421:

/* Line 1455 of yacc.c  */
#line 3066 "sql_yacc.yy"
    {
            std::string user_str("user");
            if (! ((yyval.item)= reserved_keyword_function(YYSession, user_str, NULL)))
            {
              DRIZZLE_YYABORT;
            }
            Lex->setCacheable(false);
          }
    break;

  case 422:

/* Line 1455 of yacc.c  */
#line 3075 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_year((yyvsp[(3) - (4)].item)); }
    break;

  case 423:

/* Line 1455 of yacc.c  */
#line 3091 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item),
                                                             INTERVAL_DAY, 0);
          }
    break;

  case 424:

/* Line 1455 of yacc.c  */
#line 3096 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item), (yyvsp[(6) - (8)].item), (yyvsp[(7) - (8)].interval), 0); }
    break;

  case 425:

/* Line 1455 of yacc.c  */
#line 3098 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_curdate_local();
            Lex->setCacheable(false);
          }
    break;

  case 426:

/* Line 1455 of yacc.c  */
#line 3103 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item),(yyvsp[(6) - (8)].item),(yyvsp[(7) - (8)].interval),0); }
    break;

  case 427:

/* Line 1455 of yacc.c  */
#line 3105 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item),(yyvsp[(6) - (8)].item),(yyvsp[(7) - (8)].interval),1); }
    break;

  case 428:

/* Line 1455 of yacc.c  */
#line 3107 "sql_yacc.yy"
    { (yyval.item)=new (YYSession->mem_root) Item_extract( (yyvsp[(3) - (6)].interval), (yyvsp[(5) - (6)].item)); }
    break;

  case 429:

/* Line 1455 of yacc.c  */
#line 3109 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_local();
            Lex->setCacheable(false);
          }
    break;

  case 430:

/* Line 1455 of yacc.c  */
#line 3114 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_local((yyvsp[(3) - (4)].item));
            Lex->setCacheable(false);
          }
    break;

  case 431:

/* Line 1455 of yacc.c  */
#line 3119 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_locate((yyvsp[(5) - (6)].item),(yyvsp[(3) - (6)].item)); }
    break;

  case 432:

/* Line 1455 of yacc.c  */
#line 3121 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item),
                                                             INTERVAL_DAY, 1);
          }
    break;

  case 433:

/* Line 1455 of yacc.c  */
#line 3126 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(3) - (8)].item), (yyvsp[(6) - (8)].item), (yyvsp[(7) - (8)].interval), 1); }
    break;

  case 434:

/* Line 1455 of yacc.c  */
#line 3128 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (8)].item));
            args->push_back((yyvsp[(5) - (8)].item));
            args->push_back((yyvsp[(7) - (8)].item));
            if (! ((yyval.item)= reserved_keyword_function(YYSession, reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 435:

/* Line 1455 of yacc.c  */
#line 3140 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (6)].item));
            args->push_back((yyvsp[(5) - (6)].item));
            if (! ((yyval.item)= reserved_keyword_function(YYSession, reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 436:

/* Line 1455 of yacc.c  */
#line 3151 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (8)].item));
            args->push_back((yyvsp[(5) - (8)].item));
            args->push_back((yyvsp[(7) - (8)].item));
            if (! ((yyval.item)= reserved_keyword_function(YYSession, reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 437:

/* Line 1455 of yacc.c  */
#line 3163 "sql_yacc.yy"
    {
            std::string reverse_str("substr");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (6)].item));
            args->push_back((yyvsp[(5) - (6)].item));
            if (! ((yyval.item)= reserved_keyword_function(YYSession, reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 438:

/* Line 1455 of yacc.c  */
#line 3174 "sql_yacc.yy"
    { 
            (yyval.item)= new (YYSession->mem_root) Item_func_sysdate_local(); 
            Lex->setCacheable(false);
          }
    break;

  case 439:

/* Line 1455 of yacc.c  */
#line 3179 "sql_yacc.yy"
    { 
            (yyval.item)= new (YYSession->mem_root) Item_func_sysdate_local((yyvsp[(3) - (4)].item)); 
            Lex->setCacheable(false);
          }
    break;

  case 440:

/* Line 1455 of yacc.c  */
#line 3184 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_date_add_interval((yyvsp[(7) - (8)].item),(yyvsp[(5) - (8)].item),(yyvsp[(3) - (8)].interval_time_st),0); }
    break;

  case 441:

/* Line 1455 of yacc.c  */
#line 3186 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_timestamp_diff((yyvsp[(5) - (8)].item),(yyvsp[(7) - (8)].item),(yyvsp[(3) - (8)].interval_time_st)); }
    break;

  case 442:

/* Line 1455 of yacc.c  */
#line 3188 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_curdate_utc();
            Lex->setCacheable(false);
          }
    break;

  case 443:

/* Line 1455 of yacc.c  */
#line 3193 "sql_yacc.yy"
    {
            (yyval.item)= new (YYSession->mem_root) Item_func_now_utc();
            Lex->setCacheable(false);
          }
    break;

  case 444:

/* Line 1455 of yacc.c  */
#line 3206 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_coalesce(* (yyvsp[(3) - (4)].item_list)); }
    break;

  case 445:

/* Line 1455 of yacc.c  */
#line 3208 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_collation((yyvsp[(3) - (4)].item)); }
    break;

  case 446:

/* Line 1455 of yacc.c  */
#line 3210 "sql_yacc.yy"
    {
            std::string database_str("database");
            if (! ((yyval.item)= reserved_keyword_function(YYSession, database_str, NULL)))
            {
              DRIZZLE_YYABORT;
            }
            Lex->setCacheable(false);
	  }
    break;

  case 447:

/* Line 1455 of yacc.c  */
#line 3219 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_if((yyvsp[(3) - (8)].item),(yyvsp[(5) - (8)].item),(yyvsp[(7) - (8)].item)); }
    break;

  case 448:

/* Line 1455 of yacc.c  */
#line 3221 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_microsecond((yyvsp[(3) - (4)].item)); }
    break;

  case 449:

/* Line 1455 of yacc.c  */
#line 3223 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_mod( (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item)); }
    break;

  case 450:

/* Line 1455 of yacc.c  */
#line 3225 "sql_yacc.yy"
    { (yyval.item) = new (YYSession->mem_root) Item_func_quarter((yyvsp[(3) - (4)].item)); }
    break;

  case 451:

/* Line 1455 of yacc.c  */
#line 3227 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_repeat(*YYSession, (yyvsp[(3) - (6)].item), (yyvsp[(5) - (6)].item)); }
    break;

  case 452:

/* Line 1455 of yacc.c  */
#line 3229 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_replace(*YYSession, (yyvsp[(3) - (8)].item), (yyvsp[(5) - (8)].item), (yyvsp[(7) - (8)].item)); }
    break;

  case 453:

/* Line 1455 of yacc.c  */
#line 3231 "sql_yacc.yy"
    {
            std::string reverse_str("reverse");
            List<Item> *args= new (YYSession->mem_root) List<Item>;
            args->push_back((yyvsp[(3) - (4)].item));
            if (! ((yyval.item)= reserved_keyword_function(YYSession, reverse_str, args)))
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 454:

/* Line 1455 of yacc.c  */
#line 3241 "sql_yacc.yy"
    { (yyval.item)= new (YYSession->mem_root) Item_func_round((yyvsp[(3) - (6)].item),(yyvsp[(5) - (6)].item),1); }
    break;

  case 455:

/* Line 1455 of yacc.c  */
#line 3254 "sql_yacc.yy"
    {
            const plugin::Function *udf= plugin::Function::get((yyvsp[(1) - (2)].lex_str).str, (yyvsp[(1) - (2)].lex_str).length);

            /* Temporary placing the result of getFunction in $3 */
            (yyval.udf)= udf;
          }
    break;

  case 456:

/* Line 1455 of yacc.c  */
#line 3261 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Create_func *builder;
            Item *item= NULL;

            /*
              Implementation note:
              names are resolved with the following order:
              - MySQL native functions,
              - User Defined Functions,
              - Stored Functions (assuming the current <use> database)

              This will be revised with WL#2128 (SQL PATH)
            */
            builder= find_native_function_builder((yyvsp[(1) - (5)].lex_str));
            if (builder)
            {
              item= builder->create(session, (yyvsp[(1) - (5)].lex_str), (yyvsp[(4) - (5)].item_list));
            }
            else
            {
              /* Retrieving the result of service::Function::get */
              const plugin::Function *udf= (yyvsp[(3) - (5)].udf);
              if (udf)
              {
                item= Create_udf_func::s_singleton.create(session, udf, (yyvsp[(4) - (5)].item_list));
              } else {
                /* fix for bug 250065, from Andrew Garner <muzazzi@gmail.com> */
                my_error(ER_SP_DOES_NOT_EXIST, MYF(0), "FUNCTION", (yyvsp[(1) - (5)].lex_str).str);
              }
            }

            if (! ((yyval.item)= item))
            {
              DRIZZLE_YYABORT;
            }
            Lex->setCacheable(false);
          }
    break;

  case 457:

/* Line 1455 of yacc.c  */
#line 3302 "sql_yacc.yy"
    { (yyval.item_list)= NULL; }
    break;

  case 458:

/* Line 1455 of yacc.c  */
#line 3303 "sql_yacc.yy"
    { (yyval.item_list)= (yyvsp[(1) - (1)].item_list); }
    break;

  case 459:

/* Line 1455 of yacc.c  */
#line 3308 "sql_yacc.yy"
    {
            (yyval.item_list)= new (YYSession->mem_root) List<Item>;
            (yyval.item_list)->push_back((yyvsp[(1) - (1)].item));
          }
    break;

  case 460:

/* Line 1455 of yacc.c  */
#line 3313 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].item_list)->push_back((yyvsp[(3) - (3)].item));
            (yyval.item_list)= (yyvsp[(1) - (3)].item_list);
          }
    break;

  case 461:

/* Line 1455 of yacc.c  */
#line 3321 "sql_yacc.yy"
    {
            /*
             Use Item::name as a storage for the attribute value of user
             defined function argument. It is safe to use Item::name
             because the syntax will not allow having an explicit name here.
             See WL#1017 re. udf attributes.
            */
            if ((yyvsp[(4) - (4)].lex_str).str)
            {
              (yyvsp[(2) - (4)].item)->is_autogenerated_name= false;
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(4) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).length, system_charset_info);
            }
            else
              (yyvsp[(2) - (4)].item)->set_name((yyvsp[(1) - (4)].simple_string), (uint) ((yyvsp[(3) - (4)].simple_string) - (yyvsp[(1) - (4)].simple_string)), YYSession->charset());
            (yyval.item)= (yyvsp[(2) - (4)].item);
          }
    break;

  case 462:

/* Line 1455 of yacc.c  */
#line 3341 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_avg((yyvsp[(3) - (4)].item)); }
    break;

  case 463:

/* Line 1455 of yacc.c  */
#line 3343 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_avg_distinct((yyvsp[(4) - (5)].item)); }
    break;

  case 464:

/* Line 1455 of yacc.c  */
#line 3345 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count(new Item_int((int32_t) 0L,1)); }
    break;

  case 465:

/* Line 1455 of yacc.c  */
#line 3347 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count((yyvsp[(3) - (4)].item)); }
    break;

  case 466:

/* Line 1455 of yacc.c  */
#line 3349 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr++; }
    break;

  case 467:

/* Line 1455 of yacc.c  */
#line 3351 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr--; }
    break;

  case 468:

/* Line 1455 of yacc.c  */
#line 3353 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_count_distinct(* (yyvsp[(5) - (7)].item_list)); }
    break;

  case 469:

/* Line 1455 of yacc.c  */
#line 3355 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_min((yyvsp[(3) - (4)].item)); }
    break;

  case 470:

/* Line 1455 of yacc.c  */
#line 3362 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_min((yyvsp[(4) - (5)].item)); }
    break;

  case 471:

/* Line 1455 of yacc.c  */
#line 3364 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_max((yyvsp[(3) - (4)].item)); }
    break;

  case 472:

/* Line 1455 of yacc.c  */
#line 3366 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_max((yyvsp[(4) - (5)].item)); }
    break;

  case 473:

/* Line 1455 of yacc.c  */
#line 3368 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_std((yyvsp[(3) - (4)].item), 0); }
    break;

  case 474:

/* Line 1455 of yacc.c  */
#line 3370 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_variance((yyvsp[(3) - (4)].item), 0); }
    break;

  case 475:

/* Line 1455 of yacc.c  */
#line 3372 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_std((yyvsp[(3) - (4)].item), 1); }
    break;

  case 476:

/* Line 1455 of yacc.c  */
#line 3374 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_variance((yyvsp[(3) - (4)].item), 1); }
    break;

  case 477:

/* Line 1455 of yacc.c  */
#line 3376 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_sum((yyvsp[(3) - (4)].item)); }
    break;

  case 478:

/* Line 1455 of yacc.c  */
#line 3378 "sql_yacc.yy"
    { (yyval.item)=new Item_sum_sum_distinct((yyvsp[(4) - (5)].item)); }
    break;

  case 479:

/* Line 1455 of yacc.c  */
#line 3380 "sql_yacc.yy"
    { Lex->current_select->in_sum_expr++; }
    break;

  case 480:

/* Line 1455 of yacc.c  */
#line 3384 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->in_sum_expr--;
            (yyval.item)=new Item_func_group_concat(Lex->current_context(), (yyvsp[(3) - (8)].num), (yyvsp[(5) - (8)].item_list),
                                          sel->gorder_list, (yyvsp[(7) - (8)].string));
            (yyvsp[(5) - (8)].item_list)->empty();
          }
    break;

  case 481:

/* Line 1455 of yacc.c  */
#line 3395 "sql_yacc.yy"
    { }
    break;

  case 482:

/* Line 1455 of yacc.c  */
#line 3397 "sql_yacc.yy"
    {
            (yyval.item)= (yyvsp[(3) - (3)].item);
          }
    break;

  case 483:

/* Line 1455 of yacc.c  */
#line 3404 "sql_yacc.yy"
    {
            (yyval.item)= new Item_func_set_user_var((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].item));
            Lex->setCacheable(false);
          }
    break;

  case 484:

/* Line 1455 of yacc.c  */
#line 3409 "sql_yacc.yy"
    {
            (yyval.item)= new Item_func_get_user_var(*YYSession, (yyvsp[(1) - (1)].lex_str));
            Lex->setCacheable(false);
          }
    break;

  case 485:

/* Line 1455 of yacc.c  */
#line 3414 "sql_yacc.yy"
    {
            /* disallow "SELECT @@global.global.variable" */
            if ((yyvsp[(3) - (4)].lex_str).str && (yyvsp[(4) - (4)].lex_str).str && check_reserved_words(&(yyvsp[(3) - (4)].lex_str)))
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            if (!((yyval.item)= get_system_var(YYSession, (yyvsp[(2) - (4)].var_type), (yyvsp[(3) - (4)].lex_str), (yyvsp[(4) - (4)].lex_str))))
              DRIZZLE_YYABORT;
          }
    break;

  case 486:

/* Line 1455 of yacc.c  */
#line 3428 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 487:

/* Line 1455 of yacc.c  */
#line 3429 "sql_yacc.yy"
    { (yyval.num) = 1; }
    break;

  case 488:

/* Line 1455 of yacc.c  */
#line 3434 "sql_yacc.yy"
    {
              (yyval.string)= new (YYSession->mem_root) String(",", 1, &my_charset_utf8_general_ci);
            }
    break;

  case 489:

/* Line 1455 of yacc.c  */
#line 3437 "sql_yacc.yy"
    { (yyval.string) = (yyvsp[(2) - (2)].string); }
    break;

  case 490:

/* Line 1455 of yacc.c  */
#line 3442 "sql_yacc.yy"
    {
            Lex->current_select->gorder_list = NULL;
          }
    break;

  case 491:

/* Line 1455 of yacc.c  */
#line 3446 "sql_yacc.yy"
    {
            Select_Lex *select= Lex->current_select;
            select->gorder_list=
              (SQL_LIST*) memory::sql_memdup((char*) &select->order_list,
                                     sizeof(st_sql_list));
            select->order_list.empty();
          }
    break;

  case 492:

/* Line 1455 of yacc.c  */
#line 3457 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->current_select->inc_in_sum_expr())
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 493:

/* Line 1455 of yacc.c  */
#line 3467 "sql_yacc.yy"
    {
            Lex->current_select->in_sum_expr--;
            (yyval.item)= (yyvsp[(3) - (3)].item);
          }
    break;

  case 494:

/* Line 1455 of yacc.c  */
#line 3475 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_CHAR; Lex->charset= &my_charset_bin; Lex->dec= 0; }
    break;

  case 495:

/* Line 1455 of yacc.c  */
#line 3477 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_CHAR; Lex->dec= 0; }
    break;

  case 496:

/* Line 1455 of yacc.c  */
#line 3479 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DATE; Lex->charset= NULL; Lex->dec=Lex->length= (char*)0; }
    break;

  case 497:

/* Line 1455 of yacc.c  */
#line 3481 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DATETIME; Lex->charset= NULL; Lex->dec=Lex->length= (char*)0; }
    break;

  case 498:

/* Line 1455 of yacc.c  */
#line 3483 "sql_yacc.yy"
    { (yyval.cast_type)=ITEM_CAST_DECIMAL; Lex->charset= NULL; }
    break;

  case 499:

/* Line 1455 of yacc.c  */
#line 3488 "sql_yacc.yy"
    {
            (yyval.item_list)= new (YYSession->mem_root) List<Item>;
            (yyval.item_list)->push_back((yyvsp[(1) - (1)].item));
          }
    break;

  case 500:

/* Line 1455 of yacc.c  */
#line 3493 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].item_list)->push_back((yyvsp[(3) - (3)].item));
            (yyval.item_list)= (yyvsp[(1) - (3)].item_list);
          }
    break;

  case 501:

/* Line 1455 of yacc.c  */
#line 3500 "sql_yacc.yy"
    { (yyval.item)= NULL; }
    break;

  case 502:

/* Line 1455 of yacc.c  */
#line 3501 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 503:

/* Line 1455 of yacc.c  */
#line 3505 "sql_yacc.yy"
    { (yyval.item)= NULL; }
    break;

  case 504:

/* Line 1455 of yacc.c  */
#line 3506 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(2) - (2)].item); }
    break;

  case 505:

/* Line 1455 of yacc.c  */
#line 3511 "sql_yacc.yy"
    {
            (yyval.item_list)= new List<Item>;
            (yyval.item_list)->push_back((yyvsp[(2) - (4)].item));
            (yyval.item_list)->push_back((yyvsp[(4) - (4)].item));
          }
    break;

  case 506:

/* Line 1455 of yacc.c  */
#line 3517 "sql_yacc.yy"
    {
            (yyvsp[(1) - (5)].item_list)->push_back((yyvsp[(3) - (5)].item));
            (yyvsp[(1) - (5)].item_list)->push_back((yyvsp[(5) - (5)].item));
            (yyval.item_list)= (yyvsp[(1) - (5)].item_list);
          }
    break;

  case 507:

/* Line 1455 of yacc.c  */
#line 3527 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 508:

/* Line 1455 of yacc.c  */
#line 3529 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->nest_last_join(lex->session)))
              DRIZZLE_YYABORT;
          }
    break;

  case 509:

/* Line 1455 of yacc.c  */
#line 3537 "sql_yacc.yy"
    { DRIZZLE_YYABORT_UNLESS((yyval.table_list)=(yyvsp[(1) - (1)].table_list)); }
    break;

  case 510:

/* Line 1455 of yacc.c  */
#line 3548 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 511:

/* Line 1455 of yacc.c  */
#line 3549 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(3) - (4)].table_list); }
    break;

  case 512:

/* Line 1455 of yacc.c  */
#line 3555 "sql_yacc.yy"
    { (yyval.table_list)=(yyvsp[(1) - (1)].table_list); }
    break;

  case 513:

/* Line 1455 of yacc.c  */
#line 3557 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list)));
          }
    break;

  case 514:

/* Line 1455 of yacc.c  */
#line 3577 "sql_yacc.yy"
    { 
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list)));
            Lex->is_cross= false;
          }
    break;

  case 515:

/* Line 1455 of yacc.c  */
#line 3582 "sql_yacc.yy"
    { 
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (3)].table_list) && ((yyval.table_list)=(yyvsp[(3) - (3)].table_list))); (yyvsp[(3) - (3)].table_list)->straight=1; 
          }
    break;

  case 516:

/* Line 1455 of yacc.c  */
#line 3587 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
            DRIZZLE_YYABORT_UNLESS( not Lex->is_cross );
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (4)].table_list), (yyvsp[(3) - (4)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 517:

/* Line 1455 of yacc.c  */
#line 3596 "sql_yacc.yy"
    {
            add_join_on((yyvsp[(3) - (6)].table_list),(yyvsp[(6) - (6)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 518:

/* Line 1455 of yacc.c  */
#line 3603 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (4)].table_list), (yyvsp[(3) - (4)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 519:

/* Line 1455 of yacc.c  */
#line 3611 "sql_yacc.yy"
    {
            (yyvsp[(3) - (6)].table_list)->straight=1;
            add_join_on((yyvsp[(3) - (6)].table_list),(yyvsp[(6) - (6)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 520:

/* Line 1455 of yacc.c  */
#line 3619 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && (yyvsp[(3) - (4)].table_list));
          }
    break;

  case 521:

/* Line 1455 of yacc.c  */
#line 3623 "sql_yacc.yy"
    { add_join_natural((yyvsp[(1) - (8)].table_list),(yyvsp[(3) - (8)].table_list),(yyvsp[(7) - (8)].string_list),Lex->current_select); (yyval.table_list)=(yyvsp[(3) - (8)].table_list); }
    break;

  case 522:

/* Line 1455 of yacc.c  */
#line 3625 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (4)].table_list) && ((yyval.table_list)=(yyvsp[(4) - (4)].table_list)));
            add_join_natural((yyvsp[(1) - (4)].table_list),(yyvsp[(4) - (4)].table_list),NULL,Lex->current_select);
          }
    break;

  case 523:

/* Line 1455 of yacc.c  */
#line 3633 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(5) - (6)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (6)].table_list), (yyvsp[(5) - (6)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 524:

/* Line 1455 of yacc.c  */
#line 3641 "sql_yacc.yy"
    {
            add_join_on((yyvsp[(5) - (8)].table_list),(yyvsp[(8) - (8)].item));
            Lex->pop_context();
            (yyvsp[(5) - (8)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(5) - (8)].table_list);
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 525:

/* Line 1455 of yacc.c  */
#line 3649 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (5)].table_list) && (yyvsp[(5) - (5)].table_list));
          }
    break;

  case 526:

/* Line 1455 of yacc.c  */
#line 3653 "sql_yacc.yy"
    {
            add_join_natural((yyvsp[(1) - (10)].table_list),(yyvsp[(5) - (10)].table_list),(yyvsp[(9) - (10)].string_list),Lex->current_select);
            (yyvsp[(5) - (10)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(5) - (10)].table_list);
          }
    break;

  case 527:

/* Line 1455 of yacc.c  */
#line 3659 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(6) - (6)].table_list));
            add_join_natural((yyvsp[(1) - (6)].table_list),(yyvsp[(6) - (6)].table_list),NULL,Lex->current_select);
            (yyvsp[(6) - (6)].table_list)->outer_join|=JOIN_TYPE_LEFT;
            (yyval.table_list)=(yyvsp[(6) - (6)].table_list);
          }
    break;

  case 528:

/* Line 1455 of yacc.c  */
#line 3669 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(5) - (6)].table_list));
            /* Change the current name resolution context to a local context. */
            if (push_new_name_resolution_context(YYSession, (yyvsp[(1) - (6)].table_list), (yyvsp[(5) - (6)].table_list)))
              DRIZZLE_YYABORT;
            Lex->current_select->parsing_place= IN_ON;
          }
    break;

  case 529:

/* Line 1455 of yacc.c  */
#line 3677 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
            add_join_on((yyval.table_list), (yyvsp[(8) - (8)].item));
            Lex->pop_context();
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 530:

/* Line 1455 of yacc.c  */
#line 3686 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (5)].table_list) && (yyvsp[(5) - (5)].table_list));
          }
    break;

  case 531:

/* Line 1455 of yacc.c  */
#line 3690 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
            add_join_natural((yyval.table_list),(yyvsp[(5) - (10)].table_list),(yyvsp[(9) - (10)].string_list),Lex->current_select);
          }
    break;

  case 532:

/* Line 1455 of yacc.c  */
#line 3697 "sql_yacc.yy"
    {
            DRIZZLE_YYABORT_UNLESS((yyvsp[(1) - (6)].table_list) && (yyvsp[(6) - (6)].table_list));
            add_join_natural((yyvsp[(6) - (6)].table_list),(yyvsp[(1) - (6)].table_list),NULL,Lex->current_select);
            LEX *lex= Lex;
            if (!((yyval.table_list)= lex->current_select->convert_right_join()))
              DRIZZLE_YYABORT;
          }
    break;

  case 533:

/* Line 1455 of yacc.c  */
#line 3707 "sql_yacc.yy"
    {}
    break;

  case 534:

/* Line 1455 of yacc.c  */
#line 3708 "sql_yacc.yy"
    {}
    break;

  case 535:

/* Line 1455 of yacc.c  */
#line 3709 "sql_yacc.yy"
    { Lex->is_cross= true; }
    break;

  case 536:

/* Line 1455 of yacc.c  */
#line 3721 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->table_join_options= 0;
          }
    break;

  case 537:

/* Line 1455 of yacc.c  */
#line 3726 "sql_yacc.yy"
    {
            if (!((yyval.table_list)= Lex->current_select->add_table_to_list(YYSession, (yyvsp[(2) - (4)].table), (yyvsp[(3) - (4)].lex_str_ptr),
                             Lex->current_select->get_table_join_options(),
                             Lex->lock_option,
                             Lex->current_select->pop_index_hints())))
              DRIZZLE_YYABORT;
            Lex->current_select->add_joined_table((yyval.table_list));
          }
    break;

  case 538:

/* Line 1455 of yacc.c  */
#line 3735 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if ((yyvsp[(1) - (3)].num))
            {
              if (sel->set_braces(1))
              {
                struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
                my_parse_error(&pass);
                DRIZZLE_YYABORT;
              }
              /* select in braces, can't contain global parameters */
              if (sel->master_unit()->fake_select_lex)
                sel->master_unit()->global_parameters=
                   sel->master_unit()->fake_select_lex;
            }
            if ((yyvsp[(2) - (3)].select_lex)->init_nested_join(lex->session))
              DRIZZLE_YYABORT;
            (yyval.table_list)= 0;
            /* incomplete derived tables return NULL, we must be
               nested in select_derived rule to be here. */
          }
    break;

  case 539:

/* Line 1455 of yacc.c  */
#line 3776 "sql_yacc.yy"
    {
            /* Use $2 instead of Lex->current_select as derived table will
               alter value of Lex->current_select. */
            if (!((yyvsp[(3) - (5)].table_list) || (yyvsp[(5) - (5)].lex_str_ptr)) && (yyvsp[(2) - (5)].select_lex)->embedding &&
                !(yyvsp[(2) - (5)].select_lex)->embedding->getNestedJoin()->join_list.elements)
            {
              /* we have a derived table ($3 == NULL) but no alias,
                 Since we are nested in further parentheses so we
                 can pass NULL to the outer level parentheses
                 Permits parsing of "((((select ...))) as xyz)" */
              (yyval.table_list)= 0;
            }
            else if (!(yyvsp[(3) - (5)].table_list))
            {
              /* Handle case of derived table, alias may be NULL if there
                 are no outer parentheses, add_table_to_list() will throw
                 error in this case */
              LEX *lex=Lex;
              Select_Lex *sel= lex->current_select;
              Select_Lex_Unit *unit= sel->master_unit();
              lex->current_select= sel= unit->outer_select();
              if (!((yyval.table_list)= sel->add_table_to_list(lex->session,
                                               new Table_ident(unit), (yyvsp[(5) - (5)].lex_str_ptr), 0,
                                               TL_READ)))

                DRIZZLE_YYABORT;
              sel->add_joined_table((yyval.table_list));
              lex->pop_context();
            }
            else if (((yyvsp[(3) - (5)].table_list)->select_lex && (yyvsp[(3) - (5)].table_list)->select_lex->master_unit()->is_union()) || (yyvsp[(5) - (5)].lex_str_ptr))
            {
              /* simple nested joins cannot have aliases or unions */
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            else
              (yyval.table_list)= (yyvsp[(3) - (5)].table_list);
          }
    break;

  case 541:

/* Line 1455 of yacc.c  */
#line 3822 "sql_yacc.yy"
    {
            if (add_select_to_union_list(YYSession, Lex, (bool)(yyvsp[(3) - (3)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 542:

/* Line 1455 of yacc.c  */
#line 3827 "sql_yacc.yy"
    {
            /*
              Remove from the name resolution context stack the context of the
              last select in the union.
             */
            Lex->pop_context();
          }
    break;

  case 544:

/* Line 1455 of yacc.c  */
#line 3840 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex * sel= lex->current_select;
            if (lex->current_select->set_braces(0))
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            if (sel->linkage == UNION_TYPE &&
                sel->master_unit()->first_select()->braces)
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 545:

/* Line 1455 of yacc.c  */
#line 3861 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            if (sel->linkage != UNION_TYPE)
              mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 546:

/* Line 1455 of yacc.c  */
#line 3869 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 548:

/* Line 1455 of yacc.c  */
#line 3878 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if ((yyvsp[(1) - (1)].select_lex)->init_nested_join(lex->session))
              DRIZZLE_YYABORT;
          }
    break;

  case 549:

/* Line 1455 of yacc.c  */
#line 3884 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            /* for normal joins, $3 != NULL and end_nested_join() != NULL,
               for derived tables, both must equal NULL */

            if (!((yyval.table_list)= (yyvsp[(1) - (3)].select_lex)->end_nested_join(lex->session)) && (yyvsp[(3) - (3)].table_list))
              DRIZZLE_YYABORT;
            if (!(yyvsp[(3) - (3)].table_list) && (yyval.table_list))
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 550:

/* Line 1455 of yacc.c  */
#line 3901 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->derived_tables|= DERIVED_SUBQUERY;
            if (!lex->expr_allows_subselect)
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE ||
                mysql_new_select(lex, 1))
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->current_select->linkage= DERIVED_TABLE_TYPE;
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 551:

/* Line 1455 of yacc.c  */
#line 3918 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= NO_MATTER;
          }
    break;

  case 553:

/* Line 1455 of yacc.c  */
#line 3925 "sql_yacc.yy"
    { (yyval.select_lex)= Lex->current_select; }
    break;

  case 554:

/* Line 1455 of yacc.c  */
#line 3930 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            Select_Lex *sel= lex->current_select;
            TableList *embedding;
            if (!sel->embedding || sel->end_nested_join(lex->session))
            {
              /* we are not in parentheses */
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            embedding= Lex->current_select->embedding;
            (yyval.num)= embedding &&
                !embedding->getNestedJoin()->join_list.elements;
            /* return true if we are deeply nested */
          }
    break;

  case 555:

/* Line 1455 of yacc.c  */
#line 3950 "sql_yacc.yy"
    {}
    break;

  case 556:

/* Line 1455 of yacc.c  */
#line 3951 "sql_yacc.yy"
    {}
    break;

  case 557:

/* Line 1455 of yacc.c  */
#line 3956 "sql_yacc.yy"
    {
            (yyval.num)= INDEX_HINT_MASK_ALL;
          }
    break;

  case 558:

/* Line 1455 of yacc.c  */
#line 3959 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_JOIN;  }
    break;

  case 559:

/* Line 1455 of yacc.c  */
#line 3960 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_ORDER; }
    break;

  case 560:

/* Line 1455 of yacc.c  */
#line 3961 "sql_yacc.yy"
    { (yyval.num)= INDEX_HINT_MASK_GROUP; }
    break;

  case 561:

/* Line 1455 of yacc.c  */
#line 3965 "sql_yacc.yy"
    { (yyval.index_hint)= INDEX_HINT_FORCE; }
    break;

  case 562:

/* Line 1455 of yacc.c  */
#line 3966 "sql_yacc.yy"
    { (yyval.index_hint)= INDEX_HINT_IGNORE; }
    break;

  case 563:

/* Line 1455 of yacc.c  */
#line 3971 "sql_yacc.yy"
    {
            Lex->current_select->set_index_hint_type((yyvsp[(1) - (3)].index_hint), (yyvsp[(3) - (3)].num));
          }
    break;

  case 565:

/* Line 1455 of yacc.c  */
#line 3976 "sql_yacc.yy"
    {
            Lex->current_select->set_index_hint_type(INDEX_HINT_USE, (yyvsp[(3) - (3)].num));
          }
    break;

  case 570:

/* Line 1455 of yacc.c  */
#line 3989 "sql_yacc.yy"
    { Lex->current_select->alloc_index_hints(YYSession); }
    break;

  case 572:

/* Line 1455 of yacc.c  */
#line 3993 "sql_yacc.yy"
    {  Lex->current_select->clear_index_hints(); }
    break;

  case 574:

/* Line 1455 of yacc.c  */
#line 3998 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, NULL, 0); }
    break;

  case 575:

/* Line 1455 of yacc.c  */
#line 3999 "sql_yacc.yy"
    {}
    break;

  case 576:

/* Line 1455 of yacc.c  */
#line 4004 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 577:

/* Line 1455 of yacc.c  */
#line 4006 "sql_yacc.yy"
    { Lex->current_select->add_index_hint(YYSession, (char *)"PRIMARY", 7); }
    break;

  case 580:

/* Line 1455 of yacc.c  */
#line 4016 "sql_yacc.yy"
    {
            if (!((yyval.string_list)= new List<String>))
              DRIZZLE_YYABORT;
            (yyval.string_list)->push_back(new (YYSession->mem_root)
                              String((const char *) (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length,
                                      system_charset_info));
          }
    break;

  case 581:

/* Line 1455 of yacc.c  */
#line 4024 "sql_yacc.yy"
    {
            (yyvsp[(1) - (3)].string_list)->push_back(new (YYSession->mem_root)
                              String((const char *) (yyvsp[(3) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).length,
                                      system_charset_info));
            (yyval.string_list)= (yyvsp[(1) - (3)].string_list);
          }
    break;

  case 582:

/* Line 1455 of yacc.c  */
#line 4033 "sql_yacc.yy"
    {}
    break;

  case 583:

/* Line 1455 of yacc.c  */
#line 4034 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_HOUR; }
    break;

  case 584:

/* Line 1455 of yacc.c  */
#line 4035 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_MICROSECOND; }
    break;

  case 585:

/* Line 1455 of yacc.c  */
#line 4036 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_MINUTE; }
    break;

  case 586:

/* Line 1455 of yacc.c  */
#line 4037 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_DAY_SECOND; }
    break;

  case 587:

/* Line 1455 of yacc.c  */
#line 4038 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_MICROSECOND; }
    break;

  case 588:

/* Line 1455 of yacc.c  */
#line 4039 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_MINUTE; }
    break;

  case 589:

/* Line 1455 of yacc.c  */
#line 4040 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_HOUR_SECOND; }
    break;

  case 590:

/* Line 1455 of yacc.c  */
#line 4041 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_MINUTE_MICROSECOND; }
    break;

  case 591:

/* Line 1455 of yacc.c  */
#line 4042 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_MINUTE_SECOND; }
    break;

  case 592:

/* Line 1455 of yacc.c  */
#line 4043 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_SECOND_MICROSECOND; }
    break;

  case 593:

/* Line 1455 of yacc.c  */
#line 4044 "sql_yacc.yy"
    { (yyval.interval)=INTERVAL_YEAR_MONTH; }
    break;

  case 594:

/* Line 1455 of yacc.c  */
#line 4048 "sql_yacc.yy"
    {}
    break;

  case 595:

/* Line 1455 of yacc.c  */
#line 4049 "sql_yacc.yy"
    {
                                  (yyval.interval_time_st)=INTERVAL_MICROSECOND;
                                  /*
                                    FRAC_SECOND was mistakenly implemented with
                                    a wrong resolution. According to the ODBC
                                    standard it should be nanoseconds, not
                                    microseconds. Changing it to nanoseconds
                                    in MySQL would mean making TIMESTAMPDIFF
                                    and TIMESTAMPADD to return DECIMAL, since
                                    the return value would be too big for BIGINT
                                    Hence we just deprecate the incorrect
                                    implementation without changing its
                                    resolution.
                                  */
                                }
    break;

  case 596:

/* Line 1455 of yacc.c  */
#line 4067 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_DAY; }
    break;

  case 597:

/* Line 1455 of yacc.c  */
#line 4068 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_WEEK; }
    break;

  case 598:

/* Line 1455 of yacc.c  */
#line 4069 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_HOUR; }
    break;

  case 599:

/* Line 1455 of yacc.c  */
#line 4070 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MINUTE; }
    break;

  case 600:

/* Line 1455 of yacc.c  */
#line 4071 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MONTH; }
    break;

  case 601:

/* Line 1455 of yacc.c  */
#line 4072 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_QUARTER; }
    break;

  case 602:

/* Line 1455 of yacc.c  */
#line 4073 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_SECOND; }
    break;

  case 603:

/* Line 1455 of yacc.c  */
#line 4074 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_MICROSECOND; }
    break;

  case 604:

/* Line 1455 of yacc.c  */
#line 4075 "sql_yacc.yy"
    { (yyval.interval_time_st)=INTERVAL_YEAR; }
    break;

  case 608:

/* Line 1455 of yacc.c  */
#line 4085 "sql_yacc.yy"
    { (yyval.lex_str_ptr)=0; }
    break;

  case 609:

/* Line 1455 of yacc.c  */
#line 4087 "sql_yacc.yy"
    { (yyval.lex_str_ptr)= (drizzled::LEX_STRING*) memory::sql_memdup(&(yyvsp[(2) - (2)].lex_str),sizeof(drizzled::LEX_STRING)); }
    break;

  case 612:

/* Line 1455 of yacc.c  */
#line 4096 "sql_yacc.yy"
    { Lex->current_select->where= 0; }
    break;

  case 613:

/* Line 1455 of yacc.c  */
#line 4098 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= IN_WHERE;
          }
    break;

  case 614:

/* Line 1455 of yacc.c  */
#line 4102 "sql_yacc.yy"
    {
            Select_Lex *select= Lex->current_select;
            select->where= (yyvsp[(3) - (3)].item);
            select->parsing_place= NO_MATTER;
            if ((yyvsp[(3) - (3)].item))
              (yyvsp[(3) - (3)].item)->top_level_item();
          }
    break;

  case 616:

/* Line 1455 of yacc.c  */
#line 4114 "sql_yacc.yy"
    {
            Lex->current_select->parsing_place= IN_HAVING;
          }
    break;

  case 617:

/* Line 1455 of yacc.c  */
#line 4118 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->having= (yyvsp[(3) - (3)].item);
            sel->parsing_place= NO_MATTER;
            if ((yyvsp[(3) - (3)].item))
              (yyvsp[(3) - (3)].item)->top_level_item();
          }
    break;

  case 618:

/* Line 1455 of yacc.c  */
#line 4129 "sql_yacc.yy"
    {
            Lex->escape_used= true;
            (yyval.item)= (yyvsp[(2) - (2)].item);
          }
    break;

  case 619:

/* Line 1455 of yacc.c  */
#line 4134 "sql_yacc.yy"
    {
            Lex->escape_used= false;
            (yyval.item)= new Item_string("\\", 1, &my_charset_utf8_general_ci);
          }
    break;

  case 622:

/* Line 1455 of yacc.c  */
#line 4151 "sql_yacc.yy"
    { if (YYSession->add_group_to_list((yyvsp[(3) - (4)].item),(bool) (yyvsp[(4) - (4)].num))) DRIZZLE_YYABORT; }
    break;

  case 623:

/* Line 1455 of yacc.c  */
#line 4153 "sql_yacc.yy"
    { if (YYSession->add_group_to_list((yyvsp[(1) - (2)].item),(bool) (yyvsp[(2) - (2)].num))) DRIZZLE_YYABORT; }
    break;

  case 624:

/* Line 1455 of yacc.c  */
#line 4157 "sql_yacc.yy"
    {}
    break;

  case 625:

/* Line 1455 of yacc.c  */
#line 4159 "sql_yacc.yy"
    {
            /*
              'WITH ROLLUP' is needed for backward compatibility,
              and cause LALR(2) conflicts.
              This syntax is not standard.
              MySQL syntax: GROUP BY col1, col2, col3 WITH ROLLUP
              SQL-2003: GROUP BY ... ROLLUP(col1, col2, col3)
            */
            LEX *lex= Lex;
            if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
            {
              my_error(ER_WRONG_USAGE, MYF(0), "WITH ROLLUP",
                       "global union parameters");
              DRIZZLE_YYABORT;
            }
            lex->current_select->olap= ROLLUP_TYPE;
          }
    break;

  case 629:

/* Line 1455 of yacc.c  */
#line 4193 "sql_yacc.yy"
    {
            Session *session= YYSession;
            bool ascending= ((yyvsp[(2) - (2)].num) == 1) ? true : false;
            if (session->add_order_to_list((yyvsp[(1) - (2)].item), ascending))
              DRIZZLE_YYABORT;
          }
    break;

  case 632:

/* Line 1455 of yacc.c  */
#line 4212 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            Select_Lex *sel= lex->current_select;
            Select_Lex_Unit *unit= sel-> master_unit();
            if (sel->linkage != GLOBAL_OPTIONS_TYPE &&
                sel->olap != UNSPECIFIED_OLAP_TYPE &&
                (sel->linkage != UNION_TYPE || sel->braces))
            {
              my_error(ER_WRONG_USAGE, MYF(0),
                       "CUBE/ROLLUP", "ORDER BY");
              DRIZZLE_YYABORT;
            }
            if (lex->sql_command != SQLCOM_ALTER_TABLE && !unit->fake_select_lex)
            {
              /*
                A query of the of the form (SELECT ...) ORDER BY order_list is
                executed in the same way as the query
                SELECT ... ORDER BY order_list
                unless the SELECT construct contains ORDER BY or LIMIT clauses.
                Otherwise we create a fake Select_Lex if it has not been created
                yet.
              */
              Select_Lex *first_sl= unit->first_select();
              if (!unit->is_union() &&
                  (first_sl->order_list.elements ||
                   first_sl->select_limit) &&           
                  unit->add_fake_select_lex(lex->session))
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 634:

/* Line 1455 of yacc.c  */
#line 4247 "sql_yacc.yy"
    { if (YYSession->add_order_to_list((yyvsp[(3) - (4)].item),(bool) (yyvsp[(4) - (4)].num))) DRIZZLE_YYABORT; }
    break;

  case 635:

/* Line 1455 of yacc.c  */
#line 4249 "sql_yacc.yy"
    { if (YYSession->add_order_to_list((yyvsp[(1) - (2)].item),(bool) (yyvsp[(2) - (2)].num))) DRIZZLE_YYABORT; }
    break;

  case 636:

/* Line 1455 of yacc.c  */
#line 4253 "sql_yacc.yy"
    { (yyval.num) =  1; }
    break;

  case 637:

/* Line 1455 of yacc.c  */
#line 4254 "sql_yacc.yy"
    { (yyval.num) =1; }
    break;

  case 638:

/* Line 1455 of yacc.c  */
#line 4255 "sql_yacc.yy"
    { (yyval.num) =0; }
    break;

  case 639:

/* Line 1455 of yacc.c  */
#line 4260 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            Select_Lex *sel= lex->current_select;
            sel->offset_limit= 0;
            sel->select_limit= 0;
          }
    break;

  case 640:

/* Line 1455 of yacc.c  */
#line 4266 "sql_yacc.yy"
    {}
    break;

  case 641:

/* Line 1455 of yacc.c  */
#line 4270 "sql_yacc.yy"
    {}
    break;

  case 642:

/* Line 1455 of yacc.c  */
#line 4271 "sql_yacc.yy"
    {}
    break;

  case 643:

/* Line 1455 of yacc.c  */
#line 4275 "sql_yacc.yy"
    {}
    break;

  case 644:

/* Line 1455 of yacc.c  */
#line 4280 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(1) - (1)].item);
            sel->offset_limit= 0;
            sel->explicit_limit= 1;
          }
    break;

  case 645:

/* Line 1455 of yacc.c  */
#line 4287 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(3) - (3)].item);
            sel->offset_limit= (yyvsp[(1) - (3)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 646:

/* Line 1455 of yacc.c  */
#line 4294 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(1) - (3)].item);
            sel->offset_limit= (yyvsp[(3) - (3)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 647:

/* Line 1455 of yacc.c  */
#line 4303 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 648:

/* Line 1455 of yacc.c  */
#line 4304 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 649:

/* Line 1455 of yacc.c  */
#line 4305 "sql_yacc.yy"
    { (yyval.item)= new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 650:

/* Line 1455 of yacc.c  */
#line 4310 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->current_select->select_limit= 0;
          }
    break;

  case 651:

/* Line 1455 of yacc.c  */
#line 4315 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            sel->select_limit= (yyvsp[(2) - (2)].item);
            sel->explicit_limit= 1;
          }
    break;

  case 652:

/* Line 1455 of yacc.c  */
#line 4323 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 653:

/* Line 1455 of yacc.c  */
#line 4324 "sql_yacc.yy"
    { (yyval.ulong_num)= (ulong) strtol((yyvsp[(1) - (1)].lex_str).str, (char**) 0, 16); }
    break;

  case 654:

/* Line 1455 of yacc.c  */
#line 4325 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 655:

/* Line 1455 of yacc.c  */
#line 4326 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 656:

/* Line 1455 of yacc.c  */
#line 4327 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 657:

/* Line 1455 of yacc.c  */
#line 4328 "sql_yacc.yy"
    { int error; (yyval.ulong_num)= (ulong) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 658:

/* Line 1455 of yacc.c  */
#line 4332 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 659:

/* Line 1455 of yacc.c  */
#line 4333 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 660:

/* Line 1455 of yacc.c  */
#line 4334 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 661:

/* Line 1455 of yacc.c  */
#line 4335 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 662:

/* Line 1455 of yacc.c  */
#line 4336 "sql_yacc.yy"
    { int error; (yyval.ulonglong_number)= (uint64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, (char**) 0, &error); }
    break;

  case 663:

/* Line 1455 of yacc.c  */
#line 4340 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->describe && (!(lex->result= new select_dumpvar())))
              DRIZZLE_YYABORT;
          }
    break;

  case 664:

/* Line 1455 of yacc.c  */
#line 4346 "sql_yacc.yy"
    {}
    break;

  case 666:

/* Line 1455 of yacc.c  */
#line 4351 "sql_yacc.yy"
    {}
    break;

  case 667:

/* Line 1455 of yacc.c  */
#line 4356 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->result)
              ((select_dumpvar *)lex->result)->var_list.push_back( new var((yyvsp[(2) - (2)].lex_str),0,0,(enum_field_types)0));
            else
              /*
                The parser won't create select_result instance only
                if it's an EXPLAIN.
              */
              assert(lex->describe);
          }
    break;

  case 668:

/* Line 1455 of yacc.c  */
#line 4371 "sql_yacc.yy"
    { }
    break;

  case 670:

/* Line 1455 of yacc.c  */
#line 4377 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->setCacheable(false);
            if (!(lex->exchange= new file_exchange((yyvsp[(2) - (2)].lex_str).str, 0)) ||
                !(lex->result= new select_export(lex->exchange)))
              DRIZZLE_YYABORT;
          }
    break;

  case 672:

/* Line 1455 of yacc.c  */
#line 4386 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->describe)
            {
              lex->setCacheable(false);
              if (!(lex->exchange= new file_exchange((yyvsp[(2) - (2)].lex_str).str,1)))
                DRIZZLE_YYABORT;
              if (!(lex->result= new select_dump(lex->exchange)))
                DRIZZLE_YYABORT;
            }
          }
    break;

  case 673:

/* Line 1455 of yacc.c  */
#line 4398 "sql_yacc.yy"
    {Lex->setCacheable(false);}
    break;

  case 674:

/* Line 1455 of yacc.c  */
#line 4407 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_DROP_TABLE;
            statement::DropTable *statement= new(std::nothrow) statement::DropTable(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->drop_temporary= (yyvsp[(2) - (5)].num);
            statement->drop_if_exists= (yyvsp[(4) - (5)].num);
          }
    break;

  case 675:

/* Line 1455 of yacc.c  */
#line 4417 "sql_yacc.yy"
    {}
    break;

  case 676:

/* Line 1455 of yacc.c  */
#line 4418 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_DROP_INDEX;
            statement::DropIndex *statement= new(std::nothrow) statement::DropIndex(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->alter_info.flags.set(ALTER_DROP_INDEX);
            statement->alter_info.build_method= (yyvsp[(2) - (7)].build_method);
            statement->alter_info.drop_list.push_back(new AlterDrop(AlterDrop::KEY, (yyvsp[(4) - (7)].lex_str).str));
            if (!lex->current_select->add_table_to_list(lex->session, (yyvsp[(6) - (7)].table), NULL,
                                                        TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
          }
    break;

  case 677:

/* Line 1455 of yacc.c  */
#line 4433 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_DROP_DB;
            statement::DropSchema *statement= new(std::nothrow) statement::DropSchema(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->drop_if_exists=(yyvsp[(3) - (4)].num);
            lex->name= (yyvsp[(4) - (4)].lex_str);
          }
    break;

  case 680:

/* Line 1455 of yacc.c  */
#line 4450 "sql_yacc.yy"
    {
            if (!Lex->current_select->add_table_to_list(YYSession, (yyvsp[(1) - (1)].table), NULL, TL_OPTION_UPDATING))
              DRIZZLE_YYABORT;
          }
    break;

  case 681:

/* Line 1455 of yacc.c  */
#line 4457 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 682:

/* Line 1455 of yacc.c  */
#line 4458 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 683:

/* Line 1455 of yacc.c  */
#line 4462 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 684:

/* Line 1455 of yacc.c  */
#line 4463 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 685:

/* Line 1455 of yacc.c  */
#line 4471 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_INSERT;
            lex->statement= new(std::nothrow) statement::Insert(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_ERROR;
            mysql_init_select(lex);
            /* for subselects */
            lex->lock_option= TL_READ;
          }
    break;

  case 686:

/* Line 1455 of yacc.c  */
#line 4483 "sql_yacc.yy"
    {
            Lex->current_select->set_lock_for_tables(TL_WRITE_CONCURRENT_INSERT);
            Lex->current_select= &Lex->select_lex;
          }
    break;

  case 687:

/* Line 1455 of yacc.c  */
#line 4488 "sql_yacc.yy"
    {}
    break;

  case 688:

/* Line 1455 of yacc.c  */
#line 4493 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_REPLACE;
            lex->statement= new(std::nothrow) statement::Replace(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->duplicates= DUP_REPLACE;
            mysql_init_select(lex);
          }
    break;

  case 689:

/* Line 1455 of yacc.c  */
#line 4503 "sql_yacc.yy"
    {
            Lex->current_select->set_lock_for_tables(TL_WRITE_DEFAULT);
            Lex->current_select= &Lex->select_lex;
          }
    break;

  case 690:

/* Line 1455 of yacc.c  */
#line 4508 "sql_yacc.yy"
    {}
    break;

  case 691:

/* Line 1455 of yacc.c  */
#line 4512 "sql_yacc.yy"
    {}
    break;

  case 692:

/* Line 1455 of yacc.c  */
#line 4513 "sql_yacc.yy"
    {}
    break;

  case 693:

/* Line 1455 of yacc.c  */
#line 4518 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->field_list.empty();
            lex->many_values.empty();
            lex->insert_list=0;
          }
    break;

  case 694:

/* Line 1455 of yacc.c  */
#line 4526 "sql_yacc.yy"
    {}
    break;

  case 695:

/* Line 1455 of yacc.c  */
#line 4527 "sql_yacc.yy"
    {}
    break;

  case 696:

/* Line 1455 of yacc.c  */
#line 4528 "sql_yacc.yy"
    {}
    break;

  case 697:

/* Line 1455 of yacc.c  */
#line 4530 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!(lex->insert_list = new List_item) ||
                lex->many_values.push_back(lex->insert_list))
              DRIZZLE_YYABORT;
          }
    break;

  case 699:

/* Line 1455 of yacc.c  */
#line 4540 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(3) - (3)].item)); }
    break;

  case 700:

/* Line 1455 of yacc.c  */
#line 4541 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(1) - (1)].item)); }
    break;

  case 701:

/* Line 1455 of yacc.c  */
#line 4545 "sql_yacc.yy"
    {}
    break;

  case 702:

/* Line 1455 of yacc.c  */
#line 4546 "sql_yacc.yy"
    {}
    break;

  case 703:

/* Line 1455 of yacc.c  */
#line 4548 "sql_yacc.yy"
    { Lex->current_select->set_braces(0);}
    break;

  case 704:

/* Line 1455 of yacc.c  */
#line 4549 "sql_yacc.yy"
    {}
    break;

  case 705:

/* Line 1455 of yacc.c  */
#line 4551 "sql_yacc.yy"
    { Lex->current_select->set_braces(1);}
    break;

  case 706:

/* Line 1455 of yacc.c  */
#line 4552 "sql_yacc.yy"
    {}
    break;

  case 711:

/* Line 1455 of yacc.c  */
#line 4567 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->field_list.push_back((yyvsp[(1) - (3)].item)) ||
                lex->insert_list->push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 712:

/* Line 1455 of yacc.c  */
#line 4576 "sql_yacc.yy"
    {}
    break;

  case 713:

/* Line 1455 of yacc.c  */
#line 4577 "sql_yacc.yy"
    {}
    break;

  case 714:

/* Line 1455 of yacc.c  */
#line 4581 "sql_yacc.yy"
    {}
    break;

  case 715:

/* Line 1455 of yacc.c  */
#line 4582 "sql_yacc.yy"
    {}
    break;

  case 716:

/* Line 1455 of yacc.c  */
#line 4587 "sql_yacc.yy"
    {
              if (!(Lex->insert_list = new List_item))
                DRIZZLE_YYABORT;
          }
    break;

  case 717:

/* Line 1455 of yacc.c  */
#line 4592 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (lex->many_values.push_back(lex->insert_list))
              DRIZZLE_YYABORT;
          }
    break;

  case 718:

/* Line 1455 of yacc.c  */
#line 4600 "sql_yacc.yy"
    {}
    break;

  case 720:

/* Line 1455 of yacc.c  */
#line 4606 "sql_yacc.yy"
    {
            if (Lex->insert_list->push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 721:

/* Line 1455 of yacc.c  */
#line 4611 "sql_yacc.yy"
    {
            if (Lex->insert_list->push_back((yyvsp[(1) - (1)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 722:

/* Line 1455 of yacc.c  */
#line 4618 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item);}
    break;

  case 723:

/* Line 1455 of yacc.c  */
#line 4619 "sql_yacc.yy"
    {(yyval.item)= new Item_default_value(Lex->current_context()); }
    break;

  case 725:

/* Line 1455 of yacc.c  */
#line 4624 "sql_yacc.yy"
    { Lex->duplicates= DUP_UPDATE; }
    break;

  case 727:

/* Line 1455 of yacc.c  */
#line 4632 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            mysql_init_select(lex);
            lex->sql_command= SQLCOM_UPDATE;
            lex->statement= new(std::nothrow) statement::Update(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->lock_option= TL_UNLOCK; /* Will be set later */
            lex->duplicates= DUP_ERROR;
            if (!lex->select_lex.add_table_to_list(YYSession, (yyvsp[(3) - (3)].table), NULL,0))
              DRIZZLE_YYABORT;
          }
    break;

  case 728:

/* Line 1455 of yacc.c  */
#line 4645 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->select_lex.get_table_list()->derived)
            {
              /* it is single table update and it is update of derived table */
              my_error(ER_NON_UPDATABLE_TABLE, MYF(0),
                       lex->select_lex.get_table_list()->alias, "UPDATE");
              DRIZZLE_YYABORT;
            }
            /*
              In case of multi-update setting write lock for all tables may
              be too pessimistic. We will decrease lock level if possible in
              mysql_multi_update().
            */
            Lex->current_select->set_lock_for_tables(TL_WRITE_DEFAULT);
          }
    break;

  case 729:

/* Line 1455 of yacc.c  */
#line 4661 "sql_yacc.yy"
    {}
    break;

  case 732:

/* Line 1455 of yacc.c  */
#line 4671 "sql_yacc.yy"
    {
            if (YYSession->add_item_to_list((yyvsp[(1) - (3)].item)) || YYSession->add_value_to_list((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 735:

/* Line 1455 of yacc.c  */
#line 4684 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          if (lex->update_list.push_back((yyvsp[(1) - (3)].item)) ||
              lex->value_list.push_back((yyvsp[(3) - (3)].item)))
              DRIZZLE_YYABORT;
          }
    break;

  case 736:

/* Line 1455 of yacc.c  */
#line 4696 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_DELETE;
            lex->statement= new(std::nothrow) statement::Delete(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->lock_option= TL_WRITE_DEFAULT;
            lex->ignore= 0;
            lex->select_lex.init_order();
          }
    break;

  case 738:

/* Line 1455 of yacc.c  */
#line 4712 "sql_yacc.yy"
    {
            if (!Lex->current_select->add_table_to_list(YYSession, (yyvsp[(2) - (2)].table), NULL, TL_OPTION_UPDATING,
                                           Lex->lock_option))
              DRIZZLE_YYABORT;
          }
    break;

  case 739:

/* Line 1455 of yacc.c  */
#line 4718 "sql_yacc.yy"
    {}
    break;

  case 740:

/* Line 1455 of yacc.c  */
#line 4722 "sql_yacc.yy"
    {}
    break;

  case 741:

/* Line 1455 of yacc.c  */
#line 4723 "sql_yacc.yy"
    {}
    break;

  case 742:

/* Line 1455 of yacc.c  */
#line 4727 "sql_yacc.yy"
    { Lex->ignore= 1; }
    break;

  case 743:

/* Line 1455 of yacc.c  */
#line 4732 "sql_yacc.yy"
    {
            LEX* lex= Lex;
            lex->sql_command= SQLCOM_TRUNCATE;
            lex->statement= new(std::nothrow) statement::Truncate(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.options= 0;
            lex->select_lex.init_order();
          }
    break;

  case 746:

/* Line 1455 of yacc.c  */
#line 4752 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->wild=0;
            lex->lock_option= TL_READ;
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 747:

/* Line 1455 of yacc.c  */
#line 4760 "sql_yacc.yy"
    {}
    break;

  case 748:

/* Line 1455 of yacc.c  */
#line 4765 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;

             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(session);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             std::string column_name= "Database";
             if (Lex->wild)
             {
               column_name.append(" (");
               column_name.append(Lex->wild->ptr());
               column_name.append(")");
             }

             if (Lex->current_select->where)
             {
               if (prepare_new_schema_table(session, lex, "SCHEMAS"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(session, lex, "SHOW_SCHEMAS"))
                 DRIZZLE_YYABORT;
             }

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "SCHEMA_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(column_name.c_str(), column_name.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

              if (session->add_order_to_list(my_field, true))
                DRIZZLE_YYABORT;
           }
    break;

  case 749:

/* Line 1455 of yacc.c  */
#line 4805 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;

             lex->sql_command= SQLCOM_SELECT;

             statement::Select *select=
               new(std::nothrow) statement::Select(YYSession);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;


              std::string column_name= "Tables_in_";

              if ((yyvsp[(2) - (3)].simple_string))
              {
		SchemaIdentifier identifier((yyvsp[(2) - (3)].simple_string));
                column_name.append((yyvsp[(2) - (3)].simple_string));
                lex->select_lex.db= (yyvsp[(2) - (3)].simple_string);
                if (not plugin::StorageEngine::doesSchemaExist(identifier))
                {
                  my_error(ER_BAD_DB_ERROR, MYF(0), (yyvsp[(2) - (3)].simple_string));
                }
                select->setShowPredicate((yyvsp[(2) - (3)].simple_string), "");
              }
              else if (not session->db.empty())
              {
                column_name.append(session->db);
                select->setShowPredicate(session->db, "");
              }
              else
              {
                 my_error(ER_NO_DB_ERROR, MYF(0));
              }


             if (Lex->wild)
             {
               column_name.append(" (");
               column_name.append(Lex->wild->ptr());
               column_name.append(")");
             }

             if (prepare_new_schema_table(YYSession, lex, "SHOW_TABLES"))
               DRIZZLE_YYABORT;

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "TABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(column_name.c_str(), column_name.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

              if (session->add_order_to_list(my_field, true))
                DRIZZLE_YYABORT;
           }
    break;

  case 750:

/* Line 1455 of yacc.c  */
#line 4865 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;

             lex->sql_command= SQLCOM_SELECT;

             statement::Select *select=
               new(std::nothrow) statement::Select(YYSession);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;


             if (prepare_new_schema_table(YYSession, lex, "SHOW_TEMPORARY_TABLES"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;

           }
    break;

  case 751:

/* Line 1455 of yacc.c  */
#line 4891 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             statement::Select *select=
               new(std::nothrow) statement::Select(YYSession);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             std::string column_name= "Tables_in_";

             if ((yyvsp[(3) - (4)].simple_string))
             {
               lex->select_lex.db= (yyvsp[(3) - (4)].simple_string);

	       SchemaIdentifier identifier((yyvsp[(3) - (4)].simple_string));
               if (not plugin::StorageEngine::doesSchemaExist(identifier))
               {
                 my_error(ER_BAD_DB_ERROR, MYF(0), (yyvsp[(3) - (4)].simple_string));
               }

               select->setShowPredicate((yyvsp[(3) - (4)].simple_string), "");
             }
             else
             {
               select->setShowPredicate(session->db, "");
             }

             if (prepare_new_schema_table(session, lex, "SHOW_TABLE_STATUS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
           }
    break;

  case 752:

/* Line 1455 of yacc.c  */
#line 4933 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;
             statement::Select *select;

             lex->sql_command= SQLCOM_SELECT;

             select= new(std::nothrow) statement::Select(session);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             if ((yyvsp[(4) - (5)].simple_string))
              select->setShowPredicate((yyvsp[(4) - (5)].simple_string), (yyvsp[(3) - (5)].table)->table.str);
             else if ((yyvsp[(3) - (5)].table)->db.str)
              select->setShowPredicate((yyvsp[(3) - (5)].table)->db.str, (yyvsp[(3) - (5)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(3) - (5)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(3) - (5)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(3) - (5)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "SHOW_COLUMNS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;

          }
    break;

  case 753:

/* Line 1455 of yacc.c  */
#line 4975 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             Session *session= YYSession;
             statement::Select *select;

             lex->sql_command= SQLCOM_SELECT;

             select= new(std::nothrow) statement::Select(session);

             lex->statement= select;

             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             if ((yyvsp[(4) - (5)].simple_string))
              select->setShowPredicate((yyvsp[(4) - (5)].simple_string), (yyvsp[(3) - (5)].table)->table.str);
             else if ((yyvsp[(3) - (5)].table)->db.str)
              select->setShowPredicate((yyvsp[(3) - (5)].table)->db.str, (yyvsp[(3) - (5)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(3) - (5)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(3) - (5)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(3) - (5)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "SHOW_INDEXES"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
          }
    break;

  case 754:

/* Line 1455 of yacc.c  */
#line 5016 "sql_yacc.yy"
    {
            (void) create_select_for_variable("warning_count");
            LEX *lex= Lex;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 755:

/* Line 1455 of yacc.c  */
#line 5024 "sql_yacc.yy"
    {
            (void) create_select_for_variable("error_count");
            LEX *lex= Lex;
            lex->statement= new(std::nothrow) statement::Select(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 756:

/* Line 1455 of yacc.c  */
#line 5032 "sql_yacc.yy"
    {
            Lex->sql_command = SQLCOM_SHOW_WARNS;
            Lex->statement= new(std::nothrow) statement::ShowWarnings(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 757:

/* Line 1455 of yacc.c  */
#line 5039 "sql_yacc.yy"
    {
            Lex->sql_command = SQLCOM_SHOW_ERRORS;
            Lex->statement= new(std::nothrow) statement::ShowErrors(YYSession);
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 758:

/* Line 1455 of yacc.c  */
#line 5046 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if ((yyvsp[(1) - (3)].var_type) == OPT_GLOBAL)
             {
               if (prepare_new_schema_table(session, lex, "GLOBAL_STATUS"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(session, lex, "SESSION_STATUS"))
                 DRIZZLE_YYABORT;
             }

             std::string key("Variable_name");
             std::string value("Value");

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(key.c_str(), key.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

             my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_VALUE");
             my_field->is_autogenerated_name= false;
             my_field->set_name(value.c_str(), value.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 759:

/* Line 1455 of yacc.c  */
#line 5085 "sql_yacc.yy"
    {
           {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if (prepare_new_schema_table(session, lex, "PROCESSLIST"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;
           }
          }
    break;

  case 760:

/* Line 1455 of yacc.c  */
#line 5107 "sql_yacc.yy"
    {
             LEX *lex= Lex;
             lex->sql_command= SQLCOM_SELECT;
             lex->statement=
               new(std::nothrow) statement::Select(YYSession);
             if (lex->statement == NULL)
               DRIZZLE_YYABORT;

             Session *session= YYSession;

             if ((yyvsp[(1) - (3)].var_type) == OPT_GLOBAL)
             {
               if (prepare_new_schema_table(session, lex, "GLOBAL_VARIABLES"))
                 DRIZZLE_YYABORT;
             }
             else
             {
               if (prepare_new_schema_table(session, lex, "SESSION_VARIABLES"))
                 DRIZZLE_YYABORT;
             }

             std::string key("Variable_name");
             std::string value("Value");

             Item_field *my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_NAME");
             my_field->is_autogenerated_name= false;
             my_field->set_name(key.c_str(), key.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;

             my_field= new Item_field(&session->lex->current_select->context, NULL, NULL, "VARIABLE_VALUE");
             my_field->is_autogenerated_name= false;
             my_field->set_name(value.c_str(), value.length(), system_charset_info);

             if (session->add_item_to_list(my_field))
               DRIZZLE_YYABORT;
           }
    break;

  case 761:

/* Line 1455 of yacc.c  */
#line 5146 "sql_yacc.yy"
    {
            Lex->sql_command=SQLCOM_SHOW_CREATE_DB;
            statement::ShowCreateSchema *statement= new(std::nothrow) statement::ShowCreateSchema(YYSession);
            Lex->statement= statement;
            if (Lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->is_if_not_exists= (yyvsp[(3) - (4)].num);
            Lex->name= (yyvsp[(4) - (4)].lex_str);
          }
    break;

  case 762:

/* Line 1455 of yacc.c  */
#line 5156 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command = SQLCOM_SHOW_CREATE;
            lex->statement= new(std::nothrow) statement::ShowCreate(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            if (!lex->select_lex.add_table_to_list(YYSession, (yyvsp[(3) - (3)].table), NULL,0))
              DRIZZLE_YYABORT;
          }
    break;

  case 763:

/* Line 1455 of yacc.c  */
#line 5167 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 764:

/* Line 1455 of yacc.c  */
#line 5168 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[(2) - (2)].lex_str).str; }
    break;

  case 768:

/* Line 1455 of yacc.c  */
#line 5179 "sql_yacc.yy"
    {
            Lex->wild= new (YYSession->mem_root) String((yyvsp[(2) - (2)].lex_str).str, (yyvsp[(2) - (2)].lex_str).length,
                                                    system_charset_info);
            if (Lex->wild == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 769:

/* Line 1455 of yacc.c  */
#line 5186 "sql_yacc.yy"
    {
            Lex->current_select->where= (yyvsp[(2) - (2)].item);
            if ((yyvsp[(2) - (2)].item))
              (yyvsp[(2) - (2)].item)->top_level_item();
          }
    break;

  case 770:

/* Line 1455 of yacc.c  */
#line 5196 "sql_yacc.yy"
    {
            Session *session= YYSession;
            statement::Select *select;
            LEX *lex= Lex;
            lex->lock_option= TL_READ;
            mysql_init_select(lex);
            lex->current_select->parsing_place= SELECT_LIST;
            lex->sql_command= SQLCOM_SELECT;
            select= new(std::nothrow) statement::Select(session);
            lex->statement= select;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.db= 0;

             if ((yyvsp[(2) - (2)].table)->db.str)
              select->setShowPredicate((yyvsp[(2) - (2)].table)->db.str, (yyvsp[(2) - (2)].table)->table.str);
             else
              select->setShowPredicate(session->db, (yyvsp[(2) - (2)].table)->table.str);

             {
               drizzled::TableIdentifier identifier(select->getShowSchema().c_str(), (yyvsp[(2) - (2)].table)->table.str);
               if (not plugin::StorageEngine::doesTableExist(*session, identifier))
               {
                   my_error(ER_NO_SUCH_TABLE, MYF(0),
                            select->getShowSchema().c_str(), 
                            (yyvsp[(2) - (2)].table)->table.str);
               }
             }

             if (prepare_new_schema_table(session, lex, "SHOW_COLUMNS"))
               DRIZZLE_YYABORT;

             if (session->add_item_to_list( new Item_field(&session->lex->current_select->
                                                           context,
                                                           NULL, NULL, "*")))
               DRIZZLE_YYABORT;
             (session->lex->current_select->with_wild)++;

          }
    break;

  case 771:

/* Line 1455 of yacc.c  */
#line 5235 "sql_yacc.yy"
    {}
    break;

  case 772:

/* Line 1455 of yacc.c  */
#line 5237 "sql_yacc.yy"
    { Lex->describe|= DESCRIBE_NORMAL; }
    break;

  case 773:

/* Line 1455 of yacc.c  */
#line 5239 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->select_lex.options|= SELECT_DESCRIBE;
          }
    break;

  case 776:

/* Line 1455 of yacc.c  */
#line 5251 "sql_yacc.yy"
    {}
    break;

  case 777:

/* Line 1455 of yacc.c  */
#line 5252 "sql_yacc.yy"
    { Lex->describe|= DESCRIBE_EXTENDED; }
    break;

  case 778:

/* Line 1455 of yacc.c  */
#line 5256 "sql_yacc.yy"
    {}
    break;

  case 779:

/* Line 1455 of yacc.c  */
#line 5257 "sql_yacc.yy"
    { Lex->wild= (yyvsp[(1) - (1)].string); }
    break;

  case 780:

/* Line 1455 of yacc.c  */
#line 5259 "sql_yacc.yy"
    {
            Lex->wild= new (YYSession->mem_root) String((const char*) (yyvsp[(1) - (1)].lex_str).str,
                                                    (yyvsp[(1) - (1)].lex_str).length,
                                                    system_charset_info);
          }
    break;

  case 781:

/* Line 1455 of yacc.c  */
#line 5271 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_FLUSH;
            lex->statement= new(std::nothrow) statement::Flush(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->type= 0;
          }
    break;

  case 782:

/* Line 1455 of yacc.c  */
#line 5280 "sql_yacc.yy"
    {}
    break;

  case 785:

/* Line 1455 of yacc.c  */
#line 5290 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushTables(true);
          }
    break;

  case 786:

/* Line 1455 of yacc.c  */
#line 5294 "sql_yacc.yy"
    {}
    break;

  case 787:

/* Line 1455 of yacc.c  */
#line 5296 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushTablesWithReadLock(true);
          }
    break;

  case 788:

/* Line 1455 of yacc.c  */
#line 5301 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushLog(true);
          }
    break;

  case 789:

/* Line 1455 of yacc.c  */
#line 5306 "sql_yacc.yy"
    {
            statement::Flush *statement= (statement::Flush*)Lex->statement;
            statement->setFlushStatus(true);
          }
    break;

  case 790:

/* Line 1455 of yacc.c  */
#line 5313 "sql_yacc.yy"
    {}
    break;

  case 791:

/* Line 1455 of yacc.c  */
#line 5314 "sql_yacc.yy"
    {}
    break;

  case 792:

/* Line 1455 of yacc.c  */
#line 5321 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->value_list.empty();
            lex->value_list.push_front((yyvsp[(3) - (3)].item));
            lex->sql_command= SQLCOM_KILL;
            lex->statement= new(std::nothrow) statement::Kill(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 793:

/* Line 1455 of yacc.c  */
#line 5333 "sql_yacc.yy"
    { Lex->type= 0; }
    break;

  case 794:

/* Line 1455 of yacc.c  */
#line 5334 "sql_yacc.yy"
    { Lex->type= 0; }
    break;

  case 795:

/* Line 1455 of yacc.c  */
#line 5335 "sql_yacc.yy"
    { Lex->type= ONLY_KILL_QUERY; }
    break;

  case 796:

/* Line 1455 of yacc.c  */
#line 5342 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command=SQLCOM_CHANGE_DB;
            lex->statement= new(std::nothrow) statement::ChangeSchema(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->select_lex.db= (yyvsp[(2) - (2)].lex_str).str;
          }
    break;

  case 797:

/* Line 1455 of yacc.c  */
#line 5356 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;

            lex->sql_command= SQLCOM_LOAD;
            statement::Load *statement= new(std::nothrow) statement::Load(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;

            Lex_input_stream *lip= session->m_lip;
            statement->fname_start= lip->get_ptr();
          }
    break;

  case 798:

/* Line 1455 of yacc.c  */
#line 5370 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->lock_option= (yyvsp[(4) - (6)].lock_type);
            lex->duplicates= DUP_ERROR;
            lex->ignore= 0;
            if (!(lex->exchange= new file_exchange((yyvsp[(6) - (6)].lex_str).str, 0, (yyvsp[(2) - (6)].filetype))))
              DRIZZLE_YYABORT;
          }
    break;

  case 799:

/* Line 1455 of yacc.c  */
#line 5379 "sql_yacc.yy"
    {
            Session *session= YYSession;
            Lex_input_stream *lip= session->m_lip;
            ((statement::Load *)Lex->statement)->fname_end= lip->get_ptr();
          }
    break;

  case 800:

/* Line 1455 of yacc.c  */
#line 5385 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!Lex->current_select->add_table_to_list(YYSession,
                    (yyvsp[(12) - (12)].table), NULL, TL_OPTION_UPDATING,
                    lex->lock_option))
              DRIZZLE_YYABORT;
            lex->field_list.empty();
            lex->update_list.empty();
            lex->value_list.empty();
          }
    break;

  case 801:

/* Line 1455 of yacc.c  */
#line 5397 "sql_yacc.yy"
    {}
    break;

  case 802:

/* Line 1455 of yacc.c  */
#line 5401 "sql_yacc.yy"
    { (yyval.filetype)= FILETYPE_CSV; }
    break;

  case 803:

/* Line 1455 of yacc.c  */
#line 5404 "sql_yacc.yy"
    { (yyval.lock_type)= TL_WRITE_DEFAULT; }
    break;

  case 804:

/* Line 1455 of yacc.c  */
#line 5406 "sql_yacc.yy"
    {
              (yyval.lock_type)= TL_WRITE_CONCURRENT_INSERT;
          }
    break;

  case 805:

/* Line 1455 of yacc.c  */
#line 5412 "sql_yacc.yy"
    { Lex->duplicates=DUP_ERROR; }
    break;

  case 806:

/* Line 1455 of yacc.c  */
#line 5413 "sql_yacc.yy"
    { Lex->duplicates=DUP_REPLACE; }
    break;

  case 807:

/* Line 1455 of yacc.c  */
#line 5414 "sql_yacc.yy"
    { Lex->ignore= 1; }
    break;

  case 812:

/* Line 1455 of yacc.c  */
#line 5429 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->field_term= (yyvsp[(3) - (3)].string);
          }
    break;

  case 813:

/* Line 1455 of yacc.c  */
#line 5434 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            assert(lex->exchange != 0);
            lex->exchange->enclosed= (yyvsp[(4) - (4)].string);
            lex->exchange->opt_enclosed= 1;
          }
    break;

  case 814:

/* Line 1455 of yacc.c  */
#line 5441 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->enclosed= (yyvsp[(3) - (3)].string);
          }
    break;

  case 815:

/* Line 1455 of yacc.c  */
#line 5446 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->escaped= (yyvsp[(3) - (3)].string);
          }
    break;

  case 820:

/* Line 1455 of yacc.c  */
#line 5464 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->line_term= (yyvsp[(3) - (3)].string);
          }
    break;

  case 821:

/* Line 1455 of yacc.c  */
#line 5469 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->line_start= (yyvsp[(3) - (3)].string);
          }
    break;

  case 823:

/* Line 1455 of yacc.c  */
#line 5478 "sql_yacc.yy"
    {
            assert(Lex->exchange != 0);
            Lex->exchange->skip_lines= atol((yyvsp[(2) - (3)].lex_str).str);
          }
    break;

  case 824:

/* Line 1455 of yacc.c  */
#line 5485 "sql_yacc.yy"
    { }
    break;

  case 825:

/* Line 1455 of yacc.c  */
#line 5486 "sql_yacc.yy"
    { }
    break;

  case 826:

/* Line 1455 of yacc.c  */
#line 5490 "sql_yacc.yy"
    {}
    break;

  case 827:

/* Line 1455 of yacc.c  */
#line 5491 "sql_yacc.yy"
    {}
    break;

  case 828:

/* Line 1455 of yacc.c  */
#line 5492 "sql_yacc.yy"
    {}
    break;

  case 829:

/* Line 1455 of yacc.c  */
#line 5497 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(3) - (3)].item)); }
    break;

  case 830:

/* Line 1455 of yacc.c  */
#line 5499 "sql_yacc.yy"
    { Lex->field_list.push_back((yyvsp[(1) - (1)].item)); }
    break;

  case 831:

/* Line 1455 of yacc.c  */
#line 5503 "sql_yacc.yy"
    {(yyval.item)= (yyvsp[(1) - (1)].item);}
    break;

  case 832:

/* Line 1455 of yacc.c  */
#line 5505 "sql_yacc.yy"
    { (yyval.item)= new Item_user_var_as_out_param((yyvsp[(2) - (2)].lex_str)); }
    break;

  case 833:

/* Line 1455 of yacc.c  */
#line 5509 "sql_yacc.yy"
    {}
    break;

  case 834:

/* Line 1455 of yacc.c  */
#line 5510 "sql_yacc.yy"
    {}
    break;

  case 835:

/* Line 1455 of yacc.c  */
#line 5517 "sql_yacc.yy"
    {
          Session *session= YYSession;
          (yyval.item) = new Item_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length, session->variables.getCollation());
        }
    break;

  case 836:

/* Line 1455 of yacc.c  */
#line 5522 "sql_yacc.yy"
    {
            ((Item_string*) (yyvsp[(1) - (2)].item))->append((yyvsp[(2) - (2)].lex_str).str, (yyvsp[(2) - (2)].lex_str).length);
          }
    break;

  case 837:

/* Line 1455 of yacc.c  */
#line 5529 "sql_yacc.yy"
    {
            (yyval.string)= new (YYSession->mem_root) String((yyvsp[(1) - (1)].lex_str).str,
                                             (yyvsp[(1) - (1)].lex_str).length,
                                             YYSession->variables.getCollation());
          }
    break;

  case 838:

/* Line 1455 of yacc.c  */
#line 5535 "sql_yacc.yy"
    {
            Item *tmp= new Item_hex_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            /*
              it is OK only emulate fix_fields, because we need only
              value of constant
            */
            (yyval.string)= tmp ?
              tmp->quick_fix_field(), tmp->val_str((String*) 0) :
              (String*) 0;
          }
    break;

  case 839:

/* Line 1455 of yacc.c  */
#line 5546 "sql_yacc.yy"
    {
            Item *tmp= new Item_bin_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            /*
              it is OK only emulate fix_fields, because we need only
              value of constant
            */
            (yyval.string)= tmp ? tmp->quick_fix_field(), tmp->val_str((String*) 0) :
              (String*) 0;
          }
    break;

  case 840:

/* Line 1455 of yacc.c  */
#line 5558 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item); }
    break;

  case 841:

/* Line 1455 of yacc.c  */
#line 5559 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item_num); }
    break;

  case 842:

/* Line 1455 of yacc.c  */
#line 5561 "sql_yacc.yy"
    {
            (yyvsp[(2) - (2)].item_num)->max_length++;
            (yyval.item)= (yyvsp[(2) - (2)].item_num)->neg();
          }
    break;

  case 843:

/* Line 1455 of yacc.c  */
#line 5568 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item); }
    break;

  case 844:

/* Line 1455 of yacc.c  */
#line 5569 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(1) - (1)].item_num); }
    break;

  case 845:

/* Line 1455 of yacc.c  */
#line 5571 "sql_yacc.yy"
    {
            (yyval.item) = new Item_null();
            YYSession->m_lip->next_state=MY_LEX_OPERATOR_OR_IDENT;
          }
    break;

  case 846:

/* Line 1455 of yacc.c  */
#line 5575 "sql_yacc.yy"
    { (yyval.item)= new Item_int((char*) "FALSE",0,1); }
    break;

  case 847:

/* Line 1455 of yacc.c  */
#line 5576 "sql_yacc.yy"
    { (yyval.item)= new Item_int((char*) "TRUE",1,1); }
    break;

  case 848:

/* Line 1455 of yacc.c  */
#line 5577 "sql_yacc.yy"
    { (yyval.item) = new Item_hex_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);}
    break;

  case 849:

/* Line 1455 of yacc.c  */
#line 5578 "sql_yacc.yy"
    { (yyval.item)= new Item_bin_string((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 850:

/* Line 1455 of yacc.c  */
#line 5579 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 851:

/* Line 1455 of yacc.c  */
#line 5580 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 852:

/* Line 1455 of yacc.c  */
#line 5585 "sql_yacc.yy"
    {
            int error;
            (yyval.item_num) = new Item_int((yyvsp[(1) - (1)].lex_str).str, (int64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, NULL, &error), (yyvsp[(1) - (1)].lex_str).length);
          }
    break;

  case 853:

/* Line 1455 of yacc.c  */
#line 5590 "sql_yacc.yy"
    {
            int error;
            (yyval.item_num) = new Item_int((yyvsp[(1) - (1)].lex_str).str, (int64_t) internal::my_strtoll10((yyvsp[(1) - (1)].lex_str).str, NULL, &error), (yyvsp[(1) - (1)].lex_str).length);
          }
    break;

  case 854:

/* Line 1455 of yacc.c  */
#line 5595 "sql_yacc.yy"
    { (yyval.item_num) = new Item_uint((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length); }
    break;

  case 855:

/* Line 1455 of yacc.c  */
#line 5597 "sql_yacc.yy"
    {
            (yyval.item_num)= new Item_decimal((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length, YYSession->charset());
            if (YYSession->is_error())
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 856:

/* Line 1455 of yacc.c  */
#line 5605 "sql_yacc.yy"
    {
            (yyval.item_num) = new Item_float((yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
            if (YYSession->is_error())
            {
              DRIZZLE_YYABORT;
            }
          }
    break;

  case 857:

/* Line 1455 of yacc.c  */
#line 5619 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 858:

/* Line 1455 of yacc.c  */
#line 5620 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 859:

/* Line 1455 of yacc.c  */
#line 5625 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            (yyval.item) = new Item_field(Lex->current_context(), NULL, (yyvsp[(1) - (3)].lex_str).str, "*");
            sel->with_wild++;
          }
    break;

  case 860:

/* Line 1455 of yacc.c  */
#line 5631 "sql_yacc.yy"
    {
            Select_Lex *sel= Lex->current_select;
            (yyval.item) = new Item_field(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,"*");
            sel->with_wild++;
          }
    break;

  case 861:

/* Line 1455 of yacc.c  */
#line 5639 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 862:

/* Line 1455 of yacc.c  */
#line 5644 "sql_yacc.yy"
    {
            {
              Select_Lex *sel=Lex->current_select;
              (yyval.item)= (sel->parsing_place != IN_HAVING ||
                  sel->get_in_sum_expr() > 0) ?
                  (Item*) new Item_field(Lex->current_context(),
                                         (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str) :
                  (Item*) new Item_ref(Lex->current_context(),
                                       (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str);
            }
          }
    break;

  case 863:

/* Line 1455 of yacc.c  */
#line 5655 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 864:

/* Line 1455 of yacc.c  */
#line 5660 "sql_yacc.yy"
    {
            Select_Lex *sel=Lex->current_select;
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(),
                                       (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(),
                                     (const char *)NULL, NULL, (yyvsp[(1) - (1)].lex_str).str);
          }
    break;

  case 865:

/* Line 1455 of yacc.c  */
#line 5669 "sql_yacc.yy"
    { (yyval.item)= (yyvsp[(1) - (1)].item); }
    break;

  case 866:

/* Line 1455 of yacc.c  */
#line 5674 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;

            {
              Select_Lex *sel= lex->current_select;
              if (sel->no_table_names_allowed)
              {
                my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                         MYF(0), (yyvsp[(1) - (3)].lex_str).str, session->where);
              }
              (yyval.item)= (sel->parsing_place != IN_HAVING ||
                  sel->get_in_sum_expr() > 0) ?
                  (Item*) new Item_field(Lex->current_context(),
                                         (const char *)NULL, (yyvsp[(1) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).str) :
                  (Item*) new Item_ref(Lex->current_context(),
                                       (const char *)NULL, (yyvsp[(1) - (3)].lex_str).str, (yyvsp[(3) - (3)].lex_str).str);
            }
          }
    break;

  case 867:

/* Line 1455 of yacc.c  */
#line 5694 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            Select_Lex *sel= lex->current_select;
            if (sel->no_table_names_allowed)
            {
              my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                       MYF(0), (yyvsp[(2) - (4)].lex_str).str, session->where);
            }
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(), NULL, (yyvsp[(2) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(),
                                     (const char *)NULL, (yyvsp[(2) - (4)].lex_str).str, (yyvsp[(4) - (4)].lex_str).str);
          }
    break;

  case 868:

/* Line 1455 of yacc.c  */
#line 5710 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            Select_Lex *sel= lex->current_select;
            if (sel->no_table_names_allowed)
            {
              my_error(ER_TABLENAME_NOT_ALLOWED_HERE,
                       MYF(0), (yyvsp[(3) - (5)].lex_str).str, session->where);
            }
            (yyval.item)= (sel->parsing_place != IN_HAVING ||
                sel->get_in_sum_expr() > 0) ?
                (Item*) new Item_field(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,
                                       (yyvsp[(5) - (5)].lex_str).str) :
                (Item*) new Item_ref(Lex->current_context(), (yyvsp[(1) - (5)].lex_str).str, (yyvsp[(3) - (5)].lex_str).str,
                                     (yyvsp[(5) - (5)].lex_str).str);
          }
    break;

  case 869:

/* Line 1455 of yacc.c  */
#line 5729 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 870:

/* Line 1455 of yacc.c  */
#line 5731 "sql_yacc.yy"
    {
            TableList *table=
              reinterpret_cast<TableList*>(Lex->current_select->table_list.first);
            if (my_strcasecmp(table_alias_charset, (yyvsp[(1) - (5)].lex_str).str, table->db))
            {
              my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (5)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            if (my_strcasecmp(table_alias_charset, (yyvsp[(3) - (5)].lex_str).str,
                              table->table_name))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(3) - (5)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)=(yyvsp[(5) - (5)].lex_str);
          }
    break;

  case 871:

/* Line 1455 of yacc.c  */
#line 5748 "sql_yacc.yy"
    {
            TableList *table=
              reinterpret_cast<TableList*>(Lex->current_select->table_list.first);
            if (my_strcasecmp(table_alias_charset, (yyvsp[(1) - (3)].lex_str).str, table->alias))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)=(yyvsp[(3) - (3)].lex_str);
          }
    break;

  case 872:

/* Line 1455 of yacc.c  */
#line 5758 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(2) - (2)].lex_str);}
    break;

  case 873:

/* Line 1455 of yacc.c  */
#line 5762 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(1) - (1)].lex_str)); }
    break;

  case 874:

/* Line 1455 of yacc.c  */
#line 5763 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(1) - (3)].lex_str),(yyvsp[(3) - (3)].lex_str));}
    break;

  case 875:

/* Line 1455 of yacc.c  */
#line 5764 "sql_yacc.yy"
    { (yyval.table)=new Table_ident((yyvsp[(2) - (2)].lex_str));}
    break;

  case 876:

/* Line 1455 of yacc.c  */
#line 5768 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 877:

/* Line 1455 of yacc.c  */
#line 5770 "sql_yacc.yy"
    {
            const CHARSET_INFO * const cs= system_charset_info;
            int dummy_error;
            uint32_t wlen= cs->cset->well_formed_len(cs, (yyvsp[(1) - (1)].lex_str).str,
                                                 (yyvsp[(1) - (1)].lex_str).str+(yyvsp[(1) - (1)].lex_str).length,
                                                 (yyvsp[(1) - (1)].lex_str).length, &dummy_error);
            if (wlen < (yyvsp[(1) - (1)].lex_str).length)
            {
              my_error(ER_INVALID_CHARACTER_STRING, MYF(0),
                       cs->csname, (yyvsp[(1) - (1)].lex_str).str + wlen);
              DRIZZLE_YYABORT;
            }
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 878:

/* Line 1455 of yacc.c  */
#line 5788 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 879:

/* Line 1455 of yacc.c  */
#line 5795 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 880:

/* Line 1455 of yacc.c  */
#line 5802 "sql_yacc.yy"
    {
            (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str);
          }
    break;

  case 881:

/* Line 1455 of yacc.c  */
#line 5808 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str); }
    break;

  case 882:

/* Line 1455 of yacc.c  */
#line 5810 "sql_yacc.yy"
    {
            Session *session= YYSession;
            (yyval.lex_str).str= session->strmake((yyvsp[(1) - (1)].symbol).str, (yyvsp[(1) - (1)].symbol).length);
            (yyval.lex_str).length= (yyvsp[(1) - (1)].symbol).length;
          }
    break;

  case 883:

/* Line 1455 of yacc.c  */
#line 5818 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 884:

/* Line 1455 of yacc.c  */
#line 5819 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 885:

/* Line 1455 of yacc.c  */
#line 5820 "sql_yacc.yy"
    { (yyval.lex_str)=(yyvsp[(1) - (1)].lex_str);}
    break;

  case 886:

/* Line 1455 of yacc.c  */
#line 5825 "sql_yacc.yy"
    {}
    break;

  case 887:

/* Line 1455 of yacc.c  */
#line 5826 "sql_yacc.yy"
    {}
    break;

  case 888:

/* Line 1455 of yacc.c  */
#line 5827 "sql_yacc.yy"
    {}
    break;

  case 889:

/* Line 1455 of yacc.c  */
#line 5828 "sql_yacc.yy"
    {}
    break;

  case 890:

/* Line 1455 of yacc.c  */
#line 5829 "sql_yacc.yy"
    {}
    break;

  case 891:

/* Line 1455 of yacc.c  */
#line 5830 "sql_yacc.yy"
    {}
    break;

  case 892:

/* Line 1455 of yacc.c  */
#line 5831 "sql_yacc.yy"
    {}
    break;

  case 893:

/* Line 1455 of yacc.c  */
#line 5832 "sql_yacc.yy"
    {}
    break;

  case 894:

/* Line 1455 of yacc.c  */
#line 5833 "sql_yacc.yy"
    {}
    break;

  case 895:

/* Line 1455 of yacc.c  */
#line 5834 "sql_yacc.yy"
    {}
    break;

  case 896:

/* Line 1455 of yacc.c  */
#line 5835 "sql_yacc.yy"
    {}
    break;

  case 897:

/* Line 1455 of yacc.c  */
#line 5836 "sql_yacc.yy"
    {}
    break;

  case 898:

/* Line 1455 of yacc.c  */
#line 5837 "sql_yacc.yy"
    {}
    break;

  case 899:

/* Line 1455 of yacc.c  */
#line 5838 "sql_yacc.yy"
    {}
    break;

  case 900:

/* Line 1455 of yacc.c  */
#line 5839 "sql_yacc.yy"
    {}
    break;

  case 901:

/* Line 1455 of yacc.c  */
#line 5840 "sql_yacc.yy"
    {}
    break;

  case 902:

/* Line 1455 of yacc.c  */
#line 5841 "sql_yacc.yy"
    {}
    break;

  case 903:

/* Line 1455 of yacc.c  */
#line 5842 "sql_yacc.yy"
    {}
    break;

  case 904:

/* Line 1455 of yacc.c  */
#line 5843 "sql_yacc.yy"
    {}
    break;

  case 905:

/* Line 1455 of yacc.c  */
#line 5844 "sql_yacc.yy"
    {}
    break;

  case 906:

/* Line 1455 of yacc.c  */
#line 5854 "sql_yacc.yy"
    {}
    break;

  case 907:

/* Line 1455 of yacc.c  */
#line 5855 "sql_yacc.yy"
    {}
    break;

  case 908:

/* Line 1455 of yacc.c  */
#line 5856 "sql_yacc.yy"
    {}
    break;

  case 909:

/* Line 1455 of yacc.c  */
#line 5857 "sql_yacc.yy"
    {}
    break;

  case 910:

/* Line 1455 of yacc.c  */
#line 5858 "sql_yacc.yy"
    {}
    break;

  case 911:

/* Line 1455 of yacc.c  */
#line 5859 "sql_yacc.yy"
    {}
    break;

  case 912:

/* Line 1455 of yacc.c  */
#line 5860 "sql_yacc.yy"
    {}
    break;

  case 913:

/* Line 1455 of yacc.c  */
#line 5861 "sql_yacc.yy"
    {}
    break;

  case 914:

/* Line 1455 of yacc.c  */
#line 5862 "sql_yacc.yy"
    {}
    break;

  case 915:

/* Line 1455 of yacc.c  */
#line 5863 "sql_yacc.yy"
    {}
    break;

  case 916:

/* Line 1455 of yacc.c  */
#line 5864 "sql_yacc.yy"
    {}
    break;

  case 917:

/* Line 1455 of yacc.c  */
#line 5865 "sql_yacc.yy"
    {}
    break;

  case 918:

/* Line 1455 of yacc.c  */
#line 5866 "sql_yacc.yy"
    {}
    break;

  case 919:

/* Line 1455 of yacc.c  */
#line 5867 "sql_yacc.yy"
    {}
    break;

  case 920:

/* Line 1455 of yacc.c  */
#line 5868 "sql_yacc.yy"
    {}
    break;

  case 921:

/* Line 1455 of yacc.c  */
#line 5869 "sql_yacc.yy"
    {}
    break;

  case 922:

/* Line 1455 of yacc.c  */
#line 5870 "sql_yacc.yy"
    {}
    break;

  case 923:

/* Line 1455 of yacc.c  */
#line 5871 "sql_yacc.yy"
    {}
    break;

  case 924:

/* Line 1455 of yacc.c  */
#line 5872 "sql_yacc.yy"
    {}
    break;

  case 925:

/* Line 1455 of yacc.c  */
#line 5873 "sql_yacc.yy"
    {}
    break;

  case 926:

/* Line 1455 of yacc.c  */
#line 5874 "sql_yacc.yy"
    {}
    break;

  case 927:

/* Line 1455 of yacc.c  */
#line 5875 "sql_yacc.yy"
    {}
    break;

  case 928:

/* Line 1455 of yacc.c  */
#line 5876 "sql_yacc.yy"
    {}
    break;

  case 929:

/* Line 1455 of yacc.c  */
#line 5877 "sql_yacc.yy"
    {}
    break;

  case 930:

/* Line 1455 of yacc.c  */
#line 5878 "sql_yacc.yy"
    {}
    break;

  case 931:

/* Line 1455 of yacc.c  */
#line 5879 "sql_yacc.yy"
    {}
    break;

  case 932:

/* Line 1455 of yacc.c  */
#line 5880 "sql_yacc.yy"
    {}
    break;

  case 933:

/* Line 1455 of yacc.c  */
#line 5881 "sql_yacc.yy"
    {}
    break;

  case 934:

/* Line 1455 of yacc.c  */
#line 5882 "sql_yacc.yy"
    {}
    break;

  case 935:

/* Line 1455 of yacc.c  */
#line 5883 "sql_yacc.yy"
    {}
    break;

  case 936:

/* Line 1455 of yacc.c  */
#line 5884 "sql_yacc.yy"
    {}
    break;

  case 937:

/* Line 1455 of yacc.c  */
#line 5885 "sql_yacc.yy"
    {}
    break;

  case 938:

/* Line 1455 of yacc.c  */
#line 5886 "sql_yacc.yy"
    {}
    break;

  case 939:

/* Line 1455 of yacc.c  */
#line 5887 "sql_yacc.yy"
    {}
    break;

  case 940:

/* Line 1455 of yacc.c  */
#line 5888 "sql_yacc.yy"
    {}
    break;

  case 941:

/* Line 1455 of yacc.c  */
#line 5889 "sql_yacc.yy"
    {}
    break;

  case 942:

/* Line 1455 of yacc.c  */
#line 5890 "sql_yacc.yy"
    {}
    break;

  case 943:

/* Line 1455 of yacc.c  */
#line 5891 "sql_yacc.yy"
    {}
    break;

  case 944:

/* Line 1455 of yacc.c  */
#line 5892 "sql_yacc.yy"
    {}
    break;

  case 945:

/* Line 1455 of yacc.c  */
#line 5893 "sql_yacc.yy"
    {}
    break;

  case 946:

/* Line 1455 of yacc.c  */
#line 5894 "sql_yacc.yy"
    {}
    break;

  case 947:

/* Line 1455 of yacc.c  */
#line 5895 "sql_yacc.yy"
    {}
    break;

  case 948:

/* Line 1455 of yacc.c  */
#line 5896 "sql_yacc.yy"
    {}
    break;

  case 949:

/* Line 1455 of yacc.c  */
#line 5897 "sql_yacc.yy"
    {}
    break;

  case 950:

/* Line 1455 of yacc.c  */
#line 5898 "sql_yacc.yy"
    {}
    break;

  case 951:

/* Line 1455 of yacc.c  */
#line 5899 "sql_yacc.yy"
    {}
    break;

  case 952:

/* Line 1455 of yacc.c  */
#line 5900 "sql_yacc.yy"
    {}
    break;

  case 953:

/* Line 1455 of yacc.c  */
#line 5901 "sql_yacc.yy"
    {}
    break;

  case 954:

/* Line 1455 of yacc.c  */
#line 5902 "sql_yacc.yy"
    {}
    break;

  case 955:

/* Line 1455 of yacc.c  */
#line 5903 "sql_yacc.yy"
    {}
    break;

  case 956:

/* Line 1455 of yacc.c  */
#line 5904 "sql_yacc.yy"
    {}
    break;

  case 957:

/* Line 1455 of yacc.c  */
#line 5905 "sql_yacc.yy"
    {}
    break;

  case 958:

/* Line 1455 of yacc.c  */
#line 5906 "sql_yacc.yy"
    {}
    break;

  case 959:

/* Line 1455 of yacc.c  */
#line 5907 "sql_yacc.yy"
    {}
    break;

  case 960:

/* Line 1455 of yacc.c  */
#line 5908 "sql_yacc.yy"
    {}
    break;

  case 961:

/* Line 1455 of yacc.c  */
#line 5909 "sql_yacc.yy"
    {}
    break;

  case 962:

/* Line 1455 of yacc.c  */
#line 5910 "sql_yacc.yy"
    {}
    break;

  case 963:

/* Line 1455 of yacc.c  */
#line 5911 "sql_yacc.yy"
    {}
    break;

  case 964:

/* Line 1455 of yacc.c  */
#line 5912 "sql_yacc.yy"
    {}
    break;

  case 965:

/* Line 1455 of yacc.c  */
#line 5913 "sql_yacc.yy"
    {}
    break;

  case 966:

/* Line 1455 of yacc.c  */
#line 5914 "sql_yacc.yy"
    {}
    break;

  case 967:

/* Line 1455 of yacc.c  */
#line 5915 "sql_yacc.yy"
    {}
    break;

  case 968:

/* Line 1455 of yacc.c  */
#line 5916 "sql_yacc.yy"
    {}
    break;

  case 969:

/* Line 1455 of yacc.c  */
#line 5917 "sql_yacc.yy"
    {}
    break;

  case 970:

/* Line 1455 of yacc.c  */
#line 5918 "sql_yacc.yy"
    {}
    break;

  case 971:

/* Line 1455 of yacc.c  */
#line 5919 "sql_yacc.yy"
    {}
    break;

  case 972:

/* Line 1455 of yacc.c  */
#line 5920 "sql_yacc.yy"
    {}
    break;

  case 973:

/* Line 1455 of yacc.c  */
#line 5921 "sql_yacc.yy"
    {}
    break;

  case 974:

/* Line 1455 of yacc.c  */
#line 5922 "sql_yacc.yy"
    {}
    break;

  case 975:

/* Line 1455 of yacc.c  */
#line 5923 "sql_yacc.yy"
    {}
    break;

  case 976:

/* Line 1455 of yacc.c  */
#line 5924 "sql_yacc.yy"
    {}
    break;

  case 977:

/* Line 1455 of yacc.c  */
#line 5925 "sql_yacc.yy"
    {}
    break;

  case 978:

/* Line 1455 of yacc.c  */
#line 5926 "sql_yacc.yy"
    {}
    break;

  case 979:

/* Line 1455 of yacc.c  */
#line 5927 "sql_yacc.yy"
    {}
    break;

  case 980:

/* Line 1455 of yacc.c  */
#line 5928 "sql_yacc.yy"
    {}
    break;

  case 981:

/* Line 1455 of yacc.c  */
#line 5929 "sql_yacc.yy"
    {}
    break;

  case 982:

/* Line 1455 of yacc.c  */
#line 5930 "sql_yacc.yy"
    {}
    break;

  case 983:

/* Line 1455 of yacc.c  */
#line 5931 "sql_yacc.yy"
    {}
    break;

  case 984:

/* Line 1455 of yacc.c  */
#line 5932 "sql_yacc.yy"
    {}
    break;

  case 985:

/* Line 1455 of yacc.c  */
#line 5933 "sql_yacc.yy"
    {}
    break;

  case 986:

/* Line 1455 of yacc.c  */
#line 5934 "sql_yacc.yy"
    {}
    break;

  case 987:

/* Line 1455 of yacc.c  */
#line 5935 "sql_yacc.yy"
    {}
    break;

  case 988:

/* Line 1455 of yacc.c  */
#line 5936 "sql_yacc.yy"
    {}
    break;

  case 989:

/* Line 1455 of yacc.c  */
#line 5937 "sql_yacc.yy"
    {}
    break;

  case 990:

/* Line 1455 of yacc.c  */
#line 5938 "sql_yacc.yy"
    {}
    break;

  case 991:

/* Line 1455 of yacc.c  */
#line 5939 "sql_yacc.yy"
    {}
    break;

  case 992:

/* Line 1455 of yacc.c  */
#line 5940 "sql_yacc.yy"
    {}
    break;

  case 993:

/* Line 1455 of yacc.c  */
#line 5941 "sql_yacc.yy"
    {}
    break;

  case 994:

/* Line 1455 of yacc.c  */
#line 5942 "sql_yacc.yy"
    {}
    break;

  case 995:

/* Line 1455 of yacc.c  */
#line 5943 "sql_yacc.yy"
    {}
    break;

  case 996:

/* Line 1455 of yacc.c  */
#line 5944 "sql_yacc.yy"
    {}
    break;

  case 997:

/* Line 1455 of yacc.c  */
#line 5945 "sql_yacc.yy"
    {}
    break;

  case 998:

/* Line 1455 of yacc.c  */
#line 5946 "sql_yacc.yy"
    {}
    break;

  case 999:

/* Line 1455 of yacc.c  */
#line 5947 "sql_yacc.yy"
    {}
    break;

  case 1000:

/* Line 1455 of yacc.c  */
#line 5948 "sql_yacc.yy"
    {}
    break;

  case 1001:

/* Line 1455 of yacc.c  */
#line 5949 "sql_yacc.yy"
    {}
    break;

  case 1002:

/* Line 1455 of yacc.c  */
#line 5950 "sql_yacc.yy"
    {}
    break;

  case 1003:

/* Line 1455 of yacc.c  */
#line 5951 "sql_yacc.yy"
    {}
    break;

  case 1004:

/* Line 1455 of yacc.c  */
#line 5952 "sql_yacc.yy"
    {}
    break;

  case 1005:

/* Line 1455 of yacc.c  */
#line 5953 "sql_yacc.yy"
    {}
    break;

  case 1006:

/* Line 1455 of yacc.c  */
#line 5954 "sql_yacc.yy"
    {}
    break;

  case 1007:

/* Line 1455 of yacc.c  */
#line 5955 "sql_yacc.yy"
    {}
    break;

  case 1008:

/* Line 1455 of yacc.c  */
#line 5956 "sql_yacc.yy"
    {}
    break;

  case 1009:

/* Line 1455 of yacc.c  */
#line 5957 "sql_yacc.yy"
    {}
    break;

  case 1010:

/* Line 1455 of yacc.c  */
#line 5958 "sql_yacc.yy"
    {}
    break;

  case 1011:

/* Line 1455 of yacc.c  */
#line 5959 "sql_yacc.yy"
    {}
    break;

  case 1012:

/* Line 1455 of yacc.c  */
#line 5960 "sql_yacc.yy"
    {}
    break;

  case 1013:

/* Line 1455 of yacc.c  */
#line 5961 "sql_yacc.yy"
    {}
    break;

  case 1014:

/* Line 1455 of yacc.c  */
#line 5962 "sql_yacc.yy"
    {}
    break;

  case 1015:

/* Line 1455 of yacc.c  */
#line 5963 "sql_yacc.yy"
    {}
    break;

  case 1016:

/* Line 1455 of yacc.c  */
#line 5964 "sql_yacc.yy"
    {}
    break;

  case 1017:

/* Line 1455 of yacc.c  */
#line 5965 "sql_yacc.yy"
    {}
    break;

  case 1018:

/* Line 1455 of yacc.c  */
#line 5966 "sql_yacc.yy"
    {}
    break;

  case 1019:

/* Line 1455 of yacc.c  */
#line 5967 "sql_yacc.yy"
    {}
    break;

  case 1020:

/* Line 1455 of yacc.c  */
#line 5968 "sql_yacc.yy"
    {}
    break;

  case 1021:

/* Line 1455 of yacc.c  */
#line 5969 "sql_yacc.yy"
    {}
    break;

  case 1022:

/* Line 1455 of yacc.c  */
#line 5970 "sql_yacc.yy"
    {}
    break;

  case 1023:

/* Line 1455 of yacc.c  */
#line 5971 "sql_yacc.yy"
    {}
    break;

  case 1024:

/* Line 1455 of yacc.c  */
#line 5972 "sql_yacc.yy"
    {}
    break;

  case 1025:

/* Line 1455 of yacc.c  */
#line 5973 "sql_yacc.yy"
    {}
    break;

  case 1026:

/* Line 1455 of yacc.c  */
#line 5974 "sql_yacc.yy"
    {}
    break;

  case 1027:

/* Line 1455 of yacc.c  */
#line 5975 "sql_yacc.yy"
    {}
    break;

  case 1028:

/* Line 1455 of yacc.c  */
#line 5976 "sql_yacc.yy"
    {}
    break;

  case 1029:

/* Line 1455 of yacc.c  */
#line 5977 "sql_yacc.yy"
    {}
    break;

  case 1030:

/* Line 1455 of yacc.c  */
#line 5978 "sql_yacc.yy"
    {}
    break;

  case 1031:

/* Line 1455 of yacc.c  */
#line 5979 "sql_yacc.yy"
    {}
    break;

  case 1032:

/* Line 1455 of yacc.c  */
#line 5980 "sql_yacc.yy"
    {}
    break;

  case 1033:

/* Line 1455 of yacc.c  */
#line 5981 "sql_yacc.yy"
    {}
    break;

  case 1034:

/* Line 1455 of yacc.c  */
#line 5982 "sql_yacc.yy"
    {}
    break;

  case 1035:

/* Line 1455 of yacc.c  */
#line 5983 "sql_yacc.yy"
    {}
    break;

  case 1036:

/* Line 1455 of yacc.c  */
#line 5984 "sql_yacc.yy"
    {}
    break;

  case 1037:

/* Line 1455 of yacc.c  */
#line 5985 "sql_yacc.yy"
    {}
    break;

  case 1038:

/* Line 1455 of yacc.c  */
#line 5986 "sql_yacc.yy"
    {}
    break;

  case 1039:

/* Line 1455 of yacc.c  */
#line 5987 "sql_yacc.yy"
    {}
    break;

  case 1040:

/* Line 1455 of yacc.c  */
#line 5988 "sql_yacc.yy"
    {}
    break;

  case 1041:

/* Line 1455 of yacc.c  */
#line 5989 "sql_yacc.yy"
    {}
    break;

  case 1042:

/* Line 1455 of yacc.c  */
#line 5990 "sql_yacc.yy"
    {}
    break;

  case 1043:

/* Line 1455 of yacc.c  */
#line 5991 "sql_yacc.yy"
    {}
    break;

  case 1044:

/* Line 1455 of yacc.c  */
#line 5992 "sql_yacc.yy"
    {}
    break;

  case 1045:

/* Line 1455 of yacc.c  */
#line 5993 "sql_yacc.yy"
    {}
    break;

  case 1046:

/* Line 1455 of yacc.c  */
#line 5994 "sql_yacc.yy"
    {}
    break;

  case 1047:

/* Line 1455 of yacc.c  */
#line 6001 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_SET_OPTION;
            statement::SetOption *statement= new(std::nothrow) statement::SetOption(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            mysql_init_select(lex);
            lex->option_type=OPT_SESSION;
            lex->var_list.empty();
          }
    break;

  case 1048:

/* Line 1455 of yacc.c  */
#line 6013 "sql_yacc.yy"
    {}
    break;

  case 1049:

/* Line 1455 of yacc.c  */
#line 6017 "sql_yacc.yy"
    {}
    break;

  case 1050:

/* Line 1455 of yacc.c  */
#line 6018 "sql_yacc.yy"
    {}
    break;

  case 1053:

/* Line 1455 of yacc.c  */
#line 6027 "sql_yacc.yy"
    {
          }
    break;

  case 1054:

/* Line 1455 of yacc.c  */
#line 6030 "sql_yacc.yy"
    {
          }
    break;

  case 1055:

/* Line 1455 of yacc.c  */
#line 6035 "sql_yacc.yy"
    {}
    break;

  case 1056:

/* Line 1455 of yacc.c  */
#line 6036 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1057:

/* Line 1455 of yacc.c  */
#line 6037 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1058:

/* Line 1455 of yacc.c  */
#line 6038 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1059:

/* Line 1455 of yacc.c  */
#line 6042 "sql_yacc.yy"
    { (yyval.num)= OPT_DEFAULT; }
    break;

  case 1060:

/* Line 1455 of yacc.c  */
#line 6043 "sql_yacc.yy"
    { ((statement::SetOption *)Lex->statement)->one_shot_set= true; (yyval.num)= OPT_SESSION; }
    break;

  case 1061:

/* Line 1455 of yacc.c  */
#line 6047 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1062:

/* Line 1455 of yacc.c  */
#line 6048 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1063:

/* Line 1455 of yacc.c  */
#line 6049 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1064:

/* Line 1455 of yacc.c  */
#line 6050 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1065:

/* Line 1455 of yacc.c  */
#line 6054 "sql_yacc.yy"
    { (yyval.var_type)=OPT_DEFAULT; }
    break;

  case 1066:

/* Line 1455 of yacc.c  */
#line 6055 "sql_yacc.yy"
    { (yyval.var_type)=OPT_GLOBAL; }
    break;

  case 1067:

/* Line 1455 of yacc.c  */
#line 6056 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1068:

/* Line 1455 of yacc.c  */
#line 6057 "sql_yacc.yy"
    { (yyval.var_type)=OPT_SESSION; }
    break;

  case 1071:

/* Line 1455 of yacc.c  */
#line 6067 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            if ((yyvsp[(2) - (4)].variable).var)
            { /* System variable */
              if ((yyvsp[(1) - (4)].var_type))
                lex->option_type= (yyvsp[(1) - (4)].var_type);
              lex->var_list.push_back(new set_var(lex->option_type, (yyvsp[(2) - (4)].variable).var,
                                      &(yyvsp[(2) - (4)].variable).base_name, (yyvsp[(4) - (4)].item)));
            }
          }
    break;

  case 1072:

/* Line 1455 of yacc.c  */
#line 6079 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->option_type= (yyvsp[(1) - (5)].var_type);
            lex->var_list.push_back(new set_var(lex->option_type,
                                                find_sys_var(YYSession, "tx_isolation"),
                                                &null_lex_str,
                                                new Item_int((int32_t) (yyvsp[(5) - (5)].tx_isolation))));
          }
    break;

  case 1073:

/* Line 1455 of yacc.c  */
#line 6091 "sql_yacc.yy"
    {
            Lex->var_list.push_back(new set_var_user(new Item_func_set_user_var((yyvsp[(2) - (4)].lex_str),(yyvsp[(4) - (4)].item))));
          }
    break;

  case 1074:

/* Line 1455 of yacc.c  */
#line 6095 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->var_list.push_back(new set_var((yyvsp[(3) - (6)].var_type), (yyvsp[(4) - (6)].variable).var, &(yyvsp[(4) - (6)].variable).base_name, (yyvsp[(6) - (6)].item)));
          }
    break;

  case 1075:

/* Line 1455 of yacc.c  */
#line 6103 "sql_yacc.yy"
    {
            Session *session= YYSession;

            /* We have to lookup here since local vars can shadow sysvars */
            {
              /* Not an SP local variable */
              sys_var *tmp=find_sys_var(session, (yyvsp[(1) - (1)].lex_str).str, (yyvsp[(1) - (1)].lex_str).length);
              if (!tmp)
                DRIZZLE_YYABORT;
              (yyval.variable).var= tmp;
              (yyval.variable).base_name= null_lex_str;
            }
          }
    break;

  case 1076:

/* Line 1455 of yacc.c  */
#line 6119 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_READ_UNCOMMITTED; }
    break;

  case 1077:

/* Line 1455 of yacc.c  */
#line 6120 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_READ_COMMITTED; }
    break;

  case 1078:

/* Line 1455 of yacc.c  */
#line 6121 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_REPEATABLE_READ; }
    break;

  case 1079:

/* Line 1455 of yacc.c  */
#line 6122 "sql_yacc.yy"
    { (yyval.tx_isolation)= ISO_SERIALIZABLE; }
    break;

  case 1080:

/* Line 1455 of yacc.c  */
#line 6126 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[(1) - (1)].item); }
    break;

  case 1081:

/* Line 1455 of yacc.c  */
#line 6127 "sql_yacc.yy"
    { (yyval.item)=0; }
    break;

  case 1082:

/* Line 1455 of yacc.c  */
#line 6128 "sql_yacc.yy"
    { (yyval.item)=new Item_string("ON",  2, system_charset_info); }
    break;

  case 1083:

/* Line 1455 of yacc.c  */
#line 6129 "sql_yacc.yy"
    { (yyval.item)=new Item_string("ALL", 3, system_charset_info); }
    break;

  case 1084:

/* Line 1455 of yacc.c  */
#line 6130 "sql_yacc.yy"
    { (yyval.item)=new Item_string("binary", 6, system_charset_info); }
    break;

  case 1087:

/* Line 1455 of yacc.c  */
#line 6140 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_UNLOCK_TABLES;
            lex->statement= new(std::nothrow) statement::UnlockTables(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 1088:

/* Line 1455 of yacc.c  */
#line 6148 "sql_yacc.yy"
    {}
    break;

  case 1089:

/* Line 1455 of yacc.c  */
#line 6153 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command = SQLCOM_BEGIN;
            lex->statement= new(std::nothrow) statement::StartTransaction(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
          }
    break;

  case 1090:

/* Line 1455 of yacc.c  */
#line 6160 "sql_yacc.yy"
    {}
    break;

  case 1091:

/* Line 1455 of yacc.c  */
#line 6164 "sql_yacc.yy"
    {}
    break;

  case 1092:

/* Line 1455 of yacc.c  */
#line 6165 "sql_yacc.yy"
    {}
    break;

  case 1093:

/* Line 1455 of yacc.c  */
#line 6170 "sql_yacc.yy"
    { (yyval.num)= (YYSession->variables.completion_type == 1); }
    break;

  case 1094:

/* Line 1455 of yacc.c  */
#line 6171 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1095:

/* Line 1455 of yacc.c  */
#line 6172 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1096:

/* Line 1455 of yacc.c  */
#line 6177 "sql_yacc.yy"
    { (yyval.num)= (YYSession->variables.completion_type == 2); }
    break;

  case 1097:

/* Line 1455 of yacc.c  */
#line 6178 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1098:

/* Line 1455 of yacc.c  */
#line 6179 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1099:

/* Line 1455 of yacc.c  */
#line 6183 "sql_yacc.yy"
    {}
    break;

  case 1100:

/* Line 1455 of yacc.c  */
#line 6184 "sql_yacc.yy"
    {}
    break;

  case 1101:

/* Line 1455 of yacc.c  */
#line 6189 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_COMMIT;
            statement::Commit *statement= new(std::nothrow) statement::Commit(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->tx_chain= (yyvsp[(3) - (4)].num);
            statement->tx_release= (yyvsp[(4) - (4)].num);
          }
    break;

  case 1102:

/* Line 1455 of yacc.c  */
#line 6203 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_ROLLBACK;
            statement::Rollback *statement= new(std::nothrow) statement::Rollback(YYSession);
            lex->statement= statement;
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            statement->tx_chain= (yyvsp[(3) - (4)].num);
            statement->tx_release= (yyvsp[(4) - (4)].num);
          }
    break;

  case 1103:

/* Line 1455 of yacc.c  */
#line 6215 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_ROLLBACK_TO_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::RollbackToSavepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(5) - (5)].lex_str);
          }
    break;

  case 1104:

/* Line 1455 of yacc.c  */
#line 6227 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::Savepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(2) - (2)].lex_str);
          }
    break;

  case 1105:

/* Line 1455 of yacc.c  */
#line 6239 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->sql_command= SQLCOM_RELEASE_SAVEPOINT;
            lex->statement= new(std::nothrow) statement::ReleaseSavepoint(YYSession);
            if (lex->statement == NULL)
              DRIZZLE_YYABORT;
            lex->ident= (yyvsp[(3) - (3)].lex_str);
          }
    break;

  case 1106:

/* Line 1455 of yacc.c  */
#line 6255 "sql_yacc.yy"
    {}
    break;

  case 1108:

/* Line 1455 of yacc.c  */
#line 6261 "sql_yacc.yy"
    {
            if (add_select_to_union_list(YYSession, Lex, (bool)(yyvsp[(2) - (2)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 1109:

/* Line 1455 of yacc.c  */
#line 6266 "sql_yacc.yy"
    {
            /*
              Remove from the name resolution context stack the context of the
              last select in the union.
            */
            Lex->pop_context();
          }
    break;

  case 1110:

/* Line 1455 of yacc.c  */
#line 6276 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 1111:

/* Line 1455 of yacc.c  */
#line 6277 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 1112:

/* Line 1455 of yacc.c  */
#line 6278 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 1113:

/* Line 1455 of yacc.c  */
#line 6282 "sql_yacc.yy"
    {
            Session *session= YYSession;
            LEX *lex= session->lex;
            assert(lex->current_select->linkage != GLOBAL_OPTIONS_TYPE);
            Select_Lex *sel= lex->current_select;
            Select_Lex_Unit *unit= sel->master_unit();
            Select_Lex *fake= unit->fake_select_lex;
            if (fake)
            {
              unit->global_parameters= fake;
              fake->no_table_names_allowed= 1;
              lex->current_select= fake;
            }
            session->where= "global ORDER clause";
          }
    break;

  case 1114:

/* Line 1455 of yacc.c  */
#line 6298 "sql_yacc.yy"
    {
            Session *session= YYSession;
            session->lex->current_select->no_table_names_allowed= 0;
            session->where= "";
          }
    break;

  case 1117:

/* Line 1455 of yacc.c  */
#line 6311 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1118:

/* Line 1455 of yacc.c  */
#line 6312 "sql_yacc.yy"
    { (yyval.num)=1; }
    break;

  case 1119:

/* Line 1455 of yacc.c  */
#line 6313 "sql_yacc.yy"
    { (yyval.num)=0; }
    break;

  case 1120:

/* Line 1455 of yacc.c  */
#line 6318 "sql_yacc.yy"
    {
            (yyval.select_lex)= Lex->current_select->master_unit()->first_select();
          }
    break;

  case 1121:

/* Line 1455 of yacc.c  */
#line 6322 "sql_yacc.yy"
    {
            (yyval.select_lex)= Lex->current_select->master_unit()->first_select();
          }
    break;

  case 1123:

/* Line 1455 of yacc.c  */
#line 6331 "sql_yacc.yy"
    {
            if (add_select_to_union_list(YYSession, Lex, (bool)(yyvsp[(3) - (3)].num)))
              DRIZZLE_YYABORT;
          }
    break;

  case 1124:

/* Line 1455 of yacc.c  */
#line 6336 "sql_yacc.yy"
    {
            Lex->pop_context();
            (yyval.select_lex)= (yyvsp[(1) - (5)].select_lex);
          }
    break;

  case 1125:

/* Line 1455 of yacc.c  */
#line 6345 "sql_yacc.yy"
    {
            (yyval.select_lex)= (yyvsp[(2) - (3)].select_lex);
          }
    break;

  case 1126:

/* Line 1455 of yacc.c  */
#line 6351 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (!lex->expr_allows_subselect)
            {
              struct my_parse_error_st pass= { ER(ER_SYNTAX_ERROR), YYSession };
              my_parse_error(&pass);
              DRIZZLE_YYABORT;
            }
            /*
              we are making a "derived table" for the parenthesis
              as we need to have a lex level to fit the union
              after the parenthesis, e.g.
              (SELECT .. ) UNION ...  becomes
              SELECT * FROM ((SELECT ...) UNION ...)
            */
            if (mysql_new_select(Lex, 1))
              DRIZZLE_YYABORT;
          }
    break;

  case 1127:

/* Line 1455 of yacc.c  */
#line 6372 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->pop_context();
            Select_Lex *child= lex->current_select;
            lex->current_select = lex->current_select->return_after_parsing();
            lex->nest_level--;
            lex->current_select->n_child_sum_items += child->n_sum_items;
            /*
              A subselect can add fields to an outer select. Reserve space for
              them.
            */
            lex->current_select->select_n_where_fields+=
            child->select_n_where_fields;
          }
    break;



/* Line 1455 of yacc.c  */
#line 17568 "drizzled/sql_yacc.cc"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



