unit UnitDetecteUTF8;

{$mode objfpc}{$H+}

interface
type
TTxtFileType = (txTxtOrBin,
txUTF8,
txUNICODE,
txUNIBIG,
txRTF,
txWORDDOC
);

TTxtFileSign = record
 Code : TTxtFileType;
 Sign : LongWord;
 Mask : LongWord;
 end;

 const
 TxtSignsCount = 5;
 TxtSign_UTF8 : TTxtFileSign = (Code: txUTF8; Sign:$00BFBBEF; Mask: $00FFFFFF);
 TxtSign_UNICODE : TTxtFileSign = (Code: txUNICODE; Sign:$0000FEFF; Mask: $FF00FFFF);
 TxtSign_UNIBIG : TTxtFileSign = (Code: txUNIBIG; Sign:$0000FFFE; Mask: $00FFFFFF);
 TxtSign_RTF : TTxtFileSign = (Code: txRTF; Sign:$74725C7B; Mask: $FFFFFFFF);
 TxtSign_WORDDOC : TTxtFileSign = (Code: txWORDDOC; Sign:$E011CFD0; Mask: $FFFFFFFF);

  var
  TxtFileSigns : array[0..TxtSignsCount-1] of TTxtFileSign = (
 (Code: txUTF8; Sign:$00BFBBEF; Mask: $00FFFFFF),
(Code: txUNICODE; Sign:$0000FEFF; Mask: $FF00FFFF),
 (Code: txUNIBIG; Sign:$0000FFFE; Mask: $00FFFFFF),
 (Code: txRTF; Sign:$74725C7B; Mask: $FFFFFFFF),
 (Code: txWORDDOC; Sign:$E011CFD0; Mask: $FFFFFFFF)
 );

 function TypeOfTextfile(const filename : string) : TTxtFileType;

 implementation

uses
  Classes, SysUtils; 



 function TypeOfTextfile(const filename : string) : TTxtFileType;
 var
 Flux : TFileStream;
 Sign : LongWord;
 N : integer;


 begin
 Flux := TFileStream.Create(FileName, fmOpenRead);
 try
 Flux.Read(Sign, 4);
 finally
 Flux.Free;
 end;

 result := txTxtOrBin;

 for N := 0 to High(TxtFileSigns) do
 begin
 if (Sign and TxtFileSigns[N].Mask) = TxtFileSigns[N].Sign then
 begin
 result := TxtFileSigns[N].Code;
 break;
 end;
 end;
 end;
end.

