// This code conforms with the UFC specification version 2.0.3
// and was automatically generated by FFC version 1.0-beta2+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_3_H
#define __POISSON3D_3_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_3_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_3_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 20;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0130410132739325, 0.00752923252421044, 0.0053239713749995, 0.018298126367785, 0.014173667737846, 0.0115727512471569, 0.00818317088384972, 0.0066815310478106, 0.00472455591261534, -0.028347335475692, -0.0239578711874977, -0.0207481250689683, -0.0185576872239523, -0.0160714285714286, -0.0131222664791956, -0.0107142857142857, -0.00927884361197612, -0.00757614408414159, -0.00535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, -0.0130410132739325, 0.00752923252421043, 0.0053239713749995, 0.018298126367785, -0.014173667737846, -0.0115727512471569, 0.00818317088384972, 0.00668153104781061, 0.00472455591261535, 0.028347335475692, -0.0239578711874977, -0.0207481250689683, 0.0185576872239523, 0.0160714285714286, 0.0131222664791956, -0.0107142857142857, -0.00927884361197613, -0.00757614408414158, -0.00535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0, -0.0150584650484208, 0.0053239713749995, 0.0, 0.0, 0.0, 0.0245495126515491, -0.0133630620956212, 0.00472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0428571428571429, -0.0278365308359284, 0.0151522881682832, -0.00535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0, 0.0, -0.0159719141249985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0283473354756921, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0, 0.112938487863156, -0.063887656499994, 0.0, 0.0, 0.0, 0.0736485379546474, 0.0267261241912424, -0.0236227795630767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0649519052838329, -0.0606091526731326, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0, -0.0225876975726313, 0.127775312999988, 0.0, 0.0, 0.0, 0.0, 0.0668153104781061, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0757614408414158, -0.0535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0978075995544939, -0.0564692439315782, -0.063887656499994, 0.054894379103355, -0.042521003213538, 0.0231455024943138, 0.0245495126515491, -0.0133630620956212, -0.0236227795630767, 0.0, 0.0, 0.0484122918275927, 0.0, -0.0375, -0.0524890659167824, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0195615199108988, 0.0112938487863156, 0.127775312999988, 0.0, 0.0, 0.0578637562357845, 0.0, -0.0334076552390531, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.065611332395978, 0.0, 0.0, -0.0378807204207079, -0.0535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0978075995544939, -0.0790569415042095, -0.031943828249997, 0.054894379103355, 0.014173667737846, -0.0462910049886276, -0.0245495126515492, 0.0133630620956212, 0.0236227795630767, 0.0, 0.0479157423749955, -0.0069160416896561, -0.0618589574131742, -0.0160714285714286, 0.00874817765279707, 0.0428571428571429, 0.0154647393532935, 0.0, -0.00535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0195615199108988, 0.124232336649472, -0.031943828249997, 0.0, 0.0566946709513841, -0.0115727512471569, 0.0245495126515492, -0.0467707173346743, 0.0236227795630767, 0.0, 0.0, 0.0, 0.0618589574131742, -0.0214285714285714, 0.00437408882639853, -0.0642857142857143, 0.00927884361197613, 0.00757614408414159, -0.00535714285714285};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0978075995544939, -0.0564692439315782, -0.063887656499994, 0.054894379103355, 0.042521003213538, -0.0231455024943138, 0.0245495126515491, -0.0133630620956212, -0.0236227795630767, 0.0, 0.0, 0.0484122918275927, 0.0, 0.0375, 0.0524890659167824, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0195615199108988, 0.0112938487863156, 0.127775312999988, 0.0, 0.0, -0.0578637562357845, 0.0, -0.0334076552390531, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, -0.065611332395978, 0.0, 0.0, -0.0378807204207079, -0.0535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0978075995544939, -0.0790569415042095, -0.031943828249997, 0.054894379103355, -0.014173667737846, 0.0462910049886276, -0.0245495126515492, 0.0133630620956212, 0.0236227795630767, 0.0, 0.0479157423749955, -0.0069160416896561, 0.0618589574131742, 0.0160714285714286, -0.00874817765279707, 0.0428571428571429, 0.0154647393532935, 0.0, -0.00535714285714286};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0195615199108988, 0.124232336649472, -0.031943828249997, 0.0, -0.0566946709513841, 0.0115727512471569, 0.0245495126515492, -0.0467707173346743, 0.0236227795630767, 0.0, 0.0, 0.0, -0.0618589574131742, 0.0214285714285714, -0.00437408882639853, -0.0642857142857143, 0.00927884361197614, 0.00757614408414157, -0.00535714285714285};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.117369119465393, -0.0451753951452625, -0.031943828249997, -0.018298126367785, 0.042521003213538, 0.0347182537414707, 0.0409158544192486, 0.0334076552390531, 0.0236227795630767, 0.0850420064270761, 0.0239578711874977, 0.0207481250689683, -0.00618589574131741, -0.00535714285714286, -0.00437408882639853, -0.0107142857142857, -0.00927884361197613, -0.00757614408414158, -0.00535714285714285};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.117369119465393, -0.0451753951452625, -0.031943828249997, -0.018298126367785, -0.0425210032135381, -0.0347182537414707, 0.0409158544192486, 0.0334076552390531, 0.0236227795630767, -0.0850420064270761, 0.0239578711874978, 0.0207481250689683, 0.00618589574131742, 0.00535714285714286, 0.00437408882639854, -0.0107142857142857, -0.00927884361197614, -0.00757614408414159, -0.00535714285714285};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.117369119465393, 0.0677630927178939, 0.0479157423749955, 0.0, 0.0850420064270761, 0.0694365074829414, -0.0736485379546474, 0.0400891862868637, -0.0992156741649221, 0.0, 0.0, 0.0, 0.0, 0.075, -0.0262445329583912, 0.0, -0.0649519052838329, -0.0151522881682832, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, -0.117369119465393, 0.0677630927178939, 0.0479157423749955, 0.0, -0.0850420064270761, -0.0694365074829413, -0.0736485379546474, 0.0400891862868637, -0.0992156741649221, 0.0, 0.0, 0.0, 0.0, -0.075, 0.0262445329583912, 0.0, -0.0649519052838329, -0.0151522881682832, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.0, -0.135526185435788, 0.0479157423749955, -0.10978875820671, 0.0, 0.0, 0.0245495126515491, -0.0801783725737273, -0.0992156741649221, 0.0, 0.0, -0.0968245836551854, 0.0, 0.0, 0.0, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.0, 0.0, -0.143747227124987, -0.10978875820671, 0.0, 0.0, -0.122747563257746, 0.0, 0.0425210032135381, 0.0, -0.095831484749991, 0.0138320833793122, 0.0, 0.0, 0.0, 0.0428571428571429, 0.0154647393532936, 0.0, -0.00535714285714285};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 20; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0130410132739325, 0.00752923252421044, 0.0053239713749995, 0.018298126367785, 0.014173667737846, 0.0115727512471569, 0.00818317088384972, 0.0066815310478106, 0.00472455591261534, -0.028347335475692, -0.0239578711874977, -0.0207481250689683, -0.0185576872239523, -0.0160714285714286, -0.0131222664791956, -0.0107142857142857, -0.00927884361197612, -0.00757614408414159, -0.00535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, -0.0130410132739325, 0.00752923252421043, 0.0053239713749995, 0.018298126367785, -0.014173667737846, -0.0115727512471569, 0.00818317088384972, 0.00668153104781061, 0.00472455591261535, 0.028347335475692, -0.0239578711874977, -0.0207481250689683, 0.0185576872239523, 0.0160714285714286, 0.0131222664791956, -0.0107142857142857, -0.00927884361197613, -0.00757614408414158, -0.00535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0, -0.0150584650484208, 0.0053239713749995, 0.0, 0.0, 0.0, 0.0245495126515491, -0.0133630620956212, 0.00472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0428571428571429, -0.0278365308359284, 0.0151522881682832, -0.00535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0288675134594813, 0.0, 0.0, -0.0159719141249985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0283473354756921, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0, 0.112938487863156, -0.063887656499994, 0.0, 0.0, 0.0, 0.0736485379546474, 0.0267261241912424, -0.0236227795630767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0649519052838329, -0.0606091526731326, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0, -0.0225876975726313, 0.127775312999988, 0.0, 0.0, 0.0, 0.0, 0.0668153104781061, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0757614408414158, -0.0535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0978075995544939, -0.0564692439315782, -0.063887656499994, 0.054894379103355, -0.042521003213538, 0.0231455024943138, 0.0245495126515491, -0.0133630620956212, -0.0236227795630767, 0.0, 0.0, 0.0484122918275927, 0.0, -0.0375, -0.0524890659167824, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0195615199108988, 0.0112938487863156, 0.127775312999988, 0.0, 0.0, 0.0578637562357845, 0.0, -0.0334076552390531, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, 0.065611332395978, 0.0, 0.0, -0.0378807204207079, -0.0535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0978075995544939, -0.0790569415042095, -0.031943828249997, 0.054894379103355, 0.014173667737846, -0.0462910049886276, -0.0245495126515492, 0.0133630620956212, 0.0236227795630767, 0.0, 0.0479157423749955, -0.0069160416896561, -0.0618589574131742, -0.0160714285714286, 0.00874817765279707, 0.0428571428571429, 0.0154647393532935, 0.0, -0.00535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0195615199108988, 0.124232336649472, -0.031943828249997, 0.0, 0.0566946709513841, -0.0115727512471569, 0.0245495126515492, -0.0467707173346743, 0.0236227795630767, 0.0, 0.0, 0.0, 0.0618589574131742, -0.0214285714285714, 0.00437408882639853, -0.0642857142857143, 0.00927884361197613, 0.00757614408414159, -0.00535714285714285};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0978075995544939, -0.0564692439315782, -0.063887656499994, 0.054894379103355, 0.042521003213538, -0.0231455024943138, 0.0245495126515491, -0.0133630620956212, -0.0236227795630767, 0.0, 0.0, 0.0484122918275927, 0.0, 0.0375, 0.0524890659167824, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0195615199108988, 0.0112938487863156, 0.127775312999988, 0.0, 0.0, -0.0578637562357845, 0.0, -0.0334076552390531, 0.0472455591261534, 0.0, 0.0, 0.0, 0.0, 0.0, -0.065611332395978, 0.0, 0.0, -0.0378807204207079, -0.0535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.0978075995544939, -0.0790569415042095, -0.031943828249997, 0.054894379103355, -0.014173667737846, 0.0462910049886276, -0.0245495126515492, 0.0133630620956212, 0.0236227795630767, 0.0, 0.0479157423749955, -0.0069160416896561, 0.0618589574131742, 0.0160714285714286, -0.00874817765279707, 0.0428571428571429, 0.0154647393532935, 0.0, -0.00535714285714286};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.0195615199108988, 0.124232336649472, -0.031943828249997, 0.0, -0.0566946709513841, 0.0115727512471569, 0.0245495126515492, -0.0467707173346743, 0.0236227795630767, 0.0, 0.0, 0.0, -0.0618589574131742, 0.0214285714285714, -0.00437408882639853, -0.0642857142857143, 0.00927884361197614, 0.00757614408414157, -0.00535714285714285};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, -0.117369119465393, -0.0451753951452625, -0.031943828249997, -0.018298126367785, 0.042521003213538, 0.0347182537414707, 0.0409158544192486, 0.0334076552390531, 0.0236227795630767, 0.0850420064270761, 0.0239578711874977, 0.0207481250689683, -0.00618589574131741, -0.00535714285714286, -0.00437408882639853, -0.0107142857142857, -0.00927884361197613, -0.00757614408414158, -0.00535714285714285};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.0, 0.117369119465393, -0.0451753951452625, -0.031943828249997, -0.018298126367785, -0.0425210032135381, -0.0347182537414707, 0.0409158544192486, 0.0334076552390531, 0.0236227795630767, -0.0850420064270761, 0.0239578711874978, 0.0207481250689683, 0.00618589574131742, 0.00535714285714286, 0.00437408882639854, -0.0107142857142857, -0.00927884361197614, -0.00757614408414159, -0.00535714285714285};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.117369119465393, 0.0677630927178939, 0.0479157423749955, 0.0, 0.0850420064270761, 0.0694365074829414, -0.0736485379546474, 0.0400891862868637, -0.0992156741649221, 0.0, 0.0, 0.0, 0.0, 0.075, -0.0262445329583912, 0.0, -0.0649519052838329, -0.0151522881682832, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, -0.117369119465393, 0.0677630927178939, 0.0479157423749955, 0.0, -0.0850420064270761, -0.0694365074829413, -0.0736485379546474, 0.0400891862868637, -0.0992156741649221, 0.0, 0.0, 0.0, 0.0, -0.075, 0.0262445329583912, 0.0, -0.0649519052838329, -0.0151522881682832, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.0, -0.135526185435788, 0.0479157423749955, -0.10978875820671, 0.0, 0.0, 0.0245495126515491, -0.0801783725737273, -0.0992156741649221, 0.0, 0.0, -0.0968245836551854, 0.0, 0.0, 0.0, 0.0, 0.021650635094611, 0.0303045763365663, 0.0267857142857143};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[20] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[10] *= std::sqrt(63.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[20] = \
      {0.259807621135332, 0.0, 0.0, -0.143747227124987, -0.10978875820671, 0.0, 0.0, -0.122747563257746, 0.0, 0.0425210032135381, 0.0, -0.095831484749991, 0.0138320833793122, 0.0, 0.0, 0.0, 0.0428571428571429, 0.0154647393532936, 0.0, -0.00535714285714285};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534076, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394701, 0.0, -3.3466401061363, -2.36643191323985, 15.4919333848297, 0.0, 0.0, 0.692820323027552, 0.565685424949239, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556636, 0.0, 0.0, 0.0, 14.1985914794391, -0.828078671210826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.60000000000001, 0.0, 8.76356092008265, -1.54919333848297, 0.0, 0.0, 0.0, 9.52470471983252, -1.48131215963608, 0.261861468283191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016838, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.68313005106397, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1.0, 9.16515138991168, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733757, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355964, -0.408248290463864, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830309, 4.38178046004133, -0.774596669241485, 0.0, 10.998181667894, 0.962140470884729, 4.76235235991626, -0.74065607981804, 0.130930734141595, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752583, 1.58113883008419, 2.45967477524977, 0.0, 0.0, 9.25820099772552, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270663, 0.0, -3.16227766016839, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.53452248382485, 0.377964473009228, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.65148371670111, -2.84018778721878, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.20454076850486, 0.0, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[20][20] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825974, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973465, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847578, -1.67332005306815, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278318, 2.82842712474619, -1, 1.30930734141595, 7.09929573971954, -0.414039335605413, -2.04939015319192, -0.478091443733758, 0.169030850945703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355965, -0.408248290463863, 3.17542648054294, 9.07114735222145, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033675, 4.38178046004133, -0.774596669241486, 0.0, 3.14233761939829, -0.10690449676497, 4.76235235991626, -0.74065607981804, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505166, 1.58113883008419, 2.45967477524976, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253616, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.44721359549996, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000002, 0.0, 1.46059348668044, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222145, 4.93770719878694, -0.698297248755176, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.734846922834951, 0.0, -6.26099033699941, 2.21359436211787, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[20][20] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 20; t++)
          {
            for (unsigned int u = 0; u < 20; u++)
            {
              for (unsigned int tu = 0; tu < 20; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 20; s++)
        {
          for (unsigned int t = 0; t < 20; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new poisson3d_3_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson3d_3_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson3d_3_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson3d_3_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 20;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 20;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 10;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + 2*c.entity_indices[1][0];
    dofs[5] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 2*c.entity_indices[1][1];
    dofs[7] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 2*c.entity_indices[1][2];
    dofs[9] = offset + 2*c.entity_indices[1][2] + 1;
    dofs[10] = offset + 2*c.entity_indices[1][3];
    dofs[11] = offset + 2*c.entity_indices[1][3] + 1;
    dofs[12] = offset + 2*c.entity_indices[1][4];
    dofs[13] = offset + 2*c.entity_indices[1][4] + 1;
    dofs[14] = offset + 2*c.entity_indices[1][5];
    dofs[15] = offset + 2*c.entity_indices[1][5] + 1;
    offset += 2*m.num_entities[1];
    dofs[16] = offset + c.entity_indices[2][0];
    dofs[17] = offset + c.entity_indices[2][1];
    dofs[18] = offset + c.entity_indices[2][2];
    dofs[19] = offset + c.entity_indices[2][3];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 16;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 17;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 6;
      dofs[4] = 7;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 18;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 12;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 19;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 8;
        dofs[1] = 9;
          break;
        }
      case 3:
        {
          dofs[0] = 10;
        dofs[1] = 11;
          break;
        }
      case 4:
        {
          dofs[0] = 12;
        dofs[1] = 13;
          break;
        }
      case 5:
        {
          dofs[0] = 14;
        dofs[1] = 15;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 16;
          break;
        }
      case 1:
        {
          dofs[0] = 17;
          break;
        }
      case 2:
        {
          dofs[0] = 18;
          break;
        }
      case 3:
        {
          dofs[0] = 19;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[4][1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[4][2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[5][0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
    coordinates[5][1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
    coordinates[5][2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
    coordinates[6][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
    coordinates[6][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
    coordinates[6][2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
    coordinates[7][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
    coordinates[7][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
    coordinates[7][2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
    coordinates[8][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[8][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[8][2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
    coordinates[9][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[9][2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
    coordinates[10][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
    coordinates[10][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
    coordinates[10][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
    coordinates[11][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
    coordinates[11][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
    coordinates[11][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
    coordinates[12][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[12][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[12][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
    coordinates[13][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[13][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[13][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
    coordinates[14][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[14][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[14][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
    coordinates[15][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[15][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[15][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
    coordinates[16][0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[16][1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[16][2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[17][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[17][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[17][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[18][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
    coordinates[18][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
    coordinates[18][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
    coordinates[19][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[19][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[19][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new poisson3d_3_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_3_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_3_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      32
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 1768
    // Total number of operations (multiply-add pairs):                  1827
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    const double G0_0_2 = det*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01 + K_12*K_02);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    const double G0_1_2 = det*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    const double G0_2_0 = det*(K_20*K_00 + K_21*K_01 + K_22*K_02);
    const double G0_2_1 = det*(K_20*K_10 + K_21*K_11 + K_22*K_12);
    const double G0_2_2 = det*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    
    // Compute element tensor
    A[0] = 0.0595238095238095*G0_0_0 + 0.0595238095238095*G0_0_1 + 0.0595238095238095*G0_0_2 + 0.0595238095238095*G0_1_0 + 0.0595238095238095*G0_1_1 + 0.0595238095238095*G0_1_2 + 0.0595238095238095*G0_2_0 + 0.0595238095238095*G0_2_1 + 0.0595238095238095*G0_2_2;
    A[1] = -0.0113095238095238*G0_0_0 - 0.0113095238095238*G0_1_0 - 0.0113095238095238*G0_2_0;
    A[2] = -0.0113095238095238*G0_0_1 - 0.0113095238095238*G0_1_1 - 0.0113095238095238*G0_2_1;
    A[3] = -0.0113095238095238*G0_0_2 - 0.0113095238095238*G0_1_2 - 0.0113095238095238*G0_2_2;
    A[4] = -0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_0_2 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[5] = -0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_0_2 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[6] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_2 - 0.0133928571428572*G0_1_0 - 0.0133928571428572*G0_1_2 - 0.0133928571428572*G0_2_0 - 0.0133928571428572*G0_2_2;
    A[7] = -0.0133928571428571*G0_0_0 - 0.0133928571428572*G0_0_2 - 0.0133928571428571*G0_1_0 - 0.0133928571428572*G0_1_2 - 0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_2;
    A[8] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_1 - 0.0133928571428572*G0_1_0 - 0.0133928571428572*G0_1_1 - 0.0133928571428572*G0_2_0 - 0.0133928571428572*G0_2_1;
    A[9] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_1_0 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_1;
    A[10] = -0.0348214285714286*G0_0_0 - 0.0348214285714286*G0_0_1 - 0.0964285714285714*G0_0_2 - 0.0348214285714285*G0_1_0 - 0.0348214285714285*G0_1_1 - 0.0964285714285714*G0_1_2 - 0.0348214285714286*G0_2_0 - 0.0348214285714286*G0_2_1 - 0.0964285714285714*G0_2_2;
    A[11] = 0.0133928571428571*G0_0_0 + 0.0133928571428571*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0133928571428571*G0_2_0 + 0.0133928571428571*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[12] = -0.0348214285714285*G0_0_0 - 0.0964285714285714*G0_0_1 - 0.0348214285714285*G0_0_2 - 0.0348214285714285*G0_1_0 - 0.0964285714285714*G0_1_1 - 0.0348214285714285*G0_1_2 - 0.0348214285714285*G0_2_0 - 0.0964285714285714*G0_2_1 - 0.0348214285714285*G0_2_2;
    A[13] = 0.0133928571428571*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0133928571428571*G0_0_2 + 0.0133928571428571*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0133928571428571*G0_1_2 + 0.0133928571428571*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0133928571428571*G0_2_2;
    A[14] = -0.0964285714285715*G0_0_0 - 0.0348214285714286*G0_0_1 - 0.0348214285714286*G0_0_2 - 0.0964285714285715*G0_1_0 - 0.0348214285714286*G0_1_1 - 0.0348214285714286*G0_1_2 - 0.0964285714285714*G0_2_0 - 0.0348214285714286*G0_2_1 - 0.0348214285714286*G0_2_2;
    A[15] = 0.0482142857142858*G0_0_0 + 0.0133928571428572*G0_0_1 + 0.0133928571428572*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0133928571428571*G0_1_1 + 0.0133928571428572*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0133928571428572*G0_2_1 + 0.0133928571428572*G0_2_2;
    A[16] = -0.0321428571428571*G0_0_0 - 0.0321428571428571*G0_0_1 - 0.0321428571428571*G0_0_2 - 0.0321428571428571*G0_1_0 - 0.0321428571428572*G0_1_1 - 0.0321428571428571*G0_1_2 - 0.0321428571428571*G0_2_0 - 0.0321428571428571*G0_2_1 - 0.0321428571428571*G0_2_2;
    A[17] = 0.0321428571428571*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0321428571428571*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0321428571428571*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[18] = 0.0482142857142858*G0_0_0 + 0.0321428571428572*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0321428571428572*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0321428571428572*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[19] = 0.0482142857142857*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0321428571428571*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0321428571428571*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0321428571428571*G0_2_2;
    A[20] = -0.0113095238095238*G0_0_0 - 0.0113095238095238*G0_0_1 - 0.0113095238095238*G0_0_2;
    A[21] = 0.0595238095238095*G0_0_0;
    A[22] = 0.0113095238095238*G0_0_1;
    A[23] = 0.0113095238095238*G0_0_2;
    A[24] = 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_0_2;
    A[25] = 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_0_2;
    A[26] = -0.0348214285714285*G0_0_0 + 0.0616071428571428*G0_0_2;
    A[27] = 0.0133928571428571*G0_0_0 - 0.0348214285714286*G0_0_2;
    A[28] = -0.0348214285714285*G0_0_0 + 0.0616071428571429*G0_0_1;
    A[29] = 0.0133928571428571*G0_0_0 - 0.0348214285714286*G0_0_1;
    A[30] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_1;
    A[31] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_0_1;
    A[32] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_2;
    A[33] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_0_2;
    A[34] = 0.0482142857142857*G0_0_0 + 0.0348214285714286*G0_0_1 + 0.0348214285714286*G0_0_2;
    A[35] = -0.0964285714285714*G0_0_0 - 0.0616071428571429*G0_0_1 - 0.0616071428571429*G0_0_2;
    A[36] = 0.0321428571428571*G0_0_0 - 0.0160714285714285*G0_0_1 - 0.0160714285714285*G0_0_2;
    A[37] = -0.0321428571428571*G0_0_0;
    A[38] = 0.0482142857142857*G0_0_0 + 0.0160714285714286*G0_0_1;
    A[39] = 0.0482142857142857*G0_0_0 + 0.0160714285714286*G0_0_2;
    A[40] = -0.0113095238095238*G0_1_0 - 0.0113095238095238*G0_1_1 - 0.0113095238095238*G0_1_2;
    A[41] = 0.0113095238095238*G0_1_0;
    A[42] = 0.0595238095238095*G0_1_1;
    A[43] = 0.0113095238095238*G0_1_2;
    A[44] = -0.0348214285714285*G0_1_1 + 0.0616071428571428*G0_1_2;
    A[45] = 0.0133928571428571*G0_1_1 - 0.0348214285714285*G0_1_2;
    A[46] = 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_1_2;
    A[47] = 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_1_2;
    A[48] = -0.0348214285714285*G0_1_0 + 0.0133928571428571*G0_1_1;
    A[49] = 0.0616071428571428*G0_1_0 - 0.0348214285714285*G0_1_1;
    A[50] = -0.0133928571428572*G0_1_0 - 0.0133928571428571*G0_1_1;
    A[51] = -0.0133928571428571*G0_1_0 - 0.0133928571428571*G0_1_1;
    A[52] = 0.0348214285714285*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0348214285714285*G0_1_2;
    A[53] = -0.0616071428571428*G0_1_0 - 0.0964285714285713*G0_1_1 - 0.0616071428571428*G0_1_2;
    A[54] = -0.0133928571428571*G0_1_1 - 0.0133928571428572*G0_1_2;
    A[55] = -0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2;
    A[56] = -0.0160714285714286*G0_1_0 + 0.0321428571428571*G0_1_1 - 0.0160714285714285*G0_1_2;
    A[57] = 0.0160714285714286*G0_1_0 + 0.0482142857142857*G0_1_1;
    A[58] = -0.0321428571428571*G0_1_1;
    A[59] = 0.0482142857142856*G0_1_1 + 0.0160714285714285*G0_1_2;
    A[60] = -0.0113095238095238*G0_2_0 - 0.0113095238095238*G0_2_1 - 0.0113095238095238*G0_2_2;
    A[61] = 0.0113095238095238*G0_2_0;
    A[62] = 0.0113095238095238*G0_2_1;
    A[63] = 0.0595238095238095*G0_2_2;
    A[64] = -0.0348214285714285*G0_2_1 + 0.0133928571428571*G0_2_2;
    A[65] = 0.0616071428571429*G0_2_1 - 0.0348214285714285*G0_2_2;
    A[66] = -0.0348214285714286*G0_2_0 + 0.0133928571428571*G0_2_2;
    A[67] = 0.0616071428571429*G0_2_0 - 0.0348214285714285*G0_2_2;
    A[68] = 0.0133928571428571*G0_2_0 + 0.0133928571428571*G0_2_1;
    A[69] = 0.0133928571428571*G0_2_0 + 0.0133928571428571*G0_2_1;
    A[70] = 0.0348214285714285*G0_2_0 + 0.0348214285714286*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[71] = -0.0616071428571429*G0_2_0 - 0.0616071428571429*G0_2_1 - 0.0964285714285713*G0_2_2;
    A[72] = -0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_2;
    A[73] = -0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_2;
    A[74] = -0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[75] = -0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[76] = -0.0160714285714285*G0_2_0 - 0.0160714285714285*G0_2_1 + 0.0321428571428571*G0_2_2;
    A[77] = 0.0160714285714285*G0_2_0 + 0.0482142857142856*G0_2_2;
    A[78] = 0.0160714285714285*G0_2_1 + 0.0482142857142856*G0_2_2;
    A[79] = -0.0321428571428571*G0_2_2;
    A[80] = -0.0133928571428571*G0_1_0 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[81] = 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_2_0;
    A[82] = -0.0348214285714285*G0_1_1 + 0.0616071428571428*G0_2_1;
    A[83] = -0.0348214285714285*G0_1_2 + 0.0133928571428571*G0_2_2;
    A[84] = 0.241071428571428*G0_1_1 + 0.0964285714285714*G0_1_2 + 0.0964285714285714*G0_2_1 + 0.192857142857143*G0_2_2;
    A[85] = -0.0723214285714287*G0_1_1 + 0.0723214285714282*G0_1_2 - 0.0241071428571429*G0_2_1 - 0.0723214285714286*G0_2_2;
    A[86] = -0.0482142857142855*G0_1_0 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.0241071428571428*G0_2_2;
    A[87] = -0.0723214285714286*G0_1_0 - 0.0482142857142858*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_2;
    A[88] = -0.0482142857142855*G0_1_0 - 0.0241071428571428*G0_1_1 - 0.0723214285714284*G0_2_0 - 0.0241071428571428*G0_2_1;
    A[89] = 0.0964285714285714*G0_1_0 + 0.120535714285714*G0_1_1 + 0.192857142857143*G0_2_0 + 0.0964285714285714*G0_2_1;
    A[90] = 0.0482142857142855*G0_1_0 + 0.0482142857142855*G0_1_1 + 0.0241071428571427*G0_1_2 + 0.0241071428571428*G0_2_0 + 0.0241071428571428*G0_2_1;
    A[91] = 0.0723214285714287*G0_1_0 + 0.0723214285714287*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_1;
    A[92] = 0.0482142857142856*G0_1_0 + 0.0241071428571427*G0_1_1 + 0.0482142857142856*G0_1_2 + 0.0723214285714285*G0_2_0 + 0.0482142857142856*G0_2_1 + 0.0723214285714285*G0_2_2;
    A[93] = -0.0964285714285714*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.0964285714285715*G0_1_2 - 0.192857142857143*G0_2_0 - 0.0964285714285713*G0_2_1 - 0.192857142857143*G0_2_2;
    A[94] = 0.0241071428571429*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571428*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[95] = 0.0241071428571428*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571428*G0_2_1 + 0.0241071428571429*G0_2_2;
    A[96] = 0.241071428571428*G0_1_0 - 0.0482142857142857*G0_1_1 + 0.120535714285714*G0_1_2 + 0.0964285714285714*G0_2_0 - 0.0241071428571429*G0_2_1 + 0.0964285714285715*G0_2_2;
    A[97] = -0.241071428571428*G0_1_0 - 0.289285714285714*G0_1_1 - 0.120535714285714*G0_1_2 - 0.0964285714285714*G0_2_0 - 0.120535714285714*G0_2_1;
    A[98] = 0.0482142857142857*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571428*G0_2_1;
    A[99] = -0.144642857142857*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.0964285714285716*G0_2_2;
    A[100] = -0.0133928571428571*G0_1_0 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_0 - 0.0133928571428571*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[101] = 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_2_0;
    A[102] = 0.0133928571428571*G0_1_1 - 0.0348214285714286*G0_2_1;
    A[103] = 0.0616071428571429*G0_1_2 - 0.0348214285714285*G0_2_2;
    A[104] = -0.0723214285714287*G0_1_1 - 0.0241071428571429*G0_1_2 + 0.0723214285714282*G0_2_1 - 0.0723214285714286*G0_2_2;
    A[105] = 0.192857142857143*G0_1_1 + 0.0964285714285715*G0_1_2 + 0.0964285714285715*G0_2_1 + 0.241071428571428*G0_2_2;
    A[106] = -0.0723214285714285*G0_1_0 - 0.0241071428571429*G0_1_2 - 0.0482142857142856*G0_2_0 - 0.0241071428571429*G0_2_2;
    A[107] = 0.192857142857143*G0_1_0 + 0.0964285714285715*G0_1_2 + 0.0964285714285715*G0_2_0 + 0.120535714285714*G0_2_2;
    A[108] = -0.0241071428571428*G0_1_0 - 0.0241071428571429*G0_1_1 - 0.0482142857142856*G0_2_0 - 0.0241071428571428*G0_2_1;
    A[109] = -0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_1 - 0.0723214285714285*G0_2_0 - 0.0482142857142856*G0_2_1;
    A[110] = 0.0723214285714286*G0_1_0 + 0.0723214285714286*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[111] = -0.192857142857143*G0_1_0 - 0.192857142857143*G0_1_1 - 0.0964285714285715*G0_1_2 - 0.0964285714285715*G0_2_0 - 0.0964285714285715*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[112] = 0.0241071428571428*G0_1_0 + 0.0241071428571428*G0_1_2 + 0.0482142857142856*G0_2_0 + 0.0241071428571427*G0_2_1 + 0.0482142857142856*G0_2_2;
    A[113] = 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_2 + 0.0723214285714285*G0_2_0 + 0.0241071428571429*G0_2_1 + 0.0723214285714285*G0_2_2;
    A[114] = 0.0241071428571429*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[115] = 0.0241071428571429*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[116] = 0.0964285714285713*G0_1_0 + 0.0964285714285715*G0_1_1 - 0.0241071428571429*G0_1_2 + 0.241071428571428*G0_2_0 + 0.120535714285714*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[117] = -0.0964285714285713*G0_1_0 - 0.120535714285714*G0_1_2 - 0.241071428571428*G0_2_0 - 0.120535714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[118] = -0.0964285714285716*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.144642857142857*G0_2_2;
    A[119] = 0.0241071428571429*G0_1_2 + 0.0241071428571427*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[120] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_1 - 0.0133928571428572*G0_0_2 - 0.0133928571428572*G0_2_0 - 0.0133928571428572*G0_2_1 - 0.0133928571428572*G0_2_2;
    A[121] = -0.0348214285714285*G0_0_0 + 0.0616071428571428*G0_2_0;
    A[122] = 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_2_1;
    A[123] = -0.0348214285714286*G0_0_2 + 0.0133928571428571*G0_2_2;
    A[124] = -0.0482142857142856*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.0241071428571428*G0_2_1 - 0.0241071428571428*G0_2_2;
    A[125] = -0.0723214285714286*G0_0_1 - 0.0482142857142857*G0_0_2 - 0.0241071428571429*G0_2_1 - 0.0241071428571429*G0_2_2;
    A[126] = 0.241071428571428*G0_0_0 + 0.0964285714285713*G0_0_2 + 0.0964285714285713*G0_2_0 + 0.192857142857143*G0_2_2;
    A[127] = -0.0723214285714286*G0_0_0 + 0.0723214285714285*G0_0_2 - 0.0241071428571429*G0_2_0 - 0.0723214285714285*G0_2_2;
    A[128] = 0.120535714285714*G0_0_0 + 0.0964285714285714*G0_0_1 + 0.0964285714285713*G0_2_0 + 0.192857142857143*G0_2_1;
    A[129] = -0.0241071428571427*G0_0_0 - 0.0482142857142856*G0_0_1 - 0.0241071428571428*G0_2_0 - 0.0723214285714285*G0_2_1;
    A[130] = 0.0482142857142857*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_1;
    A[131] = 0.0723214285714286*G0_0_0 + 0.0723214285714286*G0_0_1 + 0.024107142857143*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_1;
    A[132] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[133] = 0.0241071428571427*G0_0_0 + 0.0241071428571428*G0_0_2 + 0.0241071428571428*G0_2_0 + 0.0241071428571428*G0_2_2;
    A[134] = 0.0241071428571429*G0_0_0 + 0.0482142857142858*G0_0_1 + 0.0482142857142858*G0_0_2 + 0.0482142857142858*G0_2_0 + 0.0723214285714286*G0_2_1 + 0.0723214285714287*G0_2_2;
    A[135] = 0.0241071428571428*G0_0_0 - 0.0964285714285713*G0_0_1 - 0.0964285714285713*G0_0_2 - 0.0964285714285715*G0_2_0 - 0.192857142857143*G0_2_1 - 0.192857142857143*G0_2_2;
    A[136] = -0.0482142857142856*G0_0_0 + 0.241071428571428*G0_0_1 + 0.120535714285714*G0_0_2 - 0.0241071428571428*G0_2_0 + 0.0964285714285713*G0_2_1 + 0.0964285714285714*G0_2_2;
    A[137] = 0.0482142857142856*G0_0_0 + 0.0241071428571426*G0_0_2 + 0.0241071428571428*G0_2_0;
    A[138] = -0.289285714285714*G0_0_0 - 0.241071428571428*G0_0_1 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.0964285714285713*G0_2_1;
    A[139] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.0964285714285714*G0_2_2;
    A[140] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_0_2 - 0.0133928571428572*G0_2_0 - 0.0133928571428572*G0_2_1 - 0.0133928571428571*G0_2_2;
    A[141] = 0.0133928571428571*G0_0_0 - 0.0348214285714286*G0_2_0;
    A[142] = 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_2_1;
    A[143] = 0.0616071428571429*G0_0_2 - 0.0348214285714285*G0_2_2;
    A[144] = -0.0723214285714286*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0482142857142858*G0_2_1 - 0.0241071428571429*G0_2_2;
    A[145] = 0.192857142857143*G0_0_1 + 0.0964285714285715*G0_0_2 + 0.0964285714285715*G0_2_1 + 0.120535714285714*G0_2_2;
    A[146] = -0.0723214285714286*G0_0_0 - 0.0241071428571429*G0_0_2 + 0.0723214285714285*G0_2_0 - 0.0723214285714285*G0_2_2;
    A[147] = 0.192857142857143*G0_0_0 + 0.0964285714285715*G0_0_2 + 0.0964285714285715*G0_2_0 + 0.241071428571428*G0_2_2;
    A[148] = -0.0241071428571428*G0_0_0 - 0.0241071428571429*G0_0_1 - 0.0482142857142855*G0_2_0 - 0.0723214285714284*G0_2_1;
    A[149] = -0.0241071428571429*G0_0_0 - 0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_2_0 - 0.0482142857142857*G0_2_1;
    A[150] = 0.0723214285714287*G0_0_0 + 0.0723214285714287*G0_0_1 + 0.0482142857142858*G0_0_2 + 0.0482142857142858*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0241071428571429*G0_2_2;
    A[151] = -0.192857142857143*G0_0_0 - 0.192857142857143*G0_0_1 - 0.0964285714285715*G0_0_2 - 0.0964285714285715*G0_2_0 - 0.0964285714285715*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[152] = 0.0241071428571428*G0_0_0 + 0.0241071428571428*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[153] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[154] = 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0241071428571428*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[155] = 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0723214285714286*G0_2_1 + 0.0723214285714285*G0_2_2;
    A[156] = 0.0964285714285714*G0_0_0 + 0.0964285714285716*G0_0_1 - 0.0241071428571429*G0_0_2 + 0.120535714285714*G0_2_0 + 0.241071428571429*G0_2_1 - 0.0482142857142856*G0_2_2;
    A[157] = -0.0964285714285714*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.144642857142857*G0_2_2;
    A[158] = -0.0964285714285716*G0_0_1 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.241071428571429*G0_2_1 - 0.289285714285714*G0_2_2;
    A[159] = 0.0241071428571429*G0_0_2 + 0.0241071428571426*G0_2_0 + 0.0482142857142856*G0_2_2;
    A[160] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_0_1 - 0.0133928571428572*G0_0_2 - 0.0133928571428572*G0_1_0 - 0.0133928571428572*G0_1_1 - 0.0133928571428572*G0_1_2;
    A[161] = -0.0348214285714285*G0_0_0 + 0.0616071428571428*G0_1_0;
    A[162] = -0.0348214285714285*G0_0_1 + 0.0133928571428571*G0_1_1;
    A[163] = 0.0133928571428571*G0_0_2 + 0.0133928571428571*G0_1_2;
    A[164] = -0.0482142857142855*G0_0_1 - 0.0723214285714284*G0_0_2 - 0.0241071428571428*G0_1_1 - 0.0241071428571428*G0_1_2;
    A[165] = -0.0241071428571428*G0_0_1 - 0.0482142857142856*G0_0_2 - 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_1_2;
    A[166] = 0.120535714285714*G0_0_0 + 0.0964285714285713*G0_0_2 + 0.0964285714285714*G0_1_0 + 0.192857142857143*G0_1_2;
    A[167] = -0.0241071428571428*G0_0_0 - 0.0482142857142855*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0723214285714284*G0_1_2;
    A[168] = 0.241071428571428*G0_0_0 + 0.0964285714285713*G0_0_1 + 0.0964285714285713*G0_1_0 + 0.192857142857143*G0_1_1;
    A[169] = -0.0723214285714284*G0_0_0 + 0.0723214285714285*G0_0_1 - 0.0241071428571428*G0_1_0 - 0.0723214285714286*G0_1_1;
    A[170] = 0.0241071428571431*G0_0_0 + 0.024107142857143*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[171] = 0.0241071428571428*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[172] = 0.0482142857142858*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0482142857142858*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_2;
    A[173] = 0.0723214285714284*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0723214285714285*G0_0_2 + 0.0241071428571428*G0_1_0 + 0.0241071428571428*G0_1_2;
    A[174] = 0.0241071428571429*G0_0_0 + 0.0482142857142858*G0_0_1 + 0.0482142857142858*G0_0_2 + 0.0482142857142858*G0_1_0 + 0.0723214285714287*G0_1_1 + 0.0723214285714287*G0_1_2;
    A[175] = 0.0241071428571428*G0_0_0 - 0.0964285714285713*G0_0_1 - 0.0964285714285713*G0_0_2 - 0.0964285714285715*G0_1_0 - 0.192857142857143*G0_1_1 - 0.192857142857143*G0_1_2;
    A[176] = -0.0482142857142855*G0_0_0 + 0.120535714285714*G0_0_1 + 0.241071428571428*G0_0_2 - 0.0241071428571428*G0_1_0 + 0.0964285714285714*G0_1_1 + 0.0964285714285713*G0_1_2;
    A[177] = 0.0482142857142855*G0_0_0 + 0.0241071428571425*G0_0_1 + 0.0241071428571428*G0_1_0;
    A[178] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.0964285714285714*G0_1_1;
    A[179] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_1 - 0.241071428571428*G0_0_2 - 0.120535714285714*G0_1_0 - 0.0964285714285713*G0_1_2;
    A[180] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_0_2 - 0.0133928571428571*G0_1_0 - 0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_1_2;
    A[181] = 0.0133928571428571*G0_0_0 - 0.0348214285714286*G0_1_0;
    A[182] = 0.0616071428571428*G0_0_1 - 0.0348214285714285*G0_1_1;
    A[183] = 0.0133928571428571*G0_0_2 + 0.0133928571428571*G0_1_2;
    A[184] = 0.0964285714285714*G0_0_1 + 0.192857142857143*G0_0_2 + 0.120535714285714*G0_1_1 + 0.0964285714285715*G0_1_2;
    A[185] = -0.0241071428571429*G0_0_1 - 0.0723214285714285*G0_0_2 - 0.0241071428571429*G0_1_1 - 0.0482142857142857*G0_1_2;
    A[186] = -0.0241071428571427*G0_0_0 - 0.0241071428571428*G0_0_2 - 0.0482142857142856*G0_1_0 - 0.0723214285714285*G0_1_2;
    A[187] = -0.0241071428571429*G0_0_0 - 0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0482142857142857*G0_1_2;
    A[188] = -0.0723214285714284*G0_0_0 - 0.0241071428571428*G0_0_1 + 0.0723214285714285*G0_1_0 - 0.0723214285714286*G0_1_1;
    A[189] = 0.192857142857143*G0_0_0 + 0.0964285714285714*G0_0_1 + 0.0964285714285715*G0_1_0 + 0.241071428571428*G0_1_1;
    A[190] = 0.0241071428571428*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[191] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[192] = 0.0723214285714285*G0_0_0 + 0.0482142857142856*G0_0_1 + 0.0723214285714285*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.0482142857142856*G0_1_2;
    A[193] = -0.192857142857143*G0_0_0 - 0.0964285714285713*G0_0_1 - 0.192857142857143*G0_0_2 - 0.0964285714285715*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.0964285714285714*G0_1_2;
    A[194] = 0.0241071428571428*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.0241071428571428*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0482142857142857*G0_1_2;
    A[195] = 0.0241071428571428*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0723214285714286*G0_1_1 + 0.0723214285714286*G0_1_2;
    A[196] = 0.0964285714285714*G0_0_0 - 0.0241071428571428*G0_0_1 + 0.0964285714285716*G0_0_2 + 0.120535714285714*G0_1_0 - 0.0482142857142857*G0_1_1 + 0.241071428571428*G0_1_2;
    A[197] = -0.0964285714285715*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.144642857142857*G0_1_1;
    A[198] = 0.0241071428571427*G0_0_1 + 0.0241071428571426*G0_1_0 + 0.0482142857142856*G0_1_1;
    A[199] = -0.120535714285714*G0_0_1 - 0.0964285714285716*G0_0_2 - 0.120535714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.241071428571429*G0_1_2;
    A[200] = -0.0348214285714286*G0_0_0 - 0.0348214285714285*G0_0_1 - 0.0348214285714286*G0_0_2 - 0.0348214285714286*G0_1_0 - 0.0348214285714286*G0_1_1 - 0.0348214285714286*G0_1_2 - 0.0964285714285714*G0_2_0 - 0.0964285714285714*G0_2_1 - 0.0964285714285714*G0_2_2;
    A[201] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_1_0;
    A[202] = -0.0133928571428572*G0_0_1 - 0.0133928571428571*G0_1_1;
    A[203] = 0.0348214285714285*G0_0_2 + 0.0348214285714286*G0_1_2 + 0.0482142857142857*G0_2_2;
    A[204] = 0.0482142857142855*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.0482142857142855*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571427*G0_2_1;
    A[205] = 0.0723214285714286*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0723214285714286*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0482142857142857*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[206] = 0.0482142857142857*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0241071428571429*G0_1_2 + 0.0241071428571428*G0_2_0;
    A[207] = 0.0723214285714287*G0_0_0 + 0.0482142857142858*G0_0_2 + 0.0723214285714287*G0_1_0 + 0.0482142857142857*G0_1_2 + 0.0482142857142858*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[208] = 0.0241071428571431*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.024107142857143*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[209] = 0.0241071428571428*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[210] = 0.241071428571428*G0_0_0 + 0.241071428571428*G0_0_1 + 0.144642857142857*G0_0_2 + 0.241071428571428*G0_1_0 + 0.241071428571428*G0_1_1 + 0.144642857142857*G0_1_2 + 0.144642857142857*G0_2_0 + 0.144642857142857*G0_2_1 + 0.241071428571428*G0_2_2;
    A[211] = -0.0723214285714286*G0_0_0 - 0.0723214285714286*G0_0_1 - 0.144642857142857*G0_0_2 - 0.0723214285714286*G0_1_0 - 0.0723214285714286*G0_1_1 - 0.144642857142857*G0_1_2 - 0.0482142857142857*G0_2_0 - 0.0482142857142857*G0_2_1 - 0.192857142857143*G0_2_2;
    A[212] = 0.120535714285714*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.120535714285714*G0_1_2 + 0.0241071428571428*G0_2_0 + 0.120535714285714*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[213] = -0.0241071428571428*G0_0_0 + 0.0241071428571429*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.0241071428571428*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_1;
    A[214] = 0.0241071428571429*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.120535714285714*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.0241071428571429*G0_2_1 + 0.0241071428571429*G0_2_2;
    A[215] = 0.0241071428571429*G0_0_0 - 0.0241071428571428*G0_0_1 - 0.0241071428571428*G0_0_2 + 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_1_2 - 0.0241071428571429*G0_2_0;
    A[216] = 0.0482142857142856*G0_0_0 + 0.0482142857142858*G0_0_1 + 0.024107142857143*G0_0_2 + 0.0482142857142856*G0_1_0 + 0.0482142857142858*G0_1_1 + 0.024107142857143*G0_1_2 + 0.0241071428571427*G0_2_0 + 0.0241071428571428*G0_2_1;
    A[217] = -0.0482142857142857*G0_0_0 - 0.289285714285714*G0_0_1 - 0.16875*G0_0_2 - 0.0482142857142857*G0_1_0 - 0.289285714285714*G0_1_1 - 0.16875*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.16875*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[218] = -0.289285714285714*G0_0_0 - 0.0482142857142859*G0_0_1 - 0.16875*G0_0_2 - 0.289285714285714*G0_1_0 - 0.0482142857142859*G0_1_1 - 0.16875*G0_1_2 - 0.16875*G0_2_0 - 0.0241071428571429*G0_2_1 - 0.0482142857142858*G0_2_2;
    A[219] = -0.144642857142857*G0_0_0 - 0.144642857142857*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.144642857142857*G0_1_0 - 0.144642857142857*G0_1_1 - 0.0241071428571429*G0_1_2 - 0.024107142857143*G0_2_0 - 0.0241071428571429*G0_2_1;
    A[220] = 0.0133928571428571*G0_0_0 + 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_0_2 + 0.0133928571428571*G0_1_0 + 0.0133928571428571*G0_1_1 + 0.0133928571428571*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[221] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_1_0;
    A[222] = -0.0133928571428571*G0_0_1 - 0.0133928571428571*G0_1_1;
    A[223] = -0.0616071428571429*G0_0_2 - 0.0616071428571429*G0_1_2 - 0.0964285714285713*G0_2_2;
    A[224] = 0.0723214285714287*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0723214285714287*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571429*G0_2_1;
    A[225] = -0.192857142857143*G0_0_1 - 0.0964285714285715*G0_0_2 - 0.192857142857143*G0_1_1 - 0.0964285714285715*G0_1_2 - 0.0964285714285715*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[226] = 0.0723214285714286*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.0723214285714286*G0_1_0 + 0.0241071428571429*G0_1_2 + 0.024107142857143*G0_2_0;
    A[227] = -0.192857142857143*G0_0_0 - 0.0964285714285715*G0_0_2 - 0.192857142857143*G0_1_0 - 0.0964285714285715*G0_1_2 - 0.0964285714285715*G0_2_0 + 0.0241071428571428*G0_2_2;
    A[228] = 0.0241071428571428*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[229] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1;
    A[230] = -0.0723214285714286*G0_0_0 - 0.0723214285714286*G0_0_1 - 0.0482142857142857*G0_0_2 - 0.0723214285714286*G0_1_0 - 0.0723214285714286*G0_1_1 - 0.0482142857142857*G0_1_2 - 0.144642857142857*G0_2_0 - 0.144642857142857*G0_2_1 - 0.192857142857143*G0_2_2;
    A[231] = 0.192857142857143*G0_0_0 + 0.192857142857143*G0_0_1 + 0.0964285714285715*G0_0_2 + 0.192857142857143*G0_1_0 + 0.192857142857143*G0_1_1 + 0.0964285714285715*G0_1_2 + 0.0964285714285715*G0_2_0 + 0.0964285714285715*G0_2_1 + 0.241071428571428*G0_2_2;
    A[232] = -0.0241071428571428*G0_0_0 - 0.0241071428571428*G0_0_2 - 0.0241071428571428*G0_1_0 - 0.0241071428571428*G0_1_2 + 0.0241071428571428*G0_2_0 - 0.0241071428571429*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[233] = -0.0241071428571429*G0_0_0 - 0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_2 - 0.0241071428571428*G0_2_1;
    A[234] = -0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_1 - 0.0241071428571429*G0_1_2 - 0.0241071428571429*G0_2_0 + 0.0241071428571428*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[235] = -0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_1 - 0.0241071428571429*G0_1_2 - 0.0241071428571428*G0_2_0;
    A[236] = -0.0964285714285713*G0_0_0 - 0.0964285714285715*G0_0_1 + 0.024107142857143*G0_0_2 - 0.0964285714285713*G0_1_0 - 0.0964285714285715*G0_1_1 + 0.024107142857143*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_1;
    A[237] = 0.0964285714285713*G0_0_0 + 0.120535714285714*G0_0_2 + 0.0964285714285713*G0_1_0 + 0.120535714285714*G0_1_2 - 0.0241071428571429*G0_2_0 + 0.120535714285714*G0_2_1 - 0.0482142857142856*G0_2_2;
    A[238] = 0.0964285714285715*G0_0_1 + 0.120535714285714*G0_0_2 + 0.0964285714285715*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 - 0.0241071428571429*G0_2_1 - 0.0482142857142856*G0_2_2;
    A[239] = -0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.0241071428571428*G0_2_1;
    A[240] = -0.0348214285714285*G0_0_0 - 0.0348214285714285*G0_0_1 - 0.0348214285714285*G0_0_2 - 0.0964285714285714*G0_1_0 - 0.0964285714285714*G0_1_1 - 0.0964285714285714*G0_1_2 - 0.0348214285714285*G0_2_0 - 0.0348214285714285*G0_2_1 - 0.0348214285714285*G0_2_2;
    A[241] = -0.0133928571428572*G0_0_0 - 0.0133928571428572*G0_2_0;
    A[242] = 0.0348214285714285*G0_0_1 + 0.0482142857142857*G0_1_1 + 0.0348214285714285*G0_2_1;
    A[243] = -0.0133928571428571*G0_0_2 - 0.0133928571428571*G0_2_2;
    A[244] = 0.0482142857142856*G0_0_1 + 0.0723214285714285*G0_0_2 + 0.0241071428571427*G0_1_1 + 0.0482142857142856*G0_1_2 + 0.0482142857142856*G0_2_1 + 0.0723214285714285*G0_2_2;
    A[245] = 0.0241071428571428*G0_0_1 + 0.0482142857142856*G0_0_2 + 0.0241071428571427*G0_1_2 + 0.0241071428571428*G0_2_1 + 0.0482142857142856*G0_2_2;
    A[246] = 0.024107142857143*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.024107142857143*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[247] = 0.0241071428571428*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.0241071428571428*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[248] = 0.0482142857142858*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0482142857142858*G0_2_0 + 0.0241071428571429*G0_2_1;
    A[249] = 0.0723214285714285*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0482142857142856*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.0723214285714285*G0_2_0 + 0.0482142857142856*G0_2_1;
    A[250] = 0.120535714285714*G0_0_0 + 0.120535714285714*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.0241071428571428*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[251] = -0.0241071428571428*G0_0_0 - 0.0241071428571428*G0_0_1 + 0.0241071428571428*G0_0_2 - 0.0241071428571429*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.0241071428571428*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[252] = 0.241071428571428*G0_0_0 + 0.144642857142857*G0_0_1 + 0.241071428571428*G0_0_2 + 0.144642857142857*G0_1_0 + 0.241071428571428*G0_1_1 + 0.144642857142857*G0_1_2 + 0.241071428571428*G0_2_0 + 0.144642857142857*G0_2_1 + 0.241071428571428*G0_2_2;
    A[253] = -0.0723214285714285*G0_0_0 - 0.144642857142857*G0_0_1 - 0.0723214285714285*G0_0_2 - 0.0482142857142856*G0_1_0 - 0.192857142857143*G0_1_1 - 0.0482142857142856*G0_1_2 - 0.0723214285714284*G0_2_0 - 0.144642857142857*G0_2_1 - 0.0723214285714285*G0_2_2;
    A[254] = 0.0241071428571429*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.120535714285714*G0_2_1 + 0.120535714285714*G0_2_2;
    A[255] = 0.0241071428571428*G0_0_0 - 0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_0 + 0.0241071428571428*G0_2_0 - 0.0241071428571429*G0_2_1 - 0.0241071428571429*G0_2_2;
    A[256] = 0.0482142857142856*G0_0_0 + 0.024107142857143*G0_0_1 + 0.0482142857142858*G0_0_2 + 0.0241071428571427*G0_1_0 + 0.0241071428571427*G0_1_2 + 0.0482142857142856*G0_2_0 + 0.0241071428571429*G0_2_1 + 0.0482142857142856*G0_2_2;
    A[257] = -0.0482142857142857*G0_0_0 - 0.16875*G0_0_1 - 0.289285714285714*G0_0_2 - 0.0241071428571427*G0_1_0 - 0.0482142857142856*G0_1_1 - 0.16875*G0_1_2 - 0.0482142857142856*G0_2_0 - 0.16875*G0_2_1 - 0.289285714285714*G0_2_2;
    A[258] = -0.144642857142857*G0_0_0 - 0.024107142857143*G0_0_1 - 0.144642857142857*G0_0_2 - 0.024107142857143*G0_1_0 - 0.0241071428571429*G0_1_2 - 0.144642857142857*G0_2_0 - 0.024107142857143*G0_2_1 - 0.144642857142857*G0_2_2;
    A[259] = -0.289285714285714*G0_0_0 - 0.16875*G0_0_1 - 0.0482142857142858*G0_0_2 - 0.16875*G0_1_0 - 0.0482142857142856*G0_1_1 - 0.0241071428571428*G0_1_2 - 0.289285714285714*G0_2_0 - 0.16875*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[260] = 0.0133928571428571*G0_0_0 + 0.0133928571428571*G0_0_1 + 0.0133928571428571*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0133928571428571*G0_2_0 + 0.0133928571428571*G0_2_1 + 0.0133928571428571*G0_2_2;
    A[261] = -0.0133928571428571*G0_0_0 - 0.0133928571428571*G0_2_0;
    A[262] = -0.0616071428571428*G0_0_1 - 0.0964285714285713*G0_1_1 - 0.0616071428571428*G0_2_1;
    A[263] = -0.0133928571428571*G0_0_2 - 0.0133928571428571*G0_2_2;
    A[264] = -0.0964285714285714*G0_0_1 - 0.192857142857143*G0_0_2 + 0.0241071428571429*G0_1_1 - 0.0964285714285713*G0_1_2 - 0.0964285714285715*G0_2_1 - 0.192857142857143*G0_2_2;
    A[265] = 0.0241071428571429*G0_0_1 + 0.0723214285714285*G0_0_2 + 0.0241071428571429*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.0723214285714285*G0_2_2;
    A[266] = 0.0241071428571427*G0_0_0 + 0.0241071428571428*G0_0_2 + 0.0241071428571428*G0_2_0 + 0.0241071428571428*G0_2_2;
    A[267] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0241071428571429*G0_2_2;
    A[268] = 0.0723214285714284*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0723214285714285*G0_2_0 + 0.0241071428571428*G0_2_1;
    A[269] = -0.192857142857143*G0_0_0 - 0.0964285714285714*G0_0_1 - 0.0964285714285713*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.192857142857143*G0_2_0 - 0.0964285714285714*G0_2_1;
    A[270] = -0.0241071428571428*G0_0_0 - 0.0241071428571428*G0_0_1 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.0241071428571428*G0_2_1;
    A[271] = -0.0241071428571429*G0_0_0 - 0.0241071428571429*G0_0_1 - 0.0241071428571428*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_1;
    A[272] = -0.0723214285714285*G0_0_0 - 0.0482142857142856*G0_0_1 - 0.0723214285714284*G0_0_2 - 0.144642857142857*G0_1_0 - 0.192857142857143*G0_1_1 - 0.144642857142857*G0_1_2 - 0.0723214285714285*G0_2_0 - 0.0482142857142856*G0_2_1 - 0.0723214285714285*G0_2_2;
    A[273] = 0.192857142857143*G0_0_0 + 0.0964285714285713*G0_0_1 + 0.192857142857143*G0_0_2 + 0.0964285714285713*G0_1_0 + 0.241071428571428*G0_1_1 + 0.0964285714285713*G0_1_2 + 0.192857142857143*G0_2_0 + 0.0964285714285713*G0_2_1 + 0.192857142857143*G0_2_2;
    A[274] = -0.0241071428571428*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_1 + 0.0241071428571429*G0_1_2 - 0.0241071428571428*G0_2_1 - 0.0241071428571428*G0_2_2;
    A[275] = -0.0241071428571428*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.0241071428571428*G0_1_0 - 0.0241071428571428*G0_2_1 - 0.0241071428571429*G0_2_2;
    A[276] = -0.0964285714285714*G0_0_0 + 0.0241071428571428*G0_0_1 - 0.0964285714285716*G0_0_2 + 0.024107142857143*G0_1_0 + 0.0241071428571429*G0_1_2 - 0.0964285714285714*G0_2_0 + 0.0241071428571428*G0_2_1 - 0.0964285714285715*G0_2_2;
    A[277] = 0.0964285714285714*G0_0_0 + 0.120535714285714*G0_0_1 - 0.0241071428571429*G0_1_0 - 0.0482142857142858*G0_1_1 + 0.120535714285714*G0_1_2 + 0.0964285714285715*G0_2_0 + 0.120535714285714*G0_2_1;
    A[278] = -0.0241071428571427*G0_0_1 - 0.0241071428571428*G0_1_0 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_1;
    A[279] = 0.120535714285714*G0_0_1 + 0.0964285714285716*G0_0_2 + 0.120535714285714*G0_1_0 - 0.0482142857142858*G0_1_1 - 0.0241071428571429*G0_1_2 + 0.120535714285714*G0_2_1 + 0.0964285714285716*G0_2_2;
    A[280] = -0.0964285714285715*G0_0_0 - 0.0964285714285714*G0_0_1 - 0.0964285714285714*G0_0_2 - 0.0348214285714286*G0_1_0 - 0.0348214285714286*G0_1_1 - 0.0348214285714286*G0_1_2 - 0.0348214285714286*G0_2_0 - 0.0348214285714286*G0_2_1 - 0.0348214285714286*G0_2_2;
    A[281] = 0.0482142857142857*G0_0_0 + 0.0348214285714286*G0_1_0 + 0.0348214285714286*G0_2_0;
    A[282] = -0.0133928571428571*G0_1_1 - 0.0133928571428572*G0_2_1;
    A[283] = -0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_2;
    A[284] = 0.0241071428571429*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[285] = 0.0241071428571429*G0_1_1 + 0.024107142857143*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.024107142857143*G0_2_2;
    A[286] = 0.0241071428571429*G0_0_0 + 0.0482142857142858*G0_0_2 + 0.0482142857142858*G0_1_0 + 0.0723214285714286*G0_1_2 + 0.0482142857142858*G0_2_0 + 0.0723214285714287*G0_2_2;
    A[287] = 0.0241071428571428*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0482142857142857*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.0482142857142857*G0_2_2;
    A[288] = 0.0241071428571429*G0_0_0 + 0.0482142857142858*G0_0_1 + 0.0482142857142858*G0_1_0 + 0.0723214285714287*G0_1_1 + 0.0482142857142858*G0_2_0 + 0.0723214285714287*G0_2_1;
    A[289] = 0.0241071428571428*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0482142857142856*G0_1_1 + 0.0241071428571428*G0_2_0 + 0.0482142857142857*G0_2_1;
    A[290] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.120535714285714*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 + 0.0241071428571429*G0_2_2;
    A[291] = -0.0241071428571429*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_1 + 0.0241071428571428*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[292] = 0.0241071428571429*G0_0_0 + 0.120535714285714*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.120535714285714*G0_1_0 + 0.0241071428571428*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.0241071428571428*G0_2_1 + 0.120535714285714*G0_2_2;
    A[293] = -0.0241071428571429*G0_0_1 - 0.0241071428571428*G0_1_0 + 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_0 + 0.0241071428571429*G0_2_1 - 0.0241071428571428*G0_2_2;
    A[294] = 0.241071428571429*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142857*G0_0_2 + 0.144642857142857*G0_1_0 + 0.241071428571428*G0_1_1 + 0.241071428571428*G0_1_2 + 0.144642857142857*G0_2_0 + 0.241071428571428*G0_2_1 + 0.241071428571428*G0_2_2;
    A[295] = -0.192857142857143*G0_0_0 - 0.0482142857142858*G0_0_1 - 0.0482142857142858*G0_0_2 - 0.144642857142857*G0_1_0 - 0.0723214285714286*G0_1_1 - 0.0723214285714286*G0_1_2 - 0.144642857142857*G0_2_0 - 0.0723214285714286*G0_2_1 - 0.0723214285714286*G0_2_2;
    A[296] = 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_0_2 + 0.024107142857143*G0_1_0 + 0.0482142857142858*G0_1_1 + 0.0482142857142858*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.0482142857142858*G0_2_1 + 0.0482142857142858*G0_2_2;
    A[297] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.144642857142857*G0_1_1 - 0.144642857142857*G0_1_2 - 0.024107142857143*G0_2_0 - 0.144642857142857*G0_2_1 - 0.144642857142857*G0_2_2;
    A[298] = -0.0482142857142859*G0_0_0 - 0.0241071428571429*G0_0_1 - 0.16875*G0_0_2 - 0.16875*G0_1_0 - 0.0482142857142859*G0_1_1 - 0.289285714285714*G0_1_2 - 0.16875*G0_2_0 - 0.0482142857142859*G0_2_1 - 0.289285714285714*G0_2_2;
    A[299] = -0.0482142857142858*G0_0_0 - 0.16875*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.16875*G0_1_0 - 0.289285714285714*G0_1_1 - 0.0482142857142858*G0_1_2 - 0.16875*G0_2_0 - 0.289285714285714*G0_2_1 - 0.0482142857142858*G0_2_2;
    A[300] = 0.0482142857142858*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0133928571428572*G0_1_0 + 0.0133928571428571*G0_1_1 + 0.0133928571428571*G0_1_2 + 0.0133928571428572*G0_2_0 + 0.0133928571428572*G0_2_1 + 0.0133928571428572*G0_2_2;
    A[301] = -0.0964285714285714*G0_0_0 - 0.0616071428571429*G0_1_0 - 0.0616071428571429*G0_2_0;
    A[302] = -0.0133928571428571*G0_1_1 - 0.0133928571428571*G0_2_1;
    A[303] = -0.0133928571428571*G0_1_2 - 0.0133928571428571*G0_2_2;
    A[304] = 0.0241071428571428*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571428*G0_2_1 + 0.0241071428571429*G0_2_2;
    A[305] = 0.0241071428571429*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.0241071428571428*G0_2_2;
    A[306] = 0.0241071428571428*G0_0_0 - 0.0964285714285715*G0_0_2 - 0.0964285714285713*G0_1_0 - 0.192857142857143*G0_1_2 - 0.0964285714285713*G0_2_0 - 0.192857142857143*G0_2_2;
    A[307] = 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0723214285714286*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.0723214285714285*G0_2_2;
    A[308] = 0.0241071428571428*G0_0_0 - 0.0964285714285715*G0_0_1 - 0.0964285714285713*G0_1_0 - 0.192857142857143*G0_1_1 - 0.0964285714285713*G0_2_0 - 0.192857142857143*G0_2_1;
    A[309] = 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_1_0 + 0.0723214285714286*G0_1_1 + 0.0241071428571428*G0_2_0 + 0.0723214285714286*G0_2_1;
    A[310] = 0.0241071428571429*G0_0_0 + 0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0241071428571428*G0_1_0 - 0.0241071428571429*G0_1_1 - 0.0241071428571428*G0_2_0 - 0.0241071428571428*G0_2_1;
    A[311] = -0.0241071428571428*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_1 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_1;
    A[312] = 0.0241071428571428*G0_0_0 - 0.0241071428571429*G0_0_1 + 0.0241071428571428*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_2;
    A[313] = -0.0241071428571428*G0_0_1 - 0.0241071428571428*G0_1_0 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_0 - 0.0241071428571429*G0_2_2;
    A[314] = -0.192857142857143*G0_0_0 - 0.144642857142857*G0_0_1 - 0.144642857142857*G0_0_2 - 0.0482142857142858*G0_1_0 - 0.0723214285714286*G0_1_1 - 0.0723214285714286*G0_1_2 - 0.0482142857142858*G0_2_0 - 0.0723214285714286*G0_2_1 - 0.0723214285714286*G0_2_2;
    A[315] = 0.241071428571429*G0_0_0 + 0.0964285714285715*G0_0_1 + 0.0964285714285715*G0_0_2 + 0.0964285714285715*G0_1_0 + 0.192857142857143*G0_1_1 + 0.192857142857143*G0_1_2 + 0.0964285714285715*G0_2_0 + 0.192857142857143*G0_2_1 + 0.192857142857143*G0_2_2;
    A[316] = 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_1_0 - 0.0964285714285711*G0_1_1 - 0.0964285714285713*G0_1_2 + 0.0241071428571429*G0_2_0 - 0.0964285714285712*G0_2_1 - 0.0964285714285713*G0_2_2;
    A[317] = -0.0241071428571428*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0241071428571429*G0_2_0;
    A[318] = -0.0482142857142857*G0_0_0 - 0.0241071428571429*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.0964285714285712*G0_1_1 + 0.120535714285714*G0_2_0 + 0.0964285714285713*G0_2_1;
    A[319] = -0.0482142857142857*G0_0_0 + 0.120535714285714*G0_0_1 - 0.0241071428571429*G0_0_2 + 0.120535714285714*G0_1_0 + 0.0964285714285712*G0_1_2 + 0.120535714285714*G0_2_0 + 0.0964285714285712*G0_2_2;
    A[320] = -0.0321428571428571*G0_0_0 - 0.0321428571428571*G0_0_1 - 0.0321428571428571*G0_0_2 - 0.0321428571428571*G0_1_0 - 0.0321428571428571*G0_1_1 - 0.0321428571428571*G0_1_2 - 0.0321428571428571*G0_2_0 - 0.0321428571428571*G0_2_1 - 0.0321428571428571*G0_2_2;
    A[321] = 0.0321428571428571*G0_0_0 - 0.0160714285714286*G0_1_0 - 0.0160714285714285*G0_2_0;
    A[322] = -0.0160714285714286*G0_0_1 + 0.0321428571428571*G0_1_1 - 0.0160714285714285*G0_2_1;
    A[323] = -0.0160714285714285*G0_0_2 - 0.0160714285714285*G0_1_2 + 0.0321428571428571*G0_2_2;
    A[324] = 0.241071428571428*G0_0_1 + 0.0964285714285714*G0_0_2 - 0.0482142857142857*G0_1_1 - 0.0241071428571429*G0_1_2 + 0.120535714285714*G0_2_1 + 0.0964285714285715*G0_2_2;
    A[325] = 0.0964285714285713*G0_0_1 + 0.241071428571428*G0_0_2 + 0.0964285714285716*G0_1_1 + 0.120535714285714*G0_1_2 - 0.024107142857143*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[326] = -0.0482142857142856*G0_0_0 - 0.0241071428571428*G0_0_2 + 0.241071428571428*G0_1_0 + 0.0964285714285713*G0_1_2 + 0.120535714285714*G0_2_0 + 0.0964285714285714*G0_2_2;
    A[327] = 0.0964285714285714*G0_0_0 + 0.120535714285714*G0_0_2 + 0.0964285714285716*G0_1_0 + 0.241071428571429*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0482142857142856*G0_2_2;
    A[328] = -0.0482142857142855*G0_0_0 - 0.0241071428571428*G0_0_1 + 0.120535714285714*G0_1_0 + 0.0964285714285714*G0_1_1 + 0.241071428571428*G0_2_0 + 0.0964285714285713*G0_2_1;
    A[329] = 0.0964285714285714*G0_0_0 + 0.120535714285714*G0_0_1 - 0.0241071428571428*G0_1_0 - 0.0482142857142857*G0_1_1 + 0.0964285714285716*G0_2_0 + 0.241071428571428*G0_2_1;
    A[330] = 0.0482142857142856*G0_0_0 + 0.0482142857142856*G0_0_1 + 0.0241071428571427*G0_0_2 + 0.0482142857142858*G0_1_0 + 0.0482142857142858*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571429*G0_2_0 + 0.024107142857143*G0_2_1;
    A[331] = -0.0964285714285713*G0_0_0 - 0.0964285714285713*G0_0_1 + 0.0241071428571429*G0_0_2 - 0.0964285714285715*G0_1_0 - 0.0964285714285715*G0_1_1 + 0.0241071428571429*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[332] = 0.0482142857142856*G0_0_0 + 0.0241071428571427*G0_0_1 + 0.0482142857142856*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0241071428571429*G0_1_2 + 0.0482142857142858*G0_2_0 + 0.0241071428571427*G0_2_1 + 0.0482142857142856*G0_2_2;
    A[333] = -0.0964285714285714*G0_0_0 + 0.024107142857143*G0_0_1 - 0.0964285714285714*G0_0_2 + 0.0241071428571428*G0_1_0 + 0.0241071428571428*G0_1_2 - 0.0964285714285716*G0_2_0 + 0.0241071428571429*G0_2_1 - 0.0964285714285715*G0_2_2;
    A[334] = 0.024107142857143*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_1_0 + 0.0482142857142858*G0_1_1 + 0.0482142857142858*G0_1_2 + 0.0241071428571428*G0_2_0 + 0.0482142857142858*G0_2_1 + 0.0482142857142858*G0_2_2;
    A[335] = 0.0241071428571429*G0_0_1 + 0.0241071428571429*G0_0_2 + 0.0241071428571429*G0_1_0 - 0.0964285714285711*G0_1_1 - 0.0964285714285712*G0_1_2 + 0.0241071428571429*G0_2_0 - 0.0964285714285713*G0_2_1 - 0.0964285714285713*G0_2_2;
    A[336] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571428*G0_2_2;
    A[337] = -0.578571428571428*G0_0_0 - 0.289285714285714*G0_0_1 - 0.289285714285714*G0_0_2 - 0.289285714285714*G0_1_0 - 0.144642857142857*G0_1_2 - 0.289285714285714*G0_2_0 - 0.144642857142858*G0_2_1;
    A[338] = -0.289285714285714*G0_0_1 - 0.144642857142857*G0_0_2 - 0.289285714285714*G0_1_0 - 0.578571428571428*G0_1_1 - 0.289285714285714*G0_1_2 - 0.144642857142857*G0_2_0 - 0.289285714285714*G0_2_1;
    A[339] = -0.144642857142857*G0_0_1 - 0.289285714285714*G0_0_2 - 0.144642857142857*G0_1_0 - 0.289285714285714*G0_1_2 - 0.289285714285714*G0_2_0 - 0.289285714285714*G0_2_1 - 0.578571428571428*G0_2_2;
    A[340] = 0.0321428571428571*G0_0_0 + 0.0321428571428571*G0_0_1 + 0.0321428571428571*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[341] = -0.0321428571428571*G0_0_0;
    A[342] = 0.0160714285714286*G0_0_1 + 0.0482142857142857*G0_1_1;
    A[343] = 0.0160714285714285*G0_0_2 + 0.0482142857142856*G0_2_2;
    A[344] = -0.241071428571428*G0_0_1 - 0.0964285714285714*G0_0_2 - 0.289285714285714*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1;
    A[345] = -0.0964285714285713*G0_0_1 - 0.241071428571428*G0_0_2 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[346] = 0.0482142857142856*G0_0_0 + 0.0241071428571428*G0_0_2 + 0.0241071428571426*G0_2_0;
    A[347] = -0.0964285714285714*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.144642857142857*G0_2_2;
    A[348] = 0.0482142857142855*G0_0_0 + 0.0241071428571428*G0_0_1 + 0.0241071428571425*G0_1_0;
    A[349] = -0.0964285714285715*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.144642857142857*G0_1_1;
    A[350] = -0.0482142857142857*G0_0_0 - 0.0482142857142857*G0_0_1 - 0.0241071428571428*G0_0_2 - 0.289285714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.16875*G0_1_2 - 0.16875*G0_2_0 - 0.16875*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[351] = 0.0964285714285713*G0_0_0 + 0.0964285714285713*G0_0_1 - 0.0241071428571429*G0_0_2 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 - 0.0482142857142856*G0_2_2;
    A[352] = -0.0482142857142857*G0_0_0 - 0.0241071428571427*G0_0_1 - 0.0482142857142857*G0_0_2 - 0.16875*G0_1_0 - 0.0482142857142856*G0_1_1 - 0.16875*G0_1_2 - 0.289285714285714*G0_2_0 - 0.16875*G0_2_1 - 0.289285714285714*G0_2_2;
    A[353] = 0.0964285714285714*G0_0_0 - 0.0241071428571429*G0_0_1 + 0.0964285714285715*G0_0_2 + 0.120535714285714*G0_1_0 - 0.0482142857142858*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_1;
    A[354] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.144642857142857*G0_1_1 - 0.144642857142857*G0_1_2 - 0.024107142857143*G0_2_0 - 0.144642857142857*G0_2_1 - 0.144642857142857*G0_2_2;
    A[355] = -0.0241071428571429*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.0241071428571428*G0_1_0 - 0.0241071428571428*G0_2_0;
    A[356] = -0.578571428571428*G0_0_0 - 0.289285714285714*G0_0_1 - 0.289285714285714*G0_0_2 - 0.289285714285714*G0_1_0 - 0.144642857142857*G0_1_2 - 0.289285714285714*G0_2_0 - 0.144642857142857*G0_2_1;
    A[357] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571428*G0_2_2;
    A[358] = 0.289285714285714*G0_0_1 + 0.144642857142857*G0_0_2 + 0.289285714285714*G0_1_0 + 0.144642857142857*G0_1_2 + 0.144642857142858*G0_2_0 + 0.144642857142857*G0_2_1 + 0.289285714285714*G0_2_2;
    A[359] = 0.144642857142857*G0_0_1 + 0.289285714285714*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_1 + 0.144642857142857*G0_1_2 + 0.289285714285714*G0_2_0 + 0.144642857142857*G0_2_1;
    A[360] = 0.0482142857142858*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0321428571428572*G0_1_0 + 0.0321428571428572*G0_1_1 + 0.0321428571428572*G0_1_2 + 0.0482142857142857*G0_2_0 + 0.0482142857142857*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[361] = 0.0482142857142857*G0_0_0 + 0.0160714285714286*G0_1_0;
    A[362] = -0.0321428571428571*G0_1_1;
    A[363] = 0.0160714285714285*G0_1_2 + 0.0482142857142856*G0_2_2;
    A[364] = 0.0482142857142857*G0_1_1 + 0.0241071428571428*G0_1_2 + 0.0241071428571429*G0_2_1;
    A[365] = -0.0964285714285716*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.144642857142857*G0_2_2;
    A[366] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_2 - 0.241071428571428*G0_1_0 - 0.0964285714285713*G0_1_2 - 0.120535714285714*G0_2_0;
    A[367] = -0.120535714285714*G0_0_2 - 0.0964285714285716*G0_1_0 - 0.241071428571429*G0_1_2 - 0.120535714285714*G0_2_0 - 0.289285714285714*G0_2_2;
    A[368] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.0964285714285714*G0_1_1;
    A[369] = 0.0241071428571426*G0_0_1 + 0.0241071428571427*G0_1_0 + 0.0482142857142856*G0_1_1;
    A[370] = -0.289285714285714*G0_0_0 - 0.289285714285714*G0_0_1 - 0.16875*G0_0_2 - 0.0482142857142859*G0_1_0 - 0.0482142857142859*G0_1_1 - 0.0241071428571429*G0_1_2 - 0.16875*G0_2_0 - 0.16875*G0_2_1 - 0.0482142857142858*G0_2_2;
    A[371] = 0.120535714285714*G0_0_2 + 0.0964285714285715*G0_1_0 + 0.0964285714285715*G0_1_1 - 0.0241071428571428*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 - 0.0482142857142856*G0_2_2;
    A[372] = -0.144642857142857*G0_0_0 - 0.024107142857143*G0_0_1 - 0.144642857142857*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.144642857142857*G0_2_0 - 0.0241071428571429*G0_2_1 - 0.144642857142857*G0_2_2;
    A[373] = -0.0241071428571428*G0_0_1 - 0.0241071428571427*G0_1_0 - 0.0241071428571428*G0_1_2 - 0.0241071428571428*G0_2_1;
    A[374] = -0.0482142857142859*G0_0_0 - 0.16875*G0_0_1 - 0.16875*G0_0_2 - 0.0241071428571429*G0_1_0 - 0.0482142857142859*G0_1_1 - 0.0482142857142858*G0_1_2 - 0.16875*G0_2_0 - 0.289285714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[375] = -0.0482142857142857*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 - 0.0241071428571429*G0_1_0 + 0.0964285714285712*G0_1_1 + 0.0964285714285713*G0_1_2 + 0.120535714285714*G0_2_0;
    A[376] = -0.289285714285714*G0_0_1 - 0.144642857142857*G0_0_2 - 0.289285714285714*G0_1_0 - 0.578571428571428*G0_1_1 - 0.289285714285714*G0_1_2 - 0.144642857142857*G0_2_0 - 0.289285714285714*G0_2_1;
    A[377] = 0.289285714285714*G0_0_1 + 0.144642857142858*G0_0_2 + 0.289285714285714*G0_1_0 + 0.144642857142857*G0_1_2 + 0.144642857142857*G0_2_0 + 0.144642857142857*G0_2_1 + 0.289285714285714*G0_2_2;
    A[378] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285715*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285715*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571428*G0_2_2;
    A[379] = 0.289285714285715*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142857*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_2 + 0.144642857142858*G0_2_0 + 0.289285714285714*G0_2_1;
    A[380] = 0.0482142857142857*G0_0_0 + 0.0482142857142857*G0_0_1 + 0.0482142857142857*G0_0_2 + 0.0482142857142857*G0_1_0 + 0.0482142857142857*G0_1_1 + 0.0482142857142857*G0_1_2 + 0.0321428571428571*G0_2_0 + 0.0321428571428571*G0_2_1 + 0.0321428571428571*G0_2_2;
    A[381] = 0.0482142857142857*G0_0_0 + 0.0160714285714285*G0_2_0;
    A[382] = 0.0482142857142856*G0_1_1 + 0.0160714285714285*G0_2_1;
    A[383] = -0.0321428571428571*G0_2_2;
    A[384] = -0.144642857142857*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.0964285714285716*G0_2_2;
    A[385] = 0.0241071428571427*G0_1_2 + 0.0241071428571429*G0_2_1 + 0.0482142857142857*G0_2_2;
    A[386] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.0964285714285714*G0_2_2;
    A[387] = 0.0241071428571426*G0_0_2 + 0.0241071428571429*G0_2_0 + 0.0482142857142856*G0_2_2;
    A[388] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.241071428571428*G0_2_0 - 0.0964285714285713*G0_2_1;
    A[389] = -0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.0964285714285716*G0_2_0 - 0.241071428571429*G0_2_1;
    A[390] = -0.144642857142857*G0_0_0 - 0.144642857142857*G0_0_1 - 0.0241071428571429*G0_0_2 - 0.144642857142857*G0_1_0 - 0.144642857142857*G0_1_1 - 0.0241071428571429*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0241071428571429*G0_2_1;
    A[391] = -0.0241071428571428*G0_0_2 - 0.0241071428571428*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[392] = -0.289285714285714*G0_0_0 - 0.16875*G0_0_1 - 0.289285714285714*G0_0_2 - 0.16875*G0_1_0 - 0.0482142857142856*G0_1_1 - 0.16875*G0_1_2 - 0.0482142857142858*G0_2_0 - 0.0241071428571428*G0_2_1 - 0.0482142857142857*G0_2_2;
    A[393] = 0.120535714285714*G0_0_1 + 0.120535714285714*G0_1_0 - 0.0482142857142858*G0_1_1 + 0.120535714285714*G0_1_2 + 0.0964285714285716*G0_2_0 - 0.0241071428571429*G0_2_1 + 0.0964285714285716*G0_2_2;
    A[394] = -0.0482142857142858*G0_0_0 - 0.16875*G0_0_1 - 0.16875*G0_0_2 - 0.16875*G0_1_0 - 0.289285714285714*G0_1_1 - 0.289285714285714*G0_1_2 - 0.0241071428571429*G0_2_0 - 0.0482142857142858*G0_2_1 - 0.0482142857142858*G0_2_2;
    A[395] = -0.0482142857142857*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 - 0.0241071428571429*G0_2_0 + 0.0964285714285713*G0_2_1 + 0.0964285714285713*G0_2_2;
    A[396] = -0.144642857142857*G0_0_1 - 0.289285714285714*G0_0_2 - 0.144642857142857*G0_1_0 - 0.289285714285714*G0_1_2 - 0.289285714285714*G0_2_0 - 0.289285714285714*G0_2_1 - 0.578571428571428*G0_2_2;
    A[397] = 0.144642857142857*G0_0_1 + 0.289285714285714*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_1 + 0.144642857142857*G0_1_2 + 0.289285714285714*G0_2_0 + 0.144642857142857*G0_2_1;
    A[398] = 0.289285714285715*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142858*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_2 + 0.144642857142857*G0_2_0 + 0.289285714285714*G0_2_1;
    A[399] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571429*G0_2_2;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_3_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_3_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      18
    // Number of operations (multiply-add pairs) for geometry tensor:    20
    // Number of operations (multiply-add pairs) for tensor contraction: 270
    // Total number of operations (multiply-add pairs):                  308
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_20 = J_01*J_12 - J_02*J_11;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    
    // Compute element tensor
    A[0] = 0.000595238095238099*G0_0 + 7.44047619047622e-05*G0_1 + 7.44047619047622e-05*G0_2 + 7.44047619047622e-05*G0_3 + 0.000111607142857143*G0_4 + 0.000111607142857143*G0_5 + 0.000111607142857143*G0_6 + 0.000111607142857143*G0_7 + 0.000111607142857143*G0_8 + 0.000111607142857143*G0_9 - 0.000446428571428572*G0_10 + 0.000223214285714286*G0_11 - 0.000446428571428572*G0_12 + 0.000223214285714286*G0_13 - 0.000446428571428572*G0_14 + 0.000223214285714286*G0_15 + 0.00133928571428571*G0_16 + 0.000669642857142859*G0_17 + 0.00066964285714286*G0_18 + 0.000669642857142859*G0_19;
    A[1] = 7.44047619047622e-05*G0_0 + 0.000595238095238098*G0_1 + 7.4404761904762e-05*G0_2 + 7.44047619047619e-05*G0_3 + 0.000111607142857143*G0_4 + 0.000111607142857143*G0_5 - 0.000446428571428571*G0_6 + 0.000223214285714286*G0_7 - 0.000446428571428572*G0_8 + 0.000223214285714286*G0_9 + 0.000111607142857142*G0_10 + 0.000111607142857143*G0_11 + 0.000111607142857143*G0_12 + 0.000111607142857143*G0_13 + 0.000223214285714285*G0_14 - 0.000446428571428571*G0_15 + 0.000669642857142857*G0_16 + 0.00133928571428571*G0_17 + 0.000669642857142857*G0_18 + 0.000669642857142857*G0_19;
    A[2] = 7.44047619047622e-05*G0_0 + 7.4404761904762e-05*G0_1 + 0.000595238095238097*G0_2 + 7.4404761904762e-05*G0_3 - 0.000446428571428571*G0_4 + 0.000223214285714286*G0_5 + 0.000111607142857142*G0_6 + 0.000111607142857143*G0_7 + 0.000223214285714285*G0_8 - 0.000446428571428571*G0_9 + 0.000111607142857142*G0_10 + 0.000111607142857143*G0_11 + 0.000223214285714285*G0_12 - 0.000446428571428571*G0_13 + 0.000111607142857142*G0_14 + 0.000111607142857143*G0_15 + 0.000669642857142857*G0_16 + 0.000669642857142858*G0_17 + 0.00133928571428571*G0_18 + 0.000669642857142857*G0_19;
    A[3] = 7.44047619047623e-05*G0_0 + 7.44047619047619e-05*G0_1 + 7.4404761904762e-05*G0_2 + 0.000595238095238098*G0_3 + 0.000223214285714285*G0_4 - 0.000446428571428571*G0_5 + 0.000223214285714286*G0_6 - 0.000446428571428571*G0_7 + 0.000111607142857143*G0_8 + 0.000111607142857143*G0_9 + 0.000223214285714285*G0_10 - 0.00044642857142857*G0_11 + 0.000111607142857142*G0_12 + 0.000111607142857143*G0_13 + 0.000111607142857142*G0_14 + 0.000111607142857143*G0_15 + 0.000669642857142857*G0_16 + 0.000669642857142857*G0_17 + 0.000669642857142857*G0_18 + 0.00133928571428571*G0_19;
    A[4] = 0.000111607142857143*G0_0 + 0.000111607142857143*G0_1 - 0.000446428571428571*G0_2 + 0.000223214285714285*G0_3 + 0.00401785714285714*G0_4 - 0.00200892857142857*G0_5 - 0.00100446428571429*G0_7 - 0.00100446428571428*G0_8 + 0.00200892857142857*G0_9 - 0.00100446428571429*G0_11 - 0.00100446428571429*G0_12 + 0.00200892857142857*G0_13 - 0.00200892857142857*G0_18;
    A[5] = 0.000111607142857143*G0_0 + 0.000111607142857143*G0_1 + 0.000223214285714286*G0_2 - 0.000446428571428571*G0_3 - 0.00200892857142857*G0_4 + 0.00401785714285714*G0_5 - 0.00100446428571429*G0_6 + 0.00200892857142857*G0_7 - 0.00100446428571429*G0_9 - 0.00100446428571429*G0_10 + 0.00200892857142857*G0_11 - 0.00100446428571429*G0_13 - 0.00200892857142857*G0_19;
    A[6] = 0.000111607142857143*G0_0 - 0.000446428571428571*G0_1 + 0.000111607142857143*G0_2 + 0.000223214285714286*G0_3 - 0.00100446428571429*G0_5 + 0.00401785714285714*G0_6 - 0.00200892857142857*G0_7 + 0.00200892857142857*G0_8 - 0.00100446428571428*G0_9 - 0.00100446428571429*G0_11 - 0.00100446428571429*G0_14 + 0.00200892857142857*G0_15 - 0.00200892857142857*G0_17;
    A[7] = 0.000111607142857143*G0_0 + 0.000223214285714286*G0_1 + 0.000111607142857143*G0_2 - 0.000446428571428571*G0_3 - 0.00100446428571429*G0_4 + 0.00200892857142857*G0_5 - 0.00200892857142857*G0_6 + 0.00401785714285714*G0_7 - 0.00100446428571429*G0_8 - 0.00100446428571429*G0_10 + 0.00200892857142857*G0_11 - 0.00100446428571429*G0_15 - 0.00200892857142857*G0_19;
    A[8] = 0.000111607142857143*G0_0 - 0.000446428571428572*G0_1 + 0.000223214285714285*G0_2 + 0.000111607142857143*G0_3 - 0.00100446428571428*G0_4 + 0.00200892857142857*G0_6 - 0.00100446428571429*G0_7 + 0.00401785714285714*G0_8 - 0.00200892857142857*G0_9 - 0.00100446428571429*G0_13 - 0.00100446428571429*G0_14 + 0.00200892857142857*G0_15 - 0.00200892857142857*G0_17;
    A[9] = 0.000111607142857143*G0_0 + 0.000223214285714286*G0_1 - 0.000446428571428571*G0_2 + 0.000111607142857143*G0_3 + 0.00200892857142857*G0_4 - 0.00100446428571429*G0_5 - 0.00100446428571428*G0_6 - 0.00200892857142857*G0_8 + 0.00401785714285714*G0_9 - 0.00100446428571429*G0_12 + 0.00200892857142857*G0_13 - 0.00100446428571429*G0_15 - 0.00200892857142857*G0_18;
    A[10] = -0.000446428571428572*G0_0 + 0.000111607142857142*G0_1 + 0.000111607142857142*G0_2 + 0.000223214285714285*G0_3 - 0.00100446428571429*G0_5 - 0.00100446428571429*G0_7 + 0.00401785714285714*G0_10 - 0.00200892857142857*G0_11 + 0.00200892857142857*G0_12 - 0.00100446428571429*G0_13 + 0.00200892857142857*G0_14 - 0.00100446428571429*G0_15 - 0.00200892857142857*G0_16;
    A[11] = 0.000223214285714286*G0_0 + 0.000111607142857143*G0_1 + 0.000111607142857143*G0_2 - 0.00044642857142857*G0_3 - 0.00100446428571429*G0_4 + 0.00200892857142857*G0_5 - 0.00100446428571429*G0_6 + 0.00200892857142857*G0_7 - 0.00200892857142857*G0_10 + 0.00401785714285715*G0_11 - 0.00100446428571429*G0_12 - 0.00100446428571429*G0_14 - 0.00200892857142857*G0_19;
    A[12] = -0.000446428571428572*G0_0 + 0.000111607142857143*G0_1 + 0.000223214285714285*G0_2 + 0.000111607142857143*G0_3 - 0.00100446428571429*G0_4 - 0.00100446428571429*G0_9 + 0.00200892857142857*G0_10 - 0.00100446428571429*G0_11 + 0.00401785714285715*G0_12 - 0.00200892857142857*G0_13 + 0.00200892857142857*G0_14 - 0.00100446428571429*G0_15 - 0.00200892857142857*G0_16;
    A[13] = 0.000223214285714286*G0_0 + 0.000111607142857143*G0_1 - 0.000446428571428571*G0_2 + 0.000111607142857143*G0_3 + 0.00200892857142857*G0_4 - 0.00100446428571429*G0_5 - 0.00100446428571429*G0_8 + 0.00200892857142857*G0_9 - 0.00100446428571429*G0_10 - 0.00200892857142857*G0_12 + 0.00401785714285715*G0_13 - 0.00100446428571429*G0_14 - 0.00200892857142857*G0_18;
    A[14] = -0.000446428571428572*G0_0 + 0.000223214285714285*G0_1 + 0.000111607142857142*G0_2 + 0.000111607142857142*G0_3 - 0.00100446428571429*G0_6 - 0.00100446428571429*G0_8 + 0.00200892857142857*G0_10 - 0.00100446428571429*G0_11 + 0.00200892857142857*G0_12 - 0.00100446428571429*G0_13 + 0.00401785714285715*G0_14 - 0.00200892857142857*G0_15 - 0.00200892857142858*G0_16;
    A[15] = 0.000223214285714286*G0_0 - 0.000446428571428571*G0_1 + 0.000111607142857143*G0_2 + 0.000111607142857143*G0_3 + 0.00200892857142857*G0_6 - 0.00100446428571429*G0_7 + 0.00200892857142857*G0_8 - 0.00100446428571429*G0_9 - 0.00100446428571429*G0_10 - 0.00100446428571429*G0_12 - 0.00200892857142857*G0_14 + 0.00401785714285715*G0_15 - 0.00200892857142857*G0_17;
    A[16] = 0.00133928571428571*G0_0 + 0.000669642857142857*G0_1 + 0.000669642857142857*G0_2 + 0.000669642857142857*G0_3 - 0.00200892857142857*G0_10 - 0.00200892857142857*G0_12 - 0.00200892857142858*G0_14 + 0.0160714285714286*G0_16 + 0.00803571428571428*G0_17 + 0.00803571428571428*G0_18 + 0.00803571428571428*G0_19;
    A[17] = 0.000669642857142859*G0_0 + 0.00133928571428571*G0_1 + 0.000669642857142858*G0_2 + 0.000669642857142857*G0_3 - 0.00200892857142857*G0_6 - 0.00200892857142857*G0_8 - 0.00200892857142857*G0_15 + 0.00803571428571428*G0_16 + 0.0160714285714286*G0_17 + 0.00803571428571429*G0_18 + 0.00803571428571429*G0_19;
    A[18] = 0.00066964285714286*G0_0 + 0.000669642857142857*G0_1 + 0.00133928571428571*G0_2 + 0.000669642857142857*G0_3 - 0.00200892857142857*G0_4 - 0.00200892857142857*G0_9 - 0.00200892857142857*G0_13 + 0.00803571428571428*G0_16 + 0.00803571428571429*G0_17 + 0.0160714285714286*G0_18 + 0.00803571428571429*G0_19;
    A[19] = 0.000669642857142859*G0_0 + 0.000669642857142857*G0_1 + 0.000669642857142857*G0_2 + 0.00133928571428571*G0_3 - 0.00200892857142857*G0_5 - 0.00200892857142857*G0_7 - 0.00200892857142857*G0_11 + 0.00803571428571428*G0_16 + 0.00803571428571429*G0_17 + 0.00803571428571429*G0_18 + 0.0160714285714286*G0_19;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_3_form_0: public ufc::form
{
public:

  /// Constructor
  poisson3d_3_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 3})), SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None), 1), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_3_form_1: public ufc::form
{
public:

  /// Constructor
  poisson3d_3_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None), 0), Coefficient(FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 3, None), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Poisson3D_3
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson3d_3_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "Invalid coeficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_0 JacobianForm;
typedef Form_1 LinearForm;
typedef Form_1 ResidualForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
