// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_5_H
#define __POISSON3D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923465, 0.00609788120679257, 0.00352061335622799, 0.00248944957812477, 0.00705946233325034, 0.00546823600997147, 0.00446479600584761, 0.00315708753234942, 0.00257775117585288, 0.00182274533665717, -0.00298267418725715, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601733, -0.00138070985681771, -0.0011273448773449, -0.000976309302606944, -0.000797153207506486, -0.000563672438672447, 0.00278687112460007, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.0018579140830667, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.0012463266558274, 0.00101762145320216, 0.000928957041533369, 0.000830884437218256, 0.00071956703024016, 0.000587524019939406, 0.000415442218609138, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363027, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923512, -0.00609788120679247, 0.00352061335622801, 0.00248944957812479, 0.00705946233325039, -0.00546823600997145, -0.00446479600584757, 0.00315708753234941, 0.00257775117585286, 0.00182274533665715, 0.00298267418725716, -0.00252081977982929, -0.00218309396769447, 0.00195261860521384, 0.00169101731601731, 0.00138070985681771, -0.00112734487734488, -0.000976309302606922, -0.00079715320750647, -0.000563672438672437, 0.00278687112460002, -0.00245778931055953, -0.00219831358911338, 0.00207721109304566, 0.00185791408306669, 0.00160900079398462, -0.00160900079398462, -0.00143913406048031, -0.0012463266558274, -0.00101762145320215, 0.000928957041533356, 0.00083088443721826, 0.000719567030240153, 0.0005875240199394, 0.000415442218609126, 0.00705593524717798, -0.00638233357089082, -0.00582624677716566, 0.00562868913761197, 0.00513826668309063, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.0030086608985143, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923495, 0.0, -0.00704122671245611, 0.00248944957812476, 0.0, 0.0, 0.0, 0.00947126259704834, -0.0051555023517057, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937952, -0.00292892790782074, 0.00159430641501296, -0.000563672438672428, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0046447852076667, -0.00332353774887305, 0.00215870109072045, -0.00117504803987881, 0.000415442218609132, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680786, -0.000868525589828765};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923497, 0.0, 0.0, -0.0074683487343743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913698, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, 0.0374718748311399, -0.0289614183593723, 0.0, 0.0, 0.0, 0.0284137877911448, 0.0051555023517057, -0.00619733414463434, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0315656565656566, -0.0113902751970807, 0.00265717735835493, -0.00018789081289078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0232239260383337, -0.00166176887443654, -0.00647610327216137, 0.00646276421933344, -0.00290809553026389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213629048496074, -0.0277928188745204, 0.0243701532779658, -0.0157219925555703, 0.00607967912880132};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0, -0.028757485335526, 0.0536094339843701, 0.0, 0.0, 0.0, -0.0189425251940965, 0.0154665070551172, 0.0153110608279201, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0045093795093795, 0.0370997534990628, -0.0281660799985623, 0.0108976671476671, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.00431740218144092, -0.0123380044187275, 0.00872428659079175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, -0.0487403065559316, 0.0412702304583721, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0, 0.0409576306293855, -0.0449826285156206, 0.0, 0.0, 0.0, 0.0189425251940965, -0.0051555023517057, -0.021143845905223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00455611007883226, 0.0356061766019561, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0302218152700864, 0.00411266813957585, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0379091273212801, -0.0550269739444961, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, -0.0148144621425436, 0.0449826285156207, 0.0, 0.0, 0.0, 0.0, 0.0206220094068228, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0106287094334197, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0205633406978791, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.03439185871531, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0324515955311978, -0.0187359374155699, -0.0289614183593722, 0.0211783869997512, -0.0164047080299144, 0.00446479600584757, 0.0094712625970483, -0.00257775117585284, -0.00619733414463434, 0.0208787193108001, -0.0176457384588052, -0.00848980987436739, 0.0136683302364968, 0.00657617845117845, 0.00230118309469618, -0.00789141414141414, -0.0037967583990269, -0.00132858867917748, -0.000187890812890797, 0.0139343556230002, -0.0122889465527977, -0.00109915679455668, 0.0103860554652283, 0.000928957041533339, -0.00482700238195389, -0.00804500396992314, -0.000719567030240159, 0.0037389799674822, 0.00559691799261186, 0.00464478520766673, 0.000415442218609135, -0.00215870109072048, -0.00323138210966671, -0.00290809553026391, 0.0, 0.0, 0.0128177429097644, 0.0, -0.0113041867027994, -0.0183832217438608, 0.0, 0.00955378148811638, 0.0155366580724417, 0.0181644397838736, 0.0, -0.0074003273193559, -0.0120346435940572, -0.014070114555226, -0.0136156449512337, 0.0, 0.00427258096992146, 0.00694820471863012, 0.00812338442598859, 0.00786099627778515, 0.00607967912880133};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734313, -0.0249047128495238, 0.0143787426677629, 0.0536094339843699, -0.0141189246665007, 0.0109364720199429, 0.0133943880175427, -0.00631417506469884, -0.00773325352755864, 0.0153110608279201, -0.00298267418725714, 0.00252081977982934, 0.0276525235907967, -0.00195261860521383, -0.0214195526695527, -0.0243925408037797, 0.00112734487734489, 0.0123665844996876, 0.0140830399992812, 0.0108976671476671, 0.0, 0.0, 0.0197848223020205, 0.0, -0.0167212267476002, -0.00321800158796926, 0.0, 0.0129522065443228, 0.00249265331165478, -0.0106850252586227, 0.0, -0.00747795993496437, -0.00143913406048031, 0.00616900220936374, 0.00872428659079175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, 0.0135389740433143, 0.0281402291104519, 0.0357410679969885, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0354703486038675, -0.0204788153146927, -0.0449826285156207, 0.0141189246665008, -0.0109364720199429, -0.00446479600584751, 0.00631417506469886, 0.00257775117585291, -0.021143845905223, 0.0, 0.0, 0.00339592394974697, 0.0, -0.0026304713804714, 0.030835853468929, 0.0, 0.00151870335961077, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, -0.0174485731815835, 0.00356167508620757, 0.0, 0.0, 0.0100739384233621, -0.00205633406978792, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, -0.0218868448636848, -0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.00740723107127187, 0.0449826285156207, 0.0, 0.0, 0.0178591840233903, 0.0, -0.0103110047034115, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00920473237878483, 0.0, 0.0, -0.00531435471670986, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489395, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0297842233308237, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0324515955311978, -0.0335503995581135, -0.00801060507812423, 0.0211783869997512, 0.00109364720199426, -0.0169662248222207, -0.00568275755822893, 0.00567105258687628, 0.00838462854862287, 0.0208787193108001, -0.0109235523792603, -0.0162519217595033, 0.00499002532443534, 0.00958243145743148, 0.0108922666482287, -0.00187890812890813, -0.00466458889023306, -0.00558007245254537, -0.00469727032227031, 0.0139343556230002, -0.00245778931055953, -0.0120907247401236, -0.00415442218609133, 0.00464478520766674, 0.00965400476390777, 0.00643600317593853, -0.000719567030240148, -0.00498530662330958, -0.00661453944581401, -0.00464478520766674, -0.000415442218609135, 0.00215870109072044, 0.00323138210966672, 0.00290809553026393, 0.0, 0.0127646671417816, -0.00116524935543313, -0.0202632808954031, -0.00719357335632687, 0.00183832217438609, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, -0.020635115229186, -0.01143686949355, -0.00481385743762288, -0.000521115353897266, 0.00170195561890421, 0.0127646671417816, 0.00737991258440982, 0.00347410235931507, 0.000902598269554292, -0.000491312267361576, -0.000868525589828768};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734309, -0.0249047128495239, 0.0553363732971483, -0.00431340273437465, -0.0141189246665008, 0.0153110608279201, 0.00803663281052558, 0.00883984509057834, -0.0159820572902877, 0.000729098134662859, -0.00298267418725716, 0.0277290175781224, -0.00145539597846296, -0.0301571095694136, -0.0116492303992304, 0.00352848074520085, 0.0191648629148629, 0.00976309302606916, 0.00132858867917748, -0.00263047138047137, 0.0, 0.0196623144844763, -0.00219831358911337, -0.00727023882565978, -0.0148633126645335, 0.00402250198496157, -0.00724050357293084, 0.0129522065443227, 0.00685479660705068, -0.0045792965394097, 0.00928957041533348, -0.00664707549774609, -0.0057565362419212, -0.000293762009969712, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0202632808954031, -0.00411061334647248, 0.000459580543596519, -0.0399597288148542, -0.00303983956440068, 0.00427258096992148, -0.00100913554354854, 0.0464290092656685, 0.00908221989193679, -0.00270779480866284, -0.00234501909253765, 0.00127646671417816, -0.031911667854454, -0.00776832903622086, 0.000868525589828756, 0.00180519653910857, 0.000245656133680793, -0.000868525589828769};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0354703486038674, -0.0492363006502187, -0.00431340273437464, 0.0141189246665008, -0.00656188321196573, -0.00982255121286465, -0.016416855168217, 0.0149509568199466, 0.000729098134662881, 0.0, 0.0033610930397724, -0.000485131992821013, 0.0282044909641998, -0.0124007936507937, 0.0029148319199485, -0.0353234728234728, 0.00889526253486302, 0.00239145962251946, -0.00263047138047138, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920009, 0.000804500396992313, -0.00402250198496156, -0.0143913406048031, 0.00934744991870547, -0.00254405363300537, -0.00928957041533351, 0.0141250354327105, -0.00287826812096064, -0.00381890612960614, 0.00290809553026391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320203, 0.00233049871086626, -0.000336378514516182, -0.0515877880729651, 0.00840946286290446, 0.00300866089851428, -0.00286613444643492, 0.000850977809452106, 0.0425488904726053, -0.00388416451811045, -0.00347410235931507, 0.00120346435940573, 0.00098262453472315, -0.000868525589828758};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734311, -0.0128297005588456, 0.0448791059024116, -0.00801060507812425, 0.0, 0.0174983552319087, -0.00357183680467803, 0.0132597676358675, -0.0175287079957995, 0.00838462854862292, 0.0, 0.0, 0.0, 0.00867830491206147, -0.00300625300625301, 0.000613648825252321, 0.0225468975468976, -0.019200749617936, 0.0122230158484327, -0.00469727032227033, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0160900079398463, -0.00719567030240153, 0.0024926533116548, -0.000508810726601081, 0.00464478520766676, -0.0108014976838374, 0.0107935054536023, -0.00734405024924251, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0257938940364826, -0.0134551405806471, 0.00601732179702859, -0.00208446141558904, 0.000425488904726057, -0.031911667854454, 0.0135945758133865, -0.00347410235931503, -0.000902598269554298, 0.0017195929357655, -0.000868525589828767};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734316, -0.0324515955311979, -0.0187359374155699, -0.0289614183593722, 0.0211783869997512, 0.0164047080299144, -0.00446479600584758, 0.00947126259704828, -0.00257775117585287, -0.00619733414463427, -0.0208787193108001, -0.0176457384588051, -0.0084898098743674, -0.0136683302364968, -0.00657617845117843, -0.00230118309469622, -0.00789141414141414, -0.00379675839902689, -0.00132858867917748, -0.0001878908128908, 0.0139343556230002, 0.0122889465527977, 0.00109915679455668, 0.0103860554652283, 0.000928957041533344, -0.0048270023819539, 0.00804500396992314, 0.000719567030240151, -0.00373897996748219, -0.00559691799261186, 0.00464478520766674, 0.000415442218609132, -0.00215870109072046, -0.00323138210966671, -0.00290809553026394, 0.0, 0.0, 0.0128177429097644, 0.0, 0.0113041867027994, 0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, 0.00740032731935589, 0.0120346435940572, 0.014070114555226, 0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863012, 0.00812338442598858, 0.00786099627778515, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734315, 0.0249047128495239, 0.014378742667763, 0.0536094339843698, -0.0141189246665008, -0.0109364720199429, -0.0133943880175426, -0.00631417506469883, -0.00773325352755856, 0.0153110608279199, 0.00298267418725717, 0.00252081977982929, 0.0276525235907967, 0.00195261860521384, 0.0214195526695527, 0.0243925408037797, 0.00112734487734486, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, -0.0197848223020205, 0.0, -0.0167212267476003, -0.00321800158796924, 0.0, -0.0129522065443227, -0.00249265331165479, 0.0106850252586226, 0.0, -0.00747795993496438, -0.00143913406048031, 0.00616900220936373, 0.00872428659079181, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, -0.0135389740433143, -0.0281402291104519, -0.0357410679969885, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, -0.0354703486038674, -0.0204788153146928, -0.0449826285156206, 0.0141189246665008, 0.0109364720199429, 0.0044647960058476, 0.00631417506469885, 0.00257775117585289, -0.0211438459052229, 0.0, 0.0, 0.00339592394974697, 0.0, 0.00263047138047138, -0.0308358534689291, 0.0, 0.00151870335961077, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, 0.0174485731815835, -0.00356167508620759, 0.0, 0.0, 0.0100739384233621, -0.00205633406978796, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, 0.0218868448636849, 0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0128297005588457, 0.00740723107127186, 0.0449826285156208, 0.0, 0.0, -0.0178591840233903, 0.0, -0.0103110047034114, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00920473237878476, 0.0, 0.0, -0.00531435471670986, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489395, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0297842233308238, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734304, -0.0324515955311978, -0.0335503995581136, -0.00801060507812425, 0.0211783869997512, -0.00109364720199431, 0.0169662248222208, -0.00568275755822893, 0.00567105258687628, 0.00838462854862292, -0.0208787193108001, -0.0109235523792603, -0.0162519217595033, -0.00499002532443533, -0.00958243145743145, -0.0108922666482287, -0.00187890812890814, -0.00466458889023305, -0.00558007245254536, -0.00469727032227032, 0.0139343556230002, 0.00245778931055952, 0.0120907247401236, -0.00415442218609135, 0.00464478520766673, 0.00965400476390776, -0.00643600317593853, 0.000719567030240145, 0.00498530662330959, 0.00661453944581401, -0.00464478520766678, -0.000415442218609127, 0.00215870109072045, 0.00323138210966672, 0.00290809553026392, 0.0, 0.0127646671417816, -0.00116524935543313, 0.0202632808954031, 0.00719357335632687, -0.00183832217438607, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, 0.020635115229186, 0.01143686949355, 0.00481385743762287, 0.000521115353897249, -0.00170195561890421, 0.0127646671417816, 0.00737991258440981, 0.00347410235931507, 0.000902598269554275, -0.000491312267361575, -0.000868525589828767};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734308, 0.024904712849524, 0.0553363732971482, -0.00431340273437462, -0.0141189246665007, -0.0153110608279201, -0.0080366328105256, 0.00883984509057836, -0.0159820572902877, 0.00072909813466286, 0.00298267418725715, 0.0277290175781224, -0.00145539597846298, 0.0301571095694136, 0.0116492303992304, -0.00352848074520084, 0.0191648629148629, 0.00976309302606918, 0.00132858867917747, -0.00263047138047137, 0.0, -0.0196623144844763, 0.00219831358911336, -0.00727023882565976, -0.0148633126645335, 0.00402250198496157, 0.00724050357293085, -0.0129522065443228, -0.00685479660705068, 0.00457929653940971, 0.00928957041533352, -0.00664707549774611, -0.0057565362419212, -0.000293762009969707, 0.00290809553026392, 0.0, 0.0, 0.0, -0.0202632808954031, 0.00411061334647247, -0.000459580543596518, -0.0399597288148542, -0.00303983956440067, 0.00427258096992149, -0.00100913554354854, -0.0464290092656686, -0.00908221989193681, 0.00270779480866286, 0.00234501909253767, -0.00127646671417816, -0.031911667854454, -0.00776832903622084, 0.000868525589828741, 0.00180519653910859, 0.000245656133680784, -0.000868525589828764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734313, -0.0354703486038675, -0.0492363006502186, -0.00431340273437463, 0.0141189246665008, 0.00656188321196573, 0.00982255121286465, -0.016416855168217, 0.0149509568199466, 0.000729098134662877, 0.0, 0.00336109303977242, -0.000485131992821003, -0.0282044909641998, 0.0124007936507937, -0.00291483191994852, -0.0353234728234728, 0.00889526253486301, 0.00239145962251945, -0.00263047138047139, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920008, 0.000804500396992315, 0.00402250198496156, 0.0143913406048031, -0.00934744991870546, 0.00254405363300537, -0.00928957041533352, 0.0141250354327105, -0.00287826812096063, -0.00381890612960613, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086625, -0.000336378514516179, 0.0515877880729651, -0.00840946286290444, -0.00300866089851428, 0.00286613444643491, -0.000850977809452102, 0.0425488904726053, -0.00388416451811045, -0.00347410235931505, 0.00120346435940571, 0.000982624534723158, -0.00086852558982876};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0128297005588457, 0.0448791059024117, -0.00801060507812425, 0.0, -0.0174983552319087, 0.00357183680467805, 0.0132597676358676, -0.0175287079957995, 0.00838462854862291, 0.0, 0.0, 0.0, -0.00867830491206148, 0.003006253006253, -0.000613648825252317, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0160900079398463, 0.00719567030240154, -0.0024926533116548, 0.000508810726601093, 0.00464478520766676, -0.0108014976838374, 0.0107935054536023, -0.00734405024924251, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0257938940364825, 0.0134551405806471, -0.00601732179702859, 0.00208446141558904, -0.000425488904726058, -0.031911667854454, 0.0135945758133865, -0.00347410235931504, -0.000902598269554289, 0.00171959293576549, -0.00086852558982877};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734306, -0.0452812960900435, -0.0113287063442981, -0.00801060507812427, -0.00141189246665008, 0.0164047080299143, 0.0133943880175427, 0.0145226026488074, 0.0118576554089231, 0.00838462854862292, -0.00894802256177149, -0.0142846454190327, -0.0123708658169354, -0.014536160727703, -0.0125886844636845, -0.0102786178229764, -0.00939454064454065, -0.00813591085505764, -0.00664294339588733, -0.00469727032227032, -0.00836061337380014, 0.00245778931055954, 0.00219831358911338, 0.00830884437218262, 0.00743165633226679, 0.00643600317593851, 0.00965400476390779, 0.00863480436288184, 0.00747795993496439, 0.00610572871921294, 0.00650269929073342, 0.00581619106052785, 0.00503696921168106, 0.00411266813957582, 0.00290809553026391, 0.0352796762358899, 0.0191470007126724, 0.017478740331497, 0.00788016479265675, 0.00719357335632688, 0.00643412761035129, 0.00095142211463938, 0.000868525589828755, 0.000776832903622077, 0.000672757029032348, -0.00221090520312707, -0.00201827108709705, -0.00180519653910857, -0.00156334606169178, -0.00127646671417816, -0.00212744452363026, -0.00194208225905522, -0.00173705117965752, -0.00150433044925715, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0603750614533912, -0.00610007264692968, -0.00431340273437459, -0.00564756986660033, -0.0218729440398858, -0.0178591840233902, 0.00126283501293976, 0.00103110047034113, 0.000729098134662864, 0.0417574386216003, 0.0168054651988621, 0.0145539597846298, -0.000867830491206143, -0.000751563251563245, -0.000613648825252304, -0.00526094276094276, -0.00455611007883229, -0.00372004830169692, -0.00263047138047139, 0.00557374224920013, -0.0196623144844763, -0.0175865087129071, -0.0103860554652283, -0.00928957041533348, -0.00804500396992314, 0.00321800158796925, 0.00287826812096062, 0.00249265331165479, 0.00203524290640429, 0.00650269929073342, 0.00581619106052785, 0.00503696921168108, 0.00411266813957584, 0.00290809553026395, -0.0705593524717798, -0.0127646671417816, -0.0116524935543313, 0.00450295131008956, 0.00411061334647247, 0.00367664434877215, 0.00380568845855755, 0.00347410235931509, 0.00310733161448836, 0.00269102811612943, -0.00073696840104236, -0.000672757029032368, -0.000601732179702871, -0.000521115353897269, -0.000425488904726046, -0.00212744452363026, -0.00194208225905521, -0.00173705117965753, -0.00150433044925714, -0.00122828066840394, -0.000868525589828776};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734312, -0.0603750614533913, -0.00610007264692976, -0.00431340273437462, -0.00564756986660025, 0.0218729440398858, 0.0178591840233902, 0.00126283501293977, 0.00103110047034114, 0.000729098134662859, -0.0417574386216002, 0.0168054651988621, 0.0145539597846299, 0.000867830491206133, 0.000751563251563239, 0.000613648825252299, -0.00526094276094275, -0.00455611007883226, -0.0037200483016969, -0.00263047138047138, 0.00557374224920004, 0.0196623144844763, 0.0175865087129071, -0.0103860554652283, -0.00928957041533348, -0.00804500396992315, -0.00321800158796928, -0.00287826812096062, -0.0024926533116548, -0.0020352429064043, 0.00650269929073342, 0.00581619106052786, 0.00503696921168108, 0.00411266813957581, 0.00290809553026392, 0.0705593524717798, -0.0127646671417816, -0.0116524935543313, -0.00450295131008957, -0.00411061334647248, -0.00367664434877215, 0.00380568845855754, 0.00347410235931504, 0.00310733161448834, 0.00269102811612942, 0.000736968401042371, 0.000672757029032358, 0.000601732179702873, 0.000521115353897267, 0.000425488904726051, -0.00212744452363026, -0.00194208225905523, -0.00173705117965754, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0452812960900435, -0.0113287063442981, -0.00801060507812422, -0.0014118924666501, -0.0164047080299144, -0.0133943880175427, 0.0145226026488074, 0.0118576554089232, 0.00838462854862291, 0.00894802256177149, -0.0142846454190328, -0.0123708658169354, 0.014536160727703, 0.0125886844636845, 0.0102786178229764, -0.00939454064454066, -0.00813591085505765, -0.00664294339588734, -0.00469727032227034, -0.0083606133738001, -0.00245778931055953, -0.00219831358911339, 0.00830884437218266, 0.00743165633226679, 0.00643600317593851, -0.00965400476390776, -0.00863480436288184, -0.00747795993496436, -0.00610572871921293, 0.00650269929073342, 0.00581619106052785, 0.00503696921168106, 0.00411266813957581, 0.00290809553026393, -0.0352796762358899, 0.0191470007126724, 0.017478740331497, -0.00788016479265674, -0.00719357335632687, -0.00643412761035128, 0.000951422114639395, 0.000868525589828766, 0.000776832903622087, 0.000672757029032357, 0.00221090520312706, 0.00201827108709707, 0.00180519653910857, 0.00156334606169176, 0.00127646671417816, -0.00212744452363025, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617076958, 0.0679219441350653, -0.00435719474780703, -0.00308100195312472, 0.0705946233325039, -0.0328094160598287, -0.0267887760350855, 0.0126283501293977, 0.03608851646194, -0.00729098134662863, 0.0298267418725716, 0.0151249186789758, 0.0130985638061668, -0.0325436434202305, -0.0229226791726792, -0.0248527774227189, 0.0248015873015873, 0.0169226945785199, 0.0164744996218006, 0.0142797017797018, 0.0, 0.0245778931055954, 0.0219831358911339, -0.0363511941282991, -0.00743165633226679, -0.0345935170706696, 0.0362025178646541, 0.0, 0.0130864298861876, 0.0335815079556711, -0.0232239260383337, 0.00166176887443654, -0.00359783515120075, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0226083734055987, -0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193681, 0.0, 0.0333014729371016, 0.0270779480866287, 0.00703505727761299, -0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.00196524906944629, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573523, 0.00377344134083692, 0.00217859737390364, -0.0215670136718729, 0.0, 0.0984282481794863, -0.0312535720409329, -0.0852413633734344, -0.0180442582309701, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0116431678277039, 0.0, 0.0236742424242425, -0.00138070985681771, -0.0202922077922078, -0.0335199527228374, -0.000797153207506548, 0.00394570707070708, 0.0, 0.0, 0.0, 0.0363511941282991, 0.024152883079867, -0.00724050357293084, -0.0603375297744236, 0.0, -0.039259289658563, 0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064561, 0.0, -0.0555024548951693, 0.0, 0.0164151336477636, -0.00680782247561684, 0.0, 0.0427258096992147, 0.00694820471863017, -0.0108311792346515, -0.00393049813889261, 0.00607967912880133};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0301875307266957, 0.0610007264692974, -0.00308100195312476, 0.0, 0.0218729440398858, 0.0178591840233903, 0.0757701007763862, -0.0412440188136457, -0.00729098134662866, 0.0, 0.0, 0.0, 0.0520698294723688, -0.0127765752765753, 0.00184094647575698, -0.00901875901875901, 0.0286384062098029, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0402250198496157, 0.014391340604803, -0.0137095932141013, 0.00407048581280863, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0370016365967796, -0.030086608985143, 0.014070114555226, -0.00340391123780845, 0.0, -0.0427258096992148, 0.0243187165152054, 0.0, -0.00982624534723141, 0.00607967912880137};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.00377344134083707, -0.0196073763651313, 0.00924300585937421, 0.0, -0.010936472019943, 0.102690308134494, 0.0094712625970483, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965864, 0.0465726713108155, 0.00650872868404603, 0.0214195526695526, -0.00782402252196704, -0.00450937950937952, -0.0289638426440052, -0.0263060558477138, 0.000563672438672408, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, -0.0431740218144092, -0.00249265331165474, -0.0605484764655282, 0.0, 0.0299118397398575, -0.00431740218144093, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, -0.0451299134777144, -0.0281402291104519, 0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, -0.0150937653633478, 0.0130715842434209, 0.00924300585937411, 0.0, -0.0109364720199429, -0.00892959201169512, 0.00947126259704831, 0.123732056440937, -0.060150596109686, 0.0, 0.0, 0.0, -0.00650872868404609, 0.0574945887445887, -0.0266937238984759, 0.00676406926406926, 0.0126920209338899, 0.00637722566005184, 0.000563672438672477, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0431740218144092, 0.0199412264932383, -0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0451299134777144, -0.0375203054806026, 0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769577, 0.0301875307266957, 0.0174287789912277, 0.0585390371093694, 0.0, 0.0218729440398859, 0.0178591840233903, -0.0189425251940965, 0.0103110047034114, 0.0838462854862291, 0.0, 0.0, 0.0, 0.0, 0.00526094276094274, 0.0533874477969518, 0.0, -0.00455611007883225, 0.0308232573569173, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034897146363167, 0.0284934006896603, 0.0, 0.0, -0.0302218152700865, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437736897273697, -0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769581, -0.0679219441350654, -0.00435719474780698, -0.00308100195312479, 0.0705946233325039, 0.0328094160598288, 0.0267887760350854, 0.0126283501293977, 0.0360885164619401, -0.00729098134662864, -0.0298267418725716, 0.0151249186789758, 0.0130985638061669, 0.0325436434202305, 0.0229226791726792, 0.024852777422719, 0.0248015873015874, 0.0169226945785198, 0.0164744996218006, 0.0142797017797018, 0.0, -0.0245778931055953, -0.0219831358911338, -0.036351194128299, -0.00743165633226677, -0.0345935170706695, -0.0362025178646541, 0.0, -0.0130864298861876, -0.0335815079556711, -0.0232239260383337, 0.00166176887443655, -0.00359783515120075, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, -0.0226083734055987, 0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.0090822198919368, 0.0, -0.0333014729371016, -0.0270779480866286, -0.00703505727761296, 0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598855, 0.00196524906944629, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573523, -0.00377344134083697, 0.00217859737390366, -0.0215670136718729, 0.0, -0.0984282481794862, 0.0312535720409329, -0.0852413633734344, -0.0180442582309701, 0.0309866707231716, 0.0, 0.0453747560369275, -0.0116431678277039, 0.0, -0.0236742424242424, 0.00138070985681773, -0.0202922077922079, -0.0335199527228374, -0.000797153207506549, 0.00394570707070709, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.00724050357293081, 0.0603375297744236, 0.0, 0.0392592896585629, -0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064561, 0.0, 0.0555024548951693, 0.0, -0.0164151336477636, 0.00680782247561685, 0.0, 0.0427258096992147, 0.00694820471863019, -0.0108311792346515, -0.00393049813889259, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266958, 0.0610007264692974, -0.00308100195312485, 0.0, -0.021872944039886, -0.0178591840233903, 0.0757701007763861, -0.0412440188136456, -0.00729098134662859, 0.0, 0.0, 0.0, -0.0520698294723688, 0.0127765752765752, -0.00184094647575697, -0.00901875901875897, 0.0286384062098028, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0402250198496157, -0.0143913406048031, 0.0137095932141014, -0.00407048581280863, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0370016365967795, 0.0300866089851429, -0.014070114555226, 0.00340391123780843, 0.0, -0.0427258096992147, 0.0243187165152053, 0.0, -0.00982624534723143, 0.00607967912880138};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573516, -0.00377344134083713, -0.0196073763651312, 0.00924300585937421, 0.0, 0.0109364720199428, -0.102690308134494, 0.00947126259704829, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965856, 0.0465726713108155, -0.00650872868404608, -0.0214195526695527, 0.00782402252196704, -0.00450937950937948, -0.0289638426440052, -0.0263060558477138, 0.000563672438672415, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, 0.0431740218144092, 0.00249265331165474, 0.0605484764655282, 0.0, 0.0299118397398575, -0.00431740218144093, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, 0.0451299134777144, 0.0281402291104519, -0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0150937653633479, 0.0130715842434208, 0.00924300585937418, 0.0, 0.0109364720199429, 0.00892959201169517, 0.00947126259704834, 0.123732056440937, -0.0601505961096861, 0.0, 0.0, 0.0, 0.00650872868404608, -0.0574945887445887, 0.0266937238984759, 0.00676406926406923, 0.0126920209338899, 0.00637722566005182, 0.000563672438672456, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0431740218144092, -0.0199412264932384, 0.0142467003448302, 0.0, -0.0448677596097862, 0.0215870109072046, -0.0616900220936372, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0451299134777144, 0.0375203054806026, -0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266958, 0.0174287789912279, 0.0585390371093693, 0.0, -0.0218729440398857, -0.0178591840233903, -0.0189425251940965, 0.0103110047034115, 0.083846285486229, 0.0, 0.0, 0.0, 0.0, -0.00526094276094277, -0.0533874477969517, 0.0, -0.00455611007883225, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0348971463631671, -0.0284934006896603, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437736897273697, 0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769573, -0.0377344134083695, -0.0566435317214904, -0.00308100195312477, 0.0423567739995023, 0.0546823600997147, 0.0446479600584757, 0.0378850503881931, 0.00515550235170579, -0.00729098134662861, 0.0417574386216002, -0.00504163955965862, 0.0295930515620807, -0.0247331689993752, 0.0101461038961039, 0.0266937238984759, -0.0202922077922078, 0.00216957622801539, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, -0.0245778931055954, -0.00219831358911336, -0.00519302773261414, -0.0130053985814669, -0.0168945083368385, 0.00402250198496157, -0.0158304746652834, -0.026796023100289, -0.0295110221428625, 0.00464478520766675, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, -0.0226083734055987, -0.0367664434877216, 0.0, -0.0047768907440582, -0.00776832903622085, -0.00908221989193678, 0.0, 0.00370016365967795, 0.00601732179702857, 0.007035057277613, 0.00680782247561685, 0.0, 0.00427258096992149, 0.0069482047186301, 0.00812338442598857, 0.00786099627778516, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573523, 0.0, -0.00435719474780704, -0.0215670136718729, -0.127070321998507, 0.0, 0.0, 0.0284137877911449, 0.0360885164619399, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0422064833754265, 0.0, 0.0, 0.0, -0.0202922077922078, -0.00618329224984381, 0.00159430641501296, 0.00394570707070708, 0.0836061337380012, 0.0, 0.0, -0.0103860554652283, 0.024152883079867, 0.043443021437585, 0.0, 0.0, 0.0, 0.0, 0.00464478520766673, -0.0108014976838374, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, 0.0769064574585865, 0.0, 0.0, 0.0, 0.0, -0.00955378148811641, -0.0155366580724417, -0.0181644397838736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00427258096992146, 0.00694820471863015, 0.00812338442598859, 0.00786099627778516, 0.00607967912880135};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769577, 0.0377344134083696, -0.0566435317214905, -0.00308100195312481, 0.0423567739995022, -0.0546823600997145, -0.0446479600584757, 0.0378850503881931, 0.00515550235170578, -0.0072909813466285, -0.0417574386216002, -0.00504163955965861, 0.0295930515620806, 0.0247331689993752, -0.0101461038961039, -0.0266937238984759, -0.0202922077922078, 0.00216957622801541, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, 0.0245778931055953, 0.00219831358911336, -0.00519302773261412, -0.0130053985814669, -0.0168945083368386, -0.00402250198496156, 0.0158304746652834, 0.026796023100289, 0.0295110221428625, 0.00464478520766677, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, 0.0226083734055987, 0.0367664434877216, 0.0, -0.00477689074405817, -0.00776832903622087, -0.0090822198919368, 0.0, -0.00370016365967795, -0.00601732179702859, -0.00703505727761297, -0.00680782247561685, 0.0, 0.0042725809699215, 0.00694820471863008, 0.00812338442598857, 0.00786099627778517, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, -0.0188672067041848, 0.00653579212171051, 0.00924300585937421, 0.0141189246665008, 0.0, -0.111619900146189, -0.00315708753234941, -0.05413277469291, -0.060150596109686, -0.00894802256177145, -0.00252081977982928, -0.0276525235907967, 0.000650872868404633, 0.0360750360750361, -0.0188697013765088, 0.00112734487734487, 0.0374251899332651, 0.0199288301876619, 0.000563672438672408, 0.0, 0.0, 0.0593544669060614, 0.0, 0.0167212267476003, 0.00321800158796919, 0.0, -0.0043174021814409, 0.0224338798048931, 0.0463017761206981, 0.0, -0.00747795993496438, 0.018708742786244, 0.0431830154655461, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0620433733855302, 0.0, 0.0, 0.017478740331497, 0.0363288795677472, 0.0, 0.0, -0.00451299134777145, -0.00938007637015065, -0.0119136893323295, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573523, 0.0188672067041847, 0.00653579212171058, 0.00924300585937418, 0.0141189246665008, 0.0, 0.111619900146189, -0.00315708753234937, -0.05413277469291, -0.0601505961096861, 0.0089480225617715, -0.0025208197798293, -0.0276525235907967, -0.000650872868404624, -0.0360750360750361, 0.0188697013765088, 0.00112734487734488, 0.0374251899332651, 0.019928830187662, 0.000563672438672449, 0.0, 0.0, -0.0593544669060614, 0.0, 0.0167212267476003, 0.00321800158796924, 0.0, 0.00431740218144091, -0.0224338798048931, -0.0463017761206981, 0.0, -0.00747795993496438, 0.0187087427862439, 0.0431830154655461, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0620433733855302, 0.0, 0.0, 0.0174787403314969, 0.0363288795677472, 0.0, 0.0, 0.00451299134777145, 0.00938007637015064, 0.0119136893323295, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.0206351152291861, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0, -0.0348575579824557, 0.0585390371093694, -0.0282378493330015, 0.0, 0.0, 0.00631417506469885, -0.0206220094068228, 0.0838462854862291, 0.0, 0.0, -0.00679184789949388, 0.0, 0.0, 0.0, 0.0, 0.00151870335961077, -0.0616465147138343, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0450520222315696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0100739384233621, -0.0329013451166065, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0565115904387179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769577, -0.0377344134083697, -0.0217859737390348, -0.05237703320312, 0.0423567739995024, 0.0546823600997146, 0.0446479600584757, 0.0, 0.0257775117585286, 0.0291639253865145, 0.0417574386216002, 0.0285692908380655, -0.00921750786359889, 0.0273366604729936, -0.00789141414141415, -0.0248527774227189, 0.0187890812890813, -0.0034713219648246, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, -0.00491557862111906, -0.0241814494802472, -0.0197335053839338, -0.00928957041533347, -0.00241350119097692, -0.0394205194526234, -0.0158304746652834, -0.000623163327913719, 0.00712335017241506, -0.0325134964536671, -0.0141250354327105, -0.00215870109072046, 0.00411266813957582, 0.00540074884191869, 0.0, -0.0510586685671264, 0.00466099742173251, -0.0405265617908061, -0.0143871467126537, 0.00367664434877213, -0.0114170653756726, -0.00564541633388696, -0.00155366580724414, 0.00100913554354854, 0.010317557614593, 0.00571843474677502, 0.00240692871881142, 0.000260557676948619, -0.000850977809452114, 0.0127646671417816, 0.00737991258440984, 0.00347410235931509, 0.000902598269554295, -0.000491312267361566, -0.000868525589828747};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0, -0.0217859737390348, 0.00308100195312479, -0.127070321998507, 0.0, 0.0, 0.0473563129852413, 0.0257775117585286, 0.0127592173566001, 0.0, -0.0352914769176103, 0.0509388592462045, 0.0, 0.0, 0.0, 0.00225468975468974, -0.00943765659186684, -0.0143487577351166, -0.0129644660894661, 0.0836061337380013, 0.0, 0.0, 0.0477758551400502, 0.00928957041533349, -0.0144810071458617, 0.0, 0.0, 0.0, 0.0, -0.0325134964536671, -0.0141250354327105, -0.00215870109072046, 0.00411266813957582, 0.00540074884191877, 0.0, 0.0765880028506897, -0.00699149613259876, 0.0, 0.0, 0.0, -0.0228341307513453, -0.011290832667774, -0.00310733161448838, 0.00201827108709705, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, 0.00737991258440982, 0.00347410235931506, 0.000902598269554268, -0.000491312267361585, -0.00086852558982881};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769581, 0.0377344134083697, -0.0217859737390347, -0.0523770332031201, 0.0423567739995024, -0.0546823600997146, -0.0446479600584757, 0.0, 0.0257775117585285, 0.0291639253865145, -0.0417574386216002, 0.0285692908380655, -0.00921750786359894, -0.0273366604729937, 0.00789141414141414, 0.0248527774227189, 0.0187890812890813, -0.00347132196482457, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, 0.00491557862111903, 0.0241814494802472, -0.0197335053839338, -0.00928957041533349, -0.00241350119097694, 0.0394205194526234, 0.0158304746652834, 0.000623163327913702, -0.00712335017241507, -0.0325134964536671, -0.0141250354327105, -0.00215870109072045, 0.00411266813957581, 0.00540074884191867, 0.0, -0.0510586685671264, 0.0046609974217325, 0.0405265617908061, 0.0143871467126537, -0.00367664434877215, -0.0114170653756726, -0.00564541633388696, -0.00155366580724416, 0.00100913554354855, -0.010317557614593, -0.00571843474677502, -0.00240692871881143, -0.000260557676948624, 0.000850977809452106, 0.0127646671417816, 0.00737991258440984, 0.00347410235931506, 0.000902598269554285, -0.000491312267361562, -0.000868525589828736};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573518, -0.0188672067041849, 0.0108929868695176, 0.00308100195312463, 0.0141189246665008, -0.109364720199429, 0.0223239800292377, -0.0789271883087356, -0.0128887558792642, 0.0127592173566001, -0.00894802256177147, -0.0277290175781224, 0.00145539597846298, -0.0058578558156415, 0.0383297258297259, -0.0124263887113595, 0.0191648629148628, 0.0348216984596467, 0.00717437886755833, -0.0129644660894661, 0.0, 0.0589869434534289, -0.00659494076734012, 0.00727023882565972, 0.0148633126645335, -0.0040225019849616, 0.0506835250105158, -0.00431740218144091, -0.00810112326287806, 0.00356167508620759, 0.0650269929073342, -0.00166176887443653, -0.0115130724838425, -0.00205633406978792, 0.00540074884191875, 0.0, 0.0, 0.0, 0.0607898426862092, -0.0123318400394175, 0.0013787416307896, 0.0399597288148542, 0.00303983956440064, -0.00427258096992151, 0.00100913554354853, -0.0154763364218896, -0.00302740663064563, 0.00090259826955432, 0.000781673030845895, -0.000425488904726053, -0.031911667854454, -0.00776832903622088, 0.000868525589828737, 0.00180519653910857, 0.000245656133680776, -0.000868525589828788};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0188672067041847, 0.0108929868695174, 0.00308100195312465, 0.0141189246665008, 0.109364720199429, -0.0223239800292378, -0.0789271883087356, -0.0128887558792643, 0.0127592173566001, 0.00894802256177148, -0.0277290175781224, 0.00145539597846297, 0.00585785581564141, -0.0383297258297259, 0.0124263887113595, 0.019164862914863, 0.0348216984596467, 0.00717437886755831, -0.0129644660894661, 0.0, -0.0589869434534289, 0.00659494076734012, 0.00727023882565982, 0.0148633126645335, -0.00402250198496154, -0.0506835250105158, 0.00431740218144091, 0.00810112326287806, -0.00356167508620755, 0.0650269929073342, -0.00166176887443652, -0.0115130724838425, -0.0020563340697879, 0.00540074884191873, 0.0, 0.0, 0.0, -0.0607898426862092, 0.0123318400394175, -0.00137874163078958, 0.0399597288148542, 0.00303983956440069, -0.00427258096992147, 0.00100913554354853, 0.0154763364218896, 0.00302740663064561, -0.000902598269554305, -0.000781673030845883, 0.000425488904726056, -0.031911667854454, -0.00776832903622088, 0.000868525589828765, 0.00180519653910858, 0.00024565613368079, -0.000868525589828768};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617076958, 0.0, 0.0435719474780696, -0.05237703320312, -0.0282378493330015, 0.0, 0.0, 0.0631417506469885, -0.0515550235170571, 0.0291639253865144, 0.0, -0.00672218607954483, 0.000970263985642005, 0.0, 0.0, 0.0, -0.0601250601250601, -0.0125835421224891, 0.0286975154702333, -0.015031265031265, 0.0, 0.0, 0.0, -0.0436214329539588, 0.0111474844984002, -0.00160900079398464, 0.0, 0.0, 0.0, 0.0, -0.0650269929073342, 0.031573608614294, -0.00287826812096058, -0.00822533627915168, 0.00540074884191872, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0532796384198057, 0.018239037386404, -0.00466099742173252, 0.000672757029032361, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0425488904726053, -0.00388416451811041, -0.00347410235931508, 0.00120346435940574, 0.000982624534723166, -0.000868525589828754};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, -0.188672067041848, -0.108929868695174, -0.0770250488281179, -0.0705946233325039, -0.0546823600997146, -0.0446479600584757, -0.0315708753234942, -0.0257775117585285, -0.0182274533665715, 0.0894802256177148, -0.0151249186789758, -0.0130985638061669, 0.0585785581564149, -0.028183621933622, 0.0690354928408859, 0.074404761904762, 0.00976309302606919, 0.039857660375324, 0.0597492784992785, 0.0, 0.0737336793167861, 0.0659494076734016, 0.0363511941282991, 0.00743165633226676, 0.0345935170706695, -0.0120675059548847, 0.0431740218144092, 0.0155790831978425, -0.0254405363300538, -0.0232239260383337, 0.0465295284842228, 0.0251848460584054, -0.0146881004984851, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, 0.0678251202167962, -0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.00908221989193678, 0.0, -0.0111004909790339, -0.00902598269554281, -0.00234501909253764, 0.00340391123780841, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598859, 0.00196524906944629, 0.0060796791288014};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.0770250488281177, -0.0705946233325038, 0.0546823600997147, 0.0446479600584758, -0.0315708753234942, -0.0257775117585286, -0.0182274533665716, -0.0894802256177148, -0.0151249186789759, -0.0130985638061668, -0.058578558156415, 0.028183621933622, -0.0690354928408859, 0.0744047619047619, 0.00976309302606916, 0.0398576603753239, 0.0597492784992785, 0.0, -0.0737336793167862, -0.0659494076734017, 0.036351194128299, 0.00743165633226679, 0.0345935170706696, 0.0120675059548846, -0.0431740218144092, -0.0155790831978425, 0.0254405363300538, -0.0232239260383337, 0.0465295284842228, 0.0251848460584053, -0.014688100498485, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, -0.0678251202167963, 0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.00908221989193679, 0.0, 0.0111004909790338, 0.00902598269554289, 0.00234501909253761, -0.00340391123780841, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598856, 0.00196524906944628, 0.00607967912880138};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.217859737390348, -0.0770250488281177, 0.0, 0.0, 0.0, -0.0947126259704828, 0.0515550235170571, -0.0182274533665715, 0.0, -0.0907495120738551, 0.0232863356554078, 0.0, 0.0, 0.0, -0.0946969696969696, -0.0227805503941613, -0.0797153207506479, 0.0597492784992785, 0.0, 0.0, 0.0, -0.0727023882565981, -0.0483057661597341, 0.0144810071458617, 0.0, 0.0, 0.0, 0.0, 0.0464478520766673, -0.0781031370985168, 0.0431740218144092, 0.0293762009969701, -0.0328199352701214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0668764704168149, 0.0310733161448835, -0.0060548132612912, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0427258096992147, 0.00694820471863011, -0.0108311792346515, -0.0039304981388926, 0.00607967912880135};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.0, 0.231075146484353, 0.0, 0.0, 0.0, 0.0, 0.0, -0.109364720199429, 0.0, 0.0100832791193174, -0.0931453426216311, 0.0, 0.0, 0.0, -0.00450937950937958, -0.104139658944738, 0.0, -0.0924422799422799, 0.0, 0.0, 0.0, 0.0, -0.0668849069904009, -0.0579240285834467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.0647610327216138, 0.0, 0.0835038859404355, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0699149613259879, 0.0242192530451648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, 0.0270779480866287, 0.0, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923465, 0.00609788120679257, 0.00352061335622799, 0.00248944957812477, 0.00705946233325034, 0.00546823600997147, 0.00446479600584761, 0.00315708753234942, 0.00257775117585288, 0.00182274533665717, -0.00298267418725715, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601733, -0.00138070985681771, -0.0011273448773449, -0.000976309302606944, -0.000797153207506486, -0.000563672438672447, 0.00278687112460007, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.0018579140830667, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.0012463266558274, 0.00101762145320216, 0.000928957041533369, 0.000830884437218256, 0.00071956703024016, 0.000587524019939406, 0.000415442218609138, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363027, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.91485421551272, 1.29756443747036, 3.74574588632197, -1.05945692672796, -8.09173593712687, 5.01426536422406, -0.383824736789365, 1.80936716113938, -1.10800657553489, 0.313391585264003, 0.0, 12.7134831207354, 1.01946290306868, 8.20651806648289, -0.631738055305789, 0.04835737145617, -2.84282124887606, -0.227958835180083, 0.139595707137603, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494798, 1.34011878852097, 1.89521416591737, 2.5331140255951, 1.96214168703486, 2.74642624930237, -0.566421515598876, 3.17129986868837, -1.82198870938952, 0.0, 0.0, 11.1699829238239, -1.06581410364015e-14, 8.65223156827827, -0.865042958313609, 1.08801856413265e-14, -2.49768411251822, -0.998865569685867, 0.441440386136639, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880925, 0.0, 1.02140518265514e-14, 4.45964044034302, 0.0, -0.858258202906989, 2.67027285925187, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 7.03562363973514, 4.06201920231799, -0.820651806648291, 1.06581410364015e-14, -6.79705818718657, -2.08116553882675, 5.8864250611046, -1.20156148406979, 0.24275207811381, 1.06581410364015e-14, -2.48689957516035e-14, 1.02140518265514e-14, 14.8323969741913, 0.856348838577658, 0.262202212042542, 5.13809303146606, -0.741619848709565, 0.151382517704904, -0.0305838870920609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508101, 1.31624465810883, 4.91295663090392, -1.4113063856887, 0.0, 0.0, 0.0, 0.0, 13.4039795085888, 2.01017818278146, 0.0, 5.80409338312193, -1.54743588659734, 0.341938252770115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747033, 0.749149177264371, 2.75458800949269, 1.22124532708767e-14, 1.4210854715202e-14, 5.75737105184055, 0.0, 3.3240197266047, 2.06838446274243, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.33226762955019e-14, -2.1316282072803e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119207, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {0.93808315196469, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03805852802452e-14, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431071, 0.0, 9.38083151964686, 1.89521416591739, 1.24344978758018e-14, 0.0, -1.24344978758018e-14, -3.39852909359329, -2.77488738510234, -0.560611910581393, 1.77635683940025e-14, 2.8421709430404e-14, 0.0, 0.0, -2.1316282072803e-14, 1.50990331349021e-14, 17.7988763690296, 0.428174419288831, 0.349602949390069, 0.0706304617818787, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452875, 4.23782770691181, 0.0, 0.0, -1.95399252334028e-14, 3.79967103839268, -3.54562104171166, -4.07409060843206, 0.0, 0.0, 2.1316282072803e-14, 0.0, 2.14828155264968e-14, 1.77635683940025e-14, 1.46549439250521e-14, 16.7549743857359, 1.11676565710086, 0.98709071141532, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.28705943072782e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.99840144432528e-14, -1.13242748511766e-14, 1.15463194561016e-14, 0.0},
      {-1.32664991614216, 0.0, 1.73008591662711, -3.18072425757421, 0.0, 0.0, 1.4210854715202e-14, 0.0, 7.67649473578738, -2.38836465270398, -1.06581410364015e-14, 0.0, 4.2632564145606e-14, 0.0, -3.19744231092045e-14, -3.19744231092045e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662072, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {1.6248076809272, 0.0, 1.4210854715202e-14, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.82076576038526e-14, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069939, 0.997445717412047, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.36277028773848, -2.89087233497829, -0.393397896234719, 0.556348640264175, 2.33666428910958, 9.02784807228867, -0.732969916135149, -3.93352933905728, -1.19859611757306, 0.309047252182628, 1.64018416088946, 0.655588223176224, 0.0892142571199703, -0.126168012376113, 13.0996183150502, 11.55277744383, -0.234843597212095, -2.44096975264614, -0.907332870306509, 0.0736662483163242, 0.810328731479522, 0.395334573318414, 0.120463442338384, -0.0310604175145466, -0.311895674167857, -0.164844710568314, -0.0658890955530749, -0.00896637020657787, 0.0126803623514049, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940279, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275053, 5.59815020469135, 0.263899331455872, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818858, 9.14446135479764, 0.066496381160809, -2.36108976914459, -3.33842298506509, -0.023035022137996, 0.817905488277898, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.36088943928029, 0.555625639776449, 0.595437196138647, 0.0, -0.125015768949707, -0.192474367616162, -0.206265495285709, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066015, 2.99085908983324, -1.24403337882029, 0.950146187582622, 5.74064456311311, -0.721110255092795, -0.169967317119746, -1.17961073303081, 0.490653381462657, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.7817446699566, -1.30185581821822, 0.163532434528627, -3.22682211353226, 0.0385449644663671, 0.267510569439609, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663638, 0.0216558414515706, -3.5732138395088, -0.581087203147983, 0.130841432732457, -0.016435628072264, 1.37533064807501, 0.324307824721451, -0.00387391468765164, -0.0268858238268332, 0.0111830284386736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637252, 1.66904592079258, 0.963624111659448, 1.36277028773848, 0.867360833110894, 2.28430636201792, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707465, 2.41867732448956, 2.04415543160772, 2.68821895760393, -0.527798662911731, 7.07977053255618, -1.76652739792481, 0.182834820066031, -3.12574097035514, -1.01990506872272, 0.904016610326397, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.86447112137561, -1.66605356688628, 0.315075748468086, 0.0, 0.992281903807271, 0.735567892896452, 0.18190906819316, -0.14700472648997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458432, -0.430945803685661, 3.04724700110021, 0.775791113542723, -0.120185042515454, 5.29905651979671, 0.0346944333244444, -1.52970585407782, 0.901387818865999, -1.04360964314765e-14, 1.06581410364015e-14, 4.5156107826894, 0.0, -0.699555414372449, 6.36462844462226, 0.0, 0.201944253400486, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 1.4210854715202e-14, 0.0, 1.11022302462516e-14, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980282, 0.894874292847889, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, -1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14},
      {1.62882203585589, 0.772618130456562, 3.86595114186569, -1.05140010313426, 9.1544290607646, 3.3588901228148, -0.304724700110031, 3.87851223317101, -1.52475169285615, 0.414677792940102, 0.0, -9.46260092820841, -2.07602937339135, 7.32969916135159, -0.761724681099374, 0.0691050664139912, 0.564240504518065, -0.879563899362182, 0.345781182036202, -0.0940400840863373, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584719, 9.059750638547, -0.736662483163207, 0.076556210932115, -0.00694532049720431, -3.48709964663733, -0.0567083043941596, 0.088399497979587, -0.034752316375144, 0.00945138406569224, 0.0, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.52100554373646e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647577, 2.03602754481991, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059443, 0.655663160391216, 3.61359041872289, -1.70346285967311, 0.0, 2.76420265655949, -9.08783875864325, 1.78428514239954, 5.63152770643901, -0.746494073225321, -0.618094504365241, 2.03210252328837, -2.1549427706255, 0.764033484562605, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689787, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392897, -0.124241670058189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, -1.06581410364015e-14, 0.0, 0.0},
      {1.32992762321608, 0.630840061880541, 0.72843135908467, 2.57539376818857, 0.917928424547676, 0.711024300256726, 2.23926008187654, -0.205255035576785, 2.58567482211403, 0.761811750275049, 1.77635683940025e-14, 0.0, 5.34294273196308, 0.0, 4.13862564412655, 2.68954640486928, 1.24344978758018e-14, -1.19471831485578, 3.10562068169857, -2.32269806558127, 0.0, 0.0, 1.35447209004269e-14, 0.0, 1.46549439250521e-14, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403077, -1.51261363209512, 0.763985254692606, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, -1.59872115546023e-14, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313517, -0.105140010313417, 3.27118942773249, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175128, 4.25171145123353, 1.4210854715202e-14, 0.0, -2.50910403565285e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, -6.78263087840207, 3.68560354207934, -0.814411017927949, -2.1316282072803e-14, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219803, -2.1316282072803e-14, 1.06581410364015e-14, 0.0, -7.57008074256672, -2.27270584034422, -0.60665694841585, 6.99294104721298, -1.36261453366201, 0.329650402328141, -0.0728431359084754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084513, 0.22841553125065, 0.0609713174047695, 5.40219154319687, -0.702817019232745, 0.136947913395213, -0.0331311120155262, 0.00732101061700652, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 3.82426463519459, 2.20794021658197, 0.892142571199754, 1.59872115546023e-14, -2.4630604269215, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727937, 0.0, -1.19904086659517e-14, 1.4210854715202e-14, 3.22490309931942, -7.63378455726036, -4.04762275910193, 1.11713920350151, 6.61105135360479, -2.33689608954554, 0.591817792331161, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108411, 0.721929233499938, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297049, -0.096237183808074, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 1.12548859121375e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, -1.46593983227031, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945722, -5.20357020296094, 0.476969600708472, 4.00571020990214, 0.590096844352075, 0.0, 0.0, 1.98729921407903e-14, 1.22124532708767e-14, 6.41153127835567, -6.2499410609466, 0.0, 2.7762744821073, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613679, -2.34333096254029, 0.591780433634507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199775, 0.705300630647563, 0.407205508964006, 2.53385243517952, 0.0, 0.0, 3.47717900165118, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 1.33226762955019e-14, -2.43000064514831e-14, 0.0, 0.0, 8.67405085085773, 1.86517468137026e-14, 0.0, 5.00796559370721, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.72843135908469, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237767, 0.0, 0.0, 2.04281036531029e-14, 0.0, -1.55431223447522e-14, -1.59872115546023e-14, 0.0, 1.23234755733392e-14, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125634, -3.29140294302191, -1.24344978758018e-14, 0.0, 1.77635683940025e-14, 13.4907375632321, 1.83585684909537, 1.29814682728312, -1.4210854715202e-14, 0.0, -2.8421709430404e-14, 0.0, -1.59872115546023e-14, 0.0, -3.53270434653116, -3.05941170815571, -0.416333199893259, -0.294392028877606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839439, 0.307482445914334, 0.0418430609640565, 0.0295875121532903, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {-2.6598552464322, 1.84297022087776e-14, 5.0990195135928, -2.06031501455088, 1.50990331349021e-14, 0.0, 0.0, -1.23153021346074, 9.049861877399, 3.04724700110021, 0.0, 0.0, -2.48689957516035e-14, 1.15463194561016e-14, -2.8421709430404e-14, 3.5527136788005e-14, 3.86988371918333, -3.81689227863023, -5.39683034546922, -1.36674464685443, 0.0, 0.0, 0.0, 0.0, 0.0, 1.46549439250521e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542066, 0.962572311333256, 0.22225025591058, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.82076576038526e-14, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0},
      {2.97380857066589, 1.4210854715202e-14, -0.814411017927924, 5.75875553449895, 0.0, 1.55431223447522e-14, -1.06581410364015e-14, 1.37689263682152, -2.89087233497829, 1.7034628596731, -1.4210854715202e-14, 3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 8.01441409794463, -3.47218947830362, -5.19371076584693, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.46549439250521e-14, 0.0, 0.0, 0.0},
      {-1.03015750727543, 0.0, 0.940400840863422, -2.9258407710754, -1.08801856413265e-14, 1.06581410364015e-14, 0.0, 0.0, 4.63623866886821, -3.80284633026899, -1.06581410364015e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 2.17603712826531e-14, 0.0, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493486, 0.0, 0.0, 3.19744231092045e-14, 0.0, -2.66453525910038e-14, -2.66453525910038e-14, 0.0, 2.1094237467878e-14, 1.06581410364015e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 1.44913767461894, 4.18330013267039, -0.591607978309966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385683, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.06581410364015e-14, -1.0769163338864e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, -2.1316282072803e-14, 8.87411967464942, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.24344978758018e-14, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -1.00000000000001, 1.30930734141595, 7.09929573971953, -0.414039335605414, -2.04939015319192, -0.478091443733756, 0.169030850945708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463868, 3.17542648054294, 9.07114735222144, 2.30926389122033e-14, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, -2.57571741713036e-14, -1.77635683940025e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033672, 4.38178046004134, -0.774596669241498, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818038, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.15463194561016e-14, 0.0, 1.15463194561016e-14, -1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 0.547722557505165, 1.58113883008419, 2.45967477524978, 0.0, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824849, -1.20948631362952, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.77635683940025e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.2609903369994, -1.24344978758018e-14, 3.83405790253616, 1.73194791841524e-14, 0.0, 10.5830052442584, 1.24344978758018e-14, 1.24344978758018e-14, 5.18459255872629, 0.0, 0.0, -1.99840144432528e-14, 1.59872115546023e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, -1.68753899743024e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824835, 0.0755928946018458, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 0.0, 1.46059348668042, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878696, -0.698297248755178, -1.06581410364015e-14, -3.01980662698043e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, -2.48689957516035e-14, -6.26099033699944, 2.21359436211788, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, -1.82076576038526e-14, 1.55431223447522e-14, -2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157676649773, 0.0, 2.30926389122033e-14, -4.69574275274956, 1.46549439250521e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 1.95399252334028e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.50990331349021e-14, 1.97619698383278e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34336985979644e-14, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105602, 2.39356776939084, 6.30376871403132, -0.908295106229245, -2.78313372537744, -0.52440442408507, 0.37080992435478, 1.23603308118261, 9.4017475579201, -0.301561193523235, -2.42752078113805, -0.79420020665698, 0.114434427054264, 0.84091786587209, 0.350641890608836, 0.0660687472643509, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047609, 2.74642624930235, -0.792824967172094, 2.24244764232555, 2.1408720964442, -0.331662479035521, 6.49923072370876, 0.0957427107756468, -1.87616630392937, -2.15580611373102, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932526, 0.590936840285284, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542155127, 1.29756443747036, 3.74574588632199, -1.05945692672796, 0.404586796856352, 5.01426536422406, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264004, 0.0, 2.82521847127452, -0.050973145153439, 8.20651806648289, -0.631738055305783, 0.0483573714561669, -2.84282124887605, -0.227958835180075, 0.139595707137607, -0.0394836284566216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715534, 1.160576914948, 1.34011878852096, 1.89521416591738, 0.361873432227861, 1.96214168703487, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313582, 0.0, -2.49768411251823, -0.998865569685865, 0.441440386136654, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.0050890913907, -0.193429485824662, 3.55615782880924, -8.46157280212811, 1.24344978758018e-14, 4.45964044034301, 0.0, -0.858258202906992, 2.67027285925186, -1.24344978758018e-14, 2.51465515077598e-14, 12.4373429638327, -1.24344978758018e-14, -1.84297022087776e-14, 8.42792824422441, 0.0, 0.0, -1.62195554683795, -2.29379153190451, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 0.335029697130244, 4.06201920231797, -0.820651806648291, 1.32255317808472e-14, 1.69926454679663, -0.0991031208965123, 5.8864250611046, -1.20156148406979, 0.242752078113808, 0.0, -1.59872115546023e-14, 0.0, 4.94413232473044, -0.214087209644422, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704899, -0.0305838870920683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905752, 2.07610309995255, 1.46802658041886, 1.28785870856518e-14, 0.868496237346889, 0.709124208342335, 1.31624465810883, 4.91295663090393, -1.41130638568871, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 3.82970843102537, -0.223353131420174, 0.0, 5.80409338312196, -1.54743588659733, 0.341938252770111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11299858218672e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930757, 0.259512887494068, 0.749149177264346, 2.75458800949269, -1.06581410364015e-14, -8.46157280212809, 1.15147421036811, 0.0, 3.3240197266047, 2.06838446274244, 0.0, -1.4210854715202e-14, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119207, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.9380831519647, 7.62808987244124, 2.57571741713036e-14, 3.11415464992885, 0.0, 0.0, -7.5213980463361, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, -1.95399252334028e-14, -2.48689957516035e-14, 14.2141062443803, 1.62092561595273e-14, 2.08721928629529e-14, 1.95399252334028e-14, 5.80288457473996, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.30451205393456e-14, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577686, 0.0, 2.68023757704197, -0.473803541479342, 0.0, -1.24344978758018e-14, 0.0, 5.09779364038994, -0.792824967172089, 0.140152977645354, 0.0, -1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933262, 0.0998865569686025, -0.0176576154454686, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205085, 0.0, 1.49829835452879, 0.847565541382361, 1.4210854715202e-14, -1.4210854715202e-14, -1.33226762955019e-14, 1.62843044502544, 3.54562104171168, -0.814818121686415, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.197418142283062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071078, 0.0, 0.69203436665088, 1.59036212878712, 0.0, 1.15463194561016e-14, 0.0, -8.46157280212813, 3.07059789431495, 1.19418232635198, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 12.4373429638327, 5.80288457473995, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309059, 1.59872115546023e-14, 7.62808987244128, 1.79795802543455, 0.0, 2.30926389122033e-14, 1.59872115546023e-14, 1.33226762955019e-14, -7.52139804633612, 3.1910589375405, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.81441536742477e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, 0.0, 0.0, 0.0},
      {-5.36159180343549, -1.24344978758018e-14, 0.0, 8.89943818451479, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412045, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497829, -0.393397896234718, 0.556348640264176, 2.33666428910957, 9.02784807228865, -0.732969916135162, -3.93352933905727, -1.19859611757308, 0.30904725218262, 1.64018416088946, 0.655588223176228, 0.0892142571199872, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.234843597212093, -2.44096975264614, -0.907332870306512, 0.0736662483163206, 0.810328731479523, 0.395334573318414, 0.120463442338386, -0.0310604175145457, -0.311895674167864, -0.164844710568319, -0.0658890955530742, -0.0089663702065863, 0.012680362351408, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862702, 1.54523626091313, 2.9504842217604, -0.76181175027506, 5.59815020469135, 0.263899331455869, -1.93925611658552, -2.28543525082518, 2.13307290077016, -0.257539376818832, 9.14446135479766, 0.0664963811608024, -2.36108976914458, -3.33842298506509, -0.0230350221379972, 0.817905488277895, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776446, 0.595437196138647, 0.0, -0.125015768949701, -0.192474367616164, -0.206265495285701, -0.166687691932942, 0.0, 1.11022302462516e-14, 0.0, 0.0, 1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331889, 1.82834820066016, 2.99085908983326, -1.24403337882029, 0.950146187582627, 5.7406445631131, -0.721110255092791, -0.169967317119749, -1.17961073303081, 0.490653381462662, 0.2943920288776, 4.97613351528119, -0.215472901842842, 5.78174466995659, -1.30185581821822, 0.163532434528638, -3.22682211353226, 0.0385449644663596, 0.267510569439606, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532871, 10.7636648722209, -0.500120235663633, 0.0216558414515711, -3.57321383950879, -0.581087203147982, 0.130841432732456, -0.0164356280722646, 1.37533064807501, 0.324307824721457, -0.00387391468765269, -0.026885823826833, 0.0111830284386755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637246, 1.66904592079257, 0.963624111659423, 1.3627702877385, 0.867360833110901, 2.28430636201795, 2.96226264871972, -1.00852844760551, 1.71026313764872, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760392, -0.52779866291172, 7.07977053255618, -1.76652739792483, 0.182834820066033, -3.12574097035512, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.4585173044132, 0.0, 11.0940489487798, -0.632607619454902, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468091, 0.0, 0.992281903807268, 0.735567892896455, 0.181909068193166, -0.147004726489969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458434, -0.430945803685661, 3.0472470011002, 0.775791113542718, -0.120185042515475, 5.29905651979671, 0.0346944333244363, -1.52970585407783, 0.901387818865992, -10.576283741361, 0.0, 4.5156107826894, -1.22124532708767e-14, -0.69955541437245, 6.36462844462227, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847887, 0.903959543974638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186566, -1.05140010313427, 0.160604018609909, 3.35889012281481, -0.304724700110031, 3.87851223317101, -1.52475169285614, 0.414677792940092, 0.0, 1.135512111385, -0.0364215679542204, 7.32969916135161, -0.761724681099359, 0.0691050664139866, 0.564240504518043, -0.879563899362173, 0.345781182036198, -0.0940400840863459, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162682, 0.00366050530850104, 9.05975063854701, -0.736662483163208, 0.0765562109321067, -0.00694532049720686, -3.48709964663733, -0.0567083043941579, 0.0883994979795846, -0.0347523163751422, 0.00945138406568935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533297, 0.705300630647568, 2.03602754481989, 1.15175110689979, 0.146610739697711, 1.81702705031798, 1.25178444059442, 0.655663160391207, 3.61359041872287, -1.70346285967311, 1.77635683940025e-14, 0.614267257013228, 0.454391937932165, 1.78428514239953, 5.63152770643898, -0.746494073225319, -0.618094504365247, 2.03210252328835, -2.15494277062553, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231201, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689785, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392903, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880552, 0.728431359084704, 2.57539376818857, 0.131132632078242, 0.711024300256739, 2.23926008187653, -0.205255035576781, 2.58567482211402, 0.761811750275054, 1.24344978758018e-14, -10.576283741361, 0.763277533137574, 0.0, 4.13862564412657, 2.68954640486932, 3.33066907387547e-14, -1.19471831485576, 3.10562068169861, -2.32269806558128, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131698, -1.30996183150502, 0.0, 1.24344978758018e-14, -2.88176900403077, -1.51261363209513, 0.763985254692614, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0},
      {1.1517511068998, 0.546323519313524, -0.105140010313417, 3.27118942773248, 9.65295620481433, -1.26565424807268e-14, 2.69341127303543, 0.0, -0.518347241175116, 4.25171145123353, 2.22044604925031e-14, 0.0, -9.91526600752599, 0.0, -2.30926389122033e-14, 6.71889089790563, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801237611, 0.199489143482413, 3.68560354207934, -0.814411017927955, 0.0, 1.02786571910339, -0.0786795792469475, 6.00856531485323, -1.45362164025439, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.233098034907112, 0.0178428514239979, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744266, -0.00179327404131646, 5.40219154319687, -0.702817019232744, 0.136947913395217, -0.0331311120155253, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689976, 0.18210783977116, 2.20794021658199, 0.892142571199753, -2.1316282072803e-14, 0.615765106730376, 0.323209352764229, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 2.68673971959288e-14, 1.07496769977314, 1.90844613931509, -0.19274394090961, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331153, 0.0, 0.0, 0.0, 0.0, -1.08801856413265e-14, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771034, 0.0343775825476146, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.67643676718399e-14, -1.13242748511766e-14, 0.0, 0.0},
      {1.03015750727543, 0.162882203585586, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987769, 0.578174466995669, 0.476969600708461, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.24344978758018e-14, -10.576283741361, 1.83186607953018, 0.694437895660716, 0.0, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634509, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257119979, 0.141060126129501, 0.407205508964017, 2.53385243517953, 0.0, 9.65295620481434, 0.695435800330237, 1.4210854715202e-14, 2.00755023262382, 3.29336152870135, 0.0, 1.59872115546023e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 3.9190872769268e-14, 2.69784194983913e-14, 5.00796559370721, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574686, 2.44096975264613, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.40998324127395e-14, 0.0, 1.36557432028894e-14, 0.0, 0.0, -1.33226762955019e-14},
      {0.728431359084686, -7.94708263760855, -1.25455201782643e-14, 2.53908227033119, -1.77635683940025e-14, -1.77635683940025e-14, 10.2207771580387, -1.50990331349021e-14, -1.06581410364015e-14, 5.00713776237769, 0.0, 1.46549439250521e-14, 0.0, 0.0, -1.24344978758018e-14, -8.49879943502226, -2.48689957516035e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.72843135908467, 0.0, 2.32737334062816, -0.470200420431697, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547688, 0.185449546754729, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 0.0, -2.1316282072803e-14, 0.0, 7.06540869306229, -1.01980390271858, 0.208166599946608, -0.0420560041253615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678875, 0.102494148638112, -0.0209215304820314, 0.004226787450472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608014, 4.9737991503207e-14, 1.45686271816939, 0.515078753637706, 0.0, 1.59872115546023e-14, 1.06581410364015e-14, 1.84729532019113, 2.58567482211398, -0.761811750275052, 1.4210854715202e-14, 3.01980662698043e-14, -1.77635683940025e-14, 0.0, 0.0, 2.08721928629529e-14, 1.71994831963704, 5.7253384179452, -1.54195152727693, 0.341686161713616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380929, -0.0555625639776334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.95399252334028e-14, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14},
      {0.594761714133166, 0.0, 0.814411017927977, 1.15175110689978, 0.0, 2.26485497023532e-14, 0.0, 0.59009684435208, 2.89087233497829, 0.340692571934619, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -10.576283741361, 3.4347488991191, 3.47218947830368, -1.03874215316939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637714, 0.0, 0.376160336345356, 1.46292038553768, 0.0, 0.0, 1.15463194561016e-14, 9.65295620481434, 1.85449546754729, 1.90142316513447, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, -9.91526600752598, 4.62616045379079, 0.817797356933092, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029894, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14},
      {0.420560041253717, -1.55431223447522e-14, -7.94708263760857, 1.46593983227029, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0, -8.49879943502225, 4.00637247496572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.22124532708767e-14, 0.0, -1.77635683940025e-14},
      {6.542378855465, 0.0, -1.19904086659517e-14, -6.91050664139872, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, 0.0, 0.0, 3.19744231092045e-14, 0.0, -4.9737991503207e-14, -2.30926389122033e-14, 0.0, 1.75415237890775e-14, 0.0, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.17603712826531e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 2.57571741713036e-14, 1.15463194561016e-14, 1.95399252334028e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923512, -0.00609788120679247, 0.00352061335622801, 0.00248944957812479, 0.00705946233325039, -0.00546823600997145, -0.00446479600584757, 0.00315708753234941, 0.00257775117585286, 0.00182274533665715, 0.00298267418725716, -0.00252081977982929, -0.00218309396769447, 0.00195261860521384, 0.00169101731601731, 0.00138070985681771, -0.00112734487734488, -0.000976309302606922, -0.00079715320750647, -0.000563672438672437, 0.00278687112460002, -0.00245778931055953, -0.00219831358911338, 0.00207721109304566, 0.00185791408306669, 0.00160900079398462, -0.00160900079398462, -0.00143913406048031, -0.0012463266558274, -0.00101762145320215, 0.000928957041533356, 0.00083088443721826, 0.000719567030240153, 0.0005875240199394, 0.000415442218609126, 0.00705593524717798, -0.00638233357089082, -0.00582624677716566, 0.00562868913761197, 0.00513826668309063, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.0030086608985143, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828761};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.91485421551272, 1.29756443747036, 3.74574588632197, -1.05945692672796, -8.09173593712687, 5.01426536422406, -0.383824736789365, 1.80936716113938, -1.10800657553489, 0.313391585264003, 0.0, 12.7134831207354, 1.01946290306868, 8.20651806648289, -0.631738055305789, 0.04835737145617, -2.84282124887606, -0.227958835180083, 0.139595707137603, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494798, 1.34011878852097, 1.89521416591737, 2.5331140255951, 1.96214168703486, 2.74642624930237, -0.566421515598876, 3.17129986868837, -1.82198870938952, 0.0, 0.0, 11.1699829238239, -1.06581410364015e-14, 8.65223156827827, -0.865042958313609, 1.08801856413265e-14, -2.49768411251822, -0.998865569685867, 0.441440386136639, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880925, 0.0, 1.02140518265514e-14, 4.45964044034302, 0.0, -0.858258202906989, 2.67027285925187, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 7.03562363973514, 4.06201920231799, -0.820651806648291, 1.06581410364015e-14, -6.79705818718657, -2.08116553882675, 5.8864250611046, -1.20156148406979, 0.24275207811381, 1.06581410364015e-14, -2.48689957516035e-14, 1.02140518265514e-14, 14.8323969741913, 0.856348838577658, 0.262202212042542, 5.13809303146606, -0.741619848709565, 0.151382517704904, -0.0305838870920609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508101, 1.31624465810883, 4.91295663090392, -1.4113063856887, 0.0, 0.0, 0.0, 0.0, 13.4039795085888, 2.01017818278146, 0.0, 5.80409338312193, -1.54743588659734, 0.341938252770115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747033, 0.749149177264371, 2.75458800949269, 1.22124532708767e-14, 1.4210854715202e-14, 5.75737105184055, 0.0, 3.3240197266047, 2.06838446274243, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.33226762955019e-14, -2.1316282072803e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119207, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {0.93808315196469, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03805852802452e-14, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431071, 0.0, 9.38083151964686, 1.89521416591739, 1.24344978758018e-14, 0.0, -1.24344978758018e-14, -3.39852909359329, -2.77488738510234, -0.560611910581393, 1.77635683940025e-14, 2.8421709430404e-14, 0.0, 0.0, -2.1316282072803e-14, 1.50990331349021e-14, 17.7988763690296, 0.428174419288831, 0.349602949390069, 0.0706304617818787, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452875, 4.23782770691181, 0.0, 0.0, -1.95399252334028e-14, 3.79967103839268, -3.54562104171166, -4.07409060843206, 0.0, 0.0, 2.1316282072803e-14, 0.0, 2.14828155264968e-14, 1.77635683940025e-14, 1.46549439250521e-14, 16.7549743857359, 1.11676565710086, 0.98709071141532, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.28705943072782e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.99840144432528e-14, -1.13242748511766e-14, 1.15463194561016e-14, 0.0},
      {-1.32664991614216, 0.0, 1.73008591662711, -3.18072425757421, 0.0, 0.0, 1.4210854715202e-14, 0.0, 7.67649473578738, -2.38836465270398, -1.06581410364015e-14, 0.0, 4.2632564145606e-14, 0.0, -3.19744231092045e-14, -3.19744231092045e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662072, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {1.6248076809272, 0.0, 1.4210854715202e-14, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.82076576038526e-14, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069939, 0.997445717412047, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.36277028773848, -2.89087233497829, -0.393397896234719, 0.556348640264175, 2.33666428910958, 9.02784807228867, -0.732969916135149, -3.93352933905728, -1.19859611757306, 0.309047252182628, 1.64018416088946, 0.655588223176224, 0.0892142571199703, -0.126168012376113, 13.0996183150502, 11.55277744383, -0.234843597212095, -2.44096975264614, -0.907332870306509, 0.0736662483163242, 0.810328731479522, 0.395334573318414, 0.120463442338384, -0.0310604175145466, -0.311895674167857, -0.164844710568314, -0.0658890955530749, -0.00896637020657787, 0.0126803623514049, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940279, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275053, 5.59815020469135, 0.263899331455872, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818858, 9.14446135479764, 0.066496381160809, -2.36108976914459, -3.33842298506509, -0.023035022137996, 0.817905488277898, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.36088943928029, 0.555625639776449, 0.595437196138647, 0.0, -0.125015768949707, -0.192474367616162, -0.206265495285709, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066015, 2.99085908983324, -1.24403337882029, 0.950146187582622, 5.74064456311311, -0.721110255092795, -0.169967317119746, -1.17961073303081, 0.490653381462657, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.7817446699566, -1.30185581821822, 0.163532434528627, -3.22682211353226, 0.0385449644663671, 0.267510569439609, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663638, 0.0216558414515706, -3.5732138395088, -0.581087203147983, 0.130841432732457, -0.016435628072264, 1.37533064807501, 0.324307824721451, -0.00387391468765164, -0.0268858238268332, 0.0111830284386736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637252, 1.66904592079258, 0.963624111659448, 1.36277028773848, 0.867360833110894, 2.28430636201792, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707465, 2.41867732448956, 2.04415543160772, 2.68821895760393, -0.527798662911731, 7.07977053255618, -1.76652739792481, 0.182834820066031, -3.12574097035514, -1.01990506872272, 0.904016610326397, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.86447112137561, -1.66605356688628, 0.315075748468086, 0.0, 0.992281903807271, 0.735567892896452, 0.18190906819316, -0.14700472648997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458432, -0.430945803685661, 3.04724700110021, 0.775791113542723, -0.120185042515454, 5.29905651979671, 0.0346944333244444, -1.52970585407782, 0.901387818865999, -1.04360964314765e-14, 1.06581410364015e-14, 4.5156107826894, 0.0, -0.699555414372449, 6.36462844462226, 0.0, 0.201944253400486, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 1.4210854715202e-14, 0.0, 1.11022302462516e-14, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980282, 0.894874292847889, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, -1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14},
      {1.62882203585589, 0.772618130456562, 3.86595114186569, -1.05140010313426, 9.1544290607646, 3.3588901228148, -0.304724700110031, 3.87851223317101, -1.52475169285615, 0.414677792940102, 0.0, -9.46260092820841, -2.07602937339135, 7.32969916135159, -0.761724681099374, 0.0691050664139912, 0.564240504518065, -0.879563899362182, 0.345781182036202, -0.0940400840863373, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584719, 9.059750638547, -0.736662483163207, 0.076556210932115, -0.00694532049720431, -3.48709964663733, -0.0567083043941596, 0.088399497979587, -0.034752316375144, 0.00945138406569224, 0.0, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.52100554373646e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647577, 2.03602754481991, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059443, 0.655663160391216, 3.61359041872289, -1.70346285967311, 0.0, 2.76420265655949, -9.08783875864325, 1.78428514239954, 5.63152770643901, -0.746494073225321, -0.618094504365241, 2.03210252328837, -2.1549427706255, 0.764033484562605, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689787, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392897, -0.124241670058189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, -1.06581410364015e-14, 0.0, 0.0},
      {1.32992762321608, 0.630840061880541, 0.72843135908467, 2.57539376818857, 0.917928424547676, 0.711024300256726, 2.23926008187654, -0.205255035576785, 2.58567482211403, 0.761811750275049, 1.77635683940025e-14, 0.0, 5.34294273196308, 0.0, 4.13862564412655, 2.68954640486928, 1.24344978758018e-14, -1.19471831485578, 3.10562068169857, -2.32269806558127, 0.0, 0.0, 1.35447209004269e-14, 0.0, 1.46549439250521e-14, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403077, -1.51261363209512, 0.763985254692606, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, -1.59872115546023e-14, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313517, -0.105140010313417, 3.27118942773249, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175128, 4.25171145123353, 1.4210854715202e-14, 0.0, -2.50910403565285e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, -6.78263087840207, 3.68560354207934, -0.814411017927949, -2.1316282072803e-14, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219803, -2.1316282072803e-14, 1.06581410364015e-14, 0.0, -7.57008074256672, -2.27270584034422, -0.60665694841585, 6.99294104721298, -1.36261453366201, 0.329650402328141, -0.0728431359084754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084513, 0.22841553125065, 0.0609713174047695, 5.40219154319687, -0.702817019232745, 0.136947913395213, -0.0331311120155262, 0.00732101061700652, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 3.82426463519459, 2.20794021658197, 0.892142571199754, 1.59872115546023e-14, -2.4630604269215, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727937, 0.0, -1.19904086659517e-14, 1.4210854715202e-14, 3.22490309931942, -7.63378455726036, -4.04762275910193, 1.11713920350151, 6.61105135360479, -2.33689608954554, 0.591817792331161, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108411, 0.721929233499938, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297049, -0.096237183808074, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 1.12548859121375e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, -1.46593983227031, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945722, -5.20357020296094, 0.476969600708472, 4.00571020990214, 0.590096844352075, 0.0, 0.0, 1.98729921407903e-14, 1.22124532708767e-14, 6.41153127835567, -6.2499410609466, 0.0, 2.7762744821073, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613679, -2.34333096254029, 0.591780433634507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199775, 0.705300630647563, 0.407205508964006, 2.53385243517952, 0.0, 0.0, 3.47717900165118, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 1.33226762955019e-14, -2.43000064514831e-14, 0.0, 0.0, 8.67405085085773, 1.86517468137026e-14, 0.0, 5.00796559370721, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.72843135908469, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237767, 0.0, 0.0, 2.04281036531029e-14, 0.0, -1.55431223447522e-14, -1.59872115546023e-14, 0.0, 1.23234755733392e-14, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125634, -3.29140294302191, -1.24344978758018e-14, 0.0, 1.77635683940025e-14, 13.4907375632321, 1.83585684909537, 1.29814682728312, -1.4210854715202e-14, 0.0, -2.8421709430404e-14, 0.0, -1.59872115546023e-14, 0.0, -3.53270434653116, -3.05941170815571, -0.416333199893259, -0.294392028877606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839439, 0.307482445914334, 0.0418430609640565, 0.0295875121532903, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {-2.6598552464322, 1.84297022087776e-14, 5.0990195135928, -2.06031501455088, 1.50990331349021e-14, 0.0, 0.0, -1.23153021346074, 9.049861877399, 3.04724700110021, 0.0, 0.0, -2.48689957516035e-14, 1.15463194561016e-14, -2.8421709430404e-14, 3.5527136788005e-14, 3.86988371918333, -3.81689227863023, -5.39683034546922, -1.36674464685443, 0.0, 0.0, 0.0, 0.0, 0.0, 1.46549439250521e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542066, 0.962572311333256, 0.22225025591058, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.82076576038526e-14, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0},
      {2.97380857066589, 1.4210854715202e-14, -0.814411017927924, 5.75875553449895, 0.0, 1.55431223447522e-14, -1.06581410364015e-14, 1.37689263682152, -2.89087233497829, 1.7034628596731, -1.4210854715202e-14, 3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 8.01441409794463, -3.47218947830362, -5.19371076584693, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.46549439250521e-14, 0.0, 0.0, 0.0},
      {-1.03015750727543, 0.0, 0.940400840863422, -2.9258407710754, -1.08801856413265e-14, 1.06581410364015e-14, 0.0, 0.0, 4.63623866886821, -3.80284633026899, -1.06581410364015e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 2.17603712826531e-14, 0.0, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493486, 0.0, 0.0, 3.19744231092045e-14, 0.0, -2.66453525910038e-14, -2.66453525910038e-14, 0.0, 2.1094237467878e-14, 1.06581410364015e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 1.44913767461894, 4.18330013267039, -0.591607978309966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385683, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.06581410364015e-14, -1.0769163338864e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, -2.1316282072803e-14, 8.87411967464942, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.24344978758018e-14, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -1.00000000000001, 1.30930734141595, 7.09929573971953, -0.414039335605414, -2.04939015319192, -0.478091443733756, 0.169030850945708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463868, 3.17542648054294, 9.07114735222144, 2.30926389122033e-14, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, -2.57571741713036e-14, -1.77635683940025e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033672, 4.38178046004134, -0.774596669241498, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818038, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.15463194561016e-14, 0.0, 1.15463194561016e-14, -1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 0.547722557505165, 1.58113883008419, 2.45967477524978, 0.0, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824849, -1.20948631362952, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.77635683940025e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.2609903369994, -1.24344978758018e-14, 3.83405790253616, 1.73194791841524e-14, 0.0, 10.5830052442584, 1.24344978758018e-14, 1.24344978758018e-14, 5.18459255872629, 0.0, 0.0, -1.99840144432528e-14, 1.59872115546023e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, -1.68753899743024e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824835, 0.0755928946018458, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 0.0, 1.46059348668042, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878696, -0.698297248755178, -1.06581410364015e-14, -3.01980662698043e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, -2.48689957516035e-14, -6.26099033699944, 2.21359436211788, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, -1.82076576038526e-14, 1.55431223447522e-14, -2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157676649773, 0.0, 2.30926389122033e-14, -4.69574275274956, 1.46549439250521e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 1.95399252334028e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.50990331349021e-14, 1.97619698383278e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34336985979644e-14, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105602, 2.39356776939084, 6.30376871403132, -0.908295106229245, -2.78313372537744, -0.52440442408507, 0.37080992435478, 1.23603308118261, 9.4017475579201, -0.301561193523235, -2.42752078113805, -0.79420020665698, 0.114434427054264, 0.84091786587209, 0.350641890608836, 0.0660687472643509, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047609, 2.74642624930235, -0.792824967172094, 2.24244764232555, 2.1408720964442, -0.331662479035521, 6.49923072370876, 0.0957427107756468, -1.87616630392937, -2.15580611373102, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932526, 0.590936840285284, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542155127, 1.29756443747036, 3.74574588632199, -1.05945692672796, 0.404586796856352, 5.01426536422406, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264004, 0.0, 2.82521847127452, -0.050973145153439, 8.20651806648289, -0.631738055305783, 0.0483573714561669, -2.84282124887605, -0.227958835180075, 0.139595707137607, -0.0394836284566216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715534, 1.160576914948, 1.34011878852096, 1.89521416591738, 0.361873432227861, 1.96214168703487, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313582, 0.0, -2.49768411251823, -0.998865569685865, 0.441440386136654, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.0050890913907, -0.193429485824662, 3.55615782880924, -8.46157280212811, 1.24344978758018e-14, 4.45964044034301, 0.0, -0.858258202906992, 2.67027285925186, -1.24344978758018e-14, 2.51465515077598e-14, 12.4373429638327, -1.24344978758018e-14, -1.84297022087776e-14, 8.42792824422441, 0.0, 0.0, -1.62195554683795, -2.29379153190451, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 0.335029697130244, 4.06201920231797, -0.820651806648291, 1.32255317808472e-14, 1.69926454679663, -0.0991031208965123, 5.8864250611046, -1.20156148406979, 0.242752078113808, 0.0, -1.59872115546023e-14, 0.0, 4.94413232473044, -0.214087209644422, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704899, -0.0305838870920683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905752, 2.07610309995255, 1.46802658041886, 1.28785870856518e-14, 0.868496237346889, 0.709124208342335, 1.31624465810883, 4.91295663090393, -1.41130638568871, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 3.82970843102537, -0.223353131420174, 0.0, 5.80409338312196, -1.54743588659733, 0.341938252770111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11299858218672e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930757, 0.259512887494068, 0.749149177264346, 2.75458800949269, -1.06581410364015e-14, -8.46157280212809, 1.15147421036811, 0.0, 3.3240197266047, 2.06838446274244, 0.0, -1.4210854715202e-14, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119207, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.9380831519647, 7.62808987244124, 2.57571741713036e-14, 3.11415464992885, 0.0, 0.0, -7.5213980463361, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, -1.95399252334028e-14, -2.48689957516035e-14, 14.2141062443803, 1.62092561595273e-14, 2.08721928629529e-14, 1.95399252334028e-14, 5.80288457473996, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.30451205393456e-14, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577686, 0.0, 2.68023757704197, -0.473803541479342, 0.0, -1.24344978758018e-14, 0.0, 5.09779364038994, -0.792824967172089, 0.140152977645354, 0.0, -1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933262, 0.0998865569686025, -0.0176576154454686, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205085, 0.0, 1.49829835452879, 0.847565541382361, 1.4210854715202e-14, -1.4210854715202e-14, -1.33226762955019e-14, 1.62843044502544, 3.54562104171168, -0.814818121686415, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.197418142283062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071078, 0.0, 0.69203436665088, 1.59036212878712, 0.0, 1.15463194561016e-14, 0.0, -8.46157280212813, 3.07059789431495, 1.19418232635198, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 12.4373429638327, 5.80288457473995, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309059, 1.59872115546023e-14, 7.62808987244128, 1.79795802543455, 0.0, 2.30926389122033e-14, 1.59872115546023e-14, 1.33226762955019e-14, -7.52139804633612, 3.1910589375405, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.81441536742477e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, 0.0, 0.0, 0.0},
      {-5.36159180343549, -1.24344978758018e-14, 0.0, 8.89943818451479, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412045, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497829, -0.393397896234718, 0.556348640264176, 2.33666428910957, 9.02784807228865, -0.732969916135162, -3.93352933905727, -1.19859611757308, 0.30904725218262, 1.64018416088946, 0.655588223176228, 0.0892142571199872, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.234843597212093, -2.44096975264614, -0.907332870306512, 0.0736662483163206, 0.810328731479523, 0.395334573318414, 0.120463442338386, -0.0310604175145457, -0.311895674167864, -0.164844710568319, -0.0658890955530742, -0.0089663702065863, 0.012680362351408, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862702, 1.54523626091313, 2.9504842217604, -0.76181175027506, 5.59815020469135, 0.263899331455869, -1.93925611658552, -2.28543525082518, 2.13307290077016, -0.257539376818832, 9.14446135479766, 0.0664963811608024, -2.36108976914458, -3.33842298506509, -0.0230350221379972, 0.817905488277895, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776446, 0.595437196138647, 0.0, -0.125015768949701, -0.192474367616164, -0.206265495285701, -0.166687691932942, 0.0, 1.11022302462516e-14, 0.0, 0.0, 1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331889, 1.82834820066016, 2.99085908983326, -1.24403337882029, 0.950146187582627, 5.7406445631131, -0.721110255092791, -0.169967317119749, -1.17961073303081, 0.490653381462662, 0.2943920288776, 4.97613351528119, -0.215472901842842, 5.78174466995659, -1.30185581821822, 0.163532434528638, -3.22682211353226, 0.0385449644663596, 0.267510569439606, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532871, 10.7636648722209, -0.500120235663633, 0.0216558414515711, -3.57321383950879, -0.581087203147982, 0.130841432732456, -0.0164356280722646, 1.37533064807501, 0.324307824721457, -0.00387391468765269, -0.026885823826833, 0.0111830284386755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637246, 1.66904592079257, 0.963624111659423, 1.3627702877385, 0.867360833110901, 2.28430636201795, 2.96226264871972, -1.00852844760551, 1.71026313764872, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760392, -0.52779866291172, 7.07977053255618, -1.76652739792483, 0.182834820066033, -3.12574097035512, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.4585173044132, 0.0, 11.0940489487798, -0.632607619454902, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468091, 0.0, 0.992281903807268, 0.735567892896455, 0.181909068193166, -0.147004726489969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458434, -0.430945803685661, 3.0472470011002, 0.775791113542718, -0.120185042515475, 5.29905651979671, 0.0346944333244363, -1.52970585407783, 0.901387818865992, -10.576283741361, 0.0, 4.5156107826894, -1.22124532708767e-14, -0.69955541437245, 6.36462844462227, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847887, 0.903959543974638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186566, -1.05140010313427, 0.160604018609909, 3.35889012281481, -0.304724700110031, 3.87851223317101, -1.52475169285614, 0.414677792940092, 0.0, 1.135512111385, -0.0364215679542204, 7.32969916135161, -0.761724681099359, 0.0691050664139866, 0.564240504518043, -0.879563899362173, 0.345781182036198, -0.0940400840863459, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162682, 0.00366050530850104, 9.05975063854701, -0.736662483163208, 0.0765562109321067, -0.00694532049720686, -3.48709964663733, -0.0567083043941579, 0.0883994979795846, -0.0347523163751422, 0.00945138406568935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533297, 0.705300630647568, 2.03602754481989, 1.15175110689979, 0.146610739697711, 1.81702705031798, 1.25178444059442, 0.655663160391207, 3.61359041872287, -1.70346285967311, 1.77635683940025e-14, 0.614267257013228, 0.454391937932165, 1.78428514239953, 5.63152770643898, -0.746494073225319, -0.618094504365247, 2.03210252328835, -2.15494277062553, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231201, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689785, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392903, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880552, 0.728431359084704, 2.57539376818857, 0.131132632078242, 0.711024300256739, 2.23926008187653, -0.205255035576781, 2.58567482211402, 0.761811750275054, 1.24344978758018e-14, -10.576283741361, 0.763277533137574, 0.0, 4.13862564412657, 2.68954640486932, 3.33066907387547e-14, -1.19471831485576, 3.10562068169861, -2.32269806558128, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131698, -1.30996183150502, 0.0, 1.24344978758018e-14, -2.88176900403077, -1.51261363209513, 0.763985254692614, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0},
      {1.1517511068998, 0.546323519313524, -0.105140010313417, 3.27118942773248, 9.65295620481433, -1.26565424807268e-14, 2.69341127303543, 0.0, -0.518347241175116, 4.25171145123353, 2.22044604925031e-14, 0.0, -9.91526600752599, 0.0, -2.30926389122033e-14, 6.71889089790563, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801237611, 0.199489143482413, 3.68560354207934, -0.814411017927955, 0.0, 1.02786571910339, -0.0786795792469475, 6.00856531485323, -1.45362164025439, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.233098034907112, 0.0178428514239979, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744266, -0.00179327404131646, 5.40219154319687, -0.702817019232744, 0.136947913395217, -0.0331311120155253, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689976, 0.18210783977116, 2.20794021658199, 0.892142571199753, -2.1316282072803e-14, 0.615765106730376, 0.323209352764229, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 2.68673971959288e-14, 1.07496769977314, 1.90844613931509, -0.19274394090961, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331153, 0.0, 0.0, 0.0, 0.0, -1.08801856413265e-14, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771034, 0.0343775825476146, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.67643676718399e-14, -1.13242748511766e-14, 0.0, 0.0},
      {1.03015750727543, 0.162882203585586, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987769, 0.578174466995669, 0.476969600708461, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.24344978758018e-14, -10.576283741361, 1.83186607953018, 0.694437895660716, 0.0, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634509, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257119979, 0.141060126129501, 0.407205508964017, 2.53385243517953, 0.0, 9.65295620481434, 0.695435800330237, 1.4210854715202e-14, 2.00755023262382, 3.29336152870135, 0.0, 1.59872115546023e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 3.9190872769268e-14, 2.69784194983913e-14, 5.00796559370721, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574686, 2.44096975264613, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.40998324127395e-14, 0.0, 1.36557432028894e-14, 0.0, 0.0, -1.33226762955019e-14},
      {0.728431359084686, -7.94708263760855, -1.25455201782643e-14, 2.53908227033119, -1.77635683940025e-14, -1.77635683940025e-14, 10.2207771580387, -1.50990331349021e-14, -1.06581410364015e-14, 5.00713776237769, 0.0, 1.46549439250521e-14, 0.0, 0.0, -1.24344978758018e-14, -8.49879943502226, -2.48689957516035e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.72843135908467, 0.0, 2.32737334062816, -0.470200420431697, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547688, 0.185449546754729, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 0.0, -2.1316282072803e-14, 0.0, 7.06540869306229, -1.01980390271858, 0.208166599946608, -0.0420560041253615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678875, 0.102494148638112, -0.0209215304820314, 0.004226787450472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608014, 4.9737991503207e-14, 1.45686271816939, 0.515078753637706, 0.0, 1.59872115546023e-14, 1.06581410364015e-14, 1.84729532019113, 2.58567482211398, -0.761811750275052, 1.4210854715202e-14, 3.01980662698043e-14, -1.77635683940025e-14, 0.0, 0.0, 2.08721928629529e-14, 1.71994831963704, 5.7253384179452, -1.54195152727693, 0.341686161713616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380929, -0.0555625639776334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.95399252334028e-14, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14},
      {0.594761714133166, 0.0, 0.814411017927977, 1.15175110689978, 0.0, 2.26485497023532e-14, 0.0, 0.59009684435208, 2.89087233497829, 0.340692571934619, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -10.576283741361, 3.4347488991191, 3.47218947830368, -1.03874215316939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637714, 0.0, 0.376160336345356, 1.46292038553768, 0.0, 0.0, 1.15463194561016e-14, 9.65295620481434, 1.85449546754729, 1.90142316513447, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, -9.91526600752598, 4.62616045379079, 0.817797356933092, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029894, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14},
      {0.420560041253717, -1.55431223447522e-14, -7.94708263760857, 1.46593983227029, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0, -8.49879943502225, 4.00637247496572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.22124532708767e-14, 0.0, -1.77635683940025e-14},
      {6.542378855465, 0.0, -1.19904086659517e-14, -6.91050664139872, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, 0.0, 0.0, 3.19744231092045e-14, 0.0, -4.9737991503207e-14, -2.30926389122033e-14, 0.0, 1.75415237890775e-14, 0.0, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.17603712826531e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 2.57571741713036e-14, 1.15463194561016e-14, 1.95399252334028e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923495, 0.0, -0.00704122671245611, 0.00248944957812476, 0.0, 0.0, 0.0, 0.00947126259704834, -0.0051555023517057, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937952, -0.00292892790782074, 0.00159430641501296, -0.000563672438672428, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0046447852076667, -0.00332353774887305, 0.00215870109072045, -0.00117504803987881, 0.000415442218609132, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680786, -0.000868525589828765};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.91485421551272, 1.29756443747036, 3.74574588632197, -1.05945692672796, -8.09173593712687, 5.01426536422406, -0.383824736789365, 1.80936716113938, -1.10800657553489, 0.313391585264003, 0.0, 12.7134831207354, 1.01946290306868, 8.20651806648289, -0.631738055305789, 0.04835737145617, -2.84282124887606, -0.227958835180083, 0.139595707137603, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494798, 1.34011878852097, 1.89521416591737, 2.5331140255951, 1.96214168703486, 2.74642624930237, -0.566421515598876, 3.17129986868837, -1.82198870938952, 0.0, 0.0, 11.1699829238239, -1.06581410364015e-14, 8.65223156827827, -0.865042958313609, 1.08801856413265e-14, -2.49768411251822, -0.998865569685867, 0.441440386136639, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880925, 0.0, 1.02140518265514e-14, 4.45964044034302, 0.0, -0.858258202906989, 2.67027285925187, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 7.03562363973514, 4.06201920231799, -0.820651806648291, 1.06581410364015e-14, -6.79705818718657, -2.08116553882675, 5.8864250611046, -1.20156148406979, 0.24275207811381, 1.06581410364015e-14, -2.48689957516035e-14, 1.02140518265514e-14, 14.8323969741913, 0.856348838577658, 0.262202212042542, 5.13809303146606, -0.741619848709565, 0.151382517704904, -0.0305838870920609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508101, 1.31624465810883, 4.91295663090392, -1.4113063856887, 0.0, 0.0, 0.0, 0.0, 13.4039795085888, 2.01017818278146, 0.0, 5.80409338312193, -1.54743588659734, 0.341938252770115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747033, 0.749149177264371, 2.75458800949269, 1.22124532708767e-14, 1.4210854715202e-14, 5.75737105184055, 0.0, 3.3240197266047, 2.06838446274243, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.33226762955019e-14, -2.1316282072803e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119207, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {0.93808315196469, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03805852802452e-14, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431071, 0.0, 9.38083151964686, 1.89521416591739, 1.24344978758018e-14, 0.0, -1.24344978758018e-14, -3.39852909359329, -2.77488738510234, -0.560611910581393, 1.77635683940025e-14, 2.8421709430404e-14, 0.0, 0.0, -2.1316282072803e-14, 1.50990331349021e-14, 17.7988763690296, 0.428174419288831, 0.349602949390069, 0.0706304617818787, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452875, 4.23782770691181, 0.0, 0.0, -1.95399252334028e-14, 3.79967103839268, -3.54562104171166, -4.07409060843206, 0.0, 0.0, 2.1316282072803e-14, 0.0, 2.14828155264968e-14, 1.77635683940025e-14, 1.46549439250521e-14, 16.7549743857359, 1.11676565710086, 0.98709071141532, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.28705943072782e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.99840144432528e-14, -1.13242748511766e-14, 1.15463194561016e-14, 0.0},
      {-1.32664991614216, 0.0, 1.73008591662711, -3.18072425757421, 0.0, 0.0, 1.4210854715202e-14, 0.0, 7.67649473578738, -2.38836465270398, -1.06581410364015e-14, 0.0, 4.2632564145606e-14, 0.0, -3.19744231092045e-14, -3.19744231092045e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662072, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {1.6248076809272, 0.0, 1.4210854715202e-14, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.82076576038526e-14, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069939, 0.997445717412047, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.36277028773848, -2.89087233497829, -0.393397896234719, 0.556348640264175, 2.33666428910958, 9.02784807228867, -0.732969916135149, -3.93352933905728, -1.19859611757306, 0.309047252182628, 1.64018416088946, 0.655588223176224, 0.0892142571199703, -0.126168012376113, 13.0996183150502, 11.55277744383, -0.234843597212095, -2.44096975264614, -0.907332870306509, 0.0736662483163242, 0.810328731479522, 0.395334573318414, 0.120463442338384, -0.0310604175145466, -0.311895674167857, -0.164844710568314, -0.0658890955530749, -0.00896637020657787, 0.0126803623514049, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940279, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275053, 5.59815020469135, 0.263899331455872, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818858, 9.14446135479764, 0.066496381160809, -2.36108976914459, -3.33842298506509, -0.023035022137996, 0.817905488277898, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.36088943928029, 0.555625639776449, 0.595437196138647, 0.0, -0.125015768949707, -0.192474367616162, -0.206265495285709, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066015, 2.99085908983324, -1.24403337882029, 0.950146187582622, 5.74064456311311, -0.721110255092795, -0.169967317119746, -1.17961073303081, 0.490653381462657, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.7817446699566, -1.30185581821822, 0.163532434528627, -3.22682211353226, 0.0385449644663671, 0.267510569439609, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663638, 0.0216558414515706, -3.5732138395088, -0.581087203147983, 0.130841432732457, -0.016435628072264, 1.37533064807501, 0.324307824721451, -0.00387391468765164, -0.0268858238268332, 0.0111830284386736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637252, 1.66904592079258, 0.963624111659448, 1.36277028773848, 0.867360833110894, 2.28430636201792, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707465, 2.41867732448956, 2.04415543160772, 2.68821895760393, -0.527798662911731, 7.07977053255618, -1.76652739792481, 0.182834820066031, -3.12574097035514, -1.01990506872272, 0.904016610326397, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.86447112137561, -1.66605356688628, 0.315075748468086, 0.0, 0.992281903807271, 0.735567892896452, 0.18190906819316, -0.14700472648997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458432, -0.430945803685661, 3.04724700110021, 0.775791113542723, -0.120185042515454, 5.29905651979671, 0.0346944333244444, -1.52970585407782, 0.901387818865999, -1.04360964314765e-14, 1.06581410364015e-14, 4.5156107826894, 0.0, -0.699555414372449, 6.36462844462226, 0.0, 0.201944253400486, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 1.4210854715202e-14, 0.0, 1.11022302462516e-14, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980282, 0.894874292847889, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, -1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14},
      {1.62882203585589, 0.772618130456562, 3.86595114186569, -1.05140010313426, 9.1544290607646, 3.3588901228148, -0.304724700110031, 3.87851223317101, -1.52475169285615, 0.414677792940102, 0.0, -9.46260092820841, -2.07602937339135, 7.32969916135159, -0.761724681099374, 0.0691050664139912, 0.564240504518065, -0.879563899362182, 0.345781182036202, -0.0940400840863373, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584719, 9.059750638547, -0.736662483163207, 0.076556210932115, -0.00694532049720431, -3.48709964663733, -0.0567083043941596, 0.088399497979587, -0.034752316375144, 0.00945138406569224, 0.0, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.52100554373646e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647577, 2.03602754481991, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059443, 0.655663160391216, 3.61359041872289, -1.70346285967311, 0.0, 2.76420265655949, -9.08783875864325, 1.78428514239954, 5.63152770643901, -0.746494073225321, -0.618094504365241, 2.03210252328837, -2.1549427706255, 0.764033484562605, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689787, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392897, -0.124241670058189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, -1.06581410364015e-14, 0.0, 0.0},
      {1.32992762321608, 0.630840061880541, 0.72843135908467, 2.57539376818857, 0.917928424547676, 0.711024300256726, 2.23926008187654, -0.205255035576785, 2.58567482211403, 0.761811750275049, 1.77635683940025e-14, 0.0, 5.34294273196308, 0.0, 4.13862564412655, 2.68954640486928, 1.24344978758018e-14, -1.19471831485578, 3.10562068169857, -2.32269806558127, 0.0, 0.0, 1.35447209004269e-14, 0.0, 1.46549439250521e-14, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403077, -1.51261363209512, 0.763985254692606, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, -1.59872115546023e-14, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313517, -0.105140010313417, 3.27118942773249, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175128, 4.25171145123353, 1.4210854715202e-14, 0.0, -2.50910403565285e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, -6.78263087840207, 3.68560354207934, -0.814411017927949, -2.1316282072803e-14, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219803, -2.1316282072803e-14, 1.06581410364015e-14, 0.0, -7.57008074256672, -2.27270584034422, -0.60665694841585, 6.99294104721298, -1.36261453366201, 0.329650402328141, -0.0728431359084754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084513, 0.22841553125065, 0.0609713174047695, 5.40219154319687, -0.702817019232745, 0.136947913395213, -0.0331311120155262, 0.00732101061700652, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 3.82426463519459, 2.20794021658197, 0.892142571199754, 1.59872115546023e-14, -2.4630604269215, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727937, 0.0, -1.19904086659517e-14, 1.4210854715202e-14, 3.22490309931942, -7.63378455726036, -4.04762275910193, 1.11713920350151, 6.61105135360479, -2.33689608954554, 0.591817792331161, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108411, 0.721929233499938, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297049, -0.096237183808074, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 1.12548859121375e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, -1.46593983227031, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945722, -5.20357020296094, 0.476969600708472, 4.00571020990214, 0.590096844352075, 0.0, 0.0, 1.98729921407903e-14, 1.22124532708767e-14, 6.41153127835567, -6.2499410609466, 0.0, 2.7762744821073, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613679, -2.34333096254029, 0.591780433634507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199775, 0.705300630647563, 0.407205508964006, 2.53385243517952, 0.0, 0.0, 3.47717900165118, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 1.33226762955019e-14, -2.43000064514831e-14, 0.0, 0.0, 8.67405085085773, 1.86517468137026e-14, 0.0, 5.00796559370721, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.72843135908469, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237767, 0.0, 0.0, 2.04281036531029e-14, 0.0, -1.55431223447522e-14, -1.59872115546023e-14, 0.0, 1.23234755733392e-14, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125634, -3.29140294302191, -1.24344978758018e-14, 0.0, 1.77635683940025e-14, 13.4907375632321, 1.83585684909537, 1.29814682728312, -1.4210854715202e-14, 0.0, -2.8421709430404e-14, 0.0, -1.59872115546023e-14, 0.0, -3.53270434653116, -3.05941170815571, -0.416333199893259, -0.294392028877606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839439, 0.307482445914334, 0.0418430609640565, 0.0295875121532903, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {-2.6598552464322, 1.84297022087776e-14, 5.0990195135928, -2.06031501455088, 1.50990331349021e-14, 0.0, 0.0, -1.23153021346074, 9.049861877399, 3.04724700110021, 0.0, 0.0, -2.48689957516035e-14, 1.15463194561016e-14, -2.8421709430404e-14, 3.5527136788005e-14, 3.86988371918333, -3.81689227863023, -5.39683034546922, -1.36674464685443, 0.0, 0.0, 0.0, 0.0, 0.0, 1.46549439250521e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542066, 0.962572311333256, 0.22225025591058, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.82076576038526e-14, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0},
      {2.97380857066589, 1.4210854715202e-14, -0.814411017927924, 5.75875553449895, 0.0, 1.55431223447522e-14, -1.06581410364015e-14, 1.37689263682152, -2.89087233497829, 1.7034628596731, -1.4210854715202e-14, 3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 8.01441409794463, -3.47218947830362, -5.19371076584693, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.46549439250521e-14, 0.0, 0.0, 0.0},
      {-1.03015750727543, 0.0, 0.940400840863422, -2.9258407710754, -1.08801856413265e-14, 1.06581410364015e-14, 0.0, 0.0, 4.63623866886821, -3.80284633026899, -1.06581410364015e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 2.17603712826531e-14, 0.0, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493486, 0.0, 0.0, 3.19744231092045e-14, 0.0, -2.66453525910038e-14, -2.66453525910038e-14, 0.0, 2.1094237467878e-14, 1.06581410364015e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 1.44913767461894, 4.18330013267039, -0.591607978309966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385683, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.06581410364015e-14, -1.0769163338864e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, -2.1316282072803e-14, 8.87411967464942, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.24344978758018e-14, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -1.00000000000001, 1.30930734141595, 7.09929573971953, -0.414039335605414, -2.04939015319192, -0.478091443733756, 0.169030850945708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463868, 3.17542648054294, 9.07114735222144, 2.30926389122033e-14, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, -2.57571741713036e-14, -1.77635683940025e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033672, 4.38178046004134, -0.774596669241498, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818038, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.15463194561016e-14, 0.0, 1.15463194561016e-14, -1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 0.547722557505165, 1.58113883008419, 2.45967477524978, 0.0, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824849, -1.20948631362952, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.77635683940025e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.2609903369994, -1.24344978758018e-14, 3.83405790253616, 1.73194791841524e-14, 0.0, 10.5830052442584, 1.24344978758018e-14, 1.24344978758018e-14, 5.18459255872629, 0.0, 0.0, -1.99840144432528e-14, 1.59872115546023e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, -1.68753899743024e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824835, 0.0755928946018458, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 0.0, 1.46059348668042, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878696, -0.698297248755178, -1.06581410364015e-14, -3.01980662698043e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, -2.48689957516035e-14, -6.26099033699944, 2.21359436211788, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, -1.82076576038526e-14, 1.55431223447522e-14, -2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157676649773, 0.0, 2.30926389122033e-14, -4.69574275274956, 1.46549439250521e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 1.95399252334028e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.50990331349021e-14, 1.97619698383278e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34336985979644e-14, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105602, 2.39356776939084, 6.30376871403132, -0.908295106229245, -2.78313372537744, -0.52440442408507, 0.37080992435478, 1.23603308118261, 9.4017475579201, -0.301561193523235, -2.42752078113805, -0.79420020665698, 0.114434427054264, 0.84091786587209, 0.350641890608836, 0.0660687472643509, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047609, 2.74642624930235, -0.792824967172094, 2.24244764232555, 2.1408720964442, -0.331662479035521, 6.49923072370876, 0.0957427107756468, -1.87616630392937, -2.15580611373102, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932526, 0.590936840285284, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542155127, 1.29756443747036, 3.74574588632199, -1.05945692672796, 0.404586796856352, 5.01426536422406, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264004, 0.0, 2.82521847127452, -0.050973145153439, 8.20651806648289, -0.631738055305783, 0.0483573714561669, -2.84282124887605, -0.227958835180075, 0.139595707137607, -0.0394836284566216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715534, 1.160576914948, 1.34011878852096, 1.89521416591738, 0.361873432227861, 1.96214168703487, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313582, 0.0, -2.49768411251823, -0.998865569685865, 0.441440386136654, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.0050890913907, -0.193429485824662, 3.55615782880924, -8.46157280212811, 1.24344978758018e-14, 4.45964044034301, 0.0, -0.858258202906992, 2.67027285925186, -1.24344978758018e-14, 2.51465515077598e-14, 12.4373429638327, -1.24344978758018e-14, -1.84297022087776e-14, 8.42792824422441, 0.0, 0.0, -1.62195554683795, -2.29379153190451, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 0.335029697130244, 4.06201920231797, -0.820651806648291, 1.32255317808472e-14, 1.69926454679663, -0.0991031208965123, 5.8864250611046, -1.20156148406979, 0.242752078113808, 0.0, -1.59872115546023e-14, 0.0, 4.94413232473044, -0.214087209644422, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704899, -0.0305838870920683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905752, 2.07610309995255, 1.46802658041886, 1.28785870856518e-14, 0.868496237346889, 0.709124208342335, 1.31624465810883, 4.91295663090393, -1.41130638568871, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 3.82970843102537, -0.223353131420174, 0.0, 5.80409338312196, -1.54743588659733, 0.341938252770111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11299858218672e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930757, 0.259512887494068, 0.749149177264346, 2.75458800949269, -1.06581410364015e-14, -8.46157280212809, 1.15147421036811, 0.0, 3.3240197266047, 2.06838446274244, 0.0, -1.4210854715202e-14, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119207, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.9380831519647, 7.62808987244124, 2.57571741713036e-14, 3.11415464992885, 0.0, 0.0, -7.5213980463361, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, -1.95399252334028e-14, -2.48689957516035e-14, 14.2141062443803, 1.62092561595273e-14, 2.08721928629529e-14, 1.95399252334028e-14, 5.80288457473996, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.30451205393456e-14, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577686, 0.0, 2.68023757704197, -0.473803541479342, 0.0, -1.24344978758018e-14, 0.0, 5.09779364038994, -0.792824967172089, 0.140152977645354, 0.0, -1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933262, 0.0998865569686025, -0.0176576154454686, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205085, 0.0, 1.49829835452879, 0.847565541382361, 1.4210854715202e-14, -1.4210854715202e-14, -1.33226762955019e-14, 1.62843044502544, 3.54562104171168, -0.814818121686415, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.197418142283062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071078, 0.0, 0.69203436665088, 1.59036212878712, 0.0, 1.15463194561016e-14, 0.0, -8.46157280212813, 3.07059789431495, 1.19418232635198, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 12.4373429638327, 5.80288457473995, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309059, 1.59872115546023e-14, 7.62808987244128, 1.79795802543455, 0.0, 2.30926389122033e-14, 1.59872115546023e-14, 1.33226762955019e-14, -7.52139804633612, 3.1910589375405, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.81441536742477e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, 0.0, 0.0, 0.0},
      {-5.36159180343549, -1.24344978758018e-14, 0.0, 8.89943818451479, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412045, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497829, -0.393397896234718, 0.556348640264176, 2.33666428910957, 9.02784807228865, -0.732969916135162, -3.93352933905727, -1.19859611757308, 0.30904725218262, 1.64018416088946, 0.655588223176228, 0.0892142571199872, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.234843597212093, -2.44096975264614, -0.907332870306512, 0.0736662483163206, 0.810328731479523, 0.395334573318414, 0.120463442338386, -0.0310604175145457, -0.311895674167864, -0.164844710568319, -0.0658890955530742, -0.0089663702065863, 0.012680362351408, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862702, 1.54523626091313, 2.9504842217604, -0.76181175027506, 5.59815020469135, 0.263899331455869, -1.93925611658552, -2.28543525082518, 2.13307290077016, -0.257539376818832, 9.14446135479766, 0.0664963811608024, -2.36108976914458, -3.33842298506509, -0.0230350221379972, 0.817905488277895, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776446, 0.595437196138647, 0.0, -0.125015768949701, -0.192474367616164, -0.206265495285701, -0.166687691932942, 0.0, 1.11022302462516e-14, 0.0, 0.0, 1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331889, 1.82834820066016, 2.99085908983326, -1.24403337882029, 0.950146187582627, 5.7406445631131, -0.721110255092791, -0.169967317119749, -1.17961073303081, 0.490653381462662, 0.2943920288776, 4.97613351528119, -0.215472901842842, 5.78174466995659, -1.30185581821822, 0.163532434528638, -3.22682211353226, 0.0385449644663596, 0.267510569439606, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532871, 10.7636648722209, -0.500120235663633, 0.0216558414515711, -3.57321383950879, -0.581087203147982, 0.130841432732456, -0.0164356280722646, 1.37533064807501, 0.324307824721457, -0.00387391468765269, -0.026885823826833, 0.0111830284386755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637246, 1.66904592079257, 0.963624111659423, 1.3627702877385, 0.867360833110901, 2.28430636201795, 2.96226264871972, -1.00852844760551, 1.71026313764872, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760392, -0.52779866291172, 7.07977053255618, -1.76652739792483, 0.182834820066033, -3.12574097035512, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.4585173044132, 0.0, 11.0940489487798, -0.632607619454902, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468091, 0.0, 0.992281903807268, 0.735567892896455, 0.181909068193166, -0.147004726489969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458434, -0.430945803685661, 3.0472470011002, 0.775791113542718, -0.120185042515475, 5.29905651979671, 0.0346944333244363, -1.52970585407783, 0.901387818865992, -10.576283741361, 0.0, 4.5156107826894, -1.22124532708767e-14, -0.69955541437245, 6.36462844462227, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847887, 0.903959543974638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186566, -1.05140010313427, 0.160604018609909, 3.35889012281481, -0.304724700110031, 3.87851223317101, -1.52475169285614, 0.414677792940092, 0.0, 1.135512111385, -0.0364215679542204, 7.32969916135161, -0.761724681099359, 0.0691050664139866, 0.564240504518043, -0.879563899362173, 0.345781182036198, -0.0940400840863459, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162682, 0.00366050530850104, 9.05975063854701, -0.736662483163208, 0.0765562109321067, -0.00694532049720686, -3.48709964663733, -0.0567083043941579, 0.0883994979795846, -0.0347523163751422, 0.00945138406568935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533297, 0.705300630647568, 2.03602754481989, 1.15175110689979, 0.146610739697711, 1.81702705031798, 1.25178444059442, 0.655663160391207, 3.61359041872287, -1.70346285967311, 1.77635683940025e-14, 0.614267257013228, 0.454391937932165, 1.78428514239953, 5.63152770643898, -0.746494073225319, -0.618094504365247, 2.03210252328835, -2.15494277062553, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231201, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689785, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392903, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880552, 0.728431359084704, 2.57539376818857, 0.131132632078242, 0.711024300256739, 2.23926008187653, -0.205255035576781, 2.58567482211402, 0.761811750275054, 1.24344978758018e-14, -10.576283741361, 0.763277533137574, 0.0, 4.13862564412657, 2.68954640486932, 3.33066907387547e-14, -1.19471831485576, 3.10562068169861, -2.32269806558128, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131698, -1.30996183150502, 0.0, 1.24344978758018e-14, -2.88176900403077, -1.51261363209513, 0.763985254692614, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0},
      {1.1517511068998, 0.546323519313524, -0.105140010313417, 3.27118942773248, 9.65295620481433, -1.26565424807268e-14, 2.69341127303543, 0.0, -0.518347241175116, 4.25171145123353, 2.22044604925031e-14, 0.0, -9.91526600752599, 0.0, -2.30926389122033e-14, 6.71889089790563, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801237611, 0.199489143482413, 3.68560354207934, -0.814411017927955, 0.0, 1.02786571910339, -0.0786795792469475, 6.00856531485323, -1.45362164025439, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.233098034907112, 0.0178428514239979, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744266, -0.00179327404131646, 5.40219154319687, -0.702817019232744, 0.136947913395217, -0.0331311120155253, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689976, 0.18210783977116, 2.20794021658199, 0.892142571199753, -2.1316282072803e-14, 0.615765106730376, 0.323209352764229, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 2.68673971959288e-14, 1.07496769977314, 1.90844613931509, -0.19274394090961, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331153, 0.0, 0.0, 0.0, 0.0, -1.08801856413265e-14, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771034, 0.0343775825476146, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.67643676718399e-14, -1.13242748511766e-14, 0.0, 0.0},
      {1.03015750727543, 0.162882203585586, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987769, 0.578174466995669, 0.476969600708461, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.24344978758018e-14, -10.576283741361, 1.83186607953018, 0.694437895660716, 0.0, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634509, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257119979, 0.141060126129501, 0.407205508964017, 2.53385243517953, 0.0, 9.65295620481434, 0.695435800330237, 1.4210854715202e-14, 2.00755023262382, 3.29336152870135, 0.0, 1.59872115546023e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 3.9190872769268e-14, 2.69784194983913e-14, 5.00796559370721, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574686, 2.44096975264613, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.40998324127395e-14, 0.0, 1.36557432028894e-14, 0.0, 0.0, -1.33226762955019e-14},
      {0.728431359084686, -7.94708263760855, -1.25455201782643e-14, 2.53908227033119, -1.77635683940025e-14, -1.77635683940025e-14, 10.2207771580387, -1.50990331349021e-14, -1.06581410364015e-14, 5.00713776237769, 0.0, 1.46549439250521e-14, 0.0, 0.0, -1.24344978758018e-14, -8.49879943502226, -2.48689957516035e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.72843135908467, 0.0, 2.32737334062816, -0.470200420431697, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547688, 0.185449546754729, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 0.0, -2.1316282072803e-14, 0.0, 7.06540869306229, -1.01980390271858, 0.208166599946608, -0.0420560041253615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678875, 0.102494148638112, -0.0209215304820314, 0.004226787450472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608014, 4.9737991503207e-14, 1.45686271816939, 0.515078753637706, 0.0, 1.59872115546023e-14, 1.06581410364015e-14, 1.84729532019113, 2.58567482211398, -0.761811750275052, 1.4210854715202e-14, 3.01980662698043e-14, -1.77635683940025e-14, 0.0, 0.0, 2.08721928629529e-14, 1.71994831963704, 5.7253384179452, -1.54195152727693, 0.341686161713616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380929, -0.0555625639776334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.95399252334028e-14, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14},
      {0.594761714133166, 0.0, 0.814411017927977, 1.15175110689978, 0.0, 2.26485497023532e-14, 0.0, 0.59009684435208, 2.89087233497829, 0.340692571934619, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -10.576283741361, 3.4347488991191, 3.47218947830368, -1.03874215316939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637714, 0.0, 0.376160336345356, 1.46292038553768, 0.0, 0.0, 1.15463194561016e-14, 9.65295620481434, 1.85449546754729, 1.90142316513447, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, -9.91526600752598, 4.62616045379079, 0.817797356933092, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029894, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14},
      {0.420560041253717, -1.55431223447522e-14, -7.94708263760857, 1.46593983227029, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0, -8.49879943502225, 4.00637247496572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.22124532708767e-14, 0.0, -1.77635683940025e-14},
      {6.542378855465, 0.0, -1.19904086659517e-14, -6.91050664139872, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, 0.0, 0.0, 3.19744231092045e-14, 0.0, -4.9737991503207e-14, -2.30926389122033e-14, 0.0, 1.75415237890775e-14, 0.0, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.17603712826531e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 2.57571741713036e-14, 1.15463194561016e-14, 1.95399252334028e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923497, 0.0, 0.0, -0.0074683487343743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913698, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.91485421551272, 1.29756443747036, 3.74574588632197, -1.05945692672796, -8.09173593712687, 5.01426536422406, -0.383824736789365, 1.80936716113938, -1.10800657553489, 0.313391585264003, 0.0, 12.7134831207354, 1.01946290306868, 8.20651806648289, -0.631738055305789, 0.04835737145617, -2.84282124887606, -0.227958835180083, 0.139595707137603, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494798, 1.34011878852097, 1.89521416591737, 2.5331140255951, 1.96214168703486, 2.74642624930237, -0.566421515598876, 3.17129986868837, -1.82198870938952, 0.0, 0.0, 11.1699829238239, -1.06581410364015e-14, 8.65223156827827, -0.865042958313609, 1.08801856413265e-14, -2.49768411251822, -0.998865569685867, 0.441440386136639, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880925, 0.0, 1.02140518265514e-14, 4.45964044034302, 0.0, -0.858258202906989, 2.67027285925187, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 7.03562363973514, 4.06201920231799, -0.820651806648291, 1.06581410364015e-14, -6.79705818718657, -2.08116553882675, 5.8864250611046, -1.20156148406979, 0.24275207811381, 1.06581410364015e-14, -2.48689957516035e-14, 1.02140518265514e-14, 14.8323969741913, 0.856348838577658, 0.262202212042542, 5.13809303146606, -0.741619848709565, 0.151382517704904, -0.0305838870920609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508101, 1.31624465810883, 4.91295663090392, -1.4113063856887, 0.0, 0.0, 0.0, 0.0, 13.4039795085888, 2.01017818278146, 0.0, 5.80409338312193, -1.54743588659734, 0.341938252770115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747033, 0.749149177264371, 2.75458800949269, 1.22124532708767e-14, 1.4210854715202e-14, 5.75737105184055, 0.0, 3.3240197266047, 2.06838446274243, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.33226762955019e-14, -2.1316282072803e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119207, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {0.93808315196469, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03805852802452e-14, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431071, 0.0, 9.38083151964686, 1.89521416591739, 1.24344978758018e-14, 0.0, -1.24344978758018e-14, -3.39852909359329, -2.77488738510234, -0.560611910581393, 1.77635683940025e-14, 2.8421709430404e-14, 0.0, 0.0, -2.1316282072803e-14, 1.50990331349021e-14, 17.7988763690296, 0.428174419288831, 0.349602949390069, 0.0706304617818787, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452875, 4.23782770691181, 0.0, 0.0, -1.95399252334028e-14, 3.79967103839268, -3.54562104171166, -4.07409060843206, 0.0, 0.0, 2.1316282072803e-14, 0.0, 2.14828155264968e-14, 1.77635683940025e-14, 1.46549439250521e-14, 16.7549743857359, 1.11676565710086, 0.98709071141532, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.28705943072782e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.99840144432528e-14, -1.13242748511766e-14, 1.15463194561016e-14, 0.0},
      {-1.32664991614216, 0.0, 1.73008591662711, -3.18072425757421, 0.0, 0.0, 1.4210854715202e-14, 0.0, 7.67649473578738, -2.38836465270398, -1.06581410364015e-14, 0.0, 4.2632564145606e-14, 0.0, -3.19744231092045e-14, -3.19744231092045e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662072, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {1.6248076809272, 0.0, 1.4210854715202e-14, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.82076576038526e-14, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069939, 0.997445717412047, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.36277028773848, -2.89087233497829, -0.393397896234719, 0.556348640264175, 2.33666428910958, 9.02784807228867, -0.732969916135149, -3.93352933905728, -1.19859611757306, 0.309047252182628, 1.64018416088946, 0.655588223176224, 0.0892142571199703, -0.126168012376113, 13.0996183150502, 11.55277744383, -0.234843597212095, -2.44096975264614, -0.907332870306509, 0.0736662483163242, 0.810328731479522, 0.395334573318414, 0.120463442338384, -0.0310604175145466, -0.311895674167857, -0.164844710568314, -0.0658890955530749, -0.00896637020657787, 0.0126803623514049, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940279, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275053, 5.59815020469135, 0.263899331455872, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818858, 9.14446135479764, 0.066496381160809, -2.36108976914459, -3.33842298506509, -0.023035022137996, 0.817905488277898, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.36088943928029, 0.555625639776449, 0.595437196138647, 0.0, -0.125015768949707, -0.192474367616162, -0.206265495285709, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066015, 2.99085908983324, -1.24403337882029, 0.950146187582622, 5.74064456311311, -0.721110255092795, -0.169967317119746, -1.17961073303081, 0.490653381462657, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.7817446699566, -1.30185581821822, 0.163532434528627, -3.22682211353226, 0.0385449644663671, 0.267510569439609, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663638, 0.0216558414515706, -3.5732138395088, -0.581087203147983, 0.130841432732457, -0.016435628072264, 1.37533064807501, 0.324307824721451, -0.00387391468765164, -0.0268858238268332, 0.0111830284386736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637252, 1.66904592079258, 0.963624111659448, 1.36277028773848, 0.867360833110894, 2.28430636201792, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707465, 2.41867732448956, 2.04415543160772, 2.68821895760393, -0.527798662911731, 7.07977053255618, -1.76652739792481, 0.182834820066031, -3.12574097035514, -1.01990506872272, 0.904016610326397, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.86447112137561, -1.66605356688628, 0.315075748468086, 0.0, 0.992281903807271, 0.735567892896452, 0.18190906819316, -0.14700472648997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458432, -0.430945803685661, 3.04724700110021, 0.775791113542723, -0.120185042515454, 5.29905651979671, 0.0346944333244444, -1.52970585407782, 0.901387818865999, -1.04360964314765e-14, 1.06581410364015e-14, 4.5156107826894, 0.0, -0.699555414372449, 6.36462844462226, 0.0, 0.201944253400486, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 1.4210854715202e-14, 0.0, 1.11022302462516e-14, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980282, 0.894874292847889, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, -1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14},
      {1.62882203585589, 0.772618130456562, 3.86595114186569, -1.05140010313426, 9.1544290607646, 3.3588901228148, -0.304724700110031, 3.87851223317101, -1.52475169285615, 0.414677792940102, 0.0, -9.46260092820841, -2.07602937339135, 7.32969916135159, -0.761724681099374, 0.0691050664139912, 0.564240504518065, -0.879563899362182, 0.345781182036202, -0.0940400840863373, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584719, 9.059750638547, -0.736662483163207, 0.076556210932115, -0.00694532049720431, -3.48709964663733, -0.0567083043941596, 0.088399497979587, -0.034752316375144, 0.00945138406569224, 0.0, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.52100554373646e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647577, 2.03602754481991, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059443, 0.655663160391216, 3.61359041872289, -1.70346285967311, 0.0, 2.76420265655949, -9.08783875864325, 1.78428514239954, 5.63152770643901, -0.746494073225321, -0.618094504365241, 2.03210252328837, -2.1549427706255, 0.764033484562605, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689787, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392897, -0.124241670058189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, -1.06581410364015e-14, 0.0, 0.0},
      {1.32992762321608, 0.630840061880541, 0.72843135908467, 2.57539376818857, 0.917928424547676, 0.711024300256726, 2.23926008187654, -0.205255035576785, 2.58567482211403, 0.761811750275049, 1.77635683940025e-14, 0.0, 5.34294273196308, 0.0, 4.13862564412655, 2.68954640486928, 1.24344978758018e-14, -1.19471831485578, 3.10562068169857, -2.32269806558127, 0.0, 0.0, 1.35447209004269e-14, 0.0, 1.46549439250521e-14, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403077, -1.51261363209512, 0.763985254692606, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, -1.59872115546023e-14, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313517, -0.105140010313417, 3.27118942773249, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175128, 4.25171145123353, 1.4210854715202e-14, 0.0, -2.50910403565285e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, -6.78263087840207, 3.68560354207934, -0.814411017927949, -2.1316282072803e-14, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219803, -2.1316282072803e-14, 1.06581410364015e-14, 0.0, -7.57008074256672, -2.27270584034422, -0.60665694841585, 6.99294104721298, -1.36261453366201, 0.329650402328141, -0.0728431359084754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084513, 0.22841553125065, 0.0609713174047695, 5.40219154319687, -0.702817019232745, 0.136947913395213, -0.0331311120155262, 0.00732101061700652, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 3.82426463519459, 2.20794021658197, 0.892142571199754, 1.59872115546023e-14, -2.4630604269215, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727937, 0.0, -1.19904086659517e-14, 1.4210854715202e-14, 3.22490309931942, -7.63378455726036, -4.04762275910193, 1.11713920350151, 6.61105135360479, -2.33689608954554, 0.591817792331161, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108411, 0.721929233499938, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297049, -0.096237183808074, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 1.12548859121375e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, -1.46593983227031, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945722, -5.20357020296094, 0.476969600708472, 4.00571020990214, 0.590096844352075, 0.0, 0.0, 1.98729921407903e-14, 1.22124532708767e-14, 6.41153127835567, -6.2499410609466, 0.0, 2.7762744821073, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613679, -2.34333096254029, 0.591780433634507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199775, 0.705300630647563, 0.407205508964006, 2.53385243517952, 0.0, 0.0, 3.47717900165118, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 1.33226762955019e-14, -2.43000064514831e-14, 0.0, 0.0, 8.67405085085773, 1.86517468137026e-14, 0.0, 5.00796559370721, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.72843135908469, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237767, 0.0, 0.0, 2.04281036531029e-14, 0.0, -1.55431223447522e-14, -1.59872115546023e-14, 0.0, 1.23234755733392e-14, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125634, -3.29140294302191, -1.24344978758018e-14, 0.0, 1.77635683940025e-14, 13.4907375632321, 1.83585684909537, 1.29814682728312, -1.4210854715202e-14, 0.0, -2.8421709430404e-14, 0.0, -1.59872115546023e-14, 0.0, -3.53270434653116, -3.05941170815571, -0.416333199893259, -0.294392028877606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839439, 0.307482445914334, 0.0418430609640565, 0.0295875121532903, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {-2.6598552464322, 1.84297022087776e-14, 5.0990195135928, -2.06031501455088, 1.50990331349021e-14, 0.0, 0.0, -1.23153021346074, 9.049861877399, 3.04724700110021, 0.0, 0.0, -2.48689957516035e-14, 1.15463194561016e-14, -2.8421709430404e-14, 3.5527136788005e-14, 3.86988371918333, -3.81689227863023, -5.39683034546922, -1.36674464685443, 0.0, 0.0, 0.0, 0.0, 0.0, 1.46549439250521e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542066, 0.962572311333256, 0.22225025591058, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.82076576038526e-14, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0},
      {2.97380857066589, 1.4210854715202e-14, -0.814411017927924, 5.75875553449895, 0.0, 1.55431223447522e-14, -1.06581410364015e-14, 1.37689263682152, -2.89087233497829, 1.7034628596731, -1.4210854715202e-14, 3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 8.01441409794463, -3.47218947830362, -5.19371076584693, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.46549439250521e-14, 0.0, 0.0, 0.0},
      {-1.03015750727543, 0.0, 0.940400840863422, -2.9258407710754, -1.08801856413265e-14, 1.06581410364015e-14, 0.0, 0.0, 4.63623866886821, -3.80284633026899, -1.06581410364015e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 2.17603712826531e-14, 0.0, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493486, 0.0, 0.0, 3.19744231092045e-14, 0.0, -2.66453525910038e-14, -2.66453525910038e-14, 0.0, 2.1094237467878e-14, 1.06581410364015e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 1.44913767461894, 4.18330013267039, -0.591607978309966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385683, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.06581410364015e-14, -1.0769163338864e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, -2.1316282072803e-14, 8.87411967464942, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.24344978758018e-14, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -1.00000000000001, 1.30930734141595, 7.09929573971953, -0.414039335605414, -2.04939015319192, -0.478091443733756, 0.169030850945708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463868, 3.17542648054294, 9.07114735222144, 2.30926389122033e-14, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, -2.57571741713036e-14, -1.77635683940025e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033672, 4.38178046004134, -0.774596669241498, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818038, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.15463194561016e-14, 0.0, 1.15463194561016e-14, -1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 0.547722557505165, 1.58113883008419, 2.45967477524978, 0.0, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824849, -1.20948631362952, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.77635683940025e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.2609903369994, -1.24344978758018e-14, 3.83405790253616, 1.73194791841524e-14, 0.0, 10.5830052442584, 1.24344978758018e-14, 1.24344978758018e-14, 5.18459255872629, 0.0, 0.0, -1.99840144432528e-14, 1.59872115546023e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, -1.68753899743024e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824835, 0.0755928946018458, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 0.0, 1.46059348668042, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878696, -0.698297248755178, -1.06581410364015e-14, -3.01980662698043e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, -2.48689957516035e-14, -6.26099033699944, 2.21359436211788, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, -1.82076576038526e-14, 1.55431223447522e-14, -2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157676649773, 0.0, 2.30926389122033e-14, -4.69574275274956, 1.46549439250521e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 1.95399252334028e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.50990331349021e-14, 1.97619698383278e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34336985979644e-14, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105602, 2.39356776939084, 6.30376871403132, -0.908295106229245, -2.78313372537744, -0.52440442408507, 0.37080992435478, 1.23603308118261, 9.4017475579201, -0.301561193523235, -2.42752078113805, -0.79420020665698, 0.114434427054264, 0.84091786587209, 0.350641890608836, 0.0660687472643509, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047609, 2.74642624930235, -0.792824967172094, 2.24244764232555, 2.1408720964442, -0.331662479035521, 6.49923072370876, 0.0957427107756468, -1.87616630392937, -2.15580611373102, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932526, 0.590936840285284, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542155127, 1.29756443747036, 3.74574588632199, -1.05945692672796, 0.404586796856352, 5.01426536422406, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264004, 0.0, 2.82521847127452, -0.050973145153439, 8.20651806648289, -0.631738055305783, 0.0483573714561669, -2.84282124887605, -0.227958835180075, 0.139595707137607, -0.0394836284566216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715534, 1.160576914948, 1.34011878852096, 1.89521416591738, 0.361873432227861, 1.96214168703487, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313582, 0.0, -2.49768411251823, -0.998865569685865, 0.441440386136654, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.0050890913907, -0.193429485824662, 3.55615782880924, -8.46157280212811, 1.24344978758018e-14, 4.45964044034301, 0.0, -0.858258202906992, 2.67027285925186, -1.24344978758018e-14, 2.51465515077598e-14, 12.4373429638327, -1.24344978758018e-14, -1.84297022087776e-14, 8.42792824422441, 0.0, 0.0, -1.62195554683795, -2.29379153190451, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 0.335029697130244, 4.06201920231797, -0.820651806648291, 1.32255317808472e-14, 1.69926454679663, -0.0991031208965123, 5.8864250611046, -1.20156148406979, 0.242752078113808, 0.0, -1.59872115546023e-14, 0.0, 4.94413232473044, -0.214087209644422, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704899, -0.0305838870920683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905752, 2.07610309995255, 1.46802658041886, 1.28785870856518e-14, 0.868496237346889, 0.709124208342335, 1.31624465810883, 4.91295663090393, -1.41130638568871, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 3.82970843102537, -0.223353131420174, 0.0, 5.80409338312196, -1.54743588659733, 0.341938252770111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11299858218672e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930757, 0.259512887494068, 0.749149177264346, 2.75458800949269, -1.06581410364015e-14, -8.46157280212809, 1.15147421036811, 0.0, 3.3240197266047, 2.06838446274244, 0.0, -1.4210854715202e-14, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119207, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.9380831519647, 7.62808987244124, 2.57571741713036e-14, 3.11415464992885, 0.0, 0.0, -7.5213980463361, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, -1.95399252334028e-14, -2.48689957516035e-14, 14.2141062443803, 1.62092561595273e-14, 2.08721928629529e-14, 1.95399252334028e-14, 5.80288457473996, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.30451205393456e-14, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577686, 0.0, 2.68023757704197, -0.473803541479342, 0.0, -1.24344978758018e-14, 0.0, 5.09779364038994, -0.792824967172089, 0.140152977645354, 0.0, -1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933262, 0.0998865569686025, -0.0176576154454686, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205085, 0.0, 1.49829835452879, 0.847565541382361, 1.4210854715202e-14, -1.4210854715202e-14, -1.33226762955019e-14, 1.62843044502544, 3.54562104171168, -0.814818121686415, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.197418142283062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071078, 0.0, 0.69203436665088, 1.59036212878712, 0.0, 1.15463194561016e-14, 0.0, -8.46157280212813, 3.07059789431495, 1.19418232635198, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 12.4373429638327, 5.80288457473995, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309059, 1.59872115546023e-14, 7.62808987244128, 1.79795802543455, 0.0, 2.30926389122033e-14, 1.59872115546023e-14, 1.33226762955019e-14, -7.52139804633612, 3.1910589375405, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.81441536742477e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, 0.0, 0.0, 0.0},
      {-5.36159180343549, -1.24344978758018e-14, 0.0, 8.89943818451479, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412045, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497829, -0.393397896234718, 0.556348640264176, 2.33666428910957, 9.02784807228865, -0.732969916135162, -3.93352933905727, -1.19859611757308, 0.30904725218262, 1.64018416088946, 0.655588223176228, 0.0892142571199872, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.234843597212093, -2.44096975264614, -0.907332870306512, 0.0736662483163206, 0.810328731479523, 0.395334573318414, 0.120463442338386, -0.0310604175145457, -0.311895674167864, -0.164844710568319, -0.0658890955530742, -0.0089663702065863, 0.012680362351408, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862702, 1.54523626091313, 2.9504842217604, -0.76181175027506, 5.59815020469135, 0.263899331455869, -1.93925611658552, -2.28543525082518, 2.13307290077016, -0.257539376818832, 9.14446135479766, 0.0664963811608024, -2.36108976914458, -3.33842298506509, -0.0230350221379972, 0.817905488277895, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776446, 0.595437196138647, 0.0, -0.125015768949701, -0.192474367616164, -0.206265495285701, -0.166687691932942, 0.0, 1.11022302462516e-14, 0.0, 0.0, 1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331889, 1.82834820066016, 2.99085908983326, -1.24403337882029, 0.950146187582627, 5.7406445631131, -0.721110255092791, -0.169967317119749, -1.17961073303081, 0.490653381462662, 0.2943920288776, 4.97613351528119, -0.215472901842842, 5.78174466995659, -1.30185581821822, 0.163532434528638, -3.22682211353226, 0.0385449644663596, 0.267510569439606, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532871, 10.7636648722209, -0.500120235663633, 0.0216558414515711, -3.57321383950879, -0.581087203147982, 0.130841432732456, -0.0164356280722646, 1.37533064807501, 0.324307824721457, -0.00387391468765269, -0.026885823826833, 0.0111830284386755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637246, 1.66904592079257, 0.963624111659423, 1.3627702877385, 0.867360833110901, 2.28430636201795, 2.96226264871972, -1.00852844760551, 1.71026313764872, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760392, -0.52779866291172, 7.07977053255618, -1.76652739792483, 0.182834820066033, -3.12574097035512, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.4585173044132, 0.0, 11.0940489487798, -0.632607619454902, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468091, 0.0, 0.992281903807268, 0.735567892896455, 0.181909068193166, -0.147004726489969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458434, -0.430945803685661, 3.0472470011002, 0.775791113542718, -0.120185042515475, 5.29905651979671, 0.0346944333244363, -1.52970585407783, 0.901387818865992, -10.576283741361, 0.0, 4.5156107826894, -1.22124532708767e-14, -0.69955541437245, 6.36462844462227, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847887, 0.903959543974638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186566, -1.05140010313427, 0.160604018609909, 3.35889012281481, -0.304724700110031, 3.87851223317101, -1.52475169285614, 0.414677792940092, 0.0, 1.135512111385, -0.0364215679542204, 7.32969916135161, -0.761724681099359, 0.0691050664139866, 0.564240504518043, -0.879563899362173, 0.345781182036198, -0.0940400840863459, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162682, 0.00366050530850104, 9.05975063854701, -0.736662483163208, 0.0765562109321067, -0.00694532049720686, -3.48709964663733, -0.0567083043941579, 0.0883994979795846, -0.0347523163751422, 0.00945138406568935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533297, 0.705300630647568, 2.03602754481989, 1.15175110689979, 0.146610739697711, 1.81702705031798, 1.25178444059442, 0.655663160391207, 3.61359041872287, -1.70346285967311, 1.77635683940025e-14, 0.614267257013228, 0.454391937932165, 1.78428514239953, 5.63152770643898, -0.746494073225319, -0.618094504365247, 2.03210252328835, -2.15494277062553, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231201, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689785, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392903, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880552, 0.728431359084704, 2.57539376818857, 0.131132632078242, 0.711024300256739, 2.23926008187653, -0.205255035576781, 2.58567482211402, 0.761811750275054, 1.24344978758018e-14, -10.576283741361, 0.763277533137574, 0.0, 4.13862564412657, 2.68954640486932, 3.33066907387547e-14, -1.19471831485576, 3.10562068169861, -2.32269806558128, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131698, -1.30996183150502, 0.0, 1.24344978758018e-14, -2.88176900403077, -1.51261363209513, 0.763985254692614, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0},
      {1.1517511068998, 0.546323519313524, -0.105140010313417, 3.27118942773248, 9.65295620481433, -1.26565424807268e-14, 2.69341127303543, 0.0, -0.518347241175116, 4.25171145123353, 2.22044604925031e-14, 0.0, -9.91526600752599, 0.0, -2.30926389122033e-14, 6.71889089790563, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801237611, 0.199489143482413, 3.68560354207934, -0.814411017927955, 0.0, 1.02786571910339, -0.0786795792469475, 6.00856531485323, -1.45362164025439, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.233098034907112, 0.0178428514239979, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744266, -0.00179327404131646, 5.40219154319687, -0.702817019232744, 0.136947913395217, -0.0331311120155253, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689976, 0.18210783977116, 2.20794021658199, 0.892142571199753, -2.1316282072803e-14, 0.615765106730376, 0.323209352764229, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 2.68673971959288e-14, 1.07496769977314, 1.90844613931509, -0.19274394090961, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331153, 0.0, 0.0, 0.0, 0.0, -1.08801856413265e-14, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771034, 0.0343775825476146, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.67643676718399e-14, -1.13242748511766e-14, 0.0, 0.0},
      {1.03015750727543, 0.162882203585586, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987769, 0.578174466995669, 0.476969600708461, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.24344978758018e-14, -10.576283741361, 1.83186607953018, 0.694437895660716, 0.0, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634509, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257119979, 0.141060126129501, 0.407205508964017, 2.53385243517953, 0.0, 9.65295620481434, 0.695435800330237, 1.4210854715202e-14, 2.00755023262382, 3.29336152870135, 0.0, 1.59872115546023e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 3.9190872769268e-14, 2.69784194983913e-14, 5.00796559370721, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574686, 2.44096975264613, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.40998324127395e-14, 0.0, 1.36557432028894e-14, 0.0, 0.0, -1.33226762955019e-14},
      {0.728431359084686, -7.94708263760855, -1.25455201782643e-14, 2.53908227033119, -1.77635683940025e-14, -1.77635683940025e-14, 10.2207771580387, -1.50990331349021e-14, -1.06581410364015e-14, 5.00713776237769, 0.0, 1.46549439250521e-14, 0.0, 0.0, -1.24344978758018e-14, -8.49879943502226, -2.48689957516035e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.72843135908467, 0.0, 2.32737334062816, -0.470200420431697, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547688, 0.185449546754729, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 0.0, -2.1316282072803e-14, 0.0, 7.06540869306229, -1.01980390271858, 0.208166599946608, -0.0420560041253615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678875, 0.102494148638112, -0.0209215304820314, 0.004226787450472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608014, 4.9737991503207e-14, 1.45686271816939, 0.515078753637706, 0.0, 1.59872115546023e-14, 1.06581410364015e-14, 1.84729532019113, 2.58567482211398, -0.761811750275052, 1.4210854715202e-14, 3.01980662698043e-14, -1.77635683940025e-14, 0.0, 0.0, 2.08721928629529e-14, 1.71994831963704, 5.7253384179452, -1.54195152727693, 0.341686161713616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380929, -0.0555625639776334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.95399252334028e-14, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14},
      {0.594761714133166, 0.0, 0.814411017927977, 1.15175110689978, 0.0, 2.26485497023532e-14, 0.0, 0.59009684435208, 2.89087233497829, 0.340692571934619, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -10.576283741361, 3.4347488991191, 3.47218947830368, -1.03874215316939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637714, 0.0, 0.376160336345356, 1.46292038553768, 0.0, 0.0, 1.15463194561016e-14, 9.65295620481434, 1.85449546754729, 1.90142316513447, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, -9.91526600752598, 4.62616045379079, 0.817797356933092, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029894, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14},
      {0.420560041253717, -1.55431223447522e-14, -7.94708263760857, 1.46593983227029, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0, -8.49879943502225, 4.00637247496572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.22124532708767e-14, 0.0, -1.77635683940025e-14},
      {6.542378855465, 0.0, -1.19904086659517e-14, -6.91050664139872, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, 0.0, 0.0, 3.19744231092045e-14, 0.0, -4.9737991503207e-14, -2.30926389122033e-14, 0.0, 1.75415237890775e-14, 0.0, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.17603712826531e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 2.57571741713036e-14, 1.15463194561016e-14, 1.95399252334028e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, 0.0374718748311399, -0.0289614183593723, 0.0, 0.0, 0.0, 0.0284137877911448, 0.0051555023517057, -0.00619733414463434, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0315656565656566, -0.0113902751970807, 0.00265717735835493, -0.00018789081289078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0232239260383337, -0.00166176887443654, -0.00647610327216137, 0.00646276421933344, -0.00290809553026389, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213629048496074, -0.0277928188745204, 0.0243701532779658, -0.0157219925555703, 0.00607967912880132};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.91485421551272, 1.29756443747036, 3.74574588632197, -1.05945692672796, -8.09173593712687, 5.01426536422406, -0.383824736789365, 1.80936716113938, -1.10800657553489, 0.313391585264003, 0.0, 12.7134831207354, 1.01946290306868, 8.20651806648289, -0.631738055305789, 0.04835737145617, -2.84282124887606, -0.227958835180083, 0.139595707137603, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715533, 1.16057691494798, 1.34011878852097, 1.89521416591737, 2.5331140255951, 1.96214168703486, 2.74642624930237, -0.566421515598876, 3.17129986868837, -1.82198870938952, 0.0, 0.0, 11.1699829238239, -1.06581410364015e-14, 8.65223156827827, -0.865042958313609, 1.08801856413265e-14, -2.49768411251822, -0.998865569685867, 0.441440386136639, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880925, 0.0, 1.02140518265514e-14, 4.45964044034302, 0.0, -0.858258202906989, 2.67027285925187, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741912, 7.03562363973514, 4.06201920231799, -0.820651806648291, 1.06581410364015e-14, -6.79705818718657, -2.08116553882675, 5.8864250611046, -1.20156148406979, 0.24275207811381, 1.06581410364015e-14, -2.48689957516035e-14, 1.02140518265514e-14, 14.8323969741913, 0.856348838577658, 0.262202212042542, 5.13809303146606, -0.741619848709565, 0.151382517704904, -0.0305838870920609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508101, 1.31624465810883, 4.91295663090392, -1.4113063856887, 0.0, 0.0, 0.0, 0.0, 13.4039795085888, 2.01017818278146, 0.0, 5.80409338312193, -1.54743588659734, 0.341938252770115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747033, 0.749149177264371, 2.75458800949269, 1.22124532708767e-14, 1.4210854715202e-14, 5.75737105184055, 0.0, 3.3240197266047, 2.06838446274243, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, -1.33226762955019e-14, -2.1316282072803e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119207, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {0.93808315196469, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03805852802452e-14, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431071, 0.0, 9.38083151964686, 1.89521416591739, 1.24344978758018e-14, 0.0, -1.24344978758018e-14, -3.39852909359329, -2.77488738510234, -0.560611910581393, 1.77635683940025e-14, 2.8421709430404e-14, 0.0, 0.0, -2.1316282072803e-14, 1.50990331349021e-14, 17.7988763690296, 0.428174419288831, 0.349602949390069, 0.0706304617818787, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452875, 4.23782770691181, 0.0, 0.0, -1.95399252334028e-14, 3.79967103839268, -3.54562104171166, -4.07409060843206, 0.0, 0.0, 2.1316282072803e-14, 0.0, 2.14828155264968e-14, 1.77635683940025e-14, 1.46549439250521e-14, 16.7549743857359, 1.11676565710086, 0.98709071141532, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.28705943072782e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.99840144432528e-14, -1.13242748511766e-14, 1.15463194561016e-14, 0.0},
      {-1.32664991614216, 0.0, 1.73008591662711, -3.18072425757421, 0.0, 0.0, 1.4210854715202e-14, 0.0, 7.67649473578738, -2.38836465270398, -1.06581410364015e-14, 0.0, 4.2632564145606e-14, 0.0, -3.19744231092045e-14, -3.19744231092045e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662072, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {1.6248076809272, 0.0, 1.4210854715202e-14, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.82076576038526e-14, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069939, 0.997445717412047, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.36277028773848, -2.89087233497829, -0.393397896234719, 0.556348640264175, 2.33666428910958, 9.02784807228867, -0.732969916135149, -3.93352933905728, -1.19859611757306, 0.309047252182628, 1.64018416088946, 0.655588223176224, 0.0892142571199703, -0.126168012376113, 13.0996183150502, 11.55277744383, -0.234843597212095, -2.44096975264614, -0.907332870306509, 0.0736662483163242, 0.810328731479522, 0.395334573318414, 0.120463442338384, -0.0310604175145466, -0.311895674167857, -0.164844710568314, -0.0658890955530749, -0.00896637020657787, 0.0126803623514049, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940279, -1.09264703862703, 1.54523626091314, 2.95048422176041, -0.761811750275053, 5.59815020469135, 0.263899331455872, -1.93925611658551, -2.28543525082518, 2.13307290077015, -0.257539376818858, 9.14446135479764, 0.066496381160809, -2.36108976914459, -3.33842298506509, -0.023035022137996, 0.817905488277898, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.36088943928029, 0.555625639776449, 0.595437196138647, 0.0, -0.125015768949707, -0.192474367616162, -0.206265495285709, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331885, 1.82834820066015, 2.99085908983324, -1.24403337882029, 0.950146187582622, 5.74064456311311, -0.721110255092795, -0.169967317119746, -1.17961073303081, 0.490653381462657, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.7817446699566, -1.30185581821822, 0.163532434528627, -3.22682211353226, 0.0385449644663671, 0.267510569439609, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663638, 0.0216558414515706, -3.5732138395088, -0.581087203147983, 0.130841432732457, -0.016435628072264, 1.37533064807501, 0.324307824721451, -0.00387391468765164, -0.0268858238268332, 0.0111830284386736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637252, 1.66904592079258, 0.963624111659448, 1.36277028773848, 0.867360833110894, 2.28430636201792, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707465, 2.41867732448956, 2.04415543160772, 2.68821895760393, -0.527798662911731, 7.07977053255618, -1.76652739792481, 0.182834820066031, -3.12574097035514, -1.01990506872272, 0.904016610326397, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.86447112137561, -1.66605356688628, 0.315075748468086, 0.0, 0.992281903807271, 0.735567892896452, 0.18190906819316, -0.14700472648997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458432, -0.430945803685661, 3.04724700110021, 0.775791113542723, -0.120185042515454, 5.29905651979671, 0.0346944333244444, -1.52970585407782, 0.901387818865999, -1.04360964314765e-14, 1.06581410364015e-14, 4.5156107826894, 0.0, -0.699555414372449, 6.36462844462226, 0.0, 0.201944253400486, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 1.4210854715202e-14, 0.0, 1.11022302462516e-14, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980282, 0.894874292847889, 0.903959543974644, 0.0, 0.0, 0.0, 0.0, -1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14},
      {1.62882203585589, 0.772618130456562, 3.86595114186569, -1.05140010313426, 9.1544290607646, 3.3588901228148, -0.304724700110031, 3.87851223317101, -1.52475169285615, 0.414677792940102, 0.0, -9.46260092820841, -2.07602937339135, 7.32969916135159, -0.761724681099374, 0.0691050664139912, 0.564240504518065, -0.879563899362182, 0.345781182036202, -0.0940400840863373, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355639, 0.208648802584719, 9.059750638547, -0.736662483163207, 0.076556210932115, -0.00694532049720431, -3.48709964663733, -0.0567083043941596, 0.088399497979587, -0.034752316375144, 0.00945138406569224, 0.0, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.52100554373646e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647577, 2.03602754481991, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059443, 0.655663160391216, 3.61359041872289, -1.70346285967311, 0.0, 2.76420265655949, -9.08783875864325, 1.78428514239954, 5.63152770643901, -0.746494073225321, -0.618094504365241, 2.03210252328837, -2.1549427706255, 0.764033484562605, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689787, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392897, -0.124241670058189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, -1.06581410364015e-14, 0.0, 0.0},
      {1.32992762321608, 0.630840061880541, 0.72843135908467, 2.57539376818857, 0.917928424547676, 0.711024300256726, 2.23926008187654, -0.205255035576785, 2.58567482211403, 0.761811750275049, 1.77635683940025e-14, 0.0, 5.34294273196308, 0.0, 4.13862564412655, 2.68954640486928, 1.24344978758018e-14, -1.19471831485578, 3.10562068169857, -2.32269806558127, 0.0, 0.0, 1.35447209004269e-14, 0.0, 1.46549439250521e-14, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403077, -1.51261363209512, 0.763985254692606, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.73194791841524e-14, -1.59872115546023e-14, -1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313517, -0.105140010313417, 3.27118942773249, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175128, 4.25171145123353, 1.4210854715202e-14, 0.0, -2.50910403565285e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, -6.78263087840207, 3.68560354207934, -0.814411017927949, -2.1316282072803e-14, 10.0216907612581, 2.6751056943961, 6.00856531485323, -1.45362164025438, 0.321208037219803, -2.1316282072803e-14, 1.06581410364015e-14, 0.0, -7.57008074256672, -2.27270584034422, -0.60665694841585, 6.99294104721298, -1.36261453366201, 0.329650402328141, -0.0728431359084754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084513, 0.22841553125065, 0.0609713174047695, 5.40219154319687, -0.702817019232745, 0.136947913395213, -0.0331311120155262, 0.00732101061700652, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689979, 3.82426463519459, 2.20794021658197, 0.892142571199754, 1.59872115546023e-14, -2.4630604269215, 6.78739640804926, 2.13307290077016, 3.91870514328394, -1.31949665727937, 0.0, -1.19904086659517e-14, 1.4210854715202e-14, 3.22490309931942, -7.63378455726036, -4.04762275910193, 1.11713920350151, 6.61105135360479, -2.33689608954554, 0.591817792331161, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108411, 0.721929233499938, 0.0, 6.06294257990891, -1.55575179137407, 0.416806037297049, -0.096237183808074, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 1.12548859121375e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, -1.46593983227031, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945722, -5.20357020296094, 0.476969600708472, 4.00571020990214, 0.590096844352075, 0.0, 0.0, 1.98729921407903e-14, 1.22124532708767e-14, 6.41153127835567, -6.2499410609466, 0.0, 2.7762744821073, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613679, -2.34333096254029, 0.591780433634507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199775, 0.705300630647563, 0.407205508964006, 2.53385243517952, 0.0, 0.0, 3.47717900165118, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 1.33226762955019e-14, -2.43000064514831e-14, 0.0, 0.0, 8.67405085085773, 1.86517468137026e-14, 0.0, 5.00796559370721, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.72843135908469, 0.0, 0.0, 2.5390822703312, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237767, 0.0, 0.0, 2.04281036531029e-14, 0.0, -1.55431223447522e-14, -1.59872115546023e-14, 0.0, 1.23234755733392e-14, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125634, -3.29140294302191, -1.24344978758018e-14, 0.0, 1.77635683940025e-14, 13.4907375632321, 1.83585684909537, 1.29814682728312, -1.4210854715202e-14, 0.0, -2.8421709430404e-14, 0.0, -1.59872115546023e-14, 0.0, -3.53270434653116, -3.05941170815571, -0.416333199893259, -0.294392028877606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839439, 0.307482445914334, 0.0418430609640565, 0.0295875121532903, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0},
      {-2.6598552464322, 1.84297022087776e-14, 5.0990195135928, -2.06031501455088, 1.50990331349021e-14, 0.0, 0.0, -1.23153021346074, 9.049861877399, 3.04724700110021, 0.0, 0.0, -2.48689957516035e-14, 1.15463194561016e-14, -2.8421709430404e-14, 3.5527136788005e-14, 3.86988371918333, -3.81689227863023, -5.39683034546922, -1.36674464685443, 0.0, 0.0, 0.0, 0.0, 0.0, 1.46549439250521e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542066, 0.962572311333256, 0.22225025591058, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.82076576038526e-14, 0.0, -1.06581410364015e-14, 0.0, 1.4210854715202e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0},
      {2.97380857066589, 1.4210854715202e-14, -0.814411017927924, 5.75875553449895, 0.0, 1.55431223447522e-14, -1.06581410364015e-14, 1.37689263682152, -2.89087233497829, 1.7034628596731, -1.4210854715202e-14, 3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 8.01441409794463, -3.47218947830362, -5.19371076584693, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 1.46549439250521e-14, 0.0, 0.0, 0.0},
      {-1.03015750727543, 0.0, 0.940400840863422, -2.9258407710754, -1.08801856413265e-14, 1.06581410364015e-14, 0.0, 0.0, 4.63623866886821, -3.80284633026899, -1.06581410364015e-14, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 2.17603712826531e-14, 0.0, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059783, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681097, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67261700493486, 0.0, 0.0, 3.19744231092045e-14, 0.0, -2.66453525910038e-14, -2.66453525910038e-14, 0.0, 2.1094237467878e-14, 1.06581410364015e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32116539930394e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 1.44913767461894, 4.18330013267039, -0.591607978309966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338696, 7.09929573971953, 0.0, 4.34741302385683, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.06581410364015e-14, -1.0769163338864e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531991, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, -2.1316282072803e-14, 8.87411967464942, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.24344978758018e-14, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772446, 2.44948974278318, 2.82842712474621, -1.00000000000001, 1.30930734141595, 7.09929573971953, -0.414039335605414, -2.04939015319192, -0.478091443733756, 0.169030850945708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463868, 3.17542648054294, 9.07114735222144, 2.30926389122033e-14, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, -2.57571741713036e-14, -1.77635683940025e-14, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033672, 4.38178046004134, -0.774596669241498, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818038, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 1.15463194561016e-14, 0.0, 1.15463194561016e-14, -1.53210777398272e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681201, 0.547722557505165, 1.58113883008419, 2.45967477524978, 0.0, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824849, -1.20948631362952, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.77635683940025e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.2609903369994, -1.24344978758018e-14, 3.83405790253616, 1.73194791841524e-14, 0.0, 10.5830052442584, 1.24344978758018e-14, 1.24344978758018e-14, 5.18459255872629, 0.0, 0.0, -1.99840144432528e-14, 1.59872115546023e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, -1.68753899743024e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824835, 0.0755928946018458, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 0.0, 1.46059348668042, 1.42009389360939, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878696, -0.698297248755178, -1.06581410364015e-14, -3.01980662698043e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, -2.48689957516035e-14, -6.26099033699944, 2.21359436211788, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, -1.82076576038526e-14, 1.55431223447522e-14, -2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157676649773, 0.0, 2.30926389122033e-14, -4.69574275274956, 1.46549439250521e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 12.69960629311, 0.0, 1.95399252334028e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.50990331349021e-14, 1.97619698383278e-14, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34336985979644e-14, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105602, 2.39356776939084, 6.30376871403132, -0.908295106229245, -2.78313372537744, -0.52440442408507, 0.37080992435478, 1.23603308118261, 9.4017475579201, -0.301561193523235, -2.42752078113805, -0.79420020665698, 0.114434427054264, 0.84091786587209, 0.350641890608836, 0.0660687472643509, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047609, 2.74642624930235, -0.792824967172094, 2.24244764232555, 2.1408720964442, -0.331662479035521, 6.49923072370876, 0.0957427107756468, -1.87616630392937, -2.15580611373102, 11.0554159678513, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932526, 0.590936840285284, 0.522319308773341, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542155127, 1.29756443747036, 3.74574588632199, -1.05945692672796, 0.404586796856352, 5.01426536422406, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264004, 0.0, 2.82521847127452, -0.050973145153439, 8.20651806648289, -0.631738055305783, 0.0483573714561669, -2.84282124887605, -0.227958835180075, 0.139595707137607, -0.0394836284566216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715534, 1.160576914948, 1.34011878852096, 1.89521416591738, 0.361873432227861, 1.96214168703487, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827827, -0.865042958313582, 0.0, -2.49768411251823, -0.998865569685865, 0.441440386136654, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.0050890913907, -0.193429485824662, 3.55615782880924, -8.46157280212811, 1.24344978758018e-14, 4.45964044034301, 0.0, -0.858258202906992, 2.67027285925186, -1.24344978758018e-14, 2.51465515077598e-14, 12.4373429638327, -1.24344978758018e-14, -1.84297022087776e-14, 8.42792824422441, 0.0, 0.0, -1.62195554683795, -2.29379153190451, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 0.335029697130244, 4.06201920231797, -0.820651806648291, 1.32255317808472e-14, 1.69926454679663, -0.0991031208965123, 5.8864250611046, -1.20156148406979, 0.242752078113808, 0.0, -1.59872115546023e-14, 0.0, 4.94413232473044, -0.214087209644422, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704899, -0.0305838870920683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905752, 2.07610309995255, 1.46802658041886, 1.28785870856518e-14, 0.868496237346889, 0.709124208342335, 1.31624465810883, 4.91295663090393, -1.41130638568871, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 3.82970843102537, -0.223353131420174, 0.0, 5.80409338312196, -1.54743588659733, 0.341938252770111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11299858218672e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930757, 0.259512887494068, 0.749149177264346, 2.75458800949269, -1.06581410364015e-14, -8.46157280212809, 1.15147421036811, 0.0, 3.3240197266047, 2.06838446274244, 0.0, -1.4210854715202e-14, 0.0, 0.0, 12.4373429638327, 2.17608171552749, 0.0, 0.0, 6.28180682119207, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.9380831519647, 7.62808987244124, 2.57571741713036e-14, 3.11415464992885, 0.0, 0.0, -7.5213980463361, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, -1.95399252334028e-14, -2.48689957516035e-14, 14.2141062443803, 1.62092561595273e-14, 2.08721928629529e-14, 1.95399252334028e-14, 5.80288457473996, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.30451205393456e-14, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577686, 0.0, 2.68023757704197, -0.473803541479342, 0.0, -1.24344978758018e-14, 0.0, 5.09779364038994, -0.792824967172089, 0.140152977645354, 0.0, -1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933262, 0.0998865569686025, -0.0176576154454686, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205085, 0.0, 1.49829835452879, 0.847565541382361, 1.4210854715202e-14, -1.4210854715202e-14, -1.33226762955019e-14, 1.62843044502544, 3.54562104171168, -0.814818121686415, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.06581410364015e-14, 0.0, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.197418142283062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071078, 0.0, 0.69203436665088, 1.59036212878712, 0.0, 1.15463194561016e-14, 0.0, -8.46157280212813, 3.07059789431495, 1.19418232635198, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 12.4373429638327, 5.80288457473995, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309059, 1.59872115546023e-14, 7.62808987244128, 1.79795802543455, 0.0, 2.30926389122033e-14, 1.59872115546023e-14, 1.33226762955019e-14, -7.52139804633612, 3.1910589375405, 0.0, 1.24344978758018e-14, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.81441536742477e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.36557432028894e-14, 0.0, 0.0, 0.0},
      {-5.36159180343549, -1.24344978758018e-14, 0.0, 8.89943818451479, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243528, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0},
      {2.41593350361254, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857107, -2.25989885993661, 1.06532653910462, 0.869835476750488, 0.615066564126903, 10.333118277332, -2.18326971917503, -1.8907670401189, 0.724780051083751, 0.627677936394718, 0.512496888990052, -0.278967971730977, -0.241593350361241, -0.197260144544831, -0.13948398586549, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731329, 0.21942686286813, 0.190029237516522, -0.0814411017927927, -0.0728431359084656, -0.063084006188056, -0.0515078753637666, 0.0313466946954433, 0.02803733608358, 0.0242810453028187, 0.0198253904711077, 0.0140186680417866, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412045, -1.41060126129509, 3.23209352764251, 5.28531208250979, -1.36277028773849, -2.89087233497829, -0.393397896234718, 0.556348640264176, 2.33666428910957, 9.02784807228865, -0.732969916135162, -3.93352933905727, -1.19859611757308, 0.30904725218262, 1.64018416088946, 0.655588223176228, 0.0892142571199872, -0.126168012376106, 1.1908743922773, 11.55277744383, -0.234843597212093, -2.44096975264614, -0.907332870306512, 0.0736662483163206, 0.810328731479523, 0.395334573318414, 0.120463442338386, -0.0310604175145457, -0.311895674167864, -0.164844710568319, -0.0658890955530742, -0.0089663702065863, 0.012680362351408, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862702, 1.54523626091313, 2.9504842217604, -0.76181175027506, 5.59815020469135, 0.263899331455869, -1.93925611658552, -2.28543525082518, 2.13307290077016, -0.257539376818832, 9.14446135479766, 0.0664963811608024, -2.36108976914458, -3.33842298506509, -0.0230350221379972, 0.817905488277895, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776446, 0.595437196138647, 0.0, -0.125015768949701, -0.192474367616164, -0.206265495285701, -0.166687691932942, 0.0, 1.11022302462516e-14, 0.0, 0.0, 1.48769885299771e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331889, 1.82834820066016, 2.99085908983326, -1.24403337882029, 0.950146187582627, 5.7406445631131, -0.721110255092791, -0.169967317119749, -1.17961073303081, 0.490653381462662, 0.2943920288776, 4.97613351528119, -0.215472901842842, 5.78174466995659, -1.30185581821822, 0.163532434528638, -3.22682211353226, 0.0385449644663596, 0.267510569439606, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532871, 10.7636648722209, -0.500120235663633, 0.0216558414515711, -3.57321383950879, -0.581087203147982, 0.130841432732456, -0.0164356280722646, 1.37533064807501, 0.324307824721457, -0.00387391468765269, -0.026885823826833, 0.0111830284386755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637246, 1.66904592079257, 0.963624111659423, 1.3627702877385, 0.867360833110901, 2.28430636201795, 2.96226264871972, -1.00852844760551, 1.71026313764872, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760392, -0.52779866291172, 7.07977053255618, -1.76652739792483, 0.182834820066033, -3.12574097035512, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.4585173044132, 0.0, 11.0940489487798, -0.632607619454902, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468091, 0.0, 0.992281903807268, 0.735567892896455, 0.181909068193166, -0.147004726489969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458434, -0.430945803685661, 3.0472470011002, 0.775791113542718, -0.120185042515475, 5.29905651979671, 0.0346944333244363, -1.52970585407783, 0.901387818865992, -10.576283741361, 0.0, 4.5156107826894, -1.22124532708767e-14, -0.69955541437245, 6.36462844462227, 0.0, 0.201944253400485, -1.83730997289732, -2.74825341360598, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847887, 0.903959543974638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456571, 3.86595114186566, -1.05140010313427, 0.160604018609909, 3.35889012281481, -0.304724700110031, 3.87851223317101, -1.52475169285614, 0.414677792940092, 0.0, 1.135512111385, -0.0364215679542204, 7.32969916135161, -0.761724681099359, 0.0691050664139866, 0.564240504518043, -0.879563899362173, 0.345781182036198, -0.0940400840863459, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162682, 0.00366050530850104, 9.05975063854701, -0.736662483163208, 0.0765562109321067, -0.00694532049720686, -3.48709964663733, -0.0567083043941579, 0.0883994979795846, -0.0347523163751422, 0.00945138406568935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533297, 0.705300630647568, 2.03602754481989, 1.15175110689979, 0.146610739697711, 1.81702705031798, 1.25178444059442, 0.655663160391207, 3.61359041872287, -1.70346285967311, 1.77635683940025e-14, 0.614267257013228, 0.454391937932165, 1.78428514239953, 5.63152770643898, -0.746494073225319, -0.618094504365247, 2.03210252328835, -2.15494277062553, 0.764033484562615, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865873, -0.106930204231201, 0.0, 9.68367982311022, -1.32524448062077, 0.133143804689785, 0.0, -3.3545250915713, -0.478206411017784, 0.384353057392903, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880552, 0.728431359084704, 2.57539376818857, 0.131132632078242, 0.711024300256739, 2.23926008187653, -0.205255035576781, 2.58567482211402, 0.761811750275054, 1.24344978758018e-14, -10.576283741361, 0.763277533137574, 0.0, 4.13862564412657, 2.68954640486932, 3.33066907387547e-14, -1.19471831485576, 3.10562068169861, -2.32269806558128, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131698, -1.30996183150502, 0.0, 1.24344978758018e-14, -2.88176900403077, -1.51261363209513, 0.763985254692614, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0},
      {1.1517511068998, 0.546323519313524, -0.105140010313417, 3.27118942773248, 9.65295620481433, -1.26565424807268e-14, 2.69341127303543, 0.0, -0.518347241175116, 4.25171145123353, 2.22044604925031e-14, 0.0, -9.91526600752599, 0.0, -2.30926389122033e-14, 6.71889089790563, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264586, -2.94058061635794, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801237611, 0.199489143482413, 3.68560354207934, -0.814411017927955, 0.0, 1.02786571910339, -0.0786795792469475, 6.00856531485323, -1.45362164025439, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.233098034907112, 0.0178428514239979, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744266, -0.00179327404131646, 5.40219154319687, -0.702817019232744, 0.136947913395217, -0.0331311120155253, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0},
      {1.15175110689976, 0.18210783977116, 2.20794021658199, 0.892142571199753, -2.1316282072803e-14, 0.615765106730376, 0.323209352764229, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 2.68673971959288e-14, 1.07496769977314, 1.90844613931509, -0.19274394090961, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331153, 0.0, 0.0, 0.0, 0.0, -1.08801856413265e-14, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771034, 0.0343775825476146, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.67643676718399e-14, -1.13242748511766e-14, 0.0, 0.0},
      {1.03015750727543, 0.162882203585586, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987769, 0.578174466995669, 0.476969600708461, 4.00571020990214, 0.590096844352074, 0.0, 0.0, 1.24344978758018e-14, -10.576283741361, 1.83186607953018, 0.694437895660716, 0.0, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, -1.06581410364015e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634509, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257119979, 0.141060126129501, 0.407205508964017, 2.53385243517953, 0.0, 9.65295620481434, 0.695435800330237, 1.4210854715202e-14, 2.00755023262382, 3.29336152870135, 0.0, 1.59872115546023e-14, 0.0, 0.0, -9.91526600752598, 1.73481017017153, 3.9190872769268e-14, 2.69784194983913e-14, 5.00796559370721, 1.41646657250368, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574686, 2.44096975264613, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.40998324127395e-14, 0.0, 1.36557432028894e-14, 0.0, 0.0, -1.33226762955019e-14},
      {0.728431359084686, -7.94708263760855, -1.25455201782643e-14, 2.53908227033119, -1.77635683940025e-14, -1.77635683940025e-14, 10.2207771580387, -1.50990331349021e-14, -1.06581410364015e-14, 5.00713776237769, 0.0, 1.46549439250521e-14, 0.0, 0.0, -1.24344978758018e-14, -8.49879943502226, -2.48689957516035e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.72843135908467, 0.0, 2.32737334062816, -0.470200420431697, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547688, 0.185449546754729, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 0.0, -2.1316282072803e-14, 0.0, 7.06540869306229, -1.01980390271858, 0.208166599946608, -0.0420560041253615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678875, 0.102494148638112, -0.0209215304820314, 0.004226787450472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608014, 4.9737991503207e-14, 1.45686271816939, 0.515078753637706, 0.0, 1.59872115546023e-14, 1.06581410364015e-14, 1.84729532019113, 2.58567482211398, -0.761811750275052, 1.4210854715202e-14, 3.01980662698043e-14, -1.77635683940025e-14, 0.0, 0.0, 2.08721928629529e-14, 1.71994831963704, 5.7253384179452, -1.54195152727693, 0.341686161713616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.34732057331309, 0.275020660380929, -0.0555625639776334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.95399252334028e-14, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14},
      {0.594761714133166, 0.0, 0.814411017927977, 1.15175110689978, 0.0, 2.26485497023532e-14, 0.0, 0.59009684435208, 2.89087233497829, 0.340692571934619, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -10.576283741361, 3.4347488991191, 3.47218947830368, -1.03874215316939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637714, 0.0, 0.376160336345356, 1.46292038553768, 0.0, 0.0, 1.15463194561016e-14, 9.65295620481434, 1.85449546754729, 1.90142316513447, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, -9.91526600752598, 4.62616045379079, 0.817797356933092, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372302, -1.31506763029894, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, -1.59872115546023e-14},
      {0.420560041253717, -1.55431223447522e-14, -7.94708263760857, 1.46593983227029, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 0.0, 0.0, 0.0, 2.30926389122033e-14, 0.0, -1.15463194561016e-14, 0.0, -8.49879943502225, 4.00637247496572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.22124532708767e-14, 0.0, -1.77635683940025e-14},
      {6.542378855465, 0.0, -1.19904086659517e-14, -6.91050664139872, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, 0.0, 0.0, 3.19744231092045e-14, 0.0, -4.9737991503207e-14, -2.30926389122033e-14, 0.0, 1.75415237890775e-14, 0.0, -5.66586629001479, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.17603712826531e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.86517468137026e-14, 2.57571741713036e-14, 1.15463194561016e-14, 1.95399252334028e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0, -0.028757485335526, 0.0536094339843701, 0.0, 0.0, 0.0, -0.0189425251940965, 0.0154665070551172, 0.0153110608279201, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0045093795093795, 0.0370997534990628, -0.0281660799985623, 0.0108976671476671, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.00431740218144092, -0.0123380044187275, 0.00872428659079175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, -0.0487403065559316, 0.0412702304583721, -0.018239037386404};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 1.33226762955019e-14, 0.0, 1.14908083048704e-14, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 1.24344978758018e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.52100554373646e-14, 11.2249721603218, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, -2.04281036531029e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, -1.36002320516582e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.68753899743024e-14, 1.77635683940025e-14, -1.82076576038526e-14, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, 1.50990331349021e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.02140518265514e-14, 1.31006316905768e-14, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677393, 0.0, 0.0, 8.69482604771367, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.64174229766445e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, -1.38222766565832e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394699, 0.0, -3.3466401061363, -2.36643191323984, 15.4919333848297, 0.0, 0.0, 0.692820323027558, 0.565685424949244, 0.399999999999995, 0.0, -3.46389583683049e-14, -2.30926389122033e-14, 1.33226762955019e-14, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 2.4980018054066e-14, 0.0, 1.58896492367982e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57651669496772e-14, 0.0, 0.0, 0.0},
      {3.73590047786365e-14, 4.89897948556636, 3.73034936274053e-14, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {-2.8421709430404e-14, 4.24264068711927, 0.0, 0.0, 0.0, 3.10862446895044e-14, 14.3427433120127, 1.24344978758018e-14, 2.44249065417534e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, -3.46389583683049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0769163338864e-14, 1.27675647831893e-14, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008267, -1.549193338483, 0.0, 0.0, 0.0, 9.52470471983255, -1.48131215963608, 0.261861468283196, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 0.0, 2.30926389122033e-14, 0.0, 1.24344978758018e-14, -2.57571741713036e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 1.24344978758018e-14, -1.4210854715202e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14},
      {3.11769145362397, -1.75415237890775e-14, 3.16227766016835, 4.91934955049954, 0.0, -1.62647673107585e-14, 0.0, -1.33226762955019e-14, 10.690449676497, -2.41897262725904, 0.0, 0.0, 0.0, -2.22044604925031e-14, 1.15463194561016e-14, -2.98649993624167e-14, -1.40443212615082e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0325074129014e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.39808173319034e-14, -2.1316282072803e-14, 1.95399252334028e-14, 0.0, 0.0, 0.0, -2.46469511466785e-14, 2.03725925018716e-14, 0.0, 0.0},
      {2.54558441227157, 0.0, 0.0, 7.66811580507233, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, -2.8421709430404e-14, 0.0, 0.0, 2.30926389122033e-14, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.93178806284777e-14, 11.6057691494799, 0.0, 1.02140518265514e-14, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, 0.0, 0.611677741841193, 0.529728463363959, 0.432521479156766, 0.0, 1.50990331349021e-14, 1.50990331349021e-14, 1.0991207943789e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.18786224940063e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479105, 0.0, 3.54562104171166, -2.50713268211203, 4.78713553878169, 2.48689957516035e-14, 0.0, -5.56626745075488, -1.04880884817014, 0.741619848709556, -1.24344978758018e-14, 18.8034951158402, -0.60312238704646, 0.0, -2.30926389122033e-14, 0.0, 1.68183573174416, 0.701283781217658, 0.13213749452869, -0.0934353184302195, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095216, -1.86517468137026e-14, -1.58564993434418, 4.4848952846511, 4.28174419288837, 0.0, -1.4210854715202e-14, 0.19148542155127, -3.75233260785875, -4.31161222746203, -1.59872115546023e-14, -1.24344978758018e-14, 18.8807171866293, 0.0, -3.5527136788005e-14, -3.28626015289046e-14, 0.0, 0.844371341865044, 1.18187368057057, 1.04463861754667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.99680288865056e-14, 2.59512887494072, 1.15463194561016e-14, 0.0, 2.1316282072803e-14, 10.0285307284481, -0.767649473578724, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123489, 1.4210854715202e-14, 2.1316282072803e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.59872115546023e-14, 2.321153829896, 0.0, 0.0, 0.0, 3.92428337406973, 5.49285249860476, 1.77635683940025e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365566, -1.73008591662714, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278143, 0.0, 0.0, 1.37667655053519e-14, 2.30926389122033e-14, 8.91928088068603, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 16.8558564884488, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483829, 0.0, 8.12403840463596, -1.64130361329659, 1.24344978758018e-14, -1.06581410364015e-14, 0.0, 11.7728501222092, -2.40312296813958, 0.485504156227613, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 10.2761860629321, -1.48323969741915, 0.302765035409786, -0.0611677741841339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, -1.95399252334028e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, -1.59872115546023e-14, 2.63248931621765, 9.82591326180786, -2.82261277137741, 0.0, 0.0, 1.28785870856518e-14, -1.99840144432528e-14, 2.1316282072803e-14, -2.8421709430404e-14, 1.04360964314765e-14, 11.6081867662439, -3.09487177319466, 0.683876505540214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, -2.34812169708221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.29782505861521, 0.0, 1.49829835452874, 5.50917601898539, 0.0, 0.0, 2.04281036531029e-14, 0.0, 6.64803945320938, 4.13676892548488, 0.0, -1.59872115546023e-14, 0.0, 0.0, -2.08721928629529e-14, 0.0, -1.06581410364015e-14, 0.0, 12.5636136423841, -3.55352656109504, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 1.4210854715202e-14},
      {1.87616630392938, 0.0, 1.50990331349021e-14, 6.2283092998577, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07611705604904e-14, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722507, 0.0, -4.41087092453691, -3.11895674167863, 16.6749979177077, 0.0, 1.55431223447522e-14, 2.13065307820924, 1.73967095350099, 1.23013312825381, 0.0, -4.36653943835006, -3.7815340802378, 0.0, 2.66453525910038e-14, 1.24344978758018e-14, -0.55793594346197, -0.483186700722504, -0.394520289089684, -0.278967971730996, 23.6981011897578, 0.0, 0.0, 0.490653381462661, 0.43885372573626, 0.380058475033048, 0.0, 0.0, 0.0, 0.0, 0.0626933893908861, 0.0560746721671623, 0.0485620906056381, 0.0396507809422189, 0.0280373360835759, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.33226762955019e-14, 6.91050664139876, -1.68753899743024e-14, 1.57651669496772e-14, 1.95399252334028e-14, 10.5706241650196, -2.72554057547699, 0.0, 0.0, 0.0, 4.67332857821917, -1.50990331349021e-14, 0.0, -7.86705867811455, -2.39719223514614, 0.618094504365238, 0.0, 2.30926389122033e-14, 0.0, 0.0, 0.0, 23.1055548876599, -0.469687194424188, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676767, -0.062120835029094, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 1.11022302462516e-14, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24185123190546e-14, 6.30840061880561, 0.0, 0.0, 0.0, -1.52362350055012, 11.1963004093827, 0.0, -2.06501482580279e-14, -1.77635683940025e-14, 4.26614580154031, 0.0, 1.4210854715202e-14, 0.132992762321621, -4.72217953828914, -6.67684597013017, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05209757977173e-14, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560575, 1.1112512795529, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.39808173319034e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663773, 1.15463194561016e-14, 5.98171817966649, -2.48806675764059, 1.90029237516522, 1.24344978758018e-14, 0.0, -0.339934634239512, -2.35922146606162, 0.981306762925322, 1.24344978758018e-14, 9.95226703056239, -0.430945803685663, 0.0, -2.04558592287185e-14, 1.77635683940025e-14, -6.45364422706454, 0.0770899289327289, 0.535021138879199, -0.222539456105666, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031377, -1.15463194561016e-14, 0.0, 1.35447209004269e-14, 0.0, 2.75066129615001, 0.648615649442918, -0.00774782937530905, -0.0537716476536647, 0.02236605687735, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, -1.06581410364015e-14, 1.92724822331889, 2.72554057547698, 1.73472166622177, 2.57571741713036e-14, 0.0, -2.01705689521106, 3.42052627529743, -4.03112887414929, 0.0, 4.08831086321546, 5.37643791520783, 0.0, -4.61852778244065e-14, 0.0, 0.365669640132054, -6.25148194071025, -2.03981013744544, 1.80803322065279, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 1.37667655053519e-14, 0.0, -1.06581410364015e-14, 1.98456380761455, 1.4711357857929, 0.363818136386332, -0.294009452979937, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.59872115546023e-14, 1.77635683940025e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.77635683940025e-14, 0.0, 0.0, 2.1316282072803e-14, 3.73034936274053e-14, 0.0, 0.0, 0.0},
      {3.14718316987779, -1.86517468137026e-14, -0.861891607371326, 6.09449400220041, 1.55158222708543, 0.0, 0.0, 0.0693888666488709, -3.05941170815566, 1.802775637732, 0.0, 2.61457522299224e-14, 9.03122156537879, 0.0, -4.30766533554561e-14, -2.8421709430404e-14, 0.0, 0.403888506800978, -3.67461994579465, -5.49650682721196, 0.0, 0.0, 1.4432899320127e-14, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960556, 1.78974858569578, 1.80791908794929, 0.0, 1.15463194561016e-14, -1.95399252334028e-14, 0.0, -1.73194791841524e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-3.81916720471054e-14, 1.54523626091312, 0.0, 0.0, -1.4210854715202e-14, 6.71778024562962, -0.609449400220049, 0.0, 1.77635683940025e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219873, 0.138210132827965, 1.4210854715202e-14, 1.95399252334028e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {1.95399252334028e-14, 1.41060126129514, 0.0, 0.0, 1.06581410364015e-14, 3.63405410063596, 2.50356888118887, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 3.56857028479909, 11.263055412878, -1.49298814645063, 0.0, -3.5527136788005e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124155, 0.266287609379567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.73034936274053e-14, 1.2616801237611, 0.0, 0.0, 0.0, 1.42204860051346, 4.47852016375305, 1.58137392070046e-14, 3.01980662698043e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 8.27725128825318, 5.37909280973862, 3.37507799486048e-14, 2.57571741713036e-14, 0.0, -3.5527136788005e-14, 0.0, 0.0, 0.0, -1.02140518265514e-14, 2.39808173319034e-14, 0.0, 0.0, 0.0, 19.965481322634, -2.61992366301005, 0.0, 0.0, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.77635683940025e-14, 0.0, 0.0, 1.06581410364015e-14, 1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14},
      {0.0, 1.09264703862702, 1.4210854715202e-14, -2.57571741713036e-14, -1.4210854715202e-14, -1.50990331349021e-14, 5.38682254607084, -1.66533453693773e-14, 0.0, 0.0, 1.68753899743024e-14, 0.0, -3.24185123190546e-14, -1.37667655053519e-14, -3.15303338993544e-14, 13.4377817958113, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.37587727269783e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415868, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439626, 0.0, 0.0, 0.0, -1.06581410364015e-14, -2.1316282072803e-14, 0.0, 13.9858820944259, -2.72522906732405, 0.659300804656283, -0.145686271816939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846548, 0.273895826790435, -0.0662622240310455, 0.0146420212340154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316396, 1.78428514239951, 1.02140518265514e-14, 0.0, -2.48689957516035e-14, 4.26614580154033, 7.83741028656788, -2.63899331455873, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.23427840700305, 13.2221027072096, -4.67379217909106, 1.18363558466231, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274813, 0.833612074594091, -0.192474367616153, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 2.42028619368284e-14, -2.43138842392909e-14, 1.11022302462516e-14, 0.0},
      {2.06031501455085, -1.4210854715202e-14, 2.25696201807214, 3.98978286964829, 0.0, 0.0, 0.0, 0.953939201416937, 8.01142041980429, 1.18019368870416, 0.0, 0.0, 1.77635683940025e-14, -1.4210854715202e-14, -3.5527136788005e-14, -3.19744231092045e-14, -1.4210854715202e-14, 5.55254896421457, 9.6224137438848, -3.59830837050572, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29896093881143e-14, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239954, 1.99840144432528e-14, 0.814411017927992, 5.06770487035907, 0.0, 1.59872115546023e-14, 1.77635683940025e-14, 2.30926389122033e-14, 4.01510046524762, 6.58672305740272, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.95399252334028e-14, 2.1316282072803e-14, 4.08562073062058e-14, 0.0, 10.0159311874144, 2.83293314500741, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 1.17683640610267e-14, 0.0, 1.50990331349021e-14, -1.33226762955019e-14, -1.06581410364015e-14, 0.0},
      {1.45686271816938, -1.59872115546023e-14, 0.0, 5.0781645406624, -1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 10.0142755247553, 0.0, 0.0, 4.08562073062058e-14, -1.0547118733939e-14, -3.10862446895044e-14, -3.19744231092045e-14, 0.0, 2.46469511466785e-14, 0.0, 13.8784813613723, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.06581410364015e-14, 0.0, 1.3988810110277e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 12.5535587278944, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 1.70974345792274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.05193631583234e-14, 1.06581410364015e-14, 1.77635683940025e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973463, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267039, -0.591607978309968, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79856129989275e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079295, 0.683130051063959, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 1.38222766565832e-14, 0.0, -1.06581410364015e-14, -2.35367281220533e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920392, 0.0, 0.0, 7.52994023880669, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01030295240889e-14, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43773881688958e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697349, 5.79655069847576, -1.67332005306814, -1.18321595661993, 7.74596669241482, -1.19999999999999, -0.979795897113274, 0.346410161513779, 0.282842712474625, 0.200000000000001, 0.0, -2.30926389122033e-14, -1.06581410364015e-14, 0.0, -1.86517468137026e-14, -1.2712053631958e-14, 0.0, 1.06581410364015e-14, 2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {2.32379000772445, 2.44948974278317, 2.82842712474622, -1, 9.16515138991167, 7.09929573971955, -0.414039335605414, -2.04939015319191, -0.478091443733753, 0.169030850945702, 0.0, -1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 2.26485497023532e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974979, 2.12132034355964, -0.408248290463868, 3.17542648054294, 0.0, 0.0, 7.17137165600635, 0.0, -1.3801311186847, -1.56144011671765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000004, -5.69209978830307, 4.38178046004134, -0.77459666924149, 1.4210854715202e-14, 10.998181667894, 0.96214047088474, 4.76235235991627, -0.740656079818032, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 2.68673971959288e-14, 1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43218770176645e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681197, 2.73861278752581, 1.58113883008417, 2.45967477524978, 0.0, 0.0, 9.25820099772551, 0.0, 5.34522483824849, -1.20948631362952, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -3.64153152077051e-14, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52378110129803e-14, -1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253617, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, 2.8421709430404e-14, -3.16227766016838, -2.2360679774998, 0.0, 0.0, -1.06581410364015e-14, 13.7477270848675, 0.534522483824865, 0.377964473009229, -4.2632564145606e-14, -3.41948691584548e-14, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 3.111400026512e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.17683640610267e-14, 0.0, 0.0, -1.95399252334028e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.87627691161651e-14, 0.0, 0.0, 0.0},
      {-1.8, -2.48689957516035e-14, 3.65148371670108, -2.8401877872188, 0.0, 0.0, 0.0, 0.0, 12.3442679969674, 1.39659449751035, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, -4.2632564145606e-14, 0.0, 0.0, -4.70734562441066e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.55431223447522e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.28785870856518e-14, -1.33226762955019e-14},
      {2.20454076850486, 1.02140518265514e-14, 0.0, 6.6407830863536, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825747, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573303, 5.80288457473996, -2.01017818278147, -1.42141062443802, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341421, 0.594618725379069, 0.420458932936038, 9.81070843517428, -1.18450885369837, -1.02581475831037, 0.305838870920601, 0.264864231681979, 0.216260739578378, -0.105945692672791, -0.0917516612761631, -0.0749149177264187, -0.0529728463363903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0},
      {2.26568606239557, 3.07059789431496, 1.77281052085585, -1.25356634105601, 2.39356776939087, 6.30376871403132, -0.908295106229238, -2.78313372537744, -0.524404424085072, 0.370809924354778, 11.1242977306435, 9.4017475579201, -0.301561193523231, -2.42752078113804, -0.794200206656972, 0.114434427054267, 0.840917865872081, 0.350641890608835, 0.0660687472643539, -0.0467176592151086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047607, 2.74642624930236, -0.792824967172086, 2.24244764232555, 2.14087209644418, -0.331662479035522, 6.49923072370876, 0.0957427107756397, -1.87616630392936, -2.15580611373101, 0.0, 0.0, 9.44035859331466, 0.0, -1.46249406456537, -2.04706526287667, 0.0, 0.422185670932523, 0.590936840285288, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0},
      {1.9148542