#!/usr/bin/env python
"Template for generating dolfin::FunctionSpace subclass."

__author__ = "Martin Alnes (martinal@simula.no)"
__date__ = "2008-12-06 -- 2009-03-16"
__copyright__ = "Copyright (C) 2008 Martin Alnes"
__license__  = "GNU GPL version 3 or any later version"

functionspace_template = """\
class %(classname)s: public dolfin::FunctionSpace
{
public:

  %(classname)s(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new %(ufc_finite_element_classname)s()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new %(ufc_dof_map_classname)s()), mesh)))
  {
    // Do nothing
  }

  %(classname)s(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new %(ufc_finite_element_classname)s()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new %(ufc_dof_map_classname)s()), mesh)))
  {
    // Do nothing
  }

  %(classname)s(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new %(ufc_finite_element_classname)s()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new %(ufc_dof_map_classname)s()), *mesh)))
  {
      // Do nothing
  }

  %(classname)s(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new %(ufc_finite_element_classname)s()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new %(ufc_dof_map_classname)s()), *mesh)))
  {
      // Do nothing
  }

  ~%(classname)s()
  {
  }

};"""

def generate_functionspace_class(classname, ufc_finite_element_classname, ufc_dof_map_classname):
    args = { "classname": classname,
             "ufc_finite_element_classname": ufc_finite_element_classname,
             "ufc_dof_map_classname": ufc_dof_map_classname }
    return functionspace_template % args

if __name__ == "__main__":
    classname = "MyFunctionSpace"
    ufc_finite_element_classname = "myufcelement"
    ufc_dof_map_classname = "myufcdofmap"
    print generate_functionspace_class(classname, ufc_finite_element_classname, ufc_dof_map_classname)
