﻿/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System.Scripting.Utils;

namespace System.Linq.Expressions {
    public partial class ExpressionTreeVisitor {

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Maintainability", "CA1502:AvoidExcessiveComplexity")]
        public Expression VisitNode(Expression node) {
            if (node == null) {
                return null;
            }

            switch (node.NodeType) {
                #region Generated ExpressionVisitor Switch

                // *** BEGIN GENERATED CODE ***
                // generated by function: gen_visitor_switch from: generate_tree.py

                // Add
                case ExpressionType.Add:
                    return DefaultVisitBinaryExpression(node);
                // AddChecked
                case ExpressionType.AddChecked:
                    return DefaultVisitBinaryExpression(node);
                // And
                case ExpressionType.And:
                    return DefaultVisitBinaryExpression(node);
                // AndAlso
                case ExpressionType.AndAlso:
                    return DefaultVisitBinaryExpression(node);
                // ArrayLength
                case ExpressionType.ArrayLength:
                    return DefaultVisitUnaryExpression(node);
                // ArrayIndex
                case ExpressionType.ArrayIndex:
                    return DefaultVisitBinaryExpression(node);
                // Call
                case ExpressionType.Call:
                    return DefaultVisitMethodCallExpression(node);
                // Coalesce
                case ExpressionType.Coalesce:
                    return DefaultVisitBinaryExpression(node);
                // Conditional
                case ExpressionType.Conditional:
                    return DefaultVisitConditionalExpression(node);
                // Constant
                case ExpressionType.Constant:
                    return DefaultVisitConstantExpression(node);
                // Convert
                case ExpressionType.Convert:
                    return DefaultVisitUnaryExpression(node);
                // ConvertChecked
                case ExpressionType.ConvertChecked:
                    return DefaultVisitUnaryExpression(node);
                // Divide
                case ExpressionType.Divide:
                    return DefaultVisitBinaryExpression(node);
                // Equal
                case ExpressionType.Equal:
                    return DefaultVisitBinaryExpression(node);
                // ExclusiveOr
                case ExpressionType.ExclusiveOr:
                    return DefaultVisitBinaryExpression(node);
                // GreaterThan
                case ExpressionType.GreaterThan:
                    return DefaultVisitBinaryExpression(node);
                // GreaterThanOrEqual
                case ExpressionType.GreaterThanOrEqual:
                    return DefaultVisitBinaryExpression(node);
                // Invoke
                case ExpressionType.Invoke:
                    return DefaultVisitInvocationExpression(node);
                // Lambda
                case ExpressionType.Lambda:
                    return DefaultVisitLambdaExpression(node);
                // LeftShift
                case ExpressionType.LeftShift:
                    return DefaultVisitBinaryExpression(node);
                // LessThan
                case ExpressionType.LessThan:
                    return DefaultVisitBinaryExpression(node);
                // LessThanOrEqual
                case ExpressionType.LessThanOrEqual:
                    return DefaultVisitBinaryExpression(node);
                // ListInit
                case ExpressionType.ListInit:
                    return DefaultVisitListInitExpression(node);
                // MemberAccess
                case ExpressionType.MemberAccess:
                    return DefaultVisitMemberExpression(node);
                // MemberInit
                case ExpressionType.MemberInit:
                    return DefaultVisitMemberInitExpression(node);
                // Modulo
                case ExpressionType.Modulo:
                    return DefaultVisitBinaryExpression(node);
                // Multiply
                case ExpressionType.Multiply:
                    return DefaultVisitBinaryExpression(node);
                // MultiplyChecked
                case ExpressionType.MultiplyChecked:
                    return DefaultVisitBinaryExpression(node);
                // Negate
                case ExpressionType.Negate:
                    return DefaultVisitUnaryExpression(node);
                // UnaryPlus
                case ExpressionType.UnaryPlus:
                    return DefaultVisitUnaryExpression(node);
                // NegateChecked
                case ExpressionType.NegateChecked:
                    return DefaultVisitUnaryExpression(node);
                // New
                case ExpressionType.New:
                    return DefaultVisitNewExpression(node);
                // NewArrayInit
                case ExpressionType.NewArrayInit:
                    return DefaultVisitNewArrayExpression(node);
                // NewArrayBounds
                case ExpressionType.NewArrayBounds:
                    return DefaultVisitNewArrayExpression(node);
                // Not
                case ExpressionType.Not:
                    return DefaultVisitUnaryExpression(node);
                // NotEqual
                case ExpressionType.NotEqual:
                    return DefaultVisitBinaryExpression(node);
                // Or
                case ExpressionType.Or:
                    return DefaultVisitBinaryExpression(node);
                // OrElse
                case ExpressionType.OrElse:
                    return DefaultVisitBinaryExpression(node);
                // Parameter
                case ExpressionType.Parameter:
                    return DefaultVisitParameterExpression(node);
                // Power
                case ExpressionType.Power:
                    return DefaultVisitBinaryExpression(node);
                // Quote
                case ExpressionType.Quote:
                    return DefaultVisitUnaryExpression(node);
                // RightShift
                case ExpressionType.RightShift:
                    return DefaultVisitBinaryExpression(node);
                // Subtract
                case ExpressionType.Subtract:
                    return DefaultVisitBinaryExpression(node);
                // SubtractChecked
                case ExpressionType.SubtractChecked:
                    return DefaultVisitBinaryExpression(node);
                // TypeAs
                case ExpressionType.TypeAs:
                    return DefaultVisitUnaryExpression(node);
                // TypeIs
                case ExpressionType.TypeIs:
                    return DefaultVisitTypeBinaryExpression(node);
                // Assign
                case ExpressionType.Assign:
                    return DefaultVisitAssignmentExpression(node);
                // Block
                case ExpressionType.Block:
                    return DefaultVisitBlock(node);
                // Generator
                case ExpressionType.Generator:
                    return DefaultVisitLambdaExpression(node);
                // DoStatement
                case ExpressionType.DoStatement:
                    return DefaultVisitDoStatement(node);
                // Dynamic
                case ExpressionType.Dynamic:
                    return DefaultVisitDynamicExpression(node);
                // EmptyStatement
                case ExpressionType.EmptyStatement:
                    return DefaultVisitEmptyStatement(node);
                // Extension
                case ExpressionType.Extension:
                    return DefaultVisitExtensionExpression(node);
                // Goto
                case ExpressionType.Goto:
                    return DefaultVisitGotoExpression(node);
                // Index
                case ExpressionType.Index:
                    return DefaultVisitIndexExpression(node);
                // Label
                case ExpressionType.Label:
                    return DefaultVisitLabelExpression(node);
                // LocalScope
                case ExpressionType.LocalScope:
                    return DefaultVisitLocalScopeExpression(node);
                // LoopStatement
                case ExpressionType.LoopStatement:
                    return DefaultVisitLoopStatement(node);
                // OnesComplement
                case ExpressionType.OnesComplement:
                    return DefaultVisitUnaryExpression(node);
                // ReturnStatement
                case ExpressionType.ReturnStatement:
                    return DefaultVisitReturnStatement(node);
                // Scope
                case ExpressionType.Scope:
                    return DefaultVisitScopeExpression(node);
                // SwitchStatement
                case ExpressionType.SwitchStatement:
                    return DefaultVisitSwitchStatement(node);
                // ThrowStatement
                case ExpressionType.ThrowStatement:
                    return DefaultVisitThrowStatement(node);
                // TryStatement
                case ExpressionType.TryStatement:
                    return DefaultVisitTryStatement(node);
                // Unbox
                case ExpressionType.Unbox:
                    return DefaultVisitUnaryExpression(node);
                // Variable
                case ExpressionType.Variable:
                    return DefaultVisitVariableExpression(node);
                // YieldStatement
                case ExpressionType.YieldStatement:
                    return DefaultVisitYieldStatement(node);

                // *** END GENERATED CODE ***

                #endregion

                default:
                    throw Assert.Unreachable;
            }
        }

        #region Generated ExpressionVisitor Methods

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_visitor_methods from: generate_tree.py

        // AssignmentExpression
        private Expression DefaultVisitAssignmentExpression(Expression node) {
            return Visit((AssignmentExpression)node);
        }

        // BinaryExpression
        private Expression DefaultVisitBinaryExpression(Expression node) {
            return Visit((BinaryExpression)node);
        }

        // Block
        private Expression DefaultVisitBlock(Expression node) {
            return Visit((Block)node);
        }

        // ConditionalExpression
        private Expression DefaultVisitConditionalExpression(Expression node) {
            return Visit((ConditionalExpression)node);
        }

        // ConstantExpression
        private Expression DefaultVisitConstantExpression(Expression node) {
            return Visit((ConstantExpression)node);
        }

        // DoStatement
        private Expression DefaultVisitDoStatement(Expression node) {
            return Visit((DoStatement)node);
        }

        // DynamicExpression
        private Expression DefaultVisitDynamicExpression(Expression node) {
            return Visit((DynamicExpression)node);
        }

        // EmptyStatement
        private Expression DefaultVisitEmptyStatement(Expression node) {
            return Visit((EmptyStatement)node);
        }

        // GotoExpression
        private Expression DefaultVisitGotoExpression(Expression node) {
            return Visit((GotoExpression)node);
        }

        // IndexExpression
        private Expression DefaultVisitIndexExpression(Expression node) {
            return Visit((IndexExpression)node);
        }

        // InvocationExpression
        private Expression DefaultVisitInvocationExpression(Expression node) {
            return Visit((InvocationExpression)node);
        }

        // LabelExpression
        private Expression DefaultVisitLabelExpression(Expression node) {
            return Visit((LabelExpression)node);
        }

        // LambdaExpression
        private Expression DefaultVisitLambdaExpression(Expression node) {
            return Visit((LambdaExpression)node);
        }

        // ListInitExpression
        private Expression DefaultVisitListInitExpression(Expression node) {
            return Visit((ListInitExpression)node);
        }

        // LocalScopeExpression
        private Expression DefaultVisitLocalScopeExpression(Expression node) {
            return Visit((LocalScopeExpression)node);
        }

        // LoopStatement
        private Expression DefaultVisitLoopStatement(Expression node) {
            return Visit((LoopStatement)node);
        }

        // MemberExpression
        private Expression DefaultVisitMemberExpression(Expression node) {
            return Visit((MemberExpression)node);
        }

        // MemberInitExpression
        private Expression DefaultVisitMemberInitExpression(Expression node) {
            return Visit((MemberInitExpression)node);
        }

        // MethodCallExpression
        private Expression DefaultVisitMethodCallExpression(Expression node) {
            return Visit((MethodCallExpression)node);
        }

        // NewArrayExpression
        private Expression DefaultVisitNewArrayExpression(Expression node) {
            return Visit((NewArrayExpression)node);
        }

        // NewExpression
        private Expression DefaultVisitNewExpression(Expression node) {
            return Visit((NewExpression)node);
        }

        // ParameterExpression
        private Expression DefaultVisitParameterExpression(Expression node) {
            return Visit((ParameterExpression)node);
        }

        // ReturnStatement
        private Expression DefaultVisitReturnStatement(Expression node) {
            return Visit((ReturnStatement)node);
        }

        // ScopeExpression
        private Expression DefaultVisitScopeExpression(Expression node) {
            return Visit((ScopeExpression)node);
        }

        // SwitchStatement
        private Expression DefaultVisitSwitchStatement(Expression node) {
            return Visit((SwitchStatement)node);
        }

        // ThrowStatement
        private Expression DefaultVisitThrowStatement(Expression node) {
            return Visit((ThrowStatement)node);
        }

        // TryStatement
        private Expression DefaultVisitTryStatement(Expression node) {
            return Visit((TryStatement)node);
        }

        // TypeBinaryExpression
        private Expression DefaultVisitTypeBinaryExpression(Expression node) {
            return Visit((TypeBinaryExpression)node);
        }

        // UnaryExpression
        private Expression DefaultVisitUnaryExpression(Expression node) {
            return Visit((UnaryExpression)node);
        }

        // VariableExpression
        private Expression DefaultVisitVariableExpression(Expression node) {
            return Visit((VariableExpression)node);
        }

        // YieldStatement
        private Expression DefaultVisitYieldStatement(Expression node) {
            return Visit((YieldStatement)node);
        }

        // *** END GENERATED CODE ***

        #endregion

        // ExpressionType.Extension
        private Expression DefaultVisitExtensionExpression(Expression node) {
            return VisitExtension(node);
        }
    }
}
