require File.dirname(__FILE__) + '/../spec_helper'
require "win32ole"

# Basic tests. MRI includes deeper tests

describe "win32ole" do
  before :each do
    @fs = WIN32OLE.new "Scripting.FileSystemObject"
  end
  
  it "supports enumeration" do    
    windir = @fs.GetFolder ENV["windir"]
    subfolders = []
    windir.SubFolders.each {|sub| subfolders << sub.name.to_str}
    subfolders.include?("System32").should == true
  end
  
  it "supports const_load" do
    m = Module.new
    WIN32OLE.const_load(@fs, m)
    m.const_get("SystemFolder").should == 1
    m.const_get("CONSTANTS")["SystemFolder"].should == 1
  end
end
