﻿/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * ironruby@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using IronRuby.Builtins;
using IronRuby.Compiler;
using IronRuby.Compiler.Ast;
using IronRuby.Compiler.Generation;
using Microsoft.Scripting.Runtime;
using Microsoft.Scripting.Utils;
using AstUtils = Microsoft.Scripting.Ast.Utils;
using MethodDeclaration = IronRuby.Compiler.Ast.MethodDeclaration;
using MSA = System.Linq.Expressions;

namespace IronRuby.Runtime.Calls {
    /// <summary>
    /// Represents a Ruby method body AST. Multiple RubyMethodInfos can share the same instance.
    /// </summary>
    public sealed class RubyMethodBody {
        private readonly RubyContext/*!*/ _context;
        private readonly MethodDeclaration/*!*/ _ast;
        private readonly MSA.SymbolDocumentInfo _document;
        private readonly RubyEncoding/*!*/ _encoding;

        private Delegate _delegate;

        internal RubyMethodBody(RubyContext/*!*/ context, MethodDeclaration/*!*/ ast, MSA.SymbolDocumentInfo document, RubyEncoding/*!*/ encoding) {
            Assert.NotNull(ast, encoding);

            _context = context;
            _ast = ast;
            _document = document;
            _encoding = encoding;
        }

        public MethodDeclaration Ast { get { return _ast; } }
        public bool HasTarget { get { return _ast.Target != null; } }
        public string/*!*/ Name { get { return _ast.Name; } }
        public int MandatoryParameterCount { get { return _ast.Parameters.MandatoryCount; } }
        public int OptionalParameterCount { get { return _ast.Parameters.OptionalCount; } }
        public bool HasUnsplatParameter { get { return _ast.Parameters.Array != null; } }

        internal Delegate GetDelegate(RubyScope/*!*/ declaringScope, RubyModule/*!*/ declaringModule) {
            if (_delegate == null) {
                lock (this) {
                    if (_delegate == null) {
                        // TODO: remove options
                        AstGenerator gen = new AstGenerator(_context, new RubyCompilerOptions(), _document, _encoding, false);
                        MSA.LambdaExpression lambda = _ast.TransformBody(gen, declaringScope, declaringModule);
                        _delegate = RubyScriptCode.CompileLambda(lambda, _context);
                    }
                }
            }

            return _delegate;
        }
    }
}
