#ifndef _PLAYERLIST_H_INCLUDED
#define _PLAYERLIST_H_INCLUDED

#include <qwidget.h>
#include "virlist.h"

class DragSortList;
class QListViewItem;
class QPixmap;
class Playlist;
class DirViewItem;

class PlayerList : public VirList
{
Q_OBJECT
public:
	PlayerList(QWidget *parent, Playlist *pl, const char *name = 0, WFlags f = 0);
	virtual ~PlayerList();
	virtual void setDir(QString i_dir);
	virtual void setFile(QString i_file);
	virtual QString getDir();
	virtual void addFile(QString file, bool save=true);
	virtual QString getSelectedFile();
	void setCurrentSong(int player);
	void clearCurrentSong(int player);
	bool selectFirstUnplayed();
	bool selectRandomUnplayed();
protected:
	DirViewItem *current_song[2];
	QString file;
	virtual void load();
protected slots:
	virtual void flagUnplayed();
	virtual void flagPlayed();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void lv_doubleClicked(QListViewItem *it);
	virtual void lv_rightClicked(QListViewItem *it, const QPoint& pos, int col);
	virtual void removeItem();
	virtual void moveToList(int arg);
	virtual void save();
};

#endif
