.TH SS 1 "17 January 2002"
.SH NAME
ss, ssb \- Single Step 
.SH SYNOPSIS
ss
.LP
ssb 
.SH DESCRIPTION
The
.B ss
command is used to execute a single instruction and return
to the kernel debugger.
.P
Both the instruction that was single-stepped and the next
instruction to execute are printed. 
.P
The \fBssb\fP command will execute instructions from the
current value of the instruction pointer.  Each instruction
may be printed as it is executed, depending upon architecture;
execution will stop at any instruction which would cause the flow 
of control to change (e.g. branch, call, interrupt instruction, 
return, etc.)
.SH LIMITATIONS
On sparc64, there are some circumstances where single-stepping
can be dangerous. Do not single-step across an instruction which
changes the interrupt-enable bit in %tstate. Do not single step
through code which is invoked when entering or leaving the
kernel, particularly any kernel entry code before %tl is set to
0, or any kernel exit code after %tl is set to 1.
.SH ENVIRONMENT
None.
.SH SMP CONSIDERATIONS
Other processors are held in the kernel debugger when the instruction
is traced.  Single stepping though code that requires a lock which is
in use by another processor is an exercise in futility, it will never
succeed.
.SH INTERRUPT CONSIDERATIONS
When a kdb event occurs, one cpu (the initial cpu) enters kdb state.
It uses a cross system interrupt to interrupt the
other cpus and bring them all into kdb state.  All cpus run with
interrupts disabled while they are inside kdb, this prevents most
external events from disturbing the kernel while kdb is running.
.B Note:
Disabled interrupts means that any I/O that relies on interrupts cannot
proceed while kdb is in control, devices can time out.  The clock tick
is also disabled, machines will lose track of time while they are
inside kdb.
.P
Even with interrupts disabled, some non-maskable interrupt events
will still occur, these can disturb the kernel while you are
debugging it.  The initial cpu will still accept NMI events,
assuming that kdb was not entered for an NMI event.  Any cpu
where you use the SS or SSB commands will accept NMI events, even
after the instruction has finished and the cpu is back in kdb.
This is an unavoidable side effect of the fact that doing SS[B]
requires the cpu to drop all the way out of kdb, including
exiting from the NMI event that brought the cpu into kdb.  Under
normal circumstances the only NMI event is for the NMI oopser and
that is kdb aware so it does not disturb the kernel while kdb is
running.
.P
Sometimes doing SS or SSB on ix86 will allow one interrupt to proceed,
even though the cpu is disabled for interrupts.  I have not been able
to track this one down but I suspect that the interrupt was pending
when kdb was entered and it runs when kdb exits through IRET even
though the popped flags are marked as cli().  If any ix86 hardware
expert can shed some light on this problem, please notify the kdb
maintainer.
.SH EXAMPLES
.nf
.na
.ft CW
kdb> bp gendisk_head datar 4
Data Access Breakpoint #0 at 0xc024ddf4 (gendisk_head) in dr0 is enabled on cpu 0
for 4 bytes
kdb> go
...
[root@host /root]# cat /proc/partitions
Entering kdb on processor 0 due to Debug Exception @ 0xc01845e3
Read/Write breakpoint #0 at 0xc024ddf4
[0]kdb> ssb
sd_finish+0x7b:  movzbl 0xc02565d4,%edx
sd_finish+0x82:  leal   0xf(%edx),%eax
sd_finish+0x85:  sarl   $0x4,%eax
sd_finish+0x88:  movl   0xc0256654,%ecx
sd_finish+0x8e:  leal   (%eax,%eax,4),%edx
sd_finish+0x91:  leal   (%eax,%edx,2),%edx
sd_finish+0x94:  movl   0xc0251108,%eax
sd_finish+0x99:  movl   %eax,0xffffffc(%ecx,%edx,4)
sd_finish+0x9d:  movl   %ecx,0xc0251108
sd_finish+0xa3:  xorl   %ebx,%ebx
sd_finish+0xa5:  cmpb   $0x0,0xc02565d4
[0]kdb> go
[root@host /root]# 

[0]kdb> ss
sys_read:   pushl  %ebp
SS trap at 0xc01274c1
sys_read+0x1:   movl   %esp,%ebp
[0]kdb> ss
sys_read+0x1:   movl   %esp,%ebp
SS trap at 0xc01274c3
sys_read+0x3:   subl   $0xc,%esp
[0]kdb> ss
sys_read+0x3:   subl   $0xc,%esp
SS trap at 0xc01274c6
sys_read+0x6:   pushl  %edi
[0]kdb>

