/* ConfigURLPart.c generated by valac 0.12.0, the Vala compiler
 * generated from ConfigURLPart.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <uriutils.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_ENTRY (deja_dup_config_entry_get_type ())
#define DEJA_DUP_CONFIG_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntry))
#define DEJA_DUP_CONFIG_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntryClass))
#define DEJA_DUP_IS_CONFIG_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY))
#define DEJA_DUP_IS_CONFIG_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_ENTRY))
#define DEJA_DUP_CONFIG_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntryClass))

typedef struct _DejaDupConfigEntry DejaDupConfigEntry;
typedef struct _DejaDupConfigEntryClass DejaDupConfigEntryClass;
typedef struct _DejaDupConfigEntryPrivate DejaDupConfigEntryPrivate;

#define DEJA_DUP_TYPE_CONFIG_URL_PART (deja_dup_config_url_part_get_type ())
#define DEJA_DUP_CONFIG_URL_PART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart))
#define DEJA_DUP_CONFIG_URL_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartClass))
#define DEJA_DUP_IS_CONFIG_URL_PART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART))
#define DEJA_DUP_IS_CONFIG_URL_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_URL_PART))
#define DEJA_DUP_CONFIG_URL_PART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartClass))

typedef struct _DejaDupConfigURLPart DejaDupConfigURLPart;
typedef struct _DejaDupConfigURLPartClass DejaDupConfigURLPartClass;
typedef struct _DejaDupConfigURLPartPrivate DejaDupConfigURLPartPrivate;

#define DEJA_DUP_CONFIG_URL_PART_TYPE_PART (deja_dup_config_url_part_part_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupConfigUrlPartSetFromConfigData DejaDupConfigUrlPartSetFromConfigData;
#define _deja_dup_decoded_uri_free0(var) ((var == NULL) ? NULL : (var = (deja_dup_decoded_uri_free (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	DejaDupSimpleSettings* settings;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigEntry {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigEntryPrivate * priv;
	GtkEntry* entry;
};

struct _DejaDupConfigEntryClass {
	DejaDupConfigWidgetClass parent_class;
	void (*write_to_config) (DejaDupConfigEntry* self);
};

struct _DejaDupConfigURLPart {
	DejaDupConfigEntry parent_instance;
	DejaDupConfigURLPartPrivate * priv;
};

struct _DejaDupConfigURLPartClass {
	DejaDupConfigEntryClass parent_class;
};

typedef enum  {
	DEJA_DUP_CONFIG_URL_PART_PART_SCHEME,
	DEJA_DUP_CONFIG_URL_PART_PART_SERVER,
	DEJA_DUP_CONFIG_URL_PART_PART_PORT,
	DEJA_DUP_CONFIG_URL_PART_PART_USER,
	DEJA_DUP_CONFIG_URL_PART_PART_FOLDER,
	DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN
} DejaDupConfigURLPartPart;

struct _DejaDupConfigURLPartPrivate {
	DejaDupConfigURLPartPart _part;
};

struct _DejaDupConfigUrlPartSetFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigURLPart* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* userval;
};


static gpointer deja_dup_config_url_part_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_entry_get_type (void) G_GNUC_CONST;
GType deja_dup_config_url_part_get_type (void) G_GNUC_CONST;
GType deja_dup_config_url_part_part_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_URL_PART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartPrivate))
enum  {
	DEJA_DUP_CONFIG_URL_PART_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_URL_PART_PART
};
DejaDupConfigURLPart* deja_dup_config_url_part_new (DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns);
DejaDupConfigURLPart* deja_dup_config_url_part_construct (GType object_type, DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns);
static void deja_dup_config_url_part_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_url_part_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_config_url_part_real_set_from_config_co (DejaDupConfigUrlPartSetFromConfigData* data);
gchar* deja_dup_config_url_part_read_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part);
const gchar* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
DejaDupConfigURLPartPart deja_dup_config_url_part_get_part (DejaDupConfigURLPart* self);
static void deja_dup_config_url_part_real_write_to_config (DejaDupConfigEntry* base);
void deja_dup_config_url_part_write_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part, const gchar* userval);
static DejaDupDecodedUri* deja_dup_config_url_part_get_current_uri (GSettings* settings, const gchar* key);
static gchar* deja_dup_config_url_part_userinfo_get_user (const gchar* scheme, const gchar* userinfo);
static gchar* deja_dup_config_url_part_userinfo_get_domain (const gchar* scheme, const gchar* userinfo);
static gchar* deja_dup_config_url_part_userinfo_set_user (const gchar* scheme, const gchar* userinfo, const gchar* user);
static gchar* deja_dup_config_url_part_userinfo_set_domain (const gchar* scheme, const gchar* userinfo, const gchar* domain);
static void deja_dup_config_url_part_scrub_uri (DejaDupDecodedUri* uri);
static void deja_dup_config_url_part_set_part (DejaDupConfigURLPart* self, DejaDupConfigURLPartPart value);
static void deja_dup_config_url_part_finalize (GObject* obj);
static void _vala_deja_dup_config_url_part_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_config_url_part_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType deja_dup_config_url_part_part_get_type (void) {
	static volatile gsize deja_dup_config_url_part_part_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_url_part_part_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_CONFIG_URL_PART_PART_SCHEME, "DEJA_DUP_CONFIG_URL_PART_PART_SCHEME", "scheme"}, {DEJA_DUP_CONFIG_URL_PART_PART_SERVER, "DEJA_DUP_CONFIG_URL_PART_PART_SERVER", "server"}, {DEJA_DUP_CONFIG_URL_PART_PART_PORT, "DEJA_DUP_CONFIG_URL_PART_PART_PORT", "port"}, {DEJA_DUP_CONFIG_URL_PART_PART_USER, "DEJA_DUP_CONFIG_URL_PART_PART_USER", "user"}, {DEJA_DUP_CONFIG_URL_PART_PART_FOLDER, "DEJA_DUP_CONFIG_URL_PART_PART_FOLDER", "folder"}, {DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN, "DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN", "domain"}, {0, NULL, NULL}};
		GType deja_dup_config_url_part_part_type_id;
		deja_dup_config_url_part_part_type_id = g_enum_register_static ("DejaDupConfigURLPartPart", values);
		g_once_init_leave (&deja_dup_config_url_part_part_type_id__volatile, deja_dup_config_url_part_part_type_id);
	}
	return deja_dup_config_url_part_part_type_id__volatile;
}


DejaDupConfigURLPart* deja_dup_config_url_part_construct (GType object_type, DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns) {
	DejaDupConfigURLPart * self = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	self = (DejaDupConfigURLPart*) g_object_new (object_type, "key", key, "ns", ns, "part", part, NULL);
	return self;
}


DejaDupConfigURLPart* deja_dup_config_url_part_new (DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns) {
	return deja_dup_config_url_part_construct (DEJA_DUP_TYPE_CONFIG_URL_PART, part, key, ns);
}


static void deja_dup_config_url_part_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigUrlPartSetFromConfigData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupConfigUrlPartSetFromConfigData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_config_url_part_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigURLPart * self;
	DejaDupConfigUrlPartSetFromConfigData* _data_;
	self = (DejaDupConfigURLPart*) base;
	_data_ = g_slice_new0 (DejaDupConfigUrlPartSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_url_part_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_url_part_real_set_from_config_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_config_url_part_real_set_from_config_co (_data_);
}


static void deja_dup_config_url_part_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigUrlPartSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_config_url_part_real_set_from_config_co (DejaDupConfigUrlPartSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) data->self);
	data->_tmp1_ = NULL;
	data->_tmp1_ = deja_dup_config_url_part_read_uri_part ((GSettings*) ((DejaDupConfigWidget*) data->self)->settings, data->_tmp0_, data->self->priv->_part);
	data->userval = data->_tmp1_;
	gtk_entry_set_text (((DejaDupConfigEntry*) data->self)->entry, data->userval);
	_g_free0 (data->userval);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_config_url_part_real_write_to_config (DejaDupConfigEntry* base) {
	DejaDupConfigURLPart * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* userval;
	const gchar* _tmp2_ = NULL;
	self = (DejaDupConfigURLPart*) base;
	_tmp0_ = gtk_entry_get_text (((DejaDupConfigEntry*) self)->entry);
	_tmp1_ = g_strdup (_tmp0_);
	userval = _tmp1_;
	_tmp2_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	deja_dup_config_url_part_write_uri_part ((GSettings*) ((DejaDupConfigWidget*) self)->settings, _tmp2_, self->priv->_part, userval);
	_g_free0 (userval);
}


gchar* deja_dup_config_url_part_read_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part) {
	gchar* result = NULL;
	DejaDupDecodedUri* _tmp0_ = NULL;
	DejaDupDecodedUri* uri;
	gchar* text;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = deja_dup_config_url_part_get_current_uri (settings, key);
	uri = _tmp0_;
	text = NULL;
	switch (part) {
		case DEJA_DUP_CONFIG_URL_PART_PART_SCHEME:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (uri->scheme);
			_g_free0 (text);
			text = _tmp1_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_SERVER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (uri->host);
			_g_free0 (text);
			text = _tmp2_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_PORT:
		{
			if (uri->port >= 0) {
				gchar* _tmp3_ = NULL;
				_tmp3_ = g_strdup_printf ("%i", uri->port);
				_g_free0 (text);
				text = _tmp3_;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_FOLDER:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (uri->path);
			_g_free0 (text);
			text = _tmp4_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_USER:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = deja_dup_config_url_part_userinfo_get_user (uri->scheme, uri->userinfo);
			_g_free0 (text);
			text = _tmp5_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN:
		{
			gchar* _tmp6_ = NULL;
			_tmp6_ = deja_dup_config_url_part_userinfo_get_domain (uri->scheme, uri->userinfo);
			_g_free0 (text);
			text = _tmp6_;
			break;
		}
		default:
		break;
	}
	if (text == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		_g_free0 (text);
		text = _tmp7_;
	}
	result = text;
	_deja_dup_decoded_uri_free0 (uri);
	return result;
}


void deja_dup_config_url_part_write_uri_part (GSettings* settings, const gchar* key, DejaDupConfigURLPartPart part, const gchar* userval) {
	DejaDupDecodedUri* _tmp0_ = NULL;
	DejaDupDecodedUri* uri;
	gchar* _tmp9_ = NULL;
	gchar* val;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (userval != NULL);
	_tmp0_ = deja_dup_config_url_part_get_current_uri (settings, key);
	uri = _tmp0_;
	switch (part) {
		case DEJA_DUP_CONFIG_URL_PART_PART_SCHEME:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (userval);
			_g_free0 (uri->scheme);
			uri->scheme = _tmp1_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_SERVER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (userval);
			_g_free0 (uri->host);
			uri->host = _tmp2_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_PORT:
		{
			gint _tmp3_;
			_tmp3_ = atoi (userval);
			uri->port = _tmp3_;
			if (uri->port == 0) {
				uri->port = -1;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_FOLDER:
		{
			gboolean _tmp4_;
			_tmp4_ = g_str_has_prefix (userval, "/");
			if (_tmp4_) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup (userval);
				_g_free0 (uri->path);
				uri->path = _tmp5_;
			} else {
				gchar* _tmp6_;
				_tmp6_ = g_strconcat ("/", userval, NULL);
				_g_free0 (uri->path);
				uri->path = _tmp6_;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_USER:
		{
			gchar* _tmp7_ = NULL;
			_tmp7_ = deja_dup_config_url_part_userinfo_set_user (uri->scheme, uri->userinfo, userval);
			_g_free0 (uri->userinfo);
			uri->userinfo = _tmp7_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN:
		{
			gchar* _tmp8_ = NULL;
			_tmp8_ = deja_dup_config_url_part_userinfo_set_domain (uri->scheme, uri->userinfo, userval);
			_g_free0 (uri->userinfo);
			uri->userinfo = _tmp8_;
			break;
		}
		default:
		break;
	}
	deja_dup_config_url_part_scrub_uri (uri);
	_tmp9_ = deja_dup_decoded_uri_encode_uri (uri, TRUE);
	val = _tmp9_;
	g_settings_set_string (settings, key, val);
	_g_free0 (val);
	_deja_dup_decoded_uri_free0 (uri);
}


static DejaDupDecodedUri* deja_dup_config_url_part_get_current_uri (GSettings* settings, const gchar* key) {
	DejaDupDecodedUri* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* val;
	DejaDupDecodedUri* _tmp2_ = NULL;
	DejaDupDecodedUri* uri;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_settings_get_string (settings, key);
	val = _tmp0_;
	if (val == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (val);
		val = _tmp1_;
	}
	_tmp2_ = deja_dup_decoded_uri_decode_uri (val);
	uri = _tmp2_;
	if (uri == NULL) {
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFile* file;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		DejaDupDecodedUri* _tmp7_ = NULL;
		_tmp3_ = g_file_parse_name (val);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		file = _tmp4_;
		_tmp5_ = g_file_get_uri (file);
		_tmp6_ = _tmp5_;
		_tmp7_ = deja_dup_decoded_uri_decode_uri (_tmp6_);
		_deja_dup_decoded_uri_free0 (uri);
		uri = _tmp7_;
		_g_free0 (_tmp6_);
		_g_object_unref0 (file);
	}
	if (uri == NULL) {
		DejaDupDecodedUri* _tmp8_ = NULL;
		_tmp8_ = deja_dup_decoded_uri_new ();
		_deja_dup_decoded_uri_free0 (uri);
		uri = _tmp8_;
	}
	result = uri;
	_g_free0 (val);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_get_user (const gchar* scheme, const gchar* userinfo) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp7_;
	if (userinfo == NULL) {
		result = NULL;
		return result;
	}
	if (g_strcmp0 (scheme, "smb") == 0) {
		gboolean _tmp1_;
		_tmp1_ = string_contains (userinfo, ";");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = _tmp2_ = g_strsplit (userinfo, ";", 2);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		_tmp5_ = g_strdup (_tmp4_[1]);
		_tmp6_ = _tmp5_;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = g_strdup (userinfo);
	result = _tmp7_;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_get_domain (const gchar* scheme, const gchar* userinfo) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (userinfo == NULL) {
		result = NULL;
		return result;
	}
	if (g_strcmp0 (scheme, "smb") == 0) {
		gboolean _tmp1_;
		_tmp1_ = string_contains (userinfo, ";");
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = _tmp2_ = g_strsplit (userinfo, ";", 2);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		_tmp5_ = g_strdup (_tmp4_[0]);
		_tmp6_ = _tmp5_;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		result = _tmp6_;
		return result;
	}
	result = NULL;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_set_user (const gchar* scheme, const gchar* userinfo, const gchar* user) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* domain;
	gchar* _tmp2_;
	g_return_val_if_fail (user != NULL, NULL);
	_tmp0_ = deja_dup_config_url_part_userinfo_get_domain (scheme, userinfo);
	domain = _tmp0_;
	if (domain != NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup_printf ("%s;%s", domain, user);
		result = _tmp1_;
		_g_free0 (domain);
		return result;
	}
	_tmp2_ = g_strdup (user);
	result = _tmp2_;
	_g_free0 (domain);
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_set_domain (const gchar* scheme, const gchar* userinfo, const gchar* domain) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* user;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = deja_dup_config_url_part_userinfo_get_user (scheme, userinfo);
	user = _tmp0_;
	if (user == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (user);
		user = _tmp1_;
	}
	if (g_strcmp0 (domain, "") == 0) {
		result = user;
		return result;
	}
	_tmp2_ = g_strdup_printf ("%s;%s", domain, user);
	result = _tmp2_;
	_g_free0 (user);
	return result;
}


static void deja_dup_config_url_part_scrub_uri (DejaDupDecodedUri* uri) {
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	static GQuark _tmp3__label1 = 0;
	g_return_if_fail (uri != NULL);
	if (uri->scheme == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("file");
		_g_free0 (uri->scheme);
		uri->scheme = _tmp0_;
	}
	if (g_strcmp0 (uri->userinfo, "") == 0) {
		_g_free0 (uri->userinfo);
		uri->userinfo = NULL;
	}
	if (uri->path == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (uri->path);
		uri->path = _tmp1_;
	}
	_tmp2_ = uri->scheme;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				uri->port = -1;
				_g_free0 (uri->host);
				uri->host = NULL;
				_g_free0 (uri->userinfo);
				uri->userinfo = NULL;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("smb")))) {
		switch (0) {
			default:
			{
				uri->port = -1;
				break;
			}
		}
	}
}


DejaDupConfigURLPartPart deja_dup_config_url_part_get_part (DejaDupConfigURLPart* self) {
	DejaDupConfigURLPartPart result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_part;
	return result;
}


static void deja_dup_config_url_part_set_part (DejaDupConfigURLPart* self, DejaDupConfigURLPartPart value) {
	g_return_if_fail (self != NULL);
	self->priv->_part = value;
	g_object_notify ((GObject *) self, "part");
}


static void deja_dup_config_url_part_class_init (DejaDupConfigURLPartClass * klass) {
	deja_dup_config_url_part_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigURLPartPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_url_part_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_url_part_real_set_from_config_finish;
	DEJA_DUP_CONFIG_ENTRY_CLASS (klass)->write_to_config = deja_dup_config_url_part_real_write_to_config;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_config_url_part_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_config_url_part_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_url_part_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_URL_PART_PART, g_param_spec_enum ("part", "part", "part", DEJA_DUP_CONFIG_URL_PART_TYPE_PART, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_url_part_instance_init (DejaDupConfigURLPart * self) {
	self->priv = DEJA_DUP_CONFIG_URL_PART_GET_PRIVATE (self);
}


static void deja_dup_config_url_part_finalize (GObject* obj) {
	DejaDupConfigURLPart * self;
	self = DEJA_DUP_CONFIG_URL_PART (obj);
	G_OBJECT_CLASS (deja_dup_config_url_part_parent_class)->finalize (obj);
}


GType deja_dup_config_url_part_get_type (void) {
	static volatile gsize deja_dup_config_url_part_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_url_part_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigURLPartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_url_part_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigURLPart), 0, (GInstanceInitFunc) deja_dup_config_url_part_instance_init, NULL };
		GType deja_dup_config_url_part_type_id;
		deja_dup_config_url_part_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_ENTRY, "DejaDupConfigURLPart", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_url_part_type_id__volatile, deja_dup_config_url_part_type_id);
	}
	return deja_dup_config_url_part_type_id__volatile;
}


static void _vala_deja_dup_config_url_part_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigURLPart * self;
	self = DEJA_DUP_CONFIG_URL_PART (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_URL_PART_PART:
		g_value_set_enum (value, deja_dup_config_url_part_get_part (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_config_url_part_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigURLPart * self;
	self = DEJA_DUP_CONFIG_URL_PART (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_URL_PART_PART:
		deja_dup_config_url_part_set_part (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



