/* AssistantOperation.c generated by valac 0.12.0, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>
    © 2010 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <whacks.h>
#include <gnome-keyring.h>
#include <chacks.h>
#include <config.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantOperationDoApplyData AssistantOperationDoApplyData;

#define STATUS_ICON_TYPE_CLOSE_ACTION (status_icon_close_action_get_type ())

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
	void (*hide_for_now) (Assistant* self);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	gboolean _automatic;
	GtkEntry* encrypt_entry;
	GtkEntry* encrypt_confirm_entry;
	GtkCheckButton* encrypt_remember;
	GtkWidget* _password_page;
	GtkLabel* question_label;
	GtkWidget* _question_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkLabel* secondary_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkExpander* progress_expander;
	GtkWidget* _progress_page;
	GtkWidget* error_widget;
	GtkTextView* error_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _op_icon;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean saved_pos;
	gint saved_x;
	gint saved_y;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantOperationDoApplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantOperation* self;
	DejaDupOperation* _tmp0_;
	DejaDupBackend* _tmp1_;
	MountOperationAssistant* _tmp2_;
	MountOperationAssistant* _tmp3_;
	DejaDupBackend* _tmp4_;
};

typedef enum  {
	STATUS_ICON_CLOSE_ACTION_HIDE,
	STATUS_ICON_CLOSE_ACTION_MINIMIZE
} StatusIconCloseAction;


static gpointer assistant_operation_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_AUTOMATIC,
	ASSISTANT_OPERATION_PASSWORD_PAGE,
	ASSISTANT_OPERATION_QUESTION_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_OP_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
void assistant_operation_set_op_icon_name (AssistantOperation* self);
static void assistant_operation_real_set_op_icon_name (AssistantOperation* self);
GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual);
static void assistant_operation_set_secondary_label (AssistantOperation* self, DejaDupOperation* op, const gchar* text);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_set_header_icon (Assistant* self, const gchar* name);
GtkWidget* assistant_operation_make_password_page (AssistantOperation* self);
static void _lambda6_ (AssistantOperation* self);
static void assistant_operation_check_password_validity (AssistantOperation* self);
static void __lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static gboolean assistant_operation_is_first_time (AssistantOperation* self);
static void _lambda7_ (AssistantOperation* self);
static void __lambda7__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda8_ (GtkToggleButton* button, AssistantOperation* self);
static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
GtkWidget* assistant_operation_make_question_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_password_page (AssistantOperation* self);
static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_question_page (AssistantOperation* self);
static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o);
StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
static void _lambda10_ (StatusIcon* s, AssistantOperation* self);
static void __lambda10__status_icon_show_window (StatusIcon* _sender, gpointer self);
static void _lambda11_ (StatusIcon* s, AssistantOperation* self);
void assistant_operation_hide_everything (AssistantOperation* self);
static void __lambda11__status_icon_hide_all (StatusIcon* _sender, gpointer self);
static void assistant_operation_do_apply_data_free (gpointer _data);
void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_);
static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* data);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _lambda12_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantOperation* self);
static void __lambda12__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message);
static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self);
static void _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed (DejaDupOperation* _sender, const gchar* msg, gpointer self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
static void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self);
GtkWidget* assistant_operation_get_password_page (AssistantOperation* self);
static void assistant_operation_real_hide_for_now (Assistant* base);
GType status_icon_close_action_get_type (void) G_GNUC_CONST;
StatusIconCloseAction status_icon_get_close_action (StatusIcon* self);
void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_operation_real_do_cancel (AssistantOperation* self);
static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEvent* event);
void assistant_hide_for_now (Assistant* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
static gboolean _lambda9_ (AssistantOperation* self);
static gboolean __lambda9__gsource_func (gpointer self);
static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click);
static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e);
static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const gchar* str);
static void assistant_operation_ask_passphrase (AssistantOperation* self);
static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const gchar* str, gpointer self);
static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_);
void assistant_allow_forward (Assistant* self, gboolean allow);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self);
static void assistant_operation_stop_question (AssistantOperation* self, GtkDialog* dlg, gint resp);
static void _assistant_operation_stop_question_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GtkWidget* assistant_operation_get_question_page (AssistantOperation* self);
AssistantOperation* assistant_operation_construct (GType object_type);
Assistant* assistant_construct (GType object_type);
static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self);
static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self);
static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void assistant_operation_finalize (GObject* obj);
static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_make_confirm_page'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_custom_config_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_custom_config_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static void assistant_operation_real_set_op_icon_name (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_set_op_icon_name (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->set_op_icon_name (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GtkIconTheme* _tmp2_ = NULL;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* theme;
	const gchar* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_window_get_icon_name ((GtkWindow*) self);
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = gtk_icon_theme_get_for_screen (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	theme = _tmp3_;
	_tmp4_ = gtk_window_get_icon_name ((GtkWindow*) self);
	_tmp5_ = gtk_icon_theme_load_icon (theme, _tmp4_, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (theme);
		goto __catch1_g_error;
	}
	result = _tmp6_;
	_g_object_unref0 (theme);
	return result;
	_g_object_unref0 (theme);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("AssistantOperation.vala:131: %s\n", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		gtk_progress_bar_pulse (self->priv->progress_bar);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	gtk_progress_bar_set_fraction (self->priv->progress_bar, percent);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	gtk_label_set_label (self->priv->progress_label, label);
	gtk_label_set_label (self->priv->progress_file_label, "");
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual) {
	gchar* _tmp0_ = NULL;
	gchar* parse_name;
	gchar* prefix = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* log_line;
	gboolean adjustment_at_end;
	GtkAdjustment* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_;
	GtkAdjustment* adjust;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* buffer;
	gint _tmp24_;
	gboolean _tmp26_ = FALSE;
	gint _tmp27_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp31_ = {0};
	gint _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_parse_name (file);
	parse_name = _tmp0_;
	if (actual) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = assistant_operation_get_progress_file_prefix (self);
		_g_free0 (prefix);
		prefix = _tmp1_;
		_tmp2_ = g_strconcat (prefix, " ", NULL);
		_tmp3_ = _tmp2_;
		gtk_label_set_label (self->priv->progress_label, _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = g_path_get_basename (parse_name);
		_tmp5_ = _tmp4_;
		gtk_label_set_label (self->priv->progress_file_label, _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("Scanning:");
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (prefix);
		prefix = _tmp7_;
		_tmp8_ = _ ("Scanning…");
		gtk_label_set_label (self->priv->progress_label, _tmp8_);
		gtk_label_set_label (self->priv->progress_file_label, "");
	}
	_tmp9_ = g_strconcat (prefix, " ", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, parse_name, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	log_line = _tmp12_;
	adjustment_at_end = FALSE;
	_tmp13_ = gtk_scrolled_window_get_vadjustment (self->priv->progress_scroll);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	adjust = _tmp14_;
	_tmp17_ = gtk_adjustment_get_value (adjust);
	_tmp18_ = gtk_adjustment_get_upper (adjust);
	_tmp19_ = gtk_adjustment_get_page_size (adjust);
	if (_tmp17_ >= (_tmp18_ - _tmp19_)) {
		_tmp16_ = TRUE;
	} else {
		gdouble _tmp20_;
		_tmp20_ = gtk_adjustment_get_page_size (adjust);
		_tmp16_ = _tmp20_ == 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = gtk_expander_get_expanded (self->priv->progress_expander);
		_tmp15_ = !_tmp21_;
	}
	if (_tmp15_) {
		adjustment_at_end = TRUE;
	}
	_tmp22_ = gtk_text_view_get_buffer (self->priv->progress_text);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	buffer = _tmp23_;
	_tmp24_ = gtk_text_buffer_get_char_count (buffer);
	if (_tmp24_ > 0) {
		gchar* _tmp25_;
		_tmp25_ = g_strconcat ("\n", log_line, NULL);
		_g_free0 (log_line);
		log_line = _tmp25_;
	}
	_tmp27_ = gtk_text_buffer_get_line_count (buffer);
	if (_tmp27_ >= 100) {
		_tmp26_ = adjustment_at_end;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GtkTextIter start = {0};
		GtkTextIter line100 = {0};
		GtkTextIter _tmp28_ = {0};
		gint _tmp29_;
		GtkTextIter _tmp30_ = {0};
		gtk_text_buffer_get_start_iter (buffer, &_tmp28_);
		start = _tmp28_;
		_tmp29_ = gtk_text_buffer_get_line_count (buffer);
		gtk_text_buffer_get_iter_at_line (buffer, &_tmp30_, _tmp29_ - 100);
		line100 = _tmp30_;
		gtk_text_buffer_delete (buffer, &start, &line100);
	}
	gtk_text_buffer_get_end_iter (buffer, &_tmp31_);
	iter = _tmp31_;
	_tmp32_ = strlen (log_line);
	g_signal_emit_by_name (buffer, "insert-text", &iter, log_line, (gint) _tmp32_);
	if (adjustment_at_end) {
		gdouble _tmp33_;
		_tmp33_ = gtk_adjustment_get_upper (adjust);
		gtk_adjustment_set_value (adjust, _tmp33_);
	}
	_g_object_unref0 (buffer);
	_g_object_unref0 (adjust);
	_g_free0 (log_line);
	_g_free0 (prefix);
	_g_free0 (parse_name);
}


static void assistant_operation_set_secondary_label (AssistantOperation* self, DejaDupOperation* op, const gchar* text) {
	GtkVBox* _tmp0_;
	GtkVBox* page;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = _g_object_ref0 (GTK_VBOX (self->priv->_progress_page));
	page = _tmp0_;
	if (text != NULL) {
		_tmp1_ = g_strcmp0 (text, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = g_strconcat ("<i>", text, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "</i>", NULL);
		_tmp5_ = _tmp4_;
		gtk_label_set_label (self->priv->secondary_label, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		gtk_widget_show ((GtkWidget*) self->priv->secondary_label);
		gtk_container_add ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label);
		gtk_box_reorder_child ((GtkBox*) page, (GtkWidget*) self->priv->secondary_label, 1);
		gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label, "expand", FALSE, NULL);
	} else {
		gtk_container_remove ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label);
	}
	_g_object_unref0 (page);
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* progress_hbox;
	GtkProgressBar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkTextView* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkExpander* _tmp8_ = NULL;
	GtkVBox* _tmp9_ = NULL;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) self->priv->progress_label, "xalign", 0.0f, NULL);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->progress_file_label);
	self->priv->progress_file_label = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) self->priv->progress_file_label, "xalign", 0.0f, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	progress_hbox = g_object_ref_sink (_tmp2_);
	g_object_set ((GObject*) progress_hbox, "child", self->priv->progress_label, "child", self->priv->progress_file_label, NULL);
	gtk_container_child_set ((GtkContainer*) progress_hbox, (GtkWidget*) self->priv->progress_label, "expand", FALSE, NULL);
	_tmp3_ = (GtkProgressBar*) gtk_progress_bar_new ();
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->secondary_label);
	self->priv->secondary_label = g_object_ref_sink (_tmp4_);
	g_object_set ((GObject*) self->priv->secondary_label, "xalign", 0.0f, "wrap", TRUE, "use-markup", TRUE, NULL);
	_tmp5_ = (GtkTextView*) gtk_text_view_new ();
	_g_object_unref0 (self->priv->progress_text);
	self->priv->progress_text = g_object_ref_sink (_tmp5_);
	gtk_text_view_set_editable (self->priv->progress_text, FALSE);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_g_object_unref0 (self->priv->progress_scroll);
	self->priv->progress_scroll = g_object_ref_sink (_tmp6_);
	g_object_set ((GObject*) self->priv->progress_scroll, "child", self->priv->progress_text, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, "border-width", 0, NULL);
	_tmp7_ = _ ("_Details");
	_tmp8_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp7_);
	_g_object_unref0 (self->priv->progress_expander);
	self->priv->progress_expander = g_object_ref_sink (_tmp8_);
	g_object_set ((GObject*) self->priv->progress_expander, "child", self->priv->progress_scroll, NULL);
	_tmp9_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	page = g_object_ref_sink (_tmp9_);
	g_object_set ((GObject*) page, "child", progress_hbox, "child", self->priv->progress_bar, "child", self->priv->progress_expander, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) progress_hbox, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->progress_bar, "expand", FALSE, NULL);
	gtk_widget_set_size_request ((GtkWidget*) page, -1, 200);
	result = (GtkWidget*) page;
	_g_object_unref0 (progress_hbox);
	return result;
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	assistant_operation_set_error_occurred (self, TRUE);
	gtk_label_set_label (self->summary_label, _error_);
	g_object_set (self->summary_label, "wrap", TRUE, NULL);
	gtk_label_set_selectable (self->summary_label, TRUE);
	if (detail != NULL) {
		GtkTextBuffer* _tmp0_ = NULL;
		gtk_widget_set_size_request ((GtkWidget*) ((Assistant*) self)->page_box, 300, 200);
		gtk_widget_set_no_show_all (self->priv->error_widget, FALSE);
		gtk_widget_show_all (self->priv->error_widget);
		_tmp0_ = gtk_text_view_get_buffer (self->priv->error_text_view);
		gtk_text_buffer_set_text (_tmp0_, detail, -1);
	}
	assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
	assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_ERROR);
	gtk_widget_queue_resize ((GtkWidget*) ((Assistant*) self)->page_box);
}


void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, _error_, detail);
}


static void _lambda6_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void __lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda6_ (self);
}


static void _lambda7_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void __lambda7__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (GtkToggleButton* button, AssistantOperation* self) {
	gboolean _tmp0_;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	gtk_entry_set_visibility (self->priv->encrypt_entry, _tmp0_);
	if (self->priv->encrypt_confirm_entry != NULL) {
		gboolean _tmp1_;
		_tmp1_ = gtk_toggle_button_get_active (button);
		gtk_entry_set_visibility (self->priv->encrypt_confirm_entry, _tmp1_);
	}
}


static void __lambda8__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


GtkWidget* assistant_operation_make_password_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkTable* _tmp0_ = NULL;
	GtkTable* page;
	GtkEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkEntry* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp10_ = NULL;
	GtkCheckButton* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) w, "visibility", FALSE, "activates-default", TRUE, NULL);
	g_signal_connect_object ((GtkEditable*) GTK_ENTRY (w), "changed", (GCallback) __lambda6__gtk_editable_changed, self, 0);
	_tmp2_ = _ ("E_ncryption password:");
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	_g_object_unref0 (label);
	label = (GtkWidget*) g_object_ref_sink (_tmp3_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp4_ = _g_object_ref0 (GTK_ENTRY (w));
	_g_object_unref0 (self->priv->encrypt_entry);
	self->priv->encrypt_entry = _tmp4_;
	_tmp5_ = assistant_operation_is_first_time (self);
	if (_tmp5_) {
		GtkEntry* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		GtkEntry* _tmp9_;
		_tmp6_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (w);
		w = (GtkWidget*) g_object_ref_sink (_tmp6_);
		g_object_set ((GObject*) w, "visibility", FALSE, "activates-default", TRUE, NULL);
		g_signal_connect_object ((GtkEditable*) GTK_ENTRY (w), "changed", (GCallback) __lambda7__gtk_editable_changed, self, 0);
		_tmp7_ = _ ("Confir_m password:");
		_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
		_g_object_unref0 (label);
		label = (GtkWidget*) g_object_ref_sink (_tmp8_);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
		rows = rows + 1;
		_tmp9_ = _g_object_ref0 (GTK_ENTRY (w));
		_g_object_unref0 (self->priv->encrypt_confirm_entry);
		self->priv->encrypt_confirm_entry = _tmp9_;
	}
	_tmp10_ = _ ("_Show password");
	_tmp11_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp10_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp11_);
	g_signal_connect_object ((GtkToggleButton*) GTK_CHECK_BUTTON (w), "toggled", (GCallback) __lambda8__gtk_toggle_button_toggled, self, 0);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp12_ = _ ("_Remember password");
	_tmp13_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp12_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp13_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp14_ = _g_object_ref0 (GTK_CHECK_BUTTON (w));
	_g_object_unref0 (self->priv->encrypt_remember);
	self->priv->encrypt_remember = _tmp14_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


GtkWidget* assistant_operation_make_question_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkTable* _tmp0_ = NULL;
	GtkTable* page;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* label;
	GtkLabel* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE);
	page = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) label, "use-underline", TRUE, "wrap", TRUE, "xalign", 0.0f, NULL);
	gtk_table_attach (page, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	_tmp2_ = _g_object_ref0 (label);
	_g_object_unref0 (self->priv->question_label);
	self->priv->question_label = _tmp2_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	return result;
}


static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkTextView* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkScrolledWindow* scroll;
	GtkWidget* _tmp3_;
	GtkVBox* _tmp4_ = NULL;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->summary_label);
	self->summary_label = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) self->summary_label, "xalign", 0.0f, NULL);
	_tmp1_ = (GtkTextView*) gtk_text_view_new ();
	_g_object_unref0 (self->priv->error_text_view);
	self->priv->error_text_view = g_object_ref_sink (_tmp1_);
	gtk_text_view_set_editable (self->priv->error_text_view, FALSE);
	gtk_text_view_set_wrap_mode (self->priv->error_text_view, GTK_WRAP_WORD);
	g_object_set ((GtkWidget*) self->priv->error_text_view, "height-request", 150, NULL);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scroll = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->error_text_view);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	_tmp3_ = _g_object_ref0 ((GtkWidget*) scroll);
	_g_object_unref0 (self->priv->error_widget);
	self->priv->error_widget = _tmp3_;
	_tmp4_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	page = g_object_ref_sink (_tmp4_);
	g_object_set ((GObject*) page, "child", self->summary_label, "child", self->priv->error_widget, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->summary_label, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static gboolean assistant_operation_is_first_time (AssistantOperation* self) {
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* val;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RUN_KEY);
	val = _tmp1_;
	result = g_strcmp0 (val, "") == 0;
	_g_free0 (val);
	_g_object_unref0 (settings);
	return result;
}


static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_is_first_time (self);
	if (_tmp0_) {
		assistant_operation_add_custom_config_pages (self);
	}
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_confirm_page (self);
	page = _tmp0_;
	if (page == NULL) {
		_g_object_unref0 (page);
		return;
	}
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_SUMMARY);
	_tmp1_ = _ ("Summary");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	assistant_operation_set_confirm_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_progress_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_password_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_password_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	_tmp1_ = _ ("Password Needed");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	assistant_operation_set_password_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_question_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_question_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_question_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_summary_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_FINISH);
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_g_object_unref0 (self->status_icon);
	self->status_icon = NULL;
	_g_object_unref0 (self->op);
	self->op = NULL;
	if (cancelled) {
		if (success) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close (self);
		}
	} else {
		if (success) {
			self->succeeded = TRUE;
			assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
		} else {
			assistant_operation_force_visible (self, FALSE);
		}
	}
}


void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	ASSISTANT_OPERATION_GET_CLASS (self)->apply_finished (self, op, success, cancelled);
}


static void _lambda10_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_force_visible (self, TRUE);
}


static void __lambda10__status_icon_show_window (StatusIcon* _sender, gpointer self) {
	_lambda10_ (_sender, self);
}


static void _lambda11_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_hide_everything (self);
}


static void __lambda11__status_icon_hide_all (StatusIcon* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (self->status_icon == NULL) {
		StatusIcon* _tmp0_ = NULL;
		_tmp0_ = status_icon_create ((GtkWindow*) self, o, self->priv->_automatic);
		_g_object_unref0 (self->status_icon);
		self->status_icon = _tmp0_;
		g_signal_connect_object (self->status_icon, "show-window", (GCallback) __lambda10__status_icon_show_window, self, 0);
		g_signal_connect_object (self->status_icon, "hide-all", (GCallback) __lambda11__status_icon_hide_all, self, 0);
	}
}


static void assistant_operation_do_apply_data_free (gpointer _data) {
	AssistantOperationDoApplyData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AssistantOperationDoApplyData, data);
}


void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantOperationDoApplyData* _data_;
	_data_ = g_slice_new0 (AssistantOperationDoApplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_operation_do_apply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_operation_do_apply_data_free);
	_data_->self = _g_object_ref0 (self);
	assistant_operation_do_apply_co (_data_);
}


void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_) {
	AssistantOperationDoApplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_operation_apply_finished (self, _sender, success, cancelled);
}


static void _lambda12_ (DejaDupOperation* o, const gchar* e, const gchar* d, AssistantOperation* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error (self, e, d);
}


static void __lambda12__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	_lambda12_ (_sender, errstr, detail, self);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self) {
	assistant_operation_set_progress_label (self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self) {
	assistant_operation_set_progress_label_file (self, _sender, file, actual);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	assistant_operation_show_progress (self, _sender, percent);
}


static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self) {
	assistant_operation_show_question (self, _sender, title, msg);
}


static void _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed (DejaDupOperation* _sender, const gchar* msg, gpointer self) {
	assistant_operation_set_secondary_label (self, _sender, msg);
}


static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self) {
	assistant_operation_pause_op (self, _sender, header, msg);
}


static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = assistant_operation_create_op (data->self);
	_g_object_unref0 (data->self->op);
	data->self->op = data->_tmp0_;
	g_signal_connect_object (data->self->op, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, data->self, 0);
	g_signal_connect_object (data->self->op, "raise-error", (GCallback) __lambda12__deja_dup_operation_raise_error, data->self, 0);
	g_signal_connect_object (data->self->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, data->self, 0);
	g_signal_connect_object (data->self->op, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, data->self, 0);
	g_signal_connect_object (data->self->op, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, data->self, 0);
	g_signal_connect_object (data->self->op, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, data->self, 0);
	g_signal_connect_object (data->self->op, "question", (GCallback) _assistant_operation_show_question_deja_dup_operation_question, data->self, 0);
	g_signal_connect_object (data->self->op, "secondary-desc-changed", (GCallback) _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed, data->self, 0);
	data->_tmp1_ = NULL;
	data->_tmp1_ = deja_dup_operation_get_backend (data->self->op);
	data->_tmp2_ = NULL;
	data->_tmp2_ = mount_operation_assistant_new (data->self);
	data->_tmp3_ = data->_tmp2_;
	deja_dup_backend_set_mount_op (data->_tmp1_, (GMountOperation*) data->_tmp3_);
	_g_object_unref0 (data->_tmp3_);
	data->_tmp4_ = NULL;
	data->_tmp4_ = deja_dup_operation_get_backend (data->self->op);
	g_signal_connect_object (data->_tmp4_, "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, data->self, 0);
	assistant_operation_ensure_status_icon (data->self, data->self->op);
	deja_dup_operation_start (data->self->op, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_operation_pulse (self);
	return result;
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	if (page == self->priv->_confirm_page) {
		if (self->op != NULL) {
			guint _tmp0_;
			g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			deja_dup_operation_cancel (self->op);
			_g_object_unref0 (self->op);
			self->op = NULL;
		}
	} else {
		if (page == self->priv->_progress_page) {
			guint _tmp1_;
			gboolean _tmp2_ = FALSE;
			gtk_progress_bar_set_fraction (self->priv->progress_bar, (gdouble) 0);
			_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->timeout_id = _tmp1_;
			if (self->op != NULL) {
				gboolean _tmp3_;
				_tmp3_ = deja_dup_operation_get_needs_password (self->op);
				_tmp2_ = _tmp3_;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				assistant_operation_provide_password (self);
			} else {
				if (self->op == NULL) {
					assistant_operation_do_apply (self, NULL, NULL);
				}
			}
		} else {
			if (page == self->priv->_password_page) {
				assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_AUTHENTICATION);
			}
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


static void assistant_operation_real_hide_for_now (Assistant* base) {
	AssistantOperation * self;
	gboolean _tmp0_ = FALSE;
	self = (AssistantOperation*) base;
	if (self->status_icon != NULL) {
		StatusIconCloseAction _tmp1_;
		_tmp1_ = status_icon_get_close_action (self->status_icon);
		_tmp0_ = _tmp1_ == STATUS_ICON_CLOSE_ACTION_MINIMIZE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_window_iconify ((GtkWindow*) self);
		gtk_widget_show ((GtkWidget*) self);
		gtk_window_iconify ((GtkWindow*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


void assistant_operation_hide_everything (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_g_object_unref0 (self->status_icon);
	self->status_icon = NULL;
}


static void assistant_operation_real_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything (self);
	if (self->op != NULL) {
		deja_dup_operation_cancel (self->op);
	} else {
		assistant_operation_do_close (self);
	}
}


void assistant_operation_do_cancel (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_cancel (self);
}


static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->op != NULL) {
		assistant_hide_for_now ((Assistant*) self);
	} else {
		assistant_operation_do_cancel (self);
	}
	result = TRUE;
	return result;
}


static gboolean _lambda9_ (AssistantOperation* self) {
	gboolean result = FALSE;
	hacks_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	g_signal_emit_by_name (self, "closing", self->succeeded);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda9__gsource_func, g_object_ref (self), g_object_unref);
}


void assistant_operation_do_close (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_get_current_event_time ();
	assistant_operation_show_to_user (self, (GtkWindow*) self, (guint) _tmp0_, user_click);
}


static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = assistant_operation_user_focused (self, _sender, event);
	return result;
}


static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (win != NULL, FALSE);
	gtk_window_set_urgency_hint (GTK_WINDOW (win), FALSE);
	g_signal_parse_name ("focus-in-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self);
	result = FALSE;
	return result;
}


static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	gtk_window_set_focus_on_map (win, user_click);
	if (self->priv->saved_pos) {
		gtk_window_move (win, self->priv->saved_x, self->priv->saved_y);
	}
	if (user_click) {
		gtk_window_present_with_time (win, (guint32) time);
	} else {
		gboolean _tmp0_;
		g_object_get (win, "is-active", &_tmp0_, NULL);
		if (!_tmp0_) {
			gtk_window_set_urgency_hint (win, TRUE);
			g_signal_connect_object ((GtkWidget*) win, "focus-in-event", (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self, 0);
			gtk_widget_show ((GtkWidget*) win);
		}
	}
}


static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const gchar* str) {
	g_return_if_fail (self != NULL);
	if (str != NULL) {
		deja_dup_operation_continue_with_passphrase (self->op, str, NULL, NULL);
	} else {
		assistant_operation_ask_passphrase (self);
	}
}


static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const gchar* str, gpointer self) {
	assistant_operation_found_passphrase (self, _result_, str);
}


void assistant_operation_get_passphrase (AssistantOperation* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* testing;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing = _tmp1_;
	if (testing == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (testing, "") == 0;
	}
	if (_tmp2_) {
		gnome_keyring_find_password (PASSPHRASE_SCHEMA, _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
	} else {
		assistant_operation_ask_passphrase (self);
	}
	_g_free0 (testing);
}


static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_) {
	g_return_if_fail (self != NULL);
}


static void assistant_operation_check_password_validity (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->encrypt_confirm_entry != NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* passphrase;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* passphrase2;
		gboolean valid;
		_tmp0_ = gtk_entry_get_text (self->priv->encrypt_entry);
		_tmp1_ = g_strdup (_tmp0_);
		passphrase = _tmp1_;
		_tmp2_ = gtk_entry_get_text (self->priv->encrypt_confirm_entry);
		_tmp3_ = g_strdup (_tmp2_);
		passphrase2 = _tmp3_;
		valid = g_strcmp0 (passphrase, passphrase2) == 0;
		assistant_allow_forward ((Assistant*) self, valid);
		_g_free0 (passphrase2);
		_g_free0 (passphrase);
	} else {
		assistant_allow_forward ((Assistant*) self, TRUE);
	}
}


static void assistant_operation_ask_passphrase (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	assistant_interrupt ((Assistant*) self, self->priv->_password_page, TRUE);
	assistant_operation_check_password_validity (self);
	assistant_operation_force_visible (self, FALSE);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self) {
	assistant_operation_save_password_callback (self, _result_);
}


void assistant_operation_provide_password (AssistantOperation* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* passphrase;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->encrypt_entry);
	_tmp1_ = g_strdup (_tmp0_);
	passphrase = _tmp1_;
	_tmp2_ = string_strip (passphrase);
	_g_free0 (passphrase);
	passphrase = _tmp2_;
	if (g_strcmp0 (passphrase, "") != 0) {
		gboolean _tmp3_;
		_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->encrypt_remember);
		if (_tmp3_) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = _ ("Déjà Dup backup passphrase");
			gnome_keyring_store_password (PASSPHRASE_SCHEMA, GNOME_KEYRING_DEFAULT, _tmp4_, passphrase, _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
		}
	}
	deja_dup_operation_continue_with_passphrase (self->op, passphrase, NULL, NULL);
	_g_free0 (passphrase);
}


static void _assistant_operation_stop_question_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	assistant_operation_stop_question (self, _sender, response_id);
}


static void assistant_operation_stop_question (AssistantOperation* self, GtkDialog* dlg, gint resp) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	gtk_main_quit ();
	g_signal_parse_name ("response", GTK_TYPE_DIALOG, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkDialog*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_question_gtk_dialog_response, self);
}


static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	assistant_set_page_title ((Assistant*) self, self->priv->_question_page, title);
	gtk_label_set_label (self->priv->question_label, message);
	assistant_interrupt ((Assistant*) self, self->priv->_question_page, TRUE);
	assistant_operation_force_visible (self, FALSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _assistant_operation_stop_question_gtk_dialog_response, self, 0);
	gtk_main ();
}


static void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (back != NULL);
	g_return_if_fail (header != NULL);
	g_return_if_fail (msg != NULL);
	assistant_set_page_title ((Assistant*) self, self->priv->_question_page, header);
	gtk_label_set_label (self->priv->question_label, msg);
	assistant_interrupt ((Assistant*) self, self->priv->_question_page, FALSE);
	assistant_operation_force_visible (self, FALSE);
}


AssistantOperation* assistant_operation_construct (GType object_type) {
	AssistantOperation * self = NULL;
	self = (AssistantOperation*) assistant_construct (object_type);
	return self;
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_confirm_page;
	return result;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_confirm_page);
	self->priv->_confirm_page = _tmp0_;
	g_object_notify ((GObject *) self, "confirm-page");
}


gboolean assistant_operation_get_automatic (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}


static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatic = value;
	g_object_notify ((GObject *) self, "automatic");
}


GtkWidget* assistant_operation_get_password_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_password_page;
	return result;
}


static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_password_page);
	self->priv->_password_page = _tmp0_;
	g_object_notify ((GObject *) self, "password-page");
}


GtkWidget* assistant_operation_get_question_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_question_page;
	return result;
}


static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_question_page);
	self->priv->_question_page = _tmp0_;
	g_object_notify ((GObject *) self, "question-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_progress_page;
	return result;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_progress_page);
	self->priv->_progress_page = _tmp0_;
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_summary_page;
	return result;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_summary_page);
	self->priv->_summary_page = _tmp0_;
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op_icon;
	return result;
}


static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_op_icon);
	self->priv->_op_icon = _tmp0_;
	g_object_notify ((GObject *) self, "op-icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_occurred;
	return result;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_occurred = value;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self) {
	assistant_operation_do_cancel (self);
}


static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self) {
	assistant_operation_do_close (self);
}


static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare (self, _sender, page);
}


static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = assistant_operation_do_minimize_to_tray (self, event);
	return result;
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_OPERATION (obj);
	assistant_operation_set_op_icon_name (self);
	_tmp0_ = assistant_operation_make_op_icon (self);
	_tmp1_ = _tmp0_;
	assistant_operation_set_op_icon (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_set (((Assistant*) self)->header_icon, "pixbuf", self->priv->_op_icon, NULL);
	assistant_operation_add_config_pages_if_needed (self);
	assistant_operation_add_setup_pages (self);
	assistant_operation_add_confirm_page (self);
	assistant_operation_add_password_page (self);
	assistant_operation_add_question_page (self);
	assistant_operation_add_progress_page (self);
	assistant_operation_add_summary_page (self);
	g_signal_connect_object ((Assistant*) self, "canceled", (GCallback) _assistant_operation_do_cancel_assistant_canceled, self, 0);
	g_signal_connect_object ((Assistant*) self, "closed", (GCallback) _assistant_operation_do_close_assistant_closed, self, 0);
	g_signal_connect_object ((Assistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event, self, 0);
	return obj;
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_operation_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_operation_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_operation_real_set_op_icon_name;
	ASSISTANT_OPERATION_CLASS (klass)->make_progress_page = assistant_operation_real_make_progress_page;
	ASSISTANT_OPERATION_CLASS (klass)->show_error = assistant_operation_real_show_error;
	ASSISTANT_OPERATION_CLASS (klass)->make_summary_page = assistant_operation_real_make_summary_page;
	ASSISTANT_OPERATION_CLASS (klass)->apply_finished = assistant_operation_real_apply_finished;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_operation_real_do_prepare;
	ASSISTANT_CLASS (klass)->hide_for_now = assistant_operation_real_hide_for_now;
	ASSISTANT_OPERATION_CLASS (klass)->do_cancel = assistant_operation_real_do_cancel;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PASSWORD_PAGE, g_param_spec_object ("password-page", "password-page", "password-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_QUESTION_PAGE, g_param_spec_object ("question-page", "question-page", "question-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_OP_ICON, g_param_spec_object ("op-icon", "op-icon", "op-icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("closing", TYPE_ASSISTANT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->succeeded = FALSE;
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (obj);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->status_icon);
	_g_object_unref0 (self->priv->encrypt_entry);
	_g_object_unref0 (self->priv->encrypt_confirm_entry);
	_g_object_unref0 (self->priv->encrypt_remember);
	_g_object_unref0 (self->priv->_password_page);
	_g_object_unref0 (self->priv->question_label);
	_g_object_unref0 (self->priv->_question_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->secondary_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->progress_expander);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->priv->error_widget);
	_g_object_unref0 (self->priv->error_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->priv->_op_icon);
	_g_object_unref0 (self->op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static volatile gsize assistant_operation_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		GType assistant_operation_type_id;
		assistant_operation_type_id = g_type_register_static (TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_operation_type_id__volatile, assistant_operation_type_id);
	}
	return assistant_operation_type_id__volatile;
}


static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		g_value_set_boolean (value, assistant_operation_get_automatic (self));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		g_value_set_object (value, assistant_operation_get_password_page (self));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		g_value_set_object (value, assistant_operation_get_question_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		g_value_set_object (value, assistant_operation_get_op_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		assistant_operation_set_automatic (self, g_value_get_boolean (value));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		assistant_operation_set_password_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		assistant_operation_set_question_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		assistant_operation_set_op_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



