/* Duplicity.c generated by valac 0.12.0, the Vala compiler
 * generated from Duplicity.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009,2010,2011 Michael Terry <mike@mterry.name>,
    © 2009 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <config.h>


#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;
typedef struct _DejaDupDuplicityPrivate DejaDupDuplicityPrivate;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_DUPLICITY_TYPE_STATE (deja_dup_duplicity_state_get_type ())

#define DEJA_DUP_TYPE_DUPLICITY_INSTANCE (deja_dup_duplicity_instance_get_type ())
#define DEJA_DUP_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstance))
#define DEJA_DUP_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))

typedef struct _DejaDupDuplicityInstance DejaDupDuplicityInstance;
typedef struct _DejaDupDuplicityInstanceClass DejaDupDuplicityInstanceClass;

#define DEJA_DUP_DUPLICITY_TYPE_DATE_INFO (deja_dup_duplicity_date_info_get_type ())
typedef struct _DejaDupDuplicityDateInfo DejaDupDuplicityDateInfo;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__deja_dup_duplicity_date_info_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__deja_dup_duplicity_date_info_free0_ (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
typedef struct _DejaDupDuplicityCheckBackupSpaceData DejaDupDuplicityCheckBackupSpaceData;

#define DEJA_DUP_TYPE_RECURSIVE_OP (deja_dup_recursive_op_get_type ())
#define DEJA_DUP_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOp))
#define DEJA_DUP_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))
#define DEJA_DUP_IS_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_IS_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_RECURSIVE_OP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))

typedef struct _DejaDupRecursiveOp DejaDupRecursiveOp;
typedef struct _DejaDupRecursiveOpClass DejaDupRecursiveOpClass;

#define DEJA_DUP_TYPE_RECURSIVE_DELETE (deja_dup_recursive_delete_get_type ())
#define DEJA_DUP_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDelete))
#define DEJA_DUP_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))
#define DEJA_DUP_IS_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_IS_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_RECURSIVE_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))

typedef struct _DejaDupRecursiveDelete DejaDupRecursiveDelete;
typedef struct _DejaDupRecursiveDeleteClass DejaDupRecursiveDeleteClass;

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;

struct _DejaDupDuplicity {
	GObject parent_instance;
	DejaDupDuplicityPrivate * priv;
	GList* includes;
	GList* excludes;
};

struct _DejaDupDuplicityClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
	void (*process_error) (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
	void (*process_info) (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
	void (*process_warning) (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

typedef enum  {
	DEJA_DUP_DUPLICITY_STATE_NORMAL,
	DEJA_DUP_DUPLICITY_STATE_DRY_RUN,
	DEJA_DUP_DUPLICITY_STATE_STATUS,
	DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS,
	DEJA_DUP_DUPLICITY_STATE_CLEANUP,
	DEJA_DUP_DUPLICITY_STATE_DELETE
} DejaDupDuplicityState;

struct _DejaDupDuplicityDateInfo {
	gboolean full;
	GTimeVal time;
};

struct _DejaDupDuplicityPrivate {
	DejaDupOperationMode _original_mode;
	DejaDupOperationMode _mode;
	gboolean _error_issued;
	gboolean _was_stopped;
	GFile* _local;
	DejaDupBackend* _backend;
	gboolean _use_progress;
	GList* _restore_files;
	DejaDupDuplicityState _state;
	DejaDupDuplicityInstance* inst;
	gchar* remote;
	GList* backend_argv;
	GList* saved_argv;
	GList* saved_envp;
	gboolean is_full_backup;
	gboolean cleaned_up_once;
	gboolean needs_root;
	gboolean has_progress_total;
	guint64 progress_total;
	guint64 progress_count;
	gboolean has_checked_contents;
	gboolean has_non_home_contents;
	GList* homes;
	gboolean checked_collection_info;
	gboolean got_collection_info;
	GList* collection_info;
	gboolean checked_backup_space;
	gboolean deleted_files;
	gint delete_age;
	GFile* last_touched_file;
	gchar* saved_status;
	GFile* saved_status_file;
	gboolean saved_status_file_action;
	gboolean restarted_without_cache;
};

struct _DejaDupDuplicityCheckBackupSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupDuplicity* self;
	gboolean _tmp0_;
	guint64 _tmp1_;
	guint64 free;
	guint64 _tmp2_;
	guint64 total;
	const gchar* _tmp3_;
	gint full_dates;
	GList* info_collection;
	GList* info_it;
	DejaDupDuplicityDateInfo info;
	const gchar* _tmp4_;
	gboolean _tmp5_;
};


static gpointer deja_dup_duplicity_parent_class = NULL;
static GFile* deja_dup_duplicity_slash;
static GFile* deja_dup_duplicity_slash = NULL;
static GFile* deja_dup_duplicity_slash_root;
static GFile* deja_dup_duplicity_slash_root = NULL;
static GFile* deja_dup_duplicity_slash_home;
static GFile* deja_dup_duplicity_slash_home = NULL;
static GFile* deja_dup_duplicity_slash_home_me;
static GFile* deja_dup_duplicity_slash_home_me = NULL;

GType deja_dup_duplicity_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_state_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_instance_get_type (void) G_GNUC_CONST;
static GType deja_dup_duplicity_date_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static DejaDupDuplicityDateInfo* deja_dup_duplicity_date_info_dup (const DejaDupDuplicityDateInfo* self);
static void deja_dup_duplicity_date_info_free (DejaDupDuplicityDateInfo* self);
#define DEJA_DUP_DUPLICITY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityPrivate))
enum  {
	DEJA_DUP_DUPLICITY_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_ORIGINAL_MODE,
	DEJA_DUP_DUPLICITY_MODE,
	DEJA_DUP_DUPLICITY_ERROR_ISSUED,
	DEJA_DUP_DUPLICITY_WAS_STOPPED,
	DEJA_DUP_DUPLICITY_LOCAL,
	DEJA_DUP_DUPLICITY_BACKEND,
	DEJA_DUP_DUPLICITY_USE_PROGRESS,
	DEJA_DUP_DUPLICITY_RESTORE_FILES,
	DEJA_DUP_DUPLICITY_STATE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _deja_dup_duplicity_date_info_free0_ (gpointer var);
static void _g_list_free__deja_dup_duplicity_date_info_free0_ (GList* self);
#define DEJA_DUP_DUPLICITY_MINIMUM_FULL 2
#define DEJA_DUP_DUPLICITY_ERROR_GENERIC 1
#define DEJA_DUP_DUPLICITY_ERROR_HOSTNAME_CHANGED 3
#define DEJA_DUP_DUPLICITY_ERROR_RESTORE_DIR_NOT_FOUND 19
#define DEJA_DUP_DUPLICITY_ERROR_EXCEPTION 30
#define DEJA_DUP_DUPLICITY_ERROR_GPG 31
#define DEJA_DUP_DUPLICITY_ERROR_BACKEND 50
#define DEJA_DUP_DUPLICITY_ERROR_BACKEND_PERMISSION_DENIED 51
#define DEJA_DUP_DUPLICITY_ERROR_BACKEND_NOT_FOUND 52
#define DEJA_DUP_DUPLICITY_ERROR_BACKEND_NO_SPACE 53
#define DEJA_DUP_DUPLICITY_INFO_PROGRESS 2
#define DEJA_DUP_DUPLICITY_INFO_COLLECTION_STATUS 3
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_NEW 4
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_CHANGED 5
#define DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_DELETED 6
#define DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_WRITING 7
#define DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_PATCHING 8
#define DEJA_DUP_DUPLICITY_INFO_FILE_STAT 10
#define DEJA_DUP_DUPLICITY_INFO_SYNCHRONOUS_UPLOAD_BEGIN 11
#define DEJA_DUP_DUPLICITY_INFO_ASYNCHRONOUS_UPLOAD_BEGIN 12
#define DEJA_DUP_DUPLICITY_INFO_SYNCHRONOUS_UPLOAD_DONE 13
#define DEJA_DUP_DUPLICITY_INFO_ASYNCHRONOUS_UPLOAD_DONE 14
#define DEJA_DUP_DUPLICITY_WARNING_ORPHANED_SIG 2
#define DEJA_DUP_DUPLICITY_WARNING_UNNECESSARY_SIG 3
#define DEJA_DUP_DUPLICITY_WARNING_UNMATCHED_SIG 4
#define DEJA_DUP_DUPLICITY_WARNING_INCOMPLETE_BACKUP 5
#define DEJA_DUP_DUPLICITY_WARNING_ORPHANED_BACKUP 6
static void deja_dup_duplicity_network_changed (DejaDupDuplicity* self);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
void deja_dup_duplicity_resume (DejaDupDuplicity* self);
void deja_dup_duplicity_pause (DejaDupDuplicity* self, const gchar* reason);
DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode);
DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode);
void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
static void deja_dup_duplicity_real_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp);
DejaDupOperationMode deja_dup_duplicity_get_original_mode (DejaDupDuplicity* self);
static void deja_dup_duplicity_set_mode (DejaDupDuplicity* self, DejaDupOperationMode value);
gchar* deja_dup_backend_get_location (DejaDupBackend* self, GError** error);
void deja_dup_duplicity_set_backend (DejaDupDuplicity* self, DejaDupBackend* value);
void deja_dup_backend_add_argv (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self);
static void deja_dup_duplicity_process_include_excludes (DejaDupDuplicity* self);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
#define DEJA_DUP_DELETE_AFTER_KEY "delete-after"
static gboolean deja_dup_duplicity_restart (DejaDupDuplicity* self);
gboolean deja_dup_backend_is_native (DejaDupBackend* self);
static void _deja_dup_duplicity_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gint deja_dup_duplicity_cmp_prefix (DejaDupDuplicity* self, GFile* a, GFile* b);
static void deja_dup_duplicity_expand_links_in_file (DejaDupDuplicity* self, GFile* file, GList** all, gboolean include, GList* seen);
static gint _lambda5_ (GFile* a, GFile* b);
static gint __lambda5__gcompare_func (gconstpointer a, gconstpointer b);
static void deja_dup_duplicity_expand_links_in_list (DejaDupDuplicity* self, GList** all, gboolean include);
void deja_dup_duplicity_cancel (DejaDupDuplicity* self);
DejaDupDuplicityState deja_dup_duplicity_get_state (DejaDupDuplicity* self);
static gboolean deja_dup_duplicity_cleanup (DejaDupDuplicity* self);
static void deja_dup_duplicity_cancel_inst (DejaDupDuplicity* self);
void deja_dup_duplicity_stop (DejaDupDuplicity* self);
static void deja_dup_duplicity_set_was_stopped (DejaDupDuplicity* self, gboolean value);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_can_resume (DejaDupDuplicityInfo* self);
void deja_dup_duplicity_instance_pause (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_set_status (DejaDupDuplicity* self, const gchar* msg, gboolean save);
void deja_dup_duplicity_instance_resume (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_set_saved_status (DejaDupDuplicity* self);
static void deja_dup_duplicity_disconnect_inst (DejaDupDuplicity* self);
static void deja_dup_duplicity_handle_done (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gboolean success, gboolean cancelled);
void deja_dup_duplicity_set_state (DejaDupDuplicity* self, DejaDupDuplicityState value);
gboolean deja_dup_duplicity_info_get_has_collection_status (DejaDupDuplicityInfo* self);
gboolean deja_dup_duplicity_get_use_progress (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_info_get_has_backup_progress (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_check_backup_space (DejaDupDuplicity* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_duplicity_check_backup_space_finish (DejaDupDuplicity* self, GAsyncResult* _res_);
gboolean deja_dup_duplicity_info_get_has_rename_arg (DejaDupDuplicityInfo* self);
GList* deja_dup_duplicity_get_restore_files (DejaDupDuplicity* self);
static GFile* deja_dup_duplicity_make_local_rel_path (DejaDupDuplicity* self, GFile* file);
static void deja_dup_duplicity_show_error (DejaDupDuplicity* self, const gchar* errorstr, const gchar* detail);
GFile* deja_dup_duplicity_get_local (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_info_get_has_restore_progress (DejaDupDuplicityInfo* self);
gchar* deja_dup_operation_mode_to_string (DejaDupOperationMode mode);
static void deja_dup_duplicity_connect_and_start (DejaDupDuplicity* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, GFile* custom_local);
static void deja_dup_duplicity_check_backup_space_data_free (gpointer _data);
static gboolean deja_dup_duplicity_check_backup_space_co (DejaDupDuplicityCheckBackupSpaceData* data);
DejaDupBackend* deja_dup_duplicity_get_backend (DejaDupDuplicity* self);
void deja_dup_backend_get_space (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint64 deja_dup_backend_get_space_finish (DejaDupBackend* self, GAsyncResult* _res_);
static void deja_dup_duplicity_check_backup_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_duplicity_delete_excess (DejaDupDuplicity* self, gint cutoff);
gboolean deja_dup_duplicity_info_get_has_broken_cleanup (DejaDupDuplicityInfo* self);
void deja_dup_get_full_backup_threshold_date (GDate* result);
static gboolean deja_dup_duplicity_delete_files_if_needed (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_get_was_stopped (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_get_error_issued (DejaDupDuplicity* self);
static void deja_dup_duplicity_set_status_file (DejaDupDuplicity* self, GFile* file, gboolean action, gboolean save);
static gboolean deja_dup_duplicity_restart_with_short_filenames_if_needed (DejaDupDuplicity* self);
gboolean deja_dup_duplicity_info_get_can_read_short_filenames (DejaDupDuplicityInfo* self);
static gboolean deja_dup_duplicity_restart_without_cache (DejaDupDuplicity* self);
DejaDupRecursiveDelete* deja_dup_recursive_delete_new (GFile* source);
DejaDupRecursiveDelete* deja_dup_recursive_delete_construct (GType object_type, GFile* source);
GType deja_dup_recursive_op_get_type (void) G_GNUC_CONST;
GType deja_dup_recursive_delete_get_type (void) G_GNUC_CONST;
void deja_dup_recursive_op_start (DejaDupRecursiveOp* self);
static void deja_dup_duplicity_handle_exit (DejaDupDuplicity* self, gint code);
gboolean deja_dup_duplicity_info_get_guarantees_error_codes (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_handle_message (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text);
void deja_dup_duplicity_process_error (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
void deja_dup_duplicity_process_info (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
void deja_dup_duplicity_process_warning (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static gboolean deja_dup_duplicity_ask_question (DejaDupDuplicity* self, const gchar* t, const gchar* m);
static void deja_dup_duplicity_real_process_error (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in);
static void deja_dup_duplicity_process_exception (DejaDupDuplicity* self, const gchar* exception, const gchar* text);
static GFile* deja_dup_duplicity_make_file_obj (DejaDupDuplicity* self, const gchar* file);
GType deja_dup_backend_s3_get_type (void) G_GNUC_CONST;
gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self);
gchar* deja_dup_backend_get_location_pretty (DejaDupBackend* self, GError** error);
gboolean deja_dup_duplicity_info_get_new_time_format (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_real_process_info (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static void deja_dup_duplicity_process_diff_file (DejaDupDuplicity* self, const gchar* file);
static void deja_dup_duplicity_process_patch_file (DejaDupDuplicity* self, const gchar* file);
static void deja_dup_duplicity_process_progress (DejaDupDuplicity* self, gchar** firstline, int firstline_length1);
static void deja_dup_duplicity_process_collection_status (DejaDupDuplicity* self, GList* lines);
static void deja_dup_duplicity_process_file_stat (DejaDupDuplicity* self, const gchar* date, const gchar* file, GList* data, const gchar* text);
static void deja_dup_duplicity_real_process_warning (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text);
static void deja_dup_duplicity_set_error_issued (DejaDupDuplicity* self, gboolean value);
static gint deja_dup_duplicity_get_volsize (DejaDupDuplicity* self);
static void _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done (DejaDupDuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message (DejaDupDuplicityInstance* _sender, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text, gpointer self);
static void _deja_dup_duplicity_handle_exit_deja_dup_duplicity_instance_exited (DejaDupDuplicityInstance* _sender, gint code, gpointer self);
void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type);
void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
static void deja_dup_duplicity_set_original_mode (DejaDupDuplicity* self, DejaDupOperationMode value);
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, GFile* value);
void deja_dup_duplicity_set_use_progress (DejaDupDuplicity* self, gboolean value);
void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * deja_dup_duplicity_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_duplicity_finalize (GObject* obj);
static void _vala_deja_dup_duplicity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_duplicity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType deja_dup_duplicity_state_get_type (void) {
	static volatile gsize deja_dup_duplicity_state_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_state_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_DUPLICITY_STATE_NORMAL, "DEJA_DUP_DUPLICITY_STATE_NORMAL", "normal"}, {DEJA_DUP_DUPLICITY_STATE_DRY_RUN, "DEJA_DUP_DUPLICITY_STATE_DRY_RUN", "dry-run"}, {DEJA_DUP_DUPLICITY_STATE_STATUS, "DEJA_DUP_DUPLICITY_STATE_STATUS", "status"}, {DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS, "DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS", "check-contents"}, {DEJA_DUP_DUPLICITY_STATE_CLEANUP, "DEJA_DUP_DUPLICITY_STATE_CLEANUP", "cleanup"}, {DEJA_DUP_DUPLICITY_STATE_DELETE, "DEJA_DUP_DUPLICITY_STATE_DELETE", "delete"}, {0, NULL, NULL}};
		GType deja_dup_duplicity_state_type_id;
		deja_dup_duplicity_state_type_id = g_enum_register_static ("DejaDupDuplicityState", values);
		g_once_init_leave (&deja_dup_duplicity_state_type_id__volatile, deja_dup_duplicity_state_type_id);
	}
	return deja_dup_duplicity_state_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _deja_dup_duplicity_date_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (deja_dup_duplicity_date_info_free (var), NULL));
}


static void _g_list_free__deja_dup_duplicity_date_info_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _deja_dup_duplicity_date_info_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_duplicity_network_changed (DejaDupDuplicity* self) {
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		deja_dup_duplicity_resume (self);
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("Paused (no network)");
		deja_dup_duplicity_pause (self, _tmp4_);
	}
}


DejaDupDuplicity* deja_dup_duplicity_construct (GType object_type, DejaDupOperationMode mode) {
	DejaDupDuplicity * self = NULL;
	self = (DejaDupDuplicity*) g_object_new (object_type, "original-mode", mode, NULL);
	return self;
}


DejaDupDuplicity* deja_dup_duplicity_new (DejaDupOperationMode mode) {
	return deja_dup_duplicity_construct (DEJA_DUP_TYPE_DUPLICITY, mode);
}


static void _deja_dup_duplicity_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	deja_dup_duplicity_network_changed (self);
}


static void deja_dup_duplicity_real_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	DejaDupSimpleSettings* _tmp7_ = NULL;
	DejaDupSimpleSettings* settings;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	deja_dup_duplicity_set_mode (self, self->priv->_original_mode);
	_tmp0_ = deja_dup_backend_get_location (backend, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch18_g_error;
	}
	_g_free0 (self->priv->remote);
	self->priv->remote = _tmp1_;
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_signal_emit_by_name (self, "raise-error", e->message, NULL);
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		_g_error_free0 (e);
		return;
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	deja_dup_duplicity_set_backend (self, backend);
	__g_list_free__g_free0_0 (self->priv->saved_argv);
	self->priv->saved_argv = NULL;
	__g_list_free__g_free0_0 (self->priv->saved_envp);
	self->priv->saved_envp = NULL;
	__g_list_free__g_free0_0 (self->priv->backend_argv);
	self->priv->backend_argv = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp2_;
			gchar* s;
			_tmp2_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp2_;
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (s);
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp3_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = envp;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp4_;
			gchar* s;
			_tmp4_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp4_;
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (s);
				self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp5_);
				_g_free0 (s);
			}
		}
	}
	deja_dup_backend_add_argv (backend, DEJA_DUP_OPERATION_MODE_INVALID, &self->priv->backend_argv);
	if (!encrypted) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("--no-encryption");
		self->priv->backend_argv = g_list_append (self->priv->backend_argv, _tmp6_);
	}
	if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		deja_dup_duplicity_process_include_excludes (self);
	}
	_tmp7_ = deja_dup_get_settings (NULL);
	settings = _tmp7_;
	_tmp8_ = g_settings_get_int ((GSettings*) settings, DEJA_DUP_DELETE_AFTER_KEY);
	self->priv->delete_age = _tmp8_;
	_tmp9_ = deja_dup_duplicity_restart (self);
	if (!_tmp9_) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
	}
	_tmp10_ = deja_dup_backend_is_native (backend);
	if (!_tmp10_) {
		DejaDupNetwork* _tmp11_ = NULL;
		DejaDupNetwork* _tmp12_;
		DejaDupNetwork* _tmp13_ = NULL;
		DejaDupNetwork* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp11_ = deja_dup_network_get ();
		_tmp12_ = _tmp11_;
		g_signal_connect_object ((GObject*) _tmp12_, "notify::connected", (GCallback) _deja_dup_duplicity_network_changed_g_object_notify, self, 0);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = deja_dup_network_get ();
		_tmp14_ = _tmp13_;
		_tmp15_ = deja_dup_network_get_connected (_tmp14_);
		_tmp16_ = !_tmp15_;
		_g_object_unref0 (_tmp14_);
		if (_tmp16_) {
			const gchar* _tmp17_ = NULL;
			g_debug ("Duplicity.vala:178: No connection found. Postponing the backup.");
			_tmp17_ = _ ("Paused (no network)");
			deja_dup_duplicity_pause (self, _tmp17_);
		}
	}
	_g_object_unref0 (settings);
}


void deja_dup_duplicity_start (DejaDupDuplicity* self, DejaDupBackend* backend, gboolean encrypted, GList* argv, GList* envp) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->start (self, backend, encrypted, argv, envp);
}


static gint deja_dup_duplicity_cmp_prefix (DejaDupDuplicity* self, GFile* a, GFile* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (a == NULL) {
		_tmp0_ = b == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (b == NULL) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = g_file_has_prefix (a, b);
			_tmp1_ = _tmp2_;
		}
		if (_tmp1_) {
			result = -1;
			return result;
		} else {
			gboolean _tmp3_ = FALSE;
			if (a == NULL) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp4_;
				_tmp4_ = g_file_has_prefix (b, a);
				_tmp3_ = _tmp4_;
			}
			if (_tmp3_) {
				result = 1;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint _lambda5_ (GFile* a, GFile* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a != NULL) {
		_tmp2_ = b != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = g_file_equal (a, b);
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}


static gint __lambda5__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda5_ (a, b);
	return result;
}


static void deja_dup_duplicity_expand_links_in_file (DejaDupDuplicity* self, GFile* file, GList** all, gboolean include, GList* seen) {
	GList* pieces;
	GFile* _tmp0_;
	GFile* iter;
	GFile* parent = NULL;
	GFile* _tmp4_;
	GFile* so_far;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	pieces = NULL;
	_tmp0_ = _g_object_ref0 (file);
	iter = _tmp0_;
	while (TRUE) {
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GFile* _tmp3_;
		_tmp1_ = g_file_get_parent (iter);
		_g_object_unref0 (parent);
		parent = _tmp1_;
		if (!(parent != NULL)) {
			break;
		}
		_tmp2_ = g_file_get_relative_path (parent, iter);
		pieces = g_list_prepend (pieces, _tmp2_);
		_tmp3_ = _g_object_ref0 (parent);
		_g_object_unref0 (iter);
		iter = _tmp3_;
	}
	_tmp4_ = _g_object_ref0 (deja_dup_duplicity_slash);
	so_far = _tmp4_;
	{
		GList* piece_collection;
		GList* piece_it;
		piece_collection = pieces;
		for (piece_it = piece_collection; piece_it != NULL; piece_it = piece_it->next) {
			const gchar* piece;
			piece = (const gchar*) piece_it->data;
			{
				GFile* _tmp5_;
				GFile* _tmp6_ = NULL;
				GFileInfo* _tmp7_ = NULL;
				GFileInfo* info;
				gboolean _tmp8_;
				_tmp5_ = _g_object_ref0 (so_far);
				_g_object_unref0 (parent);
				parent = _tmp5_;
				_tmp6_ = g_file_resolve_relative_path (parent, piece);
				_g_object_unref0 (so_far);
				so_far = _tmp6_;
				_tmp7_ = g_file_query_info (so_far, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
				info = _tmp7_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (so_far);
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						goto __catch19_g_io_error_not_found;
					}
					goto __catch19_g_error;
				}
				_tmp8_ = g_file_info_get_is_symlink (info);
				if (_tmp8_) {
					GList* _tmp9_ = NULL;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* symlink_target;
					GFile* full_target = NULL;
					gboolean _tmp13_;
					gchar* _tmp16_ = NULL;
					gchar* remaining;
					GFile* _tmp18_;
					_tmp9_ = g_list_find_custom (seen, so_far, __lambda5__gcompare_func);
					if (_tmp9_ != NULL) {
						_g_object_unref0 (info);
						_g_object_unref0 (so_far);
						_g_object_unref0 (parent);
						_g_object_unref0 (iter);
						__g_list_free__g_free0_0 (pieces);
						return;
					}
					if (include) {
						GFile* _tmp10_;
						_tmp10_ = _g_object_ref0 (so_far);
						*all = g_list_prepend (*all, _tmp10_);
					}
					_tmp11_ = g_file_info_get_symlink_target (info);
					_tmp12_ = g_strdup (_tmp11_);
					symlink_target = _tmp12_;
					_tmp13_ = g_path_is_absolute (symlink_target);
					if (_tmp13_) {
						GFile* _tmp14_ = NULL;
						_tmp14_ = g_file_new_for_path (symlink_target);
						_g_object_unref0 (full_target);
						full_target = _tmp14_;
					} else {
						GFile* _tmp15_ = NULL;
						_tmp15_ = g_file_resolve_relative_path (parent, symlink_target);
						_g_object_unref0 (full_target);
						full_target = _tmp15_;
					}
					_tmp16_ = g_file_get_relative_path (so_far, file);
					remaining = _tmp16_;
					if (remaining != NULL) {
						GFile* _tmp17_ = NULL;
						_tmp17_ = g_file_resolve_relative_path (full_target, remaining);
						_g_object_unref0 (full_target);
						full_target = _tmp17_;
					}
					if (include) {
						*all = g_list_remove (*all, file);
					}
					_tmp18_ = _g_object_ref0 (so_far);
					seen = g_list_prepend (seen, _tmp18_);
					deja_dup_duplicity_expand_links_in_file (self, full_target, all, include, seen);
					_g_free0 (remaining);
					_g_object_unref0 (full_target);
					_g_free0 (symlink_target);
					_g_object_unref0 (info);
					_g_object_unref0 (so_far);
					_g_object_unref0 (parent);
					_g_object_unref0 (iter);
					__g_list_free__g_free0_0 (pieces);
					return;
				}
				_g_object_unref0 (info);
			}
		}
	}
	if (seen != NULL) {
		GFile* _tmp19_;
		_tmp19_ = _g_object_ref0 (file);
		*all = g_list_prepend (*all, _tmp19_);
	}
	_g_object_unref0 (so_far);
	goto __finally19;
	__catch19_g_io_error_not_found:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		*all = g_list_remove (*all, file);
		_g_error_free0 (e);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Duplicity.vala:271: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		_g_object_unref0 (iter);
		__g_list_free__g_free0_0 (pieces);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (iter);
	__g_list_free__g_free0_0 (pieces);
}


static void deja_dup_duplicity_expand_links_in_list (DejaDupDuplicity* self, GList** all, gboolean include) {
	GList* _tmp0_ = NULL;
	GList* all2;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_copy (*all);
	all2 = _tmp0_;
	{
		GList* file_collection;
		GList* file_it;
		file_collection = all2;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp1_;
			GFile* file;
			_tmp1_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp1_;
			{
				deja_dup_duplicity_expand_links_in_file (self, file, all, include, NULL);
				_g_object_unref0 (file);
			}
		}
	}
	_g_list_free0 (all2);
}


static void deja_dup_duplicity_process_include_excludes (DejaDupDuplicity* self) {
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_expand_links_in_list (self, &self->includes, TRUE);
	deja_dup_duplicity_expand_links_in_list (self, &self->excludes, FALSE);
	self->includes = g_list_sort (self->includes, (GCompareFunc) deja_dup_duplicity_cmp_prefix);
	self->excludes = g_list_sort (self->excludes, (GCompareFunc) deja_dup_duplicity_cmp_prefix);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = self->includes;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GFile* _tmp0_;
			GFile* i;
			_tmp0_ = _g_object_ref0 ((GFile*) i_it->data);
			i = _tmp0_;
			{
				GList* _tmp1_ = NULL;
				GList* excludes2;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp1_ = g_list_copy (self->excludes);
				excludes2 = _tmp1_;
				{
					GList* e_collection;
					GList* e_it;
					e_collection = excludes2;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						GFile* _tmp2_;
						GFile* e;
						_tmp2_ = _g_object_ref0 ((GFile*) e_it->data);
						e = _tmp2_;
						{
							gboolean _tmp3_;
							_tmp3_ = g_file_has_prefix (e, i);
							if (_tmp3_) {
								gchar* _tmp4_ = NULL;
								gchar* _tmp5_;
								gchar* _tmp6_;
								_tmp4_ = g_file_get_path (e);
								_tmp5_ = _tmp4_;
								_tmp6_ = g_strconcat ("--exclude=", _tmp5_, NULL);
								self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp6_);
								_g_free0 (_tmp5_);
								self->excludes = g_list_remove (self->excludes, e);
							}
							_g_object_unref0 (e);
						}
					}
				}
				_tmp7_ = g_file_get_path (i);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat ("--include=", _tmp8_, NULL);
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp9_);
				_g_free0 (_tmp8_);
				_g_list_free0 (excludes2);
				_g_object_unref0 (i);
			}
		}
	}
	{
		GList* e_collection;
		GList* e_it;
		e_collection = self->excludes;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			GFile* _tmp10_;
			GFile* e;
			_tmp10_ = _g_object_ref0 ((GFile*) e_it->data);
			e = _tmp10_;
			{
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = g_file_get_path (e);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat ("--exclude=", _tmp12_, NULL);
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp13_);
				_g_free0 (_tmp12_);
				_g_object_unref0 (e);
			}
		}
	}
	_tmp14_ = g_strdup ("--exclude=**");
	self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp14_);
}


void deja_dup_duplicity_cancel (DejaDupDuplicity* self) {
	DejaDupOperationMode prev_mode;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	prev_mode = self->priv->_mode;
	deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_INVALID);
	if (prev_mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		_tmp0_ = self->priv->_state == DEJA_DUP_DUPLICITY_STATE_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = deja_dup_duplicity_cleanup (self);
		if (_tmp1_) {
			return;
		}
	}
	deja_dup_duplicity_cancel_inst (self);
}


void deja_dup_duplicity_stop (DejaDupDuplicity* self) {
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_set_was_stopped (self, TRUE);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_can_resume (_tmp1_);
	_tmp3_ = !_tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		deja_dup_duplicity_cancel (self);
	} else {
		deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_INVALID);
		deja_dup_duplicity_cancel_inst (self);
	}
}


void deja_dup_duplicity_pause (DejaDupDuplicity* self, const gchar* reason) {
	g_return_if_fail (self != NULL);
	if (self->priv->inst != NULL) {
		deja_dup_duplicity_instance_pause (self->priv->inst);
		if (reason != NULL) {
			deja_dup_duplicity_set_status (self, reason, FALSE);
		}
	}
}


void deja_dup_duplicity_resume (DejaDupDuplicity* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->inst != NULL) {
		deja_dup_duplicity_instance_resume (self->priv->inst);
		deja_dup_duplicity_set_saved_status (self);
	}
}


static void deja_dup_duplicity_cancel_inst (DejaDupDuplicity* self) {
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_disconnect_inst (self);
	deja_dup_duplicity_handle_done (self, NULL, FALSE, TRUE);
}


static gboolean deja_dup_duplicity_restart (DejaDupDuplicity* self) {
	gboolean result = FALSE;
	GList* extra_argv;
	gchar* action_desc;
	GFile* custom_local;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_NORMAL);
	if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		result = FALSE;
		return result;
	}
	extra_argv = NULL;
	action_desc = NULL;
	custom_local = NULL;
	switch (self->priv->_original_mode) {
		case DEJA_DUP_OPERATION_MODE_BACKUP:
		{
			gboolean _tmp0_ = FALSE;
			if (!self->priv->checked_collection_info) {
				DejaDupDuplicityInfo* _tmp1_ = NULL;
				DejaDupDuplicityInfo* _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = deja_dup_duplicity_info_get_default ();
				_tmp2_ = _tmp1_;
				_tmp3_ = deja_dup_duplicity_info_get_has_collection_status (_tmp2_);
				_tmp0_ = _tmp3_;
				_g_object_unref0 (_tmp2_);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_STATUS);
				deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_STATUS);
				_tmp4_ = _ ("Preparing…");
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (action_desc);
				action_desc = _tmp5_;
			} else {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				if (self->priv->_use_progress) {
					_tmp7_ = !self->priv->has_progress_total;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					DejaDupDuplicityInfo* _tmp8_ = NULL;
					DejaDupDuplicityInfo* _tmp9_;
					gboolean _tmp10_;
					_tmp8_ = deja_dup_duplicity_info_get_default ();
					_tmp9_ = _tmp8_;
					_tmp10_ = deja_dup_duplicity_info_get_has_backup_progress (_tmp9_);
					_tmp6_ = _tmp10_;
					_g_object_unref0 (_tmp9_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_DRY_RUN);
					_tmp11_ = _ ("Preparing…");
					_tmp12_ = g_strdup (_tmp11_);
					_g_free0 (action_desc);
					action_desc = _tmp12_;
					_tmp13_ = g_strdup ("--dry-run");
					extra_argv = g_list_append (extra_argv, _tmp13_);
				} else {
					if (!self->priv->checked_backup_space) {
						deja_dup_duplicity_check_backup_space (self, NULL, NULL);
						result = TRUE;
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						__g_list_free__g_free0_0 (extra_argv);
						return result;
					} else {
						if (self->priv->has_progress_total) {
							g_signal_emit_by_name (self, "progress", (gdouble) 0.f);
						}
					}
				}
			}
			break;
		}
		case DEJA_DUP_OPERATION_MODE_RESTORE:
		{
			if (!self->priv->has_checked_contents) {
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_LIST);
				deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS);
				_tmp14_ = _ ("Preparing…");
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (action_desc);
				action_desc = _tmp15_;
			} else {
				guint _tmp16_;
				GList* _tmp29_ = NULL;
				DejaDupDuplicityInfo* _tmp46_ = NULL;
				DejaDupDuplicityInfo* _tmp47_;
				gboolean _tmp48_;
				gboolean _tmp49_;
				_tmp16_ = g_list_length (self->priv->homes);
				if (_tmp16_ > 1) {
					self->priv->has_non_home_contents = TRUE;
				} else {
					guint _tmp17_;
					_tmp17_ = g_list_length (self->priv->homes);
					if (_tmp17_ == 1) {
						DejaDupDuplicityInfo* _tmp18_ = NULL;
						DejaDupDuplicityInfo* _tmp19_;
						gboolean _tmp20_;
						gboolean _tmp21_;
						_tmp18_ = deja_dup_duplicity_info_get_default ();
						_tmp19_ = _tmp18_;
						_tmp20_ = deja_dup_duplicity_info_get_has_rename_arg (_tmp19_);
						_tmp21_ = _tmp20_;
						_g_object_unref0 (_tmp19_);
						if (_tmp21_) {
							GFile* _tmp22_;
							GFile* old_home;
							GFile* _tmp23_;
							GFile* new_home;
							gboolean _tmp24_;
							_tmp22_ = _g_object_ref0 ((GFile*) self->priv->homes->data);
							old_home = _tmp22_;
							_tmp23_ = _g_object_ref0 (deja_dup_duplicity_slash_home_me);
							new_home = _tmp23_;
							_tmp24_ = g_file_equal (old_home, new_home);
							if (!_tmp24_) {
								gchar* _tmp25_;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp25_ = g_strdup ("--rename");
								extra_argv = g_list_append (extra_argv, _tmp25_);
								_tmp26_ = g_file_get_relative_path (deja_dup_duplicity_slash, old_home);
								extra_argv = g_list_append (extra_argv, _tmp26_);
								_tmp27_ = g_file_get_relative_path (deja_dup_duplicity_slash, new_home);
								extra_argv = g_list_append (extra_argv, _tmp27_);
							}
							_g_object_unref0 (new_home);
							_g_object_unref0 (old_home);
						} else {
							gboolean _tmp28_;
							_tmp28_ = g_file_has_prefix ((GFile*) self->priv->homes->data, deja_dup_duplicity_slash_home_me);
							if (!_tmp28_) {
								self->priv->has_non_home_contents = TRUE;
							}
						}
					}
				}
				_tmp29_ = deja_dup_duplicity_get_restore_files (self);
				if (_tmp29_ != NULL) {
					GList* _tmp30_ = NULL;
					GFile* _tmp31_ = NULL;
					GFile* local_file;
					gboolean _tmp39_;
					GFile* _tmp40_;
					GList* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* rel_file_path;
					gchar* _tmp43_ = NULL;
					_tmp30_ = deja_dup_duplicity_get_restore_files (self);
					_tmp31_ = deja_dup_duplicity_make_local_rel_path (self, (GFile*) _tmp30_->data);
					local_file = _tmp31_;
					if (local_file == NULL) {
						const gchar* _tmp32_ = NULL;
						GList* _tmp33_ = NULL;
						GFile* _tmp34_;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_;
						_tmp32_ = _ ("Could not restore ‘%s’: Not a valid file location");
						_tmp33_ = deja_dup_duplicity_get_restore_files (self);
						_tmp34_ = (GFile*) _tmp33_->data;
						_tmp35_ = g_file_get_parse_name (G_IS_FILE (_tmp34_) ? ((GFile*) _tmp34_) : NULL);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strdup_printf (_tmp32_, _tmp36_);
						_tmp38_ = _tmp37_;
						deja_dup_duplicity_show_error (self, _tmp38_, NULL);
						_g_free0 (_tmp38_);
						_g_free0 (_tmp36_);
						result = FALSE;
						_g_object_unref0 (local_file);
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						__g_list_free__g_free0_0 (extra_argv);
						return result;
					}
					_tmp39_ = g_file_has_prefix (local_file, deja_dup_duplicity_slash_home_me);
					if (!_tmp39_) {
						self->priv->needs_root = TRUE;
					}
					g_file_make_directory_with_parents (local_file, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
							goto __catch20_g_io_error_exists;
						}
						goto __catch20_g_error;
					}
					goto __finally20;
					__catch20_g_io_error_exists:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						_g_error_free0 (e);
					}
					goto __finally20;
					__catch20_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						deja_dup_duplicity_show_error (self, e->message, NULL);
						result = FALSE;
						_g_error_free0 (e);
						_g_object_unref0 (local_file);
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						__g_list_free__g_free0_0 (extra_argv);
						return result;
					}
					__finally20:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (local_file);
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						__g_list_free__g_free0_0 (extra_argv);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp40_ = _g_object_ref0 (local_file);
					_g_object_unref0 (custom_local);
					custom_local = _tmp40_;
					_tmp41_ = deja_dup_duplicity_get_restore_files (self);
					_tmp42_ = g_file_get_relative_path (deja_dup_duplicity_slash, (GFile*) _tmp41_->data);
					rel_file_path = _tmp42_;
					_tmp43_ = g_strdup_printf ("--file-to-restore=%s", rel_file_path);
					extra_argv = g_list_append (extra_argv, _tmp43_);
					_g_free0 (rel_file_path);
					_g_object_unref0 (local_file);
				} else {
					gboolean _tmp44_ = FALSE;
					if (self->priv->has_non_home_contents) {
						gboolean _tmp45_;
						_tmp45_ = g_file_has_prefix (self->priv->_local, deja_dup_duplicity_slash_home_me);
						_tmp44_ = !_tmp45_;
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						self->priv->needs_root = TRUE;
					}
				}
				_tmp46_ = deja_dup_duplicity_info_get_default ();
				_tmp47_ = _tmp46_;
				_tmp48_ = deja_dup_duplicity_info_get_has_restore_progress (_tmp47_);
				_tmp49_ = _tmp48_;
				_g_object_unref0 (_tmp47_);
				if (_tmp49_) {
					g_signal_emit_by_name (self, "progress", (gdouble) 0.f);
				}
			}
			break;
		}
		default:
		break;
	}
	if (action_desc == NULL) {
		gchar* _tmp50_ = NULL;
		_tmp50_ = deja_dup_operation_mode_to_string (self->priv->_mode);
		_g_free0 (action_desc);
		action_desc = _tmp50_;
	}
	deja_dup_duplicity_set_status (self, action_desc, TRUE);
	deja_dup_duplicity_connect_and_start (self, extra_argv, NULL, NULL, custom_local);
	result = TRUE;
	_g_object_unref0 (custom_local);
	_g_free0 (action_desc);
	__g_list_free__g_free0_0 (extra_argv);
	return result;
}


static GFile* deja_dup_duplicity_make_local_rel_path (DejaDupDuplicity* self, GFile* file) {
	GFile* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* rel_file_path;
	GFile* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_relative_path (deja_dup_duplicity_slash, file);
	rel_file_path = _tmp0_;
	if (rel_file_path == NULL) {
		result = NULL;
		_g_free0 (rel_file_path);
		return result;
	}
	_tmp1_ = g_file_resolve_relative_path (self->priv->_local, rel_file_path);
	result = _tmp1_;
	_g_free0 (rel_file_path);
	return result;
}


static void deja_dup_duplicity_check_backup_space_data_free (gpointer _data) {
	DejaDupDuplicityCheckBackupSpaceData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupDuplicityCheckBackupSpaceData, data);
}


static void deja_dup_duplicity_check_backup_space (DejaDupDuplicity* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupDuplicityCheckBackupSpaceData* _data_;
	_data_ = g_slice_new0 (DejaDupDuplicityCheckBackupSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_duplicity_check_backup_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_duplicity_check_backup_space_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_duplicity_check_backup_space_co (_data_);
}


static void deja_dup_duplicity_check_backup_space_finish (DejaDupDuplicity* self, GAsyncResult* _res_) {
	DejaDupDuplicityCheckBackupSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_duplicity_check_backup_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupDuplicityCheckBackupSpaceData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_duplicity_check_backup_space_co (data);
}


static gboolean deja_dup_duplicity_check_backup_space_co (DejaDupDuplicityCheckBackupSpaceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->self->priv->checked_backup_space = TRUE;
	if (!data->self->priv->has_progress_total) {
		data->_tmp0_ = deja_dup_duplicity_restart (data->self);
		if (!data->_tmp0_) {
			g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
		}
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	deja_dup_backend_get_space (data->self->priv->_backend, TRUE, deja_dup_duplicity_check_backup_space_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = deja_dup_backend_get_space_finish (data->self->priv->_backend, data->_res_);
	data->free = data->_tmp1_;
	data->_state_ = 2;
	deja_dup_backend_get_space (data->self->priv->_backend, FALSE, deja_dup_duplicity_check_backup_space_ready, data);
	return FALSE;
	_state_2:
	data->_tmp2_ = deja_dup_backend_get_space_finish (data->self->priv->_backend, data->_res_);
	data->total = data->_tmp2_;
	if (data->total < data->self->priv->progress_total) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Backup location is too small.  Try using one with more space.");
		deja_dup_duplicity_show_error (data->self, data->_tmp3_, NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->free < data->self->priv->progress_total) {
		if (data->self->priv->got_collection_info) {
			data->full_dates = 0;
			{
				data->info_collection = data->self->priv->collection_info;
				for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
					data->info = *((DejaDupDuplicityDateInfo*) data->info_it->data);
					{
						if (data->info.full) {
							data->full_dates = data->full_dates + 1;
						}
					}
				}
			}
			if (data->full_dates > 1) {
				deja_dup_duplicity_delete_excess (data->self, data->full_dates - 1);
				data->self->priv->checked_backup_space = FALSE;
				data->self->priv->checked_collection_info = FALSE;
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_tmp4_ = NULL;
			data->_tmp4_ = _ ("Backup location does not have enough free space.");
			deja_dup_duplicity_show_error (data->self, data->_tmp4_, NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp5_ = deja_dup_duplicity_restart (data->self);
	if (!data->_tmp5_) {
		g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean deja_dup_duplicity_cleanup (DejaDupDuplicity* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DejaDupDuplicityInfo* _tmp1_ = NULL;
	DejaDupDuplicityInfo* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GList* cleanup_argv;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = deja_dup_duplicity_info_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_duplicity_info_get_has_broken_cleanup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_state == DEJA_DUP_DUPLICITY_STATE_CLEANUP;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_CLEANUP);
	cleanup_argv = NULL;
	_tmp5_ = g_strdup ("cleanup");
	cleanup_argv = g_list_append (cleanup_argv, _tmp5_);
	_tmp6_ = g_strdup ("--force");
	cleanup_argv = g_list_append (cleanup_argv, _tmp6_);
	_tmp7_ = g_strdup (self->priv->remote);
	cleanup_argv = g_list_append (cleanup_argv, _tmp7_);
	_tmp8_ = _ ("Cleaning up…");
	deja_dup_duplicity_set_status (self, _tmp8_, TRUE);
	deja_dup_duplicity_connect_and_start (self, NULL, NULL, cleanup_argv, NULL);
	result = TRUE;
	__g_list_free__g_free0_0 (cleanup_argv);
	return result;
}


static void deja_dup_duplicity_delete_excess (DejaDupDuplicity* self, gint cutoff) {
	GList* argv;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_set_state (self, DEJA_DUP_DUPLICITY_STATE_DELETE);
	argv = NULL;
	_tmp0_ = g_strdup ("remove-all-but-n-full");
	argv = g_list_append (argv, _tmp0_);
	_tmp1_ = g_strdup_printf ("%d", cutoff);
	argv = g_list_append (argv, _tmp1_);
	_tmp2_ = g_strdup ("--force");
	argv = g_list_append (argv, _tmp2_);
	_tmp3_ = g_strdup (self->priv->remote);
	argv = g_list_append (argv, _tmp3_);
	_tmp4_ = _ ("Cleaning up…");
	deja_dup_duplicity_set_status (self, _tmp4_, TRUE);
	deja_dup_duplicity_connect_and_start (self, NULL, NULL, argv, NULL);
	__g_list_free__g_free0_0 (argv);
	return;
}


static void deja_dup_duplicity_handle_done (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gboolean success, gboolean cancelled) {
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!cancelled) {
		switch (self->priv->_state) {
			case DEJA_DUP_DUPLICITY_STATE_DRY_RUN:
			{
				if (success) {
					gboolean _tmp0_;
					self->priv->has_progress_total = TRUE;
					self->priv->progress_total = self->priv->progress_count;
					_tmp0_ = deja_dup_duplicity_restart (self);
					if (_tmp0_) {
						return;
					}
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_DELETE:
			{
				gboolean _tmp1_;
				_tmp1_ = deja_dup_duplicity_restart (self);
				if (_tmp1_) {
					return;
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_CLEANUP:
			{
				gboolean _tmp2_;
				self->priv->cleaned_up_once = TRUE;
				_tmp2_ = deja_dup_duplicity_restart (self);
				if (_tmp2_) {
					return;
				}
				success = FALSE;
				cancelled = TRUE;
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_STATUS:
			{
				if (success) {
					gboolean _tmp3_ = FALSE;
					gboolean _tmp12_;
					self->priv->checked_collection_info = TRUE;
					deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_BACKUP);
					if (!self->priv->got_collection_info) {
						_tmp3_ = TRUE;
					} else {
						_tmp3_ = self->priv->collection_info == NULL;
					}
					if (_tmp3_) {
						{
							GList* s_collection;
							GList* s_it;
							s_collection = self->priv->backend_argv;
							for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
								const gchar* s;
								s = (const gchar*) s_it->data;
								{
									if (g_strcmp0 (s, "--short-filenames") == 0) {
										self->priv->backend_argv = g_list_remove (self->priv->backend_argv, s);
									}
								}
							}
						}
					}
					if (self->priv->got_collection_info) {
						GDate _tmp4_ = {0};
						GDate _tmp5_ = {0};
						GDate threshold;
						GDate full_backup = {0};
						gboolean _tmp6_ = FALSE;
						gboolean _tmp7_;
						deja_dup_get_full_backup_threshold_date (&_tmp4_);
						_tmp5_ = _tmp4_;
						threshold = _tmp5_;
						memset (&full_backup, 0, sizeof (GDate));
						{
							GList* info_collection;
							GList* info_it;
							info_collection = self->priv->collection_info;
							for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
								DejaDupDuplicityDateInfo info;
								info = *((DejaDupDuplicityDateInfo*) info_it->data);
								{
									if (info.full) {
										g_date_set_time_val (&full_backup, &info.time);
									}
								}
							}
						}
						_tmp7_ = g_date_valid (&full_backup);
						if (!_tmp7_) {
							_tmp6_ = TRUE;
						} else {
							gint _tmp8_;
							_tmp8_ = g_date_compare (&threshold, &full_backup);
							_tmp6_ = _tmp8_ > 0;
						}
						if (_tmp6_) {
							gboolean _tmp9_;
							self->priv->is_full_backup = TRUE;
							_tmp9_ = g_date_valid (&full_backup);
							if (!_tmp9_) {
								const gchar* _tmp10_ = NULL;
								_tmp10_ = _ ("Creating the first backup.  This may take a while.");
								g_signal_emit_by_name (self, "secondary-desc-changed", _tmp10_);
							} else {
								const gchar* _tmp11_ = NULL;
								_tmp11_ = _ ("Creating a fresh backup to protect against backup corruption.  This wi" \
"ll take longer than normal.");
								g_signal_emit_by_name (self, "secondary-desc-changed", _tmp11_);
							}
						}
					}
					if (self->priv->is_full_backup) {
						g_signal_emit_by_name (self, "is-full");
					}
					_tmp12_ = deja_dup_duplicity_restart (self);
					if (_tmp12_) {
						return;
					} else {
						success = FALSE;
					}
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS:
			{
				if (success) {
					gboolean _tmp13_;
					self->priv->has_checked_contents = TRUE;
					deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_RESTORE);
					_tmp13_ = deja_dup_duplicity_restart (self);
					if (_tmp13_) {
						return;
					} else {
						success = FALSE;
					}
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_STATE_NORMAL:
			{
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				if (success) {
					_tmp15_ = self->priv->_mode == DEJA_DUP_OPERATION_MODE_RESTORE;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					GList* _tmp16_ = NULL;
					_tmp16_ = deja_dup_duplicity_get_restore_files (self);
					_tmp14_ = _tmp16_ != NULL;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					GList* _tmp17_ = NULL;
					self->priv->_restore_files = g_list_delete_link (self->priv->_restore_files, self->priv->_restore_files);
					_tmp17_ = deja_dup_duplicity_get_restore_files (self);
					if (_tmp17_ != NULL) {
						gboolean _tmp18_;
						_tmp18_ = deja_dup_duplicity_restart (self);
						if (_tmp18_) {
							return;
						}
					}
				} else {
					gboolean _tmp19_ = FALSE;
					if (success) {
						_tmp19_ = self->priv->_mode == DEJA_DUP_OPERATION_MODE_BACKUP;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						gboolean _tmp20_;
						deja_dup_duplicity_set_mode (self, DEJA_DUP_OPERATION_MODE_INVALID);
						_tmp20_ = deja_dup_duplicity_delete_files_if_needed (self);
						if (_tmp20_) {
							return;
						}
					}
				}
				break;
			}
			default:
			break;
		}
	} else {
		if (self->priv->_was_stopped) {
			success = TRUE;
		}
	}
	if (self->priv->_error_issued) {
		success = FALSE;
	}
	if (!success) {
		_tmp22_ = !cancelled;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = !self->priv->_error_issued;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		const gchar* _tmp23_ = NULL;
		_tmp23_ = _ ("Failed with an unknown error.");
		deja_dup_duplicity_show_error (self, _tmp23_, NULL);
	}
	inst = NULL;
	g_signal_emit_by_name (self, "done", success, cancelled);
}


static void deja_dup_duplicity_set_status (DejaDupDuplicity* self, const gchar* msg, gboolean save) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	if (save) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (msg);
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = _tmp0_;
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = NULL;
	}
	g_signal_emit_by_name (self, "action-desc-changed", msg);
}


static void deja_dup_duplicity_set_status_file (DejaDupDuplicity* self, GFile* file, gboolean action, gboolean save) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (save) {
		GFile* _tmp0_;
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = NULL;
		_tmp0_ = _g_object_ref0 (file);
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = _tmp0_;
		self->priv->saved_status_file_action = action;
	}
	g_signal_emit_by_name (self, "action-file-changed", file, action);
}


static void deja_dup_duplicity_set_saved_status (DejaDupDuplicity* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->saved_status != NULL) {
		deja_dup_duplicity_set_status (self, self->priv->saved_status, FALSE);
	} else {
		deja_dup_duplicity_set_status_file (self, self->priv->saved_status_file, self->priv->saved_status_file_action, FALSE);
	}
}


static gboolean deja_dup_duplicity_restart_with_short_filenames_if_needed (DejaDupDuplicity* self) {
	gboolean result = FALSE;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_can_read_short_filenames (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->backend_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp4_;
			gchar* s;
			_tmp4_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp4_;
			{
				if (g_strcmp0 (s, "--short-filenames") == 0) {
					result = FALSE;
					_g_free0 (s);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	_tmp5_ = g_strdup ("--short-filenames");
	self->priv->backend_argv = g_list_append (self->priv->backend_argv, _tmp5_);
	_tmp6_ = deja_dup_duplicity_restart (self);
	if (!_tmp6_) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean deja_dup_duplicity_delete_files_if_needed (DejaDupDuplicity* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->delete_age == 0) {
		self->priv->deleted_files = TRUE;
		result = FALSE;
		return result;
	}
	if (self->priv->got_collection_info) {
		_tmp0_ = !self->priv->deleted_files;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint full_dates;
		GTimeVal prev_time = {0};
		GDate prev_date = {0};
		gint too_old;
		GTimeVal now = {0};
		GDate today = {0};
		gint _tmp2_;
		gboolean _tmp3_ = FALSE;
		full_dates = 0;
		g_get_current_time (&prev_time);
		memset (&prev_date, 0, sizeof (GDate));
		too_old = 0;
		g_get_current_time (&now);
		g_get_current_time (&now);
		memset (&today, 0, sizeof (GDate));
		g_date_set_time_val (&today, &now);
		{
			GList* info_collection;
			GList* info_it;
			info_collection = self->priv->collection_info;
			for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
				DejaDupDuplicityDateInfo info;
				info = *((DejaDupDuplicityDateInfo*) info_it->data);
				{
					if (info.full) {
						if (full_dates > 0) {
							gint _tmp1_;
							g_date_set_time_val (&prev_date, &prev_time);
							_tmp1_ = g_date_days_between (&prev_date, &today);
							if (_tmp1_ > self->priv->delete_age) {
								too_old = too_old + 1;
							}
						}
						full_dates = full_dates + 1;
					}
					prev_time = info.time;
				}
			}
		}
		g_date_set_time_val (&prev_date, &prev_time);
		_tmp2_ = g_date_days_between (&prev_date, &today);
		if (_tmp2_ > self->priv->delete_age) {
			too_old = too_old + 1;
		}
		if (self->priv->is_full_backup) {
			full_dates = full_dates + 1;
		}
		if (too_old > 0) {
			_tmp3_ = full_dates > DEJA_DUP_DUPLICITY_MINIMUM_FULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp4_;
			gint cutoff;
			_tmp4_ = MAX (DEJA_DUP_DUPLICITY_MINIMUM_FULL, full_dates - too_old);
			cutoff = _tmp4_;
			deja_dup_duplicity_delete_excess (self, cutoff);
			result = TRUE;
			return result;
		}
		self->priv->deleted_files = TRUE;
		result = FALSE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean deja_dup_duplicity_restart_without_cache (DejaDupDuplicity* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* dir;
	gchar* _tmp2_ = NULL;
	gchar* cachedir;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	DejaDupRecursiveDelete* _tmp5_ = NULL;
	DejaDupRecursiveDelete* _tmp6_;
	DejaDupRecursiveDelete* del;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->restarted_without_cache) {
		result = FALSE;
		return result;
	}
	self->priv->restarted_without_cache = TRUE;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	dir = _tmp1_;
	if (dir == NULL) {
		result = FALSE;
		_g_free0 (dir);
		return result;
	}
	_tmp2_ = g_build_filename (dir, PACKAGE, NULL);
	cachedir = _tmp2_;
	_tmp3_ = g_file_new_for_path (cachedir);
	_tmp4_ = _tmp3_;
	_tmp5_ = deja_dup_recursive_delete_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	del = _tmp6_;
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) del);
	_tmp7_ = deja_dup_duplicity_restart (self);
	result = _tmp7_;
	_g_object_unref0 (del);
	_g_free0 (cachedir);
	_g_free0 (dir);
	return result;
}


static void deja_dup_duplicity_handle_exit (DejaDupDuplicity* self, gint code) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	DejaDupDuplicityInfo* _tmp2_ = NULL;
	DejaDupDuplicityInfo* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp2_ = deja_dup_duplicity_info_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_duplicity_info_get_guarantees_error_codes (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	if (_tmp5_) {
		_tmp1_ = code == DEJA_DUP_DUPLICITY_ERROR_GENERIC;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->_error_issued;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		deja_dup_duplicity_restart_without_cache (self);
	}
}


static void deja_dup_duplicity_handle_message (DejaDupDuplicity* self, DejaDupDuplicityInstance* inst, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text) {
	gchar* _tmp0_;
	gchar* keyword;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	g_return_if_fail (user_text != NULL);
	if (control_line_length1 == 0) {
		return;
	}
	_tmp0_ = g_strdup (control_line[0]);
	keyword = _tmp0_;
	_tmp1_ = keyword;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("ERROR")))) {
		switch (0) {
			default:
			{
				deja_dup_duplicity_process_error (self, control_line, control_line_length1, data_lines, user_text);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("INFO")))) {
		switch (0) {
			default:
			{
				deja_dup_duplicity_process_info (self, control_line, control_line_length1, data_lines, user_text);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("WARNING")))) {
		switch (0) {
			default:
			{
				deja_dup_duplicity_process_warning (self, control_line, control_line_length1, data_lines, user_text);
				break;
			}
		}
	}
	_g_free0 (keyword);
}


static gboolean deja_dup_duplicity_ask_question (DejaDupDuplicity* self, const gchar* t, const gchar* m) {
	gboolean result = FALSE;
	gboolean rv;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	deja_dup_duplicity_disconnect_inst (self);
	g_signal_emit_by_name (self, "question", t, m);
	rv = self->priv->_mode != DEJA_DUP_OPERATION_MODE_INVALID;
	if (!rv) {
		deja_dup_duplicity_handle_done (self, NULL, FALSE, TRUE);
	}
	result = rv;
	return result;
}


static void deja_dup_duplicity_real_process_error (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in) {
	gchar* _tmp0_;
	gchar* text;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text_in != NULL);
	_tmp0_ = g_strdup (text_in);
	text = _tmp0_;
	if (self->priv->_state == DEJA_DUP_DUPLICITY_STATE_CLEANUP) {
		_g_free0 (text);
		return;
	}
	if (firstline_length1 > 1) {
		gint _tmp1_;
		_tmp1_ = atoi (firstline[1]);
		switch (_tmp1_) {
			case DEJA_DUP_DUPLICITY_ERROR_EXCEPTION:
			{
				const gchar* _tmp2_ = NULL;
				if (firstline_length1 > 2) {
					_tmp2_ = firstline[2];
				} else {
					_tmp2_ = "";
				}
				deja_dup_duplicity_process_exception (self, _tmp2_, text);
				_g_free0 (text);
				return;
			}
			case DEJA_DUP_DUPLICITY_ERROR_RESTORE_DIR_NOT_FOUND:
			{
				GList* _tmp3_ = NULL;
				_tmp3_ = deja_dup_duplicity_get_restore_files (self);
				if (_tmp3_ != NULL) {
					const gchar* _tmp4_ = NULL;
					GList* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					gchar* _tmp8_ = NULL;
					_tmp4_ = _ ("Could not restore ‘%s’: File not found in backup");
					_tmp5_ = deja_dup_duplicity_get_restore_files (self);
					_tmp6_ = g_file_get_parse_name ((GFile*) _tmp5_->data);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
					_g_free0 (text);
					text = _tmp8_;
					_g_free0 (_tmp7_);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_ERROR_GPG:
			{
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp9_ = _ ("Bad encryption password.");
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (text);
				text = _tmp10_;
				break;
			}
			case DEJA_DUP_DUPLICITY_ERROR_HOSTNAME_CHANGED:
			{
				gchar* _tmp17_;
				gboolean _tmp18_;
				if (firstline_length1 >= 4) {
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gboolean _tmp15_;
					gboolean _tmp16_;
					_tmp11_ = _ ("Computer name changed");
					_tmp12_ = _ ("The existing backup is of a computer named %s, but the current compute" \
"r’s name is %s.  If this is unexpected, you should back up to a differ" \
"ent location.");
					_tmp13_ = g_strdup_printf (_tmp12_, firstline[2], firstline[3]);
					_tmp14_ = _tmp13_;
					_tmp15_ = deja_dup_duplicity_ask_question (self, _tmp11_, _tmp14_);
					_tmp16_ = !_tmp15_;
					_g_free0 (_tmp14_);
					if (_tmp16_) {
						_g_free0 (text);
						return;
					}
				}
				_tmp17_ = g_strdup ("--allow-source-mismatch");
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp17_);
				_tmp18_ = deja_dup_duplicity_restart (self);
				if (_tmp18_) {
					_g_free0 (text);
					return;
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_ERROR_BACKEND_PERMISSION_DENIED:
			{
				gboolean _tmp19_ = FALSE;
				gboolean _tmp25_ = FALSE;
				if (firstline_length1 >= 5) {
					_tmp19_ = g_strcmp0 (firstline[2], "put") == 0;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					GFile* _tmp20_ = NULL;
					GFile* file;
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* _tmp24_ = NULL;
					_tmp20_ = deja_dup_duplicity_make_file_obj (self, firstline[4]);
					file = _tmp20_;
					_tmp21_ = _ ("Permission denied when trying to create ‘%s’.");
					_tmp22_ = g_file_get_parse_name (file);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup_printf (_tmp21_, _tmp23_);
					_g_free0 (text);
					text = _tmp24_;
					_g_free0 (_tmp23_);
					_g_object_unref0 (file);
				}
				if (firstline_length1 >= 5) {
					_tmp25_ = g_strcmp0 (firstline[2], "get") == 0;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					GFile* _tmp26_ = NULL;
					GFile* file;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					_tmp26_ = deja_dup_duplicity_make_file_obj (self, firstline[3]);
					file = _tmp26_;
					_tmp27_ = _ ("Permission denied when trying to read ‘%s’.");
					_tmp28_ = g_file_get_parse_name (file);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strdup_printf (_tmp27_, _tmp29_);
					_g_free0 (text);
					text = _tmp30_;
					_g_free0 (_tmp29_);
					_g_object_unref0 (file);
				} else {
					gboolean _tmp31_ = FALSE;
					if (firstline_length1 >= 4) {
						_tmp31_ = g_strcmp0 (firstline[2], "list") == 0;
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						GFile* _tmp32_ = NULL;
						GFile* file;
						const gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_;
						gchar* _tmp36_ = NULL;
						_tmp32_ = deja_dup_duplicity_make_file_obj (self, firstline[3]);
						file = _tmp32_;
						_tmp33_ = _ ("Permission denied when trying to read ‘%s’.");
						_tmp34_ = g_file_get_parse_name (file);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_);
						_g_free0 (text);
						text = _tmp36_;
						_g_free0 (_tmp35_);
						_g_object_unref0 (file);
					} else {
						gboolean _tmp37_ = FALSE;
						if (firstline_length1 >= 4) {
							_tmp37_ = g_strcmp0 (firstline[2], "delete") == 0;
						} else {
							_tmp37_ = FALSE;
						}
						if (_tmp37_) {
							GFile* _tmp38_ = NULL;
							GFile* file;
							const gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_;
							gchar* _tmp42_ = NULL;
							_tmp38_ = deja_dup_duplicity_make_file_obj (self, firstline[3]);
							file = _tmp38_;
							_tmp39_ = _ ("Permission denied when trying to delete ‘%s’.");
							_tmp40_ = g_file_get_parse_name (file);
							_tmp41_ = _tmp40_;
							_tmp42_ = g_strdup_printf (_tmp39_, _tmp41_);
							_g_free0 (text);
							text = _tmp42_;
							_g_free0 (_tmp41_);
							_g_object_unref0 (file);
						}
					}
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_ERROR_BACKEND_NOT_FOUND:
			{
				if (firstline_length1 >= 4) {
					GFile* _tmp43_ = NULL;
					GFile* file;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_;
					gchar* _tmp47_ = NULL;
					_tmp43_ = deja_dup_duplicity_make_file_obj (self, firstline[3]);
					file = _tmp43_;
					_tmp44_ = _ ("Backup location ‘%s’ does not exist.");
					_tmp45_ = g_file_get_parse_name (file);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup_printf (_tmp44_, _tmp46_);
					_g_free0 (text);
					text = _tmp47_;
					_g_free0 (_tmp46_);
					_g_object_unref0 (file);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_ERROR_BACKEND_NO_SPACE:
			{
				if (firstline_length1 >= 5) {
					const gchar* _tmp48_ = NULL;
					gchar* _tmp49_;
					_tmp48_ = _ ("No space left.");
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (text);
					text = _tmp49_;
				}
				break;
			}
			default:
			break;
		}
	}
	deja_dup_duplicity_show_error (self, text, NULL);
	_g_free0 (text);
}


void deja_dup_duplicity_process_error (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text_in) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_error (self, firstline, firstline_length1, data, text_in);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void deja_dup_duplicity_process_exception (DejaDupDuplicity* self, const gchar* exception, const gchar* text) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exception != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = exception;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("S3ResponseError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp2_;
				_tmp2_ = string_contains (text, "<Code>InvalidAccessKeyId</Code>");
				if (_tmp2_) {
					const gchar* _tmp3_ = NULL;
					_tmp3_ = _ ("Invalid ID.");
					deja_dup_duplicity_show_error (self, _tmp3_, NULL);
				} else {
					gboolean _tmp4_;
					_tmp4_ = string_contains (text, "<Code>SignatureDoesNotMatch</Code>");
					if (_tmp4_) {
						const gchar* _tmp5_ = NULL;
						_tmp5_ = _ ("Invalid secret key.");
						deja_dup_duplicity_show_error (self, _tmp5_, NULL);
					} else {
						gboolean _tmp6_;
						_tmp6_ = string_contains (text, "<Code>NotSignedUp</Code>");
						if (_tmp6_) {
							const gchar* _tmp7_ = NULL;
							_tmp7_ = _ ("Your Amazon Web Services account is not signed up for the S3 service.");
							deja_dup_duplicity_show_error (self, _tmp7_, NULL);
						}
					}
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("S3CreateError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp8_;
				_tmp8_ = string_contains (text, "<Code>BucketAlreadyExists</Code>");
				if (_tmp8_) {
					gboolean _tmp9_;
					const gchar* _tmp13_ = NULL;
					_tmp9_ = deja_dup_backend_s3_bump_bucket (DEJA_DUP_BACKEND_S3 (self->priv->_backend));
					if (_tmp9_) {
						gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						gboolean _tmp12_;
						_tmp10_ = deja_dup_backend_get_location (self->priv->_backend, &_inner_error_);
						_tmp11_ = _tmp10_;
						if (_inner_error_ != NULL) {
							goto __catch21_g_error;
						}
						_g_free0 (self->priv->remote);
						self->priv->remote = _tmp11_;
						_tmp12_ = deja_dup_duplicity_restart (self);
						if (_tmp12_) {
							return;
						}
						goto __finally21;
						__catch21_g_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							g_warning ("Duplicity.vala:974: %s\n", e->message);
							_g_error_free0 (e);
						}
						__finally21:
						if (_inner_error_ != NULL) {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp13_ = _ ("S3 bucket name is not available.");
					deja_dup_duplicity_show_error (self, _tmp13_, NULL);
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("IOError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp14_;
				_tmp14_ = string_contains (text, "GnuPG");
				if (_tmp14_) {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = _ ("Bad encryption password.");
					deja_dup_duplicity_show_error (self, _tmp15_, NULL);
				} else {
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_;
					_tmp17_ = string_contains (text, "[Errno 5]");
					if (_tmp17_) {
						_tmp16_ = self->priv->last_touched_file != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
							const gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							_tmp18_ = _ ("Error reading file ‘%s’.");
							_tmp19_ = g_file_get_parse_name (self->priv->last_touched_file);
							_tmp20_ = _tmp19_;
							_tmp21_ = g_strdup_printf (_tmp18_, _tmp20_);
							_tmp22_ = _tmp21_;
							deja_dup_duplicity_show_error (self, _tmp22_, NULL);
							_g_free0 (_tmp22_);
							_g_free0 (_tmp20_);
						} else {
							const gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							_tmp23_ = _ ("Error writing file ‘%s’.");
							_tmp24_ = g_file_get_parse_name (self->priv->last_touched_file);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_strdup_printf (_tmp23_, _tmp25_);
							_tmp27_ = _tmp26_;
							deja_dup_duplicity_show_error (self, _tmp27_, NULL);
							_g_free0 (_tmp27_);
							_g_free0 (_tmp25_);
						}
					} else {
						gboolean _tmp28_;
						_tmp28_ = string_contains (text, "[Errno 28]");
						if (_tmp28_) {
							gchar* where;
							where = NULL;
							if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
								gchar* _tmp29_ = NULL;
								gchar* _tmp30_;
								_tmp29_ = deja_dup_backend_get_location_pretty (self->priv->_backend, &_inner_error_);
								_tmp30_ = _tmp29_;
								if (_inner_error_ != NULL) {
									goto __catch22_g_error;
								}
								_g_free0 (where);
								where = _tmp30_;
								goto __finally22;
								__catch22_g_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									g_warning ("Duplicity.vala:996: %s\n", e->message);
									_g_error_free0 (e);
								}
								__finally22:
								if (_inner_error_ != NULL) {
									_g_free0 (where);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							} else {
								gchar* _tmp31_ = NULL;
								_tmp31_ = g_file_get_path (self->priv->_local);
								_g_free0 (where);
								where = _tmp31_;
							}
							if (where == NULL) {
								const gchar* _tmp32_ = NULL;
								_tmp32_ = _ ("No space left.");
								deja_dup_duplicity_show_error (self, _tmp32_, NULL);
							} else {
								const gchar* _tmp33_ = NULL;
								gchar* _tmp34_ = NULL;
								gchar* _tmp35_;
								_tmp33_ = _ ("No space left in ‘%s’.");
								_tmp34_ = g_strdup_printf (_tmp33_, where);
								_tmp35_ = _tmp34_;
								deja_dup_duplicity_show_error (self, _tmp35_, NULL);
								_g_free0 (_tmp35_);
							}
							_g_free0 (where);
						} else {
							DejaDupDuplicityInfo* _tmp36_ = NULL;
							DejaDupDuplicityInfo* _tmp37_;
							gboolean _tmp38_;
							gboolean _tmp39_;
							_tmp36_ = deja_dup_duplicity_info_get_default ();
							_tmp37_ = _tmp36_;
							_tmp38_ = deja_dup_duplicity_info_get_new_time_format (_tmp37_);
							_tmp39_ = !_tmp38_;
							_g_object_unref0 (_tmp37_);
							if (_tmp39_) {
								deja_dup_duplicity_restart_with_short_filenames_if_needed (self);
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("CollectionsError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp40_;
				_tmp40_ = deja_dup_duplicity_restart_with_short_filenames_if_needed (self);
				if (_tmp40_) {
					const gchar* _tmp41_ = NULL;
					_tmp41_ = _ ("No backup files found");
					deja_dup_duplicity_show_error (self, _tmp41_, NULL);
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("AssertionError")))) {
		switch (0) {
			default:
			{
				gboolean _tmp42_;
				_tmp42_ = string_contains (text, "time not moving forward at appropriate pace");
				if (_tmp42_) {
					gboolean _tmp43_;
					_tmp43_ = deja_dup_duplicity_restart_without_cache (self);
					if (_tmp43_) {
						return;
					}
				}
				break;
			}
		}
	}
	if (!self->priv->_error_issued) {
		const gchar* _tmp44_ = NULL;
		_tmp44_ = _ ("Failed with an unknown error.");
		deja_dup_duplicity_show_error (self, _tmp44_, text);
	}
}


static void deja_dup_duplicity_real_process_info (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		gint _tmp0_;
		_tmp0_ = atoi (firstline[1]);
		switch (_tmp0_) {
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_NEW:
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_CHANGED:
			case DEJA_DUP_DUPLICITY_INFO_DIFF_FILE_DELETED:
			{
				if (firstline_length1 > 2) {
					deja_dup_duplicity_process_diff_file (self, firstline[2]);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_WRITING:
			case DEJA_DUP_DUPLICITY_INFO_PATCH_FILE_PATCHING:
			{
				if (firstline_length1 > 2) {
					deja_dup_duplicity_process_patch_file (self, firstline[2]);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_PROGRESS:
			{
				deja_dup_duplicity_process_progress (self, firstline, firstline_length1);
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_COLLECTION_STATUS:
			{
				deja_dup_duplicity_process_collection_status (self, data);
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_SYNCHRONOUS_UPLOAD_BEGIN:
			case DEJA_DUP_DUPLICITY_INFO_ASYNCHRONOUS_UPLOAD_BEGIN:
			{
				gboolean _tmp1_;
				_tmp1_ = deja_dup_backend_is_native (self->priv->_backend);
				if (!_tmp1_) {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = _ ("Uploading…");
					deja_dup_duplicity_set_status (self, _tmp2_, TRUE);
				}
				break;
			}
			case DEJA_DUP_DUPLICITY_INFO_FILE_STAT:
			{
				deja_dup_duplicity_process_file_stat (self, firstline[2], firstline[3], data, text);
				break;
			}
			default:
			break;
		}
	}
}


void deja_dup_duplicity_process_info (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_info (self, firstline, firstline_length1, data, text);
}


static void deja_dup_duplicity_process_file_stat (DejaDupDuplicity* self, const gchar* date, const gchar* file, GList* data, const gchar* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->_mode != DEJA_DUP_OPERATION_MODE_LIST) {
		return;
	}
	if (self->priv->_state == DEJA_DUP_DUPLICITY_STATE_CHECK_CONTENTS) {
		GFile* _tmp0_ = NULL;
		GFile* gfile;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp0_ = deja_dup_duplicity_make_file_obj (self, file);
		gfile = _tmp0_;
		_tmp2_ = g_file_equal (gfile, deja_dup_duplicity_slash_root);
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp3_ = FALSE;
			GFile* _tmp4_ = NULL;
			GFile* _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = g_file_get_parent (gfile);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_ != NULL;
			_g_object_unref0 (_tmp5_);
			if (_tmp6_) {
				GFile* _tmp7_ = NULL;
				GFile* _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = g_file_get_parent (gfile);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_file_equal (_tmp8_, deja_dup_duplicity_slash_home);
				_tmp3_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
			} else {
				_tmp3_ = FALSE;
			}
			_tmp1_ = _tmp3_;
		}
		if (_tmp1_) {
			GFile* _tmp10_;
			_tmp10_ = _g_object_ref0 (gfile);
			self->priv->homes = g_list_append (self->priv->homes, _tmp10_);
		}
		if (!self->priv->has_non_home_contents) {
			gboolean _tmp14_;
			_tmp14_ = g_file_equal (gfile, deja_dup_duplicity_slash);
			_tmp13_ = !_tmp14_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gboolean _tmp15_;
			_tmp15_ = g_file_equal (gfile, deja_dup_duplicity_slash_home);
			_tmp12_ = !_tmp15_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean _tmp16_;
			_tmp16_ = g_file_has_prefix (gfile, deja_dup_duplicity_slash_home);
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			self->priv->has_non_home_contents = TRUE;
		}
		_g_object_unref0 (gfile);
	}
	g_signal_emit_by_name (self, "listed-current-files", date, file);
}


static void deja_dup_duplicity_process_diff_file (DejaDupDuplicity* self, const gchar* file) {
	GFile* _tmp0_ = NULL;
	GFile* gfile;
	GFile* _tmp1_;
	GFileType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = deja_dup_duplicity_make_file_obj (self, file);
	gfile = _tmp0_;
	_tmp1_ = _g_object_ref0 (gfile);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp1_;
	_tmp2_ = g_file_query_file_type (gfile, G_FILE_QUERY_INFO_NONE, NULL);
	if (_tmp2_ != G_FILE_TYPE_DIRECTORY) {
		deja_dup_duplicity_set_status_file (self, gfile, self->priv->_state != DEJA_DUP_DUPLICITY_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}


static void deja_dup_duplicity_process_patch_file (DejaDupDuplicity* self, const gchar* file) {
	GFile* _tmp0_ = NULL;
	GFile* gfile;
	GFile* _tmp1_;
	GFileType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = deja_dup_duplicity_make_file_obj (self, file);
	gfile = _tmp0_;
	_tmp1_ = _g_object_ref0 (gfile);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp1_;
	_tmp2_ = g_file_query_file_type (gfile, G_FILE_QUERY_INFO_NONE, NULL);
	if (_tmp2_ != G_FILE_TYPE_DIRECTORY) {
		deja_dup_duplicity_set_status_file (self, gfile, self->priv->_state != DEJA_DUP_DUPLICITY_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static void deja_dup_duplicity_process_progress (DejaDupDuplicity* self, gchar** firstline, int firstline_length1) {
	gboolean _tmp0_ = FALSE;
	DejaDupDuplicityInfo* _tmp1_ = NULL;
	DejaDupDuplicityInfo* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gdouble total = 0.0;
	gdouble percent;
	g_return_if_fail (self != NULL);
	_tmp1_ = deja_dup_duplicity_info_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_duplicity_info_get_has_restore_progress (_tmp2_);
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = self->priv->_mode == DEJA_DUP_OPERATION_MODE_RESTORE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (firstline_length1 > 2) {
		guint64 _tmp5_;
		_tmp5_ = uint64_parse (firstline[2]);
		self->priv->progress_count = _tmp5_;
	} else {
		return;
	}
	if (firstline_length1 > 3) {
		gdouble _tmp6_;
		_tmp6_ = double_parse (firstline[3]);
		total = _tmp6_;
	} else {
		if (self->priv->progress_total > 0) {
			total = (gdouble) self->priv->progress_total;
		} else {
			return;
		}
	}
	percent = ((gdouble) self->priv->progress_count) / total;
	if (percent > 1) {
		percent = (gdouble) 1;
	}
	if (percent < 0) {
		percent = (gdouble) 0;
	}
	g_signal_emit_by_name (self, "progress", percent);
}


static GFile* deja_dup_duplicity_make_file_obj (DejaDupDuplicity* self, const gchar* file) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_resolve_relative_path (deja_dup_duplicity_slash, file);
	result = _tmp0_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gpointer _deja_dup_duplicity_date_info_dup0 (gpointer self) {
	return self ? deja_dup_duplicity_date_info_dup (self) : NULL;
}


static void deja_dup_duplicity_process_collection_status (DejaDupDuplicity* self, GList* lines) {
	GTimeVal timeval = {0};
	GList* dates;
	GList* infos;
	gboolean in_chain;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_get_current_time (&timeval);
	dates = NULL;
	infos = NULL;
	in_chain = FALSE;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = lines;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp0_;
			gchar* line;
			_tmp0_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				if (g_strcmp0 (line, "chain-complete") == 0) {
					_tmp1_ = TRUE;
				} else {
					gint _tmp2_;
					_tmp2_ = string_index_of (line, "chain-no-sig", 0);
					_tmp1_ = _tmp2_ == 0;
				}
				if (_tmp1_) {
					in_chain = TRUE;
				} else {
					gboolean _tmp3_ = FALSE;
					gboolean _tmp4_ = FALSE;
					if (in_chain) {
						gint _tmp5_;
						_tmp5_ = strlen (line);
						_tmp4_ = _tmp5_ > 0;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						gchar _tmp6_;
						_tmp6_ = string_get (line, (glong) 0);
						_tmp3_ = _tmp6_ == ' ';
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						gchar** _tmp7_;
						gchar** _tmp8_ = NULL;
						gchar** tokens;
						gint tokens_length1;
						gint _tokens_size_;
						gboolean _tmp9_ = FALSE;
						_tmp8_ = _tmp7_ = g_strsplit (line, " ", 0);
						tokens = _tmp8_;
						tokens_length1 = _vala_array_length (_tmp7_);
						_tokens_size_ = _vala_array_length (_tmp7_);
						if (tokens_length1 > 2) {
							gboolean _tmp10_;
							_tmp10_ = g_time_val_from_iso8601 (tokens[2], &timeval);
							_tmp9_ = _tmp10_;
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							gchar* _tmp11_;
							DejaDupDuplicityDateInfo info = {0};
							DejaDupDuplicityDateInfo* _tmp12_;
							_tmp11_ = g_strdup (tokens[2]);
							dates = g_list_append (dates, _tmp11_);
							memset (&info, 0, sizeof (DejaDupDuplicityDateInfo));
							info.time = timeval;
							info.full = g_strcmp0 (tokens[1], "full") == 0;
							_tmp12_ = _deja_dup_duplicity_date_info_dup0 (&info);
							infos = g_list_append (infos, _tmp12_);
						}
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					} else {
						if (in_chain) {
							in_chain = FALSE;
						}
					}
				}
				_g_free0 (line);
			}
		}
	}
	if (self->priv->_mode == DEJA_DUP_OPERATION_MODE_STATUS) {
		guint _tmp14_;
		_tmp14_ = g_list_length (dates);
		_tmp13_ = _tmp14_ == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp15_;
		_tmp15_ = deja_dup_duplicity_restart_with_short_filenames_if_needed (self);
		if (_tmp15_) {
			__g_list_free__deja_dup_duplicity_date_info_free0_0 (infos);
			__g_list_free__g_free0_0 (dates);
			return;
		}
	}
	self->priv->got_collection_info = TRUE;
	__g_list_free__deja_dup_duplicity_date_info_free0_0 (self->priv->collection_info);
	self->priv->collection_info = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = infos;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			DejaDupDuplicityDateInfo s;
			s = *((DejaDupDuplicityDateInfo*) s_it->data);
			{
				DejaDupDuplicityDateInfo* _tmp16_;
				_tmp16_ = _deja_dup_duplicity_date_info_dup0 (&s);
				self->priv->collection_info = g_list_append (self->priv->collection_info, _tmp16_);
			}
		}
	}
	g_signal_emit_by_name (self, "collection-dates", dates);
	__g_list_free__deja_dup_duplicity_date_info_free0_0 (infos);
	__g_list_free__g_free0_0 (dates);
}


static void deja_dup_duplicity_real_process_warning (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		gint _tmp0_;
		_tmp0_ = atoi (firstline[1]);
		switch (_tmp0_) {
			case DEJA_DUP_DUPLICITY_WARNING_ORPHANED_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_UNNECESSARY_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_UNMATCHED_SIG:
			case DEJA_DUP_DUPLICITY_WARNING_INCOMPLETE_BACKUP:
			case DEJA_DUP_DUPLICITY_WARNING_ORPHANED_BACKUP:
			{
				if (!self->priv->cleaned_up_once) {
					deja_dup_duplicity_cleanup (self);
				}
				break;
			}
			default:
			break;
		}
	}
}


void deja_dup_duplicity_process_warning (DejaDupDuplicity* self, gchar** firstline, int firstline_length1, GList* data, const gchar* text) {
	DEJA_DUP_DUPLICITY_GET_CLASS (self)->process_warning (self, firstline, firstline_length1, data, text);
}


static void deja_dup_duplicity_show_error (DejaDupDuplicity* self, const gchar* errorstr, const gchar* detail) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (errorstr != NULL);
	if (self->priv->_error_issued == FALSE) {
		deja_dup_duplicity_set_error_issued (self, TRUE);
		g_signal_emit_by_name (self, "raise-error", errorstr, detail);
	}
}


static gint deja_dup_duplicity_get_volsize (DejaDupDuplicity* self) {
	gint result = 0;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = deja_dup_backend_is_native (self->priv->_backend);
	if (_tmp0_) {
		result = 30;
		return result;
	} else {
		result = 10;
		return result;
	}
}


static void _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done (DejaDupDuplicityInstance* _sender, gboolean success, gboolean cancelled, gpointer self) {
	deja_dup_duplicity_handle_done (self, _sender, success, cancelled);
}


static void _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message (DejaDupDuplicityInstance* _sender, gchar** control_line, int control_line_length1, GList* data_lines, const gchar* user_text, gpointer self) {
	deja_dup_duplicity_handle_message (self, _sender, control_line, control_line_length1, data_lines, user_text);
}


static void _deja_dup_duplicity_handle_exit_deja_dup_duplicity_instance_exited (DejaDupDuplicityInstance* _sender, gint code, gpointer self) {
	deja_dup_duplicity_handle_exit (self, code);
}


static void deja_dup_duplicity_disconnect_inst (DejaDupDuplicity* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->inst != NULL) {
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		g_signal_parse_name ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done, self);
		g_signal_parse_name ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message, self);
		g_signal_parse_name ("exited", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _deja_dup_duplicity_handle_exit_deja_dup_duplicity_instance_exited, self);
		deja_dup_duplicity_instance_cancel (self->priv->inst);
		_g_object_unref0 (self->priv->inst);
		self->priv->inst = NULL;
	}
}


static void deja_dup_duplicity_connect_and_start (DejaDupDuplicity* self, GList* argv_extra, GList* envp_extra, GList* argv_entire, GFile* custom_local) {
	DejaDupDuplicityInstance* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* master_argv;
	GFile* _tmp2_ = NULL;
	GFile* local_arg;
	GList* argv;
	GList* envp;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_disconnect_inst (self);
	_tmp0_ = deja_dup_duplicity_instance_new ();
	_g_object_unref0 (self->priv->inst);
	self->priv->inst = _tmp0_;
	g_signal_connect_object (self->priv->inst, "done", (GCallback) _deja_dup_duplicity_handle_done_deja_dup_duplicity_instance_done, self, 0);
	g_signal_connect_object (self->priv->inst, "message", (GCallback) _deja_dup_duplicity_handle_message_deja_dup_duplicity_instance_message, self, 0);
	g_signal_connect_object (self->priv->inst, "exited", (GCallback) _deja_dup_duplicity_handle_exit_deja_dup_duplicity_instance_exited, self, 0);
	if (argv_entire == NULL) {
		_tmp1_ = self->priv->saved_argv;
	} else {
		_tmp1_ = argv_entire;
	}
	master_argv = _tmp1_;
	if (custom_local == NULL) {
		_tmp2_ = self->priv->_local;
	} else {
		_tmp2_ = custom_local;
	}
	local_arg = _tmp2_;
	argv = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = master_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp3_;
			gchar* s;
			_tmp3_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp3_;
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (s);
				argv = g_list_append (argv, _tmp4_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = argv_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp5_;
			gchar* s;
			_tmp5_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp5_;
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup (s);
				argv = g_list_append (argv, _tmp6_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->backend_argv;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp7_;
			gchar* s;
			_tmp7_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp7_;
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup (s);
				argv = g_list_append (argv, _tmp8_);
				_g_free0 (s);
			}
		}
	}
	if (argv_entire == NULL) {
		switch (self->priv->_mode) {
			case DEJA_DUP_OPERATION_MODE_BACKUP:
			{
				gint _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				if (self->priv->is_full_backup) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("full");
					argv = g_list_prepend (argv, _tmp9_);
				}
				_tmp10_ = deja_dup_duplicity_get_volsize (self);
				_tmp11_ = g_strdup_printf ("--volsize=%d", _tmp10_);
				argv = g_list_append (argv, _tmp11_);
				_tmp12_ = g_file_get_path (local_arg);
				argv = g_list_append (argv, _tmp12_);
				_tmp13_ = g_strdup (self->priv->remote);
				argv = g_list_append (argv, _tmp13_);
				break;
			}
			case DEJA_DUP_OPERATION_MODE_RESTORE:
			{
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				_tmp14_ = g_strdup ("restore");
				argv = g_list_prepend (argv, _tmp14_);
				_tmp15_ = g_strdup ("--force");
				argv = g_list_append (argv, _tmp15_);
				_tmp16_ = g_strdup (self->priv->remote);
				argv = g_list_append (argv, _tmp16_);
				_tmp17_ = g_file_get_path (local_arg);
				argv = g_list_append (argv, _tmp17_);
				break;
			}
			case DEJA_DUP_OPERATION_MODE_STATUS:
			{
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = g_strdup ("collection-status");
				argv = g_list_prepend (argv, _tmp18_);
				_tmp19_ = g_strdup (self->priv->remote);
				argv = g_list_append (argv, _tmp19_);
				break;
			}
			case DEJA_DUP_OPERATION_MODE_LIST:
			{
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = g_strdup ("list-current-files");
				argv = g_list_prepend (argv, _tmp20_);
				_tmp21_ = g_strdup (self->priv->remote);
				argv = g_list_append (argv, _tmp21_);
				break;
			}
			default:
			break;
		}
	}
	envp = NULL;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = self->priv->saved_envp;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp22_;
			gchar* s;
			_tmp22_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp22_;
			{
				gchar* _tmp23_;
				_tmp23_ = g_strdup (s);
				envp = g_list_append (envp, _tmp23_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection;
		GList* s_it;
		s_collection = envp_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp24_;
			gchar* s;
			_tmp24_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp24_;
			{
				gchar* _tmp25_;
				_tmp25_ = g_strdup (s);
				envp = g_list_append (envp, _tmp25_);
				_g_free0 (s);
			}
		}
	}
	deja_dup_duplicity_instance_start (self->priv->inst, argv, envp, self->priv->needs_root, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch23_g_error;
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		deja_dup_duplicity_show_error (self, e->message, NULL);
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		__g_list_free__g_free0_0 (envp);
		__g_list_free__g_free0_0 (argv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	__g_list_free__g_free0_0 (envp);
	__g_list_free__g_free0_0 (argv);
}


DejaDupOperationMode deja_dup_duplicity_get_original_mode (DejaDupDuplicity* self) {
	DejaDupOperationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_original_mode;
	return result;
}


static void deja_dup_duplicity_set_original_mode (DejaDupDuplicity* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_original_mode = value;
	g_object_notify ((GObject *) self, "original-mode");
}


DejaDupOperationMode deja_dup_duplicity_get_mode (DejaDupDuplicity* self) {
	DejaDupOperationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}


static void deja_dup_duplicity_set_mode (DejaDupDuplicity* self, DejaDupOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


gboolean deja_dup_duplicity_get_error_issued (DejaDupDuplicity* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_issued;
	return result;
}


static void deja_dup_duplicity_set_error_issued (DejaDupDuplicity* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_issued = value;
	g_object_notify ((GObject *) self, "error-issued");
}


gboolean deja_dup_duplicity_get_was_stopped (DejaDupDuplicity* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_was_stopped;
	return result;
}


static void deja_dup_duplicity_set_was_stopped (DejaDupDuplicity* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_was_stopped = value;
	g_object_notify ((GObject *) self, "was-stopped");
}


GFile* deja_dup_duplicity_get_local (DejaDupDuplicity* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_local;
	return result;
}


void deja_dup_duplicity_set_local (DejaDupDuplicity* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_local);
	self->priv->_local = _tmp0_;
	g_object_notify ((GObject *) self, "local");
}


DejaDupBackend* deja_dup_duplicity_get_backend (DejaDupDuplicity* self) {
	DejaDupBackend* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_backend;
	return result;
}


void deja_dup_duplicity_set_backend (DejaDupDuplicity* self, DejaDupBackend* value) {
	DejaDupBackend* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_backend);
	self->priv->_backend = _tmp0_;
	g_object_notify ((GObject *) self, "backend");
}


gboolean deja_dup_duplicity_get_use_progress (DejaDupDuplicity* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_progress;
	return result;
}


void deja_dup_duplicity_set_use_progress (DejaDupDuplicity* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_progress = value;
	g_object_notify ((GObject *) self, "use-progress");
}


GList* deja_dup_duplicity_get_restore_files (DejaDupDuplicity* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_files;
	return result;
}


void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value) {
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp1_ = g_list_copy (value);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	self->priv->_restore_files = _tmp1_;
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp2_;
			GFile* f;
			_tmp2_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp2_;
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


DejaDupDuplicityState deja_dup_duplicity_get_state (DejaDupDuplicity* self) {
	DejaDupDuplicityState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}


void deja_dup_duplicity_set_state (DejaDupDuplicity* self, DejaDupDuplicityState value) {
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
	g_object_notify ((GObject *) self, "state");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static GObject * deja_dup_duplicity_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupDuplicity * self;
	parent_class = G_OBJECT_CLASS (deja_dup_duplicity_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_DUPLICITY (obj);
	if (deja_dup_duplicity_slash == NULL) {
		GFile* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		_tmp0_ = g_file_new_for_path ("/");
		_g_object_unref0 (deja_dup_duplicity_slash);
		deja_dup_duplicity_slash = _tmp0_;
		_tmp1_ = g_file_new_for_path ("/root");
		_g_object_unref0 (deja_dup_duplicity_slash_root);
		deja_dup_duplicity_slash_root = _tmp1_;
		_tmp2_ = g_file_new_for_path ("/home");
		_g_object_unref0 (deja_dup_duplicity_slash_home);
		deja_dup_duplicity_slash_home = _tmp2_;
		_tmp3_ = g_get_home_dir ();
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (deja_dup_duplicity_slash_home_me);
		deja_dup_duplicity_slash_home_me = _tmp4_;
	}
	return obj;
}


static DejaDupDuplicityDateInfo* deja_dup_duplicity_date_info_dup (const DejaDupDuplicityDateInfo* self) {
	DejaDupDuplicityDateInfo* dup;
	dup = g_new0 (DejaDupDuplicityDateInfo, 1);
	memcpy (dup, self, sizeof (DejaDupDuplicityDateInfo));
	return dup;
}


static void deja_dup_duplicity_date_info_free (DejaDupDuplicityDateInfo* self) {
	g_free (self);
}


static GType deja_dup_duplicity_date_info_get_type (void) {
	static volatile gsize deja_dup_duplicity_date_info_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_date_info_type_id__volatile)) {
		GType deja_dup_duplicity_date_info_type_id;
		deja_dup_duplicity_date_info_type_id = g_boxed_type_register_static ("DejaDupDuplicityDateInfo", (GBoxedCopyFunc) deja_dup_duplicity_date_info_dup, (GBoxedFreeFunc) deja_dup_duplicity_date_info_free);
		g_once_init_leave (&deja_dup_duplicity_date_info_type_id__volatile, deja_dup_duplicity_date_info_type_id);
	}
	return deja_dup_duplicity_date_info_type_id__volatile;
}


static void deja_dup_duplicity_class_init (DejaDupDuplicityClass * klass) {
	deja_dup_duplicity_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityPrivate));
	DEJA_DUP_DUPLICITY_CLASS (klass)->start = deja_dup_duplicity_real_start;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_error = deja_dup_duplicity_real_process_error;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_info = deja_dup_duplicity_real_process_info;
	DEJA_DUP_DUPLICITY_CLASS (klass)->process_warning = deja_dup_duplicity_real_process_warning;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_duplicity_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_duplicity_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_ORIGINAL_MODE, g_param_spec_enum ("original-mode", "original-mode", "original-mode", DEJA_DUP_OPERATION_TYPE_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_OPERATION_TYPE_MODE, DEJA_DUP_OPERATION_MODE_INVALID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_ERROR_ISSUED, g_param_spec_boolean ("error-issued", "error-issued", "error-issued", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_WAS_STOPPED, g_param_spec_boolean ("was-stopped", "was-stopped", "was-stopped", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_LOCAL, g_param_spec_object ("local", "local", "local", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_BACKEND, g_param_spec_object ("backend", "backend", "backend", DEJA_DUP_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_USE_PROGRESS, g_param_spec_boolean ("use-progress", "use-progress", "use-progress", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_STATE, g_param_spec_enum ("state", "state", "state", DEJA_DUP_DUPLICITY_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_BOOLEAN);
	g_signal_new ("progress", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("collection_dates", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("listed_current_files", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("question", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("secondary_desc_changed", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("is_full", DEJA_DUP_TYPE_DUPLICITY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void deja_dup_duplicity_instance_init (DejaDupDuplicity * self) {
	self->priv = DEJA_DUP_DUPLICITY_GET_PRIVATE (self);
	self->priv->_mode = DEJA_DUP_OPERATION_MODE_INVALID;
	self->priv->_error_issued = FALSE;
	self->priv->_was_stopped = FALSE;
	self->priv->_use_progress = TRUE;
	self->priv->is_full_backup = FALSE;
	self->priv->cleaned_up_once = FALSE;
	self->priv->needs_root = FALSE;
	self->priv->has_progress_total = FALSE;
	self->priv->has_checked_contents = FALSE;
	self->priv->has_non_home_contents = FALSE;
	self->priv->homes = NULL;
	self->priv->checked_collection_info = FALSE;
	self->priv->got_collection_info = FALSE;
	self->priv->collection_info = NULL;
	self->priv->checked_backup_space = FALSE;
	self->priv->deleted_files = FALSE;
	self->priv->delete_age = 0;
	self->priv->last_touched_file = NULL;
	self->priv->restarted_without_cache = FALSE;
}


static void deja_dup_duplicity_finalize (GObject* obj) {
	DejaDupDuplicity * self;
	self = DEJA_DUP_DUPLICITY (obj);
	_g_object_unref0 (self->priv->_local);
	_g_object_unref0 (self->priv->_backend);
	__g_list_free__g_object_unref0_0 (self->includes);
	__g_list_free__g_object_unref0_0 (self->excludes);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	_g_object_unref0 (self->priv->inst);
	_g_free0 (self->priv->remote);
	__g_list_free__g_free0_0 (self->priv->backend_argv);
	__g_list_free__g_free0_0 (self->priv->saved_argv);
	__g_list_free__g_free0_0 (self->priv->saved_envp);
	__g_list_free__g_object_unref0_0 (self->priv->homes);
	__g_list_free__deja_dup_duplicity_date_info_free0_0 (self->priv->collection_info);
	_g_object_unref0 (self->priv->last_touched_file);
	_g_free0 (self->priv->saved_status);
	_g_object_unref0 (self->priv->saved_status_file);
	G_OBJECT_CLASS (deja_dup_duplicity_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_get_type (void) {
	static volatile gsize deja_dup_duplicity_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicity), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_init, NULL };
		GType deja_dup_duplicity_type_id;
		deja_dup_duplicity_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicity", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_duplicity_type_id__volatile, deja_dup_duplicity_type_id);
	}
	return deja_dup_duplicity_type_id__volatile;
}


static void _vala_deja_dup_duplicity_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicity * self;
	self = DEJA_DUP_DUPLICITY (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_ORIGINAL_MODE:
		g_value_set_enum (value, deja_dup_duplicity_get_original_mode (self));
		break;
		case DEJA_DUP_DUPLICITY_MODE:
		g_value_set_enum (value, deja_dup_duplicity_get_mode (self));
		break;
		case DEJA_DUP_DUPLICITY_ERROR_ISSUED:
		g_value_set_boolean (value, deja_dup_duplicity_get_error_issued (self));
		break;
		case DEJA_DUP_DUPLICITY_WAS_STOPPED:
		g_value_set_boolean (value, deja_dup_duplicity_get_was_stopped (self));
		break;
		case DEJA_DUP_DUPLICITY_LOCAL:
		g_value_set_object (value, deja_dup_duplicity_get_local (self));
		break;
		case DEJA_DUP_DUPLICITY_BACKEND:
		g_value_set_object (value, deja_dup_duplicity_get_backend (self));
		break;
		case DEJA_DUP_DUPLICITY_USE_PROGRESS:
		g_value_set_boolean (value, deja_dup_duplicity_get_use_progress (self));
		break;
		case DEJA_DUP_DUPLICITY_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_duplicity_get_restore_files (self));
		break;
		case DEJA_DUP_DUPLICITY_STATE:
		g_value_set_enum (value, deja_dup_duplicity_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_duplicity_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicity * self;
	self = DEJA_DUP_DUPLICITY (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_ORIGINAL_MODE:
		deja_dup_duplicity_set_original_mode (self, g_value_get_enum (value));
		break;
		case DEJA_DUP_DUPLICITY_MODE:
		deja_dup_duplicity_set_mode (self, g_value_get_enum (value));
		break;
		case DEJA_DUP_DUPLICITY_ERROR_ISSUED:
		deja_dup_duplicity_set_error_issued (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_WAS_STOPPED:
		deja_dup_duplicity_set_was_stopped (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_LOCAL:
		deja_dup_duplicity_set_local (self, g_value_get_object (value));
		break;
		case DEJA_DUP_DUPLICITY_BACKEND:
		deja_dup_duplicity_set_backend (self, g_value_get_object (value));
		break;
		case DEJA_DUP_DUPLICITY_USE_PROGRESS:
		deja_dup_duplicity_set_use_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_DUPLICITY_RESTORE_FILES:
		deja_dup_duplicity_set_restore_files (self, g_value_get_pointer (value));
		break;
		case DEJA_DUP_DUPLICITY_STATE:
		deja_dup_duplicity_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



