/* monitor.c generated by valac, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>,
    © 2009 Andrew Fister <temposs@gmail.com>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libnotify/notify.h>
#include <glib/gi18n-lib.h>
#include <common.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gconf/gconf-client.h>
#include <time.h>
#include <gconf/gconf.h>


#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _Monitor {
	GObject parent_instance;
	MonitorPrivate * priv;
};

struct _MonitorClass {
	GObjectClass parent_class;
};


static GMainLoop* monitor_loop;
static GMainLoop* monitor_loop = NULL;
static guint monitor_timeout_id;
static guint monitor_timeout_id = 0U;
static GPid monitor_pid;
static GPid monitor_pid = 0;
static gboolean monitor_reactive_check;
static gboolean monitor_reactive_check = FALSE;
static gboolean monitor_testing;
static gboolean monitor_testing = FALSE;
static gboolean monitor_show_version;
static gboolean monitor_show_version = FALSE;
static NotifyNotification* monitor_note;
static NotifyNotification* monitor_note = NULL;
static gpointer monitor_parent_class = NULL;

GType monitor_get_type (void);
enum  {
	MONITOR_DUMMY_PROPERTY
};
static void monitor_prepare_next_run (void);
static void monitor_network_changed (DejaDupNetworkManager* nm, gboolean connected);
static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol);
static gboolean monitor_is_ready (char** when);
static gboolean monitor_handle_options (gint* status);
static void monitor_today (GDate* result);
static void monitor_most_recent_scheduled_date (gint period, GDate* result);
static void monitor_next_run_date (GDate* result);
static void monitor_date_to_timeval (GDate* date, GTimeVal* result);
static glong monitor_seconds_until (GDate* date);
static void monitor_close_pid (GPid child_pid, gint status);
static void _lambda0_ (NotifyNotification* n);
static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void monitor_notify_delay (const char* header, const char* reason);
static gboolean monitor_seconds_until_next_run (glong* secs);
static void monitor_prepare_tomorrow (void);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean monitor_kickoff (void);
static gboolean _monitor_kickoff_gsource_func (gpointer self);
static void monitor_prepare_run (glong wait_time);
static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static void monitor_watch_gconf (void);
static void _monitor_network_changed_deja_dup_network_manager_changed (DejaDupNetworkManager* _sender, gboolean connected, gpointer self);
static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static gboolean _lambda1_ (void);
static gboolean __lambda1__gsource_func (gpointer self);
static gint monitor_main (char** args, int args_length1);
Monitor* monitor_new (void);
Monitor* monitor_construct (GType object_type);
static void monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MONITOR_options[3] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, N_ ("Show version"), NULL}, {"testing", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &monitor_testing, NULL, NULL}, {NULL}};


static void monitor_network_changed (DejaDupNetworkManager* nm, gboolean connected) {
	g_return_if_fail (nm != NULL);
	monitor_reactive_check = TRUE;
	if (connected) {
		monitor_prepare_next_run ();
	}
	monitor_reactive_check = FALSE;
}


static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol) {
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	monitor_reactive_check = TRUE;
	monitor_prepare_next_run ();
	monitor_reactive_check = FALSE;
}


static gboolean monitor_is_ready (char** when) {
	gboolean result = FALSE;
	GError * _inner_error_;
	if (when != NULL) {
		*when = NULL;
	}
	_inner_error_ = NULL;
	{
		DejaDupBackend* _tmp0_;
		char* _tmp4_;
		gboolean _tmp3_;
		char* _tmp2_ = NULL;
		DejaDupBackend* _tmp1_;
		gboolean _tmp5_;
		_tmp0_ = deja_dup_backend_get_default (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		result = (_tmp5_ = (_tmp3_ = deja_dup_backend_is_ready (_tmp1_ = _tmp0_, &_tmp2_), *when = (_tmp4_ = _tmp2_, _g_free0 (*when), _tmp4_), _tmp3_), _g_object_unref0 (_tmp1_), _tmp5_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = TRUE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally0:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static gboolean monitor_handle_options (gint* status) {
	gboolean result = FALSE;
	*status = 0;
	if (monitor_show_version) {
		g_print ("%s %s\n", g_get_application_name (), VERSION);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void monitor_today (GDate* result) {
	GTimeVal cur_time = {0};
	GDate cur_date = {0};
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	memset (&cur_date, 0, sizeof (GDate));
	g_date_set_time_val (&cur_date, &cur_time);
	*result = cur_date;
	return;
}


static void monitor_most_recent_scheduled_date (gint period, GDate* result) {
	GDate epoch = {0};
	GDate _tmp0_ = {0};
	GDate cur_date;
	gint between;
	gint mod;
	memset (&epoch, 0, sizeof (GDate));
	g_date_set_dmy (&epoch, (GDateDay) 1, 1, (GDateYear) 1970);
	cur_date = (monitor_today (&_tmp0_), _tmp0_);
	between = g_date_days_between (&epoch, &cur_date);
	mod = between % period;
	g_date_subtract_days (&cur_date, (guint) mod);
	*result = cur_date;
	return;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void monitor_next_run_date (GDate* result) {
	GError * _inner_error_;
	GConfClient* client;
	gboolean periodic = FALSE;
	char* last_run_string;
	gint period_days = 0;
	GDate last_run = {0};
	GTimeVal last_run_tval = {0};
	GDate _tmp9_ = {0};
	GDate last_scheduled;
	_inner_error_ = NULL;
	client = _g_object_ref0 (gconf_client_get_default ());
	last_run_string = NULL;
	{
		gboolean _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gint _tmp3_;
		_tmp0_ = gconf_client_get_bool (client, DEJA_DUP_PERIODIC_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		periodic = _tmp0_;
		_tmp1_ = gconf_client_get_string (client, DEJA_DUP_LAST_RUN_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		last_run_string = (_tmp2_ = _tmp1_, _g_free0 (last_run_string), _tmp2_);
		_tmp3_ = gconf_client_get_int (client, DEJA_DUP_PERIODIC_PERIOD_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		period_days = _tmp3_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GDate _tmp4_ = {0};
			g_warning ("monitor.vala:117: %s", e->message);
			*result = (memset (&_tmp4_, 0, sizeof (GDate)), _tmp4_);
			_g_error_free0 (e);
			_g_object_unref0 (client);
			_g_free0 (last_run_string);
			return;
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (!periodic) {
		GDate _tmp5_ = {0};
		*result = (memset (&_tmp5_, 0, sizeof (GDate)), _tmp5_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	if (last_run_string == NULL) {
		GDate _tmp6_ = {0};
		*result = (monitor_today (&_tmp6_), _tmp6_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	memset (&last_run, 0, sizeof (GDate));
	g_get_current_time (&last_run_tval);
	if (!g_time_val_from_iso8601 (last_run_string, &last_run_tval)) {
		GDate _tmp7_ = {0};
		*result = (monitor_today (&_tmp7_), _tmp7_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	g_date_set_time_val (&last_run, &last_run_tval);
	if (!g_date_valid (&last_run)) {
		GDate _tmp8_ = {0};
		*result = (monitor_today (&_tmp8_), _tmp8_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	last_scheduled = (monitor_most_recent_scheduled_date (period_days, &_tmp9_), _tmp9_);
	if (g_date_compare (&last_scheduled, &last_run) <= 0) {
		g_date_add_days (&last_scheduled, (guint) period_days);
	}
	*result = last_scheduled;
	_g_object_unref0 (client);
	_g_free0 (last_run_string);
	return;
}


static void monitor_date_to_timeval (GDate* date, GTimeVal* result) {
	struct tm time = {0};
	time_t timet;
	GTimeVal tval = {0};
	g_date_to_struct_tm (date, &time);
	time.tm_hour = 0;
	time.tm_min = 0;
	time.tm_sec = 0;
	timet = mktime (&time);
	g_get_current_time (&tval);
	tval.tv_sec = (glong) timet;
	tval.tv_usec = (glong) 0;
	*result = tval;
	return;
}


static glong monitor_seconds_until (GDate* date) {
	glong result = 0L;
	GTimeVal cur_time = {0};
	GTimeVal _tmp0_ = {0};
	GTimeVal next_time;
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	next_time = (monitor_date_to_timeval (date, &_tmp0_), _tmp0_);
	if (monitor_testing) {
		result = (glong) 5;
		return result;
	} else {
		result = next_time.tv_sec - cur_time.tv_sec;
		return result;
	}
}


static void monitor_close_pid (GPid child_pid, gint status) {
	g_spawn_close_pid (child_pid);
	monitor_pid = (GPid) 0;
}


static void _lambda0_ (NotifyNotification* n) {
	NotifyNotification* _tmp0_;
	g_return_if_fail (n != NULL);
	monitor_note = (_tmp0_ = NULL, _g_object_unref0 (monitor_note), _tmp0_);
}


static void __lambda0__notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	_lambda0_ (_sender);
}


static void monitor_notify_delay (const char* header, const char* reason) {
	GError * _inner_error_;
	g_return_if_fail (header != NULL);
	g_return_if_fail (reason != NULL);
	_inner_error_ = NULL;
	if (monitor_note == NULL) {
		NotifyNotification* _tmp0_;
		notify_init (g_get_application_name ());
		monitor_note = (_tmp0_ = notify_notification_new (header, reason, "deja-dup-backup", NULL), _g_object_unref0 (monitor_note), _tmp0_);
		g_signal_connect (monitor_note, "closed", (GCallback) __lambda0__notify_notification_closed, NULL);
	} else {
		notify_notification_update (monitor_note, header, reason, "deja-dup-backup");
	}
	{
		notify_notification_show (monitor_note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("monitor.vala:202: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff (void) {
	gboolean result = FALSE;
	GError * _inner_error_;
	glong wait_time = 0L;
	gboolean _tmp0_ = FALSE;
	char* when;
	char* _tmp3_;
	gboolean _tmp2_;
	char* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	_inner_error_ = NULL;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		result = FALSE;
		return result;
	}
	if (!monitor_testing) {
		_tmp0_ = wait_time > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		monitor_prepare_next_run ();
		result = FALSE;
		return result;
	}
	if (!monitor_reactive_check) {
		monitor_prepare_tomorrow ();
	}
	when = NULL;
	if (!(_tmp2_ = monitor_is_ready (&_tmp1_), when = (_tmp3_ = _tmp1_, _g_free0 (when), _tmp3_), _tmp2_)) {
		g_debug ("monitor.vala:228: Postponing the backup.");
		if (!monitor_reactive_check) {
			monitor_notify_delay (_ ("Scheduled backup delayed"), when);
		}
		result = FALSE;
		_g_free0 (when);
		return result;
	}
	if (monitor_pid == ((GPid) 0)) {
		_tmp4_ = !deja_dup_test_bus_claimed ("operation");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		{
			char** _tmp5_;
			gint _argv_size_;
			gint argv_length1;
			char** argv;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			argv = (_tmp5_ = g_new0 (char*, 3 + 1), argv_length1 = 3, _argv_size_ = argv_length1, _tmp5_);
			argv[0] = (_tmp6_ = g_strdup ("deja-dup"), _g_free0 (argv[0]), _tmp6_);
			argv[1] = (_tmp7_ = g_strdup ("--backup"), _g_free0 (argv[1]), _tmp7_);
			argv[2] = (_tmp8_ = NULL, _g_free0 (argv[2]), _tmp8_);
			g_spawn_async (NULL, argv, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &monitor_pid, &_inner_error_);
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch3_g_error;
			}
			g_child_watch_add (monitor_pid, _monitor_close_pid_gchild_watch_func, NULL);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("monitor.vala:250: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:254: Not rerunning deja-dup, already doing so.");
	}
	result = FALSE;
	_g_free0 (when);
	return result;
}


static gboolean monitor_seconds_until_next_run (glong* secs) {
	gboolean result = FALSE;
	GDate _tmp0_ = {0};
	GDate next_date;
	next_date = (monitor_next_run_date (&_tmp0_), _tmp0_);
	if (!g_date_valid (&next_date)) {
		g_debug ("monitor.vala:263: Invalid next run date.  Not scheduling a backup.");
		result = FALSE;
		return result;
	}
	*secs = monitor_seconds_until (&next_date);
	result = TRUE;
	return result;
}


static gboolean _monitor_kickoff_gsource_func (gpointer self) {
	return monitor_kickoff ();
}


static void monitor_prepare_run (glong wait_time) {
	if (monitor_timeout_id != 0) {
		g_source_remove (monitor_timeout_id);
	}
	if (wait_time > 0) {
		g_debug ("monitor.vala:278: Waiting %ld seconds until next backup.", wait_time);
		monitor_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) wait_time, _monitor_kickoff_gsource_func, NULL, NULL);
	} else {
		g_debug ("monitor.vala:282: Late by %ld seconds.  Backing up now.", wait_time * (-1));
		monitor_kickoff ();
	}
}


static void monitor_prepare_tomorrow (void) {
	GDate _tmp0_ = {0};
	GDate tomorrow;
	glong secs;
	tomorrow = (monitor_today (&_tmp0_), _tmp0_);
	g_date_add_days (&tomorrow, (guint) 1);
	secs = monitor_seconds_until (&tomorrow);
	monitor_prepare_run (secs);
}


static void monitor_prepare_next_run (void) {
	glong wait_time = 0L;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		return;
	}
	monitor_prepare_run (wait_time);
}


static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	monitor_prepare_next_run ();
}


static void monitor_watch_gconf (void) {
	GError * _inner_error_;
	GConfClient* client;
	_inner_error_ = NULL;
	client = _g_object_ref0 (gconf_client_get_default ());
	{
		gconf_client_add_dir (client, DEJA_DUP_GCONF_DIR, GCONF_CLIENT_PRELOAD_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gconf_client_notify_add (client, DEJA_DUP_LAST_RUN_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gconf_client_notify_add (client, DEJA_DUP_PERIODIC_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gconf_client_notify_add (client, DEJA_DUP_PERIODIC_PERIOD_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("monitor.vala:315: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (client);
}


static void _monitor_network_changed_deja_dup_network_manager_changed (DejaDupNetworkManager* _sender, gboolean connected, gpointer self) {
	monitor_network_changed (_sender, connected);
}


static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	monitor_volume_added (_sender, volume);
}


static gboolean _lambda1_ (void) {
	gboolean result = FALSE;
	monitor_prepare_next_run ();
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	return _lambda1_ ();
}


static gint monitor_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_;
	GOptionContext* context;
	gint status = 0;
	DejaDupNetworkManager* _tmp1_;
	GVolumeMonitor* mon;
	GMainLoop* _tmp2_;
	_inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	g_set_application_name (_ ("Déjà Dup Monitor"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, MONITOR_options, GETTEXT_PACKAGE);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp0_;
			g_printerr ("%s\n\n%s", e->message, _tmp0_ = g_option_context_get_help (context, TRUE, NULL));
			_g_free0 (_tmp0_);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (context);
			return result;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (!monitor_handle_options (&status)) {
		result = status;
		_g_option_context_free0 (context);
		return result;
	}
	deja_dup_initialize ();
	g_signal_connect (_tmp1_ = deja_dup_network_manager_get (), "changed", (GCallback) _monitor_network_changed_deja_dup_network_manager_changed, NULL);
	_g_object_unref0 (_tmp1_);
	mon = g_volume_monitor_get ();
	g_object_ref ((GObject*) mon);
	g_signal_connect (mon, "volume-added", (GCallback) _monitor_volume_added_g_volume_monitor_volume_added, NULL);
	monitor_loop = (_tmp2_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (monitor_loop), _tmp2_);
	if (monitor_testing) {
		monitor_prepare_next_run ();
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, __lambda1__gsource_func, NULL, NULL);
	}
	monitor_watch_gconf ();
	g_main_loop_run (monitor_loop);
	result = 0;
	_g_option_context_free0 (context);
	_g_object_unref0 (mon);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


Monitor* monitor_construct (GType object_type) {
	Monitor * self;
	self = (Monitor*) g_object_new (object_type, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = MONITOR (obj);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static volatile gsize monitor_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		GType monitor_type_id;
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
		g_once_init_leave (&monitor_type_id__volatile, monitor_type_id);
	}
	return monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




