<?php

/*
 * This code is part of FusionDirectory (http://www.fusiondirectory.org)
 * and  compatible with GOsa 2.6 (http://www.gosa-project.org)
 * Copyright (C) 2011 Alejandro Escanero Blanco (aescanero@gmail.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

class filterTriplesLDAP {

    static function query($parent, $base, $scope, $filter, $attributes, $category, $objectStorage= "") {
        $result = array();
        $menu = array();
        $dn2index = array();
        $config = session::global_get('config');
        $ldap = $config->get_ldap_link(TRUE);
        $flag = ($scope == "sub") ? GL_SUBSEARCH : 0;
        $tmp = filterTriplesLDAP::get_list($parent, $base, $filter, $attributes, $category, $objectStorage, $flag | GL_SIZELIMIT);

        // Sort out menu entries, but save info
        $index = 0;
        foreach ($tmp as $entry) {
            if (in_array_ics("nisNetgroup", $entry['objectClass']) || in_array_ics("ieee802Device", $entry['objectClass']) || in_array_ics("GOhard", $entry['objectClass']) || ( in_array_ics("posixAccount", $entry['objectClass']) && (! in_array_ics("gosaUserTemplate", $entry['objectClass'])))) {
                if (isset($_SESSION['objectinfo'])) {
                    if (in_array_ics("nisNetgroup", $entry['objectClass'])) {
                        if ($entry['dn'] == $_SESSION['objectinfo']) {
                            continue;
                        }
                    }
                }
                $result[$index] = $entry;
                $dn2index[$entry['dn']] = $index;
                $index++;
            }
        }

        return $result;
    }

    static function get_list($parent, $base, $filter, $attributes, $category, $objectStorage, $flags= GL_SUBSEARCH) {
        $tmp = array();
        foreach ($objectStorage as $storage) {
            $list = filterLDAP::get_list($parent, $base, $filter, $attributes, $category, array($storage), $flags);
            foreach ($list as $entry) {
                $tmp[] = $entry;
            }
        }
        return $tmp;
    }

}

?>
