/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * bt_support.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bt_support.c,v 1.2 2004/01/16 18:38:54 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gnome.h>

#include "main.h"
#include "misc_gtk.h"
#include "bt_support.h"
#include "bittorrent_clist.h"

/***********************************/
/* start a new bittorrent download */
/***********************************/
void process_bittorrent_url(const char *url)
{
	pid_t bt_pid;

	bt_pid=get_bt_pid_by_bt_url(url);

	if(bt_pid==-1)
	{
		/* no bittorrent runs with this URL */
		/* try to create start: bt2dc_gui2 dl_dir done_dire url */
		gchar *dl_dir;

		dl_dir=gconf_client_get_string(gconf_engine,"/apps/Dc_gui2/Profile/default/dl_dir_entry_ent_cnt",NULL);
		if((dl_dir)&&(strlen(dl_dir)))
		{
			int son;
			gchar *done_dir;
			done_dir=g_strconcat(dl_dir,"/done",NULL);

			switch(son=fork())
			{
				case -1:
							gnome_app_error(GNOME_APP(main_window),_("Fork fails. Unable to start a new bittorrent client."));
							break;

				case 0:	/* the son */
							{
								chdir(dl_dir);		/* should not be necessary */
								execlp("bt2dc_gui2","bt2dc_gui2",dl_dir,done_dir,url,NULL);
							}
							_exit(1);
							break;
			}
			
			g_free(done_dir);
		}
		else
		{
			gnome_error_dialog(_("No download directory given"));
		}

		if(dl_dir)
			g_free(dl_dir);
	}
	else
	{
		resume_bittorrent_by_pid(bt_pid);
	}
}

/**********************************************************************/
/* restart a new bittorrent download using the pid of the dead client */
/**********************************************************************/
void resume_bittorrent_by_pid(pid_t bt_pid)
{
	char *bt_url;

	bt_url=get_bt_url_by_bt_pid(bt_pid);

	if(bt_url==NULL)
	{
		gnome_app_error(GNOME_APP(main_window),_("No bittorrent process has used this pid."));
	}
	else
	{
		/* a bittorrent entry exists. Does it run ? */
		if(is_a_dead_bittorrent(bt_pid))
		{
			/* try to reattach it */
			/* try to create start: bt2dc_gui2 dl_dir done_dire url bt_pid */
			gchar *dl_dir;

			dl_dir=gconf_client_get_string(gconf_engine,"/apps/Dc_gui2/Profile/default/dl_dir_entry_ent_cnt",NULL);
			if((dl_dir)&&(strlen(dl_dir)))
			{
				int son;
				char old_bt_pid[32];
				gchar *done_dir;

				sprintf(old_bt_pid,"%u",bt_pid);
				done_dir=g_strconcat(dl_dir,"/done",NULL);
	
				switch(son=fork())
				{
					case -1:
								gnome_app_error(GNOME_APP(main_window),_("Fork fails. Unable to start a new bittorrent client."));
								break;
	
					case 0:	/* the son */
								{
									chdir(dl_dir);		/* should not be necessary */
									execlp("bt2dc_gui2","bt2dc_gui2",dl_dir,done_dir,bt_url,old_bt_pid,NULL);
								}
								_exit(1);
								break;
				}
				
				g_free(done_dir);
			}
			else
			{
				gnome_error_dialog(_("No download directory given"));
			}

			if(dl_dir)
				g_free(dl_dir);
		}
		else
		{
			gnome_error_dialog(_("A bittorrent already runs with this URL"));
		}
		free(bt_url);
	}
}

