/* Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com */

package com.db4odoc.f1.nqoptimization;

import java.lang.reflect.Method;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.YapStream;
import com.db4o.inside.query.Db4oQueryExecutionListener;
import com.db4o.inside.query.NQOptimizationInfo;


public class NQExample {
	public final static String DBFILENAME="formula1.yap";
	
	public static void main(String[] args) {
		enhance();
	}
	// end main
	
	public static void enhance(){
		try {
			new com.db4o.nativequery.main.Db4oFileEnhancer().enhance(
				    "bin",              // source directory
				    "instrumented",     // target directory
				    new String[]{       // class path if needed
				      "lib/my_application.jar",
				      "lib/db4o-5.7-java1.x.jar"
				    },
				    "my.package"        // optional package prefix
				  );
		}catch (Exception ex){
			System.out.println(ex.getMessage());
		}
	}
	// end enhance
	
	public static void enhancedLoader(){
		ClassLoader loader=  
			new com.db4o.nativequery.main.Db4oEnhancingClassloader(System.class.getClassLoader());
		try {
			Class clazz=loader.loadClass("ApplicationExample");
			Method method=clazz.getMethod("run",new Class[]{});
			// invoke static method to start the app
			method.invoke(null,new Object[]{});
		} catch (Exception ex){
			System.out.println(ex.getMessage());
		}
	}
	// end enhancedLoader

	public static void nqListener() {
		ObjectContainer db = Db4o.openFile(DBFILENAME);
		((YapStream) db).getNativeQueryHandler().addListener(
				new Db4oQueryExecutionListener() {
					public void notifyQueryExecuted(NQOptimizationInfo info) {
						System.err.println(info);
					}
				});
	}
	// end nqListener
}
