/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Query.Processor
{
	/// <summary>
	/// Placeholder for a constraint, only necessary to attach children
	/// to the query graph.
	/// </summary>
	/// <remarks>
	/// Placeholder for a constraint, only necessary to attach children
	/// to the query graph.
	/// Added upon a call to Query#descend(), if there is no
	/// other place to hook up a new constraint.
	/// </remarks>
	/// <exclude></exclude>
	public class QConPath : Db4objects.Db4o.Internal.Query.Processor.QConClass
	{
		public QConPath()
		{
		}

		internal QConPath(Db4objects.Db4o.Internal.Transaction a_trans, Db4objects.Db4o.Internal.Query.Processor.QCon
			 a_parent, Db4objects.Db4o.Internal.Query.Processor.QField a_field) : base(a_trans
			, a_parent, a_field, null)
		{
			if (a_field != null)
			{
				i_yapClass = a_field.GetYapClass();
			}
		}

		public override bool CanLoadByIndex()
		{
			return false;
		}

		internal override bool Evaluate(Db4objects.Db4o.Internal.Query.Processor.QCandidate
			 a_candidate)
		{
			if (!a_candidate.FieldIsAvailable())
			{
				VisitOnNull(a_candidate.GetRoot());
			}
			return true;
		}

		internal override void EvaluateSelf()
		{
		}

		internal override bool IsNullConstraint()
		{
			return !HasChildren();
		}

		internal override Db4objects.Db4o.Internal.Query.Processor.QConClass ShareParentForClass
			(Db4objects.Db4o.Reflect.IReflectClass a_class, bool[] removeExisting)
		{
			if (i_parent == null)
			{
				return null;
			}
			if (!i_field.CanHold(a_class))
			{
				return null;
			}
			Db4objects.Db4o.Internal.Query.Processor.QConClass newConstraint = new Db4objects.Db4o.Internal.Query.Processor.QConClass
				(i_trans, i_parent, i_field, a_class);
			Morph(removeExisting, newConstraint, a_class);
			return newConstraint;
		}

		internal override Db4objects.Db4o.Internal.Query.Processor.QCon ShareParent(object
			 a_object, bool[] removeExisting)
		{
			if (i_parent == null)
			{
				return null;
			}
			object obj = i_field.Coerce(a_object);
			if (obj == Db4objects.Db4o.Foundation.No4.INSTANCE)
			{
				Db4objects.Db4o.Internal.Query.Processor.QConObject falseConstraint = new Db4objects.Db4o.Internal.Query.Processor.QConFalse
					(i_trans, i_parent, i_field);
				Morph(removeExisting, falseConstraint, ReflectClassForObject(obj));
				return falseConstraint;
			}
			Db4objects.Db4o.Internal.Query.Processor.QConObject newConstraint = new Db4objects.Db4o.Internal.Query.Processor.QConObject
				(i_trans, i_parent, i_field, obj);
			Morph(removeExisting, newConstraint, ReflectClassForObject(obj));
			return newConstraint;
		}

		private Db4objects.Db4o.Reflect.IReflectClass ReflectClassForObject(object obj)
		{
			return i_trans.Reflector().ForObject(obj);
		}

		private void Morph(bool[] removeExisting, Db4objects.Db4o.Internal.Query.Processor.QConObject
			 newConstraint, Db4objects.Db4o.Reflect.IReflectClass claxx)
		{
			bool mayMorph = true;
			if (claxx != null)
			{
				Db4objects.Db4o.Internal.ClassMetadata yc = i_trans.Stream().ProduceYapClass(claxx
					);
				if (yc != null)
				{
					System.Collections.IEnumerator i = IterateChildren();
					while (i.MoveNext())
					{
						Db4objects.Db4o.Internal.Query.Processor.QField qf = ((Db4objects.Db4o.Internal.Query.Processor.QCon
							)i.Current).GetField();
						if (!yc.HasField(i_trans.Stream(), qf.i_name))
						{
							mayMorph = false;
							break;
						}
					}
				}
			}
			if (mayMorph)
			{
				System.Collections.IEnumerator j = IterateChildren();
				while (j.MoveNext())
				{
					newConstraint.AddConstraint((Db4objects.Db4o.Internal.Query.Processor.QCon)j.Current
						);
				}
				if (HasJoins())
				{
					System.Collections.IEnumerator k = IterateJoins();
					while (k.MoveNext())
					{
						Db4objects.Db4o.Internal.Query.Processor.QConJoin qcj = (Db4objects.Db4o.Internal.Query.Processor.QConJoin
							)k.Current;
						qcj.ExchangeConstraint(this, newConstraint);
						newConstraint.AddJoin(qcj);
					}
				}
				i_parent.ExchangeConstraint(this, newConstraint);
				removeExisting[0] = true;
			}
			else
			{
				i_parent.AddConstraint(newConstraint);
			}
		}

		internal sealed override bool VisitSelfOnNull()
		{
			return false;
		}

		public override string ToString()
		{
			return base.ToString();
			return "QConPath " + base.ToString();
		}
	}
}
