/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class SystemInfoTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Item
		{
		}

		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.SystemInfoTestCase().RunSolo();
		}

		protected override void Db4oCustomTearDown()
		{
			Db4objects.Db4o.Db4oFactory.Configure().Freespace().UseRamSystem();
		}

		public virtual void TestDefaultFreespaceInfo()
		{
			AssertFreespaceInfo(FileSession().SystemInfo());
		}

		public virtual void TestIndexBasedFreespaceInfo()
		{
			Db4objects.Db4o.Db4oFactory.Configure().Freespace().UseIndexSystem();
			Reopen();
			AssertFreespaceInfo(FileSession().SystemInfo());
		}

		private void AssertFreespaceInfo(Db4objects.Db4o.Ext.ISystemInfo info)
		{
			Db4oUnit.Assert.IsNotNull(info);
			Db4objects.Db4o.Tests.Common.Assorted.SystemInfoTestCase.Item item = new Db4objects.Db4o.Tests.Common.Assorted.SystemInfoTestCase.Item
				();
			Db().Set(item);
			Db().Commit();
			Db().Delete(item);
			Db().Commit();
			Db4oUnit.Assert.IsTrue(info.FreespaceEntryCount() > 0);
			Db4oUnit.Assert.IsTrue(info.FreespaceSize() > 0);
		}

		public virtual void TestTotalSize()
		{
			if (Fixture() is Db4oUnit.Extensions.Fixtures.AbstractFileBasedDb4oFixture)
			{
				Db4oUnit.Extensions.Fixtures.AbstractFileBasedDb4oFixture fixture = (Db4oUnit.Extensions.Fixtures.AbstractFileBasedDb4oFixture
					)Fixture();
				Sharpen.IO.File f = new Sharpen.IO.File(fixture.GetAbsolutePath());
				long expectedSize = f.Length();
				long actual = Db().SystemInfo().TotalSize();
				Db4oUnit.Assert.AreEqual(expectedSize, actual);
			}
		}
	}
}
