/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using Db4oUnit;
using Db4oUnit.Tests;

namespace Db4oUnit.Extensions.Tests
{
    public class AllTests : ITestCase
    {
        private sealed class ExcludingInMemoryFixture : Fixtures.Db4oInMemory
        {
            public ExcludingInMemoryFixture(AllTests _enclosing, Fixtures.IConfigurationSource
                 source)
                : base(source)
            {
                this._enclosing = _enclosing;
            }

            public override bool Accept(System.Type clazz)
            {
                return !typeof(Fixtures.IOptOutFromTestFixture).IsAssignableFrom
                    (clazz);
            }

            private readonly AllTests _enclosing;
        }

        public static void Main(string[] args)
        {
            new TestRunner(typeof(Tests.AllTests)).Run();
        }

        public virtual void TestCascadeOnUpdate()
        {
            IDb4oFixture fixture = new Tests.AllTests.ExcludingInMemoryFixture
                        (this, new Fixtures.IndependentConfigurationSource());
            TestSuite suite = new Db4oTestSuiteBuilder(fixture, new System.Type[] { typeof(Tests.CascadeOnUpdate) }).Build();
            FrameworkTestCase.RunTestAndExpect(suite, 0);
        }
	// end TestCascadeOnUpdate

        public virtual void TestSingleTestWithDifferentFixtures()
        {
            Fixtures.IConfigurationSource configSource = new Fixtures.IndependentConfigurationSource
                ();
            AssertSimpleDb4o(new Fixtures.Db4oInMemory(configSource));
            AssertSimpleDb4o(new Fixtures.Db4oSolo(configSource));
        }

        public virtual void TestMultipleTestsSingleFixture()
        {
            Tests.MultipleDb4oTestCase.ResetConfigureCalls();
            FrameworkTestCase.RunTestAndExpect(new Db4oTestSuiteBuilder
                (new Fixtures.Db4oInMemory(new Fixtures.IndependentConfigurationSource
                ()), typeof(Tests.MultipleDb4oTestCase)).Build(), 2, false);
            Assert.AreEqual(2, Tests.MultipleDb4oTestCase.ConfigureCalls
                ());
        }

        public virtual void TestSelectiveFixture()
        {
            IDb4oFixture fixture = new Tests.AllTests.ExcludingInMemoryFixture
                (this, new Fixtures.IndependentConfigurationSource());
            TestSuite suite = new Db4oTestSuiteBuilder(fixture, 
                new System.Type[] { typeof(Tests.AcceptedTestCase), typeof(Tests.NotAcceptedTestCase)
                 }).Build();
            Assert.AreEqual(1, suite.GetTests().Length);
            FrameworkTestCase.RunTestAndExpect(suite, 0);
        }
        
        private void AssertSimpleDb4o(IDb4oFixture fixture)
        {
            TestSuite suite = new Db4oTestSuiteBuilder(fixture,
                typeof(Tests.SimpleDb4oTestCase)).Build();
            Tests.SimpleDb4oTestCase subject = GetTestSubject(suite);
            subject.ExpectedFixture(fixture);
            FrameworkTestCase.RunTestAndExpect(suite, 0);
            Assert.IsTrue(subject.EverythingCalled());
        }

        private Tests.SimpleDb4oTestCase GetTestSubject(TestSuite
             suite)
        {
            return ((Tests.SimpleDb4oTestCase)((TestMethod)suite
                .GetTests()[0]).GetSubject());
        }
    }
}
