/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class UnionPathIterator
extends Expression
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    transient NodeSetDTM m_cachedNodes = null;
    protected transient int m_next = 0;
    transient int m_lastFetched = -1;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected DTMIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public UnionPathIterator(Compiler compiler, int n) throws TransformerException {
        n = OpMap.getFirstChildPos(n);
        this.loadLocationPaths(compiler, n, 0);
    }

    public void addIterator(LocPathIterator locPathIterator) {
        if (this.m_iterators == null) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = locPathIterator;
        } else {
            DTMIterator[] dTMIteratorArray = this.m_iterators;
            int n = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[n + 1];
            System.arraycopy(dTMIteratorArray, 0, this.m_iterators, 0, n);
            this.m_iterators[n] = locPathIterator;
        }
    }

    public void allowDetachToRelease(boolean bl) {
        this.m_allowDetach = bl;
    }

    public DTMIterator asIterator(XPathContext xPathContext, int n) throws TransformerException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.m_clones.getInstance();
        unionPathIterator.setRoot(n, xPathContext);
        return unionPathIterator;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        int n = this.m_iterators.length;
        unionPathIterator.m_iterators = new LocPathIterator[n];
        int n2 = 0;
        while (n2 < n) {
            unionPathIterator.m_iterators[n2] = (LocPathIterator)this.m_iterators[n2].clone();
            ++n2;
        }
        return unionPathIterator;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.clone();
        unionPathIterator.reset();
        return unionPathIterator;
    }

    protected DTMIterator createDTMIterator(Compiler compiler, int n) throws TransformerException {
        DTMIterator dTMIterator = WalkerFactory.newDTMIterator(compiler, n, compiler.getLocationPathDepth() <= 0);
        return dTMIterator;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            if (this.m_iterators != null) {
                int n = this.m_iterators.length;
                int n2 = 0;
                while (n2 < n) {
                    this.m_iterators[n2].detach();
                    ++n2;
                }
            }
            this.m_clones.freeInstance(this);
        }
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.m_clones.getInstance();
        int n = xPathContext.getCurrentNode();
        unionPathIterator.setRoot(n, xPathContext);
        return new XNodeSet(unionPathIterator);
    }

    public void fixupVariables(Vector vector, int n) {
        int n2 = 0;
        while (n2 < this.m_iterators.length) {
            DTMIterator dTMIterator = this.m_iterators[n2];
            if (dTMIterator instanceof Expression) {
                ((Expression)((Object)dTMIterator)).fixupVariables(vector, n);
            }
            ++n2;
        }
    }

    public int getAxis() {
        return -1;
    }

    public int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public DTM getDTM(int n) {
        return this.m_execContext.getDTM(n);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLastPos(XPathContext xPathContext) {
        int n;
        UnionPathIterator unionPathIterator;
        int n2 = this.m_next;
        int n3 = this.m_cachedNodes != null ? this.m_cachedNodes.getCurrentPos() : -1;
        try {
            unionPathIterator = n2 == 0 && this.m_currentContextNode != -1 ? (UnionPathIterator)this.cloneWithReset() : (UnionPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        n2 = unionPathIterator.getCurrentPos();
        while ((n = unionPathIterator.nextNode()) != -1) {
            ++n2;
        }
        if (n3 != -1) {
            this.m_cachedNodes.setCurrentPos(n3);
        }
        return n2;
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = this.m_cachedNodes == null || !this.m_foundLast ? this.getLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    public int getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public int item(int n) {
        return this.m_cachedNodes.item(n);
    }

    protected void loadLocationPaths(Compiler compiler, int n, int n2) throws TransformerException {
        int n3 = compiler.getOpMap()[n];
        if (n3 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
            this.m_iterators[n2] = this.createDTMIterator(compiler, n);
        } else {
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n), n2 + 1);
                    WalkingIterator walkingIterator = new WalkingIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        walkingIterator.setIsTopLevel(true);
                    }
                    walkingIterator.m_firstWalker = new FilterExprWalker(walkingIterator);
                    walkingIterator.m_firstWalker.init(compiler, n, n3);
                    this.m_iterators[n2] = walkingIterator;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[n2];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int n = this.m_cachedNodes.elementAt(this.m_next);
            ++this.m_next;
            this.m_currentContextNode = n;
            return n;
        }
        if (this.m_foundLast) {
            return -1;
        }
        int n = -1;
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            int n3 = -1;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = this.m_iterators[n4].getCurrentNode();
                if (n5 != -1) {
                    if (n == -1) {
                        n3 = n4;
                        n = n5;
                    } else if (n5 == n) {
                        this.m_iterators[n4].nextNode();
                    } else {
                        DTM dTM = this.getDTM(n5);
                        if (dTM.isNodeAfter(n5, n)) {
                            n3 = n4;
                            n = n5;
                        }
                    }
                }
                ++n4;
            }
            if (n != -1) {
                this.m_iterators[n3].nextNode();
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(n);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = n;
        return n;
    }

    public int previousNode() {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = -1;
        int n = this.m_iterators.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_iterators[n2].reset();
            this.m_iterators[n2].nextNode();
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (var1_1 != -1) ** GOTO lbl-1000
            while ((var2_2 = this.nextNode()) != -1) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if ((var2_3 = this.nextNode()) != -1) continue;
            }
        }
    }

    public void setCurrentPos(int n) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = n;
        this.m_cachedNodes.setCurrentPos(n);
    }

    public void setEnvironment(Object object) {
    }

    public void setItem(int n, int n2) {
        this.m_cachedNodes.setElementAt(n, n2);
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public final void setRoot(int n) {
        this.m_context = n;
    }

    public void setRoot(int n, Object object) {
        this.m_execContext = (XPathContext)object;
        this.m_currentContextNode = n;
        this.m_context = n;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
        this.m_foundLast = false;
        try {
            if (this.m_iterators != null) {
                int n2 = this.m_iterators.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.m_iterators[n3] = ((LocPathIterator)this.m_iterators[n3]).asIterator(this.m_execContext, n);
                    this.m_iterators[n3].setRoot(n, object);
                    this.m_iterators[n3].nextNode();
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public void setShouldCacheNodes(boolean bl) {
        this.m_cachedNodes = bl ? new NodeSetDTM(this.getDTMManager()) : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

