/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.While;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class SaxonWhile
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "test") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("test");
            return;
        }
        this.test = this.makeExpression(string);
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.test = this.typeCheck("test", this.test);
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        While while_ = new While(this.test);
        this.compileChildren(executable, while_);
        return while_;
    }
}

