#!/usr/bin/env perl

# Test that darcs fails appropriately when the target repo inventory file is not writable.
# See issue612

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;
use File::Slurp 'append_file';
use File::Temp 'tempdir';

# test_with_format('--old-fashioned-inventory'); known not to work. 
test_with_format('--darcs-2');
test_with_format('--hashed');

sub test_with_format {
    my $format = shift;

    my $work_dir = tempdir( CLEANUP => 1 );
    chdir $work_dir;

    ok(mkpath('r1'), "r1 created (starting tests for format: $format)");
    ok(chdir('r1'), "chdir r1");
    darcs "init $format";
    touch 't.t';
    darcs 'add t.t';
    darcs "record -am 'initial add'";
    CORE::chmod 0555, glob('_darcs/inventories/*') if -r '_darcs/inventories';
    CORE::chmod 0555, glob('_darcs/inventories')   if -r '_darcs/inventories';
    CORE::chmod 0555, glob('_darcs/inventory')     if -r '_darcs/inventory';
    ok(chdir('../'), "chdir ../");
    darcs "get r1 r2";
    ok(chdir('r2'), "chdir r2");
    append_file('t.t',"new");
    darcs "record -am 'new patch'";
    my $out = darcs "push -a ../r1";
    like($out, qr/failed/, "expect failure when pushing to a repo with unwritable inventory (format: $format)");

    chdir '../../'; # move out the way for auto-tmpdir cleanup. 
}


