#!/usr/bin/env bash

# Issue 864

# darcs mv file1 file2
# edit file2
# darcs replace fails if new token includes some existing edits

# Regression in darcs2 - it works in darcs1 1.0.9

set -ev

rm -rf temp
mkdir temp
cd temp
darcs init
cat <<EOF > file1
aa
bb
cc
aa
bb
cc
EOF
darcs add file1
darcs record -a -m "0" --author X

ed file1 <<EOF
1s/aa/aaaa/
w
q
EOF

darcs replace aa aaaa file1

darcs mv file1 file2

ed file2 <<EOF
2s/bb/beebee/
w
q
EOF

! darcs replace bb beebee file2 2>&1 |
tee /dev/tty |
grep -q 'Skipping file'
exit=$?

cd .. && rm -rf temp

exit $exit