/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_project_node_hpp_
#define dammit_project_node_hpp_ 1

#include "environment_node.hpp"

#include "intrusive_ptr_list.hpp"

#include <dammit/build_project.hpp>

namespace dammit {

class project_node :
	public node
{
public:
	virtual ~project_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	typedef build_project::type type;

	typedef intrusive_ptr_list<node> node_list;
	typedef node_list::iterator node_iterator;
	typedef node_list::const_iterator node_const_iterator;

	node_list nodes;

	std::string project_name;
	type project_type;
};

}

#endif
