/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_print_visitor_hpp_
#define dammit_print_visitor_hpp_ 1

#include "visitor.hpp"

#include <ostream>

namespace dammit {

class print_visitor :
	public visitor
{
public:
	print_visitor(std::ostream &out) : out(out), depth(0) { }

	virtual ~print_visitor(void) throw() { }

	virtual intrusive_ptr<node> visit(parallel_node &);

	virtual intrusive_ptr<node> visit(project_node &);
	virtual intrusive_ptr<node> visit(configuration_node &);

	virtual intrusive_ptr<node> visit(input_node &);
	virtual intrusive_ptr<node> visit(temporary_node &);
	virtual intrusive_ptr<node> visit(output_node &);

	virtual intrusive_ptr<node> visit(tool_node &);
	virtual intrusive_ptr<node> visit(environment_node &);

	virtual intrusive_ptr<node> visit(action_node &);

private:
	std::ostream &out;
	unsigned int depth;
};

}

#endif
