/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_depth_first_adapter_hpp_
#define dammit_depth_first_adapter_hpp_ 1

#include "visitor.hpp"

namespace dammit {

class depth_first_adapter :
	public visitor
{
public:
	virtual ~depth_first_adapter(void) throw() { }

	virtual intrusive_ptr<node> visit(parallel_node &);
	virtual intrusive_ptr<node> visit(project_node &);
	virtual intrusive_ptr<node> visit(configuration_node &);
	virtual intrusive_ptr<node> visit(input_node &);
	virtual intrusive_ptr<node> visit(temporary_node &);
	virtual intrusive_ptr<node> visit(output_node &);
	virtual intrusive_ptr<node> visit(tool_node &);
	virtual intrusive_ptr<node> visit(environment_node &);
	virtual intrusive_ptr<node> visit(action_node &);

protected:
	virtual void enter(parallel_node &);
	virtual intrusive_ptr<node> leave(parallel_node &);
	virtual void enter(project_node &);
	virtual intrusive_ptr<node> leave(project_node &);
	virtual void enter(configuration_node &);
	virtual intrusive_ptr<node> leave(configuration_node &);
	virtual void enter(input_node &);
	virtual intrusive_ptr<node> leave(input_node &);
	virtual void enter(temporary_node &);
	virtual intrusive_ptr<node> leave(temporary_node &);
	virtual void enter(output_node &);
	virtual intrusive_ptr<node> leave(output_node &);
	virtual void enter(tool_node &);
	virtual intrusive_ptr<node> leave(tool_node &);
	virtual void enter(environment_node &);
	virtual intrusive_ptr<node> leave(environment_node &);
	virtual void enter(action_node &);
	virtual intrusive_ptr<node> leave(action_node &);
};

}

#endif
