/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_action_node_hpp_
#define dammit_action_node_hpp_ 1

#include "input_node.hpp"

#include "intrusive_ptr_list.hpp"
#include "intrusive_ptr.hpp"

#include "command.hpp"

namespace dammit {

class action_node :
	public node
{
public:
	virtual ~action_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	//intrusive_ptr<tool_node> tool;

	typedef intrusive_ptr_list<node> input_list;
	typedef input_list::iterator input_iterator;
	typedef input_list::const_iterator input_const_iterator;
	
	input_list inputs;

	command cmd;
};

}

#endif
