SSLCLIENT(1)                 DACS Commands Manual                 SSLCLIENT(1)



NNAAMMEE
       sslclient - an SSL client

SSYYNNOOPPSSIISS
       ssssllcclliieenntt [ddaaccssooppttiioonnss[1]] [--ccaaff | ----ccaa__cceerrtt__ffiillee _f_i_l_e_n_a_m_e]
                 [--ccaadd | ----ccaa__cceerrtt__ddiirr _d_i_r_n_a_m_e]
                 [--ccccff | ----cceerrtt__cchhaaiinn__ffiillee _f_i_l_e_n_a_m_e]
                 [--CC | ----cciipphheerrss _c_i_p_h_e_r_s_t_r_i_n_g]
                 [[--ddvvpp] | [----ddeeffaauulltt__vveerriiffyy__ppaatthhss] _c_i_p_h_e_r_s_t_r_i_n_g]
                 [--hh | ----hheellpp] [--kkff | ----kkeeyy__ffiillee _f_i_l_e_n_a_m_e]
                 [--kkfftt | ----kkeeyy__ffiillee__ttyyppee pem | asn1]
                 [--pp | --sspp | [----sseerrvveerr__ppoorrtt] _p_o_r_t_n_u_m]
                 [--rr | ----rraannddoomm _f_i_l_e_n_a_m_e]
                 [[--ssmm | ----sseerrvveerr__mmaattcchh _r_e_g_e_x ]...]
                 [--vvdd | ----vveerriiffyy__ddeepptthh _d_e_p_t_h]
                 [--vvtt | ----vveerriiffyy__ttyyppee none | peer] [----] _s_e_r_v_e_r [:_p_o_r_t ]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite. It can be used with the usual
       DDAACCSS command line options (ddaaccssooppttiioonnss[1]), _p_r_o_v_i_d_e_d _t_h_e_y _a_l_l _a_p_p_e_a_r
       _b_e_f_o_r_e _t_h_e _p_r_o_g_r_a_m_-_s_p_e_c_i_f_i_c _f_l_a_g_s (note that the --uunn flag can be used
       to suppress configuration file processing).  ssssllcclliieenntt is also used by
       the hhttttpp((11))[2] command and by requests generated internally by DDAACCSS
       components.

       The ssssllcclliieenntt utility acts as an SSL client. After establishing a
       bidirectional SSL connection with an SSL server, it forwards its
       standard input to the SSL server and writes data produced by the SSL
       server to ssssllcclliieenntt''ss standard output.

       ssssllcclliieenntt connects to _s_e_r_v_e_r (a domain name or IP address). If a port
       number suffix is given, it is used; otherwise if a port number was
       specified as a separate command line argument (----sseerrvveerr__ppoorrtt), that is
       used, and failing that, the ddeeffaauulltt SSSSLL ppoorrtt ffoorr hhttttppss ((444433))[3] is
       used.

       The program reads from its standard input and the server asynchronously
       (using non-blocking I/O). Note that the server side might need to see
       end-of-file on its input before its output is returned to ssssllcclliieenntt.

       This program's underlying SSL functionality is provided by OOppeennSSSSLL[4].

OOPPTTIIOONNSS
       ssssllcclliieenntt recognizes these options:

       --ccaaff _f_i_l_e_n_a_m_e
       ----ccaa__cceerrtt__ffiillee _f_i_l_e_n_a_m_e
           This identifies _f_i_l_e_n_a_m_e as a file of CA certificates in PEM
           format. This is the _C_A_f_i_l_e argument to the OOppeennSSSSLL[4]
           SSSSLL__CCTTXX__llooaadd__vveerriiffyy__llooccaattiioonnss(())[5] function. It is similar to
           mmoodd__ssssll''ss[6] SSSSLLCCAACCeerrttiiffiiccaatteeFFiillee[7] directive, except that it is
           used to verify the server's SSL certificate.

       --ccaadd _d_i_r_n_a_m_e
       ----ccaa__cceerrtt__ddiirr _d_i_r_n_a_m_e
           This identifies _d_i_r_n_a_m_e as a directory containing CA certificates
           in PEM format, one certificate per file. This is the _C_A_p_a_t_h
           argument to the OOppeennSSSSLL[4] SSSSLL__CCTTXX__llooaadd__vveerriiffyy__llooccaattiioonnss(())[5]
           function. It is similar to mmoodd__ssssll''ss[6] SSSSLLCCAACCeerrttiiffiiccaatteePPaatthh[8]
           directive, except that it is used to verify the server's
           certificate.

       --ccccff _f_i_l_e_n_a_m_e
       ----cceerrtt__cchhaaiinn__ffiillee _f_i_l_e_n_a_m_e
           This causes the client certificate chain to be loaded from
           _f_i_l_e_n_a_m_e, a file containing certificates in PEM format. This is the
           _f_i_l_e argument to the OOppeennSSSSLL[4]
           SSSSLL__CCTTXX__uussee__cceerrttiiffiiccaattee__cchhaaiinn__ffiillee(())[9] function. It is similar to
           mmoodd__ssssll''ss[6] SSSSLLCCAACCeerrttiiffiiccaatteeCChhaaiinnFFiillee[10] directive, except that
           it is used for the client's chain.

               TTiipp
               If you want the client certificate to be sent you must also
               specify the --kkff flag.

       --CC _c_i_p_h_e_r_s_t_r_i_n_g
       ----cciipphheerrss _c_i_p_h_e_r_s_t_r_i_n_g
           This sets the list of ciphers to be used to _c_i_p_h_e_r_s_t_r_i_n_g. This is
           the _s_t_r argument to the OOppeennSSSSLL[4] SSSSLL__CCTTXX__sseett__cciipphheerr__lliisstt(())[11]
           function. It is similar to mmoodd__ssssll''ss[6] SSSSLLCCiipphheerrSSuuiittee[12]
           directive.

       --ddvvpp
       ----ddeeffaauulltt__vveerriiffyy__ppaatthhss
           This flag tells ssssllcclliieenntt to use default locations for finding CA
           certificates. It results in a call to the OOppeennSSSSLL[4]
           SSSSLL__CCTTXX__sseett__ddeeffaauulltt__vveerriiffyy__ppaatthhss(()) function.

       --hh
       ----hheellpp
           Print a usage synopsis.

       --kkff _f_i_l_e_n_a_m_e
       ----kkeeyy__ffiillee _f_i_l_e_n_a_m_e
           This sets ssssllcclliieenntt''ss private key to the first private key found in
           _f_i_l_e_n_a_m_e. This is the _f_i_l_e argument to the OOppeennSSSSLL[4]
           SSSSLL__CCTTXX__uusseePPrriivvaatteeKKeeyy__ffiillee(()) function. The default private key file
           type is PEM. If the key has been encrypted, the program will prompt
           for the passphrase.

       --kkfftt _t_y_p_e
       ----kkeeyy__ffiillee__ttyyppee _t_y_p_e
           The private key file type is set to _t_y_p_e, which must be either pem
           or asn1 (case insensitive). The default private key file type is
           PEM.

       --pp _p_o_r_t_n_u_m
       --sspp _p_o_r_t_n_u_m
       ----sseerrvveerr__ppoorrtt _p_o_r_t_n_u_m
           Unless specified with the _s_e_r_v_e_r argument, _p_o_r_t_n_u_m is the port
           number to use, overriding the default port (443).

       --rr _f_i_l_e_n_a_m_e
       ----rraannddoomm _f_i_l_e_n_a_m_e
           Seed material for the PRNG is read from _f_i_l_e_n_a_m_e. This is the
           _f_i_l_e_n_a_m_e argument to the OOppeennSSSSLL[4] RRAANNDD__llooaadd__ffiillee(()) function.

       --ssmm _r_e_g_e_x
       ----sseerrvveerr__mmaattcchh _r_e_g_e_x
           This argument, which may be repeated, specifies a constraint on the
           server's identity by matching an attribute value in the server's
           certificate against _r_e_g_e_x. These tests are made immediately after
           an SSL connection is established. Each _r_e_g_e_x is an IEEE Std 1003.2
           ("POSIX.2") regular expression with extended expressions and case
           insensitivity (REG_EXTENDED | REG_ICASE). See bbeellooww[13] for the
           matching algorithm.

       --vvdd _d_e_p_t_h
       ----vveerriiffyy__ddeepptthh _d_e_p_t_h
           This sets the maximum depth for certificate chain verification to
           _d_e_p_t_h. This is the _d_e_p_t_h argument to the OOppeennSSSSLL[4]
           SSSSLL__CCTTXX__sseett__vveerriiffyy__ddeepptthh(()) function.

       --vvtt _t_y_p_e
       ----vveerriiffyy__ttyyppee _t_y_p_e
           This sets the verification mode to _t_y_p_e, which must be either none
           or peer (case insensitive). This is the _m_o_d_e argument to the
           OOppeennSSSSLL[4] SSSSLL__CCTTXX__sseett__vveerriiffyy(()) function.

       ----
           This argument explicitly marks the end of the flags.

       The DDAACCSS --vv (or ----vveerrbboossee) flag causes the program to show some of the
       server's SSL certificate, print feedback about regular expression
       matching, and so on. If ssssllcclliieenntt is not doing what you expect, try
       using this flag.

   SSeerrvveerr IIddeennttiittyy VVeerriiffiiccaattiioonn
       If the server presents a valid SSL (X.509) certificate, a set of checks
       is applied to it to help ensure that ssssllcclliieenntt is communicating with
       the intended entity. Verification is successful and checking is
       terminated as soon as any test is successful. If no test succeeds, the
       program terminates immediately.

           TTiipp
           You can use a command like the following one to display an X.509
           certificate to stdout in text form:

               % openssl x509 -noout -text < cert.crt

           Here, cert.crt is the certificate to display.

       The server certificate's subjectAltName extension fields have the
       format field-name:field-value. For each such field, tests are made in
       the following sequence:

        1. the entire field is matched against each of the regular expressions
           given on the command line.

        2. if the previous test failed and field-name is "DNS" (exact match),
           it is compared case insensitively to the server's name (as given on
           the command line).

        3. if the previous test failed and if the field-name is "IP Address"
           (exact match), it is compared to the server's name (exact match),
           which is assumed to be an IP address (as given on the command
           line).


       If the above procedure is unsuccessful and the server certificate's
       commonName attribute value is available, it is matched against each of
       the regular expressions given on the command line.

EEXXAAMMPPLLEESS
       The following command line attempts to connect to port 443 at
       example.com and prints to stdout the server's response to a request for
       the home page:

           % perl -e 'printf "GET / HTTP/1.0\n\n";' | sslclient example.com:443


DDIIAAGGNNOOSSTTIICCSS
       When used with DDAACCSS logging configured, messages are directed to a log
       file, otherwise error messages and verbose output are written to
       stderr. The program exits 0 if everything was fine, 1 if an error
       occurred.

NNOOTTEESS
       A wrapper mode of operation might be useful.

       It would also be useful to have a mode where it listens for an SSL
       connection for input (rather than its standard input) and then relays
       data over that connection to a specified server, possibly but not
       necessarily via SSL. This mode might run on a firewall host to forward
       an approved incoming SSL connection (presumably authenticated by a
       client certificate, and possibly by a DDAACCSS ruleset) to a service
       running on an interior host, for instance.

SSEEEE AALLSSOO
       hhttttpp((11))[2], ooppeennssssll((11))[4], ss__cclliieenntt((11))[14], ssttuunnnneell((11))[15],
       ccuurrll((11))[16], ssssllwwrraapp((11))[17], and others, and rreeggeexx((33))[18].

       A variety of reference material on SSL/TLS is available. Perhaps best
       is Network Security with OpenSSL by John Viega, Matt Messier, and
       Pravir Chandra, O'Reilly & Associates, Inc., 2002. Also useful are
       SSSSLL//TTLLSS SSttrroonngg EEnnccrryyppttiioonn:: AAnn IInnttrroodduuccttiioonn[19], NNeettssccaappee SSSSLL 33..00
       SSppeecciiffiiccaattiioonn[20], and RRFFCC 22224466[21].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[22])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[23] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. http(1)
           http://dacs.dss.ca/man/http.1.html

        3. default SSL port for https (443)
           http://www.iana.org/assignments/port-numbers

        4. OpenSSL
           http://www.openssl.org

        5. SSSSLL__CCTTXX__llooaadd__vveerriiffyy__llooccaattiioonnss(())
           http://www.openssl.org/docs/ssl/SSL_CTX_load_verify_locations.html

        6. mod_ssl's
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html

        7. SSLCACertificateFile
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatefile

        8. SSLCACertificatePath
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatepath

        9. SSSSLL__CCTTXX__uussee__cceerrttiiffiiccaattee__cchhaaiinn__ffiillee(())
           http://www.openssl.org/docs/ssl/SSL_CTX_use_certificate.html

       10. SSLCACertificateChainFile
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatechainfile

       11. SSSSLL__CCTTXX__sseett__cciipphheerr__lliisstt(())
           http://www.openssl.org/docs/ssl/SSL_CTX_set_cipher_list.html

       12. SSLCipherSuite
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslciphersuite

       13. below
           http://dacs.dss.ca/man/#verificaton

       14. s_client(1)
           http://www.openssl.org/docs/apps/s_client.html

       15. stunnel(1)
           http://www.stunnel.org

       16. curl(1)
           http://directory.fsf.org/project/curl

       17. sslwrap(1)
           http://www.rickk.com/sslwrap

       18. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       19. SSL/TLS Strong Encryption: An Introduction
           http://httpd.apache.org/docs-2.2/ssl/ssl_intro.html

       20. Netscape SSL 3.0 Specification
           http://web.archive.org/web/20070717014933rn_1/wp.netscape.com/eng/ssl3//

       21. RFC 2246
           http://www.rfc-editor.org/rfc/rfc2246.txt

       22. www.dss.ca
           http://www.dss.ca

       23. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      SSLCLIENT(1)
